/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferByte;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ImageHandler;
import org.jpedal.images.ImageOps;
import org.jpedal.images.ImageTransformer;
import org.jpedal.images.ImageTransformerDouble;
import org.jpedal.images.SamplingFactory;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.IDObjectDecoder;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.MaskObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.ImageCommands;
import org.jpedal.render.RenderUtils;
import org.jpedal.utils.LogWriter;

public class ImageDecoder
extends BaseDecoder {
    PdfImageData pdfImages = null;
    private boolean getSamplingOnly = false;
    boolean isMask = true;
    String imagesInFile = null;
    boolean isPrinting;
    ImageHandler customImageHandler;
    boolean useHiResImageForDisplay;
    boolean isType3Font;
    boolean renderDirectly;
    int formLevel;
    PdfPageData pageData;
    ObjectStore objectStoreStreamRef;
    boolean clippedImagesExtracted = true;
    private boolean extractRawCMYK = false;
    boolean finalImagesExtracted = true;
    private boolean doNotRotate = false;
    boolean createScaledVersion = true;
    boolean renderImages = false;
    boolean rawImagesExtracted = true;
    private int optionsApplied = 0;
    private String currentImage = "";
    private String formName;

    public ImageDecoder(ImageHandler imageHandler, ObjectStore objectStore, boolean bl, PdfImageData pdfImageData, int n, PdfPageData pdfPageData, String string, String string2) {
        this.formName = string2;
        this.customImageHandler = imageHandler;
        this.objectStoreStreamRef = objectStore;
        this.renderDirectly = bl;
        this.pdfImages = pdfImageData;
        this.formLevel = n;
        this.pageData = pdfPageData;
        this.imagesInFile = string;
    }

    private GenericColorSpace setupXObjectColorspace(PdfObject pdfObject, int n, int n2, int n3, byte[] byArray) {
        int[] nArray;
        PdfObject pdfObject2;
        byte[] byArray2;
        PdfObject pdfObject3 = pdfObject.getDictionary(2087749783);
        GenericColorSpace genericColorSpace = new DeviceRGBColorSpace();
        if (pdfObject3 != null) {
            genericColorSpace = ColorspaceFactory.getColorSpaceInstance(this.currentPdfFile, pdfObject3, this.cache.XObjectColorspaces);
            genericColorSpace.setPrinting(this.isPrinting);
            this.cache.put(1, genericColorSpace.getID(), "x");
            if (n == 1 && genericColorSpace.getID() == 1785221209 && pdfObject.getDictionary(489767739) == null) {
                byArray2 = genericColorSpace.getIndexedMap();
                if (genericColorSpace.getIndexedMap() == null || byArray2.length == 6 && byArray2[0] == 0 && byArray2[1] == 0 && byArray2[2] == 0) {
                    genericColorSpace = new DeviceGrayColorSpace();
                }
            }
        }
        byArray2 = genericColorSpace.getIndexedMap();
        if (n == 8 && byArray2 != null && genericColorSpace.getID() == 1785221209 && n2 * n3 == byArray.length && (pdfObject2 = pdfObject.getDictionary(489767739)) != null && (nArray = pdfObject2.getIntArray(489767739)) != null && nArray.length == 2 && nArray[0] == 255 && nArray[0] == nArray[1] && genericColorSpace.getIndexedMap() != null && genericColorSpace.getIndexedMap().length == 768) {
            boolean bl = true;
            for (int i = 0; i < 768; ++i) {
                if (byArray2[i] == 0) continue;
                bl = false;
                i = 768;
            }
            if (bl) {
                genericColorSpace = new DeviceGrayColorSpace();
            }
        }
        if ((pdfObject2 = pdfObject.getDictionary(1888135062)) != null) {
            genericColorSpace.setDecodeParms(pdfObject2);
        }
        genericColorSpace.setIntent(pdfObject.getName(1144346498));
        return genericColorSpace;
    }

    public BufferedImage processImageXObject(PdfObject pdfObject, String string, byte[] byArray, boolean bl, String string2) throws PdfException {
        Object object;
        BufferedImage bufferedImage = null;
        string = this.fileName + '-' + string;
        int n = 1;
        int n2 = pdfObject.getInt(959726687);
        int n3 = pdfObject.getInt(959926393);
        int n4 = pdfObject.getInt(-1344207655);
        if (n4 != -1) {
            n = n4;
        }
        boolean bl2 = this.isMask = pdfObject.getBoolean(1516403337);
        GenericColorSpace genericColorSpace = this.setupXObjectColorspace(pdfObject, n, n2, n3, byArray);
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("Processing XObject: " + string + ' ' + pdfObject.getObjectRefAsString() + " width=" + n2 + " Height=" + n3 + " Depth=" + n + " colorspace=" + genericColorSpace);
        }
        if (this.customImageHandler != null) {
            bufferedImage = this.customImageHandler.processImageData(this.gs, pdfObject);
        }
        PdfObject pdfObject2 = pdfObject.getDictionary(489767774);
        byte[] byArray2 = genericColorSpace.getIndexedMap();
        if (pdfObject2 != null && byArray2 != null && byArray2.length == 3 && genericColorSpace.getID() != 1247168582) {
            pdfObject = pdfObject2;
            pdfObject.setFloatArray(859785322, new float[]{1.0f, 0.0f});
            byArray = this.currentPdfFile.readStream(pdfObject, true, true, false, false, false, null);
            n = 1;
            n2 = pdfObject.getInt(959726687);
            n3 = pdfObject.getInt(959926393);
            n4 = pdfObject.getInt(-1344207655);
            if (n4 != -1) {
                n = n4;
            }
            genericColorSpace = this.setupXObjectColorspace(pdfObject, n, n2, n3, byArray);
        }
        if (pdfObject2 != null && pdfObject.getInt(959726687) == 1 && pdfObject.getInt(959926393) == 1 && pdfObject.getInt(-1344207655) == 8) {
            int n5 = -1;
            pdfObject = pdfObject2;
            object = pdfObject.getFloatArray(859785322);
            if (object != null) {
                n5 = (byte)(object[0] * 255.0f);
            }
            byte[] byArray3 = new byte[]{0, 0, 0, -1, -1, -1};
            byte[] byArray4 = this.currentPdfFile.readStream(pdfObject, true, true, false, false, false, null);
            n2 = pdfObject.getInt(959726687);
            n3 = pdfObject.getInt(959926393);
            int n6 = n2 * n3 * 4;
            byArray = new byte[n6];
            ColorSpaceConvertor.flatten1bpc(n2, byArray4, byArray3, true, n6, n5, byArray);
            bufferedImage = new BufferedImage(n2, n3, 2);
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n2, n3, n2 * 4, 4, new int[]{0, 1, 2, 3}, null);
            bufferedImage.setData(writableRaster);
        } else if (this.customImageHandler == null || bufferedImage == null && !this.customImageHandler.alwaysIgnoreGenericHandler()) {
            bufferedImage = this.processImage(genericColorSpace, byArray, string, n2, n3, n, bl2, pdfObject, bl, 2);
        }
        if (ImageCommands.trackImages && bufferedImage != null && string2 != null) {
            float f = this.gs.CTM[0][0];
            if (f == 0.0f) {
                f = this.gs.CTM[0][1];
            }
            if (f < 0.0f) {
                f = -f;
            }
            f = (int)((float)n2 / f * 100.0f);
            object = new StringBuilder(string2);
            object.append(" w=");
            object.append(String.valueOf(n2));
            object.append(" h=");
            object.append(String.valueOf(n3));
            object.append(' ');
            object.append(String.valueOf((int)f));
            object.append(' ');
            object.append(ColorSpaces.IDtoString(genericColorSpace.getID()));
            object.append(" (");
            object.append(String.valueOf(bufferedImage.getWidth()));
            object.append(' ');
            object.append(String.valueOf(bufferedImage.getHeight()));
            object.append(" type=");
            object.append(String.valueOf(bufferedImage.getType()));
            object.append(')');
            if (this.imagesInFile.length() == 0) {
                this.imagesInFile = object.toString();
            } else {
                object.append('\n');
                object.append(this.imagesInFile);
                this.imagesInFile = object.toString();
            }
        }
        return bufferedImage;
    }

    public int processDOImage(String string, int n, PdfObject pdfObject) throws PdfException {
        block7: {
            if (this.formLevel > 0) {
                string = this.formName + '_' + this.formLevel + '_' + string;
            }
            String string2 = null;
            if (ImageCommands.rejectSuperimposedImages) {
                string2 = (int)this.gs.CTM[2][0] + "-" + (int)this.gs.CTM[2][1] + '-' + (int)this.gs.CTM[0][0] + '-' + (int)this.gs.CTM[1][1] + '-' + (int)this.gs.CTM[0][1] + '-' + (int)this.gs.CTM[1][0];
            }
            try {
                this.processXImage(string, string, string2, pdfObject);
            }
            catch (Error error) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Error: " + error.getMessage());
                }
                this.imagesProcessedFully = false;
                this.errorTracker.addPageFailureMessage("Error " + error + " in DO");
            }
            catch (Exception exception) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception " + exception);
                }
                this.imagesProcessedFully = false;
                this.errorTracker.addPageFailureMessage("Error " + exception + " in DO");
                if (!exception.getMessage().contains("JPeg 2000")) break block7;
                throw new RuntimeException("XX JPeg 2000 Images needs the VM parameter -Dorg.jpedal.jai=true switch turned on");
            }
        }
        return n;
    }

    private void processXImage(String string, String string2, String string3, PdfObject pdfObject) throws PdfException {
        boolean bl;
        if (ImageCommands.trackImages) {
            string2 = string2 + " Image";
            if (this.imagesInFile == null) {
                this.imagesInFile = "";
            }
        }
        boolean bl2 = bl = this.current.getType() == 4 || this.current.getType() == 5 || this.current.getType() == 6;
        if (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted) {
            byte[] byArray = this.currentPdfFile.readStream(pdfObject, true, true, false, false, false, pdfObject.getCacheName(this.currentPdfFile.getObjectReader()));
            if (byArray == null) {
                this.imagesProcessedFully = false;
            }
            if (byArray != null) {
                boolean bl3 = false;
                BufferedImage bufferedImage = null;
                this.currentImage = this.fileName + '-' + string;
                if (!bl3) {
                    bufferedImage = this.processImageXObject(pdfObject, string, byArray, true, string2);
                }
                if (bufferedImage != null && bufferedImage.getWidth() == 1 && bufferedImage.getHeight() == 1 && this.isType3Font) {
                    bufferedImage.flush();
                    bufferedImage = null;
                }
                if (bufferedImage != null || bl3) {
                    float[][] fArray;
                    block23: {
                        fArray = null;
                        if (!bl && (this.renderDirectly || this.useHiResImageForDisplay)) {
                            int n;
                            this.gs.x = this.gs.CTM[2][0];
                            this.gs.y = this.gs.CTM[2][1];
                            if (this.finalImagesExtracted || this.rawImagesExtracted) {
                                int n2;
                                n = (int)Math.abs(this.gs.CTM[0][0]);
                                if (n == 0) {
                                    n = (int)Math.abs(this.gs.CTM[0][1]);
                                }
                                if ((n2 = (int)Math.abs(this.gs.CTM[1][1])) == 0) {
                                    n2 = (int)Math.abs(this.gs.CTM[1][0]);
                                }
                                this.pdfImages.setImageInfo(this.currentImage, this.pageNum, this.gs.x, this.gs.x, n, n2);
                            }
                            if (this.renderDirectly) {
                                this.current.drawImage(this.pageNum, bufferedImage, this.gs, bl3, string, this.optionsApplied, -1);
                            } else if (bufferedImage != null || bl3) {
                                n = this.current.drawImage(this.pageNum, bufferedImage, this.gs, bl3, string, this.optionsApplied, -1);
                                if (ImageCommands.rejectSuperimposedImages && string3 != null) {
                                    this.cache.setImposedKey(string3, n);
                                }
                            }
                        } else if (this.clippedImagesExtracted || bl) {
                            this.generateTransformedImage(bufferedImage, string);
                        } else {
                            try {
                                this.generateTransformedImageSingle(bufferedImage, string);
                            }
                            catch (Exception exception) {
                                if (!LogWriter.isOutput()) break block23;
                                LogWriter.writeLog("Exception " + exception + " on transforming image in file");
                            }
                        }
                    }
                    if (bufferedImage != null) {
                        bufferedImage.flush();
                    }
                    if (fArray != null) {
                        this.gs.CTM = fArray;
                    }
                }
            }
        }
    }

    ImageDecoder() {
    }

    public ImageDecoder(ImageHandler imageHandler, boolean bl, ObjectStore objectStore, boolean bl2, PdfImageData pdfImageData, int n, PdfPageData pdfPageData) {
        this.customImageHandler = imageHandler;
        this.useHiResImageForDisplay = bl;
        this.objectStoreStreamRef = objectStore;
        this.renderDirectly = bl2;
        this.pdfImages = pdfImageData;
        this.formLevel = n;
        this.pageData = pdfPageData;
    }

    public void setSamplingOnly(boolean bl) {
        this.getSamplingOnly = bl;
    }

    public String getImagesInFile() {
        return this.imagesInFile;
    }

    public void setParameters(boolean bl, boolean bl2, int n, int n2, boolean bl3, boolean bl4, boolean bl5) {
        this.isPageContent = bl;
        this.renderPage = bl2;
        this.renderMode = n;
        this.extractionMode = n2;
        this.isPrinting = bl3;
        this.isType3Font = bl4;
        this.useHiResImageForDisplay = bl5;
        this.renderImages = bl2 && (n & 2) == 2;
        this.finalImagesExtracted = (n2 & 4) == 4;
        this.extractRawCMYK = (n2 & 0x80) == 128;
        this.clippedImagesExtracted = (n2 & 0x20) == 32;
        this.rawImagesExtracted = (n2 & 2) == 2;
        this.createScaledVersion = this.finalImagesExtracted || this.renderImages;
    }

    public void setImageName(String string) {
        this.currentImage = string;
    }

    public int getOptionsApplied() {
        return this.optionsApplied;
    }

    public int processIDImage(int n, int n2, byte[] byArray, int n3) throws Exception {
        int n4;
        XObject xObject = new XObject(6420);
        IDObjectDecoder iDObjectDecoder = new IDObjectDecoder(this.currentPdfFile.getObjectReader());
        iDObjectDecoder.setEndPt(n - 2);
        iDObjectDecoder.readDictionaryAsObject(xObject, n2, byArray);
        BufferedImage bufferedImage = null;
        int n5 = n4 = n + 1;
        int n6 = byArray.length;
        while ((n6 - n5 <= 3 || byArray[n5 + 1] != 69 || byArray[n5 + 2] != 73 || byArray[n5 + 3] != 10) && (n6 - n5 <= 3 || byArray[n5] != 32 && byArray[n5] != 10 && byArray[n5] != 13 && (byArray[n5 + 3] != 32 || byArray[n5 + 4] != 81) || byArray[n5 + 1] != 69 || byArray[n5 + 2] != 73 || byArray[n5 + 3] != 32 && byArray[n5 + 3] != 10 && byArray[n5 + 3] != 13) && ++n5 != n6) {
        }
        if (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted) {
            Object object;
            Object object2;
            Object object3;
            String string = this.fileName + "-IN-" + n3;
            int n7 = n5;
            if (n5 < byArray.length && byArray[n7] != 32 && byArray[n7] != 10 && byArray[n7] != 13) {
                ++n7;
            }
            if (byArray[n4] == 10) {
                ++n4;
            }
            byte[] byArray2 = new byte[n7 - n4];
            System.arraycopy(byArray, n4, byArray2, 0, n7 - n4);
            xObject.setStream(byArray2);
            PdfObject pdfObject = ((PdfObject)xObject).getDictionary(2087749783);
            if (pdfObject != null && (object3 = pdfObject.getGeneralStringValue()) != null && (object2 = this.cache.get(2, object3)) != null) {
                pdfObject = (PdfObject)object2;
            }
            if (this.customImageHandler != null) {
                bufferedImage = this.customImageHandler.processImageData(this.gs, xObject);
            }
            object3 = ((PdfObject)xObject).getMixedArray(1011108731);
            boolean bl = false;
            if (object3 != null && ((PdfArrayIterator)object3).hasMoreTokens()) {
                int n8 = ((PdfArrayIterator)object3).getNextValueAsConstant(false);
                bl = n8 != 1399277700 && n8 != 1180911742;
            }
            int n9 = ((PdfObject)xObject).getInt(959726687);
            int n10 = ((PdfObject)xObject).getInt(959926393);
            int n11 = ((PdfObject)xObject).getInt(-1344207655);
            boolean bl2 = ((PdfObject)xObject).getBoolean(1516403337);
            if (bl) {
                object = new PdfFilteredReader();
                byArray2 = ((PdfFilteredReader)object).decodeFilters(ObjectUtils.setupDecodeParms(xObject, this.currentPdfFile.getObjectReader()), byArray2, (PdfArrayIterator)object3, n9, n10, null);
            }
            object = new DeviceRGBColorSpace();
            if (pdfObject != null) {
                object = ColorspaceFactory.getColorSpaceInstance(this.currentPdfFile, pdfObject);
                ((GenericColorSpace)object).setPrinting(this.isPrinting);
                this.cache.put(1, ((GenericColorSpace)object).getID(), "x");
            }
            if (byArray2 != null) {
                if (this.customImageHandler == null || bufferedImage == null && !this.customImageHandler.alwaysIgnoreGenericHandler()) {
                    bufferedImage = this.processImage((GenericColorSpace)object, byArray2, string, n9, n10, n11, bl2, xObject, false, 0);
                    this.currentImage = string;
                }
                if (this.isPrinting && bufferedImage != null && this.gs != null && bufferedImage.getHeight() == 1 && this.gs.CTM[1][1] < 1.0f) {
                    bufferedImage = null;
                }
                if (bufferedImage != null) {
                    if (this.current.getType() == 4 || this.current.getType() == 5 || this.current.getType() == 6) {
                        this.generateTransformedImage(bufferedImage, string);
                    } else if (this.renderDirectly || this.useHiResImageForDisplay) {
                        this.gs.x = this.gs.CTM[2][0];
                        this.gs.y = this.gs.CTM[2][1];
                        this.current.drawImage(this.pageNum, bufferedImage, this.gs, false, string, this.optionsApplied, -1);
                    } else if (this.clippedImagesExtracted) {
                        this.generateTransformedImage(bufferedImage, string);
                    } else {
                        this.generateTransformedImageSingle(bufferedImage, string);
                    }
                    if (bufferedImage != null) {
                        bufferedImage.flush();
                    }
                }
            }
        }
        n = n5 + 3;
        return n;
    }

    public void generateTransformedImage(BufferedImage bufferedImage, String string) {
        float f = 0.0f;
        float f2 = 0.0f;
        if (bufferedImage != null) {
            String string2;
            ImageTransformerDouble imageTransformerDouble = new ImageTransformerDouble(this.gs, bufferedImage, this.createScaledVersion);
            imageTransformerDouble.doubleScaleTransformShear(this.current);
            bufferedImage = imageTransformerDouble.getImage();
            if (this.current.getType() != 4 && this.current.getType() != 5 && this.current.getType() != 6) {
                string2 = this.objectStoreStreamRef.getImageType(this.currentImage);
                if (string2 == null) {
                    string2 = "tif";
                }
                if (this.objectStoreStreamRef.saveStoredImage("CLIP_" + this.currentImage, ImageCommands.addBackgroundToMask(bufferedImage, this.isMask), false, false, string2)) {
                    this.errorTracker.addPageFailureMessage("Problem saving " + bufferedImage);
                }
            }
            if (this.current.getType() == 4 || this.current.getType() == 5 || this.current.getType() == 6) {
                if (bufferedImage != null) {
                    this.gs.x = f;
                    this.gs.y = f2;
                    this.current.drawImage(this.pageNum, bufferedImage, this.gs, false, string, this.optionsApplied, -1);
                }
            } else {
                if (this.finalImagesExtracted || this.renderImages) {
                    imageTransformerDouble.doubleScaleTransformScale();
                }
                imageTransformerDouble.completeImage();
                f = imageTransformerDouble.getImageX();
                f2 = imageTransformerDouble.getImageY();
                float f3 = imageTransformerDouble.getImageW();
                float f4 = imageTransformerDouble.getImageH();
                bufferedImage = imageTransformerDouble.getImage();
                if (bufferedImage != null) {
                    if (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted) {
                        this.pdfImages.setImageInfo(this.currentImage, this.pageNum, f, f2, f3, f4);
                    }
                    if ((this.renderImages || !this.isPageContent) && bufferedImage != null) {
                        this.gs.x = f;
                        this.gs.y = f2;
                        this.current.drawImage(this.pageNum, bufferedImage, this.gs, false, string, this.optionsApplied, -1);
                    }
                    if (!this.renderDirectly && this.isPageContent && this.finalImagesExtracted && ImageCommands.isExtractionAllowed(this.currentPdfFile)) {
                        string2 = this.objectStoreStreamRef.getImageType(this.currentImage);
                        this.objectStoreStreamRef.saveStoredImage(this.currentImage, ImageCommands.addBackgroundToMask(bufferedImage, this.isMask), false, false, string2);
                    }
                }
            }
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("NO image written");
        }
    }

    public void generateTransformedImageSingle(BufferedImage bufferedImage, String string) {
        if (bufferedImage != null) {
            boolean bl;
            Area area = this.gs.getClippingShape();
            ImageTransformer imageTransformer = new ImageTransformer(this.gs, bufferedImage, true);
            float f = imageTransformer.getImageX();
            float f2 = imageTransformer.getImageY();
            float f3 = imageTransformer.getImageW();
            float f4 = imageTransformer.getImageH();
            bufferedImage = imageTransformer.getImage();
            if (bufferedImage != null && this.customImageHandler != null && area != null && area.getBounds().getWidth() > 1.0 && area.getBounds().getHeight() > 1.0 && !this.customImageHandler.imageHasBeenScaled() && !(bl = area.contains(f, f2, f3, f4))) {
                imageTransformer.clipImage(area);
                f = imageTransformer.getImageX();
                f2 = imageTransformer.getImageY();
                f3 = imageTransformer.getImageW();
                f4 = imageTransformer.getImageH();
            }
            if ((bufferedImage = imageTransformer.getImage()) != null) {
                if (this.finalImagesExtracted || this.rawImagesExtracted) {
                    this.pdfImages.setImageInfo(this.currentImage, this.pageNum, f, f2, f3, f4);
                }
                if ((this.renderImages || !this.isPageContent) && bufferedImage != null) {
                    this.gs.x = f;
                    this.gs.y = f2;
                    this.current.drawImage(this.pageNum, bufferedImage, this.gs, false, string, this.optionsApplied, -1);
                }
                if (this.isPageContent && this.finalImagesExtracted && ImageCommands.isExtractionAllowed(this.currentPdfFile)) {
                    String string2 = this.objectStoreStreamRef.getImageType(this.currentImage);
                    this.objectStoreStreamRef.saveStoredImage(this.currentImage, ImageCommands.addBackgroundToMask(bufferedImage, this.isMask), false, false, string2);
                }
            }
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("NO image written");
        }
    }

    BufferedImage processImage(GenericColorSpace genericColorSpace, byte[] byArray, String string, int n, int n2, int n3, boolean bl, PdfObject pdfObject, boolean bl2, int n4) throws PdfException {
        PdfObject pdfObject2;
        int n5;
        int n6;
        int n7;
        boolean bl3;
        PdfObject pdfObject3;
        PdfObject pdfObject4;
        PdfObject pdfObject5;
        byte[] byArray2;
        byte[] byArray3;
        int n8;
        int n9;
        int n10;
        int n11;
        String string2;
        BufferedImage bufferedImage;
        boolean bl4;
        boolean bl5;
        int n12;
        boolean bl6;
        Object object;
        float[] fArray;
        int n13;
        block191: {
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            this.cache.put(1, genericColorSpace.getID(), "x");
            n13 = n3;
            int n22 = 1;
            fArray = pdfObject.getFloatArray(859785322);
            if (LogWriter.debug && fArray != null) {
                object = "";
                for (float f : fArray) {
                    object = (String)object + ' ' + f;
                }
            }
            object = pdfObject.getMixedArray(1011108731);
            bl6 = false;
            n12 = 0;
            if (object != null && ((PdfArrayIterator)object).hasMoreTokens()) {
                while (((PdfArrayIterator)object).hasMoreTokens()) {
                    int n23 = ((PdfArrayIterator)object).getNextValueAsConstant(true);
                    bl6 = n23 == 1180911742;
                    n12 = n23 == 1399277700 ? 1 : 0;
                }
            } else {
                object = null;
            }
            bl5 = false;
            bl4 = false;
            bufferedImage = null;
            string2 = "jpg";
            n11 = genericColorSpace.getID();
            n10 = genericColorSpace.getColorSpace().getNumComponents();
            n9 = 0;
            n8 = 0;
            byArray3 = new byte[4];
            if (bl) {
                ImageCommands.getMaskColor(byArray3, this.gs);
            }
            byArray2 = genericColorSpace.getIndexedMap();
            if (this.renderPage && this.streamType != 1 && !this.current.avoidDownSamplingImage()) {
                if (this.isPrinting && SamplingFactory.isPrintDownsampleEnabled && n < 4000) {
                    n9 = this.pageData.getCropBoxWidth(this.pageNum) * 4;
                    n8 = this.pageData.getCropBoxHeight(this.pageNum) * 4;
                } else if (SamplingFactory.downsampleLevel == SamplingFactory.high || this.getSamplingOnly) {
                    float[][] fArray2 = new float[3][3];
                    for (int i = 0; i < 3; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            fArray2[i][j] = this.gs.CTM[i][j] < 0.0f ? -this.gs.CTM[i][j] : this.gs.CTM[i][j];
                        }
                    }
                    n9 = fArray2[0][0] == 0.0f || fArray2[0][0] < fArray2[0][1] ? (int)fArray2[0][1] : (int)fArray2[0][0];
                    n8 = fArray2[1][1] == 0.0f || fArray2[1][1] < fArray2[1][0] ? (int)fArray2[1][0] : (int)fArray2[1][1];
                    if (!this.getSamplingOnly && (n < 500 || n2 < 600 && (n < 1000 || n12))) {
                        n9 = 0;
                        n8 = 0;
                    }
                } else if (SamplingFactory.downsampleLevel == SamplingFactory.medium) {
                    n9 = this.pageData.getCropBoxWidth(this.pageNum);
                    n8 = this.pageData.getCropBoxHeight(this.pageNum);
                }
            }
            if (this.current.avoidDownSamplingImage() || n < 4000 && n2 < 4000 && (this.current.getType() == 4 || this.current.getType() == 5 || this.current.getType() == 6)) {
                n9 = -1;
                n8 = -1;
            }
            if ((bl6 || n12) && this.multiplyer > 1.0f) {
                n9 = (int)((float)n9 * this.multiplyer);
                n8 = (int)((float)n8 * this.multiplyer);
            }
            pdfObject5 = pdfObject.getDictionary(1888135062);
            pdfObject4 = pdfObject.getDictionary(489767739);
            pdfObject3 = pdfObject.getDictionary(489767774);
            if (n3 == 1 && (pdfObject3 != null || pdfObject.getObjectType() != 489767739) && genericColorSpace.getID() == 1568372915 && n2 < 300) {
                n9 = 0;
                n8 = 0;
            }
            if ((pdfObject4 != null || pdfObject3 != null) && LogWriter.isOutput()) {
                LogWriter.writeLog("newMask= " + pdfObject4 + " newSMask=" + pdfObject3);
            }
            bl3 = false;
            if (fArray != null) {
                bl3 = true;
                n21 = fArray.length;
                for (n20 = 0; n20 < n21; n20 += 2) {
                    if (fArray[n20] == 1.0f && fArray[n20 + 1] == 0.0f) continue;
                    bl3 = false;
                    n20 = n21;
                }
            }
            if (!(!this.renderPage || pdfObject4 != null || genericColorSpace.getID() == 1247168582 || !bl3 && fArray != null && fArray.length != 0 || n3 != 1 && n3 != 8 || n9 <= 0 || n8 <= 0 || !SamplingFactory.isPrintDownsampleEnabled && this.isPrinting)) {
                int n24;
                n19 = n;
                n18 = n2;
                if (this.multiplyer <= 1.0f && !this.isPrinting) {
                    n21 = 1000;
                    if (genericColorSpace.getID() == 1568372915) {
                        n21 = 4000;
                    }
                    if (n9 > n21) {
                        n9 = n21;
                    }
                    if (n8 > n21) {
                        n8 = n21;
                    }
                }
                n21 = n8 << 2;
                n20 = n9 << 2;
                while (n19 > n20 && n18 > n21) {
                    n22 <<= 1;
                    n19 >>= 1;
                    n18 >>= 1;
                }
                n17 = n / n9;
                if (n17 < 1) {
                    n17 = 1;
                }
                if ((n24 = n2 / n8) < 1) {
                    n24 = 1;
                }
                if ((n22 = n17) > n24) {
                    n22 = n24;
                }
            }
            if (this.getSamplingOnly) {
                byte[] byArray4;
                float f = (float)n / (float)n9;
                float f2 = (float)n2 / (float)n8;
                this.samplingUsed = f < f2 ? f : f2;
                n17 = 0;
                if (pdfObject3 != null && (byArray4 = this.currentPdfFile.readStream(pdfObject3, true, true, false, false, false, pdfObject3.getCacheName(this.currentPdfFile.getObjectReader()))) != null) {
                    if (pdfObject5 == null) {
                        pdfObject5 = pdfObject3.getDictionary(1888135062);
                    }
                    n7 = pdfObject3.getInt(959726687);
                    n16 = pdfObject3.getInt(959926393);
                    n15 = n7 / 2 > n && n16 / 2 > n2 ? 1 : 0;
                    int n25 = n14 = n15 != 0 && pdfObject5 != null && pdfObject5.getInt(1010783618) != -1 && pdfObject5.getInt(1970893723) != 15 ? 1 : 0;
                    if (n14 == 0) {
                        n17 = 1;
                    }
                }
                if (n17 == 0) {
                    return null;
                }
            }
            if (n22 > 1 && this.multiplyer > 1.0f) {
                n22 = (int)((float)n22 / this.multiplyer);
            }
            if (n22 > 1) {
                int n26;
                int n27;
                int n28;
                int n29;
                int n30;
                int n31;
                int n32;
                bl4 = true;
                n19 = n / n22;
                n18 = n2 / n22;
                boolean bl7 = false;
                if (bl && n > 2000 && n2 > 2000 && n3 == 1 && genericColorSpace.getID() == 1785221209 && this.gs.CTM[0][0] > 0.0f && this.gs.CTM[1][1] > 0.0f) {
                    bl7 = true;
                }
                if (n3 == 1 && (genericColorSpace.getID() != 1785221209 || byArray2 == null)) {
                    if (this.formLevel < 2 && (bl7 || !bl && bl2 && genericColorSpace.getID() == 1568372915)) {
                        int n33 = byArray.length;
                        byte[] byArray5 = new byte[n33];
                        System.arraycopy(byArray, 0, byArray5, 0, n33);
                        boolean bl8 = !bl7 && !this.doNotRotate && (this.renderDirectly || this.useHiResImageForDisplay) && RenderUtils.isInverted(this.gs.CTM);
                        int n34 = n7 = !bl7 && !this.doNotRotate && (this.renderDirectly || this.useHiResImageForDisplay) && RenderUtils.isRotated(this.gs.CTM) ? 1 : 0;
                        if (this.renderDirectly) {
                            bl8 = false;
                            n7 = 0;
                        }
                        if (n7 != 0) {
                            byArray5 = ImageOps.rotateImage(byArray5, n, n2, n3, 1, byArray2);
                            n16 = n2;
                            n2 = n;
                            n = n16;
                            n16 = n9;
                            n9 = n8;
                            n8 = n16;
                        }
                        if (bl8) {
                            byArray5 = ImageOps.invertImage(byArray5, n, n2, n3, 1, byArray2);
                        }
                        if (bl3) {
                            for (n16 = 0; n16 < n33; ++n16) {
                                byArray5[n16] = (byte)(byArray5[n16] ^ 0xFF);
                            }
                        }
                        if (!(genericColorSpace.getID() == 1785221209 && n3 == 1 && byArray3 != null || (n >= 4000 || n2 >= 4000) && genericColorSpace.getID() != 1568372915 || pdfObject instanceof MaskObject)) {
                            String string3 = this.pageNum + String.valueOf(this.imageCount);
                            if (bl7) {
                                this.current.getObjectStore().saveRawImageData(string3, byArray5, n, n2, n9, n8, byArray3, genericColorSpace.getID());
                            } else {
                                this.current.getObjectStore().saveRawImageData(string3, byArray5, n, n2, n9, n8, null, genericColorSpace.getID());
                            }
                        }
                        if (n7 != 0) {
                            int n35 = n2;
                            n2 = n;
                            n = n35;
                            n35 = n9;
                            n9 = n8;
                            n8 = n35;
                        }
                    }
                    if (byArray2 != null) {
                        byArray2 = genericColorSpace.convertIndexToRGB(byArray2);
                    }
                    int n36 = n19 * n18;
                    if (bl) {
                        n36 *= 4;
                        byArray3[3] = -1;
                    } else if (byArray2 != null) {
                        n36 *= 3;
                    }
                    byte[] byArray6 = new byte[n36];
                    int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
                    n7 = n + 7 >> 3;
                    for (n14 = 0; n14 < n18; ++n14) {
                        for (n32 = 0; n32 < n19; ++n32) {
                            int n37;
                            n6 = 0;
                            n5 = 0;
                            int n38 = n22;
                            n31 = n22;
                            n30 = n - n32;
                            n29 = n2 - n14;
                            if (n38 > n30) {
                                n38 = n30;
                            }
                            if (n31 > n29) {
                                n31 = n29;
                            }
                            for (n37 = 0; n37 < n31; ++n37) {
                                for (n28 = 0; n28 < n38; ++n28) {
                                    n27 = (n37 + n14 * n22) * n7 + (n32 * n22 + n28 >> 3);
                                    n15 = n27 < byArray.length ? byArray[n27] : 0;
                                    if (bl && !bl3) {
                                        n15 = (byte)(n15 ^ 0xFF);
                                    }
                                    if ((n16 = n15 & nArray[7 - (n32 * n22 + n28 & 7)]) != 0) {
                                        ++n6;
                                    }
                                    ++n5;
                                }
                            }
                            n37 = n32 + n19 * n14;
                            if (n5 > 0) {
                                if (bl) {
                                    for (n28 = 0; n28 < 4; ++n28) {
                                        byArray6[n37 * 4 + n28] = bl3 ? (byte)(255 - (byArray3[n28] & 0xFF) * n6 / n5) : (byte)((byArray3[n28] & 0xFF) * n6 / n5);
                                    }
                                    continue;
                                }
                                if (byArray2 == null || genericColorSpace.getID() == -2073385820) {
                                    // empty if block
                                }
                                if (byArray2 != null && n3 == 1) {
                                    for (n26 = 0; n26 < 3; ++n26) {
                                        if (byArray2[0] == -1 && byArray2[1] == -1 && byArray2[2] == -1) {
                                            n28 = (byArray2[n26] & 0xFF) + (byArray2[n26 + 3] & 0xFF);
                                            byArray6[n37 * 3 + n26] = (byte)(255 - n28 * n6 / n5);
                                            continue;
                                        }
                                        float f = n6 / n5;
                                        byArray6[n37 * 3 + n26] = (double)f > 0.5 ? byArray2[n26 + 3] : byArray2[n26];
                                    }
                                    continue;
                                }
                                if (byArray2 != null) {
                                    for (n28 = 0; n28 < 3; ++n28) {
                                        byArray6[n37 * 3 + n28] = (byte)((byArray2[n28] & 0xFF) * n6 / n5);
                                    }
                                    continue;
                                }
                                byArray6[n37] = (byte)(255 * n6 / n5);
                                continue;
                            }
                            if (bl) {
                                for (n28 = 0; n28 < 3; ++n28) {
                                    byArray6[n37 * 4 + n28] = 0;
                                }
                                continue;
                            }
                            if (byArray2 != null) {
                                for (n28 = 0; n28 < 3; ++n28) {
                                    byArray6[n37 * 3 + n28] = 0;
                                }
                                continue;
                            }
                            byArray6[n37] = -1;
                        }
                    }
                    byArray = byArray6;
                    if (byArray2 != null) {
                        n10 = 3;
                    }
                    n2 = n18;
                    n = n19;
                    genericColorSpace.setIndex(null, 0);
                    if (genericColorSpace.getID() == -2073385820) {
                        genericColorSpace = new DeviceRGBColorSpace();
                        if (n3 == 1 && byArray2 == null) {
                            n10 = 1;
                            n14 = byArray.length;
                            for (n32 = 0; n32 < n14; ++n32) {
                                byArray[n32] = (byte)(byArray[n32] ^ 0xFF);
                            }
                        }
                    }
                    n3 = 8;
                } else {
                    if (n3 == 8 && (object == null || !bl6 && !n12)) {
                        boolean bl9 = genericColorSpace.getIndexedMap() != null && (genericColorSpace.getID() == 1785221209 || genericColorSpace.getID() == 1008872003 || genericColorSpace.getID() == 1498837125 || genericColorSpace.getID() == 1247168582);
                        n17 = byArray.length;
                        int n39 = 0;
                        n7 = 0;
                        n16 = 0;
                        n15 = 0;
                        n14 = 0;
                        n32 = 0;
                        n6 = 0;
                        n5 = 1;
                        try {
                            byte[] byArray7;
                            if (bl9) {
                                n32 = 1;
                                n10 = 3;
                                n5 = 3;
                                byArray2 = genericColorSpace.convertIndexToRGB(byArray2);
                                genericColorSpace.setIndex(null, 0);
                            } else {
                                n32 = genericColorSpace.getColorComponentCount();
                            }
                            if (n * n2 == n17 || genericColorSpace.getID() == 1568372915) {
                                n32 = 1;
                            }
                            if (bl9) {
                                byArray7 = new byte[n19 * n18 * n5];
                                n6 = n;
                            } else {
                                byArray7 = new byte[n19 * n18 * n32];
                                n6 = n * n32;
                            }
                            for (n7 = 0; n7 < n18; ++n7) {
                                for (n39 = 0; n39 < n19; ++n39) {
                                    n31 = n22;
                                    n30 = n22;
                                    n29 = n - n39;
                                    n27 = n2 - n7;
                                    if (n31 > n29) {
                                        n31 = n29;
                                    }
                                    if (n30 > n27) {
                                        n30 = n27;
                                    }
                                    for (n14 = 0; n14 < n32; ++n14) {
                                        int n40;
                                        int n41;
                                        n28 = 0;
                                        n26 = 0;
                                        int[] nArray = new int[n5];
                                        for (n15 = 0; n15 < n30; ++n15) {
                                            for (n16 = 0; n16 < n31; ++n16) {
                                                int n42 = (n15 + n7 * n22) * n6 + (n39 * n22 * n32 + n16 * n32 + n14);
                                                if (n42 >= n17) continue;
                                                if (!bl9) {
                                                    n28 += byArray[n42] & 0xFF;
                                                } else {
                                                    for (n41 = 0; n41 < n5; ++n41) {
                                                        nArray[n41] = nArray[n41] + (byArray2[(byArray[n42] & 0xFF) * n5 + n41] & 0xFF);
                                                    }
                                                }
                                                ++n26;
                                            }
                                        }
                                        if (bl9) {
                                            n40 = n14 + n39 * n5 + n19 * n7 * n5;
                                            for (n41 = 0; n41 < n5; ++n41) {
                                                byArray7[n40 + n41] = (byte)(nArray[n41] / n26);
                                            }
                                            continue;
                                        }
                                        if (n26 <= 0) continue;
                                        n40 = n14 + n39 * n32 + n19 * n7 * n32;
                                        byArray7[n40] = (byte)(n28 / n26);
                                    }
                                }
                            }
                            byArray = byArray7;
                            n2 = n18;
                            n = n19;
                        }
                        catch (Exception exception) {
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("Exception: " + exception.getMessage());
                            }
                            break block191;
                        }
                    }
                    if (bl6 || n12 || byArray2 == null) {
                        // empty if block
                    }
                }
            }
        }
        if (fArray != null && fArray.length != 0 && (object == null || !n12 && !bl6) && byArray2 == null) {
            ImageCommands.applyDecodeArray(byArray, n3, fArray, n11, pdfObject);
        }
        if (bl) {
            float f = (float)n2 / (float)n;
            if (this.isPrinting && f < 0.1f && n > 4000 && n2 > 1 || f < 0.001f && n > 4000 && n2 > 1 || n == 1 && n2 == 1) {
                float f3;
                float f4 = this.gs.CTM[2][0];
                float f5 = this.gs.CTM[2][1];
                float f6 = this.gs.CTM[1][1];
                if (f6 == 0.0f) {
                    f6 = this.gs.CTM[1][0];
                }
                if (f6 < 0.0f) {
                    f5 += f6;
                    f6 = -f6;
                }
                if ((f3 = this.gs.CTM[0][0]) == 0.0f) {
                    f3 = this.gs.CTM[0][1];
                }
                if (f3 < 0.0f) {
                    f4 += f3;
                    f3 = -f3;
                }
                if (this.gs.CTM[0][0] == 0.0f && this.gs.CTM[0][1] > 0.0f && this.gs.CTM[1][0] != 0.0f && this.gs.CTM[1][1] == 0.0f) {
                    float f7 = f6;
                    f6 = f3;
                    f3 = f7;
                }
                if (f3 < 1.0f) {
                    f3 = 1.0f;
                }
                if (f6 < 1.0f) {
                    f6 = 1.0f;
                }
                int n43 = -1;
                if (f6 < 3.0f) {
                    n43 = (int)f6;
                    f6 = 1.0f;
                } else if (f3 < 3.0f) {
                    n43 = (int)f3;
                    f3 = 1.0f;
                }
                GeneralPath generalPath = new GeneralPath(1);
                generalPath.moveTo(f4, f5);
                generalPath.lineTo(f4, f5 + f6);
                generalPath.lineTo(f4 + f3, f5 + f6);
                generalPath.lineTo(f4 + f3, f5);
                generalPath.closePath();
                if (this.renderPage && generalPath != null) {
                    float f8 = this.gs.getLineWidth();
                    if (n43 > 0) {
                        this.gs.setLineWidth(n43);
                    }
                    this.gs.setNonstrokeColor(this.gs.nonstrokeColorSpace.getColor());
                    this.gs.setFillType(2);
                    this.current.drawShape(generalPath, this.gs, 70);
                    if (n43 > 0) {
                        this.gs.setLineWidth(f8);
                    }
                }
                return null;
            }
            if (n2 == 2 && n3 == 1 && ImageCommands.isRepeatingLine(byArray, n2)) {
                float f9 = this.gs.CTM[2][0];
                float f10 = this.gs.CTM[2][1];
                float f11 = this.gs.CTM[1][1];
                float f12 = this.gs.CTM[0][0];
                if (this.gs.CTM[0][0] == 0.0f && this.gs.CTM[0][1] > 0.0f && this.gs.CTM[1][0] != 0.0f && this.gs.CTM[1][1] == 0.0f) {
                    float f13 = f11;
                    f11 = f12;
                    f12 = f13;
                }
                double d = f12 / (float)(byArray.length / n2);
                double d2 = d / 8.0;
                for (n6 = 0; n6 < byArray.length / n2; ++n6) {
                    n5 = byArray[n6] & 0xFF;
                    int n44 = 8;
                    double d3 = 0.0;
                    boolean bl10 = false;
                    for (n5 = (n5 ^ 0xFFFFFFFF) & 0xFF; n5 != 0 || bl10; n5 >>>= 1) {
                        --n44;
                        if ((n5 & 1) == 1) {
                            if (bl10) continue;
                            d3 = ((double)n44 + 0.5) * d2 + (double)n6 * d;
                            bl10 = true;
                            continue;
                        }
                        if (!bl10) continue;
                        bl10 = false;
                        double d4 = ((double)n44 + 0.5) * d2 + (double)n6 * d;
                        GeneralPath generalPath = new GeneralPath(1);
                        generalPath.moveTo((float)((double)f9 + d4), f10);
                        generalPath.lineTo((float)((double)f9 + d4), f10 + f11);
                        generalPath.lineTo((float)((double)f9 + d3), f10 + f11);
                        generalPath.lineTo((float)((double)f9 + d3), f10);
                        generalPath.closePath();
                        if (!this.renderPage || generalPath == null) continue;
                        this.gs.setNonstrokeColor(this.gs.nonstrokeColorSpace.getColor());
                        this.gs.setFillType(2);
                        this.current.drawShape(generalPath, this.gs, 70);
                    }
                }
                return null;
            }
            if (bl4) {
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
                int[] nArray = new int[]{0, 1, 2, 3};
                bufferedImage = new BufferedImage(n, n2, 2);
                WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 4, 4, nArray, null);
                bufferedImage.setData(writableRaster);
            } else {
                boolean bl11 = true;
                if (n2 < 20) {
                    bl11 = true;
                } else if (n4 != 0) {
                    bl11 = this.current.hasObjectsBehind(this.gs.CTM);
                }
                boolean bl12 = false;
                boolean bl13 = false;
                if (bl && n3 == 1 && genericColorSpace.getID() == 1785221209 && byArray3[0] == 0 && byArray3[1] == 0 && byArray3[2] == 0) {
                    bl12 = true;
                    for (n7 = 0; n7 < byArray.length; ++n7) {
                        if (byArray[n7] == -1) continue;
                        bl12 = false;
                        n7 = byArray.length;
                    }
                    if (this.isPrinting && (n4 == 0 || this.isType3Font || n3 == 1)) {
                        WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferByte(byArray, byArray.length), n, n2, 1, null);
                        bufferedImage = new BufferedImage(n, n2, 12);
                        bufferedImage.setData(writableRaster);
                        bl13 = true;
                    } else if (bl12) {
                        bufferedImage = null;
                        bl5 = true;
                    } else {
                        byte[] byArray8 = new byte[]{byArray3[0], byArray3[1], byArray3[2], -1, -1, -1};
                        bufferedImage = ColorSpaceConvertor.convertIndexedToFlat(n3, n, n2, byArray, byArray8, true, true);
                    }
                }
                if (!bl12) {
                    if (!(this.isPrinting || byArray3[0] != 0 || byArray3[1] != 0 || byArray3[2] != 0 || bl11 || this.isType3Font || genericColorSpace.getID() == 1785221209)) {
                        if (n3 == 1) {
                            WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferByte(byArray, byArray.length), n, n2, 1, null);
                            bufferedImage = new BufferedImage(n, n2, 12);
                            bufferedImage.setData(writableRaster);
                        } else {
                            int[] nArray = new int[]{0};
                            WritableRaster writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray, byArray.length), n, n2, n, 1, nArray, null);
                            bufferedImage = new BufferedImage(n, n2, 10);
                            bufferedImage.setData(writableRaster);
                        }
                    } else if (!bl13) {
                        if (n3 == 8 && bl4) {
                            byte[] byArray9 = new byte[]{byArray3[0], byArray3[1], byArray3[2], -1, -1, -1};
                            bufferedImage = ColorSpaceConvertor.convertIndexedToFlat(n3, n, n2, byArray, byArray9, true, true);
                        } else if (n < 4000 && n2 < 4000 || bl11) {
                            byte[] byArray10 = new byte[]{byArray3[0], byArray3[1], byArray3[2], -1, -1, -1};
                            bufferedImage = ColorSpaceConvertor.convertIndexedToFlat(1, n, n2, byArray, byArray10, true, false);
                        }
                    }
                }
            }
        } else if (object == null) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Image " + string + ' ' + n + "W * " + n2 + "H with No Compression at BPC " + n3);
            }
            bufferedImage = this.makeImage(genericColorSpace, n, n2, n3, byArray, n10, pdfObject);
        } else if (bl6) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("JPeg Image " + string + ' ' + n + "W * " + n2 + 'H' + " arrayInverted=" + bl3);
            }
            if (n11 == 1498837125 && this.extractRawCMYK) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Raw CMYK image " + string + " saved.");
                }
                if (!this.objectStoreStreamRef.saveRawCMYKImage(byArray, string)) {
                    this.errorTracker.addPageFailureMessage("Problem saving Raw CMYK image " + string);
                }
            }
            boolean bl14 = false;
            if (genericColorSpace.getID() == 1247168582) {
                int n45 = genericColorSpace.getAlternateColorSpace();
                GenericColorSpace genericColorSpace2 = null;
                if (n45 == 1785221209) {
                    genericColorSpace2 = new DeviceRGBColorSpace();
                } else if (n45 == 1498837125) {
                    genericColorSpace2 = new DeviceCMYKColorSpace();
                }
                if (genericColorSpace2 != null) {
                    try {
                        bufferedImage = genericColorSpace2.JPEGToRGBImage(byArray, n, n2, fArray, n9, n8, bl3, pdfObject);
                        if (bufferedImage != null) {
                            bl14 = true;
                            genericColorSpace = genericColorSpace2;
                            if (genericColorSpace.isImageYCCK()) {
                                this.hasYCCKimages = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        this.errorTracker.addPageFailureMessage("Unable to use alt colorspace with " + string + " to JPEG");
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("Exception: " + exception.getMessage());
                        }
                        bufferedImage.flush();
                        bufferedImage = null;
                    }
                }
            }
            if (!bl14) {
                try {
                    bufferedImage = genericColorSpace.JPEGToRGBImage(byArray, n, n2, fArray, n9, n8, bl3, pdfObject);
                    if (genericColorSpace.isImageYCCK()) {
                        this.hasYCCKimages = true;
                    }
                }
                catch (Exception exception) {
                    this.errorTracker.addPageFailureMessage("Problem converting " + string + " to JPEG");
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                    bufferedImage.flush();
                    bufferedImage = null;
                }
            }
            string2 = "jpg";
            this.setRotationOptionsOnJPEGImage();
        } else if (n12) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("JPeg 2000 Image " + string + ' ' + n + "W * " + n2 + 'H');
            }
            if (!JAIHelper.isJAIused()) {
                if (System.getProperty("org.jpedal.jai") != null && System.getProperty("org.jpedal.jai").toLowerCase().equals("true")) {
                    if (!ImageCommands.JAImessageShow) {
                        ImageCommands.JAImessageShow = true;
                        System.err.println("JPeg 2000 Images need both JAI and imageio.jar on classpath");
                    }
                    throw new RuntimeException("JPeg 2000 Images need both JAI and imageio.jar on classpath");
                }
                System.err.println("JPeg 2000 Images needs the VM parameter -Dorg.jpedal.jai=true switch turned on");
                throw new RuntimeException("JPeg 2000 Images needs the VM parameter -Dorg.jpedal.jai=true switch turned on");
            }
            bufferedImage = genericColorSpace.JPEG2000ToRGBImage(byArray, n, n2, fArray, n9, n8);
            string2 = "jpg";
            this.setRotationOptionsOnJPEGImage();
        } else {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog(string + ' ' + n + "W * " + n2 + "H BPC=" + n3 + ' ' + genericColorSpace);
            }
            bufferedImage = this.makeImage(genericColorSpace, n, n2, n3, byArray, n10, pdfObject);
            if (n3 == 8 || this.gs.nonstrokeColorSpace.getID() == 1785221209 || this.gs.nonstrokeColorSpace.getID() == 1247168582) {
                string2 = "jpg";
            }
        }
        if (bufferedImage != null) {
            if (pdfObject3 != null && pdfObject5 == null) {
                pdfObject5 = pdfObject3.getDictionary(1888135062);
                if (genericColorSpace.getID() == 1568372915 && n < pdfObject3.getInt(959726687) && n2 < pdfObject3.getInt(959926393)) {
                    int n46 = byArray.length;
                    boolean bl15 = true;
                    for (int i = 0; i < n46; ++i) {
                        if (byArray[i] == 0) continue;
                        bl15 = false;
                        i = n46;
                    }
                    if (bl15) {
                        bufferedImage = new BufferedImage(pdfObject3.getInt(959726687), pdfObject3.getInt(959926393), 10);
                    }
                }
            }
            if (pdfObject3 != null) {
                bufferedImage = this.addSMaskObject(genericColorSpace, byArray, string, n, n2, pdfObject, bl6, n12 != 0, bufferedImage, pdfObject5, pdfObject3);
            } else if (pdfObject4 != null) {
                bufferedImage = ImageCommands.addMaskObject(genericColorSpace, n3, bl6, n12 != 0, bufferedImage, n11, byArray2, pdfObject4, this.optionsApplied, this.currentPdfFile);
            }
            if (bufferedImage != null) {
                bufferedImage = ImageCommands.simulateOverprint(genericColorSpace, byArray, bl6, n12 != 0, bufferedImage, n11, pdfObject4, pdfObject3, this.current, this.gs);
            }
            if (bufferedImage == null) {
                return null;
            }
            if (this.current.getType() != 4 && this.current.getType() != 5 && this.current.getType() != 6 && !this.renderDirectly && (this.finalImagesExtracted || this.rawImagesExtracted) && !this.cache.testIfImageAlreadySaved(pdfObject)) {
                this.saveImage(string, this.createScaledVersion, bufferedImage, string2);
            }
        }
        if (bufferedImage == null && !bl5) {
            this.imagesProcessedFully = false;
        }
        if ((pdfObject2 = this.gs.getTR()) != null) {
            bufferedImage = ImageCommands.applyTR(bufferedImage, pdfObject2, this.currentPdfFile);
        }
        if (pdfObject5 != null && pdfObject5.getInt(1010122310) != -1 && this.current.hasObjectsBehind(this.gs.CTM) && bufferedImage != null && bufferedImage.getType() != 2 && (!bl6 || pdfObject5.getInt(862279027) == 0)) {
            bufferedImage = ImageCommands.makeBlackandWhiteTransparent(bufferedImage);
        }
        if (n9 > 0 && n8 > 0 && n13 == 1 && ImageCommands.sharpenDownsampledImages && (genericColorSpace.getID() == 1568372915 || genericColorSpace.getID() == 1785221209)) {
            Kernel kernel = new Kernel(3, 3, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f});
            ConvolveOp convolveOp = new ConvolveOp(kernel);
            bufferedImage = convolveOp.filter(bufferedImage, null);
        }
        ++this.imageCount;
        if (n4 == 0 && this.isPrinting && bufferedImage != null && n3 == 1 && byArray3 != null && byArray3[0] == 0 && byArray3[1] == 0 && byArray3[2] == 0 && byArray3[3] == 0) {
            int n47 = bufferedImage.getWidth();
            int n48 = bufferedImage.getHeight();
            BufferedImage bufferedImage2 = new BufferedImage(n47, n48, 10);
            bufferedImage2.getGraphics().setColor(Color.WHITE);
            bufferedImage2.getGraphics().fillRect(0, 0, n47, n48);
            bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
            bufferedImage = bufferedImage2;
        }
        return bufferedImage;
    }

    private void setRotationOptionsOnJPEGImage() {
        if (this.imageStatus > 0 && this.gs.CTM[0][0] > 0.0f && this.gs.CTM[0][1] > 0.0f && this.gs.CTM[1][1] > 0.0f && this.gs.CTM[1][0] < 0.0f) {
            if (this.imageStatus == 1) {
                this.gs.CTM[0][1] = -this.gs.CTM[0][1];
                this.gs.CTM[1][1] = -this.gs.CTM[1][1];
                this.gs.CTM[2][1] = this.gs.CTM[2][1] - this.gs.CTM[1][1];
            } else if (this.imageStatus == 2) {
                ++this.optionsApplied;
            }
        } else if (this.optionsApplied > 0 && this.gs.CTM[0][0] < 0.0f && this.gs.CTM[1][1] < 0.0f && this.gs.CTM[0][1] == 0.0f && this.gs.CTM[1][0] == 0.0f) {
            this.gs.CTM[1][1] = -this.gs.CTM[1][1];
            this.gs.CTM[2][1] = this.gs.CTM[2][1] - this.gs.CTM[1][1] + this.gs.CTM[1][0];
            this.gs.CTM[2][0] = this.gs.CTM[2][0] - this.gs.CTM[0][1];
        }
    }

    private void saveImage(String string, boolean bl, BufferedImage bufferedImage, String string2) {
        if (bufferedImage != null && bufferedImage.getSampleModel().getNumBands() == 1) {
            string2 = "tif";
        }
        if (this.isPageContent && (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted)) {
            this.objectStoreStreamRef.saveStoredImage(string, ImageCommands.addBackgroundToMask(bufferedImage, this.isMask), false, bl, string2);
        }
    }

    private BufferedImage makeImage(GenericColorSpace genericColorSpace, int n, int n2, int n3, byte[] byArray, int n4, PdfObject pdfObject) {
        Object object;
        block59: {
            byte[] byArray2;
            Object object2;
            boolean bl;
            int n5;
            if (genericColorSpace.getID() == 1568372915) {
                int n6;
                if (n3 == 1) {
                    n5 = byArray.length;
                    n6 = (n + 7 >> 3) * n2;
                    if (n5 < n6) {
                        object = byArray;
                        byArray = new byte[n6];
                        System.arraycopy(object, 0, byArray, 0, n5);
                        for (int i = n5; i < n6; ++i) {
                            byArray[i] = -1;
                        }
                    }
                } else if (n3 == 8 && (n5 = byArray.length) < (n6 = n * n2)) {
                    object = byArray;
                    byArray = new byte[n6];
                    System.arraycopy(object, 0, byArray, 0, n5);
                }
            }
            ColorSpace colorSpace = genericColorSpace.getColorSpace();
            n5 = genericColorSpace.getID();
            object = null;
            byte[] byArray3 = genericColorSpace.getIndexedMap();
            this.optionsApplied = 0;
            boolean bl2 = !this.doNotRotate && this.useHiResImageForDisplay && RenderUtils.isInverted(this.gs.CTM);
            boolean bl3 = bl = !this.doNotRotate && this.useHiResImageForDisplay && RenderUtils.isRotated(this.gs.CTM);
            if (pdfObject.getGeneralType(608780341) == 489767739 && this.streamType != 1) {
                bl2 = false;
                bl = false;
            }
            if (bl2) {
                int n7 = n4;
                if (n5 == -2073385820) {
                    n7 = 1;
                } else if (n5 == 960981604) {
                    n7 = genericColorSpace.getColorComponentCount();
                }
                object2 = ImageOps.invertImage(byArray, n, n2, n3, n7, byArray3);
                if (object2 != null) {
                    byArray = object2;
                    ++this.optionsApplied;
                }
            }
            if (bl && (byArray2 = ImageOps.rotateImage(byArray, n, n2, n3, n4, byArray3)) != null) {
                byArray = byArray2;
                this.optionsApplied += 2;
                int n8 = n2;
                n2 = n;
                n = n8;
            }
            if (byArray3 != null) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Indexed " + n + ' ' + n2);
                }
                if (!genericColorSpace.isIndexConverted()) {
                    byArray3 = genericColorSpace.convertIndexToRGB(byArray3);
                }
                if (n3 == 8 && genericColorSpace.getIndexSize() == 0 && genericColorSpace.getID() == 1785221209) {
                    int n9;
                    boolean bl4 = false;
                    int n10 = byArray3.length;
                    for (n9 = 0; n9 < n10; ++n9) {
                        if (byArray3[n9] == 0) continue;
                        bl4 = true;
                        n9 = n10;
                    }
                    if (!bl4) {
                        n9 = byArray.length;
                        for (int i = 0; i < n9; ++i) {
                            if (byArray[i] == 0) continue;
                            bl4 = true;
                            i = n9;
                        }
                    }
                    if (!bl4) {
                        return new BufferedImage(1, 1, 2);
                    }
                }
                try {
                    if (n3 == 1 && byArray3.length == 6 && byArray3[0] == byArray3[3] && byArray3[1] == byArray3[4] && byArray3[2] == byArray3[5]) {
                        object = null;
                        break block59;
                    }
                    if (n3 == 8 && n == 1 && n2 == 1 && byArray3[0] == -1 && byArray3[1] == -1 && byArray3[2] == -1 && ImageDecoder.allBytesZero(byArray)) {
                        object = new BufferedImage(1, 1, 1);
                        ((BufferedImage)object).createGraphics().setPaint(Color.CYAN);
                        Raster raster = ColorSpaceConvertor.createInterleavedRaster(new byte[]{-1, -1, -1}, 1, 1);
                        ((BufferedImage)object).setData(raster);
                        break block59;
                    }
                    object = ColorSpaceConvertor.convertIndexedToFlat(n3, n, n2, byArray, byArray3, false, false);
                }
                catch (Exception exception) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                    break block59;
                }
            }
            if (n3 == 1) {
                object = new BufferedImage(n, n2, 12);
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
                if (genericColorSpace.getID() == -2073385820) {
                    int n11 = byArray.length;
                    for (int i = 0; i < n11; ++i) {
                        byArray[i] = (byte)(byArray[i] ^ 0xFF);
                    }
                }
                object2 = Raster.createPackedRaster(dataBufferByte, n, n2, n3, null);
                ((BufferedImage)object).setData((Raster)object2);
            } else if (n5 == -2073385820 || n5 == 960981604) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Converting Separation/DeviceN colorspace to sRGB ");
                }
                object = genericColorSpace.dataToRGB(byArray, n, n2);
            } else if (n4 == 4) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Converting ICC/CMYK colorspace to sRGB ");
                }
                object = ColorSpaceConvertor.convertFromICCCMYK(n, n2, byArray);
            } else if (n4 == 3) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Converting 3 comp colorspace to sRGB index=" + byArray3);
                }
                if (n * n2 == byArray.length) {
                    if (n3 == 8 && byArray3 != null) {
                        object = ColorSpaceConvertor.convertIndexedToFlat(n3, n, n2, byArray, byArray3, false, false);
                    } else {
                        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
                        object2 = new int[]{0};
                        object = new BufferedImage(n, n2, 10);
                        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n, 1, (int[])object2, null);
                        ((BufferedImage)object).setData(writableRaster);
                    }
                } else {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Converting data to sRGB ");
                    }
                    if (n3 == 4) {
                        int n12 = byArray.length;
                        int n13 = n * n2 * 3;
                        boolean bl5 = (n & 1) == 1;
                        int n14 = n * 3 + 1 >> 1;
                        byte[] byArray4 = new byte[n13];
                        int n15 = 0;
                        int n16 = 0;
                        for (int i = 0; i < n12; ++i) {
                            byte by = byArray[i];
                            ++n16;
                            byArray4[n15] = (byte)(by & 0xF0);
                            if (byArray4[n15] == -16) {
                                byArray4[n15] = -1;
                            }
                            ++n15;
                            if (n16 == n14 && bl5) {
                                n16 = 0;
                            } else {
                                byArray4[n15] = (byte)((by & 0xF) << 4);
                                if (byArray4[n15] == -16) {
                                    byArray4[n15] = -1;
                                }
                                ++n15;
                            }
                            if (n15 != n13) continue;
                            i = n12;
                        }
                        byArray = byArray4;
                    }
                    object = new BufferedImage(n, n2, 1);
                    byArray = ImageOps.checkSize(byArray, n, n2, 3);
                    Raster raster = ColorSpaceConvertor.createInterleavedRaster(byArray, n, n2);
                    ((BufferedImage)object).setData(raster);
                }
            } else if (n4 == 1) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("comp=1 and d= " + n3);
                }
                if (n3 != 8) {
                    int n17 = n * n2;
                    object2 = new byte[n17];
                    switch (n3) {
                        case 2: {
                            ColorSpaceConvertor.flatten2bpc(n, byArray, null, false, n17, object2);
                            break;
                        }
                        case 4: {
                            ColorSpaceConvertor.flatten4bpc(n, byArray, n17, object2);
                            break;
                        }
                        default: {
                            if (!LogWriter.isOutput()) break;
                            LogWriter.writeLog("unknown comp= " + n3);
                        }
                    }
                    byArray = object2;
                }
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
                object2 = new int[]{0};
                object = new BufferedImage(n, n2, 10);
                WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n, 1, (int[])object2, null);
                ((BufferedImage)object).setData(writableRaster);
            } else if (LogWriter.isOutput()) {
                LogWriter.writeLog("Image " + colorSpace.getType() + " not currently supported with components " + n4);
            }
        }
        return object;
    }

    private static boolean allBytesZero(byte[] byArray) {
        boolean bl = true;
        for (byte by : byArray) {
            if (by == 0) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private BufferedImage addSMaskObject(GenericColorSpace genericColorSpace, byte[] byArray, String string, int n, int n2, PdfObject pdfObject, boolean bl, boolean bl2, BufferedImage bufferedImage, PdfObject pdfObject2, PdfObject pdfObject3) throws PdfException {
        byte[] byArray2 = this.currentPdfFile.readStream(pdfObject3, true, true, false, false, false, pdfObject3.getCacheName(this.currentPdfFile.getObjectReader()));
        if (byArray2 != null) {
            int n3;
            int n4;
            boolean bl3 = pdfObject2 != null && pdfObject2.getInt(1010783618) != -1 && pdfObject2.getInt(1970893723) != 15 && genericColorSpace.getID() != 1247168582;
            PdfObject pdfObject4 = pdfObject3.getDictionary(2087749783);
            if (bl3 && (genericColorSpace.getID() == 1785221209 || genericColorSpace.getID() == 1498837125) && pdfObject4.getParameterConstant(2087749783) == 1568372915) {
                bl3 = false;
            }
            if (bl && pdfObject4.getParameterConstant(2087749783) == 1568372915) {
                n4 = byArray2.length;
                bl3 = true;
                for (n3 = 0; n3 < n4; ++n3) {
                    if (byArray2[n3] == -1) continue;
                    bl3 = false;
                    n3 = n4;
                }
            }
            if (!bl3) {
                int n5;
                n4 = this.optionsApplied;
                if (this.optionsApplied == 0) {
                    this.doNotRotate = true;
                }
                n3 = pdfObject3.getInt(959726687);
                int n6 = pdfObject3.getInt(959926393);
                boolean bl4 = false;
                boolean bl5 = false;
                if (bl4) {
                    PdfObject pdfObject5 = pdfObject.getDictionary(2087749783);
                    PdfArrayIterator pdfArrayIterator = pdfObject3.getMixedArray(1011108731);
                    boolean bl6 = false;
                    if (pdfObject5.getParameterConstant(2087749783) == 1785221209 && pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
                        while (pdfArrayIterator.hasMoreTokens()) {
                            n5 = pdfArrayIterator.getNextValueAsConstant(true);
                            bl6 = n5 == 1247500931;
                        }
                    }
                    bl5 = byArray.length == 2 && pdfObject5.getParameterConstant(2087749783) == 895578984;
                    boolean bl7 = bl4 = pdfObject5 != null && (pdfObject5.getParameterConstant(2087749783) == 1785221209 && (!bl || bl6) || bl5 && pdfObject5.getDictionary(895578984).getParameterConstant(2087749783) == 1785221209) && pdfObject4.getParameterConstant(2087749783) == 1568372915;
                }
                if (bl4 && (bl || bl2 || bl5)) {
                    int n7 = byArray2.length;
                    for (int i = 0; i < n7; ++i) {
                        byArray2[i] = (byte)(-1 - byArray2[i]);
                    }
                    bufferedImage = this.processImageXObject(pdfObject3, string, byArray2, true, null);
                } else {
                    BufferedImage bufferedImage2 = this.processImageXObject(pdfObject3, string, byArray2, true, null);
                    if (this.pageNum > 0 && this.pageData.getRotation(this.pageNum) == 0 && n4 == 2) {
                        int n8 = bufferedImage2.getWidth();
                        int n9 = bufferedImage2.getHeight();
                        BufferedImage bufferedImage3 = new BufferedImage(n9, n8, bufferedImage2.getType());
                        for (n5 = 0; n5 < n8; ++n5) {
                            for (int i = 0; i < n9; ++i) {
                                bufferedImage3.setRGB(n9 - 1 - i, n5, bufferedImage2.getRGB(n5, i));
                            }
                        }
                        bufferedImage2 = bufferedImage3;
                    }
                    this.doNotRotate = false;
                    this.optionsApplied = n4;
                    if (bufferedImage2 != null) {
                        bufferedImage = ImageCommands.applySmask(bufferedImage, bufferedImage2, pdfObject3, false, genericColorSpace.getID() == 1785221209, pdfObject3.getDictionary(2087749783), pdfObject, this.gs);
                        bufferedImage2.flush();
                    }
                }
            }
        }
        return bufferedImage;
    }
}

