/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import org.jpedal.fonts.tt.conversion.FontWriter;

public class CFFFixer {
    private byte[] data;
    private byte[] original;
    private int charstringOffset = -1;
    private int privateOffset = -1;
    private int privateOffsetLocation = -1;
    private int privateOffsetLength = -1;
    private int fdArrayOffset = -1;
    private int fdArrayOffsetLocation = -1;
    private int fdArrayOffsetLength = -1;

    public CFFFixer(byte[] byArray) {
        this.data = byArray;
        this.original = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.original, 0, byArray.length);
        if (this.scanForDotsection()) {
            this.fixData();
        }
    }

    private boolean scanForDotsection() {
        boolean bl = false;
        for (int i = 0; i < this.data.length - 1; ++i) {
            if (this.data[i] != 12 || this.data[i + 1] != 0) continue;
            bl = true;
        }
        return bl;
    }

    private void fixData() {
        try {
            int n;
            int n2;
            byte by = this.data[2];
            int n3 = FontWriter.getUintFromByteArray(this.data, by, 2);
            byte by2 = this.data[by + 2];
            int n4 = by + 3 + by2 * n3;
            int n5 = FontWriter.getUintFromByteArray(this.data, n4, by2);
            int n6 = n4 + n5 + (by2 - 1);
            int n7 = FontWriter.getUintFromByteArray(this.data, n6, 2);
            if (n7 != 1) {
                this.data = this.original;
                return;
            }
            byte by3 = this.data[n6 + 2];
            int n8 = n6 + 3 + by3 * n7;
            int n9 = FontWriter.getUintFromByteArray(this.data, n8, by3);
            int n10 = n8 + by3;
            byte[] byArray = new byte[n9 - 1];
            System.arraycopy(this.data, n10, byArray, 0, n9 - 1);
            this.decodeTopDict(byArray);
            if (this.charstringOffset == -1) {
                this.data = this.original;
                return;
            }
            int n11 = FontWriter.getUintFromByteArray(this.data, this.charstringOffset, 2);
            byte by4 = this.data[this.charstringOffset + 2];
            int n12 = this.charstringOffset + 3;
            int[] nArray = new int[n11 + 1];
            for (n2 = 0; n2 < n11 + 1; ++n2) {
                nArray[n2] = FontWriter.getUintFromByteArray(this.data, n12 + by4 * n2, by4);
            }
            n2 = n12 + (n11 + 1) * by4;
            int n13 = 0;
            for (n = 0; n < n11; ++n) {
                int n14;
                int n15;
                int n16;
                int n17 = n2 + nArray[n] - 1;
                int n18 = n2 + nArray[n + 1] - 1;
                int[] nArray2 = new int[n18 - n17];
                for (n16 = 0; n16 < nArray2.length; ++n16) {
                    nArray2[n16] = this.data[n17 + n16];
                    if (nArray2[n16] >= 0) continue;
                    int n19 = n16;
                    nArray2[n19] = nArray2[n19] + 256;
                }
                for (n16 = 0; n16 < nArray2.length; n16 += n15 + n14) {
                    int n20 = nArray2[n16];
                    if (n20 >= 32 && n20 <= 246) {
                        n14 = 1;
                        n15 = 0;
                        continue;
                    }
                    if (n20 >= 247 && n20 <= 254) {
                        n14 = 2;
                        n15 = 0;
                        continue;
                    }
                    if (n20 == 255) {
                        n14 = 5;
                        n15 = 0;
                        continue;
                    }
                    if (n20 == 28) {
                        n14 = 3;
                        n15 = 0;
                        continue;
                    }
                    if (n20 == 12) {
                        if (nArray2[n16 + 1] == 0) {
                            System.arraycopy(this.data, n17 + n16 + 2, this.data, n17 + n16, this.data.length - (n17 + n16 + 2));
                            System.arraycopy(nArray2, n16 + 2, nArray2, n16, nArray2.length - (n16 + 2));
                            int n21 = n + 1;
                            while (n21 < nArray.length) {
                                int n22 = n21++;
                                nArray[n22] = nArray[n22] - 2;
                            }
                            n13 += 2;
                            n15 = 0;
                        } else {
                            n15 = 2;
                        }
                        n14 = 0;
                        continue;
                    }
                    n15 = 1;
                    n14 = 0;
                }
            }
            if (n13 == 0) {
                this.data = this.original;
                return;
            }
            for (n = 0; n < nArray.length; ++n) {
                byte[] byArray2 = FontWriter.setUintAsBytes(nArray[n], by4);
                System.arraycopy(byArray2, 0, this.data, n12 + n * by4, by4);
            }
            if (this.fdArrayOffset != -1 && this.fdArrayOffsetLength != -1 && this.fdArrayOffsetLocation != -1) {
                byte[] byArray3 = FontWriter.set1cNumber(this.fdArrayOffset - n13);
                byArray3 = CFFFixer.pad1cNumber(this.fdArrayOffsetLength, byArray3, this.fdArrayOffset - n13);
                System.arraycopy(byArray3, 0, this.data, n10 + this.fdArrayOffsetLocation, this.fdArrayOffsetLength);
            }
            if (this.privateOffset != -1 && this.privateOffsetLength != -1 && this.privateOffsetLocation != -1) {
                byte[] byArray4 = FontWriter.set1cNumber(this.privateOffset - n13);
                byArray4 = CFFFixer.pad1cNumber(this.privateOffsetLength, byArray4, this.privateOffset - n13);
                System.arraycopy(byArray4, 0, this.data, n10 + this.privateOffsetLocation, this.privateOffsetLength);
            }
            byte[] byArray5 = this.data;
            this.data = new byte[this.data.length - n13];
            System.arraycopy(byArray5, 0, this.data, 0, this.data.length);
        }
        catch (Exception exception) {
            this.data = this.original;
        }
    }

    private void decodeTopDict(byte[] byArray) {
        int n;
        int n2;
        int[] nArray = new int[byArray.length];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            nArray[n2] = byArray[n2] < 0 ? byArray[n2] + 256 : byArray[n2];
        }
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < nArray.length; n2 += n + n3) {
            int n5 = nArray[n2];
            if (n5 >= 32 && n5 <= 246) {
                n4 = n5 - 139;
                n3 = 1;
                n = 0;
                continue;
            }
            if (n5 >= 247 && n5 <= 250) {
                n4 = (n5 - 247) * 256 + nArray[n2 + 1] + 108;
                n3 = 2;
                n = 0;
                continue;
            }
            if (n5 >= 251 && n5 <= 254) {
                n4 = -((n5 - 251) * 256) - nArray[n2 + 1] - 108;
                n3 = 2;
                n = 0;
                continue;
            }
            if (n5 == 28) {
                n4 = FontWriter.getUintFromIntArray(nArray, n2 + 1, 2);
                n3 = 3;
                n = 0;
                continue;
            }
            if (n5 == 29) {
                n4 = FontWriter.getUintFromIntArray(nArray, n2 + 1, 4);
                n3 = 5;
                n = 0;
                continue;
            }
            if (n5 == 30) {
                n3 = 1;
                while ((nArray[n2 + n3] & 0xF) != 15 && (nArray[n2 + n3] & 0xF) != 15) {
                    ++n3;
                }
                ++n3;
                n = 0;
                continue;
            }
            if (n5 == 12) {
                if (nArray[n2 + 1] == 36) {
                    this.fdArrayOffsetLocation = n2 - n3;
                    this.fdArrayOffsetLength = n3;
                    this.fdArrayOffset = n4;
                }
                n = 2;
                n3 = 0;
                continue;
            }
            if (n5 == 17) {
                this.charstringOffset = n4;
                n = 1;
                n3 = 0;
                continue;
            }
            if (n5 == 18) {
                this.privateOffsetLocation = n2 - n3;
                this.privateOffsetLength = n3;
                this.privateOffset = n4;
                n = 1;
                n3 = 0;
                continue;
            }
            n = 1;
            n3 = 0;
        }
    }

    private static byte[] pad1cNumber(int n, byte[] byArray, int n2) {
        if (n == byArray.length) {
            return byArray;
        }
        if (n < byArray.length) {
            throw new IllegalArgumentException("Trying to pad a number to a smaller size.");
        }
        if (n != 2 && n != 3 && n != 5) {
            throw new IllegalArgumentException("Padding to an incorect number of bytes.");
        }
        byte[] byArray2 = n == 2 ? new byte[]{-117, byArray[0]} : (n == 3 ? new byte[]{28, (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)} : new byte[]{29, (byte)(n2 >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)});
        return byArray2;
    }

    public byte[] getBytes() {
        return this.data;
    }
}

