/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.T3Display;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Node;

public class FormStream {
    public static final boolean debugUnimplemented = false;
    public static final boolean debug = false;
    private static boolean showFontMessage = false;
    public static final boolean exitOnError = false;
    protected PdfObjectReader currentPdfFile;
    public static boolean marksNewJavascriptCode = false;
    public static final int[] id = new int[]{17, 4866, 4668, 21, 40, 20, 37, 5695, 8223, 8211, 8230, 8217, 31, 4865, 27, 22, 38, 4866, 5139, 10019, 5155, 10016, 5152};

    public FormStream() {
    }

    public FormStream(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
    }

    public FormObject createAppearanceString(FormObject formObject, PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
        this.init(formObject);
        return formObject;
    }

    private void init(FormObject formObject) {
        String string;
        int n = formObject.getInt(5686);
        if (n != -1) {
            formObject.commandFf(n);
        }
        if (!marksNewJavascriptCode) {
            this.resolveAdditionalAction(formObject);
        }
        this.setupAPimages(formObject, false);
        int n2 = formObject.getNameAsConstant(24);
        if (n2 != -1) {
            if (n2 == 36 || n2 == 32) {
                if (!formObject.hasDownImage()) {
                    formObject.setOffsetDownApp();
                }
            } else if (n2 == 30) {
                formObject.setNoDownIcon();
            } else if (n2 == 25) {
                formObject.setInvertForDownIcon();
            }
        }
        if ((string = formObject.getTextStreamValue(5137)) != null) {
            FormStream.decodeFontCommandObj(string, formObject);
        }
    }

    public void setupAPimages(FormObject formObject, boolean bl) {
        int[] nArray = new int[]{30, 34, 20};
        String[] stringArray = new String[]{"PdfDictionary.N", "PdfDictionary.R", "PdfDictionary.D"};
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Map map;
            PdfObject pdfObject;
            BufferedImage bufferedImage;
            PdfObject pdfObject2 = formObject.getDictionary(4384).getDictionary(nArray[i]);
            if (pdfObject2 == null) continue;
            if (bl && nArray[i] == 30) {
                System.out.println(" AP (" + stringArray[i] + ")=" + pdfObject2 + ' ' + pdfObject2.getObjectRefAsString() + " AP=" + formObject.getDictionary(4384) + " form=" + formObject + ' ' + formObject.getObjectRefAsString() + " stream=" + pdfObject2.getDecodedStream() + " Off=" + pdfObject2.getDictionary(2045494));
            }
            if (pdfObject2.getDecodedStream() != null) {
                bufferedImage = FormStream.rotate(FormStream.decode(this.currentPdfFile, pdfObject2, formObject.getParameterConstant(1147962727)), formObject.getDictionary(7451).getInt(34));
                if (bl) {
                    System.out.println(bufferedImage);
                }
                if (bufferedImage == null) continue;
                if (nArray[i] == 20) {
                    formObject.setAppearanceImage(bufferedImage, 20, 2045494);
                    if (!bl) continue;
                    System.out.println("D " + bufferedImage);
                    continue;
                }
                if (nArray[i] == 30 && !formObject.hasNormalOff()) {
                    formObject.setAppearanceImage(bufferedImage, 30, 2045494);
                    if (!bl) continue;
                    System.out.println("N " + bufferedImage);
                    continue;
                }
                if (nArray[i] != 34) continue;
                formObject.setAppearanceImage(bufferedImage, 34, 2045494);
                if (!bl) continue;
                System.out.println("R " + bufferedImage);
                continue;
            }
            PdfObject pdfObject3 = pdfObject2.getDictionary(7998);
            if (pdfObject3 != null) {
                bufferedImage = FormStream.rotate(FormStream.decode(this.currentPdfFile, pdfObject3, formObject.getParameterConstant(1147962727)), formObject.getDictionary(7451).getInt(34));
                if (bl) {
                    System.out.println("On=" + pdfObject3 + ' ' + bufferedImage);
                }
                if (bufferedImage == null) continue;
                if (nArray[i] == 20) {
                    formObject.setAppearanceImage(bufferedImage, 20, 7998);
                    if (!formObject.hasDownOff()) {
                        formObject.setAppearanceImage(null, 20, 2045494);
                    }
                } else if (nArray[i] == 30) {
                    formObject.setAppearanceImage(bufferedImage, 30, 7998);
                    formObject.setNormalOnState("On");
                } else if (nArray[i] == 34) {
                    formObject.setAppearanceImage(bufferedImage, 34, 7998);
                    if (!formObject.hasRolloverOff()) {
                        formObject.setAppearanceImage(null, 34, 2045494);
                    }
                }
            }
            if ((pdfObject = pdfObject2.getDictionary(2045494)) != null) {
                bufferedImage = FormStream.rotate(FormStream.decode(this.currentPdfFile, pdfObject, formObject.getParameterConstant(1147962727)), formObject.getDictionary(7451).getInt(34));
                if (bl) {
                    System.out.println("Off=" + pdfObject + ' ' + pdfObject.getDecodedStream() + ' ' + bufferedImage);
                }
                if (bufferedImage == null) continue;
                if (nArray[i] == 20) {
                    formObject.setAppearanceImage(bufferedImage, 20, 2045494);
                } else if (nArray[i] == 30) {
                    formObject.setAppearanceImage(bufferedImage, 30, 2045494);
                } else if (nArray[i] == 34) {
                    formObject.setAppearanceImage(bufferedImage, 34, 2045494);
                }
            }
            if ((map = pdfObject2.getOtherDictionaries()) == null || map.isEmpty()) continue;
            if (bl) {
                System.out.println(formObject.getObjectRefAsString() + " AP Other=" + map);
            }
            for (String string : map.keySet()) {
                Object v = map.get(string);
                PdfObject pdfObject4 = (PdfObject)v;
                bufferedImage = FormStream.rotate(FormStream.decode(this.currentPdfFile, pdfObject4, formObject.getParameterConstant(1147962727)), formObject.getDictionary(7451).getInt(34));
                if (bl) {
                    System.out.println("(other) " + string + ' ' + pdfObject4 + ' ' + bufferedImage);
                }
                if (bufferedImage == null) continue;
                if (nArray[i] == 20) {
                    if (bl) {
                        System.out.println("D(other) set=" + bufferedImage + ' ' + formObject);
                    }
                    formObject.setAppearanceImage(bufferedImage, 20, 7998);
                    if (formObject.hasDownOff()) continue;
                    formObject.setAppearanceImage(null, 20, 2045494);
                    continue;
                }
                if (nArray[i] == 30) {
                    formObject.setAppearanceImage(bufferedImage, 30, 7998);
                    formObject.setNormalOnState(string);
                    if (bl) {
                        System.out.println("Set N (other) " + formObject);
                    }
                    if (formObject.hasNormalOff()) continue;
                    formObject.setAppearanceImage(null, 30, 2045494);
                    continue;
                }
                if (nArray[i] != 34) continue;
                formObject.setAppearanceImage(bufferedImage, 34, 7998);
                if (formObject.hasRolloverOff()) continue;
                formObject.setAppearanceImage(null, 34, 2045494);
            }
        }
    }

    private void resolveAdditionalAction(FormObject formObject) {
        int[] nArray = id;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = n2 = nArray[i];
        }
    }

    public static BufferedImage decode(PdfObjectReader pdfObjectReader, PdfObject pdfObject, int n) {
        return FormStream.decode(pdfObjectReader, pdfObject, n, 0, 0, 0, 1.0f);
    }

    public static BufferedImage decode(PdfObjectReader pdfObjectReader, PdfObject pdfObject, int n, int n2, int n3, int n4, float f) {
        boolean bl = true;
        pdfObjectReader.checkResolved(pdfObject);
        try {
            Graphics2D graphics2D;
            BufferedImage bufferedImage;
            float f2;
            float f3;
            float f4;
            float f5;
            Object object;
            PdfStreamDecoder pdfStreamDecoder;
            T3Display t3Display;
            ObjectStore objectStore;
            block42: {
                objectStore = new ObjectStore(null);
                t3Display = new T3Display(0, false, 20, objectStore);
                if (!bl) {
                    t3Display.setOptimisedRotation(false);
                } else {
                    t3Display.setHiResImageForDisplayMode(bl);
                }
                pdfStreamDecoder = new PdfStreamDecoder(pdfObjectReader, bl, null);
                pdfStreamDecoder.setParameters(false, true, 15, 0);
                pdfStreamDecoder.setIntValue(-12, 1);
                pdfStreamDecoder.setBooleanValue(-16, true);
                pdfStreamDecoder.setObjectValue(-8, objectStore);
                pdfStreamDecoder.setObjectValue(23, t3Display);
                try {
                    object = pdfObject.getDictionary(2004251818);
                    if (object != null) {
                        pdfStreamDecoder.readResources((PdfObject)object, false);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Exception " + exception + " reading resources in XForm");
                    if (!LogWriter.isOutput()) break block42;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
            object = pdfObject.getDecodedStream();
            if (object != null) {
                pdfStreamDecoder.decodeStreamIntoObjects((byte[])object, false);
            }
            boolean bl2 = pdfStreamDecoder.ignoreColors;
            objectStore.flush();
            T3Glyph t3Glyph = new T3Glyph(t3Display, 0, 0, bl2, "");
            float[] fArray = pdfObject.getFloatArray(303185736);
            float f6 = 0.0f;
            float f7 = 0.0f;
            if (fArray != null) {
                int n5;
                int n6;
                int n7;
                for (n7 = 0; n7 < 4; ++n7) {
                    fArray[n7] = fArray[n7] * f;
                }
                f6 = fArray[0];
                f7 = fArray[1];
                n7 = (int)(fArray[2] + 0.5f - fArray[0]);
                if (n7 < 0) {
                    n7 = -n7;
                }
                if ((n6 = (int)(fArray[3] + 0.5f - fArray[1])) < 0) {
                    n6 = -n6;
                }
                if (n7 == 0 && n6 > 0) {
                    n7 = 1;
                }
                if (n7 > 0 && n6 == 0) {
                    n6 = 1;
                }
                if ((n5 = (int)(f5 = (f4 = (float)n2 / (float)n7) - (f3 = (float)n3 / (float)n6))) != 0) {
                    int n8 = n2;
                    n2 = n3;
                    n3 = n8;
                    f4 = (float)n2 / (float)n7;
                    f3 = (float)n3 / (float)n6;
                }
                if (f4 < 1.0f || f3 < 1.0f) {
                    f2 = 1.0f;
                    n2 = n7;
                    n3 = n6;
                } else {
                    if (f4 > f3) {
                        f2 = f4;
                        n3 = (int)((float)n6 * f2);
                    } else {
                        f2 = f3;
                        n2 = (int)((float)n7 * f2);
                    }
                    f6 *= f2;
                    f7 *= f2;
                }
            } else {
                float f8;
                float f9 = 20.0f;
                if ((float)n3 < f9) {
                    n3 = (int)f9;
                }
                if ((float)n2 < f9) {
                    n2 = (int)f9;
                }
                if ((f8 = (float)n2 / f9) > (f4 = (float)n3 / f9)) {
                    f2 = f8;
                    n3 = (int)(f9 * f2);
                } else {
                    f2 = f4;
                    n2 = (int)(f9 * f2);
                }
                f6 *= f2;
                f7 *= f2;
            }
            if (n2 == 0 || n3 == 0) {
                return null;
            }
            if (f2 > 1.0f) {
                n3 += 2;
                n2 += 2;
            }
            if (n4 == 1) {
                n2 += 2;
                n3 += 2;
            }
            int n9 = n3;
            float[] fArray2 = pdfObject.getFloatArray(1145198201);
            if (fArray2 != null) {
                f4 = fArray2[0];
                f3 = fArray2[1];
                f5 = fArray2[2];
                float f10 = fArray2[3];
                float f11 = fArray2[4] * f2 * f;
                float f12 = fArray2[5] * f2 * f;
                if (f5 != 0.0f) {
                    bufferedImage = new BufferedImage(n3, n2, 2);
                    n9 = n2;
                } else {
                    bufferedImage = new BufferedImage(n2, n3, 2);
                    if (!(f3 < 0.0f)) {
                        if (f11 != 0.0f) {
                            f11 = -f6;
                        }
                        if (f12 != 0.0f) {
                            f12 = -f7;
                        }
                    }
                }
                graphics2D = (Graphics2D)bufferedImage.getGraphics();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, n9);
                affineTransform.scale(1.0, -1.0);
                graphics2D.setTransform(affineTransform);
                AffineTransform affineTransform2 = new AffineTransform(f4, f3, f5, f10, f11, f12);
                graphics2D.transform(affineTransform2);
            } else {
                bufferedImage = new BufferedImage(n2, n3, 2);
                graphics2D = (Graphics2D)bufferedImage.getGraphics();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, n9);
                affineTransform.scale(1.0, -1.0);
                graphics2D.setTransform(affineTransform);
            }
            if (n4 == 2) {
                graphics2D.scale(-1.0, -1.0);
            } else if (n4 == 1) {
                graphics2D.translate(1, 1);
            }
            if (n == 1919840408) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            t3Glyph.render(0, graphics2D, f2 * f, true);
            graphics2D.dispose();
            return bufferedImage;
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
            return null;
        }
        catch (Error error) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Error: " + error.getMessage());
            }
            if (ExternalHandlers.throwMissingCIDError && error.getMessage().contains("kochi")) {
                throw error;
            }
            return null;
        }
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2;
        if (bufferedImage == null) {
            return null;
        }
        if (n == 0) {
            return bufferedImage;
        }
        try {
            double d = (double)n * Math.PI / 180.0;
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            int n4 = (int)Math.round((double)n3 * Math.abs(Math.sin(d)) + (double)n2 * Math.abs(Math.cos(d)));
            int n5 = (int)Math.round((double)n3 * Math.abs(Math.cos(d)) + (double)n2 * Math.abs(Math.sin(d)));
            AffineTransform affineTransform = AffineTransform.getTranslateInstance((n4 - n2) / 2, (n5 - n3) / 2);
            affineTransform.rotate(d, n2 / 2, n3 / 2);
            bufferedImage2 = new BufferedImage(n4, n5, 2);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawRenderedImage(bufferedImage, affineTransform);
            graphics2D.dispose();
        }
        catch (Error error) {
            bufferedImage2 = null;
        }
        return bufferedImage2;
    }

    public boolean hasXFADataSet() {
        return false;
    }

    public static void decodeFontCommandObj(String string, FormObject formObject) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "() []");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        for (n2 = n - 1; n2 > -1; --n2) {
            float f;
            if (stringArray[n2].equals("g")) {
                --n2;
                f = 0.0f;
                try {
                    f = Float.parseFloat(FormStream.handleComma(stringArray[n2]));
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error in generating g value " + stringArray[n2]);
                }
                formObject.setTextColor(new float[]{f});
                continue;
            }
            if (stringArray[n2].equals("Tf")) {
                --n2;
                int n3 = 8;
                try {
                    n3 = (int)Float.parseFloat(FormStream.handleComma(stringArray[n2]));
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error in generating Tf size " + stringArray[n2]);
                }
                --n2;
                String string2 = null;
                try {
                    string2 = stringArray[n2];
                    if (string2.startsWith("/")) {
                        string2 = string2.substring(1);
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error in generating Tf font " + stringArray[n2]);
                }
                PdfFont pdfFont = new PdfFont();
                formObject.setTextFont(pdfFont.setFont(string2, n3));
                formObject.setTextSize(n3);
                continue;
            }
            if (stringArray[n2].equals("rg") || stringArray[n2].equals("r")) {
                f = Float.parseFloat(FormStream.handleComma(stringArray[--n2]));
                float f2 = Float.parseFloat(FormStream.handleComma(stringArray[--n2]));
                float f3 = Float.parseFloat(FormStream.handleComma(stringArray[--n2]));
                formObject.setTextColor(new float[]{f3, f2, f});
                continue;
            }
            if (stringArray[n2].equals("Sig")) {
                LogWriter.writeFormLog("Sig-  UNIMPLEMENTED=" + string + "< " + n2, false);
                continue;
            }
            if (stringArray[n2].equals("\\n") || showFontMessage) continue;
            showFontMessage = true;
            LogWriter.writeFormLog("{stream} Unknown FONT command " + stringArray[n2] + ' ' + n2 + " string=" + string, false);
        }
    }

    private static String handleComma(String string) {
        int n = string.indexOf(44);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public Node getXFA(int n) {
        throw new RuntimeException("getXFA Should never be called in base class");
    }
}

