/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter.ccitt;

import java.util.BitSet;
import org.jpedal.io.filter.ccitt.CCITTDecoder;
import org.jpedal.objects.raw.PdfObject;

public class CCITT1D
implements CCITTDecoder {
    boolean BlackIs1 = false;
    boolean isByteAligned = false;
    int columns = 1728;
    byte[] data;
    int bitReached;
    private static final int EOL = -1;
    private static final boolean debug = false;
    boolean isWhite = true;
    private boolean isTerminating = false;
    private boolean isEndOfLine = false;
    private boolean EOS = false;
    private int cRTC = 0;
    int width = 0;
    int height = 0;
    private int line = 0;
    BitSet out;
    private BitSet inputBits;
    int outPtr = 0;
    private int bytesNeeded = 0;
    int scanlineStride;
    private int inputBitCount = 0;
    private static final int[][][] b = new int[][][]{new int[][]{{3, 2, 0}, {2, 3, 0}}, new int[][]{{2, 1, 0}, {3, 4, 0}}, new int[][]{{3, 5, 0}, {2, 6, 0}}, new int[][]{{3, 7, 0}}, new int[][]{{5, 8, 0}, {4, 9, 0}}, new int[][]{{4, 10, 0}, {5, 11, 0}, {7, 12, 0}}, new int[][]{{4, 13, 0}, {7, 14, 0}}, new int[][]{{24, 15, 0}}, new int[][]{{55, 0, 0}, {23, 16, 0}, {24, 17, 0}, {8, 18, 0}, {15, 64, 1}}, new int[][]{{103, 19, 0}, {104, 20, 0}, {108, 21, 0}, {55, 22, 0}, {40, 23, 0}, {23, 24, 0}, {24, 25, 0}, {8, 1792, 1}, {12, 1856, 1}, {13, 1920, 1}}, new int[][]{{202, 26, 0}, {203, 27, 0}, {204, 28, 0}, {205, 29, 0}, {104, 30, 0}, {105, 31, 0}, {106, 32, 0}, {107, 33, 0}, {210, 34, 0}, {211, 35, 0}, {212, 36, 0}, {213, 37, 0}, {214, 38, 0}, {215, 39, 0}, {108, 40, 0}, {109, 41, 0}, {218, 42, 0}, {219, 43, 0}, {84, 44, 0}, {85, 45, 0}, {86, 46, 0}, {87, 47, 0}, {100, 48, 0}, {101, 49, 0}, {82, 50, 0}, {83, 51, 0}, {36, 52, 0}, {55, 53, 0}, {56, 54, 0}, {39, 55, 0}, {40, 56, 0}, {88, 57, 0}, {89, 58, 0}, {43, 59, 0}, {44, 60, 0}, {90, 61, 0}, {102, 62, 0}, {103, 63, 0}, {200, 128, 1}, {201, 192, 1}, {91, 256, 1}, {51, 320, 1}, {52, 384, 1}, {53, 448, 1}, {1, -1, 1}, {18, 1984, 1}, {19, 2048, 1}, {20, 2112, 1}, {21, 2176, 1}, {22, 2240, 1}, {23, 2304, 1}, {28, 2368, 1}, {29, 2432, 1}, {30, 2496, 1}, {31, 2560, 1}}, new int[][]{{108, 512, 1}, {109, 576, 1}, {74, 640, 1}, {75, 704, 1}, {76, 768, 1}, {77, 832, 1}, {114, 896, 1}, {115, 960, 1}, {116, 1024, 1}, {117, 1088, 1}, {118, 1152, 1}, {119, 1216, 1}, {82, 1280, 1}, {83, 1344, 1}, {84, 1408, 1}, {85, 1472, 1}, {90, 1536, 1}, {91, 1600, 1}, {100, 1664, 1}, {101, 1728, 1}}};
    private static final int[][][] w = new int[][][]{new int[][]{{7, 2, 0}, {8, 3, 0}, {11, 4, 0}, {12, 5, 0}, {14, 6, 0}, {15, 7, 0}}, new int[][]{{19, 8, 0}, {20, 9, 0}, {7, 10, 0}, {8, 11, 0}, {27, 64, 1}, {18, 128, 1}}, new int[][]{{7, 1, 0}, {8, 12, 0}, {3, 13, 0}, {52, 14, 0}, {53, 15, 0}, {42, 16, 0}, {43, 17, 0}, {23, 192, 1}, {24, 1664, 1}}, new int[][]{{39, 18, 0}, {12, 19, 0}, {8, 20, 0}, {23, 21, 0}, {3, 22, 0}, {4, 23, 0}, {40, 24, 0}, {43, 25, 0}, {19, 26, 0}, {36, 27, 0}, {24, 28, 0}, {55, 256, 1}}, new int[][]{{53, 0, 0}, {2, 29, 0}, {3, 30, 0}, {26, 31, 0}, {27, 32, 0}, {18, 33, 0}, {19, 34, 0}, {20, 35, 0}, {21, 36, 0}, {22, 37, 0}, {23, 38, 0}, {40, 39, 0}, {41, 40, 0}, {42, 41, 0}, {43, 42, 0}, {44, 43, 0}, {45, 44, 0}, {4, 45, 0}, {5, 46, 0}, {10, 47, 0}, {11, 48, 0}, {82, 49, 0}, {83, 50, 0}, {84, 51, 0}, {85, 52, 0}, {36, 53, 0}, {37, 54, 0}, {88, 55, 0}, {89, 56, 0}, {90, 57, 0}, {91, 58, 0}, {74, 59, 0}, {75, 60, 0}, {50, 61, 0}, {51, 62, 0}, {52, 63, 0}, {54, 320, 1}, {55, 384, 1}, {100, 448, 1}, {101, 512, 1}, {104, 576, 1}, {103, 640, 1}}, new int[][]{{204, 704, 1}, {205, 768, 1}, {210, 832, 1}, {211, 896, 1}, {212, 960, 1}, {213, 1024, 1}, {214, 1088, 1}, {215, 1152, 1}, {216, 1216, 1}, {217, 1280, 1}, {218, 1344, 1}, {219, 1408, 1}, {152, 1472, 1}, {153, 1536, 1}, {154, 1600, 1}, {155, 1728, 1}}, new int[0][], new int[][]{{8, 1792, 1}, {12, 1856, 1}, {13, 1920, 1}}, new int[][]{{1, -1, 1}, {18, 1984, 1}, {19, 2048, 1}, {20, 2112, 1}, {21, 2176, 1}, {22, 2240, 1}, {23, 2304, 1}, {28, 2368, 1}, {29, 2432, 1}, {30, 2496, 1}, {31, 2560, 1}}};

    public CCITT1D(byte[] byArray, int n, int n2, PdfObject pdfObject) {
        this.data = byArray;
        this.bitReached = 0;
        this.columns = n;
        if (pdfObject != null) {
            int n3;
            this.BlackIs1 = pdfObject.getBoolean(1297445940);
            int n4 = pdfObject.getInt(1162902911);
            if (n4 != -1) {
                this.columns = n4;
            }
            if ((n3 = pdfObject.getInt(574572355)) > 0) {
                n2 = n3;
            }
            this.isByteAligned = pdfObject.getBoolean(-823077984);
        }
        this.width = this.columns;
        this.height = n2;
        this.scanlineStride = this.columns + 7 >> 3;
        this.bytesNeeded = n2 * this.scanlineStride;
        this.out = new BitSet(this.bytesNeeded << 3);
        this.inputBitCount = this.data.length << 3;
        this.inputBits = CCITT1D.fromByteArray(this.data, this.inputBitCount);
    }

    CCITT1D() {
    }

    public byte[] decode() {
        this.decode1DRun();
        byte[] byArray = this.createOutputFromBitset();
        if (this.BlackIs1) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)(255 - byArray[i]);
            }
        }
        return byArray;
    }

    byte[] createOutputFromBitset() {
        byte[] byArray = new byte[this.bytesNeeded];
        int n = 0;
        int n2 = 7;
        int n3 = 0;
        for (int i = 0; i < this.outPtr; ++i) {
            if (this.out.get(i)) {
                int n4 = 1 << n2;
                n3 = (byte)(n3 | n4);
                --n2;
            } else {
                --n2;
            }
            if ((i + 1) % this.width == 0 && i != 0) {
                n2 = -1;
            }
            if (n2 >= 0 || n >= byArray.length) continue;
            byArray[n] = n3;
            ++n;
            n2 = 7;
            n3 = 0;
        }
        return byArray;
    }

    private void decode1DRun() {
        while (!this.EOS) {
            if (this.isTerminating) {
                this.isTerminating = false;
                boolean bl = this.isWhite = !this.isWhite;
                if (this.isEndOfLine) {
                    this.isEndOfLine = false;
                    this.isWhite = true;
                }
            }
            boolean bl = this.isWhite;
            int n = this.getCodeWord();
            if (n <= 0) continue;
            if (bl) {
                this.out.set(this.outPtr, this.outPtr + n, true);
            }
            this.outPtr += n;
        }
    }

    private int getCodeWord() {
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = 2;
        int n5 = 14;
        int n6 = 0;
        int n7 = 0;
        if (this.isWhite) {
            n4 = 4;
            n5 = 13;
        }
        for (int i = n4; i < n5; ++i) {
            n6 = this.get1DBits(i, true) & 0xFF;
            n2 = CCITT1D.checkTables(n6, i, this.isWhite);
            if (n2 != -1) {
                n7 = i;
                i = n5;
                continue;
            }
            if (i != 8) continue;
            ++n3;
            ++this.bitReached;
        }
        if (n2 != -1) {
            this.bitReached = this.bitReached + n7 - n3;
            n = this.processCodeWord(n2, n6, n7);
        } else if (this.bitReached > this.inputBitCount) {
            this.EOS = true;
        }
        return n;
    }

    private int processCodeWord(int n, int n2, int n3) {
        boolean bl;
        int n4;
        if (this.isWhite) {
            n4 = w[n3 - 4][n][1];
            bl = w[n3 - 4][n][2] == 0;
        } else {
            n4 = b[n3 - 2][n][1];
            boolean bl2 = bl = b[n3 - 2][n][2] == 0;
        }
        if (bl) {
            this.isTerminating = true;
        }
        if (n4 == -1) {
            if (this.line != 0) {
                n4 = this.width - this.line;
            }
            this.line = 0;
            this.isWhite = true;
            this.isTerminating = false;
        }
        if (n4 != -1) {
            this.line += n4;
            if (this.line == this.width) {
                if (bl) {
                    this.line = 0;
                    this.isEndOfLine = true;
                }
            } else if (this.line > this.width) {
                this.line = 0;
                this.isEndOfLine = true;
            }
        }
        if (n3 == 12 && n2 == 1) {
            ++this.cRTC;
            if (this.cRTC == 6) {
                this.EOS = true;
            }
        } else {
            this.cRTC = 0;
        }
        if (this.cRTC != 6 && this.isEndOfLine && this.isByteAligned) {
            int n5 = this.bitReached % 8;
            int n6 = 8 - n5;
            if (n5 > 0) {
                this.bitReached += n6;
            }
        }
        return n4;
    }

    int get1DBits(int n) {
        return this.get1DBits(n, false);
    }

    private int get1DBits(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        if (bl && n > 8) {
            ++n3;
        }
        for (int i = 0; i < n; ++i) {
            if (!this.inputBits.get(i + this.bitReached)) continue;
            int n4 = 1 << n - i - 1 - n3;
            n2 |= n4;
        }
        return n2;
    }

    private static int checkTables(int n, int n2, boolean bl) {
        int n3 = -1;
        int[][] nArray = bl ? w[n2 - 4] : b[n2 - 2];
        int n4 = nArray.length;
        for (int i = 0; i < n4; ++i) {
            if (n != nArray[i][0]) continue;
            n3 = i;
            i = n4;
        }
        return n3;
    }

    private static BitSet fromByteArray(byte[] byArray, int n) {
        int n2 = 0;
        BitSet bitSet = new BitSet(n);
        byte[] byArray2 = byArray;
        int n3 = byArray2.length;
        for (int i = 0; i < n3; ++i) {
            byte by;
            byte by2 = by = byArray2[i];
            for (int j = 7; j >= 0; --j) {
                int n4 = by2 & 1 << j;
                if (n4 >= 1) {
                    bitSet.set(n2, true);
                }
                ++n2;
            }
        }
        return bitSet;
    }
}

