/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.objects.raw.CompressedObject;
import org.jpedal.objects.raw.EncryptionObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.StreamObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_boolean;

public class PdfFileReader {
    private static final int UNSET = -1;
    private static final int COMPRESSED = 1;
    private static final int LEGACY = 2;
    private int newCacheSize = -1;
    private LinearizedHintTable linHintTable;
    private boolean refTableInvalid = false;
    private static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    private byte[] lastCompressedStream = null;
    private Map lastOffsetStart;
    private Map lastOffsetEnd;
    private PdfObject compressedObj;
    private int lastFirst = -1;
    private int lastCompressedID = -1;
    private PdfObject linearObj;
    private Certificate certificate;
    private PrivateKey key;
    private PdfObject infoObject = null;
    private byte[] ID = null;
    PdfObject encyptionObj = null;
    private static final String pattern = "obj";
    private Vector_Int xref = new Vector_Int(100);
    private DecryptionFactory decryption = null;
    private byte[] encryptionPassword = null;
    private static final byte[] oldPattern = new byte[]{120, 114, 101, 102};
    private static final byte[] EOFpattern = new byte[]{37, 37, 69, 79, 70};
    private static final byte[] trailerpattern = new byte[]{116, 114, 97, 105, 108, 101, 114};
    private RandomAccessBuffer pdf_datafile = null;
    private static final byte[] endObj = new byte[]{32, 111, 98, 106};
    private static final byte[] lengthString = new byte[]{47, 76, 101, 110, 103, 116, 104};
    private static final byte[] startStream = new byte[]{115, 116, 114, 101, 97, 109};
    private Vector_Int offset = new Vector_Int(2000);
    private Vector_boolean isCompressed = new Vector_boolean(2000);
    private Vector_Int generation = new Vector_Int(2000);
    public static int alwaysCacheInMemory = 16384;
    private long eof;
    private int[] ObjLengthTable;

    public PdfObject getInfoObject() {
        return this.infoObject;
    }

    public void setCacheSize(int n) {
        this.newCacheSize = n;
    }

    public void init(RandomAccessBuffer randomAccessBuffer) {
        block2: {
            this.pdf_datafile = randomAccessBuffer;
            try {
                this.eof = randomAccessBuffer.length();
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
    }

    public final void readObject(PdfObject pdfObject) {
        if (pdfObject.isDataExternal() && this.linHintTable != null) {
            this.readExternalObject(pdfObject);
        } else {
            byte[] byArray;
            String string = pdfObject.getObjectRefAsString();
            boolean bl = this.isCompressed(string);
            pdfObject.setCompressedStream(bl);
            if (bl) {
                byArray = this.readCompressedObject(pdfObject, string);
            } else {
                this.movePointer(string);
                if (string.charAt(0) == '<') {
                    byArray = this.readObjectData(-1, pdfObject);
                } else {
                    int n = string.indexOf(32);
                    int n2 = Integer.parseInt(string.substring(0, n));
                    if (this.ObjLengthTable == null || this.refTableInvalid) {
                        byArray = this.getPointer() == 0L ? new byte[]{} : this.readObjectData(-1, pdfObject);
                    } else if (n2 > this.ObjLengthTable.length || this.ObjLengthTable[n2] == 0) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog(string + " cannot have offset 0");
                        }
                        byArray = new byte[]{};
                    } else {
                        byArray = this.readObjectData(this.ObjLengthTable[n2], pdfObject);
                    }
                }
            }
            if (byArray.length > 1) {
                ObjectDecoder objectDecoder = new ObjectDecoder(this);
                objectDecoder.readDictionaryAsObject(pdfObject, 0, byArray);
            }
        }
    }

    private void readExternalObject(PdfObject pdfObject) {
        int n = pdfObject.getObjectRefID();
        int n2 = pdfObject.getObjectRefGeneration();
        byte[] byArray = this.readObjectAsByteArray(pdfObject, this.isCompressed(n, n2), n, n2);
        pdfObject.setStatus(2);
        pdfObject.setUnresolvedData(byArray, 540096309);
        ObjectDecoder objectDecoder = new ObjectDecoder(this);
        objectDecoder.resolveFully(pdfObject);
    }

    private byte[] readCompressedObject(PdfObject pdfObject, String string) {
        byte[] byArray;
        int n = Integer.parseInt(string.substring(0, string.indexOf(32)));
        int n2 = this.getCompressedStreamObject(string);
        String string2 = n2 + " 0 R";
        String string3 = null;
        int n3 = this.lastFirst;
        boolean bl = true;
        byte[] byArray2 = this.lastCompressedStream;
        HashMap hashMap = this.lastOffsetStart;
        HashMap hashMap2 = this.lastOffsetEnd;
        PdfObject pdfObject2 = null;
        if (this.lastOffsetStart != null && n2 == this.lastCompressedID) {
            string3 = (String)this.lastOffsetStart.get(String.valueOf(n));
        }
        while (string3 == null) {
            if (pdfObject2 != null) {
                this.compressedObj = pdfObject2;
            } else if (n2 != this.lastCompressedID) {
                bl = false;
                this.movePointer(string2);
                byArray = this.readObjectData(this.ObjLengthTable[n2], null);
                this.compressedObj = new CompressedObject(string2);
                ObjectDecoder objectDecoder = new ObjectDecoder(this);
                objectDecoder.readDictionaryAsObject(this.compressedObj, 0, byArray);
            }
            hashMap = new HashMap();
            hashMap2 = new HashMap();
            n3 = this.compressedObj.getInt(960643930);
            byArray2 = this.compressedObj.getDecodedStream();
            this.extractCompressedObjectOffset(hashMap, hashMap2, n3, byArray2, n2);
            string3 = (String)hashMap.get(String.valueOf(n));
            pdfObject2 = this.compressedObj.getDictionary(894663815);
            if (pdfObject2 != null) continue;
        }
        if (!bl) {
            this.lastCompressedStream = byArray2;
            this.lastCompressedID = n2;
            this.lastOffsetStart = hashMap;
            this.lastOffsetEnd = hashMap2;
            this.lastFirst = n3;
        }
        int n4 = n3 + Integer.parseInt(string3);
        int n5 = byArray2.length;
        String string4 = (String)hashMap2.get(String.valueOf(n));
        if (string4 != null) {
            n5 = n3 + Integer.parseInt(string4);
        }
        int n6 = n5 - n4;
        byArray = new byte[n6];
        System.arraycopy(byArray2, n4, byArray, 0, n6);
        pdfObject.setInCompressedStream(true);
        return byArray;
    }

    private PdfObject readCompressedStream(int n) throws PdfException {
        PdfObject pdfObject = null;
        PdfObject pdfObject2 = null;
        while (n != -1) {
            int[] nArray;
            this.movePointer(n);
            byte[] byArray = this.readObjectData(-1, null);
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 32;
            int n3 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                char c = (char)byArray[i];
                if (c == '\n' || c == '\r') {
                    c = ' ';
                }
                if (c == ' ' && n2 == 32) {
                    n3 = 0;
                } else if (c == pattern.charAt(n3)) {
                    ++n3;
                } else {
                    n3 = 0;
                    stringBuilder.append(c);
                }
                if (n3 == 3) break;
                n2 = c;
            }
            stringBuilder.append('R');
            CompressedObject compressedObject = new CompressedObject(stringBuilder.toString());
            compressedObject.setCompressedStream(true);
            ObjectDecoder objectDecoder = new ObjectDecoder(this);
            objectDecoder.readDictionaryAsObject(compressedObject, 0, byArray);
            int[] nArray2 = ((PdfObject)compressedObject).getIntArray(39);
            byte[] byArray2 = compressedObject.getDecodedStream();
            if (byArray2 == null) {
                byArray2 = this.readStream(compressedObject, true, true, false, false, true, null);
            }
            if ((nArray = ((PdfObject)compressedObject).getIntArray(1043608929)) == null) {
                this.readCompressedOffsets(0, 0, ((PdfObject)compressedObject).getInt(590957109), nArray2, byArray2);
            } else {
                int n4 = nArray.length;
                int n5 = 0;
                for (int i = 0; i < n4; i += 2) {
                    n5 = this.readCompressedOffsets(n5, nArray[i], nArray[i + 1], nArray2, byArray2);
                }
            }
            if (pdfObject2 == null) {
                byte[][] byArray3;
                pdfObject2 = ((PdfObject)compressedObject).getDictionary(574570308);
                pdfObject = ((PdfObject)compressedObject).getDictionary(1113489015);
                if (pdfObject != null && (byArray3 = ((PdfObject)compressedObject).getStringArray(6420)) != null) {
                    this.ID = byArray3[0];
                }
                this.infoObject = ((PdfObject)compressedObject).getDictionary(423507519);
            }
            if (this.linearObj != null) {
                n = -1;
                continue;
            }
            n = ((PdfObject)compressedObject).getInt(541209926);
        }
        if (pdfObject != null) {
            this.setupDecryption(pdfObject);
        }
        this.ObjLengthTable = this.calculateObjectLength((int)this.eof);
        return pdfObject2;
    }

    public final byte[] readStream(PdfObject pdfObject, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string) {
        int n;
        byte[] byArray;
        boolean bl6 = pdfObject.isCached();
        byte[] byArray2 = null;
        if (!bl6) {
            byArray2 = pdfObject.getDecodedStream();
        }
        if (byArray2 == null) {
            int n2;
            block34: {
                block33: {
                    byArray = pdfObject.stream;
                    if (bl6) {
                        try {
                            if (!(this.decryption == null || bl5 || !this.decryption.getBooleanValue(102) && bl4)) {
                                this.decryption.decrypt(null, pdfObject.getObjectRefAsString(), false, string, false, false);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            byArray = null;
                            if (!LogWriter.isOutput()) break block33;
                            LogWriter.writeLog("Exception " + exception);
                        }
                    }
                }
                if (byArray != null) {
                    try {
                        if (!(this.decryption == null || bl5 || !this.decryption.getBooleanValue(102) && bl4 || pdfObject.getObjectType() == 2087749783 && pdfObject.getObjectRefAsString().startsWith("["))) {
                            byArray = this.decryption.decrypt(byArray, pdfObject.getObjectRefAsString(), false, null, false, false);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        byArray = null;
                        if (!LogWriter.isOutput()) break block34;
                        LogWriter.writeLog("Exception " + exception + " with " + pdfObject.getObjectRefAsString());
                    }
                }
            }
            if (bl3) {
                pdfObject.stream = null;
            }
            n = 1;
            if (byArray != null || bl6) {
                int n3;
                int n4;
                n2 = 1;
                int n5 = 1;
                int n6 = pdfObject.getInt(959926393);
                if (n6 != -1) {
                    n2 = n6;
                }
                if ((n4 = pdfObject.getInt(959726687)) != -1) {
                    n5 = n4;
                }
                if ((n3 = pdfObject.getInt(1043816557)) != -1) {
                    n = n3;
                }
                if (n2 * n5 == 1) {
                    n5 = n;
                }
                PdfArrayIterator pdfArrayIterator = pdfObject.getMixedArray(1011108731);
                int n7 = -1;
                if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
                    n7 = pdfArrayIterator.getNextValueAsConstant(false);
                }
                if (pdfArrayIterator != null && n7 != -1 && n7 != 1399277700 && n7 != 1180911742) {
                    try {
                        PdfFilteredReader pdfFilteredReader = new PdfFilteredReader();
                        byArray = pdfFilteredReader.decodeFilters(ObjectUtils.setupDecodeParms(pdfObject, this), byArray, pdfArrayIterator, n5, n2, string);
                        pdfObject.setStreamMayBeCorrupt(pdfFilteredReader.hasError());
                    }
                    catch (Exception exception) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("[PDF] Problem " + exception + " decompressing stream ");
                        }
                        byArray = null;
                        bl6 = false;
                    }
                    n = 1;
                } else if (byArray != null && n != -1 && n < byArray.length) {
                    if (byArray.length != n && n > 0) {
                        byte[] byArray3 = new byte[n];
                        System.arraycopy(byArray, 0, byArray3, 0, n);
                        byArray = byArray3;
                    } else if (byArray.length == 1 && n == 0) {
                        byArray = new byte[]{};
                    }
                }
            }
            if (byArray != null && bl) {
                pdfObject.setDecodedStream(byArray);
            }
            if (bl2 && bl6) {
                byte[] byArray4;
                block35: {
                    n2 = (int)new File(string).length();
                    byArray4 = new byte[n2];
                    try {
                        new BufferedInputStream(new FileInputStream(string)).read(byArray4);
                    }
                    catch (Exception exception) {
                        if (!LogWriter.isOutput()) break block35;
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                }
                if (n != 1 && n < n2) {
                    byte[] byArray5 = new byte[n];
                    System.arraycopy(byArray4, 0, byArray5, 0, n);
                    byArray4 = byArray5;
                }
                return byArray4;
            }
        } else {
            byArray = byArray2;
        }
        if (byArray == null) {
            return null;
        }
        n = byArray.length;
        byte[] byArray6 = new byte[n];
        System.arraycopy(byArray, 0, byArray6, 0, n);
        return byArray6;
    }

    private PdfObject readLegacyReferenceTable(int n, int n2) throws PdfException {
        int n3 = 0;
        int n4 = 1024;
        PdfObject pdfObject = null;
        PdfObject pdfObject2 = null;
        do {
            int n5;
            byte[] byArray;
            try {
                byArray = this.readTrailer(n4, n, n2);
            }
            catch (Exception exception) {
                block31: {
                    try {
                        this.closeFile();
                    }
                    catch (IOException iOException) {
                        if (!LogWriter.isOutput()) break block31;
                        LogWriter.writeLog("Exception " + exception + " closing file");
                    }
                }
                throw new PdfException("Exception " + exception + " reading trailer");
            }
            if (byArray == null) break;
            int n6 = byArray.length;
            for (n5 = 0; n5 < n6 && (byArray[n5] != 116 || byArray[n5 + 1] != 114 || byArray[n5 + 2] != 97 || byArray[n5 + 3] != 105 || byArray[n5 + 4] != 108 || byArray[n5 + 5] != 101 || byArray[n5 + 6] != 114); ++n5) {
            }
            int n7 = n5;
            if (n5 == byArray.length) break;
            while (byArray[n5] != 60 && byArray[n5 - 1] != 60) {
                ++n5;
            }
            CompressedObject compressedObject = new CompressedObject("1 0 R");
            ObjectDecoder objectDecoder = new ObjectDecoder(this);
            objectDecoder.readDictionary(compressedObject, ++n5, byArray, -1, true);
            int n8 = 0;
            while (true) {
                if (byArray[n5] == 60 && byArray[n5 - 1] == 60) {
                    ++n8;
                    ++n5;
                } else if (byArray[n5] == 91) {
                    ++n5;
                    while (byArray[n5] != 93 && ++n5 != byArray.length) {
                    }
                } else if (byArray[n5] == 62 && byArray[n5 - 1] == 62) {
                    --n8;
                    ++n5;
                }
                if (n8 == 0) break;
                ++n5;
            }
            int n9 = ((PdfObject)compressedObject).getInt(910911090);
            if (n9 != -1) {
                n = n9;
            } else {
                boolean bl = true;
                while (byArray[n5] != 116 && byArray[n5 + 1] != 120 && byArray[n5 + 2] != 114 && byArray[n5 + 3] != 101 && byArray[n5 + 4] != 102) {
                    if (byArray[n5] == 111 && byArray[n5 + 1] == 98 && byArray[n5 + 2] == 106) {
                        bl = false;
                        break;
                    }
                    ++n5;
                }
                if (bl) {
                    n5 += 8;
                    while (n5 < n6 && (byArray[n5] == 10 || byArray[n5] == 32 || byArray[n5] == 13)) {
                        ++n5;
                    }
                    int n10 = n5;
                    while (n5 < n6 && byArray[n5] != 10 && byArray[n5] != 32 && byArray[n5] != 13) {
                        ++n5;
                    }
                    if (n10 != n5) {
                        n = NumberUtils.parseInt(n10, n5, byArray);
                    }
                }
            }
            n5 = 0;
            while (byArray[n5] == 13 || byArray[n5] == 10 || byArray[n5] == 9) {
                ++n5;
            }
            if (n == -1) {
                if (!LogWriter.isOutput()) continue;
                LogWriter.writeLog("No startRef");
                continue;
            }
            if (byArray[n5] == 120 && byArray[n5 + 1] == 114 && byArray[n5 + 2] == 101 && byArray[n5 + 3] == 102) {
                n5 = 5;
                while (byArray[n5] == 10 || byArray[n5] == 32 || byArray[n5] == 13) {
                    ++n5;
                }
                n3 = this.readXRefs(this.xref, n3, byArray, n7, n5);
                if (pdfObject2 == null) {
                    byte[][] byArray2;
                    pdfObject2 = ((PdfObject)compressedObject).getDictionary(574570308);
                    pdfObject = ((PdfObject)compressedObject).getDictionary(1113489015);
                    if (pdfObject != null && (byArray2 = ((PdfObject)compressedObject).getStringArray(6420)) != null) {
                        this.ID = byArray2[0];
                    }
                    this.infoObject = ((PdfObject)compressedObject).getDictionary(423507519);
                }
                if ((n = ((PdfObject)compressedObject).getInt(541209926)) != -1 && (long)n < this.eof) {
                    n4 = 1024;
                    this.xref.addElement(n);
                    continue;
                }
                n = -1;
                continue;
            }
            n = -1;
            pdfObject2 = new PageObject(this.findOffsets());
            this.readObject(pdfObject2);
            this.refTableInvalid = true;
        } while (n != -1);
        if (pdfObject != null) {
            this.setupDecryption(pdfObject);
        }
        if (!this.refTableInvalid) {
            this.ObjLengthTable = this.calculateObjectLength(n2);
        }
        return pdfObject2;
    }

    private void setupDecryption(PdfObject pdfObject) throws PdfSecurityException {
        try {
            this.decryption = this.certificate != null ? new DecryptionFactory(this.ID, this.certificate, this.key) : new DecryptionFactory(this.ID, this.encryptionPassword);
            if (this.encyptionObj == null) {
                this.encyptionObj = new EncryptionObject(new String(pdfObject.getUnresolvedData()));
                this.readObject(this.encyptionObj);
            }
            this.decryption.readEncryptionObject(this.encyptionObj);
        }
        catch (Error error) {
            throw new RuntimeException("This PDF file is encrypted and JPedal needs an additional library to \ndecode on the classpath (we recommend bouncycastle library).\nThere is additional explanation at http://www.idrsolutions.com/additional-jars\n");
        }
    }

    public int getPDFflag(Integer n) {
        if (this.decryption == null) {
            return -1;
        }
        return this.decryption.getPDFflag(n);
    }

    private int readFirstStartRef() throws PdfException {
        int n;
        this.refTableInvalid = false;
        int n2 = -1;
        int n3 = 1019;
        StringBuilder stringBuilder = new StringBuilder(10);
        int n4 = 1024;
        byte[] byArray = new byte[n4];
        int[] nArray = new int[]{37, 37, 69, 79};
        int n5 = 3;
        boolean bl = false;
        try {
            int n6;
            long l;
            block21: {
                l = this.eof;
                n = 255;
                do {
                    byte[] byArray2 = this.getBytes(l - (long)n, n);
                    n6 = 0;
                    for (int i = n - 1; i > -1; --i) {
                        if (!bl) {
                            n5 = 3;
                        }
                        if (byArray2[i] == nArray[n5]) {
                            --n5;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        --n6;
                        if (n5 >= 0) continue;
                        i = -1;
                    }
                    if (n5 >= 0) continue;
                    l -= (long)n6;
                    break block21;
                } while ((l -= (long)n) >= 0L);
                l = this.eof;
            }
            int n7 = (int)(l - (long)n4);
            if (n7 < 0) {
                n7 = 0;
                n6 = (int)this.eof;
                byArray = new byte[n6];
                n3 = n6 + 3;
            }
            byArray = this.getBytes(n7, byArray.length);
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + exception + " reading last 1024 bytes");
            }
            throw new PdfException(exception + " reading last 1024 bytes");
        }
        n = byArray.length;
        if (n3 > n) {
            n3 = n - 5;
        }
        while (!(n3 <= -1 || (byArray[n3] == 116 && byArray[n3 + 1] == 120 || byArray[n3] == 114 && byArray[n3 + 1] == 116) && byArray[n3 + 2] == 114 && byArray[n3 + 3] == 101 && byArray[n3 + 4] == 102)) {
            --n3;
        }
        if (n3 == -1) {
            block22: {
                try {
                    this.closeFile();
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block22;
                    LogWriter.writeLog("Exception " + iOException + " closing file");
                }
            }
            throw new PdfException("No Startxref found in last 1024 bytes ");
        }
        n3 += 5;
        while (n3 < 1024 && (byArray[n3] == 10 || byArray[n3] == 32 || byArray[n3] == 13)) {
            ++n3;
        }
        while (n3 < 1024 && byArray[n3] != 10 && byArray[n3] != 32 && byArray[n3] != 13) {
            stringBuilder.append((char)byArray[n3]);
            ++n3;
        }
        if (stringBuilder.length() > 0) {
            n2 = Integer.parseInt(stringBuilder.toString());
        }
        if (n2 == -1) {
            block23: {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("No Startref found in last 1024 bytes ");
                }
                try {
                    this.closeFile();
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block23;
                    LogWriter.writeLog("Exception " + iOException + " closing file");
                }
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        return n2;
    }

    public final PdfObject readReferenceTable(PdfObject pdfObject) throws PdfException {
        Object object;
        this.linearObj = pdfObject;
        int n = -1;
        int n2 = (int)this.eof;
        boolean bl = false;
        if (pdfObject == null) {
            n = this.readFirstStartRef();
        } else {
            object = this.getBuffer();
            int n3 = ((byte[])object).length;
            int n4 = 5;
            for (int i = 0; i < n3; ++i) {
                if (object[i] == 101 && object[i + 1] == 110 && object[i + 2] == 100 && object[i + 3] == 111 && object[i + 4] == 98 && object[i + 5] == 106) {
                    n4 = i + 6;
                }
                if (object[i] == 120 && object[i + 1] == 114 && object[i + 2] == 101 && object[i + 3] == 102) {
                    n = i;
                    i = n3;
                    continue;
                }
                if (object[i] != 88 || object[i + 1] != 82 || object[i + 2] != 101 || object[i + 3] != 102) continue;
                bl = true;
                n = n4;
                while (object[n] == 10 || object[n] == 13 || object[n] == 32) {
                    ++n;
                }
                i = n3;
            }
        }
        this.xref.addElement(n);
        if (n >= n2) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Pointer not if file - trying to manually find startref");
            }
            this.refTableInvalid = true;
            object = new PageObject(this.findOffsets());
            this.readObject((PdfObject)object);
            return object;
        }
        if (bl || this.isCompressedStream(n, n2)) {
            return this.readCompressedStream(n);
        }
        return this.readLegacyReferenceTable(n, n2);
    }

    public void spoolStreamDataToDisk(File file, long l) throws Exception {
        BufferedOutputStream bufferedOutputStream;
        block19: {
            this.movePointer(l);
            boolean bl = false;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            int n = -1;
            int n2 = 0;
            boolean bl2 = false;
            int n3 = n;
            int n4 = 0;
            boolean bl3 = false;
            boolean bl4 = false;
            if (n < 1) {
                n = 128;
            }
            int n5 = 0;
            int n6 = n;
            byte[] byArray = new byte[n6];
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            byte[] byArray2 = null;
            boolean bl5 = false;
            try {
                int n10 = n - 1;
                int n11 = -n;
                while (true) {
                    if (++n10 == n) {
                        long l2 = this.getPointer();
                        if (l == -1L) {
                            l = l2;
                        }
                        if (l2 + (long)n > this.eof) {
                            n = (int)(this.eof - l2);
                        }
                        byArray2 = new byte[n += 6];
                        this.read(byArray2);
                        n11 += n10;
                        n10 = 0;
                    }
                    void var26_24 = byArray2[n10];
                    boolean bl6 = false;
                    n7 = var26_24 == ObjectDecoder.endPattern[n7] && !bl5 ? ++n7 : 0;
                    n8 = bl4 && var26_24 == endObj[n8] && !bl5 ? ++n8 : 0;
                    if (bl2 && (bl || var26_24 != 13 && var26_24 != 10)) {
                        bufferedOutputStream.write((int)var26_24);
                        bl = true;
                    }
                    n2 = n2 < 6 && var26_24 == startStream[n2] ? ++n2 : 0;
                    if (!bl2 && n2 == 6) {
                        bl2 = true;
                    }
                    if (!bl3 && n3 != -1) {
                        if (!bl4 && var26_24 == lengthString[n9] && !bl5) {
                            if (++n9 == 6) {
                                bl3 = true;
                            }
                        } else {
                            n9 = 0;
                        }
                    }
                    if (n7 == 6 || n8 == 4) {
                        if (!bl3) break;
                        n7 = 0;
                        n8 = 0;
                    }
                    if (!bl3 || n4 < n3) {
                        if (!bl6 && !bl5) {
                            byArray[n5] = var26_24;
                            if (++n5 == n6) {
                                n6 = n6 < 0x200000 ? (n6 *= 2) : (n6 += 100000);
                                byte[] byArray3 = new byte[n6];
                                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                                byArray = byArray3;
                            }
                        }
                        ++n4;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!LogWriter.isOutput()) break block19;
                LogWriter.writeLog("Exception " + exception + " reading object");
            }
        }
        if (bufferedOutputStream != null) {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
    }

    private boolean isCompressedStream(int n, int n2) throws PdfException {
        int n3 = 50;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = new int[]{79, 98, 106, 83, 116, 109};
        int[] nArray2 = new int[]{88, 82, 101, 102};
        int n7 = -1;
        boolean bl = true;
        while (true) {
            if (n + n3 > n2) {
                n3 = n2 - n;
            }
            if (n3 < 0) {
                n3 = 50;
            }
            byte[] byArray = this.getBytes(n, n3);
            if (bl && byArray[0] == 114 && byArray[1] == 101 && byArray[2] == 102) {
                n4 = 1;
            }
            bl = false;
            for (int i = 0; i < n3; ++i) {
                byte by = byArray[i];
                if (by == oldPattern[n4] && n7 != 1) {
                    ++n4;
                    n7 = 2;
                } else if (by == nArray[n5] && (n5 == 0 || n7 == 1)) {
                    ++n5;
                    n7 = 1;
                } else if (by == nArray2[n6] && (n6 == 0 || n7 == 1)) {
                    ++n6;
                    n7 = 1;
                } else {
                    n4 = 0;
                    n5 = 0;
                    n6 = 0;
                    n7 = -1;
                }
                if (n4 == 3 || n5 == 4 || n6 == 3) break;
            }
            if (n4 == 3 || n5 == 4 || n6 == 3) break;
            n += n3;
        }
        if (n7 == -1) {
            block14: {
                try {
                    this.closeFile();
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block14;
                    LogWriter.writeLog("Exception 1 closing file");
                }
            }
            throw new PdfException("Exception unable to find ref or obj in trailer");
        }
        return n7 == 1;
    }

    void closeFile() throws IOException {
        if (this.pdf_datafile != null) {
            this.pdf_datafile.close();
            this.pdf_datafile = null;
        }
    }

    private byte[] readTrailer(int n, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            if (n2 + n > n3) {
                n = n3 - n2;
            }
            if (n == 0) break;
            byte[] byArray = this.getBytes(n2, n);
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                byte by = byArray[i];
                n4 = by == EOFpattern[n4] ? ++n4 : 0;
                n5 = by == trailerpattern[n5] ? ++n5 : 0;
                if (n5 == 7) {
                    ++n6;
                    n5 = 0;
                }
                if (n4 != 4 && n6 != 2) continue;
                for (int j = 0; j < i + 1; ++j) {
                    byteArrayOutputStream.write(byArray[j]);
                }
                i = n;
                bl = true;
            }
            if (!bl) {
                byteArrayOutputStream.write(byArray);
            }
            n2 += n;
        } while (n4 != 4 && n6 != 2);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getBuffer() {
        return this.pdf_datafile.getPdfBuffer();
    }

    private static int getWord(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (byArray[n + i] & 0xFF);
        }
        return n3;
    }

    private int readXRefs(Vector_Int vector_Int, int n, byte[] byArray, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = true;
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        while (n3 < n2) {
            int n4;
            int n5 = n3;
            int n6 = -1;
            while (byArray[n3] != 10 && byArray[n3] != 13) {
                if (n6 == -1 && byArray[n3] == 37) {
                    n6 = n3 - 1;
                }
                ++n3;
            }
            if (n6 == -1) {
                n6 = n3 - 1;
            }
            while (byArray[n5] == 32) {
                ++n5;
            }
            while (byArray[n6] == 32) {
                --n6;
            }
            ++n3;
            int n7 = 0;
            int n8 = n6 - n5 + 1;
            if (n8 <= 0) continue;
            int n9 = 1;
            for (n4 = 1; n4 < n8; ++n4) {
                int n10 = byArray[n5 + n4];
                if (n10 == 32 && n9 != 32) {
                    nArray[n7] = n4;
                    ++n7;
                } else if (n10 != 32 && n9 == 32) {
                    nArray2[n7] = n4;
                }
                n9 = n10;
            }
            nArray[n7] = n8;
            if (++n7 == 1) {
                if (bl) {
                    bl = false;
                    continue;
                }
                n = NumberUtils.parseInt(n5, n5 + nArray[0], byArray);
                bl = true;
                continue;
            }
            if (n7 == 2) {
                n = NumberUtils.parseInt(n5, n5 + nArray[0], byArray);
                continue;
            }
            int n11 = NumberUtils.parseInt(n5, n5 + nArray[0], byArray);
            int n12 = NumberUtils.parseInt(n5 + nArray2[1], n5 + nArray[1], byArray);
            char c = (char)byArray[n5 + nArray2[2]];
            if (c == 'n') {
                n4 = 0;
                int n13 = 20;
                if ((long)(n11 + n13) > this.eof) {
                    n13 = (int)(this.eof - (long)n11);
                }
                if (n13 > 0) {
                    byte[] byArray2 = this.getBytes(n11, n13);
                    for (int i = 4; i < n13; ++i) {
                        if (byArray2[i - 3] != 32 && byArray2[i - 3] != 10 || byArray2[i - 2] != 111 || byArray2[i - 1] != 98 || byArray2[i] != 106) continue;
                        n4 = 1;
                        i = n13;
                    }
                    if (n4 != 0 && bl2) {
                        bl2 = false;
                        if (byArray2[0] == 48 && byArray2[1] != 48 && n == 1) {
                            n = 0;
                        } else if (byArray2[0] == 49 && byArray2[1] == 32) {
                            n = 1;
                        }
                    }
                    if (n4 != 0) {
                        this.storeObjectOffset(n, n11, n12, false, false);
                        vector_Int.addElement(n11);
                    }
                }
                ++n;
                continue;
            }
            if (c != 'f') continue;
            ++n;
        }
        return n;
    }

    private void extractCompressedObjectOffset(Map map, Map map2, int n, byte[] byArray, int n2) {
        String string = null;
        for (int i = 0; i < n; ++i) {
            int n3;
            if (byArray.length == 0) continue;
            while (byArray[i] == 10 || byArray[i] == 13 || byArray[i] == 32) {
                ++i;
            }
            int n4 = i;
            while (byArray[i] != 32 && byArray[i] != 13 && byArray[i] != 10) {
                ++i;
            }
            int n5 = i - 1;
            int n6 = n5 - n4 + 1;
            char[] cArray = new char[n6];
            for (n3 = 0; n3 < n6; ++n3) {
                cArray[n3] = (char)byArray[n4 + n3];
            }
            String string2 = new String(cArray);
            int n7 = NumberUtils.parseInt(n4, n4 + n6, byArray);
            while (byArray[i] == 32 || byArray[i] == 13 || byArray[i] == 10) {
                ++i;
            }
            int n8 = i;
            while (byArray[i] != 32 && byArray[i] != 13 && byArray[i] != 10 && i < n) {
                ++i;
            }
            int n9 = i - 1;
            n6 = n9 - n8 + 1;
            cArray = new char[n6];
            for (n3 = 0; n3 < n6; ++n3) {
                cArray[n3] = (char)byArray[n8 + n3];
            }
            String string3 = new String(cArray);
            if ((long)n2 != this.getOffset(n7)) continue;
            map.put(string2, string3);
            if (string != null) {
                map2.put(string, string3);
            }
            string = string2;
        }
    }

    private int readCompressedOffsets(int n, int n2, int n3, int[] nArray, byte[] byArray) throws PdfException {
        int[] nArray2 = new int[]{1, 0, 0};
        boolean bl = false;
        block5: for (int i = 0; i < n3; ++i) {
            int n4;
            int[] nArray3 = new int[3];
            for (n4 = 0; n4 < 3; ++n4) {
                if (nArray[n4] == 0) {
                    nArray3[n4] = nArray2[n4];
                    continue;
                }
                nArray3[n4] = PdfFileReader.getWord(byArray, n, nArray[n4]);
                n += nArray[n4];
            }
            switch (nArray3[0]) {
                case 0: {
                    ++n2;
                    bl = nArray3[1] == 0 && nArray3[2] == 0;
                    continue block5;
                }
                case 1: {
                    n4 = nArray3[1];
                    int n5 = nArray3[2];
                    boolean bl2 = true;
                    if (n2 == n4) {
                        int n6;
                        bl2 = false;
                        int n7 = 20;
                        byte[] byArray2 = this.getBytes(n2, n7);
                        int n8 = 0;
                        for (n6 = 0; n6 < n7; ++n6) {
                            if (byArray2[n6] != 32 && byArray2[n6] != 10 && byArray2[n6] != 13) continue;
                            n8 = n6;
                            n6 = n7;
                        }
                        if (n8 > 0 && (n6 = NumberUtils.parseInt(0, n8, byArray2)) == n2) {
                            bl2 = true;
                        }
                    }
                    if (bl2 || !bl) {
                        this.storeObjectOffset(n2, n4, n5, false, false);
                    }
                    ++n2;
                    continue block5;
                }
                case 2: {
                    n4 = nArray3[1];
                    this.storeObjectOffset(n2, n4, 0, true, false);
                    ++n2;
                    continue block5;
                }
                default: {
                    throw new PdfException("Exception Unsupported Compression mode with value " + nArray3[0]);
                }
            }
        }
        return n;
    }

    byte[] readFDFData() throws IOException {
        int n = (int)this.pdf_datafile.length();
        this.pdf_datafile.readLine();
        int n2 = (int)this.pdf_datafile.getFilePointer();
        byte[] byArray = new byte[n -= n2];
        this.pdf_datafile.read(byArray);
        return byArray;
    }

    private int[] calculateObjectLength(int n) {
        int n2;
        int n3;
        this.xref.addElement(n);
        int[] nArray = this.xref.get();
        int n4 = nArray.length;
        int[] nArray2 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray2[n3] = n3;
        }
        nArray2 = Sorts.quicksort(nArray, nArray2);
        n3 = this.offset.getCapacity();
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        int[] nArray5 = this.offset.get();
        boolean[] blArray = this.isCompressed.get();
        for (n2 = 0; n2 < n3; ++n2) {
            if (blArray[n2]) continue;
            nArray4[n2] = nArray5[n2];
            nArray3[n2] = n2;
        }
        nArray3 = Sorts.quicksort(nArray4, nArray3);
        n2 = 0;
        while (nArray4[nArray3[n2]] == 0) {
            ++n2;
        }
        int n5 = nArray4[nArray3[n2]];
        int n6 = 0;
        while (nArray[nArray2[n6]] < n5 + 1) {
            ++n6;
        }
        int[] nArray6 = new int[n3];
        while (n2 < n3 - 1) {
            int n7 = nArray4[nArray3[n2 + 1]];
            int n8 = n7 - n5 - 1;
            if (nArray[nArray2[n6]] < n7) {
                n8 = nArray[nArray2[n6]] - n5 - 1;
                while (nArray[nArray2[n6]] < n7 + 1) {
                    ++n6;
                }
            }
            nArray6[nArray3[n2]] = n8;
            n5 = n7;
            while (nArray[nArray2[n6]] < n5 + 1) {
                ++n6;
            }
            ++n2;
        }
        nArray6[nArray3[n2]] = nArray[nArray2[n6]] - n5 - 1;
        return nArray6;
    }

    private void movePointer(int n, int n2) {
        this.movePointer(this.offset.elementAt(n));
    }

    public long getOffset(int n) {
        return this.offset.elementAt(n);
    }

    public byte[] getBytes(long l, int n) {
        byte[] byArray;
        block2: {
            byArray = new byte[n];
            this.movePointer(l);
            try {
                this.pdf_datafile.read(byArray);
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
        return byArray;
    }

    private String findOffsets() throws PdfSecurityException {
        String string;
        block7: {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Corrupt xref table - trying to find objects manually");
            }
            string = "";
            String string2 = null;
            this.movePointer(0L);
            while (true) {
                int n;
                int n2;
                block6: {
                    n2 = (int)this.getPointer();
                    try {
                        string2 = this.pdf_datafile.readLine();
                    }
                    catch (Exception exception) {
                        if (!LogWriter.isOutput()) break block6;
                        LogWriter.writeLog("Exception " + exception + " reading line");
                    }
                }
                if (string2 == null) break block7;
                if (string2.contains(" obj")) {
                    n = string2.indexOf(32);
                    if (n <= -1) continue;
                    this.storeObjectOffset(Integer.parseInt(string2.substring(0, n)), n2, 1, false, true);
                    continue;
                }
                if (string2.contains("/Root")) {
                    int n3 = string2.indexOf("/Root") + 5;
                    n = string2.indexOf(82, n3);
                    if (n <= -1) continue;
                    string = string2.substring(n3, n + 1).trim();
                    continue;
                }
                if (string2.contains("/Encrypt")) break;
            }
            throw new PdfSecurityException("Corrupted, encrypted file");
        }
        return string;
    }

    public void storeLinearizedTables(LinearizedHintTable linearizedHintTable) {
        this.linHintTable = linearizedHintTable;
    }

    public void dispose() {
        block6: {
            if (this.decryption != null) {
                this.decryption.flush();
                this.decryption.dispose();
            }
            if (this.decryption != null) {
                this.decryption.cipher = null;
            }
            this.decryption = null;
            this.compressedObj = null;
            if (this.linHintTable != null) {
                this.linHintTable = null;
            }
            this.offset = null;
            this.generation = null;
            this.isCompressed = null;
            try {
                if (this.pdf_datafile != null) {
                    this.pdf_datafile.close();
                }
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
        this.pdf_datafile = null;
        this.xref = null;
    }

    private void movePointer(String string) {
        long l = this.getOffset(string);
        this.movePointer(l);
    }

    public final String getType() {
        String string;
        block3: {
            string = "";
            try {
                this.movePointer(0L);
                string = this.pdf_datafile.readLine();
                int n = string.indexOf("%PDF");
                if (n != -1) {
                    string = string.substring(n + 5);
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception " + exception + " in reading type");
            }
        }
        return string;
    }

    private void movePointer(long l) {
        block5: {
            try {
                if (l > this.pdf_datafile.length()) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Attempting to access ref outside file");
                    }
                } else {
                    this.pdf_datafile.seek(l);
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Exception " + exception + " moving pointer to  " + l + " in file.");
            }
        }
    }

    private void read(byte[] byArray) throws IOException {
        this.pdf_datafile.read(byArray);
    }

    private long getPointer() {
        long l;
        block2: {
            l = 0L;
            try {
                l = this.pdf_datafile.getFilePointer();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception " + exception + " getting pointer in file");
            }
        }
        return l;
    }

    private void storeObjectOffset(int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = 0;
        int n5 = 0;
        if (n < this.generation.getCapacity()) {
            n4 = this.generation.elementAt(n);
            n5 = this.offset.elementAt(n);
        }
        if (n4 < n3 || n5 == 0 || bl2 && n2 > this.offset.elementAt(n)) {
            this.offset.setElementAt(n2, n);
            this.generation.setElementAt(n3, n);
            this.isCompressed.setElementAt(bl, n);
        }
    }

    private int getCompressedStreamObject(int n, int n2) {
        return this.offset.elementAt(n);
    }

    private int getCompressedStreamObject(String string) {
        int n = 0;
        if (string.endsWith("R")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = Integer.parseInt(stringTokenizer.nextToken());
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("Error with reference ..value=" + string + '<');
        }
        return this.offset.elementAt(n);
    }

    private int getOffset(String string) {
        int n = 0;
        if (string.endsWith("R")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = Integer.parseInt(stringTokenizer.nextToken());
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("2. Error with reference .." + string + "<<");
        }
        return this.offset.elementAt(n);
    }

    public final boolean isCompressed(int n, int n2) {
        return this.isCompressed.elementAt(n);
    }

    private boolean isCompressed(String string) {
        int n = 0;
        if (string.endsWith("R")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = Integer.parseInt(stringTokenizer.nextToken());
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("5.Error with reference .." + string + '<');
        }
        return this.isCompressed.elementAt(n);
    }

    public DecryptionFactory getDecryptionObject() {
        return this.decryption;
    }

    public void setPassword(String string) {
        this.encryptionPassword = string.getBytes();
        if (this.decryption != null) {
            this.decryption.reset(this.encryptionPassword);
        }
    }

    byte[] readObjectData(PdfObject pdfObject) {
        byte[] byArray;
        byte[] byArray2;
        String string = pdfObject.getObjectRefAsString();
        if (pdfObject.isDataExternal() && (byArray2 = this.readObjectAsByteArray(pdfObject, false, pdfObject.getObjectRefID(), 0)) == null) {
            pdfObject.setFullyResolved(false);
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (15)");
            }
            return byArray2;
        }
        boolean bl = this.isCompressed(string);
        pdfObject.setCompressedStream(bl);
        if (bl) {
            byArray = this.readCompressedObjectData(pdfObject, string);
        } else {
            this.movePointer(string);
            if (string.charAt(0) == '<') {
                byArray = this.readObjectData(-1, pdfObject);
            } else {
                int n = string.indexOf(32);
                int n2 = Integer.parseInt(string.substring(0, n));
                if (this.ObjLengthTable == null || this.refTableInvalid) {
                    byArray = this.getPointer() == 0L ? new byte[]{} : this.readObjectData(-1, pdfObject);
                } else if (n2 > this.ObjLengthTable.length || this.ObjLengthTable[n2] == 0) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog(string + " cannot have offset 0");
                    }
                    byArray = new byte[]{};
                } else {
                    byArray = this.readObjectData(this.ObjLengthTable[n2], pdfObject);
                }
            }
        }
        return byArray;
    }

    private byte[] readCompressedObjectData(PdfObject pdfObject, String string) {
        byte[] byArray;
        int n = Integer.parseInt(string.substring(0, string.indexOf(32)));
        int n2 = this.getCompressedStreamObject(string);
        String string2 = n2 + " 0 R";
        String string3 = null;
        int n3 = this.lastFirst;
        boolean bl = true;
        byte[] byArray2 = this.lastCompressedStream;
        HashMap hashMap = this.lastOffsetStart;
        HashMap hashMap2 = this.lastOffsetEnd;
        PdfObject pdfObject2 = null;
        if (this.lastOffsetStart != null) {
            string3 = (String)this.lastOffsetStart.get(String.valueOf(n));
        }
        while (string3 == null) {
            if (pdfObject2 != null) {
                this.compressedObj = pdfObject2;
            } else if (n2 != this.lastCompressedID) {
                bl = false;
                this.movePointer(string2);
                byArray = this.readObjectData(this.ObjLengthTable[n2], null);
                this.compressedObj = new CompressedObject(string2);
                ObjectDecoder objectDecoder = new ObjectDecoder(this);
                objectDecoder.readDictionaryAsObject(this.compressedObj, 0, byArray);
            }
            hashMap = new HashMap();
            hashMap2 = new HashMap();
            n3 = this.compressedObj.getInt(960643930);
            byArray2 = this.compressedObj.getDecodedStream();
            this.extractCompressedObjectOffset(hashMap, hashMap2, n3, byArray2, n2);
            string3 = (String)hashMap.get(String.valueOf(n));
            pdfObject2 = this.compressedObj.getDictionary(894663815);
            if (pdfObject2 != null) continue;
        }
        if (!bl) {
            this.lastCompressedStream = byArray2;
            this.lastCompressedID = n2;
            this.lastOffsetStart = hashMap;
            this.lastOffsetEnd = hashMap2;
            this.lastFirst = n3;
        }
        int n4 = n3 + Integer.parseInt(string3);
        int n5 = byArray2.length;
        String string4 = (String)hashMap2.get(String.valueOf(n));
        if (string4 != null) {
            n5 = n3 + Integer.parseInt(string4);
        }
        int n6 = n5 - n4;
        byArray = new byte[n6];
        System.arraycopy(byArray2, n4, byArray, 0, n6);
        pdfObject.setInCompressedStream(true);
        return byArray;
    }

    private byte[] readObjectData(int n, PdfObject pdfObject) {
        if (n < 1 || this.newCacheSize != -1) {
            return this.readObjectDataXX(n, pdfObject);
        }
        byte[] byArray = null;
        if (n > 0) {
            byArray = new byte[n += 6];
            this.fillBuffer(byArray);
        }
        return byArray;
    }

    private void fillBuffer(byte[] byArray) {
        block2: {
            try {
                this.read(byArray);
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
    }

    private byte[] readObjectDataXX(int n, PdfObject pdfObject) {
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        long l = this.getPointer();
        if (pdfObject != null) {
            n2 = this.newCacheSize;
        }
        int n6 = n;
        int n7 = 0;
        boolean bl5 = false;
        if (n < 1) {
            n = 128;
        }
        if (n2 != -1 && n > n2) {
            n = n2;
        }
        byte[] byArray = null;
        int n8 = n - 1;
        while (bl4) {
            if (++n8 == n) {
                long l2 = this.getPointer();
                if (l2 + (long)n > this.eof) {
                    n = (int)(this.eof - l2);
                }
                if (n == 0) break;
                byte[] byArray2 = new byte[n += 6];
                this.fillBuffer(byArray2);
                if (byArray == null) {
                    int n9 = 0;
                    while (byArray2[n9] == 101 || byArray2[n9] == 110 || byArray2[n9] == 100 || byArray2[n9] == 111 || byArray2[n9] == 98 || byArray2[n9] == 106) {
                        ++n9;
                    }
                    if (n9 > 0) {
                        byte[] byArray3 = byArray2;
                        int n10 = byArray2.length - n9;
                        byArray2 = new byte[n10];
                        System.arraycopy(byArray3, n9, byArray2, 0, n10);
                    }
                    byArray = byArray2;
                } else {
                    byArray = PdfFileReader.appendDataBlock(byArray2.length, byArray2, byArray);
                }
                n8 = 0;
            }
            byte by = byArray[n7];
            if (!bl3) {
                n4 = by == endPattern[n4] ? ++n4 : 0;
            }
            if (!bl && n2 != -1 && !bl2) {
                if (n3 < 6 && by == startStream[n3]) {
                    if (++n3 == 6) {
                        bl = true;
                    }
                } else {
                    n3 = 0;
                }
            }
            if (bl && byArray != null && byArray.length > n2) {
                pdfObject.setCache(l, this);
                bl2 = true;
            }
            if (!bl && !bl5 && n6 != -1) {
                if (by == lengthString[n5] && !bl3) {
                    if (++n5 == 6) {
                        bl5 = true;
                    }
                } else {
                    n5 = 0;
                }
            }
            ++n7;
            if (n4 == 6) {
                if (!bl5) {
                    bl4 = false;
                }
                n4 = 0;
            }
            if (!bl5 || n7 <= n6) continue;
            bl4 = false;
        }
        if (!bl5) {
            byArray = ObjectUtils.checkEndObject(byArray);
        }
        return byArray;
    }

    private static byte[] appendDataBlock(int n, byte[] byArray, byte[] byArray2) {
        int n2 = byArray2.length;
        byte[] byArray3 = new byte[n2 + n];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        System.arraycopy(byArray, 0, byArray3, n2, n);
        return byArray3;
    }

    public byte[] readObjectAsByteArray(PdfObject pdfObject, boolean bl, int n, int n2) {
        byte[] byArray = null;
        if (this.linHintTable != null) {
            byArray = this.linHintTable.getObjData(n);
        }
        if (byArray == null) {
            if (bl) {
                byArray = this.readCompressedObjectAsByteArray(pdfObject, n, n2);
            } else {
                this.movePointer(n, n2);
                if (this.ObjLengthTable == null || this.refTableInvalid) {
                    byArray = this.readObjectData(-1, pdfObject);
                } else {
                    if (n > this.ObjLengthTable.length) {
                        return null;
                    }
                    byArray = this.readObjectData(this.ObjLengthTable[n], pdfObject);
                }
            }
        }
        return byArray;
    }

    private byte[] readCompressedObjectAsByteArray(PdfObject pdfObject, int n, int n2) {
        byte[] byArray;
        int n3 = this.getCompressedStreamObject(n, n2);
        String string = null;
        HashMap hashMap = this.lastOffsetStart;
        HashMap hashMap2 = this.lastOffsetEnd;
        int n4 = this.lastFirst;
        boolean bl = true;
        byte[] byArray2 = this.lastCompressedStream;
        if (this.lastOffsetStart != null) {
            string = (String)this.lastOffsetStart.get(String.valueOf(n));
        }
        while (string == null) {
            bl = false;
            this.movePointer(n3, 0);
            byArray = this.readObjectData(this.ObjLengthTable[n3], null);
            String string2 = n3 + " " + n2 + " R";
            CompressedObject compressedObject = new CompressedObject(string2);
            ObjectDecoder objectDecoder = new ObjectDecoder(this);
            objectDecoder.readDictionaryAsObject(compressedObject, 0, byArray);
            hashMap = new HashMap();
            hashMap2 = new HashMap();
            n4 = ((PdfObject)compressedObject).getInt(960643930);
            byArray2 = compressedObject.getDecodedStream();
            this.extractCompressedObjectOffset(hashMap, hashMap2, n4, byArray2, n3);
            string = (String)hashMap.get(String.valueOf(n));
            PdfObject pdfObject2 = ((PdfObject)compressedObject).getDictionary(894663815);
            String string3 = pdfObject2 == null ? null : pdfObject2.getObjectRefAsString();
            if (string3 == null) continue;
            n3 = Integer.parseInt(string3.substring(0, string3.indexOf(32)));
        }
        if (!bl) {
            this.lastCompressedStream = byArray2;
            this.lastOffsetStart = hashMap;
            this.lastOffsetEnd = hashMap2;
            this.lastFirst = n4;
        }
        int n5 = n4 + Integer.parseInt(string);
        int n6 = byArray2.length;
        String string4 = (String)hashMap2.get(String.valueOf(n));
        if (string4 != null) {
            n6 = n4 + Integer.parseInt(string4);
        }
        int n7 = n6 - n5;
        byArray = new byte[n7];
        System.arraycopy(byArray2, n5, byArray, 0, n7);
        pdfObject.setInCompressedStream(true);
        return byArray;
    }

    public byte[] readPageIntoStream(PdfObject pdfObject) {
        byte[][] byArray = pdfObject.getKeyArray(1216184967);
        byte[] byArray2 = new byte[]{};
        if (byArray == null || byArray != null && byArray.length > 0 && byArray[0] == null) {
            return byArray2;
        }
        if (byArray != null) {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                StreamObject streamObject = new StreamObject(new String(byArray[i]));
                streamObject.isDataExternal(pdfObject.isDataExternal());
                this.readObject(streamObject);
                byte[] byArray3 = streamObject.getDecodedStream();
                byArray2 = i == 0 && byArray3 != null ? byArray3 : PdfFileReader.appendData(byArray2, byArray3);
            }
        }
        return byArray2;
    }

    private static byte[] appendData(byte[] byArray, byte[] byArray2) {
        if (byArray2 != null) {
            int n = byArray.length + 1;
            int n2 = byArray2.length;
            if (n2 > 0) {
                while (byArray2[n2 - 1] == 0) {
                    --n2;
                }
                byte[] byArray3 = new byte[n];
                System.arraycopy(byArray, 0, byArray3, 0, n - 1);
                byArray3[n - 1] = 32;
                byArray = new byte[n + n2];
                System.arraycopy(byArray3, 0, byArray, 0, n);
                System.arraycopy(byArray2, 0, byArray, n, n2);
            }
        }
        return byArray;
    }

    public void setCertificate(Certificate certificate, PrivateKey privateKey) {
        this.certificate = certificate;
        this.key = privateKey;
    }
}

