/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.TrueType;
import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1GlyphFactory;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Hhea;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.fonts.tt.conversion.CFFFixer;
import org.jpedal.fonts.tt.conversion.CFFWriter;
import org.jpedal.fonts.tt.conversion.CMAPWriter;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.FontWriter;
import org.jpedal.fonts.tt.conversion.HeadWriter;
import org.jpedal.fonts.tt.conversion.HheaWriter;
import org.jpedal.fonts.tt.conversion.HmtxWriter;
import org.jpedal.fonts.tt.conversion.LocaWriter;
import org.jpedal.fonts.tt.conversion.MAXPWriter;
import org.jpedal.fonts.tt.conversion.NameWriter;
import org.jpedal.fonts.tt.conversion.OS2Writer;
import org.jpedal.fonts.tt.conversion.PostWriter;
import org.jpedal.utils.LogWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PS2OTFFontWriter
extends FontWriter {
    byte[] cff;
    byte[] cmap = null;
    PdfFont pdfFont;
    PdfFont originalFont;
    PdfJavaGlyphs glyphs;
    int minCharCode;
    int maxCharCode;
    private int xAvgCharWidth = 0;
    private double xMaxExtent = Double.MIN_VALUE;
    private double minRightSideBearing = Double.MAX_VALUE;
    private double minLeftSideBearing = Double.MAX_VALUE;
    private double advanceWidthMax = Double.MIN_VALUE;
    private double lowestDescender = -1.0;
    private double highestAscender = 1.0;
    private float[] fontBBox = new float[4];
    private double emSquareSize = 1000.0;
    private int[] advanceWidths;
    private int[] lsbs = null;
    private HashMap<String, Integer> widthMap;
    private String[] glyphList = null;
    FontFile2 orginTTTables = null;

    public PS2OTFFontWriter(PdfFont pdfFont, byte[] byArray, String string, HashMap<String, Integer> hashMap) throws Exception {
        int n;
        boolean bl = string.equals("cff");
        this.name = pdfFont.getBaseFontName();
        this.widthMap = hashMap;
        String[] stringArray = new String[]{"CFF ", "OS/2", "cmap", "head", "hhea", "hmtx", "maxp", "name", "post"};
        if (string.equals("ttf")) {
            this.subType = 11;
            this.glyphs = pdfFont.getGlyphData();
            this.pdfFont = new TrueType(byArray, this.glyphs);
            this.orginTTTables = new FontFile2(byArray);
            stringArray = new String[]{"OS/2", "cmap", "cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "name", "post", "prep"};
            for (n = 0; n < stringArray.length; ++n) {
                this.IDtoTable.put(stringArray[n], n);
            }
        } else {
            this.glyphs = new T1Glyphs(false, bl);
            this.pdfFont = new Type1C(byArray, this.glyphs, bl);
        }
        this.glyphCount = this.glyphs.getGlyphCount();
        this.originalFont = pdfFont;
        this.cff = byArray;
        this.tableList = new ArrayList();
        this.numTables = stringArray.length;
        n = 1;
        while (n * 2 <= this.numTables) {
            n *= 2;
        }
        this.searchRange = n * 16;
        this.entrySelector = 0;
        while (Math.pow(2.0, this.entrySelector) < (double)n) {
            ++this.entrySelector;
        }
        this.rangeShift = this.numTables * 16 - this.searchRange;
        this.tableList.addAll(Arrays.asList(stringArray).subList(0, this.numTables));
        this.checksums = new int[this.tableCount][1];
        this.tables = new int[this.tableCount][1];
        this.tableLength = new int[this.tableCount][1];
        this.type = 1;
    }

    @Override
    void readTables() {
        int n;
        int n2 = 0;
        this.advanceWidths = new int[this.glyphCount];
        if (this.widthMap != null) {
            for (int i = 0; i < this.glyphCount; ++i) {
                Integer n3 = this.pdfFont.isCIDFont() ? this.widthMap.get(this.glyphs.getCharGlyph(i + 1)) : this.widthMap.get(this.glyphs.getIndexForCharString(i + 1));
                if (n3 != null) {
                    this.advanceWidths[i] = n3;
                } else if (this.pdfFont.is1C()) {
                    Integer n4;
                    n = 0;
                    if (((Type1C)this.pdfFont).getFDSelect() != null) {
                        n = ((Type1C)this.pdfFont).getFDSelect()[i];
                    }
                    if ((n4 = this.widthMap.get("JPedalDefaultWidth" + n)) != null) {
                        this.advanceWidths[i] = n4;
                    }
                }
                this.advanceWidthMax = this.advanceWidthMax > (double)this.advanceWidths[i] ? this.advanceWidthMax : (double)this.advanceWidths[i];
                n2 += this.advanceWidths[i];
            }
        }
        if (this.glyphCount > 0) {
            this.xAvgCharWidth = (int)((double)n2 / (double)this.glyphCount);
        }
        double d = Double.MIN_VALUE;
        n = this.glyphCount;
        if (this.originalFont.getCIDToGIDMap() != null && this.originalFont.getCIDToGIDMap().length < n) {
            n = this.originalFont.getCIDToGIDMap().length;
        }
        for (int i = 0; i < n && i < 256; ++i) {
            PdfGlyph pdfGlyph = this.glyphs.getEmbeddedGlyph(new T1GlyphFactory(), this.pdfFont.getMappedChar(i, false), new float[][]{{1.0f, 0.0f}, {0.0f, 1.0f}}, i, this.pdfFont.getGlyphValue(i), this.pdfFont.getWidth(i), this.pdfFont.getMappedChar(i, false));
            if (pdfGlyph == null || pdfGlyph.getShape() == null) continue;
            Rectangle2D rectangle2D = pdfGlyph.getShape().getBounds2D();
            double d2 = rectangle2D.getMinX();
            double d3 = (double)this.advanceWidths[i] - rectangle2D.getMaxX();
            double d4 = rectangle2D.getMinX() + rectangle2D.getWidth();
            this.minLeftSideBearing = this.minLeftSideBearing < d2 ? this.minLeftSideBearing : d2;
            this.minRightSideBearing = this.minRightSideBearing < d3 ? this.minRightSideBearing : d3;
            this.xMaxExtent = this.xMaxExtent > d4 ? this.xMaxExtent : d4;
            this.lowestDescender = this.lowestDescender < rectangle2D.getMinY() ? this.lowestDescender : rectangle2D.getMinY();
            this.highestAscender = this.highestAscender > rectangle2D.getMaxY() ? this.highestAscender : rectangle2D.getMaxY();
            d = d > rectangle2D.getMaxX() ? d : rectangle2D.getMaxX();
        }
        this.fontBBox = this.originalFont.is1C() ? this.pdfFont.FontBBox : this.originalFont.getFontBounds();
        this.minLeftSideBearing = this.minLeftSideBearing < (double)this.fontBBox[0] ? this.minLeftSideBearing : (double)this.fontBBox[0];
        this.lowestDescender = this.lowestDescender < (double)this.fontBBox[1] ? this.lowestDescender : (double)this.fontBBox[1];
        d = d > (double)this.fontBBox[2] ? d : (double)this.fontBBox[2];
        this.highestAscender = this.highestAscender > (double)this.fontBBox[3] ? this.highestAscender : (double)this.fontBBox[3];
        this.fontBBox = new float[]{(float)this.minLeftSideBearing, (float)this.lowestDescender, (float)d, (float)this.highestAscender};
    }

    @Override
    public byte[] getTableBytes(int n) {
        Object object;
        block36: {
            object = new byte[]{};
            FontTableWriter fontTableWriter = null;
            switch (n) {
                case 16: {
                    if (this.pdfFont.is1C()) {
                        object = new CFFFixer(this.cff).getBytes();
                        break;
                    }
                    fontTableWriter = new CFFWriter(this.glyphs, this.name);
                    Object object2 = (CFFWriter)fontTableWriter;
                    this.glyphList = ((CFFWriter)object2).getGlyphList();
                    this.advanceWidths = ((CFFWriter)object2).getWidths();
                    this.lsbs = ((CFFWriter)object2).getBearings();
                    this.fontBBox = ((CFFWriter)object2).getBBox();
                    this.emSquareSize = ((CFFWriter)object2).getEmSquareSize();
                    this.highestAscender = this.fontBBox[3];
                    this.lowestDescender = this.fontBBox[1];
                    this.advanceWidthMax = 0.0;
                    int n2 = 0;
                    for (int i = 0; i < this.advanceWidths.length; ++i) {
                        this.advanceWidthMax = this.advanceWidthMax > (double)this.advanceWidths[i] ? this.advanceWidthMax : (double)this.advanceWidths[i];
                        n2 += this.advanceWidths[i];
                        this.minLeftSideBearing = this.minLeftSideBearing < (double)this.lsbs[i] ? this.minLeftSideBearing : (double)this.lsbs[i];
                    }
                    if (this.glyphCount <= 0) break;
                    this.xAvgCharWidth = (int)((double)n2 / (double)this.glyphCount);
                    break;
                }
                case 0: {
                    if (this.subType == 11) {
                        object = this.orginTTTables.getTableBytes(0);
                        break;
                    }
                    fontTableWriter = new HeadWriter(this.fontBBox);
                    break;
                }
                case 2: {
                    if (this.subType == 11) {
                        fontTableWriter = new CMAPWriter(this.name, this.pdfFont, this.originalFont, this.glyphs, this.glyphList);
                        break;
                    }
                    fontTableWriter = new CMAPWriter(this.name, this.pdfFont, this.originalFont, this.glyphs, this.glyphList);
                    this.minCharCode = fontTableWriter.getIntValue(0);
                    this.maxCharCode = fontTableWriter.getIntValue(1);
                    break;
                }
                case 4: {
                    object = this.orginTTTables.getTableBytes(4);
                    break;
                }
                case 5: {
                    Object object2;
                    if (this.subType == 11) {
                        object2 = (TTGlyphs)this.glyphs;
                        Hmtx hmtx = (Hmtx)((TTGlyphs)object2).getTable(6);
                        Hhea hhea = (Hhea)((TTGlyphs)object2).getTable(5);
                        boolean bl = false;
                        int n3 = hhea.getIntValue(4);
                        if (n3 == 0) {
                            for (int i = 0; i < this.glyphs.getGlyphCount(); ++i) {
                                int n4 = (int)hmtx.getUnscaledWidth(i);
                                n3 = n4 > n3 ? n4 : n3;
                            }
                            if (n3 != hhea.getIntValue(4)) {
                                bl = true;
                            }
                        }
                        if (bl) {
                            fontTableWriter = new HheaWriter(this.glyphs, hhea.getIntValue(7), hhea.getIntValue(6), hhea.getIntValue(6), n3, hhea.getIntValue(2), hhea.getIntValue(1));
                            break;
                        }
                        object = this.orginTTTables.getTableBytes(5);
                        break;
                    }
                    fontTableWriter = new HheaWriter(this.glyphs, this.xMaxExtent, this.minRightSideBearing, this.minLeftSideBearing, this.advanceWidthMax, this.lowestDescender, this.highestAscender);
                    break;
                }
                case 6: {
                    if (this.subType == 11) {
                        object = this.orginTTTables.getTableBytes(6);
                        break;
                    }
                    fontTableWriter = new HmtxWriter(this.glyphs, this.advanceWidths, this.lsbs);
                    break;
                }
                case 3: {
                    if (this.subType == 11) {
                        object = this.orginTTTables.getTableBytes(3);
                        break;
                    }
                    fontTableWriter = new LocaWriter(this.name, this.pdfFont, this.originalFont, this.glyphs, this.glyphList);
                    break;
                }
                case 13: {
                    Object object2;
                    if (this.subType == 11) {
                        object2 = this.orginTTTables.getTableBytes(13);
                        if (((Object)object2).length > 0) {
                            object = object2;
                            break;
                        }
                        fontTableWriter = new OS2Writer(this.originalFont, this.glyphs, this.xAvgCharWidth, this.minCharCode, this.maxCharCode, this.fontBBox, this.emSquareSize);
                        break;
                    }
                    fontTableWriter = new OS2Writer(this.originalFont, this.glyphs, this.xAvgCharWidth, this.minCharCode, this.maxCharCode, this.fontBBox, this.emSquareSize);
                    break;
                }
                case 1: {
                    if (this.subType == 11) {
                        object = this.orginTTTables.getTableBytes(1);
                        break;
                    }
                    fontTableWriter = new MAXPWriter(this.glyphs);
                    break;
                }
                case 7: {
                    if (this.subType == 11) {
                        fontTableWriter = new NameWriter(this.pdfFont, this.glyphs, this.name);
                        break;
                    }
                    fontTableWriter = new NameWriter(this.pdfFont, this.glyphs, this.name);
                    break;
                }
                case 8: {
                    Object object2;
                    if (this.subType == 11) {
                        object2 = this.orginTTTables.getTableBytes(8);
                        if (((Object)object2).length > 0) {
                            object = object2;
                            break;
                        }
                        fontTableWriter = new PostWriter();
                        break;
                    }
                    fontTableWriter = new PostWriter();
                    break;
                }
                case 14: {
                    object = this.orginTTTables.getTableBytes(14);
                    if (((byte[])object).length != 0) break;
                    object = new byte[]{FontWriter.setNextUint8(0)};
                    break;
                }
                case 9: {
                    object = this.orginTTTables.getTableBytes(9);
                    if (((byte[])object).length != 0) break;
                    object = FontWriter.setNextUint16(0);
                    break;
                }
                case 10: {
                    object = this.orginTTTables.getTableBytes(10);
                    if (((byte[])object).length != 0) break;
                    object = new byte[]{FontWriter.setNextUint8(0)};
                    break;
                }
            }
            if (fontTableWriter != null) {
                try {
                    object = fontTableWriter.writeTable();
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block36;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
        return object;
    }
}

