/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.Name;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.TTFontWriter;

public class NameWriter
extends Name
implements FontTableWriter {
    String[] strings = new String[7];

    public NameWriter(PdfFont pdfFont, PdfJavaGlyphs pdfJavaGlyphs, String string) {
        string = string.replaceAll("[.,<>*#]", "-");
        this.strings[0] = pdfFont.getCopyright() != null ? pdfFont.getCopyright() : "No copyright information found.";
        this.strings[1] = string;
        switch (pdfJavaGlyphs.style) {
            case 0: {
                this.strings[2] = "Roman";
                break;
            }
            case 1: {
                this.strings[2] = "Bold";
                break;
            }
            case 2: {
                this.strings[2] = "Italic";
                break;
            }
            default: {
                this.strings[2] = "Roman";
            }
        }
        this.strings[3] = "JPedal PDF2HTML " + string + ' ' + new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(Calendar.getInstance().getTime());
        this.strings[4] = string;
        this.strings[5] = "Version 1.0";
        this.strings[6] = string;
    }

    public byte[] writeTable() throws IOException {
        byte[] byArray;
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(TTFontWriter.setNextUint16(0));
        byteArrayOutputStream.write(TTFontWriter.setNextUint16(14));
        byteArrayOutputStream.write(TTFontWriter.setNextUint16(174));
        int n2 = 0;
        for (n = 0; n < 7; ++n) {
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(1));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(n));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.strings[n].length()));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(n2));
            n2 += this.strings[n].length();
        }
        for (n = 0; n < 7; ++n) {
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(3));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(1));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(1033));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(n));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.strings[n].length() * 2));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(n2));
            n2 += this.strings[n].length() * 2;
        }
        for (n = 0; n < 7; ++n) {
            for (byte by : byArray = this.strings[n].getBytes("US-ASCII")) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint8(by));
            }
        }
        for (n = 0; n < 7; ++n) {
            for (byte by : byArray = this.strings[n].getBytes("UTF-16BE")) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint8(by));
            }
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public int getIntValue(int n) {
        int n2 = 0;
        switch (n) {
            default: 
        }
        return n2;
    }
}

