/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.StringUtils;

public class FontWriter
extends FontFile2 {
    String name;
    int glyphCount;
    int headCheckSumPos = -1;
    Map IDtoTable = new HashMap();
    private static boolean compressWoff = true;
    ArrayList<TTFDirectory> ttfList = new ArrayList();
    static final String[] TTFTableOrder;
    private HashMap<Integer, byte[]> tableStore = new HashMap();
    boolean debug = false;

    public FontWriter(byte[] byArray) {
        super(byArray);
    }

    public FontWriter() {
    }

    static int getUintFromByteArray(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = (n2 - 1) * 8; i >= 0; i -= 8) {
            int n5 = byArray[n + n4];
            if (n5 < 0) {
                n5 += 256;
            }
            n3 |= n5 << i;
            ++n4;
        }
        return n3;
    }

    static int getUintFromIntArray(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = (n2 - 1) * 8; i >= 0; i -= 8) {
            n3 |= (nArray[n + n4] & 0xFF) << i;
            ++n4;
        }
        return n3;
    }

    static byte[] set1cNumber(int n) {
        byte[] byArray = n >= -107 && n <= 107 ? new byte[]{(byte)(n + 139)} : (n >= 108 && n <= 1131 ? new byte[]{(byte)(247 + (n -= 108) / 256), (byte)(n & 0xFF)} : (n >= -1131 && n <= -108 ? new byte[]{(byte)(251 + (n += 108) / -256), (byte)(-n & 0xFF)} : (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE ? new byte[]{28, (byte)(n / 256 & 0xFF), (byte)(n & 0xFF)} : new byte[]{29, (byte)(n / 256 / 256 / 256 & 0xFF), (byte)(n / 256 / 256 & 0xFF), (byte)(n / 256 & 0xFF), (byte)(n & 0xFF)})));
        return byArray;
    }

    static byte[] set1cRealNumber(double d) {
        int n;
        String string = Double.toString(d);
        if (string.length() > 10) {
            if (string.contains("E")) {
                String[] stringArray = string.split("E");
                string = string.substring(0, 10 - (stringArray[1].length() + 1)) + "E" + stringArray[1];
            } else {
                string = string.substring(0, 10);
            }
        }
        if ((n = (string = string + "f").length()) % 2 == 1) {
            ++n;
        }
        byte[] byArray = new byte[1 + (n /= 2)];
        byArray[0] = 30;
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2;
            char c = string.charAt(n2);
            char c2 = n2 + 1 < string.length() ? string.charAt(n2 + 1) : c;
            byte by = FontWriter.getNibble(c);
            byte by2 = FontWriter.getNibble(c2);
            byArray[i + 1] = (byte)((by & 0xF) << 4 | by2 & 0xF);
        }
        return byArray;
    }

    private static byte getNibble(char c) {
        switch (c) {
            case '.': {
                return 10;
            }
            case 'E': {
                return 11;
            }
            case '-': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return (byte)Integer.parseInt("" + c);
    }

    static byte[] setCharstringType2Number(int n) {
        byte[] byArray;
        if (n >= -107 && n <= 107) {
            byArray = new byte[]{(byte)(n + 139)};
        } else if (n >= 108 && n <= 1131) {
            byArray = new byte[]{(byte)(247 + (n -= 108) / 256), (byte)(n & 0xFF)};
        } else if (n >= -1131 && n <= -108) {
            byArray = new byte[]{(byte)(251 + (n += 108) / -256), (byte)(-n & 0xFF)};
        } else if (n >= 0) {
            byArray = new byte[]{-1, (byte)(n / 256 & 0xFF), (byte)(n & 0xFF), 0, 0};
        } else {
            int n2 = n + 32768;
            byArray = new byte[]{-1, (byte)(0x80 | n2 / 256 & 0x7F), (byte)(n2 & 0xFF), 0, 0};
        }
        return byArray;
    }

    public static byte[] setUintAsBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = n2; i > 0; --i) {
            int n3 = n;
            for (int j = 1; j < i; ++j) {
                n3 >>= 8;
            }
            byArray[n2 - i] = (byte)n3;
        }
        return byArray;
    }

    static int createChecksum(byte[] byArray) {
        int n = 0;
        FontFile2 fontFile2 = new FontFile2(byArray, true);
        int n2 = byArray.length + 3 >> 2;
        for (int i = 0; i < n2; ++i) {
            n += fontFile2.getNextUint32();
        }
        return n;
    }

    public static final byte[] setUFWord(int n) {
        short s = (short)n;
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(s >> 8 * (1 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte[] setFWord(int n) {
        short s = (short)n;
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(s >> 8 * (1 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte[] setNextUint16(int n) {
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(n >> 8 * (1 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte[] setNextInt16(int n) {
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(n >> 8 * (1 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte[] setNextSignedInt16(short s) {
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(s >> 8 * (1 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte setNextUint8(int n) {
        return (byte)(n & 0xFF);
    }

    public static final byte[] setNextUint32(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)(n >> 8 * (3 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte[] setNextUint64(int n) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(n >> 8 * (7 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte[] setNextUint64(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l >> 8 * (7 - i) & 0xFFL);
        }
        return byArray;
    }

    public final byte[] writeFontToStream() throws IOException {
        this.readTables();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.type == 1) {
            if (this.subType == 10) {
                byteArrayOutputStream.write(FontWriter.setNextUint32(0x4F54544F));
            } else {
                byteArrayOutputStream.write(FontWriter.setNextUint32(65536));
            }
        } else if (this.type == 3) {
            byteArrayOutputStream.write(FontWriter.setNextUint32(1953784678));
        } else {
            byteArrayOutputStream.write(FontWriter.setNextUint32(65536));
        }
        if (this.type == 3) {
            System.out.println("TTC write not implemented");
        } else {
            this.writeTablesForFont(byteArrayOutputStream);
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = FontWriter.setNextUint32((int)(Long.parseLong("B1B0AFBA", 16) - (long)FontWriter.createChecksum(byArray)));
        System.arraycopy(byArray2, 0, byArray, 0 + this.headCheckSumPos, 4);
        return byArray;
    }

    void readTables() {
    }

    private void writeTablesForFont(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n;
        int n2;
        Object[] objectArray;
        int n3;
        String string;
        int n4;
        int[] nArray = new int[this.numTables];
        int[] nArray2 = new int[this.numTables];
        int[] nArray3 = new int[this.numTables];
        int[] nArray4 = new int[this.numTables];
        byteArrayOutputStream.write(FontWriter.setNextUint16(this.numTables));
        byteArrayOutputStream.write(FontWriter.setNextUint16(this.searchRange));
        byteArrayOutputStream.write(FontWriter.setNextUint16(this.entrySelector));
        byteArrayOutputStream.write(FontWriter.setNextUint16(this.rangeShift));
        for (n4 = 0; n4 < this.numTables; ++n4) {
            string = (String)this.tableList.get(n4);
            n3 = FontWriter.getTableID(string);
            if (this.debug) {
                System.out.println("writing out " + string + " id=" + n3);
            }
            if (n3 == -1) continue;
            objectArray = this.getTableBytes(n3);
            this.tableStore.put(n3, (byte[])objectArray);
            if (n3 != 0) {
                nArray3[n4] = FontWriter.createChecksum((byte[])objectArray);
            }
            nArray4[n4] = objectArray.length;
            nArray[n4] = n4;
            nArray2[n4] = this.tables[n3][this.currentFontID];
        }
        if (this.subType == 10) {
            nArray = Sorts.quicksort(nArray2, nArray);
        }
        n4 = FontWriter.alignOnWordBoundary(byteArrayOutputStream.size() + 16 * this.numTables);
        objectArray = new int[this.numTables];
        for (n2 = 0; n2 < this.numTables; ++n2) {
            int n5 = nArray[n2];
            objectArray[n5] = n4;
            nArray2[n5] = n4;
            n4 = FontWriter.alignOnWordBoundary(n4 + nArray4[n5]);
        }
        if (this.subType == 11) {
            for (n2 = 0; n2 < this.numTables; ++n2) {
                string = TTFTableOrder[n2];
                byteArrayOutputStream.write(StringUtils.toBytes(string));
                n3 = FontWriter.getTableID(string);
                n = (Integer)this.IDtoTable.get(string);
                if (n3 == -1) continue;
                if (n3 == 0) {
                    this.headCheckSumPos = byteArrayOutputStream.size();
                }
                byteArrayOutputStream.write(FontWriter.setNextUint32(nArray3[n]));
                byteArrayOutputStream.write(FontWriter.setNextUint32(objectArray[n]));
                byteArrayOutputStream.write(FontWriter.setNextUint32(nArray4[n]));
                this.ttfList.add(new TTFDirectory(string, objectArray[n], nArray3[n], nArray4[n]));
            }
        } else {
            for (n2 = 0; n2 < this.numTables; ++n2) {
                n = n2;
                string = (String)this.tableList.get(n);
                byteArrayOutputStream.write(StringUtils.toBytes(string));
                n3 = FontWriter.getTableID(string);
                if (n3 == -1) continue;
                if (n3 == 0) {
                    this.headCheckSumPos = byteArrayOutputStream.size();
                }
                byteArrayOutputStream.write(FontWriter.setNextUint32(nArray3[n]));
                byteArrayOutputStream.write(FontWriter.setNextUint32(objectArray[n]));
                byteArrayOutputStream.write(FontWriter.setNextUint32(nArray4[n]));
                this.ttfList.add(new TTFDirectory(string, objectArray[n], nArray3[n], nArray4[n]));
            }
        }
        for (int i = 0; i < this.numTables; ++i) {
            n2 = nArray[i];
            string = (String)this.tableList.get(n2);
            n3 = FontWriter.getTableID(string);
            byte[] byArray = this.tableStore.get(n3);
            while ((byteArrayOutputStream.size() & 3) != 0) {
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(byArray);
        }
    }

    private static int alignOnWordBoundary(int n) {
        int n2 = n & 3;
        if (n2 != 0) {
            n += 4 - n2;
        }
        return n;
    }

    public final byte[] writeFontToWoffStream() throws IOException {
        Object object;
        int n;
        byte[] byArray = this.writeFontToStream();
        for (TTFDirectory tTFDirectory : this.ttfList) {
            if (!tTFDirectory.getTag().equals("head")) continue;
            n = this.AdjustWoffChecksum(byArray, tTFDirectory.getOffset(), tTFDirectory.getLength());
            tTFDirectory.setChecksum(n);
        }
        int n2 = 12 + 16 * this.numTables;
        int n3 = 44 + 20 * this.numTables;
        n = byArray.length - n2;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, n2, byArray2, 0, byArray.length - n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        int n4 = 0;
        for (TTFDirectory tTFDirectory : this.ttfList) {
            int n5;
            Object object2;
            object = new byte[tTFDirectory.getLength()];
            System.arraycopy(byArray, tTFDirectory.getOffset(), object, 0, tTFDirectory.getLength());
            tTFDirectory.setOffset(n4 + n3);
            int n6 = tTFDirectory.getLength();
            if (compressWoff) {
                byte[] byArray3 = new byte[tTFDirectory.getLength()];
                object2 = new Deflater();
                ((Deflater)object2).setInput((byte[])object);
                ((Deflater)object2).finish();
                n6 = ((Deflater)object2).deflate(byArray3);
                if (n6 < tTFDirectory.getLength() && ((Deflater)object2).finished()) {
                    byteArrayOutputStream.write(byArray3, 0, n6);
                } else {
                    byteArrayOutputStream.write((byte[])object);
                    n6 = tTFDirectory.getLength();
                }
            } else {
                byteArrayOutputStream.write((byte[])object);
            }
            tTFDirectory.setCompressLength(n6);
            int n7 = n5 = n6 % 4 > 0 ? 4 - n6 % 4 : 0;
            if (n5 > 0) {
                object2 = new byte[n5];
                byteArrayOutputStream.write((byte[])object2);
            }
            n4 = n4 + tTFDirectory.getCompressLength() + n5;
        }
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        byteArrayOutputStream2.write(FontWriter.setNextUint32(2001684038));
        if (this.type == 1) {
            if (this.subType == 10) {
                byteArrayOutputStream2.write(FontWriter.setNextUint32(0x4F54544F));
            } else {
                byteArrayOutputStream2.write(FontWriter.setNextUint32(65536));
            }
        } else if (this.type == 3) {
            byteArrayOutputStream2.write(FontWriter.setNextUint32(1953784678));
        } else {
            byteArrayOutputStream2.write(FontWriter.setNextUint32(65536));
        }
        byteArrayOutputStream2.write(FontWriter.setNextUint32(n3 + n4));
        byteArrayOutputStream2.write(FontWriter.setNextUint16(this.numTables));
        byteArrayOutputStream2.write(FontWriter.setNextUint16(0));
        int n8 = byArray.length % 4 > 0 ? 4 - byArray.length % 4 : 0;
        byteArrayOutputStream2.write(FontWriter.setNextUint32(n8 > 0 ? byArray.length + n8 : byArray.length));
        byteArrayOutputStream2.write(FontWriter.setNextUint16(1));
        byteArrayOutputStream2.write(FontWriter.setNextUint16(1));
        byteArrayOutputStream2.write(FontWriter.setNextUint32(0));
        byteArrayOutputStream2.write(FontWriter.setNextUint32(0));
        byteArrayOutputStream2.write(FontWriter.setNextUint32(0));
        byteArrayOutputStream2.write(FontWriter.setNextUint32(0));
        byteArrayOutputStream2.write(FontWriter.setNextUint32(0));
        object = this.ttfList.iterator();
        while (object.hasNext()) {
            TTFDirectory tTFDirectory = (TTFDirectory)object.next();
            byteArrayOutputStream2.write(tTFDirectory.getTagBytes());
            byteArrayOutputStream2.write(FontWriter.setNextUint32(tTFDirectory.getOffset()));
            byteArrayOutputStream2.write(FontWriter.setNextUint32(tTFDirectory.getCompressLength()));
            byteArrayOutputStream2.write(FontWriter.setNextUint32(tTFDirectory.getLength()));
            byteArrayOutputStream2.write(FontWriter.setNextUint32(tTFDirectory.getChecksum()));
        }
        byteArrayOutputStream2.write(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream2.flush();
        byteArrayOutputStream2.close();
        return byteArrayOutputStream2.toByteArray();
    }

    private int AdjustWoffChecksum(byte[] byArray, int n, int n2) {
        if (byArray.length > n && n2 >= 4) {
            int n3;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byte[] byArray2 = new byte[4];
            for (n3 = 0; n3 < 4; ++n3) {
                byArray2[n3] = 0;
            }
            System.arraycopy(byArray2, 0, byArray, n + 8, 4);
            n3 = -1313820742 - FontWriter.createChecksum(byArray2);
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byteBuffer.array(), n, byArray3, 0, n2);
            int n4 = FontWriter.createChecksum(byArray3);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
            byteBuffer2.putInt(n3);
            byte[] byArray4 = byteBuffer2.array();
            System.arraycopy(byArray4, 0, byArray, n + 8, 4);
            return n4;
        }
        return 0;
    }

    static {
        if (System.getProperty("org.jpedal.pdf2html.compressWoff") != null && System.getProperty("org.jpedal.pdf2html.compressWoff").toLowerCase().equals("false")) {
            compressWoff = false;
        }
        TTFTableOrder = new String[]{"OS/2", "cmap", "cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "name", "post", "prep"};
    }

    private class TTFDirectory {
        private int offset2;
        private int checksum2;
        private int length2;
        private int compressLength;
        private String tag2;

        public TTFDirectory(String string, int n, int n2, int n3) {
            this.tag2 = string;
            this.offset2 = n;
            this.checksum2 = n2;
            this.length2 = n3;
        }

        public String getTag() {
            return this.tag2;
        }

        public byte[] getTagBytes() {
            byte[] byArray = new byte[4];
            for (int i = 0; i < 4; ++i) {
                byArray[i] = (byte)this.getTag().charAt(i);
            }
            return byArray;
        }

        public int getOffset() {
            return this.offset2;
        }

        public int getChecksum() {
            return this.checksum2;
        }

        public int getLength() {
            return this.length2;
        }

        public int getCompressLength() {
            return this.compressLength;
        }

        public void setOffset(int n) {
            this.offset2 = n;
        }

        public void setChecksum(int n) {
            this.checksum2 = n;
        }

        public void setLength(int n) {
            this.length2 = n;
        }

        public void setTag(String string) {
            this.tag2 = string;
        }

        public void setCompressLength(int n) {
            this.compressLength = n;
        }
    }
}

