/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public class ShowLinks {
    private boolean includeImages = true;

    public ShowLinks(String string) {
        BufferedImage bufferedImage = null;
        PdfDecoder pdfDecoder = this.includeImages ? new PdfDecoder(true) : new PdfDecoder(false);
        try {
            pdfDecoder.openPdfFile(string);
            for (int i = 1; i < pdfDecoder.getPageCount() + 1; ++i) {
                PdfArrayIterator pdfArrayIterator = pdfDecoder.getFormRenderer().getAnnotsOnPage(i);
                if (pdfArrayIterator != null && pdfArrayIterator.getTokenCount() > 0) {
                    if (this.includeImages) {
                        bufferedImage = pdfDecoder.getPageAsImage(i);
                    }
                    while (pdfArrayIterator.hasMoreTokens()) {
                        Object[] objectArray;
                        String string2 = pdfArrayIterator.getNextValueAsString(true);
                        for (Object object : objectArray = pdfDecoder.getFormRenderer().getCompData().getRawForm(string2)) {
                            Object object2;
                            FormObject formObject;
                            int n;
                            if (object == null || (n = (formObject = (FormObject)object).getParameterConstant(1147962727)) != 473513531) continue;
                            System.out.println("link object");
                            float[] fArray = formObject.getFloatArray(573911876);
                            System.out.println("PDF Rect= " + fArray[0] + ' ' + fArray[1] + ' ' + fArray[2] + ' ' + fArray[3]);
                            int n2 = pdfDecoder.getPdfPageData().getCropBoxHeight(i);
                            float f = fArray[0];
                            float f2 = fArray[2] - fArray[0];
                            float f3 = fArray[3] - fArray[1];
                            float f4 = (float)n2 - fArray[1] - f3;
                            System.out.println("Javaspace Rect x=" + f + " y=" + f4 + " w=" + f2 + " h=" + f3);
                            if (this.includeImages) {
                                object2 = (Graphics2D)bufferedImage.getGraphics();
                                ((Graphics2D)object2).setPaint(Color.RED);
                                ((Graphics)object2).drawRect((int)f, (int)f4, (int)f2, (int)f3);
                            }
                            if ((object2 = formObject.getDictionary(17)) == null || ((PdfObject)object2).getNameAsConstant(35) != 2433561) continue;
                            String string3 = ((PdfObject)object2).getTextStreamValue(2433561);
                            System.out.println("text=" + string3);
                        }
                    }
                }
                if (!this.includeImages) continue;
                ImageIO.write((RenderedImage)bufferedImage, "PNG", new File("image-" + i + ".png"));
            }
            pdfDecoder.closePdfFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Simple demo to extract pdf file links if any");
        if (stringArray.length != 1) {
            System.out.println("No filename given or  wrong number of values");
        } else {
            String string = stringArray[0];
            System.out.println("File :" + string);
            File file = new File(string);
            if (!file.exists()) {
                System.out.println("File " + string + " not found");
            } else {
                new ShowLinks(string);
            }
        }
        System.exit(1);
    }
}

