/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.FileWriter;
import java.io.PrintWriter;
import org.jpedal.utils.LogScanner;
import org.jpedal.utils.TimeNow;

public class LogWriter {
    public static LogScanner logScanner = null;
    public static boolean debug = false;
    public static String log_name = null;
    public static boolean testing = false;
    private static boolean verbose = false;

    public static final void resetLogFile() {
        if (log_name != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(log_name, false));
                printWriter.println(TimeNow.getTimeNow() + " Running Storypad");
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " attempting to write to log file " + log_name);
            }
        }
    }

    public static final boolean isOutput() {
        return verbose || logScanner != null;
    }

    public static final void writeLog(String string) {
        if (logScanner != null) {
            logScanner.message(string);
        }
        if (verbose) {
            System.out.println(string);
        }
        if (log_name != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(log_name, true));
                if (!testing) {
                    printWriter.println(TimeNow.getTimeNow() + ' ' + string);
                }
                printWriter.println(string);
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " attempting to write to log file " + log_name);
            }
        }
    }

    public static final void setupLogFile(String string) {
        if (string != null) {
            if (string.indexOf(118) != -1) {
                verbose = true;
                LogWriter.writeLog("Verbose on");
            } else {
                verbose = false;
            }
        }
        if (!testing) {
            LogWriter.writeLog("Software version - 4.92b23-OS");
            LogWriter.writeLog("Software started - " + TimeNow.getTimeNow());
        }
        LogWriter.writeLog("=======================================================");
    }

    public static void writeFormLog(String string, boolean bl) {
        if (bl) {
            System.out.println("[forms] " + string);
        }
        LogWriter.writeLog("[forms] " + string);
    }
}

