/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.utils;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConvertToString {
    public static final String convertMapToString(NamedNodeMap namedNodeMap) {
        if (namedNodeMap == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            stringBuilder.append('\t');
            stringBuilder.append(node.getNodeName());
            stringBuilder.append('=');
            stringBuilder.append(node.getNodeValue());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static final String convertMapToString(Map map) {
        if (map == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object k : map.keySet()) {
            stringBuilder.append('\t');
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(map.get(k));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static final String convertArrayToString(String[] stringArray) {
        if (stringArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(stringArray[i]);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static String convertArrayToString(boolean[] blArray) {
        if (blArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < blArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(i);
                stringBuilder.append('=');
                stringBuilder.append(blArray[i]);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static String convertArrayToString(float[] fArray) {
        if (fArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < fArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(fArray[i]);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static String convertArrayToString(float[][] fArray) {
        if (fArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            for (int i = 0; i < fArray.length; ++i) {
                stringBuilder.append('{');
                for (int j = 0; j < fArray[i].length; ++j) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(fArray[i][j]);
                }
                stringBuilder.append("}, ");
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
        return null;
    }

    public static String convertArrayToString(int[] nArray) {
        if (nArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(nArray[i]);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static String convertArrayToString(Rectangle[] rectangleArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < rectangleArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",\n ");
            }
            stringBuilder.append(rectangleArray[i].x);
            stringBuilder.append(' ');
            stringBuilder.append(rectangleArray[i].y);
            stringBuilder.append(' ');
            stringBuilder.append(rectangleArray[i].width);
            stringBuilder.append(' ');
            stringBuilder.append(rectangleArray[i].height);
        }
        return stringBuilder.toString();
    }

    public static String convertArrayToString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("count=");
        stringBuilder.append(objectArray.length);
        for (Object object : objectArray) {
            stringBuilder.append('\n');
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    public static String convertArrayToString(List list) {
        if (list == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("count=");
        stringBuilder.append(list.size());
        for (Object e : list) {
            stringBuilder.append('\n');
            stringBuilder.append(e);
        }
        return stringBuilder.toString();
    }

    public static String convertArrayToString(Set set) {
        if (set == null) {
            return "null";
        }
        return ConvertToString.convertArrayToString(set.toArray());
    }

    public static String convertArrayToString(Boolean[] booleanArray) {
        if (booleanArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < booleanArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(i);
                stringBuilder.append('=');
                stringBuilder.append(booleanArray[i]);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static String convertButtonGroupToString(ButtonGroup buttonGroup) {
        if (buttonGroup == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(buttonGroup.getButtonCount());
        stringBuilder.append('\n');
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            stringBuilder.append(enumeration.nextElement());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static void printStackTrace(int n) {
        ConvertToString.printStackTrace(2, n + 1, false);
    }

    public static void printStackTrace(int n, int n2, boolean bl) {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (n2 == -1 || n2 > stackTraceElementArray.length - 1) {
            n2 = stackTraceElementArray.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            if (bl) {
                System.err.println(stackTraceElementArray[i]);
                continue;
            }
            System.out.println(stackTraceElementArray[i]);
        }
    }

    public static String convertDocumentToString(Node node) {
        return ConvertToString.convertDocumentToString(node, 0);
    }

    private static String convertDocumentToString(Node node, int n) {
        if (node == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(node.getNodeName());
        stringBuilder.append(" = ");
        stringBuilder.append(node.getNodeValue());
        stringBuilder.append(" type=");
        stringBuilder.append(node.getNodeType());
        stringBuilder.append(" textContent=");
        stringBuilder.append(node.getTextContent());
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            stringBuilder.append(" attributes=[");
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(namedNodeMap.item(i));
            }
            stringBuilder.append(']');
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            stringBuilder.append('\n');
            for (int j = 0; j < n; ++j) {
                stringBuilder.append('|');
            }
            stringBuilder.append(ConvertToString.convertDocumentToString(nodeList.item(i), n + 1));
        }
        return stringBuilder.toString();
    }
}

