/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.external.ImageHelper;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class ObjectStore {
    public static final boolean verifyFilesSaved = false;
    private static final Map undeletedFiles = new HashMap();
    public static final boolean isMultiThreaded = false;
    ImageHelper images = new DefaultImageHelper();
    private static final boolean debugCache = false;
    private static boolean checkedThisSession = false;
    private static final String separator = System.getProperty("file.separator");
    private String currentFilename = "";
    private String currentFilePath = "";
    public static String temp_dir = "";
    public static final String multiThreaded_root_dir = null;
    private static final String cmyk_dir = temp_dir + "cmyk" + separator;
    private String key = "jpedal" + Math.random() + '_';
    private final Map image_type = new HashMap();
    private final Map tempFileNames = new HashMap();
    public static final Integer IMAGE_WIDTH = 1;
    public static final Integer IMAGE_HEIGHT = 2;
    public static final Integer IMAGE_pX = 3;
    public static final Integer IMAGE_pY = 4;
    public static final Integer IMAGE_MASKCOL = 5;
    public static final Integer IMAGE_COLORSPACE = 6;
    public static final long time = 14400000L;
    public String fullFileName;
    private static final Map pagesOnDisk = new HashMap();
    private static final Map pagesOnDiskAsBytes = new HashMap();
    private final Map imagesOnDiskAsBytes = new HashMap();
    private final Map imagesOnDiskAsBytesW = new HashMap();
    private final Map imagesOnDiskAsBytesH = new HashMap();
    private final Map imagesOnDiskAsBytespX = new HashMap();
    private final Map imagesOnDiskAsBytespY = new HashMap();
    private final Map imagesOnDiskMask = new HashMap();
    private final Map imagesOnDiskColSpaceID = new HashMap();

    public ObjectStore(ImageHelper imageHelper) {
        if (imageHelper != null) {
            this.images = imageHelper;
        }
        this.init();
    }

    public ObjectStore() {
        this.init();
    }

    private void init() {
        block7: {
            try {
                if (temp_dir.length() == 0) {
                    temp_dir = System.getProperty("java.io.tmpdir");
                }
                if (temp_dir.length() == 0) {
                    temp_dir = temp_dir + separator + "jpedal" + separator;
                } else if (!temp_dir.endsWith(separator)) {
                    temp_dir = temp_dir + separator;
                }
                File file = new File(temp_dir);
                if (!file.exists()) {
                    file.mkdirs();
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block7;
                LogWriter.writeLog("Unable to create temp dir at " + temp_dir);
            }
        }
    }

    private static void checkExists(String string) {
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException("Unable to create " + file.getAbsolutePath());
        }
    }

    private static void checkExists(File file) {
        if (!file.exists()) {
            throw new RuntimeException("Unable to create " + file.getAbsolutePath());
        }
    }

    public String getCurrentFilename() {
        return this.currentFilename;
    }

    public String getCurrentFilepath() {
        return this.currentFilePath;
    }

    public final void storeFileName(String string) {
        this.fullFileName = string;
        int n = this.fullFileName.lastIndexOf(47);
        int n2 = this.fullFileName.lastIndexOf(92);
        if (n2 > n) {
            n = n2;
        }
        this.currentFilePath = n > 0 ? this.fullFileName.substring(0, n + 1) : "";
        int n3 = string.indexOf(92);
        if (n3 == -1) {
            n3 = string.indexOf(47);
        }
        while (n3 != -1) {
            if ((n3 = (string = string.substring(n3 + 1)).indexOf(92)) != -1) continue;
            n3 = string.indexOf(47);
        }
        int n4 = string.lastIndexOf(46);
        if (n4 != -1) {
            string = string.substring(0, n4);
        }
        string = Strip.stripAllSpaces(string);
        this.currentFilename = string.toLowerCase();
    }

    public boolean saveRawCMYKImage(byte[] byArray, String string) {
        boolean bl = true;
        string = ObjectStore.removeIllegalFileNameCharacters(string);
        File file = new File(cmyk_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(cmyk_dir + string + ".jpg");
            this.tempFileNames.put(cmyk_dir + string + ".jpg", "#");
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Unable to save CMYK jpeg " + string);
            }
            bl = false;
        }
        return bl;
    }

    public final synchronized boolean saveStoredImage(String string, BufferedImage bufferedImage, boolean bl, boolean bl2, String string2) {
        boolean bl3 = false;
        string = ObjectStore.removeIllegalFileNameCharacters(string);
        int n = bufferedImage.getType();
        File file = new File(temp_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (string2.contains("tif")) {
            if (!(n != 1 && n != 2 || string.contains("HIRES_"))) {
                bufferedImage = ColorSpaceConvertor.convertColorspace(bufferedImage, 5);
            }
            if (!bl) {
                this.image_type.put(string, "tif");
            }
            bl3 = this.saveStoredImage("TIFF", ".tif", ".tiff", string, bufferedImage, bl, bl2);
        } else if (string2.contains("jpg")) {
            if (!bl) {
                this.image_type.put(string, "jpg");
            }
            bl3 = this.saveStoredJPEGImage(string, bufferedImage, bl, bl2);
        } else if (string2.contains("png")) {
            if (!bl) {
                this.image_type.put(string, "png");
            }
            bl3 = this.saveStoredImage("PNG", ".png", ".png", string, bufferedImage, bl, bl2);
        }
        return bl3;
    }

    public final String getImageType(String string) {
        return (String)this.image_type.get(string);
    }

    public final void init(String string) {
        this.key = string + System.currentTimeMillis();
        File file = new File(temp_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public final synchronized BufferedImage loadStoredImage(String string) {
        if (string == null) {
            return null;
        }
        string = ObjectStore.removeIllegalFileNameCharacters(string);
        String string2 = (String)this.image_type.get(string);
        BufferedImage bufferedImage = null;
        if (string2 == null) {
            return null;
        }
        if (string2.equals("tif")) {
            bufferedImage = this.loadStoredImage(string, ".tif");
        } else if (string2.equals("jpg")) {
            bufferedImage = this.loadStoredJPEGImage(string);
        } else if (string2.equals("png")) {
            bufferedImage = this.loadStoredImage(string, ".png");
        }
        return bufferedImage;
    }

    public final synchronized boolean isImageCached(String string) {
        String string2 = (String)this.image_type.get(string = ObjectStore.removeIllegalFileNameCharacters(string));
        if (string2 == null) {
            return false;
        }
        String string3 = temp_dir + this.key + string + '.' + string2;
        File file = new File(string3);
        return file.exists();
    }

    public final synchronized void flush() {
        block10: {
            Object object;
            Object object22;
            for (Object object22 : this.imagesOnDiskAsBytes.keySet()) {
                if (object22 == null || !(object = new File((String)this.imagesOnDiskAsBytes.get(object22))).exists()) continue;
                object.delete();
            }
            this.imagesOnDiskAsBytes.clear();
            this.imagesOnDiskAsBytesW.clear();
            this.imagesOnDiskAsBytesH.clear();
            this.imagesOnDiskAsBytespX.clear();
            this.imagesOnDiskAsBytespY.clear();
            this.imagesOnDiskMask.clear();
            this.imagesOnDiskColSpaceID.clear();
            Iterator iterator = this.tempFileNames.keySet().iterator();
            while (iterator.hasNext()) {
                object22 = (String)iterator.next();
                if (!((String)object22).contains(this.key)) continue;
                object = new File((String)object22);
                if (object.delete()) {
                    iterator.remove();
                    continue;
                }
                undeletedFiles.put(this.key, "x");
            }
            try {
                if (!checkedThisSession && temp_dir.length() > 2) {
                    checkedThisSession = true;
                    object22 = new File(temp_dir);
                    object = ((File)object22).list();
                    File[] fileArray = ((File)object22).listFiles();
                    if (object != null) {
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            boolean bl;
                            if (object[i].contains(this.key)) {
                                File file = new File(temp_dir + object[i]);
                                file.delete();
                            }
                            if (!(bl = true) || object[i].endsWith(".pdf") || System.currentTimeMillis() - fileArray[i].lastModified() < 14400000L) continue;
                            fileArray[i].delete();
                        }
                    }
                }
                if (((File)(object22 = new File(cmyk_dir))).exists()) {
                    ((File)object22).delete();
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block10;
                LogWriter.writeLog("Exception " + exception + " flushing files");
            }
        }
    }

    public static void copyCMYKimages(String string) {
        File file = new File(cmyk_dir);
        if (file.exists()) {
            String[] stringArray = file.list();
            if (stringArray.length > 0) {
                Object object;
                if (!string.endsWith(separator)) {
                    string = string + separator;
                }
                if (!((File)(object = new File(string))).exists()) {
                    ((File)object).mkdirs();
                }
            }
            for (String string2 : stringArray) {
                File file2 = new File(cmyk_dir + (String)string2);
                File file3 = new File(string + (String)string2);
                file2.renameTo(file3);
            }
        }
    }

    private synchronized boolean saveStoredJPEGImage(String string, BufferedImage bufferedImage, boolean bl, boolean bl2) {
        String string2;
        String string3;
        boolean bl3;
        block5: {
            bl3 = false;
            string3 = string;
            string2 = "";
            if (!bl) {
                string3 = temp_dir + this.key + string;
                string2 = temp_dir + this.key + 'R' + string;
                this.image_type.put('R' + string, this.image_type.get(string));
            }
            if (!string3.toLowerCase().endsWith(".jpg") & !string3.toLowerCase().endsWith(".jpeg")) {
                string3 = string3 + ".jpg";
                string2 = string2 + ".jpg";
            }
            try {
                this.images.write(bufferedImage, "jpg", string3);
                this.tempFileNames.put(string3, "#");
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Exception " + exception + " writing image " + bufferedImage + " as " + string3);
            }
        }
        if (bl2) {
            ObjectStore.saveCopy(string3, string2);
            this.tempFileNames.put(string2, "#");
        }
        return bl3;
    }

    public String getFileForCachedImage(String string) {
        return temp_dir + this.key + string + '.' + this.image_type.get(string);
    }

    private synchronized BufferedImage loadStoredImage(String string, String string2) {
        string = ObjectStore.removeIllegalFileNameCharacters(string);
        String string3 = temp_dir + this.key + string + string2;
        BufferedImage bufferedImage = this.images.read(string3);
        return bufferedImage;
    }

    private static void saveCopy(String string, String string2) {
        block6: {
            FilterOutputStream filterOutputStream;
            BufferedInputStream bufferedInputStream;
            block5: {
                bufferedInputStream = null;
                filterOutputStream = null;
                try {
                    int n;
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
                    byte[] byArray = new byte[65535];
                    while ((n = bufferedInputStream.read(byArray)) != -1) {
                        ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block5;
                    LogWriter.writeLog("Exception " + exception + " copying file");
                }
            }
            try {
                filterOutputStream.close();
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception " + exception + " closing files");
            }
        }
    }

    public final void saveAsCopy(String string, String string2) {
        block6: {
            FilterOutputStream filterOutputStream;
            BufferedInputStream bufferedInputStream;
            block5: {
                bufferedInputStream = null;
                filterOutputStream = null;
                string = ObjectStore.removeIllegalFileNameCharacters(string);
                String string3 = temp_dir + this.key + string;
                try {
                    int n;
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(string3));
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
                    byte[] byArray = new byte[65535];
                    while ((n = bufferedInputStream.read(byArray)) != -1) {
                        ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block5;
                    LogWriter.writeLog("Exception " + exception + " copying file");
                }
            }
            try {
                filterOutputStream.close();
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception " + exception + " closing files");
            }
        }
    }

    public static void copy(String string, String string2) {
        BufferedOutputStream bufferedOutputStream;
        BufferedInputStream bufferedInputStream;
        block2: {
            bufferedInputStream = null;
            bufferedOutputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception " + exception + " copying file");
            }
        }
        ObjectStore.copy(bufferedInputStream, bufferedOutputStream);
    }

    public static void copy(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) {
        block6: {
            block5: {
                try {
                    int n;
                    byte[] byArray = new byte[65535];
                    while ((n = bufferedInputStream.read(byArray)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block5;
                    LogWriter.writeLog("Exception " + exception + " copying file");
                }
            }
            try {
                bufferedOutputStream.close();
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception " + exception + " closing files");
            }
        }
    }

    private synchronized BufferedImage loadStoredJPEGImage(String string) {
        String string2 = temp_dir + this.key + string + ".jpg";
        BufferedImage bufferedImage = null;
        File file = new File(string2);
        if (file.exists()) {
            try {
                bufferedImage = this.images.read(string2);
            }
            catch (Exception exception) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception " + exception + " loading " + string);
                }
            }
        } else {
            bufferedImage = new BufferedImage(100, 100, 1);
        }
        return bufferedImage;
    }

    private synchronized boolean saveStoredImage(String string, String string2, String string3, String string4, BufferedImage bufferedImage, boolean bl, boolean bl2) {
        boolean bl3 = false;
        String string5 = string4 = ObjectStore.removeIllegalFileNameCharacters(string4);
        String string6 = "";
        if (!bl) {
            string5 = temp_dir + this.key + string4;
            string6 = temp_dir + this.key + 'R' + string4;
            this.image_type.put('R' + string4, this.image_type.get(string4));
        }
        if (!string5.toLowerCase().endsWith(string2) & !string5.toLowerCase().endsWith(string3)) {
            string5 = string5 + string2;
            string6 = string6 + string2;
        }
        try {
            if (!JAIHelper.isJAIused() && string.equals("TIFF")) {
                this.images.write(bufferedImage, "png", string5);
            } else {
                this.images.write(bufferedImage, string, string5);
            }
            File file = new File(string5);
            if (file.length() == 0L) {
                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
                if (!JAIHelper.isJAIused() && string.equals("TIFF")) {
                    this.images.write(bufferedImage, "png", string5);
                } else {
                    this.images.write(bufferedImage, string, string5);
                }
            }
            this.tempFileNames.put(string5, "#");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (LogWriter.isOutput()) {
                LogWriter.writeLog(" Exception " + exception + " writing image " + bufferedImage + " with type " + bufferedImage.getType());
            }
            bl3 = true;
        }
        catch (Error error) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Error " + error + " writing image " + bufferedImage + " with type " + bufferedImage.getType());
            }
            bl3 = true;
        }
        if (bl2) {
            ObjectStore.saveCopy(string5, string6);
            this.tempFileNames.put(string6, "#");
        }
        return bl3;
    }

    public static synchronized void flushPages() {
        block4: {
            try {
                File file;
                for (Object k : pagesOnDisk.keySet()) {
                    if (k == null || !(file = new File((String)pagesOnDisk.get(k))).exists()) continue;
                    file.delete();
                }
                pagesOnDisk.clear();
                for (Object k : pagesOnDiskAsBytes.keySet()) {
                    if (k == null || !(file = new File((String)pagesOnDiskAsBytes.get(k))).exists()) continue;
                    file.delete();
                }
                pagesOnDiskAsBytes.clear();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception " + exception + " flushing files");
            }
        }
    }

    public void finalize() {
        block3: {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + throwable.getMessage());
            }
        }
        this.flush();
        for (Object k : undeletedFiles.keySet()) {
            String string = (String)k;
            File file = new File(string);
            if (!file.delete()) continue;
            undeletedFiles.remove(string);
        }
    }

    public static DynamicVectorRenderer getCachedPage(Integer n) {
        SwingDisplay swingDisplay;
        block3: {
            swingDisplay = null;
            Object v = pagesOnDisk.get(n);
            if (v != null) {
                try {
                    File file = new File((String)v);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    byte[] byArray = new byte[(int)file.length()];
                    bufferedInputStream.read(byArray);
                    bufferedInputStream.close();
                    swingDisplay = new SwingDisplay(byArray, new HashMap());
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
        return swingDisplay;
    }

    public static void cachePage(Integer n, DynamicVectorRenderer dynamicVectorRenderer) {
        block2: {
            try {
                File file = File.createTempFile("page", ".bin", new File(temp_dir));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                bufferedOutputStream.write(dynamicVectorRenderer.serializeToByteArray(null));
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                pagesOnDisk.put(n, file.getAbsolutePath());
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
    }

    public static byte[] getCachedPageAsBytes(String string) {
        byte[] byArray;
        block3: {
            byArray = null;
            Object v = pagesOnDiskAsBytes.get(string);
            if (v != null) {
                try {
                    File file = new File((String)v);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    byArray = new byte[(int)file.length()];
                    bufferedInputStream.read(byArray);
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
        return byArray;
    }

    public static void cachePageAsBytes(String string, byte[] byArray) {
        block3: {
            try {
                File file;
                if (pagesOnDiskAsBytes.containsKey(string) && (file = new File((String)pagesOnDiskAsBytes.get(string))).exists()) {
                    file.delete();
                }
                file = File.createTempFile("bytes", ".bin", new File(temp_dir));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                bufferedOutputStream.write(byArray);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                pagesOnDiskAsBytes.put(string, file.getAbsolutePath());
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
    }

    public void saveRawImageData(String string, byte[] byArray, int n, int n2, int n3, int n4, byte[] byArray2, int n5) {
        block2: {
            try {
                File file = File.createTempFile("image", ".bin", new File(temp_dir));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                bufferedOutputStream.write(byArray);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                Integer n6 = new Integer(string);
                this.imagesOnDiskAsBytes.put(n6, file.getAbsolutePath());
                this.imagesOnDiskAsBytesW.put(n6, n);
                this.imagesOnDiskAsBytesH.put(n6, n2);
                this.imagesOnDiskAsBytespX.put(n6, n3);
                this.imagesOnDiskAsBytespY.put(n6, n4);
                this.imagesOnDiskMask.put(n6, byArray2);
                this.imagesOnDiskColSpaceID.put(n6, n5);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
    }

    public boolean isRawImageDataSaved(String string) {
        return this.imagesOnDiskAsBytes.get(new Integer(string)) != null;
    }

    public byte[] getRawImageData(String string) {
        byte[] byArray;
        block3: {
            byArray = null;
            Object v = this.imagesOnDiskAsBytes.get(new Integer(string));
            if (v != null) {
                try {
                    File file = new File((String)v);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    byArray = new byte[(int)file.length()];
                    bufferedInputStream.read(byArray);
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
        return byArray;
    }

    public Object getRawImageDataParameter(String string, Integer n) {
        if (n.equals(IMAGE_WIDTH)) {
            return this.imagesOnDiskAsBytesW.get(new Integer(string));
        }
        if (n.equals(IMAGE_HEIGHT)) {
            return this.imagesOnDiskAsBytesH.get(new Integer(string));
        }
        if (n.equals(IMAGE_pX)) {
            return this.imagesOnDiskAsBytespX.get(new Integer(string));
        }
        if (n.equals(IMAGE_pY)) {
            return this.imagesOnDiskAsBytespY.get(new Integer(string));
        }
        if (n.equals(IMAGE_MASKCOL)) {
            return this.imagesOnDiskMask.get(new Integer(string));
        }
        if (n.equals(IMAGE_COLORSPACE)) {
            return this.imagesOnDiskColSpaceID.get(new Integer(string));
        }
        return null;
    }

    public static File createTempFile(String string) throws IOException {
        String string2 = string.substring(0, string.lastIndexOf(46));
        while (string2.length() < 3) {
            string2 = string2 + 'a';
        }
        String string3 = string.substring(string.lastIndexOf(46));
        if (string3.length() < 3) {
            string3 = "pdf";
        }
        File file = File.createTempFile(string2, string3, new File(temp_dir));
        return file;
    }

    public static String removeIllegalFileNameCharacters(String string) {
        return string;
    }

    public void setFileToDeleteOnFlush(String string) {
        this.tempFileNames.put(string, "#");
    }

    public String getKey() {
        return this.key;
    }
}

