/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.Serializable;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ArrayDecoder;
import org.jpedal.io.ColorObjectDecoder;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.objects.raw.ColorSpaceObject;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.NamesObject;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class ObjectDecoder
implements Serializable {
    PdfFileReader objectReader = null;
    DecryptionFactory decryption = null;
    private Object PDFkey;
    static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    static final boolean debugFastCode = false;
    private int pdfKeyType;
    private int PDFkeyInt;
    static String padding = "";
    boolean isInlineImage = false;
    private int endPt = -1;

    public ObjectDecoder(PdfFileReader pdfFileReader) {
        this.init(pdfFileReader);
    }

    private ObjectDecoder() {
    }

    private void init(PdfFileReader pdfFileReader) {
        this.objectReader = pdfFileReader;
        this.decryption = pdfFileReader.getDecryptionObject();
    }

    public int readDictionaryAsObject(PdfObject pdfObject, int n, byte[] byArray) {
        if (this.endPt == -1) {
            this.endPt = byArray.length;
        }
        int n2 = byArray.length;
        n = this.readObjectDataValues(pdfObject, n, byArray, n2);
        if (!pdfObject.ignoreStream() && pdfObject.getGeneralType(-1) != 6420) {
            this.readStreamData(pdfObject, n, byArray, n2);
        }
        if (pdfObject.getObjectType() == 373244477) {
            this.setFieldNames(pdfObject);
        }
        return n;
    }

    private int readObjectDataValues(PdfObject pdfObject, int n, byte[] byArray, int n2) {
        int n3 = 0;
        if (this.isInlineImage) {
            n3 = 1;
        }
        while (true) {
            if (n < n2 && byArray[n] == 37) {
                n = ObjectDecoder.stripComment(n2, n, byArray);
            }
            if (n >= n2 || this.endPt != -1 && n >= this.endPt || byArray[n] == 101 && byArray[n + 1] == 110 && byArray[n + 2] == 100 && byArray[n + 3] == 111 || byArray[n] == 115 && byArray[n + 1] == 116 && byArray[n + 2] == 114 && byArray[n + 3] == 101 && byArray[n + 4] == 97 && byArray[n + 5] == 109) break;
            if (byArray[n] == 60 && byArray[n + 1] == 60) {
                ++n;
                ++n3;
            } else if (byArray[n] == 62 && n + 1 != n2 && byArray[n + 1] == 62 && byArray[n - 1] != 62) {
                ++n;
                if (--n3 == 0) {
                    break;
                }
            } else if (byArray[n] == 47 && (byArray[n + 1] == 47 || byArray[n + 1] == 32)) {
                ++n;
            } else if (byArray[n] == 47) {
                int n4;
                int n5 = ++n;
                if ((n += (n4 = ObjectDecoder.findDictionaryEnd(n, byArray, n2))) == n2) break;
                boolean bl = false;
                if (pdfObject.getID() == 1184787) {
                    bl = ObjectDecoder.isStringPair(n, byArray, bl);
                }
                int n6 = pdfObject.getObjectType();
                boolean bl2 = this.isMapObject(pdfObject, n, byArray, n2, n5, n4, bl, n6);
                if (byArray[n] == 47 || byArray[n] == 40 || byArray[n] == 91) {
                    --n;
                }
                if (this.pdfKeyType == -1) {
                    n = ObjectUtils.handleUnknownType(n, byArray, n2);
                }
                if (this.PDFkeyInt != -1 && this.pdfKeyType != -1) {
                    n = this.setValue(pdfObject, n, byArray, n2, bl2);
                }
            } else if (byArray[n] == 91 && n3 == 0 && pdfObject.getObjectType() == 1485011327) {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, byArray.length, 18, null, 826094945);
                arrayDecoder.readArray(false, byArray, pdfObject, 339034948);
            }
            ++n;
        }
        return n;
    }

    private boolean isMapObject(PdfObject pdfObject, int n, byte[] byArray, int n2, int n3, int n4, boolean bl, int n5) {
        boolean bl2;
        if (n5 == 487790868 && (pdfObject.getID() == 893350012 || pdfObject.getID() == 1184787 && bl || pdfObject.getID() == 17 && byArray[n - 2] == 47)) {
            this.pdfKeyType = 30;
            this.PDFkey = PdfDictionary.getKey(n3, n4, byArray);
            this.PDFkeyInt = 487790868;
            bl2 = true;
        } else {
            bl2 = false;
            this.PDFkey = null;
            this.getKeyType(pdfObject, n, byArray, n2, n4, n3, n5);
        }
        return bl2;
    }

    private static int findDictionaryEnd(int n, byte[] byArray, int n2) {
        int n3 = 0;
        while (byArray[n] != 32 && byArray[n] != 13 && byArray[n] != 9 && byArray[n] != 10 && byArray[n] != 91 && byArray[n] != 47 && byArray[n] != 40 && byArray[n] != 60 && byArray[n] != 62) {
            ++n3;
            if (++n != n2) continue;
            break;
        }
        return n3;
    }

    private void getKeyType(PdfObject pdfObject, int n, byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6;
        this.PDFkeyInt = PdfDictionary.getIntKey(n4, n3, byArray);
        if (this.PDFkeyInt == 895578984 && (n5 == 7451 || n5 == 373244477 || n5 == 2004845231)) {
            this.PDFkeyInt = 25;
        }
        if (this.isInlineImage) {
            this.PDFkeyInt = PdfObjectFactory.getInlineID(this.PDFkeyInt);
        }
        int n7 = pdfObject.getID();
        if (n5 == 2004251818 && (this.PDFkeyInt == 2087749783 || this.PDFkeyInt == -1938465939 || this.PDFkeyInt == 878474856 || this.PDFkeyInt == 979194486 || this.PDFkeyInt == 373243460 || this.PDFkeyInt == 1146450818)) {
            this.pdfKeyType = 2;
        } else if (n5 == 1485011327 && this.PDFkeyInt == 20) {
            this.PDFkeyInt = 339034948;
            this.pdfKeyType = 18;
        } else if ((n5 == 373244477 || n5 == 7451) && this.PDFkeyInt == 20) {
            if (n7 == 4384 || n7 == 4369) {
                this.pdfKeyType = 40;
            } else if (n7 == 2570558) {
                this.pdfKeyType = 25;
            } else {
                this.PDFkeyInt = 339034948;
                this.pdfKeyType = 18;
            }
        } else {
            this.pdfKeyType = !(n5 != 373244477 && n5 != 7451 || n7 != 4384 && n7 != 4369 || this.PDFkeyInt != 17) ? 40 : (this.PDFkeyInt == 1110717793 && n5 == -1567847737 ? 22 : (this.PDFkeyInt == 506543413 && n5 == -1567847737 ? 25 : ((n5 == 2087749783 || n5 == 1518239089) && this.PDFkeyInt == 30 ? 7 : (this.PDFkeyInt == 826096968 && n5 == 2087749783 && pdfObject.getParameterConstant(2087749783) == 391471749 ? 7 : (n7 == 2570558 && pdfObject.getObjectType() == 373244477 && (this.PDFkeyInt == 32 || this.PDFkeyInt == 31) ? 25 : (this.isInlineImage && this.PDFkeyInt == 2087749783 ? 1 : PdfDictionary.getKeyType(this.PDFkeyInt, n5)))))));
        }
        if (n7 == 878474856 && this.PDFkeyInt == 1518239089) {
            n6 = n;
            while (byArray[n6] >= 48 && byArray[n6] < 58 || byArray[n6] == 32) {
                ++n6;
            }
            if (byArray[n6] == 91) {
                this.pdfKeyType = 14;
            }
        }
        if (this.pdfKeyType == -1 && n7 == 1448698499) {
            this.pdfKeyType = ObjectDecoder.getPairedValues(pdfObject, n, byArray, this.pdfKeyType, n2, n3, n4);
        } else if ((n7 == 30 || n7 == 20 || n7 == 34) && pdfObject.getParentID() == 4384 && pdfObject.getObjectType() == 373244477 && byArray[n] != 91) {
            n6 = n;
            while (byArray[n6] >= 48 && byArray[n6] < 58 || byArray[n6] == 32) {
                ++n6;
            }
            if (!(byArray[n4] == 76 && byArray[n4 + 1] == 101 && byArray[n4 + 2] == 110 && byArray[n4 + 3] == 103 && byArray[n4 + 4] == 116 && byArray[n4 + 5] == 104 || byArray[n4] == 79 && byArray[n4 + 1] == 110 || byArray[n4] == 79 && byArray[n4 + 1] == 102 && byArray[n4 + 2] == 102 || byArray[n6] != 82)) {
                this.pdfKeyType = ObjectDecoder.getPairedValues(pdfObject, n, byArray, this.pdfKeyType, n2, n3, n4);
            }
        }
        if (this.PDFkeyInt == 1888135062) {
            this.pdfKeyType = ObjectDecoder.setTypeForDecodeParams(n, byArray, n2, this.pdfKeyType);
        }
    }

    private int setValue(PdfObject pdfObject, int n, byte[] byArray, int n2, boolean bl) {
        boolean bl2 = pdfObject.ignoreRecursion();
        if (this.pdfKeyType == 5 && pdfObject.isDataExternal()) {
            this.pdfKeyType = 1;
        }
        switch (this.pdfKeyType) {
            case 25: {
                n = this.setTextStreamValue(pdfObject, n, byArray, bl2);
                break;
            }
            case 35: {
                n = this.setNameTreeValue(pdfObject, n, byArray, n2, bl2);
                break;
            }
            case 2: {
                n = this.setDictionaryValue(pdfObject, n, byArray, n2, bl2);
                break;
            }
            case 20: {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, this.endPt, 20);
                n = arrayDecoder.readArray(bl2, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 12: {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, this.endPt, 12);
                n = arrayDecoder.readArray(false, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 14: {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, this.endPt, 14);
                n = arrayDecoder.readArray(bl2, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 18: {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, this.endPt, 18);
                n = arrayDecoder.readArray(bl2, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 22: {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, this.endPt, 22);
                n = arrayDecoder.readArray(false, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 16: {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, this.endPt, 16);
                n = arrayDecoder.readArray(false, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 9: {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, this.endPt, 9);
                n = arrayDecoder.readArray(false, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 10: {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, this.endPt, 10);
                n = arrayDecoder.readArray(false, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 30: {
                n = this.setNameStringValue(pdfObject, n, byArray, bl);
                break;
            }
            case 8: {
                n = this.setBooleanValue(pdfObject, n, byArray, this.PDFkeyInt);
                break;
            }
            case 3: {
                n = this.setStringConstantValue(pdfObject, n, byArray);
                break;
            }
            case 4: {
                n = this.setStringKeyValue(pdfObject, n, byArray);
                break;
            }
            case 6: {
                ++n;
                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                    ++n;
                }
                n = this.setNumberValue(pdfObject, n, byArray, this.PDFkeyInt);
                break;
            }
            case 7: {
                n = this.setFloatValue(pdfObject, n, byArray, n2);
                break;
            }
            case 5: {
                n = this.setUnreadDictionaryValue(pdfObject, n, byArray);
                break;
            }
            case 40: {
                if (byArray.length - 5 > 0 && byArray[n + 1] == 110 && byArray[n + 2] == 117 && byArray[n + 3] == 108 && byArray[n + 4] == 108) {
                    n += 5;
                    break;
                }
                n = this.setVariousValue(pdfObject, n, byArray, n2, this.PDFkeyInt, bl, bl2);
                break;
            }
            case 1: {
                n = this.setDictionaryValue(pdfObject, n, byArray, bl2);
            }
        }
        return n;
    }

    private static boolean isStringPair(int n, byte[] byArray, boolean bl) {
        int n2 = byArray.length;
        for (int i = n; i < n2; ++i) {
            if (byArray[i] == 40) {
                i = n2;
                bl = true;
                continue;
            }
            if (byArray[i] == 47 || byArray[i] == 62 || byArray[i] == 60 || byArray[i] == 91 || byArray[i] == 82) {
                i = n2;
                continue;
            }
            if (byArray[i] != 77 || byArray[i + 1] != 67 || byArray[i + 2] != 73 || byArray[i + 3] != 68) continue;
            i = n2;
        }
        return bl;
    }

    private static int stripComment(int n, int n2, byte[] byArray) {
        while (n2 < n && byArray[n2] != 10 && byArray[n2] != 13) {
            ++n2;
        }
        while (n2 < n && (byArray[n2] == 9 || byArray[n2] == 10 || byArray[n2] == 13 || byArray[n2] == 32 || byArray[n2] == 60)) {
            ++n2;
        }
        return n2;
    }

    private int setVariousValue(PdfObject pdfObject, int n, byte[] byArray, int n2, int n3, boolean bl, boolean bl2) {
        if (byArray[n] != 60) {
            ++n;
        }
        if (byArray[n] == 47) {
            n = this.setNameStringValue(pdfObject, n, byArray, bl);
        } else if (byArray[n] == 102 && byArray[n + 1] == 97 && byArray[n + 2] == 108 && byArray[n + 3] == 115 && byArray[n + 4] == 101) {
            pdfObject.setBoolean(n3, false);
            n += 4;
        } else if (byArray[n] == 116 && byArray[n + 1] == 114 && byArray[n + 2] == 117 && byArray[n + 3] == 101) {
            pdfObject.setBoolean(n3, true);
            n += 3;
        } else if (byArray[n] == 40 || byArray[n] == 60 && byArray[n - 1] != 60 && byArray[n + 1] != 60) {
            n = this.readTextStream(pdfObject, n, byArray, n3, bl2);
        } else if (byArray[n] == 91) {
            if (n3 == 2627089) {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, this.endPt, 18);
                n = arrayDecoder.readArray(bl2, byArray, pdfObject, n3);
            } else if (n3 == 27) {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, this.endPt, 20);
                n = arrayDecoder.readArray(bl2, byArray, pdfObject, n3);
            } else if (n3 == 19) {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, this.endPt, 10);
                n = arrayDecoder.readArray(bl2, byArray, pdfObject, n3);
            } else {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, this.endPt, 20);
                n = arrayDecoder.readArray(bl2, byArray, pdfObject, n3);
            }
        } else if (byArray[n] == 60 && byArray[n + 1] == 60) {
            n = this.readDictionary(pdfObject, n, byArray, n3, bl2);
        } else {
            int n4;
            int n5;
            int n6 = n;
            int n7 = n + 1;
            byte[] byArray2 = byArray;
            int n8 = 0;
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            String string = pdfObject.getObjectRefAsString();
            do {
                if (byArray2[n7] == 82 && !bl5) {
                    int n9;
                    bl4 = true;
                    n5 = n7;
                    n7 = n;
                    n = n5;
                    while (byArray2[n7] == 91 || byArray2[n7] == 32 || byArray2[n7] == 13 || byArray2[n7] == 10) {
                        ++n7;
                    }
                    int n10 = n7;
                    int n11 = n7;
                    while (byArray2[n7] != 10 && byArray2[n7] != 13 && byArray2[n7] != 32 && byArray2[n7] != 47 && byArray2[n7] != 60 && byArray2[n7] != 62) {
                        ++n7;
                    }
                    n4 = NumberUtils.parseInt(n10, n7, byArray2);
                    while (byArray2[n7] == 10 || byArray2[n7] == 13 || byArray2[n7] == 32) {
                        ++n7;
                    }
                    n10 = n7;
                    while (byArray2[n7] != 10 && byArray2[n7] != 13 && byArray2[n7] != 32 && byArray2[n7] != 47 && byArray2[n7] != 60 && byArray2[n7] != 62) {
                        ++n7;
                    }
                    int n12 = NumberUtils.parseInt(n10, n7, byArray2);
                    while (byArray2[n7] == 10 || byArray2[n7] == 13 || byArray2[n7] == 32 || byArray2[n7] == 47 || byArray2[n7] == 60) {
                        ++n7;
                    }
                    if (byArray2[n7] != 82) {
                        throw new RuntimeException("ref=" + n4 + " gen=" + n4 + " 1. Unexpected value " + byArray2[n7] + " in file - please send to IDRsolutions for analysis char=" + (char)byArray2[n7]);
                    }
                    string = new String(byArray2, n11, 1 + n7 - n11);
                    byte[] byArray3 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(n4, n12), n4, n12);
                    int n13 = 0;
                    int n14 = byArray3.length - 3;
                    for (n9 = 3; n9 < n14; ++n9) {
                        if (byArray3[n9 - 2] == 111 && byArray3[n9 - 1] == 98 && byArray3[n9] == 106) {
                            for (n13 = n9 + 1; n13 < n14 && (byArray3[n13] == 10 || byArray3[n13] == 13 || byArray3[n13] == 32 || byArray3[n13] == 9); ++n13) {
                            }
                            n9 = n14;
                            continue;
                        }
                        if (byArray3[n9] > 47 && byArray3[n9] < 58 || byArray3[n9] == 111 || byArray3[n9] == 98 || byArray3[n9] == 106 || byArray3[n9] == 82 || byArray3[n9] == 32 || byArray3[n9] == 10 || byArray3[n9] == 13) continue;
                        n9 = n14;
                        n13 = 0;
                    }
                    boolean bl6 = bl5 = byArray3[n13] == 40;
                    if (pdfObject.getID() == 4369 && byArray3[0] == 60 && byArray3[1] == 60) {
                        PdfObject pdfObject2 = ObjectFactory.createObject(n3, string, pdfObject.getObjectType(), pdfObject.getID());
                        pdfObject2.setID(n3);
                        pdfObject.setDictionary(n3, pdfObject2);
                        pdfObject2.setStatus(2);
                        pdfObject2.setUnresolvedData(byArray3, 2);
                        bl3 = false;
                        n8 = 4;
                        n = n7;
                        break;
                    }
                    if (pdfObject.getID() == -1 && byArray3[0] == 60 && byArray3[1] == 60) {
                        bl3 = false;
                        n8 = 0;
                        n = n7;
                        break;
                    }
                    if (n3 == 2037870513 && byArray2[n] == 82) {
                        n9 = 0;
                        while (byArray3[n9] != 91 && (byArray3[++n9] != 60 || byArray3[n9 + 1] == 60)) {
                        }
                        ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n9, this.endPt, 18);
                        arrayDecoder.readArray(bl2, byArray3, pdfObject, n3);
                        n = n7;
                        break;
                    }
                    byArray2 = byArray3;
                    if (byArray2 == null) {
                        pdfObject.setFullyResolved(false);
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("[Linearized] " + string + " not yet available (4)");
                        }
                        n = n2;
                        break;
                    }
                    n6 = 3;
                    if (byArray2.length <= 3) {
                        n6 = 0;
                    } else {
                        while (byArray2[n6 - 2] != 111 || byArray2[n6 - 1] != 98 || byArray2[n6] != 106) {
                            if (++n6 != byArray2.length) continue;
                            n6 = 0;
                            break;
                        }
                    }
                    if (byArray2[n6] != 40) {
                        ++n6;
                    }
                    while (byArray2[n6] == 10 || byArray2[n6] == 13 || byArray2[n6] == 32) {
                        ++n6;
                    }
                    n7 = n6;
                    continue;
                }
                if (byArray2[n7] == 91 || byArray2[n7] == 40) break;
                if (byArray2[n7] == 60) {
                    n8 = 0;
                    break;
                }
                if (byArray2[n7] == 62 || byArray2[n7] == 47) {
                    n8 = 1;
                    break;
                }
                if (byArray2[n7] == 32 || byArray2[n7] == 10 || byArray2[n7] == 13 || byArray2[n7] >= 48 && byArray2[n7] <= 57 || byArray2[n7] == 46) continue;
                bl3 = false;
            } while (++n7 != byArray2.length);
            n5 = 0;
            for (n4 = n6 + 1; n4 < byArray2.length; ++n4) {
                if (byArray2[n4] != 47) continue;
                ++n5;
            }
            while (byArray2[n6] == 10 || byArray2[n6] == 13 || byArray2[n6] == 32) {
                ++n6;
            }
            if (n8 != 4) {
                if (n5 == 0 && byArray2[n6] == 47) {
                    n6 = this.setNameStringValue(pdfObject, n6, byArray2, bl);
                } else if (byArray2[n6] == 40) {
                    n6 = this.readTextStream(pdfObject, n6, byArray2, n3, bl2);
                } else if (byArray2[n6] == 91) {
                    ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n6, this.endPt, 20);
                    n6 = arrayDecoder.readArray(bl2, byArray2, pdfObject, n3);
                } else if (n8 == 0) {
                    try {
                        n6 = this.readDictionaryFromRefOrDirect(-1, pdfObject, string, n6, byArray2, n3);
                    }
                    catch (Exception exception) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("Exception: " + exception.getMessage());
                        }
                    }
                } else if (bl3) {
                    n6 = this.setNumberValue(pdfObject, n6, byArray2, n3);
                } else if (n8 == 1) {
                    n6 = this.setNameStringValue(pdfObject, n6, byArray2, bl);
                }
            }
            if (!bl4) {
                n = n6;
            }
        }
        return n;
    }

    private static int setTypeForDecodeParams(int n, byte[] byArray, int n2, int n3) {
        int n4;
        for (n4 = n; n4 < n2 && (byArray[n4] == 32 || byArray[n4] == 9 || byArray[n4] == 13 || byArray[n4] == 10); ++n4) {
        }
        if (byArray[n4] != 60) {
            while (n4 < n2 && (byArray[n4] == 32 || byArray[n4] == 9 || byArray[n4] == 13 || byArray[n4] == 10 || byArray[n4] == 91)) {
                ++n4;
            }
            if (byArray[n4] == 60) {
                n3 = 22;
            }
        }
        return n3;
    }

    private int setNameTreeValue(PdfObject pdfObject, int n, byte[] byArray, int n2, boolean bl) {
        int n3;
        boolean bl2 = false;
        while (byArray[n] != 91) {
            if (byArray[n] == 40) {
                bl2 = false;
                break;
            }
            if (byArray[n] >= 48 && byArray[n] <= 57) {
                bl2 = true;
                break;
            }
            ++n;
        }
        byte[] byArray2 = byArray;
        int n4 = n;
        int n5 = n;
        int n6 = 0;
        if (bl2) {
            n3 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            int n7 = NumberUtils.parseInt(n3, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            n3 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            int n8 = NumberUtils.parseInt(n3, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            if (byArray[n] != 82) {
                throw new RuntimeException("3. Unexpected value in file " + byArray[n] + " - please send to IDRsolutions for analysis");
            }
            if (!bl) {
                byArray2 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(n7, n8), n7, n8);
                if (byArray2 == null) {
                    pdfObject.setFullyResolved(false);
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (1)");
                    }
                    n = n2;
                    return n;
                }
                n5 = 3;
                while (byArray2[n5 - 1] != 106 && byArray2[n5 - 2] != 98 && byArray2[n5 - 3] != 111) {
                    ++n5;
                }
                while (byArray2[n5] == 10 || byArray2[n5] == 13 || byArray2[n5] == 32) {
                    ++n5;
                }
                n4 = n5;
            }
        }
        while (n5 < byArray2.length) {
            if (byArray2[n5] == 91 || byArray2[n5] == 40) {
                ++n6;
            } else if (byArray2[n5] == 93 || byArray2[n5] == 41) {
                --n6;
            }
            if (n6 == 0) break;
            ++n5;
        }
        if (!bl) {
            byte[] byArray3;
            block23: {
                n3 = n5 - n4 + 1;
                byArray3 = new byte[n3];
                System.arraycopy(byArray2, n4, byArray3, 0, n3);
                if (pdfObject.getObjectType() != 1113489015 && this.decryption != null) {
                    try {
                        byArray3 = this.decryption.decrypt(byArray3, pdfObject.getObjectRefAsString(), false, null, false, false);
                    }
                    catch (PdfSecurityException pdfSecurityException) {
                        if (!LogWriter.isOutput()) break block23;
                        LogWriter.writeLog("Exception: " + pdfSecurityException.getMessage());
                    }
                }
            }
            pdfObject.setTextStreamValue(this.PDFkeyInt, byArray3);
        }
        if (!bl2) {
            n = n5;
        }
        return n;
    }

    private int setDictionaryValue(PdfObject pdfObject, int n, byte[] byArray, boolean bl) {
        boolean bl2;
        int n2 = n;
        int n3 = n;
        while (byArray[n3] == 10 || byArray[n3] == 32 || byArray[n3] == 9) {
            ++n3;
        }
        if (byArray[n3] == 110 && byArray[n3 + 1] == 117 && byArray[n3 + 2] == 108 && byArray[n3 + 3] == 108) {
            n = n3 + 4;
            return n;
        }
        if (byArray[n] != 60 && byArray[n + 1] != 60) {
            n2 += 2;
        }
        boolean bl3 = true;
        boolean bl4 = bl2 = byArray[n2 - 1] == 47;
        while (bl3) {
            if (byArray[n2] == 60 && byArray[n2 + 1] == 60) {
                int n4 = 1;
                ++n2;
                while (n4 > 0) {
                    if (byArray[n2] == 60 && byArray[n2 + 1] == 60) {
                        ++n4;
                        n2 += 2;
                        continue;
                    }
                    if (byArray[n2 - 1] == 62 && byArray[n2] == 62) {
                        if (--n4 <= 0) continue;
                        n2 += 2;
                        continue;
                    }
                    ++n2;
                }
                bl3 = false;
                continue;
            }
            if (byArray[n2] == 82) {
                bl3 = false;
                continue;
            }
            if (bl2 && (byArray[n2] == 32 || byArray[n2] == 13 || byArray[n2] == 10 || byArray[n2] == 9)) {
                bl3 = false;
                continue;
            }
            if (byArray[n2] == 47) {
                bl3 = false;
                --n2;
                continue;
            }
            if (byArray[n2] == 62 && byArray[n2 + 1] == 62) {
                bl3 = false;
                --n2;
                continue;
            }
            ++n2;
        }
        this.readDictionary(pdfObject, n, byArray, this.PDFkeyInt, bl);
        return n2;
    }

    private int setFloatValue(PdfObject pdfObject, int n, byte[] byArray, int n2) {
        int n3;
        ++n;
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
            ++n;
        }
        int n4 = n;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
            ++n;
        }
        float f = NumberUtils.parseFloat(n4, n, byArray);
        for (n3 = n; n3 < n2 && (byArray[n3] == 32 || byArray[n3] == 13 || byArray[n3] == 10); ++n3) {
        }
        if (byArray[n3] >= 48 && byArray[n3] <= 57) {
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            n4 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            int n5 = NumberUtils.parseInt(n4, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            if (byArray[n] != 82) {
                throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            byte[] byArray2 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed((int)f, n5), (int)f, n5);
            if (byArray2 == null) {
                pdfObject.setFullyResolved(false);
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (3)");
                }
                n = n2;
                return n;
            }
            int n6 = 3;
            while (byArray2[n6 - 1] != 106 && byArray2[n6 - 2] != 98 && byArray2[n6 - 3] != 111) {
                ++n6;
            }
            while (byArray2[n6] == 10 || byArray2[n6] == 13 || byArray2[n6] == 32) {
                ++n6;
            }
            int n7 = n6;
            while (byArray2[n7] != 10 && byArray2[n7] != 13 && byArray2[n7] != 32) {
                ++n7;
            }
            f = NumberUtils.parseFloat(n6, n7, byArray2);
        }
        pdfObject.setFloatNumber(this.PDFkeyInt, f);
        return --n;
    }

    private int setStringKeyValue(PdfObject pdfObject, int n, byte[] byArray) {
        ++n;
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
            ++n;
        }
        int n2 = n;
        int n3 = 1;
        boolean bl = false;
        while (byArray[n] != 82 && !bl) {
            if (this.PDFkeyInt == 1110793845 && byArray[n] == 110 && byArray[n + 1] == 117 && byArray[n + 2] == 108 && byArray[n + 3] == 108) {
                bl = true;
            }
            ++n;
            ++n3;
        }
        --n;
        if (!bl) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            pdfObject.setStringKey(this.PDFkeyInt, byArray2);
        }
        return n;
    }

    private int setDictionaryValue(PdfObject pdfObject, int n, byte[] byArray, int n2, boolean bl) {
        int n3;
        int n4;
        boolean bl2;
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
            ++n;
        }
        byte[] byArray2 = byArray;
        int n5 = n;
        boolean bl3 = bl2 = byArray2[n5] != 60;
        if (bl2) {
            n4 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            int n6 = NumberUtils.parseInt(n4, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            n4 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            n3 = NumberUtils.parseInt(n4, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            if (byArray[n] != 82) {
                throw new RuntimeException("3. Unexpected value in file " + byArray[n] + " - please send to IDRsolutions for analysis");
            }
            if (!bl) {
                byArray2 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(n6, n3), n6, n3);
                if (byArray2 == null) {
                    pdfObject.setFullyResolved(false);
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (2)");
                    }
                    n = n2;
                    return n;
                }
                if (byArray2[0] == 60 && byArray2[1] == 60) {
                    n5 = 0;
                } else {
                    n5 = 3;
                    while (byArray2[n5 - 1] != 106 && byArray2[n5 - 2] != 98 && byArray2[n5 - 3] != 111) {
                        if (byArray2[n5] == 47) {
                            n5 = 0;
                            break;
                        }
                        if (++n5 != byArray2.length) continue;
                        n5 = 0;
                        break;
                    }
                    while (byArray2[n5] == 10 || byArray2[n5] == 13 || byArray2[n5] == 32) {
                        ++n5;
                    }
                }
            }
        }
        n4 = n5;
        while (byArray2[n4] == 60 || byArray2[n4] == 32 || byArray2[n4] == 13 || byArray2[n4] == 10) {
            ++n4;
        }
        if (byArray2[n4] == 62) {
            n5 = n4 + 1;
        } else {
            PdfObject pdfObject2 = ObjectFactory.createObject(this.PDFkeyInt, pdfObject.getObjectRefAsString(), pdfObject.getObjectType(), pdfObject.getID());
            pdfObject2.setID(this.PDFkeyInt);
            if (bl) {
                n5 = this.readKeyPairs(this.PDFkeyInt, byArray2, n5, -2, null);
            } else {
                n3 = this.readKeyPairs(this.PDFkeyInt, byArray2, n5, -1, null);
                n5 = this.readKeyPairs(this.PDFkeyInt, byArray2, n5, n3, pdfObject2);
                pdfObject.setDictionary(this.PDFkeyInt, pdfObject2);
            }
        }
        if (!bl2) {
            n = n5;
        }
        return n;
    }

    private int setStringConstantValue(PdfObject pdfObject, int n, byte[] byArray) {
        ++n;
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
            ++n;
        }
        int n2 = n;
        int n3 = 0;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
            ++n;
            ++n3;
        }
        pdfObject.setConstant(this.PDFkeyInt, n2, n3, byArray);
        return --n;
    }

    private int setBooleanValue(PdfObject pdfObject, int n, byte[] byArray, int n2) {
        ++n;
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
            ++n;
        }
        int n3 = n;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
            ++n;
        }
        --n;
        if (byArray[n3] == 116 && byArray[n3 + 1] == 114 && byArray[n3 + 2] == 117 && byArray[n3 + 3] == 101) {
            pdfObject.setBoolean(n2, true);
        } else if (byArray[n3] == 102 && byArray[n3 + 1] == 97 && byArray[n3 + 2] == 108 && byArray[n3 + 3] == 115 && byArray[n3 + 4] == 101) {
            pdfObject.setBoolean(n2, false);
        } else {
            throw new RuntimeException("Unexpected value for Boolean value for" + n2 + '=' + this.PDFkey);
        }
        return n;
    }

    private int setTextStreamValue(PdfObject pdfObject, int n, byte[] byArray, boolean bl) {
        if (byArray[n + 1] == 40 && byArray[n + 2] == 41) {
            pdfObject.setTextStreamValue(this.PDFkeyInt, new byte[1]);
            if (byArray[n += 3] == 47) {
                --n;
            }
        } else {
            n = this.readTextStream(pdfObject, n, byArray, this.PDFkeyInt, bl);
        }
        return n;
    }

    private void setFieldNames(PdfObject pdfObject) {
        String string = pdfObject.getTextStreamValue(36);
        if (string != null) {
            String string2 = pdfObject.getStringKey(1110793845);
            boolean bl = false;
            while (string2 != null) {
                FormObject formObject = new FormObject(string2, false);
                this.objectReader.readObject(formObject);
                String string3 = formObject.getTextStreamValue(36);
                if (string == null && string3 != null) {
                    string = string3;
                } else if (!(string3 == null || string.equals(string3) && string2.equals(pdfObject.getObjectRefAsString()))) {
                    string = string3 + '.' + string;
                    bl = true;
                }
                if (string3 == null) break;
                string2 = formObject.getParentRef();
            }
            if (bl) {
                pdfObject.setTextStreamValue(36, StringUtils.toBytes(string));
            }
        }
    }

    private void readStreamData(PdfObject pdfObject, int n, byte[] byArray, int n2) {
        for (int i = n; i < n2 - 5 && (byArray[i] != 62 || byArray[i + 1] != 62); ++i) {
            if (byArray[i] != 115 || byArray[i + 1] != 116 || byArray[i + 2] != 114 || byArray[i + 3] != 101 || byArray[i + 4] != 97 || byArray[i + 5] != 109) continue;
            if (!pdfObject.isCached()) {
                this.readStreamIntoObject(pdfObject, i, byArray);
            }
            i = n2;
        }
    }

    private static int getPairedValues(PdfObject pdfObject, int n, byte[] byArray, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        int n6 = n;
        while (n6 < n3) {
            while (n6 < n3 && (byArray[n6] == 32 || byArray[n6] == 10 || byArray[n6] == 13 || byArray[n6] == 10)) {
                ++n6;
            }
            if (n6 < n3 && byArray[n6] >= 48 && byArray[n6] <= 57) {
                while (n6 < n3 && byArray[n6] >= 48 && byArray[n6] <= 57) {
                    ++n6;
                }
                while (n6 < n3 && (byArray[n6] == 32 || byArray[n6] == 10 || byArray[n6] == 13 || byArray[n6] == 10)) {
                    ++n6;
                }
                while (n6 < n3 && (byArray[n6] >= 48 && byArray[n6] <= 57 || byArray[n6] == 32 || byArray[n6] == 10 || byArray[n6] == 13 || byArray[n6] == 10)) {
                    ++n6;
                }
                if (n6 >= n3 || byArray[n6] != 82) break;
                ++n6;
            }
            while (n6 < n3 && (byArray[n6] == 32 || byArray[n6] == 10 || byArray[n6] == 13 || byArray[n6] == 10)) {
                ++n6;
            }
            if (byArray[n6] == 62 && byArray[n6 + 1] == 62) {
                bl = true;
                break;
            }
            if (byArray[n6] != 47) break;
            ++n6;
            while (n6 < n3 && byArray[n6] != 32 && byArray[n6] != 10 && byArray[n6] != 13 && byArray[n6] != 10) {
                ++n6;
            }
        }
        if (bl) {
            pdfObject.setCurrentKey(PdfDictionary.getKey(n5, n4, byArray));
            return 5;
        }
        return n2;
    }

    private int setUnreadDictionaryValue(PdfObject pdfObject, int n, byte[] byArray) {
        byte[] byArray2;
        int n2;
        if (byArray[n] != 60) {
            ++n;
        }
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 9) {
            ++n;
        }
        int n3 = n;
        PdfObject pdfObject2 = ObjectFactory.createObject(this.PDFkeyInt, pdfObject.getObjectRefAsString(), pdfObject.getObjectType(), pdfObject.getID());
        pdfObject2.setID(this.PDFkeyInt);
        if (byArray[n] != 110 || byArray[n + 1] != 117 || byArray[n + 2] != 108 || byArray[n + 3] != 108) {
            pdfObject.setDictionary(this.PDFkeyInt, pdfObject2);
        }
        int n4 = 2;
        if (byArray[n] == 47) {
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            int n5 = n;
            int n6 = 0;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
                ++n6;
            }
            --n;
            n2 = pdfObject2.setConstant(this.PDFkeyInt, n5, n6, byArray);
            if (n2 == -1 || this.isInlineImage) {
                byArray2 = new byte[n6];
                System.arraycopy(byArray, n5, byArray2, 0, n6);
                String string = new String(byArray2);
                pdfObject2.setGeneralStringValue(string);
            }
            n4 = 0;
        } else if (byArray[n] != 101 || byArray[n + 1] != 110 || byArray[n + 2] != 100 || byArray[n + 3] != 111 || byArray[n + 4] != 98) {
            while (byArray[n] == 91 && this.PDFkeyInt != 2087749783 || byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10) {
                ++n;
            }
            if (byArray[n] == 60 && byArray[n + 1] == 60) {
                n += 2;
                n2 = 1;
                while (n2 > 0) {
                    if (byArray[n] == 60 && byArray[n + 1] == 60) {
                        n += 2;
                        ++n2;
                        continue;
                    }
                    if (byArray[n] == 62 && n + 1 == byArray.length) {
                        n2 = 0;
                        continue;
                    }
                    if (byArray[n] == 62 && byArray[n + 1] == 62) {
                        n += 2;
                        --n2;
                        continue;
                    }
                    ++n;
                }
            } else if (byArray[n] == 91) {
                ++n;
                n2 = 1;
                while (n2 > 0) {
                    if (byArray[n] == 40) {
                        ++n;
                        while (byArray[n] != 41 || ObjectUtils.isEscaped(byArray, n)) {
                            ++n;
                        }
                    } else if (byArray[n] == 91) {
                        ++n2;
                    } else if (byArray[n] == 93) {
                        --n2;
                    }
                    ++n;
                }
                --n;
            } else if (byArray[n] == 110 && byArray[n + 1] == 117 && byArray[n + 2] == 108 && byArray[n + 3] == 108) {
                n += 4;
            } else {
                n4 = 1;
                while ((byArray[n] != 82 || byArray[n - 1] == 101) && ++n != byArray.length) {
                }
                if (++n >= byArray.length) {
                    n = byArray.length - 1;
                }
            }
        }
        pdfObject2.setStatus(n4);
        if (n4 != 0) {
            n2 = n - n3;
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n3, byArray2, 0, n2);
            if (byArray2[n2 - 1] == 82) {
                for (int i = 0; i < n2; ++i) {
                    if (byArray2[i] != 10 && byArray2[i] != 13) continue;
                    byArray2[i] = 32;
                }
            }
            pdfObject2.setUnresolvedData(byArray2, this.PDFkeyInt);
        }
        if (byArray[n] == 47 || byArray[n] == 62) {
            --n;
        }
        return n;
    }

    int readDictionary(PdfObject pdfObject, int n, byte[] byArray, int n2, boolean bl) {
        String string = pdfObject.getObjectRefAsString();
        if (byArray[n] != 60) {
            ++n;
        }
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
            ++n;
        }
        if (byArray[n] == 47) {
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            int n3 = n;
            int n4 = 0;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
                ++n4;
            }
            --n;
            if (!bl) {
                PdfObject pdfObject2 = ObjectFactory.createObject(n2, string, pdfObject.getObjectType(), pdfObject.getID());
                pdfObject2.setID(n2);
                int n5 = pdfObject2.setConstant(n2, n3, n4, byArray);
                if (n5 == -1 || this.isInlineImage) {
                    byte[] byArray2 = new byte[n4];
                    System.arraycopy(byArray, n3, byArray2, 0, n4);
                    String string2 = new String(byArray2);
                    pdfObject2.setGeneralStringValue(string2);
                }
                pdfObject.setDictionary(n2, pdfObject2);
                if (pdfObject.isDataExternal()) {
                    pdfObject2.isDataExternal(true);
                    if (!this.resolveFully(pdfObject2)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
            }
        } else if (byArray[n] != 101 || byArray[n + 1] != 110 || byArray[n + 2] != 100 || byArray[n + 3] != 111 || byArray[n + 4] != 98) {
            if (byArray[n] == 40 && n2 == 6691) {
                int n6 = ++n;
                while (n < byArray.length && (byArray[++n] != 41 || ObjectUtils.isEscaped(byArray, n))) {
                }
                byte[] byArray3 = ObjectUtils.readEscapedValue(n, byArray, n6, false);
                NamesObject namesObject = new NamesObject(string);
                namesObject.setDecodedStream(byArray3);
                pdfObject.setDictionary(6691, namesObject);
            } else if (bl) {
                while (byArray[n] == 91 || byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10) {
                    ++n;
                }
                if (byArray[n] == 60 && byArray[n + 1] == 60) {
                    n += 2;
                    int n7 = 1;
                    while (n7 > 0) {
                        if (byArray[n] == 60 && byArray[n + 1] == 60) {
                            n += 2;
                            ++n7;
                            continue;
                        }
                        if (byArray[n] == 62 && byArray[n + 1] == 62) {
                            n += 2;
                            --n7;
                            continue;
                        }
                        ++n;
                    }
                    --n;
                } else {
                    n = this.readDictionaryFromRefOrDirect(n2, pdfObject, string, n, byArray, n2);
                }
                if (n < byArray.length && byArray[n] == 47) {
                    --n;
                }
            } else {
                n = this.readDictionaryFromRefOrDirect(n2, pdfObject, string, n, byArray, n2);
            }
        }
        return n;
    }

    private int readTextStream(PdfObject pdfObject, int n, byte[] byArray, int n2, boolean bl) {
        block77: {
            if (n2 == 39 || n2 == 9986) {
                int n3;
                int n4;
                if (n2 == 9986) {
                    ++n;
                }
                boolean bl2 = false;
                while (byArray[n] != 91) {
                    if (byArray[n] == 40) {
                        bl2 = false;
                        break;
                    }
                    if (byArray[n] >= 48 && byArray[n] <= 57) {
                        bl2 = true;
                        break;
                    }
                    ++n;
                }
                byte[] byArray2 = byArray;
                int n5 = n;
                int n6 = n;
                int n7 = 0;
                if (bl2) {
                    n4 = n;
                    while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                        ++n;
                    }
                    int n8 = NumberUtils.parseInt(n4, n, byArray);
                    while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                        ++n;
                    }
                    n4 = n;
                    while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                        ++n;
                    }
                    n3 = NumberUtils.parseInt(n4, n, byArray);
                    while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                        ++n;
                    }
                    if (byArray[n] != 82) {
                        throw new RuntimeException("3. Unexpected value in file " + byArray[n] + " - please send to IDRsolutions for analysis");
                    }
                    if (!bl) {
                        byArray2 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(n8, n3), n8, n3);
                        if (byArray2 == null) {
                            pdfObject.setFullyResolved(false);
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (6)");
                            }
                            return byArray.length;
                        }
                        n6 = 3;
                        while (byArray2[n6 - 1] != 106 && byArray2[n6 - 2] != 98 && byArray2[n6 - 3] != 111) {
                            if (++n6 != byArray2.length) continue;
                            n6 = 0;
                            break;
                        }
                        while (byArray2[n6] == 10 || byArray2[n6] == 13 || byArray2[n6] == 32) {
                            ++n6;
                        }
                        n5 = n6;
                    }
                }
                while (n6 < byArray2.length) {
                    if (byArray2[n6] == 91 || byArray2[n6] == 40) {
                        ++n7;
                    } else if (byArray2[n6] == 93 || byArray2[n6] == 41) {
                        --n7;
                    }
                    if (n7 == 0) break;
                    ++n6;
                }
                if (!bl) {
                    n4 = n6 - n5 + 1;
                    byte[] byArray3 = new byte[n4];
                    System.arraycopy(byArray2, n5, byArray3, 0, n4);
                    if (n2 != 6691) {
                        for (n3 = 0; n3 < n4; ++n3) {
                            if (byArray3[n3] != 10 && byArray3[n3] != 13) continue;
                            byArray3[n3] = 32;
                        }
                    }
                    pdfObject.setTextStreamValue(n2, byArray3);
                }
                if (!bl2) {
                    n = n6;
                }
            } else {
                try {
                    int n9;
                    int n10;
                    int n11;
                    if (byArray[n] != 60 && byArray[n] != 40) {
                        ++n;
                    }
                    while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
                        ++n;
                    }
                    if (byArray[n] == 47) {
                        pdfObject.setTextStreamValue(n2, new byte[1]);
                        return --n;
                    }
                    boolean bl3 = byArray[n] != 60 && byArray[n] != 40;
                    int n12 = n;
                    byte[] byArray4 = byArray;
                    if (bl3) {
                        n11 = n;
                        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                            ++n;
                        }
                        n10 = NumberUtils.parseInt(n11, n, byArray);
                        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                            ++n;
                        }
                        n11 = n;
                        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                            ++n;
                        }
                        n9 = NumberUtils.parseInt(n11, n, byArray);
                        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                            ++n;
                        }
                        if (byArray[n] != 82) {
                            return byArray.length;
                        }
                        if (!bl) {
                            byArray4 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(n10, n9), n10, n9);
                            if (byArray4 == null) {
                                pdfObject.setFullyResolved(false);
                                if (LogWriter.isOutput()) {
                                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (7)");
                                }
                                return byArray.length;
                            }
                            if (byArray4[0] == 40) {
                                n12 = 0;
                            } else {
                                n12 = 3;
                                while (byArray4[n12 - 1] != 106 && byArray4[n12 - 2] != 98 && byArray4[n12 - 3] != 111) {
                                    ++n12;
                                }
                                while (byArray4[n12] == 10 || byArray4[n12] == 13 || byArray4[n12] == 32) {
                                    ++n12;
                                }
                            }
                        }
                    }
                    n11 = 0;
                    if (!bl3 || !bl) {
                        while (byArray4[n12] != 40 && byArray4[n12] != 60) {
                            ++n12;
                        }
                        n10 = byArray4[n12];
                        n11 = n12;
                        n9 = 1;
                        while (n12 < byArray4.length) {
                            if (!(n10 != 40 || byArray4[++n12] != 41 && byArray4[n12] != 40 || ObjectUtils.isEscaped(byArray4, n12))) {
                                if (byArray4[n12] == 40) {
                                    ++n9;
                                } else if (byArray4[n12] == 41) {
                                    --n9;
                                }
                                if (n9 == 0) break;
                            }
                            if (n10 != 60 || byArray4[n12] != 62 && byArray4[n12] != 0) continue;
                        }
                    }
                    if (!bl) {
                        byte[] byArray5;
                        block76: {
                            if (byArray4[n11] == 60) {
                                n9 = n12 - ++n11 >> 1;
                                byArray5 = new byte[n9];
                                int n13 = 0;
                                while (n11 != n12) {
                                    while (byArray4[n11] == 32 || byArray4[n11] == 10 || byArray4[n11] == 13) {
                                        ++n11;
                                    }
                                    int n14 = byArray4[n11];
                                    if (n14 >= 65 && n14 <= 70) {
                                        n14 -= 55;
                                    } else if (n14 >= 97 && n14 <= 102) {
                                        n14 -= 87;
                                    } else if (n14 >= 48 && n14 <= 57) {
                                        n14 -= 48;
                                    } else if (LogWriter.isOutput()) {
                                        LogWriter.writeLog("Unexpected number " + (char)byArray4[n11]);
                                    }
                                    ++n11;
                                    while (byArray4[n11] == 32 || byArray4[n11] == 10 || byArray4[n11] == 13) {
                                        ++n11;
                                    }
                                    int n15 = byArray4[n11];
                                    if (n15 >= 65 && n15 <= 70) {
                                        n15 -= 55;
                                    } else if (n15 >= 97 && n15 <= 102) {
                                        n15 -= 87;
                                    } else if (n15 >= 48 && n15 <= 57) {
                                        n15 -= 48;
                                    } else {
                                        if (LogWriter.isOutput()) {
                                            LogWriter.writeLog("Unexpected number " + (char)byArray4[n11]);
                                        }
                                        return n;
                                    }
                                    ++n11;
                                    int n16 = n15 + (n14 << 4);
                                    byArray5[n13] = (byte)n16;
                                    ++n13;
                                }
                            } else {
                                if (byArray4[n11] == 40) {
                                    ++n11;
                                }
                                byArray5 = ObjectUtils.readEscapedValue(n12, byArray4, n11, n2 == 6420);
                            }
                            if (pdfObject.getObjectType() != 1113489015) {
                                try {
                                    if (this.decryption != null && !pdfObject.isInCompressedStream()) {
                                        byArray5 = this.decryption.decryptString(byArray5, pdfObject.getObjectRefAsString());
                                    }
                                }
                                catch (PdfSecurityException pdfSecurityException) {
                                    if (!LogWriter.isOutput()) break block76;
                                    LogWriter.writeLog("Exception: " + pdfSecurityException.getMessage());
                                }
                            }
                        }
                        pdfObject.setTextStreamValue(n2, byArray5);
                    }
                    if (!bl3) {
                        n = n12;
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block77;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
        return n;
    }

    int setNumberValue(PdfObject pdfObject, int n, byte[] byArray, int n2) {
        int n3;
        int n4;
        int n5 = n;
        int n6 = byArray.length;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62 && byArray[n] != 40 && byArray[n] != 46) {
            ++n;
        }
        int n7 = NumberUtils.parseInt(n5, n, byArray);
        for (n4 = n; n4 < n6 && (byArray[n4] == 32 || byArray[n4] == 13 || byArray[n4] == 10); ++n4) {
        }
        boolean bl = false;
        if (byArray[n4] >= 48 && byArray[n4] <= 57) {
            n3 = n4;
            while (byArray[n3] != 10 && byArray[n3] != 13 && byArray[n3] != 32 && byArray[n3] != 47 && byArray[n3] != 60 && byArray[n3] != 62) {
                ++n3;
            }
            while (n3 < n6 && (byArray[n3] == 10 || byArray[n3] == 13 || byArray[n3] == 32 || byArray[n3] == 47)) {
                ++n3;
            }
            boolean bl2 = bl = n3 < n6 && byArray[n3] == 82;
        }
        if (bl) {
            int n8;
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            n5 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            n3 = NumberUtils.parseInt(n5, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            if (byArray[n] != 82) {
                throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            byte[] byArray2 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(n7, n3), n7, n3);
            if (byArray2 == null) {
                pdfObject.setFullyResolved(false);
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (8)");
                }
                return n6;
            }
            int n9 = 0;
            int n10 = byArray2.length;
            if ((n10 <= 1 || byArray2[0] != 60 || byArray2[1] != 60) && n10 >= 3) {
                n9 = 3;
                if (n10 > 3) {
                    while (byArray2[n9 - 1] != 106 && byArray2[n9 - 2] != 98 && byArray2[n9 - 3] != 111) {
                        if (++n9 != n10) continue;
                        n9 = 0;
                        break;
                    }
                }
            }
            if (n10 > 1) {
                while (n9 < byArray2.length && (byArray2[n9] == 9 || byArray2[n9] == 10 || byArray2[n9] == 13 || byArray2[n9] == 32)) {
                    ++n9;
                }
            }
            for (n8 = n9; n8 < n10 && byArray2[n8] != 9 && byArray2[n8] != 10 && byArray2[n8] != 13 && byArray2[n8] != 32; ++n8) {
            }
            n7 = NumberUtils.parseInt(n9, n8, byArray2);
        }
        pdfObject.setIntNumber(n2, n7);
        return --n;
    }

    int readDictionaryFromRefOrDirect(int n, PdfObject pdfObject, String string, int n2, byte[] byArray, int n3) {
        block43: {
            int n4;
            int n5;
            int n6;
            int n7;
            boolean bl;
            byte[] byArray2;
            int n8;
            block0: while (true) {
                int n9 = -1;
                while (byArray[n2] == 91 || byArray[n2] == 32 || byArray[n2] == 13 || byArray[n2] == 10) {
                    if (byArray[n2] == 91) {
                        n9 = n2;
                    }
                    ++n2;
                }
                if (n3 == 2087749783 || n == 2087749783 || pdfObject.getPDFkeyInt() == 2087749783) {
                    ColorObjectDecoder colorObjectDecoder = new ColorObjectDecoder(this.objectReader);
                    return colorObjectDecoder.processColorSpace(pdfObject, pdfObject.getObjectRefAsString(), n2, byArray);
                }
                if (n9 != -1 && (n3 == 489767739 || n3 == 9250 || n3 == 2037870513)) {
                    return this.processArray(pdfObject, byArray, n3, n9);
                }
                if (byArray[n2] == 37) {
                    while (byArray[n2] != 13 && byArray[n2] != 10) {
                        ++n2;
                    }
                    while (byArray[n2] == 91 || byArray[n2] == 32 || byArray[n2] == 13 || byArray[n2] == 10) {
                        ++n2;
                    }
                }
                if (byArray[n2] == 60) {
                    n2 = this.convertDirectDictionaryToObject(pdfObject, string, n2, byArray, n3);
                    break block43;
                }
                if (byArray[n2] == 47) {
                    n2 = ObjectUtils.setDirectValue(pdfObject, n2, byArray, n3);
                    break block43;
                }
                n8 = n2;
                byArray2 = byArray;
                while (true) {
                    block44: {
                        if (byArray2[n8] == 91 || byArray2[n8] == 32 || byArray2[n8] == 13 || byArray2[n8] == 10) {
                            ++n8;
                            continue;
                        }
                        bl = false;
                        do {
                            if (bl && byArray2[n8] == 93) {
                                return n8;
                            }
                            n7 = n8;
                            while (byArray2[n8] != 10 && byArray2[n8] != 13 && byArray2[n8] != 32 && byArray2[n8] != 47 && byArray2[n8] != 60 && byArray2[n8] != 62) {
                                if (byArray2[n8] == 108 && byArray2[n8 - 1] == 108 && byArray2[n8 - 2] == 117 && byArray2[n8 - 3] == 110) {
                                    bl = true;
                                }
                                if (bl && byArray2[n8] == 93) {
                                    return n8;
                                }
                                ++n8;
                            }
                            n6 = NumberUtils.parseInt(n7, n8, byArray2);
                            while (byArray2[n8] == 10 || byArray2[n8] == 13 || byArray2[n8] == 32) {
                                ++n8;
                            }
                            if (n6 != 69560 || byArray2[n7] != 110) break block44;
                            bl = true;
                        } while (byArray2[n8] != 60);
                        n2 = n8;
                        continue block0;
                    }
                    n7 = n8;
                    while (byArray2[n8] != 10 && byArray2[n8] != 13 && byArray2[n8] != 32 && byArray2[n8] != 47 && byArray2[n8] != 60 && byArray2[n8] != 62) {
                        ++n8;
                    }
                    n5 = NumberUtils.parseInt(n7, n8, byArray2);
                    while (byArray2[n8] == 10 || byArray2[n8] == 13 || byArray2[n8] == 32 || byArray2[n8] == 47 || byArray2[n8] == 60) {
                        ++n8;
                    }
                    if (byArray2[n8] != 82) {
                        throw new RuntimeException("ref=" + n6 + " gen=" + n6 + " 1. Unexpected value " + byArray2[n8] + " in file - please send to IDRsolutions for analysis char=" + (char)byArray2[n8]);
                    }
                    byArray2 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(n6, n5), n6, n5);
                    if (byArray2 == null) {
                        pdfObject.setFullyResolved(false);
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (11)");
                        }
                        return byArray.length;
                    }
                    if (byArray2 != null && byArray2.length > 4 && byArray2[0] == 37 && byArray2[1] == 80 && byArray2[2] == 68 && byArray2[3] == 70) {
                        byArray2 = null;
                    }
                    if (byArray2 == null) break block0;
                    n4 = 0;
                    if (byArray2[n4] != 91 && byArray2[0] != 60 && byArray2[1] != 60) {
                        while ((n4 < 3 || n4 > 2 && byArray2[n4 - 1] != 106 && byArray2[n4 - 2] != 98 && byArray2[n4 - 3] != 111) && byArray2[n4] != 47) {
                            ++n4;
                        }
                        while (byArray2[n4] != 91 && (byArray2[n4] == 10 || byArray2[n4] == 13 || byArray2[n4] == 32)) {
                            ++n4;
                        }
                    }
                    if (byArray2[n4] != 91) {
                        n8 = 0;
                        break block0;
                    }
                    n8 = n4;
                }
                break;
            }
            if (byArray2 != null) {
                while (byArray2[n8] == 10 || byArray2[n8] == 13 || byArray2[n8] == 32) {
                    ++n8;
                }
                boolean bl2 = bl = n8 < byArray.length && byArray[n8] == 60;
                if (bl) {
                    for (n4 = n8; n4 < byArray2.length && (byArray[n4] == 60 || byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32); ++n4) {
                    }
                    if (byArray[n4] == 47) {
                        bl = false;
                    }
                }
                if (bl) {
                    n7 = n8;
                    while (byArray2[n8] != 10 && byArray2[n8] != 13 && byArray2[n8] != 32 && byArray2[n8] != 47 && byArray2[n8] != 60 && byArray2[n8] != 62) {
                        ++n8;
                    }
                    n6 = NumberUtils.parseInt(n7, n8, byArray2);
                    while (byArray2[n8] == 10 || byArray2[n8] == 13 || byArray2[n8] == 32 || byArray2[n8] == 47 || byArray2[n8] == 60) {
                        ++n8;
                    }
                    n7 = n8;
                    while (byArray2[n8] != 10 && byArray2[n8] != 13 && byArray2[n8] != 32 && byArray2[n8] != 47 && byArray2[n8] != 60 && byArray2[n8] != 62) {
                        ++n8;
                    }
                    n5 = NumberUtils.parseInt(n7, n8, byArray2);
                    while (byArray2[n8 - 1] != 106 && byArray2[n8 - 2] != 98 && byArray2[n8 - 3] != 111 && byArray2[n8] != 60) {
                        ++n8;
                    }
                }
                while (byArray2[n8] == 10 || byArray2[n8] == 13 || byArray2[n8] == 32 || byArray2[n8] == 9) {
                    ++n8;
                }
                if (byArray2[0] != 60) {
                    while (byArray2[n8] != 60 && byArray2[n8 + 1] != 60) {
                        if (byArray2[n8] == 110 && byArray2[n8 + 1] == 117 && byArray2[n8 + 2] == 108 && byArray2[n8 + 3] == 108) {
                            return n2;
                        }
                        if (byArray2[n8] == 47) break;
                        if (byArray2[n8] == 40) {
                            n8 = this.readTextStream(pdfObject, n8, byArray2, n3, true);
                            break;
                        }
                        ++n8;
                    }
                }
                n2 = this.handleValue(pdfObject, n2, n3, n8, n6, n5, byArray2);
            }
        }
        return n2;
    }

    private int processArray(PdfObject pdfObject, byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = n2; byArray[n3] != 93 && n3 <= byArray.length; ++n3) {
        }
        PdfObject pdfObject2 = ObjectFactory.createObject(n, null, pdfObject.getObjectType(), pdfObject.getID());
        pdfObject2.setID(n);
        pdfObject.setDictionary(n, pdfObject2);
        pdfObject2.ignoreRecursion(pdfObject.ignoreRecursion());
        if (pdfObject2.isDataExternal()) {
            pdfObject2.isDataExternal(true);
            if (!this.resolveFully(pdfObject2)) {
                pdfObject.setFullyResolved(false);
            }
        }
        int n4 = 9;
        if (n == 9250) {
            n4 = 14;
        }
        ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n2, n3, n4);
        int n5 = arrayDecoder.readArray(pdfObject.ignoreRecursion(), byArray, pdfObject2, n);
        return n5;
    }

    private int handleValue(PdfObject pdfObject, int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        int n6 = byArray.length;
        if (byArray[n3] == 47) {
            int n7 = ++n3;
            int n8 = 0;
            while (n3 < n6 && byArray[n3] != 10 && byArray[n3] != 13 && byArray[n3] != 32 && byArray[n3] != 47 && byArray[n3] != 60 && byArray[n3] != 62) {
                ++n3;
                ++n8;
            }
            --n;
            if (n2 == -1) {
                pdfObject.setConstant(n2, n7, n8, byArray);
            } else {
                PdfObject pdfObject2 = ObjectFactory.createObject(n2, null, pdfObject.getObjectType(), pdfObject.getID());
                pdfObject2.setID(n2);
                pdfObject2.setConstant(n2, n7, n8, byArray);
                pdfObject.setDictionary(n2, pdfObject2);
                if (pdfObject.isDataExternal()) {
                    pdfObject2.isDataExternal(true);
                    if (!this.resolveFully(pdfObject2)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
            }
        } else {
            PdfObject pdfObject3;
            if (n2 == -1) {
                pdfObject3 = pdfObject;
            } else {
                pdfObject3 = ObjectFactory.createObject(n2, n4, n5, pdfObject.getObjectType());
                pdfObject3.setID(n2);
                pdfObject3.setInCompressedStream(pdfObject.isInCompressedStream());
                if (pdfObject.isDataExternal()) {
                    pdfObject3.isDataExternal(true);
                    if (!this.resolveFully(pdfObject3)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
                if (n2 != 2004251818) {
                    pdfObject3.ignoreRecursion(pdfObject.ignoreRecursion());
                }
            }
            ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
            objectDecoder.readDictionaryAsObject(pdfObject3, n3, byArray);
            if (n2 != -1) {
                pdfObject.setDictionary(n2, pdfObject3);
            }
        }
        return n;
    }

    int convertDirectDictionaryToObject(PdfObject pdfObject, String string, int n, byte[] byArray, int n2) {
        int n3;
        PdfObject pdfObject2;
        if (n2 == -1) {
            pdfObject2 = pdfObject;
            int n4 = 0;
            n3 = -1;
            int n5 = -1;
            if (byArray[0] == 60) {
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == 47) {
                        ++n4;
                    }
                    if (n4 != 1) continue;
                    if (n3 == -1) {
                        if (byArray[i] <= 48 || byArray[i] >= 57) continue;
                        n3 = i;
                        continue;
                    }
                    if (byArray[i] != 82) continue;
                    n5 = i + 1;
                }
                if (n4 == 1 && n3 != -1 && n5 != -1) {
                    string = new String(byArray, n3, n5 - n3);
                    pdfObject2.setRef(string);
                }
            }
        } else {
            pdfObject2 = ObjectFactory.createObject(n2, string, pdfObject.getObjectType(), pdfObject.getID());
            pdfObject2.setInCompressedStream(pdfObject.isInCompressedStream());
            pdfObject2.setID(n2);
            if (pdfObject.isCached()) {
                pdfObject2.moveCacheValues(pdfObject);
            }
        }
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        n = objectDecoder.readDictionaryAsObject(pdfObject2, n, byArray);
        if (n < byArray.length && byArray[n] == 62) {
            --n;
        }
        if (n2 != -1) {
            pdfObject.setDictionary(n2, pdfObject2);
        }
        n3 = byArray.length;
        while (n < n3 - 1 && byArray[n] == 62 && byArray[n + 1] == 62 && (++n + 1 >= byArray.length || byArray[n + 1] != 62)) {
        }
        return n;
    }

    private int readKeyPairs(int n, byte[] byArray, int n2, int n3, PdfObject pdfObject) {
        int n4 = n2;
        int n5 = n3;
        boolean bl = false;
        boolean bl2 = false;
        Object object = null;
        Object object2 = null;
        PdfObject[] pdfObjectArray = null;
        if (n3 == -1) {
            bl = true;
        } else if (n3 == -2) {
            bl = true;
            bl2 = true;
        } else {
            object = new byte[n5][];
            object2 = new byte[n5][];
            pdfObjectArray = new PdfObject[n5];
        }
        n3 = 0;
        while (true) {
            PdfObject pdfObject2;
            Object object3;
            byte[] byArray2;
            int n6;
            int n7;
            int n8;
            boolean bl3;
            if (byArray[n4] == 9 || byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32 || byArray[n4] == 60) {
                ++n4;
                continue;
            }
            if (byArray[n4] == 37) {
                while (byArray[n4] != 10 && byArray[n4] != 13) {
                    ++n4;
                }
                while (byArray[n4] == 9 || byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32 || byArray[n4] == 60) {
                    ++n4;
                }
            }
            if (byArray[n4] == 62) break;
            if (byArray[n4] == 47) {
                ++n3;
            } else {
                throw new RuntimeException("Unexpected value " + byArray[n4] + " - not key pair");
            }
            int n9 = ++n4;
            while (byArray[n4] != 32 && byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 91 && byArray[n4] != 60 && byArray[n4] != 47) {
                ++n4;
            }
            int n10 = n4 - n9;
            byte[] byArray3 = new byte[n10];
            System.arraycopy(byArray, n9, byArray3, 0, n10);
            if (!bl) {
                object[n3 - 1] = byArray3;
            }
            while (byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32) {
                ++n4;
            }
            boolean bl4 = bl3 = byArray[n4] == 60 || byArray[n4] == 91 || byArray[n4] == 47;
            if (bl3) {
                int n11;
                while (byArray[n4 - 1] != 60 && byArray[n4] != 60 && byArray[n4] != 91 && byArray[n4] != 47) {
                    ++n4;
                }
                n8 = n4;
                n7 = 1;
                if (byArray[n4] == 60) {
                    n4 += 2;
                    n11 = 1;
                    while (n11 > 0) {
                        if (byArray[n4] == 60 && byArray[n4 + 1] == 60) {
                            n4 += 2;
                            ++n11;
                            continue;
                        }
                        if (byArray[n4] == 62 && byArray[n4 + 1] == 62) {
                            n4 += 2;
                            --n11;
                            continue;
                        }
                        ++n4;
                    }
                } else if (byArray[n4] == 91) {
                    n11 = 1;
                    ++n4;
                    n6 = 0;
                    while (n11 > 0) {
                        if (n6 == 0 && byArray[n4] == 40) {
                            n6 = 1;
                        } else if (n6 != 0 && byArray[n4] == 41 && (byArray[n4 - 1] != 92 || byArray[n4 - 2] == 92)) {
                            n6 = 0;
                        }
                        if (n6 == 0) {
                            if (byArray[n4] == 91) {
                                ++n11;
                            } else if (byArray[n4] == 93) {
                                --n11;
                            }
                        }
                        ++n4;
                    }
                    n7 = 0;
                } else if (byArray[n4] == 47) {
                    ++n4;
                    while (byArray[n4] != 47 && byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 32 && (++n4 >= byArray.length - 1 || byArray[n4] != 62 || byArray[n4 + 1] != 62)) {
                    }
                }
                if (bl) continue;
                n6 = n4 - n8;
                byArray2 = new byte[n6];
                System.arraycopy(byArray, n8, byArray2, 0, n6);
                object2[n3 - 1] = byArray2;
                String string = pdfObject.getObjectRefAsString();
                if (pdfObject.getObjectType() == 2087749783) {
                    ColorObjectDecoder colorObjectDecoder = new ColorObjectDecoder(this.objectReader);
                    if (n7 != 0 && !bl3) {
                        colorObjectDecoder.handleColorSpaces(pdfObject, 0, byArray2);
                        pdfObjectArray[n3 - 1] = pdfObject;
                        continue;
                    }
                    object3 = new ColorSpaceObject(string);
                    if (bl3) {
                        ((PdfObject)object3).setRef(-1, 0);
                    }
                    colorObjectDecoder.handleColorSpaces((PdfObject)object3, 0, byArray2);
                    pdfObjectArray[n3 - 1] = object3;
                    continue;
                }
                if (n7 == 0) continue;
                PdfObject pdfObject3 = ObjectFactory.createObject(n, string, pdfObject.getObjectType(), pdfObject.getID());
                pdfObject3.setID(n);
                this.readDictionaryFromRefOrDirect(n, pdfObject3, string, 0, byArray2, -1);
                pdfObjectArray[n3 - 1] = pdfObject3;
                continue;
            }
            n8 = 0;
            n7 = 0;
            n6 = n4;
            int n12 = n4;
            boolean bl5 = false;
            if (byArray[n4] == 110 && byArray[n4 + 1] == 117 && byArray[n4 + 2] == 108 && byArray[n4 + 3] == 108) {
                n4 += 4;
                bl5 = true;
            } else {
                while (byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 32 && byArray[n4] != 47 && byArray[n4] != 60 && byArray[n4] != 62) {
                    ++n4;
                }
                n8 = NumberUtils.parseInt(n12, n4, byArray);
                while (byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32 || byArray[n4] == 47 || byArray[n4] == 60) {
                    ++n4;
                }
                n12 = n4;
                while (byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 32 && byArray[n4] != 47 && byArray[n4] != 60 && byArray[n4] != 62) {
                    ++n4;
                }
                n7 = NumberUtils.parseInt(n12, n4, byArray);
                while (byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32 || byArray[n4] == 47 || byArray[n4] == 60) {
                    ++n4;
                }
            }
            if (!bl5 && byArray[n4] != 82) {
                throw new RuntimeException((char)byArray[n4 - 1] + " " + (char)byArray[n4] + " " + (char)byArray[n4 + 1] + " 3. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            ++n4;
            if (bl) continue;
            if (bl5) {
                pdfObjectArray[n3 - 1] = null;
                continue;
            }
            if (PdfDictionary.getKeyType(n, pdfObject.getObjectType()) == 5) {
                object3 = new String(byArray, n6, n4 - n6);
                PdfObject pdfObject4 = ObjectFactory.createObject(n, (String)object3, pdfObject.getObjectType(), pdfObject.getID());
                pdfObject4.setStatus(1);
                pdfObject4.setUnresolvedData(StringUtils.toBytes((String)object3), n);
                pdfObjectArray[n3 - 1] = pdfObject4;
                continue;
            }
            object3 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(n8, n7), n8, n7);
            if (object3 == null) {
                pdfObject.setFullyResolved(false);
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (12)");
                }
                return byArray.length;
            }
            int n13 = 0;
            while ((n13 < 3 || object3[n13 - 1] != 106 && object3[n13 - 2] != 98 && object3[n13 - 3] != 111) && object3[n13] != 47 && object3[n13] != 91 && object3[n13] != 60) {
                if (++n13 != ((Object)object3).length) continue;
                n13 = 0;
                break;
            }
            while (object3[n13] == 10 || object3[n13] == 13 || object3[n13] == 32) {
                ++n13;
            }
            int n14 = ((Object)object3).length - n13;
            byArray2 = new byte[n14];
            System.arraycopy(object3, n13, byArray2, 0, n14);
            object2[n3 - 1] = byArray2;
            String string = n8 + " " + n7 + " R";
            if (pdfObject.getObjectType() == 373243460 && n == 373243460) {
                pdfObjectArray[n3 - 1] = null;
                object2[n3 - 1] = StringUtils.toBytes(string);
                continue;
            }
            if (pdfObject.getObjectType() == 979194486) {
                pdfObject2 = ObjectFactory.createObject(n, string, 979194486, 979194486);
                pdfObject2.setStatus(1);
                pdfObject2.setUnresolvedData(StringUtils.toBytes(string), n);
                pdfObjectArray[n3 - 1] = pdfObject2;
                continue;
            }
            pdfObject2 = ObjectFactory.createObject(n, string, pdfObject.getObjectType(), pdfObject.getID());
            pdfObject2.setID(n);
            if (pdfObject2.getObjectType() == 2087749783) {
                ColorObjectDecoder colorObjectDecoder = new ColorObjectDecoder(this.objectReader);
                colorObjectDecoder.handleColorSpaces(pdfObject2, 0, byArray2);
            } else {
                this.readDictionaryFromRefOrDirect(n, pdfObject2, string, 0, byArray2, -1);
            }
            pdfObjectArray[n3 - 1] = pdfObject2;
        }
        if (!bl) {
            pdfObject.setDictionaryPairs((byte[][])object, (byte[][])object2, pdfObjectArray);
        }
        if (bl2 || !bl) {
            return n4;
        }
        return n3;
    }

    void readStreamIntoObject(PdfObject pdfObject, int n, byte[] byArray) {
        int n2 = byArray.length;
        byte[] byArray2 = null;
        PdfArrayIterator pdfArrayIterator = pdfObject.getMixedArray(1011108731);
        boolean bl = false;
        int n3 = -1;
        if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
            n3 = pdfArrayIterator.getNextValueAsConstant(true);
            if (n3 == 1247500931) {
                bl = true;
            }
            while (pdfArrayIterator.hasMoreTokens() && !bl) {
                n3 = pdfArrayIterator.getNextValueAsConstant(true);
                if (n3 != 1247500931) continue;
                bl = true;
            }
        }
        for (int i = n; i < n2; ++i) {
            int n4;
            if (byArray[i] != 115 || byArray[i + 1] != 116 || byArray[i + 2] != 114 || byArray[i + 3] != 101 || byArray[i + 4] != 97 || byArray[i + 5] != 109) continue;
            i += 6;
            while (byArray[i] == 32) {
                ++i;
            }
            if (byArray[i] == 13 && byArray[i + 1] == 10) {
                i += 2;
            } else if (byArray[i] == 10 && byArray[i + 1] == 10 && byArray[i + 2] == 10 && byArray[i + 3] == -1 && n3 == 1180911742) {
                i += 3;
            } else if (byArray[i] == 10 && byArray[i + 1] == 10 && byArray[i + 2] == -1 && n3 == 1180911742) {
                i += 2;
            } else if (byArray[i] == 10 || byArray[i] == 13) {
                // empty if block
            }
            int n5 = ++i;
            --i;
            int n6 = 0;
            int n7 = pdfObject.getInt(1043816557);
            boolean bl2 = false;
            if (n7 != -1) {
                n6 = n7;
                i = n5 + n6;
                if (i < n2 && byArray[i] == 13 && i + 1 < n2 && byArray[i + 1] == 10) {
                    i += 2;
                }
                if (n2 <= i + 9 || byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109) {
                    n4 = i;
                    if (i < n2) {
                        while (!bl2 && ++i != n2) {
                            if (byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109) continue;
                            n6 = i - n5;
                            bl2 = true;
                        }
                    }
                    if (!bl2) {
                        i = n4;
                        if (i > n2) {
                            i = n2;
                        }
                        while (!bl2 && --i >= 0) {
                            if (byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109) continue;
                            n6 = i - n5;
                            bl2 = true;
                        }
                    }
                    if (!bl2) {
                        i = n4;
                    }
                }
                if (this.decryption != null && this.decryption.getBooleanValue(101)) {
                    n6 = n7;
                }
            } else {
                while (++i != n2 && (byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109)) {
                }
                n4 = i - 1;
                if (n4 > n5) {
                    n6 = n4 - n5 + 1;
                }
            }
            if (n6 > 1 && (this.decryption == null || !this.decryption.getBooleanValue(101)) && (n4 = n5 + n6 - 1) < byArray.length && n4 > 0 && (byArray[n4] == 10 || byArray[n4] == 13 && (pdfObject != null && bl || n4 > 0 && byArray[n4 - 1] == 10))) {
                --n6;
                --n4;
            }
            if (n5 + n6 > n2) {
                n6 = n2 - n5;
            }
            if (n6 < 0) {
                return;
            }
            if (n6 < 0) {
                throw new RuntimeException("Negative stream length " + n6 + " start=" + n5 + " count=" + n2);
            }
            byArray2 = new byte[n6];
            System.arraycopy(byArray, n5, byArray2, 0, n6);
            i = n2;
        }
        if (pdfObject != null) {
            pdfObject.setStream(byArray2);
            if (pdfObject.decompressStreamWhenRead()) {
                this.objectReader.readStream(pdfObject, true, true, false, pdfObject.getObjectType() == 1365674082, pdfObject.isCompressedStream(), null);
            }
        }
    }

    private int setNameStringValue(PdfObject pdfObject, int n, byte[] byArray, boolean bl) {
        byte[] byArray2;
        int n2;
        int n3;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 40) {
            ++n;
        }
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
            ++n;
        }
        int n4 = n;
        byte[] byArray3 = byArray;
        boolean bl2 = byArray[n] != 47 && byArray[n] != 40 && byArray[n] != 60;
        boolean bl3 = byArray[n] == 40;
        boolean bl4 = false;
        if (bl2) {
            for (n3 = n + 1; n3 < byArray.length && (byArray[n3] == 10 || byArray[n3] == 13 || byArray[n3] == 32); ++n3) {
            }
            if (byArray[n3] == 47 || byArray[n3] == 93) {
                bl2 = false;
                n = n3 + 1;
                bl4 = true;
            }
        }
        if (bl2) {
            int n5 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            n3 = NumberUtils.parseInt(n5, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            n5 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            n2 = NumberUtils.parseInt(n5, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            if (byArray[n] != 82) {
                throw new RuntimeException(padding + "2. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            byArray3 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(n3, n2), n3, n2);
            if (byArray3 == null) {
                pdfObject.setFullyResolved(false);
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (13)");
                }
                return byArray.length;
            }
            if (byArray3[0] == 47) {
                n4 = 0;
            } else {
                n4 = 3;
                while (byArray3[n4] != 47) {
                    ++n4;
                }
            }
        }
        if (byArray3[++n4] == 47) {
            return n4 - 1;
        }
        n3 = n4 + 1;
        if (bl4) {
            while (byArray3[n4] == 10 || byArray3[n4] == 13 || byArray3[n4] == 32 || byArray3[n4] == 47) {
                ++n4;
            }
            n2 = 0;
            int n6 = 0;
            while (byArray3[n3] != 93) {
                if (byArray3[n3] == 47 && (n6 == 32 || n6 == 10 || n6 == 13)) {
                    ++n2;
                }
                n6 = byArray3[n3];
                if (++n3 != byArray3.length) continue;
            }
            int n7 = n3 - n2;
            int n8 = 0;
            byArray2 = new byte[n7 - n4];
            int n9 = 0;
            for (int i = n4; i < n7; ++i) {
                int n10 = byArray3[i];
                if (n10 == 47) {
                    if (n9 != 32 && n9 != 10 && n9 != 13) {
                        byArray2[n8] = 32;
                        ++n8;
                    }
                } else {
                    byArray2[n8] = n10;
                    ++n8;
                }
                n9 = n10;
            }
        } else {
            while (!(!bl3 ? byArray3[n3] == 32 || byArray3[n3] == 10 || byArray3[n3] == 13 || byArray3[n3] == 47 || byArray3[n3] == 62 : byArray3[n3] == 41)) {
                if (++n3 != byArray3.length) continue;
            }
            n2 = n3 - n4;
            byArray2 = new byte[n2];
            System.arraycopy(byArray3, n4, byArray2, 0, n2);
        }
        if (bl) {
            pdfObject.setName(this.PDFkey, StringUtils.getTextString(byArray2, false));
        } else {
            pdfObject.setName(this.PDFkeyInt, byArray2);
        }
        if (!bl2) {
            n = n3 - 1;
        }
        return n;
    }

    public synchronized boolean resolveFully(PdfObject pdfObject) {
        boolean bl;
        boolean bl2 = bl = pdfObject != null;
        if (bl) {
            byte[] byArray = pdfObject.getStatus() == 0 ? StringUtils.toBytes(pdfObject.getObjectRefAsString()) : pdfObject.getUnresolvedData();
            pdfObject.setStatus(0);
            if (byArray[0] != 101 && byArray[1] != 110 && byArray[2] != 100 && byArray[3] != 111 && byArray[4] != 98) {
                int n = 0;
                while (byArray[n] == 91 || byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10) {
                    ++n;
                }
                int n2 = n;
                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                    ++n;
                }
                int n3 = NumberUtils.parseInt(n2, n, byArray);
                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
                    ++n;
                }
                n2 = n;
                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                    ++n;
                }
                int n4 = NumberUtils.parseInt(n2, n, byArray);
                if (byArray[byArray.length - 1] == 82) {
                    bl = this.resolveFullyChildren(pdfObject, bl, byArray, n3, n4);
                }
                if (bl) {
                    pdfObject.ignoreRecursion(false);
                    ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
                    objectDecoder.readDictionaryAsObject(pdfObject, n, byArray);
                }
            }
        }
        return bl;
    }

    private boolean resolveFullyChildren(PdfObject pdfObject, boolean bl, byte[] byArray, int n, int n2) {
        pdfObject.setRef(new String(byArray));
        pdfObject.isDataExternal(true);
        byte[] byArray2 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(n, n2), n, n2);
        if (byArray2 == null) {
            pdfObject.setFullyResolved(false);
            bl = false;
        } else {
            pdfObject.setStatus(2);
            pdfObject.setUnresolvedData(byArray2, 2004845231);
            pdfObject.isDataExternal(true);
            if (!this.resolveFully(pdfObject)) {
                pdfObject.setFullyResolved(false);
            }
        }
        return bl;
    }

    public void checkResolved(PdfObject pdfObject) {
        if (pdfObject != null && pdfObject.getStatus() != 0) {
            byte[] byArray = pdfObject.getUnresolvedData();
            pdfObject.setStatus(0);
            if (!(byArray[0] == 101 && byArray[1] == 110 && byArray[2] == 100 && byArray[3] == 111 && byArray[4] == 98 || byArray[0] == 110 && byArray[1] == 117 && byArray[2] == 108 && byArray[3] == 108)) {
                String string = pdfObject.getObjectRefAsString();
                if (byArray[0] == 91) {
                    int n;
                    int n2 = 0;
                    int n3 = byArray.length;
                    for (n = 0; n < n3; ++n) {
                        if (byArray[n] < 48 || byArray[n] > 57) continue;
                        n2 = n;
                        n = n3;
                    }
                    n = n2;
                    while (byArray[n] >= 48 && byArray[n] <= 57 || byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 9) {
                        ++n;
                    }
                    if (byArray[n] == 82) {
                        pdfObject.setRef(new String(byArray, n2, n3 - n2));
                    }
                } else if (byArray[byArray.length - 1] == 82) {
                    pdfObject.setRef(new String(byArray));
                }
                ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
                objectDecoder.readDictionaryFromRefOrDirect(-1, pdfObject, string, 0, byArray, -1);
            }
        }
    }

    public void setEndPt(int n) {
        this.endPt = n;
    }
}

