/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JViewport;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.gui.CheckNode;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;
import org.w3c.dom.NodeList;

public class SwingProperties
extends JPanel {
    Map reverseMessage = new HashMap();
    String[] menuTabs = new String[]{"ShowMenubar", "ShowButtons", "ShowDisplayoptions", "ShowNavigationbar", "ShowSidetabbar"};
    String propertiesLocation = "";
    PropertiesFile properties = null;
    JDialog propertiesDialog;
    JButton confirm = new JButton("OK");
    JButton cancel = new JButton("Cancel");
    JTabbedPane tabs = new JTabbedPane();
    JTextField resolution;
    JComboBox searchStyle;
    JCheckBox border;
    JCheckBox downloadWindow;
    JCheckBox HiResPrint;
    JCheckBox constantTabs;
    JCheckBox enhancedViewer;
    JCheckBox enhancedFacing;
    JCheckBox thumbnailScroll;
    JCheckBox enhancedGUI;
    JCheckBox rightClick;
    JCheckBox scrollwheelZoom;
    JCheckBox update = new JCheckBox(Messages.getMessage("PdfPreferences.CheckForUpdate"));
    JTextField maxMultiViewers;
    JTextField pageInsets;
    JLabel pageInsetsText;
    JTextField windowTitle;
    JLabel windowTitleText;
    JTextField iconLocation;
    JLabel iconLocationText;
    JTextField printerBlacklist;
    JLabel printerBlacklistText;
    JComboBox defaultPrinter;
    JLabel defaultPrinterText;
    JComboBox defaultPagesize;
    JLabel defaultPagesizeText;
    JTextField defaultDPI;
    JLabel defaultDPIText;
    JTextField sideTabLength;
    JLabel sideTabLengthText;
    JCheckBox useHinting;
    JCheckBox autoScroll;
    JCheckBox confirmClose;
    JCheckBox openLastDoc;
    JComboBox pageLayout = new JComboBox<String>(new String[]{"Single Page", "Continuous", "Continuous Facing", "Facing", "PageFlow"});
    JComboBox voiceSelect;
    JPanel highlightBoxColor = new JPanel();
    JPanel highlightTextColor = new JPanel();
    JPanel viewBGColor = new JPanel();
    JPanel pdfDecoderBackground = new JPanel();
    JPanel foreGroundColor = new JPanel();
    JCheckBox invertHighlight = new JCheckBox("Highlight Inverts Page");
    JCheckBox replaceDocTextCol = new JCheckBox("Replace Document Text Colors");
    JCheckBox replaceDisplayBGCol = new JCheckBox("Replace Display Background Color");
    JCheckBox changeTextAndLineArt = new JCheckBox("Change Color of Text and Line art");
    JCheckBox showMouseSelectionBox = new JCheckBox("Show Mouse Selection Box");
    JTextField highlightComposite = new JTextField(String.valueOf(PdfDecoder.highlightComposite));
    private Container parent;
    private boolean preferencesSetup = false;
    private JButton clearHistory;
    private JLabel historyClearedLabel;
    KeyListener numericalKeyListener = new KeyListener(){
        boolean consume = false;

        public void keyPressed(KeyEvent keyEvent) {
            this.consume = false;
            if (!(keyEvent.getKeyChar() >= '0' && keyEvent.getKeyChar() <= '9' || keyEvent.getKeyCode() == 8 && keyEvent.getKeyCode() == 127)) {
                this.consume = true;
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (this.consume) {
                keyEvent.consume();
            }
        }
    };

    public void showPreferenceWindow(SwingGUI swingGUI) {
        this.propertiesDialog = this.parent instanceof JFrame ? new JDialog((JFrame)this.parent) : new JDialog();
        this.propertiesDialog.setModal(true);
        if (!this.preferencesSetup) {
            this.preferencesSetup = true;
            this.createPreferenceWindow(swingGUI);
        }
        if (this.properties.getValue("readOnly").toLowerCase().equals("true")) {
            JOptionPane.showMessageDialog(this, "You do not have permission alter jPedal properties.\nAccess to the properties window has therefore been disabled.", "Can not write to properties file", 1);
        }
        if (this.properties.isReadOnly()) {
            JOptionPane.showMessageDialog(this, "Current properties file is read only.\nAny alteration can only be saved as another properties file.", "Properties file is read only", 1);
            this.confirm.setEnabled(false);
        } else {
            this.confirm.setEnabled(true);
        }
        this.propertiesDialog.setLocationRelativeTo(this.parent);
        this.propertiesDialog.setVisible(true);
    }

    private void saveGUIPreferences(SwingGUI swingGUI) {
        Component[] componentArray = this.tabs.getComponents();
        for (int i = 0; i != componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JPanel)) continue;
            Component[] componentArray2 = ((JPanel)componentArray[i]).getComponents();
            for (int j = 0; j != componentArray2.length; ++j) {
                Object object;
                if (componentArray2[j] instanceof JScrollPane) {
                    object = ((JScrollPane)componentArray2[j]).getComponents();
                    for (int k = 0; k != ((Component[])object).length; ++k) {
                        if (!(object[k] instanceof JViewport)) continue;
                        Component[] componentArray3 = ((JViewport)object[k]).getComponents();
                        for (int i2 = 0; i2 != componentArray3.length; ++i2) {
                            JTree jTree;
                            CheckNode checkNode;
                            if (!(componentArray3[i2] instanceof JTree) || (checkNode = (CheckNode)(jTree = (JTree)componentArray3[i2]).getModel().getRoot()).getChildCount() <= 0) continue;
                            this.saveMenuPreferencesChildren(checkNode, swingGUI);
                        }
                    }
                }
                if (!(componentArray2[j] instanceof JButton)) continue;
                object = (JButton)componentArray2[j];
                String string = (String)this.reverseMessage.get(((AbstractButton)object).getText().substring((Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ').length()));
                if (((AbstractButton)object).getText().startsWith(Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ')) {
                    this.properties.setValue(string, "true");
                    swingGUI.alterProperty(string, true);
                    continue;
                }
                this.properties.setValue(string, "false");
                swingGUI.alterProperty(string, false);
            }
        }
    }

    private void saveMenuPreferencesChildren(CheckNode checkNode, SwingGUI swingGUI) {
        for (int i = 0; i != checkNode.getChildCount(); ++i) {
            CheckNode checkNode2 = (CheckNode)checkNode.getChildAt(i);
            String string = (String)this.reverseMessage.get(checkNode2.getText());
            if (checkNode2.isSelected()) {
                this.properties.setValue(string, "true");
                swingGUI.alterProperty(string, true);
            } else {
                this.properties.setValue(string, "false");
                swingGUI.alterProperty(string, false);
            }
            if (checkNode2.getChildCount() <= 0) continue;
            this.saveMenuPreferencesChildren(checkNode2, swingGUI);
        }
    }

    private void createPreferenceWindow(final SwingGUI swingGUI) {
        this.properties = swingGUI.getProperties();
        this.propertiesLocation = swingGUI.getPropertiesFileLocation();
        this.propertiesDialog.setTitle(Messages.getMessage("PdfPreferences.windowTitle"));
        this.update.setToolTipText(Messages.getMessage("PdfPreferences.update.toolTip"));
        this.invertHighlight.setText(Messages.getMessage("PdfPreferences.InvertHighlight"));
        this.showMouseSelectionBox.setText(Messages.getMessage("PdfPreferences.ShowSelectionBow"));
        this.invertHighlight.setToolTipText(Messages.getMessage("PdfPreferences.invertHighlight.toolTip"));
        this.showMouseSelectionBox.setToolTipText(Messages.getMessage("PdfPreferences.showMouseSelection.toolTip"));
        this.highlightBoxColor.setToolTipText(Messages.getMessage("PdfPreferences.highlightBox.toolTip"));
        this.highlightTextColor.setToolTipText(Messages.getMessage("PdfPreferences.highlightText.toolTip"));
        String string = this.properties.getValue("resolution");
        this.resolution = string.length() > 0 ? new JTextField(string) : new JTextField(72);
        this.resolution.setToolTipText(Messages.getMessage("PdfPreferences.resolutionInput.toolTip"));
        string = this.properties.getValue("maxmultiviewers");
        this.maxMultiViewers = string.length() > 0 ? new JTextField(string) : new JTextField(20);
        this.maxMultiViewers.setToolTipText(Messages.getMessage("PdfPreferences.maxMultiViewer.toolTip"));
        this.searchStyle = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch"), Messages.getMessage("PageLayoutViewMenu.MenuSearch")});
        this.searchStyle.setToolTipText(Messages.getMessage("PdfPreferences.searchStyle.toolTip"));
        this.pageLayout = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing"), Messages.getMessage("PageLayoutViewMenu.PageFlow")});
        this.pageLayout.setToolTipText(Messages.getMessage("PdfPreferences.pageLayout.toolTip"));
        this.pageInsetsText = new JLabel(Messages.getMessage("PdfViewerViewMenu.pageInsets"));
        this.pageInsets = new JTextField();
        this.pageInsets.setToolTipText(Messages.getMessage("PdfPreferences.pageInsets.toolTip"));
        this.windowTitleText = new JLabel(Messages.getMessage("PdfCustomGui.windowTitle"));
        this.windowTitle = new JTextField();
        this.windowTitle.setToolTipText(Messages.getMessage("PdfPreferences.windowTitle.toolTip"));
        this.iconLocationText = new JLabel(Messages.getMessage("PdfViewerViewMenu.iconLocation"));
        this.iconLocation = new JTextField();
        this.iconLocation.setToolTipText(Messages.getMessage("PdfPreferences.iconLocation.toolTip"));
        this.defaultDPIText = new JLabel(Messages.getMessage("PdfViewerPrint.defaultDPI"));
        this.defaultDPI = new JTextField();
        this.defaultDPI.setToolTipText(Messages.getMessage("PdfPreferences.defaultDPI.toolTip"));
        this.sideTabLengthText = new JLabel(Messages.getMessage("PdfCustomGui.SideTabLength"));
        this.sideTabLength = new JTextField();
        this.sideTabLength.setToolTipText(Messages.getMessage("PdfPreferences.sideTabLength.toolTip"));
        this.useHinting = new JCheckBox(Messages.getMessage("PdfCustomGui.useHinting"));
        this.useHinting.setToolTipText(Messages.getMessage("PdfPreferences.useHinting.toolTip"));
        this.autoScroll = new JCheckBox(Messages.getMessage("PdfViewerViewMenuAutoscrollSet.text"));
        this.autoScroll.setToolTipText("Set if autoscroll should be enabled / disabled");
        this.confirmClose = new JCheckBox(Messages.getMessage("PfdViewerViewMenuConfirmClose.text"));
        this.confirmClose.setToolTipText("Set if we should confirm closing the viewer");
        this.openLastDoc = new JCheckBox(Messages.getMessage("PdfViewerViewMenuOpenLastDoc.text"));
        this.openLastDoc.setToolTipText("Set if last document should be opened upon start up");
        this.border = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.Borders_Show"));
        this.border.setToolTipText("Set if we should display a border for the page");
        this.downloadWindow = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.DownloadWindow_Show"));
        this.downloadWindow.setToolTipText("Set if the download window should be displayed");
        this.HiResPrint = new JCheckBox(Messages.getMessage("Printing.HiRes"));
        this.HiResPrint.setToolTipText("Set if hi res printing should be enabled / disabled");
        this.constantTabs = new JCheckBox(Messages.getMessage("PdfCustomGui.consistentTabs"));
        this.constantTabs.setToolTipText("Set to keep sidetabs consistant between files");
        this.enhancedViewer = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedViewer"));
        this.enhancedViewer.setToolTipText("Set to use enahnced viewer mode");
        this.enhancedFacing = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedFacing"));
        this.enhancedFacing.setToolTipText("Set to turn facing mode to page turn mode");
        this.thumbnailScroll = new JCheckBox(Messages.getMessage("PdfCustomGui.thumbnailScroll"));
        this.thumbnailScroll.setToolTipText("Set to show thumbnail whilst scrolling");
        this.enhancedGUI = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedGUI"));
        this.enhancedGUI.setToolTipText("Set to enabled the enhanced gui");
        this.rightClick = new JCheckBox(Messages.getMessage("PdfCustomGui.allowRightClick"));
        this.rightClick.setToolTipText("Set to enable / disable the right click functionality");
        this.scrollwheelZoom = new JCheckBox(Messages.getMessage("PdfCustomGui.allowScrollwheelZoom"));
        this.scrollwheelZoom.setToolTipText("Set to enable zooming when scrolling with ctrl pressed");
        this.historyClearedLabel = new JLabel(Messages.getMessage("PageLayoutViewMenu.HistoryCleared"));
        this.historyClearedLabel.setForeground(Color.red);
        this.historyClearedLabel.setVisible(false);
        this.clearHistory = new JButton(Messages.getMessage("PageLayoutViewMenu.ClearHistory"));
        this.clearHistory.setToolTipText("Clears the history of previous files");
        this.clearHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                swingGUI.clearRecentDocuments();
                SwingWorker swingWorker = new SwingWorker(){

                    public Object construct() {
                        for (int i = 0; i < 6; ++i) {
                            SwingProperties.this.historyClearedLabel.setVisible(!SwingProperties.this.historyClearedLabel.isVisible());
                            try {
                                Thread.sleep(300L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                };
                swingWorker.start();
            }
        });
        JButton jButton = new JButton(Messages.getMessage("PdfPreferences.SaveAs"));
        jButton.setToolTipText("Save preferences in a new file");
        JButton jButton2 = new JButton(Messages.getMessage("PdfPreferences.ResetToDefault"));
        jButton2.setToolTipText("Reset  and save preferences to program defaults");
        this.propertiesDialog.getContentPane().setLayout(new BorderLayout());
        this.propertiesDialog.getContentPane().add((Component)this, "Center");
        this.propertiesDialog.pack();
        if (PdfDecoder.isRunningOnMac) {
            this.propertiesDialog.setSize(600, 475);
        } else {
            this.propertiesDialog.setSize(550, 450);
        }
        this.confirm.setText(Messages.getMessage("PdfPreferences.OK"));
        this.cancel.setText(Messages.getMessage("PdfPreferences.Cancel"));
        this.confirm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingProperties.this.setPreferences(swingGUI);
                if (Viewer.showMessages) {
                    JOptionPane.showMessageDialog(null, Messages.getMessage("PdfPreferences.savedTo") + SwingProperties.this.propertiesLocation + '\n' + Messages.getMessage("PdfPreferences.restart"), "Restart Jpedal", 1);
                }
                SwingProperties.this.propertiesDialog.setVisible(false);
            }
        });
        this.confirm.setToolTipText("Save the preferences in the current loaded preferences file");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingProperties.this.propertiesDialog.setVisible(false);
            }
        });
        this.cancel.setToolTipText("Leave preferences window without saving changes");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = swingGUI.getPropertiesFileLocation();
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showSaveDialog(SwingProperties.this.propertiesDialog);
                if (n != 1 && n != -1 && n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (file.exists()) {
                        file.delete();
                    }
                    swingGUI.setPropertiesFileLocation(file.getAbsolutePath());
                    SwingProperties.this.setPreferences(swingGUI);
                }
                swingGUI.setPropertiesFileLocation(string);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(SwingProperties.this.propertiesDialog, Messages.getMessage("PdfPreferences.reset"), "Reset to Default", 0);
                if (n == 0) {
                    String string = swingGUI.getPropertiesFileLocation();
                    File file = new File(string);
                    if (file.exists()) {
                        file.delete();
                    }
                    swingGUI.getProperties().loadProperties(string);
                    if (Viewer.showMessages) {
                        JOptionPane.showMessageDialog(SwingProperties.this.propertiesDialog, Messages.getMessage("PdfPreferences.restart"));
                    }
                    SwingProperties.this.propertiesDialog.setVisible(false);
                }
            }
        });
        this.highlightComposite.addKeyListener(new KeyListener(){
            boolean consume = false;

            public void keyPressed(KeyEvent keyEvent) {
                this.consume = false;
                if (!(!((JTextField)keyEvent.getSource()).getText().contains(".") || keyEvent.getKeyChar() != '.' || keyEvent.getKeyChar() >= '0' && keyEvent.getKeyChar() <= '9' || keyEvent.getKeyCode() == 8 && keyEvent.getKeyCode() == 127)) {
                    this.consume = true;
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (this.consume) {
                    keyEvent.consume();
                }
            }
        });
        this.highlightComposite.setToolTipText("Set the transparency of the highlight");
        this.resolution.addKeyListener(this.numericalKeyListener);
        this.maxMultiViewers.addKeyListener(this.numericalKeyListener);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        this.add((Component)new ButtonBarPanel(jPanel), "Center");
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.gray));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        Dimension dimension = new Dimension(5, 40);
        Box.Filler filler = new Box.Filler(dimension, dimension, dimension);
        this.confirm.setPreferredSize(this.cancel.getPreferredSize());
        if (this.properties.isReadOnly()) {
            this.confirm.setEnabled(false);
        } else {
            this.confirm.setEnabled(true);
        }
        jPanel2.add(jButton2);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.confirm);
        jPanel2.add(jButton);
        this.getRootPane().setDefaultButton(this.confirm);
        jPanel2.add(filler);
        jPanel2.add(this.cancel);
        jPanel2.add(filler);
        jPanel2.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
        this.add((Component)jPanel2, "South");
    }

    public void setPreferences(SwingGUI swingGUI) {
        int n = 0;
        int n2 = this.pageLayout.getSelectedIndex() + 1;
        if (n2 < 1 || n2 > 5) {
            n2 = 1;
        }
        if (this.border.isSelected()) {
            n = 1;
        }
        int n3 = this.highlightBoxColor.getBackground().getRGB();
        int n4 = this.highlightTextColor.getBackground().getRGB();
        int n5 = this.viewBGColor.getBackground().getRGB();
        int n6 = this.pdfDecoderBackground.getBackground().getRGB();
        int n7 = this.foreGroundColor.getBackground().getRGB();
        boolean bl = this.changeTextAndLineArt.isSelected();
        boolean bl2 = this.invertHighlight.isSelected();
        boolean bl3 = this.replaceDocTextCol.isSelected();
        boolean bl4 = this.replaceDisplayBGCol.isSelected();
        boolean bl5 = this.showMouseSelectionBox.isSelected();
        this.properties.setValue("borderType", String.valueOf(n));
        this.properties.setValue("useHinting", String.valueOf(this.useHinting.isSelected()));
        this.properties.setValue("pageMode", String.valueOf(n2));
        this.properties.setValue("pageInsets", String.valueOf(this.pageInsets.getText()));
        this.properties.setValue("windowTitle", String.valueOf(this.windowTitle.getText()));
        String string = this.iconLocation.getText();
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + '/';
        }
        this.properties.setValue("iconLocation", String.valueOf(string));
        this.properties.setValue("sideTabBarCollapseLength", String.valueOf(this.sideTabLength.getText()));
        this.properties.setValue("autoScroll", String.valueOf(this.autoScroll.isSelected()));
        this.properties.setValue("confirmClose", String.valueOf(this.confirmClose.isSelected()));
        this.properties.setValue("openLastDocument", String.valueOf(this.openLastDoc.isSelected()));
        this.properties.setValue("resolution", String.valueOf(this.resolution.getText()));
        this.properties.setValue("searchWindowType", String.valueOf(this.searchStyle.getSelectedIndex()));
        this.properties.setValue("automaticupdate", String.valueOf(this.update.isSelected()));
        this.properties.setValue("maxmultiviewers", String.valueOf(this.maxMultiViewers.getText()));
        this.properties.setValue("showDownloadWindow", String.valueOf(this.downloadWindow.isSelected()));
        this.properties.setValue("useHiResPrinting", String.valueOf(this.HiResPrint.isSelected()));
        this.properties.setValue("consistentTabBar", String.valueOf(this.constantTabs.isSelected()));
        this.properties.setValue("highlightComposite", String.valueOf(this.highlightComposite.getText()));
        this.properties.setValue("highlightBoxColor", String.valueOf(n3));
        this.properties.setValue("highlightTextColor", String.valueOf(n4));
        this.properties.setValue("vbgColor", String.valueOf(n5));
        this.properties.setValue("pdfDisplayBackground", String.valueOf(n6));
        this.properties.setValue("vfgColor", String.valueOf(n7));
        this.properties.setValue("replaceDocumentTextColors", String.valueOf(bl3));
        this.properties.setValue("replacePdfDisplayBackground", String.valueOf(bl4));
        this.properties.setValue("changeTextAndLineart", String.valueOf(bl));
        this.properties.setValue("invertHighlights", String.valueOf(bl2));
        this.properties.setValue("showMouseSelectionBox", String.valueOf(bl5));
        this.properties.setValue("allowRightClick", String.valueOf(this.rightClick.isSelected()));
        this.properties.setValue("allowScrollwheelZoom", String.valueOf(this.scrollwheelZoom.isSelected()));
        this.properties.setValue("enhancedViewerMode", String.valueOf(this.enhancedViewer.isSelected()));
        this.properties.setValue("enhancedFacingMode", String.valueOf(this.enhancedFacing.isSelected()));
        this.properties.setValue("previewOnSingleScroll", String.valueOf(this.thumbnailScroll.isSelected()));
        this.properties.setValue("enhancedGUI", String.valueOf(this.enhancedGUI.isSelected()));
        this.properties.setValue("printerBlacklist", String.valueOf(this.printerBlacklist.getText()));
        if (((String)this.defaultPrinter.getSelectedItem()).startsWith("System Default")) {
            this.properties.setValue("defaultPrinter", "");
        } else {
            this.properties.setValue("defaultPrinter", String.valueOf(this.defaultPrinter.getSelectedItem()));
        }
        this.properties.setValue("defaultDPI", String.valueOf(this.defaultDPI.getText()));
        this.properties.setValue("defaultPagesize", String.valueOf(this.defaultPagesize.getSelectedItem()));
        this.saveGUIPreferences(swingGUI);
    }

    public void setParent(Container container) {
        this.parent = container;
    }

    public void dispose() {
        this.removeAll();
        this.reverseMessage = null;
        this.menuTabs = null;
        this.propertiesLocation = null;
        if (this.propertiesDialog != null) {
            this.propertiesDialog.removeAll();
        }
        this.propertiesDialog = null;
        this.confirm = null;
        this.cancel = null;
        if (this.tabs != null) {
            this.tabs.removeAll();
        }
        this.tabs = null;
        this.resolution = null;
        this.searchStyle = null;
        this.border = null;
        this.downloadWindow = null;
        this.HiResPrint = null;
        this.constantTabs = null;
        this.enhancedViewer = null;
        this.enhancedFacing = null;
        this.thumbnailScroll = null;
        this.enhancedGUI = null;
        this.rightClick = null;
        this.scrollwheelZoom = null;
        this.update = null;
        this.maxMultiViewers = null;
        this.pageInsets = null;
        this.pageInsetsText = null;
        this.windowTitle = null;
        this.windowTitleText = null;
        this.iconLocation = null;
        this.iconLocationText = null;
        this.printerBlacklist = null;
        this.printerBlacklistText = null;
        this.defaultPrinter = null;
        this.defaultPrinterText = null;
        this.defaultPagesize = null;
        this.defaultPagesizeText = null;
        this.defaultDPI = null;
        this.defaultDPIText = null;
        this.sideTabLength = null;
        this.sideTabLengthText = null;
        this.useHinting = null;
        this.autoScroll = null;
        this.confirmClose = null;
        this.openLastDoc = null;
        this.pageLayout = null;
        if (this.highlightBoxColor != null) {
            this.highlightBoxColor.removeAll();
        }
        this.highlightBoxColor = null;
        if (this.highlightTextColor != null) {
            this.highlightTextColor.removeAll();
        }
        this.highlightTextColor = null;
        if (this.viewBGColor != null) {
            this.viewBGColor.removeAll();
        }
        this.viewBGColor = null;
        if (this.pdfDecoderBackground != null) {
            this.pdfDecoderBackground.removeAll();
        }
        this.pdfDecoderBackground = null;
        if (this.foreGroundColor != null) {
            this.foreGroundColor.removeAll();
        }
        this.foreGroundColor = null;
        if (this.invertHighlight != null) {
            this.invertHighlight.removeAll();
        }
        this.invertHighlight = null;
        if (this.replaceDocTextCol != null) {
            this.replaceDocTextCol.removeAll();
        }
        this.replaceDocTextCol = null;
        if (this.replaceDisplayBGCol != null) {
            this.replaceDisplayBGCol.removeAll();
        }
        this.replaceDisplayBGCol = null;
        if (this.changeTextAndLineArt != null) {
            this.changeTextAndLineArt.removeAll();
        }
        this.changeTextAndLineArt = null;
        this.showMouseSelectionBox = null;
        if (this.highlightComposite != null) {
            this.highlightComposite.removeAll();
        }
        this.highlightComposite = null;
        if (this.propertiesDialog != null) {
            this.propertiesDialog.removeAll();
        }
        this.parent = null;
        this.clearHistory = null;
        this.historyClearedLabel = null;
    }

    private static boolean hasFreetts() {
        return false;
    }

    class ButtonBarPanel
    extends JPanel {
        private Component currentComponent;

        public ButtonBarPanel(JPanel jPanel) {
            this.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(jPanel);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setVerticalScrollBarPolicy(22);
            this.add((Component)jScrollPane, "West");
            ButtonGroup buttonGroup = new ButtonGroup();
            this.addButton(Messages.getMessage("PdfPreferences.GeneralTitle"), "/org/jpedal/examples/viewer/res/display.png", this.createGeneralSettings(), jPanel, buttonGroup);
            this.addButton(Messages.getMessage("PdfPreferences.PageDisplayTitle"), "/org/jpedal/examples/viewer/res/pagedisplay.png", this.createPageDisplaySettings(), jPanel, buttonGroup);
            this.addButton(Messages.getMessage("PdfPreferences.InterfaceTitle"), "/org/jpedal/examples/viewer/res/interface.png", this.createInterfaceSettings(), jPanel, buttonGroup);
        }

        private JPanel makePanel(String string) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jLabel.setOpaque(true);
            jLabel.setBackground(jPanel.getBackground().brighter());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel2.setFont(jPanel2.getFont().deriveFont(1));
            jPanel2.setOpaque(true);
            jPanel2.setBackground(jPanel.getBackground().brighter());
            jPanel2.add((Component)jLabel, "West");
            jPanel.add((Component)jPanel2, "North");
            jPanel.setPreferredSize(new Dimension(400, 300));
            jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            return jPanel;
        }

        private JPanel createGeneralSettings() {
            String string = SwingProperties.this.properties.getValue("resolution");
            if (string.length() > 0) {
                SwingProperties.this.resolution.setText(string);
            }
            if ((string = SwingProperties.this.properties.getValue("useHinting")).length() > 0 && string.equals("true")) {
                SwingProperties.this.useHinting.setSelected(true);
            } else {
                SwingProperties.this.useHinting.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("autoScroll");
            if (string.equals("true")) {
                SwingProperties.this.autoScroll.setSelected(true);
            } else {
                SwingProperties.this.autoScroll.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("confirmClose");
            if (string.equals("true")) {
                SwingProperties.this.confirmClose.setSelected(true);
            } else {
                SwingProperties.this.confirmClose.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("automaticupdate");
            if (string.equals("true")) {
                SwingProperties.this.update.setSelected(true);
            } else {
                SwingProperties.this.update.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("openLastDocument");
            if (string.equals("true")) {
                SwingProperties.this.openLastDoc.setSelected(true);
            } else {
                SwingProperties.this.openLastDoc.setSelected(false);
            }
            JPanel jPanel = this.makePanel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            JPanel jPanel2 = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            JLabel jLabel = new JLabel(Messages.getMessage("PdfPreferences.GeneralSection"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(10, 0, 0, 5);
            gridBagConstraints.gridx = 0;
            JLabel jLabel2 = new JLabel(Messages.getMessage("PdfViewerViewMenu.Resolution"));
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.resolution, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.useHinting.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.useHinting.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.useHinting, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.autoScroll.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.autoScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.autoScroll, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.confirmClose.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.confirmClose.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.confirmClose, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(15, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel3 = new JLabel(Messages.getMessage("PdfPreferences.StartUp"));
            jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel3.setFont(jLabel3.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel3, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.update.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.update.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.update, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.openLastDoc.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.openLastDoc.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.openLastDoc, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(SwingProperties.this.clearHistory);
            jPanel3.add(Box.createHorizontalGlue());
            jPanel3.add(SwingProperties.this.historyClearedLabel);
            jPanel3.add(Box.createHorizontalGlue());
            jPanel2.add((Component)jPanel3, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            jPanel.add((Component)jScrollPane, "Center");
            return jPanel;
        }

        private JPanel createPageDisplaySettings() {
            String string = SwingProperties.this.properties.getValue("enhancedViewerMode");
            if (string.length() > 0 && string.equals("true")) {
                SwingProperties.this.enhancedViewer.setSelected(true);
            } else {
                SwingProperties.this.enhancedViewer.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("borderType");
            if (string.length() > 0) {
                if (Integer.parseInt(string) == 1) {
                    SwingProperties.this.border.setSelected(true);
                } else {
                    SwingProperties.this.border.setSelected(false);
                }
            }
            if ((string = SwingProperties.this.properties.getValue("pageInsets")) != null && string.length() != 0) {
                SwingProperties.this.pageInsets.setText(string);
            } else {
                SwingProperties.this.pageInsets.setText("25");
            }
            string = SwingProperties.this.properties.getValue("pageMode");
            if (string.length() > 0) {
                int n = Integer.parseInt(string);
                if (n < 1 || n > 5) {
                    n = 1;
                }
                SwingProperties.this.pageLayout.setSelectedIndex(n - 1);
            }
            if ((string = SwingProperties.this.properties.getValue("enhancedFacingMode")).length() > 0 && string.equals("true")) {
                SwingProperties.this.enhancedFacing.setSelected(true);
            } else {
                SwingProperties.this.enhancedFacing.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("previewOnSingleScroll");
            if (string.length() > 0 && string.equals("true")) {
                SwingProperties.this.thumbnailScroll.setSelected(true);
            } else {
                SwingProperties.this.thumbnailScroll.setSelected(false);
            }
            JPanel jPanel = this.makePanel(Messages.getMessage("PdfPreferences.PageDisplayTitle"));
            JPanel jPanel2 = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            JLabel jLabel = new JLabel(Messages.getMessage("PdfPreferences.GeneralSection"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.enhancedViewer.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.enhancedViewer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.enhancedViewer, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.border.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.border.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.border, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)SwingProperties.this.pageInsetsText, gridBagConstraints);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.pageInsets, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(15, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel2 = new JLabel(Messages.getMessage("PdfPreferences.DisplayModes"));
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel2.setFont(jLabel2.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel3 = new JLabel(Messages.getMessage("PageLayoutViewMenu.PageLayout"));
            jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.pageLayout, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.thumbnailScroll.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.thumbnailScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.thumbnailScroll, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            jPanel.add((Component)jScrollPane, "Center");
            return jPanel;
        }

        private JPanel createInterfaceSettings() {
            String string = SwingProperties.this.properties.getValue("enhancedGUI");
            if (string.length() > 0 && string.equals("true")) {
                SwingProperties.this.enhancedGUI.setSelected(true);
            } else {
                SwingProperties.this.enhancedGUI.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("allowRightClick");
            if (string.length() > 0 && string.equals("true")) {
                SwingProperties.this.rightClick.setSelected(true);
            } else {
                SwingProperties.this.rightClick.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("allowScrollwheelZoom");
            if (string.length() > 0 && string.equals("true")) {
                SwingProperties.this.scrollwheelZoom.setSelected(true);
            } else {
                SwingProperties.this.scrollwheelZoom.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("windowTitle");
            if (string != null && string.length() != 0) {
                SwingProperties.this.windowTitle.setText(string);
            }
            if ((string = SwingProperties.this.properties.getValue("iconLocation")) != null && string.length() != 0) {
                SwingProperties.this.iconLocation.setText(string);
            } else {
                SwingProperties.this.iconLocation.setText("/org/jpedal/examples/viewer/res/");
            }
            string = SwingProperties.this.properties.getValue("searchWindowType");
            if (string.length() > 0) {
                SwingProperties.this.searchStyle.setSelectedIndex(Integer.parseInt(string));
            } else {
                SwingProperties.this.searchStyle.setSelectedIndex(0);
            }
            string = SwingProperties.this.properties.getValue("maxmultiviewers");
            if (string != null && string.length() > 0) {
                SwingProperties.this.maxMultiViewers.setText(string);
            }
            if ((string = SwingProperties.this.properties.getValue("sideTabBarCollapseLength")) != null && string.length() != 0) {
                SwingProperties.this.sideTabLength.setText(string);
            } else {
                SwingProperties.this.sideTabLength.setText("30");
            }
            string = SwingProperties.this.properties.getValue("consistentTabBar");
            if (string.length() > 0 && string.equals("true")) {
                SwingProperties.this.constantTabs.setSelected(true);
            } else {
                SwingProperties.this.constantTabs.setSelected(false);
            }
            String string2 = SwingProperties.this.properties.getValue("showMouseSelectionBox");
            if (string2.length() > 0 && string2.toLowerCase().equals("true")) {
                SwingProperties.this.showMouseSelectionBox.setSelected(true);
            } else {
                SwingProperties.this.showMouseSelectionBox.setSelected(false);
            }
            JPanel jPanel = this.makePanel(Messages.getMessage("PdfPreferences.InterfaceTitle"));
            JTabbedPane jTabbedPane = new JTabbedPane();
            JPanel jPanel2 = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            SwingProperties.this.enhancedGUI.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.enhancedGUI.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.enhancedGUI, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(3, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)SwingProperties.this.windowTitleText, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.windowTitle, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)SwingProperties.this.iconLocationText, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.iconLocation, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridx = 0;
            JLabel jLabel2 = new JLabel(Messages.getMessage("PageLayoutViewMenu.SearchLayout"));
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.searchStyle, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(15, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel3 = new JLabel(Messages.getMessage("PdfPreferences.SideTab"));
            jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel3.setFont(jLabel3.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel3, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.sideTabLengthText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.sideTabLengthText, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.sideTabLength, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.constantTabs.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.constantTabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.constantTabs, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            jTabbedPane.add(Messages.getMessage("PdfPreferences.AppearanceTab"), jScrollPane);
            JPanel jPanel3 = new JPanel();
            JScrollPane jScrollPane2 = new JScrollPane(jPanel3);
            jScrollPane2.setBorder(BorderFactory.createEmptyBorder());
            jPanel3.setLayout(new GridBagLayout());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel4 = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            jLabel4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel4.setFont(jLabel4.getFont().deriveFont(1));
            jPanel3.add((Component)jLabel4, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.rightClick.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.rightClick.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel3.add((Component)SwingProperties.this.rightClick, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.scrollwheelZoom.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.scrollwheelZoom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel3.add((Component)SwingProperties.this.scrollwheelZoom, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel3.add((Component)SwingProperties.this.showMouseSelectionBox, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            jPanel3.add(Box.createVerticalGlue(), gridBagConstraints);
            jTabbedPane.add(Messages.getMessage("PdfPreferences.Mouse"), jScrollPane2);
            JPanel jPanel4 = new JPanel();
            JScrollPane jScrollPane3 = new JScrollPane(jPanel4);
            jScrollPane3.setBorder(BorderFactory.createEmptyBorder());
            jPanel4.setLayout(new GridBagLayout());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel5 = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            jLabel5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel5.setFont(jLabel5.getFont().deriveFont(1));
            jPanel4.add((Component)jLabel5, gridBagConstraints);
            jPanel.add((Component)jTabbedPane, "Center");
            return jPanel;
        }

        private void addMenuToTree(int n, NodeList nodeList, CheckNode checkNode, List list) {
            for (int i = 0; i != nodeList.getLength(); ++i) {
                String string;
                if (i >= nodeList.getLength() || (string = nodeList.item(i).getNodeName()).startsWith("#")) continue;
                CheckNode checkNode2 = new CheckNode(Messages.getMessage("PdfCustomGui." + string));
                checkNode2.setEnabled(true);
                SwingProperties.this.reverseMessage.put(Messages.getMessage("PdfCustomGui." + string), string);
                String string2 = SwingProperties.this.properties.getValue(string);
                if (string2.length() > 0 && string2.equals("true")) {
                    checkNode2.setSelected(true);
                } else {
                    checkNode2.setSelected(false);
                }
                if (nodeList.item(i).hasChildNodes()) {
                    list.add(checkNode);
                    checkNode.add(checkNode2);
                    this.addMenuToTree(n, nodeList.item(i).getChildNodes(), checkNode2, list);
                    continue;
                }
                checkNode.add(checkNode2);
            }
        }

        private void show(Component component) {
            if (this.currentComponent != null) {
                this.remove(this.currentComponent);
            }
            this.currentComponent = component;
            this.add("Center", this.currentComponent);
            this.revalidate();
            this.repaint();
        }

        private void addButton(String string, String string2, final Component component, JPanel jPanel, ButtonGroup buttonGroup) {
            AbstractAction abstractAction = new AbstractAction(string, new ImageIcon(this.getClass().getResource(string2))){

                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonBarPanel.this.show(component);
                }
            };
            JToggleButton jToggleButton = new JToggleButton(abstractAction);
            jToggleButton.setVerticalTextPosition(3);
            jToggleButton.setHorizontalTextPosition(0);
            jToggleButton.setContentAreaFilled(false);
            if (PdfDecoder.isRunningOnMac) {
                jToggleButton.setHorizontalAlignment(2);
            }
            jToggleButton.setAlignmentX(0.5f);
            jPanel.add(jToggleButton);
            buttonGroup.add(jToggleButton);
            if (buttonGroup.getSelection() == null) {
                jToggleButton.setSelected(true);
                this.show(component);
            }
        }
    }
}

