/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.jpedal.color.PdfTexturePaint;
import org.jpedal.fonts.glyph.T1Glyph;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Path;

public class Vector_Object
implements Serializable {
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    private static final Integer GENERIC = 1;
    private static final Integer BASICSTROKE = 2;
    private static final Integer BUFFERED_IMAGE = 3;
    private static final Integer GENERAL_PATH = 4;
    private static final Integer T1GLYPH = 5;
    private static final Integer TTGLYPH = 6;
    private static final Integer AREA = 7;
    private static final Integer RECT = 8;
    private static final Integer T3GLYPH = 9;
    private static final Integer TEXTUREDPAINT = 10;
    private Object[] items = new Object[this.max_size];
    private int checkPoint = -1;

    public Vector_Object() {
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.checkPoint = this.current_item;
        }
    }

    protected static int incrementSize(int n) {
        n = n < 8000 ? (n *= 4) : (n < 16000 ? (n *= 2) : (n += 2000));
        return n;
    }

    public Vector_Object(int n) {
        this.max_size = n;
        this.items = new Object[this.max_size];
    }

    public final Object[] get() {
        return this.items;
    }

    public final Object pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    public final void push(Object object) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = object;
        ++this.current_item;
    }

    public final boolean contains(Object object) {
        boolean bl = false;
        for (int i = 0; i < this.current_item; ++i) {
            if (!this.items[i].equals(object)) continue;
            i = this.current_item + 1;
            bl = true;
        }
        return bl;
    }

    public final void addElement(Object object) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = object;
        ++this.current_item;
    }

    public final void setElementAt(Object object, int n) {
        if (n >= this.max_size) {
            this.checkSize(n);
        }
        this.items[n] = object;
    }

    public final Object elementAt(int n) {
        if (n >= this.max_size) {
            return null;
        }
        return this.items[n];
    }

    public final void set(Object[] objectArray) {
        this.items = objectArray;
    }

    public final void clear() {
        this.checkPoint = -1;
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = null;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = null;
            }
        }
        this.current_item = 0;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void removeElementAt(int n) {
        if (n >= 0) {
            System.arraycopy(this.items, n + 1, this.items, n, this.current_item - 1 - n);
            this.items[this.current_item - 1] = null;
        } else {
            this.items[0] = null;
        }
        --this.current_item;
    }

    private void checkSize(int n) {
        if (n >= this.max_size) {
            int n2 = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= n) {
                this.max_size = n + this.increment_size + 2;
            }
            Object[] objectArray = this.items;
            this.items = new Object[this.max_size];
            System.arraycopy(objectArray, 0, this.items, 0, n2);
            this.increment_size = Vector_Object.incrementSize(this.increment_size);
        }
    }

    public void writeToStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.max_size);
        for (int i = 0; i < this.max_size; ++i) {
            Object object;
            Object object2;
            Object object3 = this.items[i];
            if (object3 instanceof BasicStroke) {
                objectOutputStream.writeObject(BASICSTROKE);
                object2 = (BasicStroke)this.items[i];
                objectOutputStream.writeFloat(((BasicStroke)object2).getLineWidth());
                objectOutputStream.writeInt(((BasicStroke)object2).getEndCap());
                objectOutputStream.writeInt(((BasicStroke)object2).getLineJoin());
                objectOutputStream.writeFloat(((BasicStroke)object2).getMiterLimit());
                objectOutputStream.writeObject(((BasicStroke)object2).getDashArray());
                objectOutputStream.writeFloat(((BasicStroke)object2).getDashPhase());
                continue;
            }
            if (object3 instanceof Rectangle2D) {
                objectOutputStream.writeObject(RECT);
                object2 = (Rectangle2D)this.items[i];
                objectOutputStream.writeDouble(((Rectangle2D)object2).getBounds2D().getX());
                objectOutputStream.writeDouble(((Rectangle2D)object2).getBounds2D().getY());
                objectOutputStream.writeDouble(((Rectangle2D)object2).getBounds2D().getWidth());
                objectOutputStream.writeDouble(((Rectangle2D)object2).getBounds2D().getHeight());
                continue;
            }
            if (object3 instanceof BufferedImage) {
                objectOutputStream.writeObject(BUFFERED_IMAGE);
                object2 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((BufferedImage)object3), "png", (OutputStream)object2);
                objectOutputStream.writeObject(((ByteArrayOutputStream)object2).toByteArray());
                continue;
            }
            if (object3 instanceof GeneralPath) {
                objectOutputStream.writeObject(GENERAL_PATH);
                PathSerializer.serializePath(objectOutputStream, ((GeneralPath)this.items[i]).getPathIterator(new AffineTransform()));
                continue;
            }
            if (object3 instanceof T1Glyph) {
                objectOutputStream.writeObject(T1GLYPH);
                ((T1Glyph)object3).flushArea();
                objectOutputStream.writeObject(object3);
                ((T1Glyph)object3).writePathsToStream(objectOutputStream);
                continue;
            }
            if (object3 instanceof TTGlyph) {
                objectOutputStream.writeObject(TTGLYPH);
                ((TTGlyph)object3).flushArea();
                objectOutputStream.writeObject(object3);
                ((TTGlyph)object3).writePathsToStream(objectOutputStream);
                continue;
            }
            if (object3 instanceof T3Glyph) {
                objectOutputStream.writeObject(T3GLYPH);
                ((T3Glyph)object3).writePathsToStream(objectOutputStream);
                continue;
            }
            if (object3 instanceof PdfTexturePaint) {
                objectOutputStream.writeObject(TEXTUREDPAINT);
                object2 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((PdfTexturePaint)object3).getImage(), "png", (OutputStream)object2);
                objectOutputStream.writeObject(((ByteArrayOutputStream)object2).toByteArray());
                object = ((PdfTexturePaint)object3).getAnchorRect();
                objectOutputStream.writeDouble(((Rectangle2D)object).getBounds2D().getX());
                objectOutputStream.writeDouble(((Rectangle2D)object).getBounds2D().getY());
                objectOutputStream.writeDouble(((Rectangle2D)object).getBounds2D().getWidth());
                objectOutputStream.writeDouble(((Rectangle2D)object).getBounds2D().getHeight());
                continue;
            }
            if (object3 instanceof Area) {
                objectOutputStream.writeObject(AREA);
                object2 = (Area)this.items[i];
                object = ((Area)object2).getPathIterator(new AffineTransform());
                PathSerializer.serializePath(objectOutputStream, (PathIterator)object);
                continue;
            }
            try {
                objectOutputStream.writeObject(GENERIC);
                objectOutputStream.writeObject(object3);
                continue;
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) continue;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        objectOutputStream.close();
    }

    public void restoreFromStream(ByteArrayInputStream byteArrayInputStream) throws IOException, ClassNotFoundException {
        int n;
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        this.max_size = n = ((Integer)objectInputStream.readObject()).intValue();
        this.items = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            float f;
            Integer n2 = (Integer)objectInputStream.readObject();
            if (n2.compareTo(BASICSTROKE) == 0) {
                float f2 = objectInputStream.readFloat();
                int n3 = objectInputStream.readInt();
                int n4 = objectInputStream.readInt();
                float f3 = objectInputStream.readFloat();
                float[] fArray = (float[])objectInputStream.readObject();
                f = objectInputStream.readFloat();
                object = new BasicStroke(f2, n3, n4, f3, fArray, f);
            } else if (n2.compareTo(RECT) == 0) {
                float f4 = objectInputStream.readFloat();
                float f5 = objectInputStream.readFloat();
                float f6 = objectInputStream.readFloat();
                float f7 = objectInputStream.readFloat();
                object = new Rectangle2D.Float(f4, f5, f6, f7);
            } else if (n2.compareTo(BUFFERED_IMAGE) == 0) {
                byte[] byArray = (byte[])objectInputStream.readObject();
                object = ImageIO.read(new ByteArrayInputStream(byArray));
            } else if (n2.compareTo(GENERAL_PATH) == 0) {
                object = PathSerializer.deserializePath(objectInputStream);
            } else if (n2.compareTo(T1GLYPH) == 0) {
                T1Glyph t1Glyph = (T1Glyph)objectInputStream.readObject();
                int n5 = (Integer)objectInputStream.readObject();
                GeneralPath[] generalPathArray = new GeneralPath[n5];
                for (int j = 0; j < n5; ++j) {
                    generalPathArray[j] = PathSerializer.deserializePath(objectInputStream);
                }
                Vector_Path vector_Path = new Vector_Path();
                vector_Path.set(generalPathArray);
                vector_Path.setCurrent_item(generalPathArray.length);
                t1Glyph.setPaths(vector_Path);
                object = t1Glyph;
            } else if (n2.compareTo(TTGLYPH) == 0) {
                TTGlyph tTGlyph = (TTGlyph)objectInputStream.readObject();
                int n6 = (Integer)objectInputStream.readObject();
                GeneralPath[] generalPathArray = new GeneralPath[n6];
                for (int j = 0; j < n6; ++j) {
                    generalPathArray[j] = PathSerializer.deserializePath(objectInputStream);
                }
                Vector_Path vector_Path = new Vector_Path();
                vector_Path.set(generalPathArray);
                vector_Path.setCurrent_item(generalPathArray.length);
                tTGlyph.setPaths(vector_Path);
                object = tTGlyph;
            } else if (n2.compareTo(T3GLYPH) == 0) {
                object = new T3Glyph(objectInputStream);
            } else if (n2.compareTo(TEXTUREDPAINT) == 0) {
                byte[] byArray = (byte[])objectInputStream.readObject();
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                float f8 = objectInputStream.readFloat();
                float f9 = objectInputStream.readFloat();
                float f10 = objectInputStream.readFloat();
                f = objectInputStream.readFloat();
                Rectangle2D.Float float_ = new Rectangle2D.Float(f8, f9, f10, f);
                object = new PdfTexturePaint(bufferedImage, float_);
            } else if (n2.compareTo(AREA) == 0) {
                GeneralPath generalPath = PathSerializer.deserializePath(objectInputStream);
                object = new Area(generalPath);
            } else {
                object = objectInputStream.readObject();
            }
            this.items[i] = object;
        }
    }

    public void trim() {
        Object[] objectArray = new Object[this.current_item];
        System.arraycopy(this.items, 0, objectArray, 0, this.current_item);
        this.items = objectArray;
        this.max_size = this.current_item;
    }

    public void setSize(int n) {
        this.current_item = n;
    }
}

