/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.javafx;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.render.output.FontMapper;
import org.jpedal.render.output.GenericFontMapper;
import org.jpedal.render.output.OutputDisplay;
import org.jpedal.render.output.javafx.FXMLShape;
import org.jpedal.render.output.javafx.JavaFXHelper;
import org.jpedal.utils.LogWriter;

public class FXMLDisplay
extends OutputDisplay {
    String packageName = "";
    private int lastFontTextLength;
    private int fontTextLength;
    private int lastFontSizeAsString;
    private String textWithSpaces;
    private int shapeCount = 0;
    private String divName;
    private String javaFxFileName = "";
    private int textX;
    private int textY;
    private String currentAffine = "";
    private boolean simpleText;

    public FXMLDisplay(int n, Point2D point2D, Rectangle rectangle, boolean bl, int n2, ObjectStore objectStore) {
        super(n, point2D, rectangle, bl, n2, objectStore, null);
        this.type = 6;
        Helper = new JavaFXHelper();
        this.firstPageName = System.getProperty("org.jpedal.pdf2javafx.firstPageName");
        Pattern pattern = Pattern.compile("[^a-zA-Z]");
        if (this.firstPageName != null && (this.firstPageName.length() == 0 || pattern.matcher(this.firstPageName.substring(0, 1)).find())) {
            throw new RuntimeException("org.jpedal.pdf2javafx.firstPageName must begin with a character A-Z or a-z.");
        }
    }

    public static String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd - MMMMM - yyyy");
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    protected void completeOutput() {
        boolean bl;
        block5: {
            this.flushText();
            bl = false;
            if (this.endPage == 1 || this.endPage - this.startPage == 0) {
                bl = true;
            }
            this.writeCustom(0, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.writeCustom(0, "");
            this.writeCustom(0, "<?import java.lang.*?>");
            this.writeCustom(0, "<?import javafx.scene.*?>");
            this.writeCustom(0, "<?import javafx.scene.control.*?>");
            this.writeCustom(0, "<?import javafx.scene.layout.*?>");
            this.writeCustom(0, "<?import javafx.scene.image.*?>");
            this.writeCustom(0, "<?import javafx.scene.shape.*?>");
            this.writeCustom(0, "<?import javafx.scene.text.*?>");
            this.writeCustom(0, "");
            this.writeCustom(0, "<BorderPane prefHeight=\"" + (this.pageData.getCropBoxHeight(this.pageNumber) + 50) + "\" prefWidth=\"" + this.pageData.getCropBoxWidth(this.pageNumber) + "\" xmlns:fx=\"http://javafx.com/fxml\" fx:controller=\"" + this.packageName + "." + (this.firstPageName != null && this.pageNumber == 1 ? this.firstPageName : "page" + this.pageNumberAsString) + "\">");
            this.writeCustom(0, "\t");
            this.writeCustom(0, "\t<center>");
            this.writeCustom(0, "\t");
            this.writeCustom(0, "\t\t<Pane fx:id=\"PDFContent\">");
            this.writeCustom(0, "");
            this.writeCustom(0, "");
            try {
                this.writeCustom(0, this.script.toString());
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        this.writeCustom(0, "\t\t</Pane>");
        this.writeCustom(0, "\t");
        this.writeCustom(0, "\t</center>");
        if (!bl) {
            this.writeCustom(0, "\n\t<bottom>");
            this.writeCustom(0, "\t\t<HBox id=\"navBar\" alignment=\"center\" spacing=\"5\" style=\"-fx-background-color: #F0F8FF\" prefHeight=\"50\" prefWidth=\"" + this.pageData.getCropBoxWidth(this.pageNumber) + "\" layoutY=\"" + (this.pageData.getCropBoxHeight(this.pageNumber) + 10) + '\"' + '>');
            this.writeCustom(0, "\t\t\t<children>");
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t\t<Button id=\"start\" onAction=\"#firstPage\" >");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"First page\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/smstart.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t</Button>");
            this.writeCustom(0, "\t\t\t\t<Button id=\"back10Pages\" onAction=\"#previous10Pages\" >");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Previous 10 pages\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/smfback.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t</Button>");
            this.writeCustom(0, "\t\t\t\t<Button id=\"backOnePage\" onAction=\"#previousPage\" >");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Previous page\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/smback.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t</Button>");
            this.writeCustom(0, "\t\t\t\t<TextField alignment=\"center\" text= \"" + this.pageNumber + "\" maxHeight=\"25\" prefWidth=\"50\" editable= \"NO\"/>");
            this.writeCustom(0, "\t\t\t\t<Label text=\":\" style=\"-fx-font: DARK 26 Arial;\"/>");
            this.writeCustom(0, "\t\t\t\t<TextField alignment=\"center\" text= \"" + this.endPage + "\" maxHeight=\"25\" prefWidth=\"50\" editable= \"NO\"/>");
            this.writeCustom(0, "\t\t\t\t<Button id=\"forward\" onAction=\"#nextPage\" >");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Next page\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/smforward.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t</Button>");
            this.writeCustom(0, "\t\t\t\t<Button id=\"next10Pages\" onAction=\"#next10Pages\" >");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Next 10 pages\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/smfforward.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t</Button>");
            this.writeCustom(0, "\t\t\t\t<Button  id=\"end\" onAction=\"#endPage\" >");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Last page\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/smend.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t</Button>");
            this.writeCustom(0, "\t\t\t\t<Hyperlink onAction=\"#ourWebSite\">");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/logo.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Visit our website\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t</Hyperlink>");
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t</children>");
            this.writeCustom(0, "\t\t</HBox>");
            this.writeCustom(0, "\t</bottom>");
        }
        this.writeCustom(0, "</BorderPane>");
        this.createMainClassContent(bl);
        if (!bl) {
            this.createFXMLPDFStage();
        }
        this.customIO.flush();
    }

    private String createFXMLPDFStage() {
        String string;
        block3: {
            this.writeCustom(13, "/**");
            this.writeCustom(13, "* ===========================================");
            this.writeCustom(13, "* Java Pdf Extraction Decoding Access Library");
            this.writeCustom(13, "* ===========================================");
            this.writeCustom(13, "*");
            this.writeCustom(13, "* Project Info:  http://www.idrsolutions.com");
            this.writeCustom(13, "*");
            this.writeCustom(13, "* generated by JPedal PDF to FXML");
            this.writeCustom(13, "*");
            this.writeCustom(13, "* --------------------------------------------");
            this.writeCustom(13, "* PDFStage.java");
            this.writeCustom(13, "* --------------------------------------------");
            this.writeCustom(13, "* --------------------------------------------");
            this.writeCustom(13, "* " + FXMLDisplay.getDate());
            this.writeCustom(13, "* --------------------------------------------");
            this.writeCustom(13, "*/");
            this.writeCustom(13, "");
            this.writeCustom(13, "");
            this.writeCustom(13, "package " + this.packageName + ';');
            this.writeCustom(13, "");
            this.writeCustom(13, "import javafx.stage.Stage;");
            this.writeCustom(13, "");
            this.writeCustom(13, "");
            this.writeCustom(13, "public class PDFStage {");
            this.writeCustom(13, "");
            this.writeCustom(13, "");
            this.writeCustom(13, "\tprivate static Stage stage = null;");
            this.writeCustom(13, "\t");
            this.writeCustom(13, "\tpublic static Stage getInstance(){");
            this.writeCustom(13, "\t");
            this.writeCustom(13, "\t\tif(stage == null){");
            this.writeCustom(13, "\t\t\tstage = new Stage();");
            this.writeCustom(13, "\t\t}");
            this.writeCustom(13, "\t");
            this.writeCustom(13, "\t\tstage.centerOnScreen();");
            this.writeCustom(13, "\t\tstage.resizableProperty().set(false);");
            this.writeCustom(13, "\t");
            this.writeCustom(13, "\t\treturn stage;");
            this.writeCustom(13, "\t");
            this.writeCustom(13, "\t}");
            this.writeCustom(13, "\t");
            this.writeCustom(13, "}");
            string = this.rootDir;
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(string + "PDFStage.java"));
                printWriter.println(this.fxmlPDFStage.toString());
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        return string;
    }

    private String createMainClassContent(Boolean bl) {
        String string;
        block19: {
            int n;
            this.writeCustom(4, "/**");
            this.writeCustom(4, "* ===========================================");
            this.writeCustom(4, "* Java Pdf Extraction Decoding Access Library");
            this.writeCustom(4, "* ===========================================");
            this.writeCustom(4, "*");
            this.writeCustom(4, "* Project Info:  http://www.idrsolutions.com");
            this.writeCustom(4, "*");
            this.writeCustom(4, "* generated by JPedal PDF to FXML");
            this.writeCustom(4, "*");
            this.writeCustom(4, "* --------------------------------------------");
            this.writeCustom(4, "* " + this.packageName + ".pdf");
            this.writeCustom(4, "* --------------------------------------------");
            this.writeCustom(4, "* --------------------------------------------");
            this.writeCustom(4, "* " + FXMLDisplay.getDate());
            this.writeCustom(4, "* --------------------------------------------");
            this.writeCustom(4, "*/");
            this.writeCustom(4, "");
            this.writeCustom(4, "");
            this.writeCustom(4, " package " + this.packageName + ';');
            this.writeCustom(4, "");
            this.writeCustom(4, "");
            this.writeCustom(4, " import java.io.IOException;");
            this.writeCustom(4, " import java.net.URI;");
            this.writeCustom(4, " import java.net.URISyntaxException;");
            this.writeCustom(4, " import javafx.application.Application;");
            this.writeCustom(4, " import java.net.URL;");
            this.writeCustom(4, " import java.util.ResourceBundle;");
            this.writeCustom(4, " import javafx.fxml.Initializable;");
            this.writeCustom(4, " import javafx.fxml.FXMLLoader;");
            this.writeCustom(4, " import javafx.scene.Parent;");
            this.writeCustom(4, " import javafx.scene.Scene;");
            this.writeCustom(4, " import javafx.stage.Stage;");
            this.writeCustom(4, " import javafx.fxml.FXML;");
            this.writeCustom(4, " import javafx.event.ActionEvent;");
            this.writeCustom(4, " import javafx.scene.text.Text;");
            this.writeCustom(4, " import javafx.scene.text.Font;");
            this.writeCustom(4, " import javafx.scene.text.FontPosture;");
            this.writeCustom(4, " import javafx.scene.text.FontWeight;");
            if (!bl.booleanValue()) {
                this.writeCustom(4, " import javafx.scene.layout.Pane;");
                this.writeCustom(4, " import javafx.util.Duration;");
                this.writeCustom(4, " import javafx.animation.FadeTransition;");
                this.writeCustom(4, " import javafx.scene.Node;");
                this.writeCustom(4, " import java.lang.reflect.Method;");
            }
            this.writeCustom(4, " ");
            this.writeCustom(4, "");
            this.writeCustom(4, "");
            this.writeCustom(4, "public class " + (this.firstPageName != null && this.pageNumber == 1 ? this.firstPageName : "page" + this.pageNumberAsString) + " extends Application implements Initializable{");
            this.writeCustom(4, "");
            if (!bl.booleanValue()) {
                this.writeCustom(4, "\t@FXML private Pane PDFContent;");
            }
            for (n = 1; n <= this.textID - 1; ++n) {
                this.writeCustom(4, "\t@FXML private Text tb_" + n + ';');
            }
            this.writeCustom(4, "");
            this.writeCustom(4, "\tpublic static void main(String[] args) {");
            this.writeCustom(4, "\t\tApplication.launch(" + (this.firstPageName != null && this.pageNumber == 1 ? this.firstPageName : "page" + this.pageNumberAsString) + ".class, args);");
            this.writeCustom(4, "\t}");
            this.writeCustom(4, "\t");
            this.writeCustom(4, "\t@Override");
            this.writeCustom(4, "\tpublic void start(Stage stage) throws Exception {");
            if (!bl.booleanValue()) {
                this.writeCustom(4, "\t\tstage = PDFStage.getInstance();");
            }
            this.writeCustom(4, "\t\tloadPage(stage);");
            this.writeCustom(4, "\t}");
            this.writeCustom(4, "");
            this.writeCustom(4, "\t@Override");
            this.writeCustom(4, "\tpublic void initialize(URL url, ResourceBundle rb) {");
            if (!bl.booleanValue()) {
                this.writeCustom(4, "\t\tcreateTransition(PDFContent);");
            }
            if (this.fxmlText.size() != 0) {
                this.writeCustom(4, "\t\tdrawPage0();");
                this.writeCustom(4, "\t}\n");
                n = 0;
                int n2 = 0;
                int n3 = 50;
                while (true) {
                    StringBuilder stringBuilder = new StringBuilder(n3);
                    for (int i = 0; i < n3 && this.fxmlText.size() > n2; ++n2, ++i) {
                        stringBuilder.append((String)this.fxmlText.get(n2) + '\n');
                    }
                    this.writeCustom(4, "\tprivate void drawPage" + n + "() {");
                    this.writeCustom(4, stringBuilder.toString());
                    if (this.fxmlText.size() <= n2) break;
                    this.writeCustom(4, "\t\tdrawPage" + ++n + "();// Chain to prevent methods being over 64KB so that the class will not refuse to compile. \n\t}\n");
                }
            }
            this.writeCustom(4, "\t}");
            this.writeCustom(4, "\t");
            if (!bl.booleanValue()) {
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void firstPage(ActionEvent event) {");
                this.writeCustom(4, "\t\tnewPage( 0 , false , PDFStage.getInstance());");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void previous10Pages(ActionEvent event) {");
                this.writeCustom(4, "\t\tnewPage( 10 , false , PDFStage.getInstance());");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void previousPage(ActionEvent event) {");
                this.writeCustom(4, "\t\tnewPage( 1 , false , PDFStage.getInstance());");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void nextPage(ActionEvent event) {");
                this.writeCustom(4, "\t\tnewPage( 1 , true , PDFStage.getInstance());");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void next10Pages(ActionEvent event) {");
                this.writeCustom(4, "\t\tnewPage( 10 , true , PDFStage.getInstance());");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void endPage(ActionEvent event) {");
                this.writeCustom(4, "\t\tnewPage( 9999 , false , PDFStage.getInstance());");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void ourWebSite(ActionEvent event) throws IOException, URISyntaxException {");
                this.writeCustom(4, "\t\tjava.awt.Desktop.getDesktop().browse(new URI(\"http://www.idrsolutions.com/\"));");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
            }
            this.writeCustom(4, "\tpublic void loadPage(Stage stage) throws IOException {");
            this.writeCustom(4, "\t");
            this.writeCustom(4, "\t\tParent root = FXMLLoader.load(getClass().getResource(\"" + (this.firstPageName != null && this.pageNumber == 1 ? this.firstPageName : "page" + this.pageNumberAsString) + ".fxml\"));");
            this.writeCustom(4, "\t\t");
            if (bl.booleanValue()) {
                this.writeCustom(4, "\t\tstage.setTitle(\"" + this.packageName + "\");");
            } else {
                this.writeCustom(4, "\t\tstage.setTitle(\"" + this.packageName + " - Page " + this.pageNumber + "\");");
            }
            this.writeCustom(4, "\t\tstage.setScene(new Scene(root));");
            this.writeCustom(4, "\t\tstage.show();");
            this.writeCustom(4, "\t}");
            this.writeCustom(4, "\t");
            this.writeCustom(4, "\tprivate static void setTextsize(Text textBox, float requiredWidth) {");
            this.writeCustom(4, "\t\tfloat actualWidth=(int) textBox.getLayoutBounds().getWidth();");
            this.writeCustom(4, "\t\tfloat dx=requiredWidth-actualWidth;");
            this.writeCustom(4, "\t\tfloat scalingNeeded=requiredWidth/actualWidth;");
            this.writeCustom(4, "\t\ttextBox.setScaleX(scalingNeeded);");
            this.writeCustom(4, "\t\ttextBox.setScaleY(scalingNeeded);");
            this.writeCustom(4, "\t\ttextBox.setTranslateX(dx/2);");
            this.writeCustom(4, "\t}");
            this.writeCustom(4, "\t");
            if (!bl.booleanValue()) {
                this.writeCustom(4, "\tprivate static void createTransition(Node i){");
                this.writeCustom(4, "\t\tFadeTransition fadeOutTransition = new FadeTransition(Duration.seconds(2), i);");
                this.writeCustom(4, "\t\tfadeOutTransition.setFromValue(0.0);");
                this.writeCustom(4, "\t\tfadeOutTransition.setToValue(3.0);");
                this.writeCustom(4, "\t\tfadeOutTransition.play();");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\tprivate static void newPage(int change, boolean forward, final Stage stage) {");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t\tfinal int currentPageNo = " + this.pageNumber + ", pageCount = " + this.endPage + " ;");
                this.writeCustom(4, "\t\tint newPageNo = 0;");
                this.writeCustom(4, "\t\t");
                this.writeCustom(4, "\t\tif (change == 0) { //special case 1st page");
                this.writeCustom(4, "\t\t\tnewPageNo = 1;");
                this.writeCustom(4, "\t\t} else if (change == 9999) { //special case last page");
                this.writeCustom(4, "\t\t\tnewPageNo = pageCount;");
                this.writeCustom(4, "\t\t} else {");
                this.writeCustom(4, "\t\t\tif (forward) {");
                this.writeCustom(4, "\t\t\t\tnewPageNo = currentPageNo + change;");
                this.writeCustom(4, "\t\t\t} else {");
                this.writeCustom(4, "\t\t\t\tnewPageNo = currentPageNo - change;");
                this.writeCustom(4, "\t\t\t}");
                this.writeCustom(4, "\t\t}");
                this.writeCustom(4, "\t\t");
                this.writeCustom(4, "\t\t//error check for bounds");
                this.writeCustom(4, "\t\tif (newPageNo < 1) {");
                this.writeCustom(4, "\t\t\tnewPageNo = 1;");
                this.writeCustom(4, "\t\t} else if (newPageNo > pageCount) {");
                this.writeCustom(4, "\t\t\tnewPageNo = pageCount;");
                this.writeCustom(4, "\t\t}");
                this.writeCustom(4, "\t\t");
                if (this.firstPageName != null && this.firstPageName.length() > 0) {
                    this.writeCustom(4, "\t\tString customClassName = \"" + this.packageName + '.' + this.firstPageName + "\";");
                    this.writeCustom(4, "\t\tboolean customFirstPage = false;");
                }
                this.writeCustom(4, "\t\t//Add zero when required as prefix of the new pages.");
                this.writeCustom(4, "\t\tString newPageNoAsString = String.valueOf(newPageNo);");
                if (this.firstPageName != null && this.firstPageName.length() > 0) {
                    this.writeCustom(4, "");
                    this.writeCustom(4, "\t\tif(newPageNoAsString.equals(\"1\"))");
                    this.writeCustom(4, "\t\t\tcustomFirstPage=true;");
                    this.writeCustom(4, "");
                }
                this.writeCustom(4, "\t\tString maxNumberOfPages = String.valueOf(pageCount);");
                this.writeCustom(4, "\t\tint padding = maxNumberOfPages.length() - newPageNoAsString.length();");
                this.writeCustom(4, "\t\tfor (int ii = 0; ii < padding; ii++) {");
                this.writeCustom(4, "\t\t\tnewPageNoAsString = '0' + newPageNoAsString;");
                this.writeCustom(4, "\t\t}");
                this.writeCustom(4, "\t\t");
                if (this.firstPageName != null && this.firstPageName.length() > 0) {
                    this.writeCustom(4, "\t\t//workout new class from pageNumber");
                    this.writeCustom(4, "\t\tString newClass=\"\";");
                    this.writeCustom(4, "\t\t");
                    this.writeCustom(4, "\t\tif(customFirstPage)");
                    this.writeCustom(4, "\t\t\tnewClass=customClassName;");
                    this.writeCustom(4, "\t\telse");
                    this.writeCustom(4, "\t\t\tnewClass=\"" + this.packageName + ".page" + "\"+newPageNoAsString;");
                } else {
                    this.writeCustom(4, "\t\t//workout new class from pageNumber");
                    this.writeCustom(4, "\t\tString newClass=\"" + this.packageName + ".page" + "\"+newPageNoAsString;");
                }
                this.writeCustom(4, "\t\t");
                this.writeCustom(4, "\t\t//create an instance");
                this.writeCustom(4, "\t\ttry {");
                this.writeCustom(4, "\t\t\tClass c = Class.forName(newClass);");
                this.writeCustom(4, "\t\t\tApplication nextPage = (javafx.application.Application) c.newInstance();");
                this.writeCustom(4, "\t\t");
                this.writeCustom(4, "\t\t\tMethod m = c.getMethod(\"loadPage\", new Class[]{Stage.class});");
                this.writeCustom(4, "\t\t\tm.invoke(nextPage, new Object[]{stage});");
                this.writeCustom(4, "\t\t\t");
                this.writeCustom(4, "\t\t} catch (Exception e) {");
                this.writeCustom(4, "\t\t\te.printStackTrace();");
                this.writeCustom(4, "\t\t}");
                this.writeCustom(4, "\t\t");
                this.writeCustom(4, "\t}");
            }
            this.writeCustom(4, "}");
            string = this.rootDir;
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(string + (this.firstPageName != null && this.pageNumber == 1 ? this.firstPageName : "page" + this.pageNumberAsString) + ".java"));
                printWriter.println(this.css.toString());
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block19;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        return string;
    }

    protected void writeoutTextAsDiv(float f) {
        if (this.currentTextBlock.isEmpty()) {
            throw new RuntimeException("writeoutTextAsDiv() called incorrectly.  Attempted to write out text with empty text block use flushText.");
        }
        this.divName = "tb_" + this.textID;
        String string = this.currentTextBlock.getOutputString(true);
        int n = this.currentTextBlock.getFontSize() + this.currentTextBlock.getFontAdjustment();
        int n2 = this.currentTextBlock.getAltFontSize();
        int n3 = this.currentTextBlock.getFontCondition();
        if (n2 > 0) {
            switch (n3) {
                case 1: {
                    if (string.length() <= 32) break;
                    n = n2;
                    break;
                }
                case 2: {
                    n = n2;
                }
            }
        }
        int n4 = (int)((float)n * this.scaling);
        if (n < 1) {
            return;
        }
        this.textWithSpaces = this.currentTextBlock.getOutputString(false);
        this.fontTextLength = this.textWithSpaces.length();
        this.writePosition("", false, f);
        String string2 = this.simpleText ? "layoutX=\"" + this.textX + "\" layoutY=\"" + this.textY + "\" " : "";
        String string3 = this.currentTextBlock.getWeight();
        String string4 = FXMLDisplay.setJavaFxWeight(string3);
        String string5 = this.currentTextBlock.getStyle().equals("normal") ? "REGULAR" : "ITALIC";
        this.writeCustom(15, "\t" + this.divName + ".setFont(Font.font(\"" + this.currentTextBlock.getFont() + "\", FontWeight." + string4 + ", FontPosture." + string5 + ", " + n4 + "));");
        String string6 = "";
        if (this.currentTextBlock.getColor() != -14475232) {
            string6 = "fill=\"" + FXMLDisplay.hexColor(this.currentTextBlock.getColor()) + "\"";
        }
        if (string.startsWith("$")) {
            string = "\u200b$" + string.substring(1);
        }
        this.writeCustom(2, "\n\t<Text fx:id=\"" + this.divName + "\" text=\"" + FXMLDisplay.tidyQuotes(string) + "\" " + string2 + string6 + ">" + this.currentAffine + "</Text>");
        ++this.textID;
    }

    protected void writeTextPosition(float[] fArray, int n, int n2, float f) {
        if (fArray[0] > 0.0f && fArray[3] > 0.0f && fArray[1] == 0.0f && fArray[2] == 0.0f) {
            this.simpleText = true;
            this.currentAffine = "";
            this.textX = n;
            this.textY = n2;
        } else {
            this.simpleText = false;
            this.currentAffine = "\n\t\t<transforms>\n\t\t\t<javafx.scene.transform.Affine mxx=\"" + FXMLDisplay.setPrecision(fArray[0] / f, 2) + "\" myx=\"" + FXMLDisplay.setPrecision(fArray[1] / f, 2) + "\" mxy=\"" + FXMLDisplay.setPrecision(fArray[2] / f, 2) + "\" myy=\"" + FXMLDisplay.setPrecision(fArray[3] / f, 2) + "\" tx=\"" + n + "\" ty=\"" + n2 + "\" />\n\t\t</transforms>\n\t";
        }
    }

    private static String tidyQuotes(String string) {
        char[] cArray = new char[]{'\"', '&', '<', '>', '\'', '\u00a3'};
        String[] stringArray = new String[]{"&quot;", "&amp;", "&lt;", "&gt;", "&apos;", "&#163;"};
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            boolean bl = false;
            for (int j = 0; j < cArray.length; ++j) {
                if (string.charAt(i) != cArray[j]) continue;
                string2 = string2 + stringArray[j];
                bl = true;
                break;
            }
            if (bl) continue;
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }

    public void setBooleanValue(int n, boolean bl) {
        switch (n) {
            case 4: {
                this.includeJSFontResizingCode = bl;
                break;
            }
            default: {
                super.setBooleanValue(n, bl);
            }
        }
    }

    public void setTag(int n, String string) {
        switch (n) {
            case 0: {
                this.tag[0] = string;
                break;
            }
            default: {
                super.setTag(n, string);
            }
        }
    }

    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, Object object, int n2, GraphicsState graphicsState, AffineTransform affineTransform, String string, PdfFont pdfFont, float f) {
        super.drawEmbeddedText(fArray, n, pdfGlyph, object, n2, graphicsState, affineTransform, string, pdfFont, f);
    }

    public void drawShape(Shape shape, GraphicsState graphicsState, int n) {
        super.drawShape(shape, graphicsState, n);
    }

    public int drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl, String string, int n2, int n3) {
        int n4 = super.drawImage(n, bufferedImage, graphicsState, bl, string, n2, n3);
        if (n4 == -2) {
            float f = graphicsState.getAlpha(2);
            String string2 = "";
            if (f < 1.0f) {
                string2 = " opacity=\"" + f + "\"";
            }
            this.writeCustom(2, "\n\t<ImageView id=\"" + string + "\" layoutX=\"" + this.currentImage[0] + "\" layoutY=\"" + this.currentImage[1] + "\" fitWidth=\"" + this.currentImage[2] + "\" fitHeight=\"" + this.currentImage[3] + "\"" + string2 + ">");
            this.writeCustom(2, "\t<image>");
            this.writeCustom(2, "\t\t<Image url=\"@" + this.imageName + "\"/>");
            this.writeCustom(2, "\t</image>");
            this.writeCustom(2, "</ImageView>");
        }
        return -1;
    }

    public void setOutputDir(String string, String string2, String string3) {
        super.setOutputDir(string, string2, string3);
        if (this.pageNumber == 1 && this.firstPageName != null && this.firstPageName.length() > 0) {
            this.javaFxFileName = this.firstPageName;
            this.fileName = string3;
        } else {
            this.javaFxFileName = "page" + string3;
            this.fileName = string3;
        }
        this.packageName = string2;
        if (this.packageName.contains(" ")) {
            this.packageName = this.packageName.replaceAll(" ", "_");
        }
    }

    public void init(int n, int n2, int n3, Color color) {
        block3: {
            super.init(n, n2, n3, color);
            if (this.rootDir == null) {
                throw new RuntimeException("Please pass in output_dir (second param if running ExtractpageAsJavaFX");
            }
            try {
                this.customIO.setupOutput(this.rootDir + this.javaFxFileName + ".fxml", false, this.encodingType[0]);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void writeCustom(int var1_1, Object var2_2) {
        switch (var1_1) {
            case 0: {
                this.customIO.writeString(var2_2.toString());
                break;
            }
            case 1: {
                this.topSection.append('\t');
                this.topSection.append(var2_2.toString());
                this.topSection.append('\n');
                break;
            }
            case 2: {
                this.script.append('\t');
                this.script.append(var2_2.toString());
                this.script.append('\n');
                break;
            }
            case 15: {
                this.fxmlText.add("\t" + var2_2.toString());
                break;
            }
            case 3: {
                this.form.append(var2_2.toString());
                break;
            }
            case 6: {
                this.testDivs.append(var2_2.toString());
                break;
            }
            case 4: {
                this.css.append(var2_2.toString());
                this.css.append('\n');
                break;
            }
            case 13: {
                this.fxmlPDFStage.append(var2_2.toString());
                this.fxmlPDFStage.append('\n');
                break;
            }
            case 7: {
                try {
                    this.writeEveryGlyf = (Boolean)var2_2;
                }
                catch (Exception var3_3) {
                    if (!LogWriter.isOutput()) break;
                    LogWriter.writeLog("Exception: " + var3_3.getMessage());
                }
                break;
            }
            case 8: {
                try {
                    this.encodingType = (String[])var2_2;
                }
                catch (Exception var3_4) {
                    if (!LogWriter.isOutput()) break;
                    LogWriter.writeLog("Exception: " + var3_4.getMessage());
                }
                break;
            }
            case 9: {
                if (this.jsImagesAdded) break;
                this.writeCustom(1, var2_2);
                this.jsImagesAdded = true;
                break;
            }
            case 10: {
                var3_5 = (Object[])var2_2;
                var4_6 = (PdfFont)var3_5[0];
                var5_7 = var4_6.getFontName();
                var6_8 = (String)var3_5[2];
                var7_9 = this.rootDir + this.javaFxFileName + '/';
                var8_10 = new File(var7_9);
                if (!var8_10.exists()) {
                    var8_10.mkdirs();
                }
                try {
                    var9_11 = new BufferedOutputStream(new FileOutputStream(var7_9 + var5_7 + '.' + var6_8));
                    var9_11.write((byte[])var3_5[1]);
                    var9_11.flush();
                    var9_11.close();
                }
                catch (Exception var9_12) {
                    if (!LogWriter.isOutput()) ** GOTO lbl85
                    LogWriter.writeLog("Exception: " + var9_12.getMessage());
                }
lbl85:
                // 3 sources

                var9_11 = new StringBuffer();
                var9_11.append("@font-face {\n");
                var9_11.append("\tfont-family: ").append(var5_7).append(";\n");
                var9_11.append("\tsrc: url(\"").append(this.javaFxFileName).append('/').append(var5_7).append('.').append(var6_8).append("\");\n");
                var9_11.append("}\n");
                this.writeCustom(4, var9_11);
                break;
            }
            default: {
                super.writeCustom(var1_1, var2_2);
            }
        }
    }

    protected void drawPatternedShape(Shape shape, GraphicsState graphicsState) {
        super.drawPatternedShape(shape, graphicsState);
        if (this.currentPatternedShape[0] != -1) {
            this.writeCustom(2, "\n\t<ImageView layoutX=\"" + this.currentPatternedShape[0] + "\" layoutY=\"" + this.currentPatternedShape[1] + "\" fitWidth=\"" + this.currentPatternedShape[2] + "\" fitHeight=\"" + this.currentPatternedShape[3] + "\">");
            this.writeCustom(2, "\t<image>");
            this.writeCustom(2, "\t\t<Image url=\"@" + this.currentPatternedShapeName + "\"/>");
            this.writeCustom(2, "\t</image>");
            this.writeCustom(2, "</ImageView>");
        }
    }

    protected void drawNonPatternedShape(Shape shape, GraphicsState graphicsState, int n, String string, Rectangle2D rectangle2D, Point2D point2D) {
        FXMLShape fXMLShape = new FXMLShape(n, this.shapeCount, this.scaling, shape, graphicsState, new AffineTransform(), point2D, rectangle2D.getBounds(), this.currentColor, this.dpCount, this.pageRotation, this.pageData, this.pageNumber, this.includeClip);
        fXMLShape.setShapeNumber(this.shapeCount);
        ++this.shapeCount;
        if (!fXMLShape.isEmpty()) {
            this.writeCustom(2, fXMLShape.getContent());
            this.currentColor = fXMLShape.getShapeColor();
        }
    }

    protected void drawTextArea() {
        if (this.currentTextBlock.isEmpty()) {
            return;
        }
    }

    protected void drawPageBorder() {
        double[] dArray = new double[]{this.cropBox.getX(), this.cropBox.getY()};
        this.writeCustom(2, "pdf.moveTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[0] = dArray[0] + this.cropBox.getWidth();
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[1] = dArray[1] + this.cropBox.getHeight();
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        dArray[0] = dArray[0] - this.cropBox.getWidth();
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
        this.writeCustom(2, "pdf.closePath();");
        this.writeCustom(2, "pdf.strokeStyle = '" + FXMLDisplay.rgbToColor(0) + "';");
        this.writeCustom(2, "pdf.lineWidth = '1'");
        this.writeCustom(2, "pdf.stroke();");
    }

    protected FontMapper getFontMapper(PdfFont pdfFont) {
        return new GenericFontMapper(pdfFont.getFontName(), this.fontMode, pdfFont.isFontEmbedded);
    }
}

