/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.render.T3Display;
import org.jpedal.render.T3Renderer;
import org.jpedal.utils.LogWriter;

public class T3Glyph
implements PdfGlyph {
    private boolean lockColours;
    T3Renderer glyphDisplay;
    private int maxWidth;
    private int maxHeight;
    String stringName;
    float glyphScale;
    int id;

    public T3Glyph() {
        this.lockColours = false;
        this.stringName = "";
        this.glyphScale = 1.0f;
        this.id = 0;
    }

    public String getGlyphName() {
        return this.stringName;
    }

    public void setStringName(String string) {
        this.stringName = string;
    }

    public T3Glyph(T3Renderer t3Renderer, int n, int n2, boolean bl, String string) {
        this.lockColours = false;
        this.stringName = "";
        this.glyphScale = 1.0f;
        this.id = 0;
        this.glyphDisplay = t3Renderer;
        this.maxWidth = n;
        this.maxHeight = n2;
        this.lockColours = bl;
        this.stringName = string;
    }

    public void setScaling(float f) {
        this.glyphScale = f;
    }

    public Area getShape() {
        return null;
    }

    public void render(int n, Graphics2D graphics2D, float f, boolean bl) {
        this.glyphDisplay.setScalingValues(0.0, 0.0, f);
        float f2 = this.glyphScale;
        if (bl) {
            this.glyphScale = f * this.glyphScale;
        }
        AffineTransform affineTransform = null;
        if (this.glyphScale != 1.0f) {
            affineTransform = graphics2D.getTransform();
            graphics2D.scale(this.glyphScale, this.glyphScale);
        }
        this.glyphDisplay.setG2(graphics2D);
        this.glyphDisplay.paint(null, null, null);
        if (affineTransform != null) {
            graphics2D.setTransform(affineTransform);
        }
        this.glyphScale = f2;
    }

    public float getmaxWidth() {
        if (this.maxWidth == 0 && this.glyphScale < 1.0f) {
            return 1.0f / this.glyphScale;
        }
        return this.maxWidth;
    }

    public int getmaxHeight() {
        return this.maxHeight;
    }

    public void setT3Colors(PdfPaint pdfPaint, PdfPaint pdfPaint2, boolean bl) {
        this.glyphDisplay.lockColors(pdfPaint, pdfPaint2, bl);
    }

    public boolean ignoreColors() {
        return this.lockColours;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int n) {
        this.id = n;
    }

    public void writePathsToStream(ObjectOutput objectOutput) throws IOException {
        byte[] byArray = this.glyphDisplay.serializeToByteArray(null);
        objectOutput.writeObject(byArray);
        objectOutput.writeInt(this.maxWidth);
        objectOutput.writeInt(this.maxHeight);
        objectOutput.writeBoolean(this.lockColours);
    }

    public T3Glyph(ObjectInput objectInput) {
        block2: {
            this.lockColours = false;
            this.stringName = "";
            this.glyphScale = 1.0f;
            this.id = 0;
            try {
                byte[] byArray = (byte[])objectInput.readObject();
                this.glyphDisplay = new T3Display(byArray, null);
                this.maxWidth = objectInput.readInt();
                this.maxHeight = objectInput.readInt();
                this.lockColours = objectInput.readBoolean();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
    }

    public void flushArea() {
    }

    public void setDisplacement(short s, float f) {
    }

    public void setWidth(float f) {
    }

    public int getFontBB(int n) {
        return 0;
    }

    public void setStrokedOnly(boolean bl) {
    }

    public boolean containsBrokenData() {
        return false;
    }
}

