/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.Type1;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class T1Glyphs
extends PdfJavaGlyphs {
    private static String nybChars = "0123456789.ee -";
    public boolean is1C = false;
    private String[] charForGlyphIndex;
    protected Map charStrings = new HashMap();
    protected Map glyphNumbers = new HashMap();
    int max = 100;
    double[] operandsRead = new double[this.max];
    int operandReached = 0;
    float[] pt;
    private double xs = -1.0;
    private double ys = -1.0;
    private double x = 0.0;
    private double y = 0.0;
    private int ptCount = 0;
    int currentOp = 0;
    private int hintCount = 0;
    private boolean allowAll = false;
    private double h;
    private boolean isCID;
    private int[] nominalWidthX = new int[]{0};
    private int[] defaultWidthX = new int[]{0};
    private boolean defaultWidthsPassed = false;
    private int[] fdSelect = null;
    DynamicVectorRenderer dynamicVectorRenderer = null;

    public T1Glyphs(boolean bl) {
        this.isCID = bl;
    }

    public T1Glyphs(boolean bl, boolean bl2) {
        this.charForGlyphIndex = new String[65536];
    }

    public T1Glyphs() {
    }

    public static String[] readFontNames(FontData fontData, int n) {
        String[] stringArray;
        block9: {
            BufferedReader bufferedReader;
            block8: {
                int n2;
                int n3;
                stringArray = new String[]{null};
                bufferedReader = new BufferedReader(new StringReader(new String(fontData.getBytes(0, fontData.length()))));
                String string = null;
                do {
                    block7: {
                        try {
                            string = bufferedReader.readLine();
                        }
                        catch (IOException iOException) {
                            if (!LogWriter.isOutput()) break block7;
                            LogWriter.writeLog("Exception: " + iOException.getMessage());
                        }
                    }
                    if (string == null) break block8;
                } while (!string.startsWith("/FontName") || (n3 = string.indexOf(47, 9)) == -1 || (n2 = string.indexOf(32, n3)) == -1);
                String string2 = string.substring(n3 + 1, n2);
                stringArray[0] = string2.toLowerCase();
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block9;
                    LogWriter.writeLog("Exception " + exception + " closing stream");
                }
            }
        }
        if (fontData != null) {
            fontData.close();
        }
        return stringArray;
    }

    private boolean processFlex(GlyphFactory glyphFactory, boolean bl, int n, boolean bl2, int n2) {
        if (bl2 && this.ptCount == 14 && n2 == 0) {
            bl2 = false;
            for (int i = 0; i < 12; i += 6) {
                glyphFactory.curveTo(this.pt[i], this.pt[i + 1], this.pt[i + 2], this.pt[i + 3], this.pt[i + 4], this.pt[i + 5]);
                if (!bl) continue;
                System.out.println("t1 flex " + this.pt[i] + ' ' + this.pt[i + 1] + ' ' + this.pt[i + 2] + ' ' + this.pt[i + 3] + ' ' + this.pt[i + 4] + ' ' + this.pt[i + 5]);
            }
        } else if (!bl2 && n2 >= 0 && n2 <= 2) {
            bl2 = true;
            this.ptCount = 0;
            this.pt = new float[16];
            if (bl) {
                System.out.println("flex on " + n + ' ' + n2);
            }
        }
        return bl2;
    }

    private void endchar(GlyphFactory glyphFactory, int n, boolean bl, int n2) {
        if (bl) {
            System.out.println("Endchar");
        }
        if (this.operandReached == 5) {
            --this.operandReached;
            ++this.currentOp;
        }
        if (this.operandReached == 4) {
            this.endchar(glyphFactory, n);
        } else {
            glyphFactory.closePath();
        }
    }

    private int mask(boolean bl, int n, int n2) {
        if (bl) {
            System.out.println("hintmask/cntrmask " + n2);
        }
        this.hintCount += this.operandReached / 2;
        if (bl) {
            System.out.println("hintCount=" + this.hintCount);
        }
        for (int i = this.hintCount; i > 0; i -= 8) {
            ++n;
        }
        return n;
    }

    private double sbw(boolean bl) {
        double d;
        this.y = d = this.operandsRead[this.operandReached - 2];
        this.xs = this.x = (d = this.operandsRead[this.operandReached - 1]);
        this.ys = this.y;
        this.allowAll = true;
        double d2 = this.y;
        this.h = this.operandsRead[this.operandReached - 3];
        if (bl) {
            System.out.println("sbw xs,ys set to " + this.x + ' ' + this.y);
        }
        return d2;
    }

    private void hmoveto(GlyphFactory glyphFactory, boolean bl, boolean bl2) {
        if (bl2 && this.operandReached == 2) {
            ++this.currentOp;
        }
        double d = this.operandsRead[this.currentOp];
        this.x += d;
        glyphFactory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
        if (bl) {
            System.out.println("reset xs,ys to " + this.x + ' ' + this.y);
        }
        if (bl) {
            System.out.println("hmoveto " + this.x + ' ' + this.y);
        }
    }

    private void rmoveto(GlyphFactory glyphFactory, boolean bl, boolean bl2) {
        if (bl2 && this.operandReached == 3) {
            ++this.currentOp;
        }
        if (bl) {
            System.out.println(this.currentOp + " " + this.operandReached + ' ' + bl2 + " x,y=(" + this.x + ' ' + this.y + ") xs,ys=(" + this.xs + ' ' + this.ys + ") rmoveto " + this.operandsRead[this.currentOp] + ' ' + this.operandsRead[this.currentOp + 1]);
        }
        double d = this.operandsRead[this.currentOp + 1];
        this.y += d;
        d = this.operandsRead[this.currentOp];
        this.x += d;
        glyphFactory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
        if (bl) {
            System.out.println("xs,ys=(" + this.xs + ' ' + this.ys + ") x=" + this.x + " y=" + this.y);
        }
    }

    private void vhhvcurveto(GlyphFactory glyphFactory, boolean bl, int n) {
        boolean bl2;
        boolean bl3 = bl2 = n == 31;
        while (this.operandReached >= 4) {
            this.operandReached -= 4;
            if (bl2) {
                this.x += this.operandsRead[this.currentOp];
            } else {
                this.y += this.operandsRead[this.currentOp];
            }
            this.pt[0] = (float)this.x;
            this.pt[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 1];
            this.y += this.operandsRead[this.currentOp + 2];
            this.pt[2] = (float)this.x;
            this.pt[3] = (float)this.y;
            if (bl2) {
                this.y += this.operandsRead[this.currentOp + 3];
                if (this.operandReached == 1) {
                    this.x += this.operandsRead[this.currentOp + 4];
                }
            } else {
                this.x += this.operandsRead[this.currentOp + 3];
                if (this.operandReached == 1) {
                    this.y += this.operandsRead[this.currentOp + 4];
                }
            }
            this.pt[4] = (float)this.x;
            this.pt[5] = (float)this.y;
            glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
            if (bl) {
                System.out.println(this.currentOp + "vh/hvCurveto " + this.operandsRead[this.currentOp] + ' ' + this.operandsRead[this.currentOp + 1] + ' ' + this.operandsRead[this.currentOp + 2] + ' ' + this.operandsRead[this.currentOp + 3] + ' ' + this.operandsRead[this.currentOp + 4] + ' ' + this.operandsRead[this.currentOp + 5]);
            }
            this.currentOp += 4;
            bl2 = !bl2;
        }
    }

    private void vvhhcurveto(GlyphFactory glyphFactory, boolean bl, int n) {
        boolean bl2;
        boolean bl3 = bl2 = n == 26;
        if ((this.operandReached & 1) == 1) {
            if (bl2) {
                this.x += this.operandsRead[0];
            } else {
                this.y += this.operandsRead[0];
            }
            ++this.currentOp;
        }
        while (this.currentOp < this.operandReached) {
            if (bl2) {
                this.y += this.operandsRead[this.currentOp];
            } else {
                this.x += this.operandsRead[this.currentOp];
            }
            this.pt[0] = (float)this.x;
            this.pt[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 1];
            this.y += this.operandsRead[this.currentOp + 2];
            this.pt[2] = (float)this.x;
            this.pt[3] = (float)this.y;
            if (bl2) {
                this.y += this.operandsRead[this.currentOp + 3];
            } else {
                this.x += this.operandsRead[this.currentOp + 3];
            }
            this.pt[4] = (float)this.x;
            this.pt[5] = (float)this.y;
            this.currentOp += 4;
            glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
            if (!bl) continue;
            System.out.println("vv/hhCurveto " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
    }

    private void rlinecurve(GlyphFactory glyphFactory, boolean bl) {
        for (int i = (this.operandReached - 6) / 2; i > 0; --i) {
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            glyphFactory.lineTo((float)this.x, (float)this.y);
            if (bl) {
                System.out.println("rlineCurve " + this.operandsRead[0] + ' ' + this.operandsRead[1]);
            }
            this.currentOp += 2;
        }
        float[] fArray = new float[6];
        this.x += this.operandsRead[this.currentOp];
        this.y += this.operandsRead[this.currentOp + 1];
        fArray[0] = (float)this.x;
        fArray[1] = (float)this.y;
        this.x += this.operandsRead[this.currentOp + 2];
        this.y += this.operandsRead[this.currentOp + 3];
        fArray[2] = (float)this.x;
        fArray[3] = (float)this.y;
        this.x += this.operandsRead[this.currentOp + 4];
        this.y += this.operandsRead[this.currentOp + 5];
        fArray[4] = (float)this.x;
        fArray[5] = (float)this.y;
        glyphFactory.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
        if (bl) {
            System.out.println("rlineCurve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
        this.currentOp += 6;
    }

    private void closepath(GlyphFactory glyphFactory, boolean bl) {
        if (this.xs != -1.0) {
            glyphFactory.lineTo((float)this.xs, (float)this.ys);
        }
        if (bl) {
            System.out.println("close to xs=" + this.xs + " ys=" + this.ys + ' ' + this.x + ',' + this.y);
        }
        this.xs = -1.0;
    }

    private void hsbw(GlyphFactory glyphFactory, String string, boolean bl) {
        this.x += this.operandsRead[0];
        glyphFactory.moveTo((float)this.x, 0.0f);
        if (bl) {
            System.out.println("hsbw " + this.x + " xs,ys=" + this.xs + ' ' + this.ys);
        }
        this.allowAll = true;
    }

    private void pop(boolean bl) {
        if (this.operandReached > 0) {
            --this.operandReached;
        }
        if (bl) {
            System.out.println("POP");
        }
        if (bl) {
            for (int i = 0; i < 6; ++i) {
                System.out.println(i + " == " + this.operandsRead[i] + ' ' + this.operandReached);
            }
        }
    }

    private void setcurrentpoint(boolean bl) {
        if (bl) {
            System.out.println("setCurrentPoint " + this.operandsRead[0] + ' ' + this.operandsRead[1]);
        }
    }

    private void div(boolean bl) {
        if (bl) {
            for (int i = 0; i < 6; ++i) {
                System.out.println(i + " " + this.currentOp + ' ' + this.operandsRead[i] + ' ' + this.operandReached);
            }
        }
        double d = this.operandsRead[this.operandReached - 2] / this.operandsRead[this.operandReached - 1];
        if (this.operandReached > 0) {
            --this.operandReached;
        }
        this.operandsRead[this.operandReached - 1] = d;
        if (bl) {
            for (int i = 0; i < 6; ++i) {
                System.out.println("after====" + i + " == " + this.operandsRead[i] + ' ' + this.operandReached);
            }
        }
        if (bl) {
            System.out.println("DIV");
        }
    }

    private void vmoveto(GlyphFactory glyphFactory, boolean bl, boolean bl2) {
        if (bl2 && this.operandReached == 2) {
            ++this.currentOp;
        }
        this.y += this.operandsRead[this.currentOp];
        glyphFactory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
        if (bl) {
            System.out.println("Set xs,ys= " + this.xs + ' ' + this.ys);
        }
        if (bl) {
            System.out.println("vmoveto " + this.operandsRead[0] + ' ' + this.operandsRead[1] + " currentOp" + this.currentOp + " y=" + this.y + ' ' + bl2);
        }
    }

    private void rlineto(GlyphFactory glyphFactory, boolean bl) {
        for (int i = this.operandReached / 2; i > 0; --i) {
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            glyphFactory.lineTo((float)this.x, (float)this.y);
            this.currentOp += 2;
            if (!bl) continue;
            System.out.println("x,y= (" + this.x + ' ' + this.y + ") rlineto " + this.operandsRead[0] + ' ' + this.operandsRead[1]);
        }
    }

    private void hvlineto(GlyphFactory glyphFactory, boolean bl, int n) {
        boolean bl2 = n == 6;
        for (int i = 0; i < this.operandReached; ++i) {
            if (bl2) {
                this.x += this.operandsRead[i];
            } else {
                this.y += this.operandsRead[i];
            }
            glyphFactory.lineTo((float)this.x, (float)this.y);
            if (bl) {
                System.out.println("h/vlineto " + this.operandsRead[0] + ' ' + this.operandsRead[1]);
            }
            bl2 = !bl2;
        }
    }

    private void rrcurveto(GlyphFactory glyphFactory, boolean bl) {
        int n = this.operandReached / 6;
        if (bl && n > 1) {
            System.out.println("**********currentOp=" + this.currentOp + " curves=" + n);
        }
        while (n > 0) {
            float[] fArray = new float[6];
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            fArray[0] = (float)this.x;
            fArray[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 2];
            this.y += this.operandsRead[this.currentOp + 3];
            fArray[2] = (float)this.x;
            fArray[3] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 4];
            this.y += this.operandsRead[this.currentOp + 5];
            fArray[4] = (float)this.x;
            fArray[5] = (float)this.y;
            glyphFactory.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
            if (bl) {
                System.out.println("rrcurveto " + this.operandsRead[this.currentOp] + ' ' + this.operandsRead[this.currentOp + 1] + ' ' + this.operandsRead[this.currentOp + 2] + ' ' + this.operandsRead[this.currentOp + 3] + ' ' + this.operandsRead[this.currentOp + 4] + ' ' + this.operandsRead[this.currentOp + 5]);
            }
            this.currentOp += 6;
            --n;
        }
    }

    private void endchar(GlyphFactory glyphFactory, int n) {
        StandardFonts.checkLoaded(1);
        float f = (float)(this.x + this.operandsRead[this.currentOp]);
        float f2 = (float)(this.y + this.operandsRead[this.currentOp + 1]);
        String string = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[this.currentOp + 2]);
        String string2 = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[this.currentOp + 3]);
        this.x = 0.0;
        this.y = 0.0;
        this.decodeGlyph(null, glyphFactory, string, n, "", 0.0f, true);
        glyphFactory.closePath();
        glyphFactory.moveTo(f, f2);
        this.x = f;
        this.y = f2;
        this.decodeGlyph(null, glyphFactory, string2, n, "", 0.0f, true);
        if (this.xs == -1.0) {
            this.xs = this.x;
            this.ys = this.y;
            System.out.println("ENDCHAR Set xs,ys= " + this.xs + ' ' + this.ys);
        }
    }

    private void rcurveline(GlyphFactory glyphFactory, boolean bl) {
        for (int i = (this.operandReached - 2) / 6; i > 0; --i) {
            float[] fArray = new float[6];
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            fArray[0] = (float)this.x;
            fArray[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 2];
            this.y += this.operandsRead[this.currentOp + 3];
            fArray[2] = (float)this.x;
            fArray[3] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 4];
            this.y += this.operandsRead[this.currentOp + 5];
            fArray[4] = (float)this.x;
            fArray[5] = (float)this.y;
            glyphFactory.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
            if (bl) {
                System.out.println("rCurveline " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
            }
            this.currentOp += 6;
        }
        this.x += this.operandsRead[this.currentOp];
        this.y += this.operandsRead[this.currentOp + 1];
        glyphFactory.lineTo((float)this.x, (float)this.y);
        this.currentOp += 2;
        if (bl) {
            System.out.println("rCurveline " + this.operandsRead[0] + ' ' + this.operandsRead[1]);
        }
    }

    private void seac(GlyphFactory glyphFactory, int n, int n2) {
        StandardFonts.checkLoaded(1);
        float f = (float)this.operandsRead[n2 + 1];
        float f2 = (float)this.operandsRead[n2 + 2];
        String string = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[n2 + 3]);
        String string2 = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[n2 + 4]);
        double d = this.x;
        this.y = 0.0;
        this.decodeGlyph(null, glyphFactory, string, n, "", 0.0f, true);
        glyphFactory.closePath();
        glyphFactory.moveTo(0.0f, 0.0f);
        this.x = (double)f + d;
        this.y = f2;
        this.decodeGlyph(null, glyphFactory, string2, n, "", 0.0f, true);
    }

    private void flex1(GlyphFactory glyphFactory, boolean bl) {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.x;
        double d4 = this.y;
        for (n2 = 0; n2 < 10; n2 += 2) {
            d += this.operandsRead[n2];
            d2 += this.operandsRead[n2 + 1];
        }
        n2 = Math.abs(d) > Math.abs(d2) ? 1 : 0;
        for (n = 0; n < 6; n += 2) {
            this.x += this.operandsRead[n];
            this.y += this.operandsRead[n + 1];
            this.pt[n] = (float)this.x;
            this.pt[n + 1] = (float)this.y;
        }
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (bl) {
            System.out.println("flex1 first curve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
        for (n = 0; n < 4; n += 2) {
            this.x += this.operandsRead[n + 6];
            this.y += this.operandsRead[n + 7];
            this.pt[n] = (float)this.x;
            this.pt[n + 1] = (float)this.y;
        }
        if (n2 != 0) {
            this.x += this.operandsRead[10];
            this.y = d4;
        } else {
            this.x = d3;
            this.y += this.operandsRead[10];
        }
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (bl) {
            System.out.println("flex1 second curve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
    }

    private void flex(GlyphFactory glyphFactory, boolean bl) {
        for (int i = 0; i < 12; i += 6) {
            for (int j = 0; j < 6; j += 2) {
                this.x += this.operandsRead[i + j];
                this.y += this.operandsRead[i + j + 1];
                this.pt[j] = (float)this.x;
                this.pt[j + 1] = (float)this.y;
            }
            glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
            if (!bl) continue;
            System.out.println("flex " + this.pt[0] + ' ' + this.pt[1] + ' ' + this.pt[2] + ' ' + this.pt[3] + ' ' + this.pt[4] + ' ' + this.pt[5]);
        }
    }

    private void hflex(GlyphFactory glyphFactory, boolean bl) {
        this.x += this.operandsRead[0];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[1];
        this.y += this.operandsRead[2];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[3];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (bl) {
            System.out.println("hflex first curve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
        this.x += this.operandsRead[4];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[5];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[6];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (bl) {
            System.out.println("hflex second curve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
    }

    private void hflex1(GlyphFactory glyphFactory, boolean bl) {
        this.x += this.operandsRead[0];
        this.y += this.operandsRead[1];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[2];
        this.y += this.operandsRead[3];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[4];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (bl) {
            System.out.println("36 first curve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
        this.x += this.operandsRead[5];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[6];
        this.y += this.operandsRead[7];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[8];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (bl) {
            System.out.println("36 second curve " + this.operandsRead[0] + ' ' + this.operandsRead[1] + ' ' + this.operandsRead[2] + ' ' + this.operandsRead[3] + ' ' + this.operandsRead[4] + ' ' + this.operandsRead[5]);
        }
    }

    public PdfGlyph getEmbeddedGlyph(GlyphFactory glyphFactory, String string, float[][] fArray, int n, String string2, float f, String string3) {
        PdfGlyph pdfGlyph;
        if (this.lastTrm[0][0] != fArray[0][0] | this.lastTrm[1][0] != fArray[1][0] | this.lastTrm[0][1] != fArray[0][1] | this.lastTrm[1][1] != fArray[1][1]) {
            this.lastTrm = fArray;
            this.flush();
        }
        if ((pdfGlyph = this.getEmbeddedCachedShape(n)) == null) {
            this.operandsRead = new double[this.max];
            this.operandReached = 0;
            this.x = -glyphFactory.getLSB();
            this.y = 0.0;
            this.decodeGlyph(string3, glyphFactory, string, n, string2, f, false);
            pdfGlyph = glyphFactory.getGlyph(false);
            if (pdfGlyph != null) {
                pdfGlyph.setID(n);
            }
            this.setEmbeddedCachedShape(n, pdfGlyph);
        }
        return pdfGlyph;
    }

    public final int getNumber(byte[] byArray, int n, double[] dArray, int n2, boolean bl) {
        double d = 0.0;
        int n3 = byArray[n] & 0xFF;
        if (n3 < 28 | n3 == 31) {
            System.err.println("!!!!Incorrect type1C operand");
        } else if (n3 == 28) {
            d = (byArray[n + 1] << 8) + (byArray[n + 2] & 0xFF);
            n += 3;
        } else if (n3 == 255) {
            if (this.is1C) {
                d = ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
                d += (double)(((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 4] & 0xFF)) / 65536.0;
                if (byArray[n + 1] < 0) {
                    d -= 65536.0;
                }
                if (bl) {
                    System.out.println("x=" + d);
                    for (int i = 0; i < 5; ++i) {
                        System.out.println(i + " " + byArray[n + i] + ' ' + (byArray[n + i] & 0xFF) + ' ' + (byArray[n + i] & 0x7F));
                    }
                }
            } else {
                d = ((byArray[n + 1] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 4] & 0xFF);
            }
            n += 5;
        } else if (n3 == 29) {
            d = ((byArray[n + 1] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 4] & 0xFF);
            n += 5;
        } else if (n3 == 30) {
            char[] cArray = new char[65];
            ++n;
            int n4 = 0;
            while (n4 < 64) {
                int n5 = byArray[n++] & 0xFF;
                int n6 = n5 >> 4 & 0xF;
                int n7 = n5 & 0xF;
                if (n6 == 15) break;
                cArray[n4++] = nybChars.charAt(n6);
                if (n4 == 64) break;
                if (n6 == 12) {
                    cArray[n4++] = 45;
                }
                if (n4 == 64 || n7 == 15) break;
                cArray[n4++] = nybChars.charAt(n7);
                if (n4 == 64) break;
                if (n7 != 12) continue;
                cArray[n4++] = 45;
            }
            d = Double.valueOf(new String(cArray, 0, n4));
        } else if (n3 < 247) {
            d = n3 - 139;
            ++n;
        } else if (n3 < 251) {
            d = (n3 - 247 << 8) + (byArray[n + 1] & 0xFF) + 108;
            n += 2;
        } else {
            d = -(n3 - 251 << 8) - (byArray[n + 1] & 0xFF) - 108;
            n += 2;
        }
        dArray[n2] = d;
        return n;
    }

    public final int getNumber(FontData fontData, int n, double[] dArray, int n2, boolean bl) {
        double d = 0.0;
        int n3 = fontData.getByte(n) & 0xFF;
        if (n3 < 28 | n3 == 31) {
            System.err.println("!!!!Incorrect type1C operand");
        } else if (n3 == 28) {
            d = (fontData.getByte(n + 1) << 8) + (fontData.getByte(n + 2) & 0xFF);
            n += 3;
        } else if (n3 == 255) {
            if (this.is1C) {
                int n4 = ((fontData.getByte(n + 1) & 0xFF) << 8) + (fontData.getByte(n + 2) & 0xFF);
                if (n4 > 32768) {
                    n4 = 65536 - n4;
                }
                double d2 = n4;
                double d3 = ((fontData.getByte(n + 3) & 0xFF) << 8) + (fontData.getByte(n + 4) & 0xFF);
                d = d2 + d3 / 65536.0;
                if (fontData.getByte(n + 1) < 0) {
                    if (bl) {
                        System.out.println("Negative " + d);
                    }
                    d = -d;
                }
                if (bl) {
                    System.out.println("x=" + d);
                    for (int i = 0; i < 5; ++i) {
                        System.out.println(i + " " + fontData.getByte(n + i) + ' ' + (fontData.getByte(n + i) & 0xFF) + ' ' + (fontData.getByte(n + i) & 0x7F));
                    }
                }
            } else {
                d = ((fontData.getByte(n + 1) & 0xFF) << 24) + ((fontData.getByte(n + 2) & 0xFF) << 16) + ((fontData.getByte(n + 3) & 0xFF) << 8) + (fontData.getByte(n + 4) & 0xFF);
            }
            n += 5;
        } else if (n3 == 29) {
            d = ((fontData.getByte(n + 1) & 0xFF) << 24) + ((fontData.getByte(n + 2) & 0xFF) << 16) + ((fontData.getByte(n + 3) & 0xFF) << 8) + (fontData.getByte(n + 4) & 0xFF);
            n += 5;
        } else if (n3 == 30) {
            char[] cArray = new char[65];
            ++n;
            int n5 = 0;
            while (n5 < 64) {
                int n6 = fontData.getByte(n++) & 0xFF;
                int n7 = n6 >> 4 & 0xF;
                int n8 = n6 & 0xF;
                if (n7 == 15) break;
                cArray[n5++] = nybChars.charAt(n7);
                if (n5 == 64) break;
                if (n7 == 12) {
                    cArray[n5++] = 45;
                }
                if (n5 == 64 || n8 == 15) break;
                cArray[n5++] = nybChars.charAt(n8);
                if (n5 == 64) break;
                if (n8 != 12) continue;
                cArray[n5++] = 45;
            }
            d = Double.valueOf(new String(cArray, 0, n5));
        } else if (n3 < 247) {
            d = n3 - 139;
            ++n;
        } else if (n3 < 251) {
            d = (n3 - 247 << 8) + (fontData.getByte(n + 1) & 0xFF) + 108;
            n += 2;
        } else {
            d = -(n3 - 251 << 8) - (fontData.getByte(n + 1) & 0xFF) - 108;
            n += 2;
        }
        dArray[n2] = d;
        return n;
    }

    protected void decodeGlyph(String string, GlyphFactory glyphFactory, String string2, int n, String string3, float f, boolean bl) {
        block96: {
            int n2;
            byte[] byArray;
            boolean bl2 = false;
            this.allowAll = false;
            if (this.isCID) {
                byArray = (byte[])this.charStrings.get(String.valueOf(n));
            } else {
                if (string2 == null) {
                    string2 = string3;
                }
                if (string2 == null && (string2 = string) == null) {
                    string2 = ".notdef";
                }
                if ((byArray = (byte[])this.charStrings.get(string2)) == null) {
                    if (string != null) {
                        byArray = (byte[])this.charStrings.get(string);
                    }
                    if (byArray == null) {
                        byArray = (byte[])this.charStrings.get(".notdef");
                    }
                }
            }
            if (byArray == null) break block96;
            boolean bl3 = true;
            this.ptCount = 0;
            int n3 = -1;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = byArray.length;
            int n8 = 0;
            this.currentOp = 0;
            this.hintCount = 0;
            double d = 999999.0;
            double d2 = 0.0;
            double d3 = 1000.0;
            boolean bl4 = false;
            this.pt = new float[6];
            int n9 = 0;
            this.h = 100000.0;
            if (this.is1C) {
                this.operandsRead = new double[this.max];
                this.operandReached = 0;
                this.allowAll = true;
            }
            if (bl2) {
                System.out.println("****************** " + string3 + ' ' + string2);
                for (n2 = 0; n2 < n7; ++n2) {
                    System.out.println(n2 + " " + (byArray[n2] & 0xFF));
                }
                System.out.println("=====xs=" + this.xs + " ys=" + this.ys);
            }
            while (n4 < n7) {
                block98: {
                    int n10;
                    boolean bl5;
                    block100: {
                        int n11;
                        block107: {
                            block109: {
                                byte[] byArray2;
                                block108: {
                                    block106: {
                                        block105: {
                                            block104: {
                                                block103: {
                                                    block102: {
                                                        block101: {
                                                            block99: {
                                                                block97: {
                                                                    int n12 = byArray[n4] & 0xFF;
                                                                    if (n12 > 31 || n12 == 28) {
                                                                        n5 = n4;
                                                                        n4 = this.getNumber(byArray, n4, this.operandsRead, this.operandReached, bl2);
                                                                        n8 = (int)this.operandsRead[this.operandReached];
                                                                        ++this.operandReached;
                                                                        if (n5 == 0) {
                                                                            if (this.nominalWidthX.length == 1) {
                                                                                n9 = this.nominalWidthX[0] + n8;
                                                                            } else {
                                                                                n2 = (Integer)this.glyphNumbers.get("" + n) - 1;
                                                                                if (n2 < this.fdSelect.length) {
                                                                                    n9 = this.nominalWidthX[this.fdSelect[n2]] + n8;
                                                                                }
                                                                            }
                                                                        }
                                                                        if (n12 != 28 || !bl2) continue;
                                                                        System.out.println("Shortint " + n8);
                                                                        continue;
                                                                    }
                                                                    ++n3;
                                                                    bl5 = false;
                                                                    n11 = n6;
                                                                    n6 = n12;
                                                                    ++n4;
                                                                    this.currentOp = 0;
                                                                    if (n6 != 12) break block97;
                                                                    n6 = byArray[n4] & 0xFF;
                                                                    ++n4;
                                                                    if (n6 == 7) {
                                                                        d3 = this.sbw(bl2);
                                                                        this.operandReached = 0;
                                                                    } else if (this.allowAll) {
                                                                        if (n6 == 16) {
                                                                            bl4 = this.processFlex(glyphFactory, bl2, n11, bl4, n8);
                                                                            this.operandReached = 0;
                                                                        } else if (n6 == 33) {
                                                                            this.setcurrentpoint(bl2);
                                                                            this.operandReached = 0;
                                                                        } else if (n6 == 34) {
                                                                            this.hflex(glyphFactory, bl2);
                                                                            this.operandReached = 0;
                                                                        } else if (n6 == 35) {
                                                                            this.flex(glyphFactory, bl2);
                                                                            this.operandReached = 0;
                                                                        } else if (n6 == 36) {
                                                                            this.hflex1(glyphFactory, bl2);
                                                                            this.operandReached = 0;
                                                                        } else if (n6 == 37) {
                                                                            this.flex1(glyphFactory, bl2);
                                                                            this.operandReached = 0;
                                                                        } else if (n6 == 6) {
                                                                            this.seac(glyphFactory, n, this.currentOp);
                                                                            this.operandReached = 0;
                                                                        } else if (n6 == 12) {
                                                                            this.div(bl2);
                                                                        } else if (n6 == 17) {
                                                                            this.pop(bl2);
                                                                        } else if (n6 == 0) {
                                                                            this.operandReached = 0;
                                                                            if (bl2) {
                                                                                System.out.println("Dot section");
                                                                            }
                                                                        } else if (bl2) {
                                                                            this.operandReached = 0;
                                                                            System.out.println("1 Not implemented " + n4 + " id=" + n6 + " op=" + Type1.T1C[n6]);
                                                                        } else {
                                                                            this.operandReached = 0;
                                                                        }
                                                                    }
                                                                    break block98;
                                                                }
                                                                if (n6 != 13) break block99;
                                                                this.hsbw(glyphFactory, string2, bl2);
                                                                this.operandReached = 0;
                                                                break block98;
                                                            }
                                                            if (!this.allowAll) break block98;
                                                            if (n6 == 0) break block100;
                                                            if (!(n6 == 1 | n6 == 3 | n6 == 18 | n6 == 23)) break block101;
                                                            this.hintCount += this.operandReached / 2;
                                                            this.operandReached = 0;
                                                            if (bl2) {
                                                                System.out.println("One of hstem vstem hstemhm vstemhm " + n6 + ' ' + this.xs + ' ' + this.ys);
                                                            }
                                                            break block100;
                                                        }
                                                        if (n6 != 4) break block102;
                                                        if (bl4) {
                                                            double d4 = this.operandsRead[this.currentOp];
                                                            this.y += d4;
                                                            this.pt[this.ptCount] = (float)this.x;
                                                            ++this.ptCount;
                                                            this.pt[this.ptCount] = (float)this.y;
                                                            ++this.ptCount;
                                                            if (bl2) {
                                                                System.out.println("flex value " + this.x + ' ' + this.y);
                                                            }
                                                        } else {
                                                            this.vmoveto(glyphFactory, bl2, bl3);
                                                        }
                                                        this.operandReached = 0;
                                                        break block100;
                                                    }
                                                    if (n6 != 5) break block103;
                                                    this.rlineto(glyphFactory, bl2);
                                                    this.operandReached = 0;
                                                    break block100;
                                                }
                                                if (!(n6 == 6 | n6 == 7)) break block104;
                                                this.hvlineto(glyphFactory, bl2, n6);
                                                this.operandReached = 0;
                                                break block100;
                                            }
                                            if (n6 != 8) break block105;
                                            this.rrcurveto(glyphFactory, bl2);
                                            this.operandReached = 0;
                                            break block100;
                                        }
                                        if (n6 != 9) break block106;
                                        this.closepath(glyphFactory, bl2);
                                        this.operandReached = 0;
                                        break block100;
                                    }
                                    if (n6 != 10 && n6 != 29) break block107;
                                    if (bl2) {
                                        System.out.println(n6 + " -------------- last Value=" + n8 + ' ' + this.allowAll + " commandCount=" + n3 + " operandReached=" + this.operandReached + ' ' + bl3);
                                    }
                                    if (this.is1C || n6 != 10 || n8 < 0 || n8 > 2 || n11 == 11 || this.operandReached <= 5) break block108;
                                    bl4 = this.processFlex(glyphFactory, bl2, n11, bl4, n8);
                                    this.operandReached = 0;
                                    break block100;
                                }
                                n8 = n6 == 10 ? (n8 += this.localBias) : (n8 += this.globalBias);
                                if (n6 == 10) {
                                    byArray2 = (byte[])this.charStrings.get("subrs" + n8);
                                    if (bl2) {
                                        System.out.println("=================callsubr " + n8);
                                    }
                                } else {
                                    if (bl2) {
                                        System.out.println("=================callgsubr " + n8);
                                    }
                                    byArray2 = (byte[])this.charStrings.get("global" + n8);
                                }
                                if (byArray2 == null) break block109;
                                if (bl2) {
                                    System.out.println("Subroutine=============" + n8 + " op=" + this.currentOp + ' ' + this.operandReached);
                                }
                                int n13 = byArray2.length;
                                n10 = byArray.length;
                                int n14 = n13 + n10 - 2;
                                n7 = n7 + n13 - 2;
                                byte[] byArray3 = new byte[n14];
                                System.arraycopy(byArray, 0, byArray3, 0, n5);
                                System.arraycopy(byArray2, 0, byArray3, n5, n13);
                                System.arraycopy(byArray, n4, byArray3, n5 + n13, n10 - n4);
                                byArray = byArray3;
                                n4 = n5;
                                if (this.operandReached > 0) {
                                    --this.operandReached;
                                }
                                break block100;
                            }
                            if (!bl2) break block100;
                            System.out.println("No data found for sub-routine " + this.charStrings);
                            break block100;
                        }
                        if (n6 == 11) {
                            if (bl2) {
                                System.out.println("return=============" + n4);
                            }
                        } else if (n6 == 14) {
                            this.endchar(glyphFactory, n, bl2, n7);
                            this.operandReached = 0;
                            n4 = n7 + 1;
                        } else if (n6 == 16) {
                            if (bl2) {
                                System.out.println("Blend");
                            }
                            this.operandReached = 0;
                        } else if (n6 == 19 | n6 == 20) {
                            n4 = this.mask(bl2, n4, n11);
                            this.operandReached = 0;
                        } else if (n6 == 21) {
                            if (bl4) {
                                if (bl2) {
                                    System.out.println(this.currentOp + " " + this.ptCount + ' ' + this.pt.length);
                                }
                                double d5 = this.operandsRead[this.currentOp + 1];
                                this.y += d5;
                                d5 = this.operandsRead[this.currentOp];
                                this.x += d5;
                                this.pt[this.ptCount] = (float)this.x;
                                ++this.ptCount;
                                this.pt[this.ptCount] = (float)this.y;
                                ++this.ptCount;
                                if (bl2) {
                                    System.out.println("flex value " + this.pt[this.ptCount - 2] + ' ' + this.pt[this.ptCount - 1] + " count=" + this.ptCount);
                                }
                            } else {
                                this.rmoveto(glyphFactory, bl2, bl3);
                            }
                            this.operandReached = 0;
                        } else if (n6 == 22) {
                            if (bl4) {
                                double d6 = this.operandsRead[this.currentOp];
                                this.x += d6;
                                this.pt[this.ptCount] = (float)this.x;
                                ++this.ptCount;
                                this.pt[this.ptCount] = (float)this.y;
                                ++this.ptCount;
                                if (bl2) {
                                    System.out.println("flex value " + this.x + ' ' + this.y);
                                }
                            } else {
                                this.hmoveto(glyphFactory, bl2, bl3);
                            }
                            this.operandReached = 0;
                        } else if (n6 == 24) {
                            this.rcurveline(glyphFactory, bl2);
                            this.operandReached = 0;
                        } else if (n6 == 25) {
                            this.rlinecurve(glyphFactory, bl2);
                            this.operandReached = 0;
                        } else if (n6 == 26 | n6 == 27) {
                            this.vvhhcurveto(glyphFactory, bl2, n6);
                            this.operandReached = 0;
                        } else if (n6 == 30 | n6 == 31) {
                            this.vhhvcurveto(glyphFactory, bl2, n6);
                            this.operandReached = 0;
                        } else if (bl2) {
                            this.operandReached = 0;
                            System.out.println("Unsupported command " + n4 + ">>>>>" + this.hintCount + ">>>>>>key=" + n6 + ' ' + Type1.T1CcharCodes1Byte[n6] + " <1<<" + this.operandsRead);
                            for (n2 = 0; n2 < n7; ++n2) {
                                System.out.println(n2 + " " + (byArray[n2] & 0xFF));
                            }
                        }
                    }
                    if (bl2 && !bl5) {
                        BufferedImage bufferedImage = new BufferedImage(1000, 1000, 2);
                        Graphics2D graphics2D = bufferedImage.createGraphics();
                        graphics2D.setColor(Color.red);
                        for (n10 = 0; n10 < 7; ++n10) {
                            graphics2D.drawLine(n10 * 100, 0, n10 * 100, 1000);
                            graphics2D.drawLine(0, n10 * 100, 1000, n10 * 100);
                        }
                        graphics2D.setColor(Color.black);
                        PdfGlyph pdfGlyph = glyphFactory.getGlyph(true);
                        if (pdfGlyph.getShape() != null) {
                            pdfGlyph.render(1, graphics2D, 1.0f, false);
                            ShowGUIMessage.showGUIMessage(n4 + " x " + " x,y=" + this.x + ' ' + this.y, bufferedImage, n4 + " x ");
                        }
                    }
                }
                if (d > this.y) {
                    d = this.y;
                }
                if (d2 < this.y) {
                    d2 = this.y;
                }
                if (n6 == 19 || n6 == 29 || n6 == 10) continue;
                bl3 = false;
            }
            if (d3 > this.h) {
                d = d3 - this.h;
            }
            if (d2 < d3) {
                d = 0.0;
            } else if (d3 != d2) {
                float f2 = (float)(d2 - (d3 - d));
                d = f2 < 0.0f ? (d3 - d2 <= (double)f2 ? (double)f2 : (d -= (double)f2)) : 0.0;
                if (d < 0.0) {
                    d = 0.0;
                }
            }
            glyphFactory.setYMin((float)d, (float)d2);
            if (bl2 & !bl) {
                BufferedImage bufferedImage = new BufferedImage(600, 600, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(Color.red);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.scale(0.25, 0.25);
                graphics2D.transform(affineTransform);
                PdfGlyph pdfGlyph = glyphFactory.getGlyph(true);
                graphics2D.setColor(Color.green);
                for (int i = 0; i < 7; ++i) {
                    graphics2D.drawLine(0, i * 50, 1000, i * 50);
                }
                pdfGlyph.render(1, graphics2D, 1.0f, false);
            }
        }
    }

    public void setCharString(String string, byte[] byArray, int n) {
        this.charStrings.put(string, byArray);
        this.glyphNumbers.put(string, n);
    }

    public void setIndexForCharString(int n, String string) {
        if (this.charForGlyphIndex == null) {
            this.charForGlyphIndex = new String[65536];
        }
        if (n < this.charForGlyphIndex.length) {
            this.charForGlyphIndex[n] = string;
        }
    }

    public String getIndexForCharString(int n) {
        return this.charForGlyphIndex[n];
    }

    public boolean is1C() {
        return this.is1C;
    }

    public void setWidthValues(int[] nArray, int[] nArray2) {
        this.nominalWidthX = nArray2;
        this.defaultWidthX = nArray;
    }

    public void setis1C(boolean bl) {
        this.is1C = bl;
    }

    public void setRenderer(DynamicVectorRenderer dynamicVectorRenderer) {
        this.dynamicVectorRenderer = dynamicVectorRenderer;
    }

    public void setFDSelect(int[] nArray) {
        this.fdSelect = nArray;
    }

    public Map getCharStrings() {
        return this.charStrings;
    }
}

