
CocoaLumberjack Documentation 
=============================

## Beginner

* [Getting Started](GettingStarted.md): Get up and running using the Lumberjack Framework.

* [ARC](ARC.md): Supporting ARC files in a non-ARC project.

* [Xcode Tricks](XcodeTricks.md): Using different log levels for Debug and Release builds.

* [Per Logger Log Levels](PerLoggerLogLevels.md): Using different log levels for each logger.

* [Xcode Colors](XcodeColors.md): Use colors in the Xcode debugging console.

* [Custom Formatters](CustomFormatters.md): How to write your own custom formatters.

* [FAQ](FAQ.md): Frequently asked questions.

* [Performance](Performance.md): Analysis of performance with benchmarks.

* [Problem Solution](ProblemSolution.md): Common issues you may encounter and their solutions.

* [AppCode Support](AppCode-support.md) How to use CocoaLumberjack in AppCode.

## Intermediate

* [Architecture](Architecture.md): Lumberjack internals & overview.

* [Custom Context](CustomContext.md): Taking advantage of logging contexts.

* [Custom Loggers](CustomLoggers.md): How to write your own custom loggers.

* [Custom Log Levels](CustomLogLevels.md): How to add or customize log levels.

* [Per User Log Levels](PerUserLogLevels.md): Different log levels per developer.

## Advanced

* [Dynamic Log Levels](DynamicLogLevels.md): Dynamically changing log levels during run-time.

* [Fine Grained Logging](FineGrainedLogging.md): When you need something more advanced than simple log levels.

* [Log File Management](LogFileManagement.md): Compress your log files, or upload them to a server.

