// Code generated by vfsgen; DO NOT EDIT.

package install

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"os"
	pathpkg "path"
	"time"
)

// templates statically implements the virtual filesystem provided to vfsgen.
var templates = func() http.FileSystem {
	fs := vfsgen۰FS{
		"/": &vfsgen۰DirInfo{
			name:    "/",
			modTime: time.Date(1970, 1, 1, 0, 0, 0, 0, time.UTC),
		},
		"/flux-account.yaml.tmpl": &vfsgen۰CompressedFileInfo{
			name:             "flux-account.yaml.tmpl",
			modTime:          time.Date(1970, 1, 1, 0, 0, 0, 0, time.UTC),
			uncompressedSize: 836,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x92\x4b\xaf\xd3\x30\x10\x85\xf7\xfe\x15\x47\xba\x8b\x0b\xe8\x26\xa8\x3b\x94\x5d\xdb\x05\x0b\x10\x8b\xf0\xd8\x20\x16\x63\x7b\x42\x4d\x5d\x3b\xf2\x23\x3c\xa2\xfc\x77\x94\xa4\x95\x9a\xb6\x20\x55\xba\x3b\x7b\x7c\xc6\x73\xe6\xe8\x2b\x8a\x42\x3c\xe0\xd3\x8e\x11\x39\x74\x46\x31\x48\x29\x9f\x5d\x7a\x82\xb2\x39\x26\x0e\x08\xde\x72\x7c\x02\x39\xbd\x28\x41\x1a\xa7\x8d\xfb\x0e\x0a\x2c\x1e\xe0\x9d\xfd\x0d\xc7\xac\x59\xa3\xf1\x01\xef\xb2\xe4\xe0\x38\x71\xc4\x4f\x93\x76\x53\x4b\x21\x29\xb2\x1e\x27\x70\x8c\x50\xde\xa5\xe0\x2d\x5e\xd4\x9b\xf5\xf6\x65\x29\xa8\x35\x5f\x38\x44\xe3\x5d\x85\x6e\x25\xf6\xc6\xe9\x0a\x1f\x67\x57\xeb\xd9\x94\x38\x70\x22\x4d\x89\x2a\x01\x58\x92\x6c\xe3\x78\x02\x1c\x1d\xb8\x42\x63\xf3\x2f\x71\x7e\xe9\x7b\x98\x06\xe5\x07\x3a\x70\x6c\x49\x31\x86\xe1\xf8\x3e\x5d\x2b\xf4\xfd\xf2\xb5\xef\xc1\x4e\x0f\x83\x18\x73\x39\x37\x14\x24\xa9\x92\x72\xda\xf9\x60\xfe\x50\x32\xde\x95\xfb\x37\xb1\x34\xfe\x75\xb7\x92\x9c\xe8\xe4\x77\x3b\x27\x54\x7b\xcb\xf7\x9a\x15\x21\x5b\x9e\x24\x05\xa8\x35\x6f\x83\xcf\x6d\xac\xf0\xf5\xf1\xd5\xe3\xb7\xa9\x2f\x70\xf4\x39\x28\x5e\x14\x3b\x0e\xf2\xac\x50\xc0\x79\x57\x1f\x85\x9f\xeb\xf7\xff\xd6\x3e\xc3\x86\x9b\x99\x80\xfb\x17\xf5\x96\x6b\x6e\x46\xd1\x69\xd1\xff\xcc\x17\xc0\x75\xb6\x8b\xff\x62\x96\x3f\x58\xa5\x63\x76\x37\xc1\xb9\xb2\x73\x89\xc1\x25\x27\xb7\xc8\xb0\x71\x3c\x69\x6e\x28\xdb\x34\xa3\x32\x12\xf5\x37\x00\x00\xff\xff\xfd\x7f\x67\x6a\x44\x03\x00\x00"),
		},
		"/flux-deployment.yaml.tmpl": &vfsgen۰CompressedFileInfo{
			name:             "flux-deployment.yaml.tmpl",
			modTime:          time.Date(1970, 1, 1, 0, 0, 0, 0, time.UTC),
			uncompressedSize: 7270,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xd4\x59\x5d\x6f\x1b\xb7\xd2\xbe\xf7\xaf\x18\x28\x2f\x90\x18\x90\x56\x76\xdd\x16\xc5\xf6\x55\x71\xd2\x7c\xb8\x39\x69\x52\xc3\x4e\xce\x41\xaf\x6a\x8a\x3b\xd2\x12\xe2\x92\x7b\x38\x5c\xa9\x82\xd0\xff\x7e\x30\xe4\x7e\x70\x65\xd9\x29\x72\x77\x72\x11\xdb\xbb\xc3\xe1\xcc\x33\x5f\x0f\xb9\xb3\xd9\xec\x4c\xd4\xea\x5f\xe8\x48\x59\x93\x83\xa8\x6b\x9a\x6f\x2f\xcf\x36\xca\x14\x39\xbc\xc6\x5a\xdb\x7d\x85\xc6\x9f\x55\xe8\x45\x21\xbc\xc8\xcf\x00\x8c\xa8\x30\x87\x95\x6e\xfe\x3c\x1c\x40\xad\x20\xfb\x28\x2a\xa4\x5a\x48\x84\xbf\xfe\x6a\xdf\x87\x3f\x73\x38\x1c\xc6\x6f\x0f\x07\x40\x53\xb0\x18\xd5\x28\x59\x99\xc3\x5a\x2b\x29\x28\x87\xcb\x33\x00\x42\x8d\xd2\x5b\xc7\x6f\x00\x2a\xe1\x65\xf9\xab\x58\xa2\xa6\xf8\x20\xdd\x9b\xa5\xbd\x13\x1e\xd7\xfb\xf8\xd2\xef\x6b\xcc\xe1\x16\xa5\x43\xe1\xf1\x0c\xc0\x63\x55\x6b\xe1\xb1\x55\x96\x78\xc0\xff\x84\x31\xd6\x0b\xaf\xac\xe9\x95\x03\xd4\xce\x56\xe8\x4b\x6c\x28\x53\x76\x5e\x5b\xe7\x73\x98\x5c\x5d\x5c\x5d\x4e\xe0\x19\x78\xd4\x3a\x91\x00\x6f\x81\xa4\x13\x35\xc2\xbc\x42\xef\x94\x24\x76\xae\xb6\xca\xf8\xe7\x04\xbc\x38\x6b\x15\xeb\x91\x0f\x47\x5e\x00\x74\x58\x84\x57\xb6\xc0\xbb\x11\x0a\xfc\x6f\x89\x5e\x64\x9b\x66\x89\xce\xa0\xc7\x60\x9c\xa5\x1c\xb4\x32\xad\x0a\x86\xce\x6d\x95\xc4\x97\x52\xda\xc6\xf8\x8f\xe3\x1d\x00\xb6\x56\x37\x15\xf6\x36\xcc\x5a\x1b\xd6\xca\xcf\x36\xb8\xef\x37\x22\x86\xcf\x0f\x1b\x77\x4f\x06\x7d\x33\x5e\x52\x84\xcc\x48\xa4\x0a\x5c\x89\x46\xfb\x0f\xb6\xc0\x1c\x2e\xbe\xbd\xb8\x80\x67\xb0\x2b\xd1\x40\xc5\xd6\x60\x01\x0e\x45\x31\xb3\x46\xef\xa7\xb0\x43\xd8\x59\xf3\xdc\xc3\x12\x41\x2c\x35\x32\x90\xb2\xac\x6c\x71\xd6\x2a\x7c\x06\x9f\x4a\x45\xa0\x08\x04\xf8\xaa\x5e\x11\x34\x84\x05\xac\xac\x83\x35\x1a\x74\xc2\x2b\xb3\x86\xbb\xbb\x5f\x60\x83\x7b\xca\xe0\x9d\x81\xf7\x3f\x10\xfc\xb4\x80\xcb\xec\xf2\x62\xda\x6b\xe9\xf6\x8e\x2e\x10\x08\x87\xa9\x1d\x64\xd9\x14\x83\x58\x80\x00\xc2\x5a\x70\x36\xb5\x40\xc1\x0e\x7b\x35\x52\x18\xd8\x39\xe5\xd9\xd0\xec\x34\x7e\x6b\x34\x3d\x18\x58\xd5\x7e\xff\x5a\xb9\x14\xc4\x0a\x0b\xd5\x54\x39\x7c\xc0\xca\xba\x7d\xea\x27\xc2\xca\x6a\x6d\x77\xec\x51\xbb\xb5\xa2\xe0\x6a\x43\xfc\x4c\x80\x6c\xc8\xdb\x4a\x31\x02\x1b\x63\x77\xe6\x8f\xd2\x92\xa7\x5e\xc5\x4a\x69\x9c\xc2\xae\x54\xb2\x84\xbd\x6d\x60\xa7\xb4\x8e\x4e\x79\x0b\x85\xe5\x02\xe5\xc7\xbc\x88\x7f\x71\x60\x77\x86\xcd\xee\x15\x38\xac\x2d\x38\xe1\x4b\x74\xe0\x4b\x61\xda\x8d\xd7\xca\x97\xcd\x12\x2c\x3f\x44\xd0\x6a\x83\x19\xfc\x6e\x9b\xe7\x5a\x83\xd0\x64\xbb\x2d\xc6\x60\x83\xf2\xa0\x8c\xb7\x61\x8d\xb4\xc6\x0b\x65\xd0\x4d\x61\x89\xda\xee\x32\xb8\xc3\x01\xd5\xd2\xfb\x9a\xf2\xf9\xbc\xb0\x92\x32\x4e\x2c\x59\x70\x5a\xa3\x99\x73\xcd\x92\x9f\xaf\x1b\x55\x20\xcd\x1b\xc2\x59\xed\xd4\x56\x78\x0c\xa9\xc7\x8e\x64\xa5\xaf\x74\xaf\xa9\x8b\x05\x51\x39\x93\xd6\xac\xd4\xba\x7f\x05\x10\x1f\x7c\x10\x75\x9e\x3c\x4c\x2b\x70\x96\x2c\xfb\xda\xb8\x84\xd2\x9c\x47\x25\x43\xfa\x7d\x31\x26\x3b\x45\x25\x3f\x29\xc5\x16\x41\x40\xa1\x56\x2b\x74\xdc\x6d\x3b\x0d\x6d\x55\x0d\x1d\x35\x84\x20\xaa\x4b\x83\xc0\x5d\x69\xab\x0a\xec\x60\x5f\xa9\x75\x25\xea\xc1\x10\xe5\x4b\x10\x06\xd0\x78\xb7\x0f\x3e\xdc\x47\xa1\xfb\x29\x08\x53\x40\x63\xa4\xad\xb8\xcd\x87\xf5\xd1\xdb\x0f\x21\x9c\xc2\x14\xbd\x16\x34\xdb\xa0\x41\x21\xb5\xf1\x7c\x10\x01\x86\xe1\x2b\x22\x90\x2c\xfb\x62\x04\x42\x27\xf0\x16\x54\xc5\x0d\x16\xae\x6f\xae\x43\x13\x80\x17\xec\x16\xa9\xb5\x51\x66\xd8\x9c\x9d\xdb\xa2\x53\x2b\x25\x43\xa7\x87\xba\x71\xb5\x25\xa4\xf3\xbf\x01\x64\xaf\x25\xb6\x8f\x88\x22\x03\xc4\xfb\xfd\x0d\xe0\x40\xb8\xf5\x50\xa6\x8f\x20\xb6\xae\xd7\xdc\x3f\x28\x81\x66\xdc\x82\x9f\x3d\xd2\x84\x1f\xae\x3b\xd1\x84\x3b\x38\xfb\x4a\x7c\xd0\xff\x93\x09\xd1\xa2\xee\x30\xf4\x49\x63\x61\x92\xc7\x4a\x9c\x80\xaa\xc4\x1a\x63\xf6\xf3\x82\x0c\xde\x2a\x53\x04\x9f\x2b\x6e\x2b\x0e\xe5\x90\xb5\xb1\xa5\x68\x14\x84\xdc\x3c\xc2\x52\x0e\x02\x13\x0c\x10\xbe\xaf\xfb\xb2\x59\x66\x85\x95\x1b\x74\x99\xb4\xd5\xdc\xcd\x63\x0f\x08\x3f\xe6\x5e\xf4\xd0\x75\x71\x64\xa2\xc0\x24\x82\x77\xf5\x62\x0d\x6c\x69\xd6\xcb\x84\x6d\x72\x68\x15\x2a\x9b\x6a\xcb\x2f\xb3\xcb\x1f\xb2\x8b\xb1\xec\x4d\xa3\xf5\x8d\xd5\x4a\xee\x73\x78\xb7\xfa\x68\xfd\x8d\x43\x4a\xbd\x70\x48\xb6\x71\x12\x29\xed\xe3\x0e\xff\xd3\x20\xf9\xd1\x33\x00\x59\x37\x39\x7c\x77\x51\x8d\x1e\x56\xa1\xd5\xe7\xf0\xfd\xb7\x1f\xd4\xc0\x2f\xac\x4b\x17\xcf\x86\xc8\xdc\x04\xae\x71\x75\x71\xc5\x93\x53\x99\x95\x75\x55\x48\x59\xa1\x7b\x69\xad\xb6\x68\x90\xe8\xc6\xd9\x25\xa6\x16\x30\xa4\xd7\xe3\xa9\x1d\xb7\x8a\x0a\xc7\x8f\x85\x2f\x73\x98\x8b\x5a\x45\xa4\xb7\xdf\xcf\x55\x81\xc6\x2b\xbf\xcf\xea\x66\x99\xc8\x2a\xa3\xbc\x12\xfa\x35\x6a\xb1\xbf\xe3\xfa\x2c\x28\x87\xef\x12\x01\xaf\x2a\xb4\x8d\x3f\xf1\x8e\x87\xac\xfa\xdf\x30\x35\x29\xda\x51\x60\x4e\xd3\x23\x88\x63\xee\x26\x5a\x86\x5e\x06\xcb\x8a\x39\x51\xc9\x04\xd1\x46\xca\x0a\xda\xb6\xfd\x66\xcd\x21\x03\x65\x62\xce\x3d\xa7\xb8\x86\xa8\x9c\x8f\xda\x64\x87\xd9\x6f\x46\xef\x73\xf0\xae\x41\xd6\xc6\x1c\x28\x74\xa8\x65\xdb\xd8\xb9\xa4\x6a\x74\x2b\xeb\x24\xb2\xd2\x48\x7a\x98\xf3\x3c\x66\x78\xca\x4b\xc6\xb6\x6f\x85\x6b\x6d\x8f\x62\x5f\x67\x7e\x52\xa3\xef\x8c\xd4\x4d\xe8\x9c\x4c\xdd\xe2\x80\xeb\xba\x6a\xe4\x06\x5f\xa0\x32\x1d\x99\xf9\x91\x97\x1e\xd1\x8c\xbe\xbb\x42\x81\x52\x0b\xc7\x94\x6d\x69\xb7\x49\x03\x78\x82\x06\xc4\xf6\x98\x3a\xef\xac\xf5\xf3\x8c\xa8\x7c\xd4\x01\x61\x46\xbb\x4e\x86\x11\x35\x89\x3b\x4f\x3b\x91\x44\x03\x9a\xad\x72\xd6\x84\x81\x10\x67\xed\xe4\xfd\xe7\x9f\xdf\xbc\xfa\xed\xe3\xdb\x77\xd7\x93\x38\x02\xa6\x8c\x87\xdd\xa2\x73\xe3\x79\x9d\xa8\x09\x23\x6e\xb9\x8f\xd3\xd4\xeb\x53\x3e\x3e\x18\xb4\x0f\x7d\x1c\x92\x93\x85\x1f\x75\x94\x67\x1e\x9f\x58\xba\xdd\xb8\x45\x27\x54\xa4\xb5\x2e\xc4\x24\x51\x71\x4c\x68\xd2\xa0\x07\x36\xd3\x51\x6f\x61\x40\x68\x8f\xce\x30\xb5\x7e\x60\xf1\xca\xd9\x8a\xd3\xa2\x63\x2c\x53\x10\xc4\xe9\xd6\x4e\x55\x86\x41\x5b\xb9\xa1\x87\xc1\x46\xb3\xcd\x4f\xe0\x32\xc0\x3d\xc2\x65\x2b\x74\x83\x0f\x30\xf9\x52\x12\x1f\xe7\x40\x37\x73\x9f\xc8\x00\x1e\xf9\xe3\x51\xff\xc4\xb0\x7f\x24\x2f\x59\x2a\xb2\x9b\x91\xdc\xb8\x3f\x7c\xa9\xf2\x76\x82\x49\x89\x05\x6a\xea\x5a\xef\xe1\x97\x4f\x9f\x6e\x60\x29\x48\x49\x10\x8d\x2f\x41\x3a\x0c\x9d\x54\xe8\x38\xd5\x87\xf3\x00\x2b\xdc\x2a\x11\x1c\xbf\xbf\x7e\xf7\xe9\x8f\x97\x9f\x3f\xfd\xf2\xf9\xee\xcd\xed\x7d\x70\xb7\x7f\xf4\xfe\xcd\xef\xf7\xa3\x84\xdf\x0a\xa7\xf8\x34\x47\x1d\x41\x4e\x14\x46\xfa\x72\x14\xbf\xb7\xce\x56\xe3\x18\x46\xb1\x5b\x5c\xe5\x23\xcf\x47\x5c\x91\x1b\x1b\xbb\x30\x00\xc0\x98\xe7\x23\x3c\x22\x04\xf1\x8c\x8a\x05\x4f\x62\x29\x64\x89\x05\xa7\x56\x9a\xdb\x3d\xad\x66\xa4\x58\xfb\x34\xd1\x62\x5d\xcb\x9b\x93\x05\xed\x19\x3b\x2c\x9c\x86\x4d\xf8\x6c\xd8\x62\xec\x4b\xa4\x34\x17\x06\xf6\xea\x77\x96\xad\x6c\x18\xa7\x50\x71\xe1\x26\x21\x24\x22\x94\x76\x17\xce\xbf\xd6\x18\x94\x21\x64\xca\x8f\x73\x67\x36\xeb\x1d\x08\x87\x1f\xde\x7c\xd1\x3f\xca\x5a\xd2\x97\xd1\x56\x66\x52\x37\xe4\xd1\x65\xdc\xc0\x75\x0a\xc9\x67\x8a\xbd\x66\x80\xe2\x55\x14\x7d\x77\x33\x72\x8a\xdb\x0e\xa1\x0f\xe7\xeb\x71\x66\x0f\x36\x74\xf2\x9c\x5d\xde\xb1\x64\x38\xf1\x26\x23\x28\xb5\xb8\x95\x5e\x9c\x8d\x58\xa6\x22\xa8\x1a\x0a\x37\x00\x01\x3d\x85\x45\x2c\xa7\x65\x18\x6c\x81\xe3\x85\x83\xff\x8b\xee\x34\x7d\x9e\xda\xd2\x35\x97\x58\x86\x9c\xc0\xc9\xf9\x7f\x64\x08\x0f\x83\x38\xe0\x66\x85\x72\x8b\x07\x63\x2f\x35\xeb\x36\x61\x98\x43\xf0\x3e\xdf\xfe\x1a\x2f\x28\x84\x59\xc7\x77\xd7\xca\x87\x43\x33\x29\x6f\xdd\xbe\x6f\xd7\x6f\x99\x19\x27\xea\x9e\xaa\x39\x4e\x9b\xc4\xf7\xb6\x64\x4e\x96\x53\x5a\x0b\x1d\x77\xfe\xbf\x17\x69\x65\x9e\xe7\xc3\xdf\xef\xdf\xfc\x7e\xfe\x8f\x78\x74\x0f\xb4\xba\x21\x74\xf3\xc1\xd8\x2c\x2d\x74\xc6\x87\xcb\xa9\x71\x7a\x71\x38\x40\x76\xad\x3c\x3b\x1b\xee\xf0\xc6\x12\x4b\x27\x8c\x2c\x3b\xa1\x9f\xc3\x5f\xf1\x36\x4f\xad\xc2\x23\xee\x5f\x74\x6a\x25\x73\x38\x5e\x77\x17\x32\x85\xfe\x69\x95\x49\x16\x4c\xa6\x93\xf6\x52\x50\x13\xa6\xcb\x9f\x6e\x6a\x0e\x39\xf1\x64\x3c\x75\x55\xc2\xa8\x15\x73\x72\xae\x21\x52\x05\xba\x18\x8e\xa3\x93\x4d\xb8\x93\xb0\x84\xd0\x98\x02\xdd\x51\x8c\x1d\x6a\xe1\xd5\x16\x03\xe5\xa4\x2e\x03\xd7\xa3\x38\x1f\xd5\x64\xef\x1c\x35\xcb\x42\xb9\xcb\x69\xfc\xf9\x4d\x7f\xc3\x39\x80\x13\x6e\x30\x4f\x81\x13\xae\x05\x3b\x54\x3b\xa9\x13\x0a\x3e\x13\xba\x53\xeb\x39\xb8\x7d\xe4\x58\x06\x4e\xaf\x7f\x53\x09\x75\xd2\x00\xe4\x17\x9d\x86\x4e\x6a\xb8\xa3\x3d\x19\x0e\xe4\x56\xb2\xb3\x0c\x28\x9a\x70\x7d\xc7\x38\xf1\xc4\x56\xfe\xe8\x00\x9e\x62\xd5\xce\xbe\x76\xb2\x2d\x9e\x18\x75\xdd\x8a\x56\x17\xaf\x5a\xfc\xff\x06\xf7\xa0\x8a\x9f\x7a\xb1\x27\xe8\x4c\x62\x15\xab\x10\xbe\x71\x38\xba\x05\x38\xb1\x57\x78\xbd\x9f\xf5\xf2\x34\x6a\x57\x5d\xb7\x06\xe5\xa1\x14\x14\x46\xb1\x35\x7a\x0f\x42\x4a\xa4\xd8\xd1\x4b\x8c\x17\x69\x2f\xba\x3b\x9b\xfb\x95\xd0\x84\xf7\xe7\x67\x87\xc3\xac\x0b\xc4\x6d\x3b\xc3\x4f\xc5\xa2\x53\x1a\xe4\x1f\xd6\xc3\x69\xb1\x13\x71\x22\xef\x1a\xe9\xa3\xbd\xbb\x70\x9c\x67\x8a\xd7\x78\xa0\xbd\x91\xb0\xb4\x76\xb3\x41\xac\x39\xeb\x7b\x53\x27\x6b\xe5\x27\x53\xa8\x50\x30\xe0\xdc\xd0\x40\x84\x33\x76\x5b\x08\x4d\x4d\xde\xa1\xa8\xfa\x8a\x38\x3f\x32\x8c\x55\xcf\xc8\x0b\x8f\x0b\x6e\x30\x8f\xe6\x8d\xc1\x3f\x7d\x97\x3c\xc9\xc4\x13\x06\x26\xdd\x1e\x93\x6e\x1e\x25\x4a\x5e\x60\xb6\xce\xa6\xf0\x6f\x64\x66\xf9\x4a\xdb\xa6\x38\xcf\xc2\x05\x91\xb7\x1b\x3e\x9f\x10\xd4\xc2\x79\x25\x1b\x2d\x5c\x17\x8c\x56\xcb\xf1\x28\x6d\x77\x5d\xec\x88\xfb\xa8\x64\x5d\xd9\x8e\xf5\x66\x3b\xeb\x36\xd4\x1f\x36\x8f\x96\x85\x8d\x16\x62\x29\x2f\xbf\xb9\x7a\xf8\x7f\xea\xf0\x9b\x98\x7d\x5d\x57\xea\x2f\xac\xad\x79\x22\x35\x3e\xb4\xd2\xd7\x83\xf0\x51\x86\x74\xfa\x66\x83\xbe\x45\xe0\x81\x8f\x67\xcb\xa9\x25\x61\xe3\x47\x52\xe7\x0e\xdd\xf6\xc4\xa7\x0c\x3e\x10\x0c\x0c\x88\x6b\xf5\xc7\x74\x14\x8b\x0d\x8f\xb1\x98\x65\x84\x3e\xf9\x3e\xf2\x3c\xf9\xc4\x92\x7c\x2b\xe1\xe0\x84\xab\xbb\x40\xca\xb3\x91\x97\x5a\x91\x47\x33\x6b\x4d\x58\xe4\x57\x17\x57\x97\x3d\x48\xb7\xb8\x56\xe4\xdd\xfe\xb5\x22\x86\xf8\x4e\x0a\x13\xd2\xf5\x08\x29\xd7\x8a\xcd\x8a\x28\x37\xa3\x56\x30\x75\xbb\xed\x8d\x2f\x8b\x42\xc5\x4b\x16\x1e\xde\x2f\x99\xbc\x8f\x60\x1c\xde\x0f\xfc\xed\x70\x00\x17\xa8\xc0\x17\x56\xcf\xc2\xc7\xaf\x51\x3f\x1d\x7e\xeb\x36\xf8\xad\x6e\xd5\xbf\xfe\x78\xd7\x11\x2f\x9a\xb6\x07\xa2\xc6\xb5\x34\x0c\x4c\x61\x3d\x81\x0d\xc2\x50\x89\x7d\xb8\x9c\xd2\xdb\xe1\x8a\xd2\x90\xb6\x76\xd3\xd4\xa0\x88\x1a\x24\xb0\x06\xc8\x56\x08\xef\xfb\x4f\x46\xac\xbd\xa9\x69\xb8\x81\x2c\x0c\x75\xf7\x5f\x93\x8f\xd6\xe0\x24\x7d\xf3\x2a\x18\x90\xde\x41\xc6\xcd\x69\x7c\x2d\xd9\x1d\x6c\x82\x7d\xa3\x37\xfd\x99\x6b\x72\x39\x39\xfb\x6f\x00\x00\x00\xff\xff\xf8\xa7\x91\xc4\x66\x1c\x00\x00"),
		},
		"/flux-secret.yaml.tmpl": &vfsgen۰CompressedFileInfo{
			name:             "flux-secret.yaml.tmpl",
			modTime:          time.Date(1970, 1, 1, 0, 0, 0, 0, time.UTC),
			uncompressedSize: 137,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x54\xca\x31\x0a\xc2\x40\x10\x85\xe1\x7e\x4f\xf1\x2e\xb0\x82\xed\x1c\x42\x0b\xc1\x7e\xc8\xbe\xc8\x62\xb2\x19\x93\x89\x18\x86\xdc\x5d\x14\x1b\xcb\x9f\xff\xcb\x39\x27\xb5\x7a\xe5\xbc\xd4\xa9\x09\x9e\xc7\x74\xaf\xad\x08\x2e\xec\x66\x7a\x1a\xe9\x5a\xd4\x55\x12\xd0\x74\xa4\xa0\x1f\xd6\x57\xbe\x55\xcf\x85\x36\x4c\x5b\x04\x6a\x8f\xc3\x49\x47\x2e\xa6\x1d\xb1\xef\x3f\xfa\x4d\x41\xc4\xff\x8d\x00\x5b\xf9\x30\xdf\x8c\x82\xb3\xe9\x63\x65\x7a\x07\x00\x00\xff\xff\x40\x21\xa1\xbb\x89\x00\x00\x00"),
		},
		"/memcache-dep.yaml.tmpl": &vfsgen۰CompressedFileInfo{
			name:             "memcache-dep.yaml.tmpl",
			modTime:          time.Date(1970, 1, 1, 0, 0, 0, 0, time.UTC),
			uncompressedSize: 967,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\x53\x4d\x6f\x9b\x40\x10\xbd\xf3\x2b\x9e\xe4\x6b\x21\x25\x52\x2e\xdc\xa2\xa6\xad\x22\xb5\x91\xa5\x28\xbd\x8f\x97\x81\xac\xb2\x5f\xdd\x9d\x75\x4d\x51\xfe\x7b\x05\x76\x6c\x68\x32\x27\xe0\xbd\x79\xf3\x76\xf6\x51\x96\x65\xb1\x81\x65\xab\x48\x3d\x73\x8b\x96\x83\xf1\x83\x65\x27\xc8\x89\x5b\xec\x06\x7c\x33\xf9\x00\xf1\x98\x19\xc5\x06\xca\x3b\x21\xed\x38\x42\x5b\xea\x19\x96\x85\x5a\x12\xaa\x0a\x0a\xfa\x17\xc7\xa4\xbd\x6b\x40\x21\xa4\xab\x7d\x5d\xbc\x68\xd7\x36\xb8\x3b\xcb\x16\x6f\xf4\xa6\x00\x1c\x59\x6e\x2e\xd3\xc7\x11\xba\x43\xf5\x40\x96\x53\x20\xc5\x78\x7d\x3d\x91\xe6\xd7\x06\xe3\xb8\x46\xc7\x11\xec\xda\x89\x96\x02\xab\x49\x31\x72\x30\x5a\x51\x6a\x50\x17\x40\x62\xc3\x4a\x7c\x9c\x10\xc0\x92\xa8\xe7\x1f\xb4\x63\x93\x8e\x1f\xde\x19\x28\x00\x61\x1b\x0c\x09\x9f\x5a\x16\x66\xa7\x32\xab\xee\x8f\xfa\x81\x37\x2b\x33\xee\x5b\x7e\x5c\x99\x98\x6a\xc7\x42\xd5\x4b\xde\x71\x74\x2c\x9c\x2a\xed\xaf\x7c\x6a\x60\xb4\xcb\x87\x13\xe9\xbc\xe4\xf3\xb0\xf2\xc3\x61\x53\xcd\xd7\xb0\x00\x9a\xba\xba\xa9\xae\x3f\xaf\xf1\x6d\x36\x66\xeb\x8d\x56\x43\x83\xfb\xee\xc1\xcb\x36\x72\x9a\xee\xe3\x8d\x45\xb1\x5f\x1c\xac\x44\x69\x71\x53\x5f\x03\xd8\xe0\x27\x1d\xb4\xcd\x76\x9a\xe0\xe3\x30\x65\x21\x27\xfe\x04\xed\x60\xb9\xa7\xdd\x20\x9c\x96\x8d\xf7\xb8\xb1\x58\x35\x26\xfd\x97\xd1\xf9\x08\xef\x18\x5a\xd8\x2e\xe9\x01\x75\x7d\x5d\xd7\xd8\xe0\x8e\x3b\xca\x46\x10\x7c\xbc\xf8\xda\x4c\x9c\xfd\xfe\xf8\xf8\xe4\x94\xb7\x73\x3a\xc5\xa3\x67\x81\xf1\x7d\x82\xef\xc0\xa4\x9e\x11\xf9\x77\xe6\x24\x20\xd7\x22\x72\x0a\xde\x25\xae\xce\x42\x93\xea\xea\x84\xc7\x7d\x2a\xa3\xd9\xc9\xe5\x00\x8b\xdd\x6f\x7d\x94\xe6\xe8\xee\x14\xcd\xdb\xb6\x7d\x64\x95\xa3\x96\xe1\x8b\x77\xc2\x07\x99\x23\x7a\xac\xb4\x46\x9a\x85\x64\xcc\xee\x36\x3d\x25\x8e\x27\xb9\xff\xa1\xef\xd1\xe7\xf0\x1e\x23\x63\xfc\x9f\x6d\xd4\x7b\x6d\xb8\xe7\xaf\x49\x91\x21\x99\x7f\xaf\x8e\x4c\xe2\x4b\xfc\xff\x05\x00\x00\xff\xff\xec\xf7\xcf\x04\xc7\x03\x00\x00"),
		},
		"/memcache-svc.yaml.tmpl": &vfsgen۰CompressedFileInfo{
			name:             "memcache-svc.yaml.tmpl",
			modTime:          time.Date(1970, 1, 1, 0, 0, 0, 0, time.UTC),
			uncompressedSize: 206,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x5c\x8c\x3d\x0e\x02\x21\x10\x46\x7b\x4e\xf1\x5d\x00\x13\x2c\x39\x84\x8d\x89\xfd\x04\x3e\x23\x51\x58\x02\x64\x9b\xc9\xde\xdd\xb0\x6b\xe3\x76\xf3\xf3\xde\xb3\xd6\x1a\xa9\xe9\xc1\xd6\xd3\x52\x3c\x56\x67\xde\xa9\x44\x8f\x3b\xdb\x9a\x02\x4d\xe6\x90\x28\x43\xbc\x01\x8a\x64\x7a\x64\xe6\x20\xe1\xc5\xa8\x8a\xf4\xc4\xe5\x26\x99\xbd\x4a\x20\xb6\xed\x07\xed\xab\x87\xea\xff\x57\x15\x2c\x71\x62\xbd\x32\xcc\x62\x5d\xda\xe8\x73\x00\xec\x39\xbf\x5f\x0f\xc4\xc3\xb9\xab\x73\x06\xe8\xfc\x30\x8c\xa5\x1d\xce\xd9\xf8\x06\x00\x00\xff\xff\x20\x2f\xef\xba\xce\x00\x00\x00"),
		},
	}
	fs["/"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/flux-account.yaml.tmpl"].(os.FileInfo),
		fs["/flux-deployment.yaml.tmpl"].(os.FileInfo),
		fs["/flux-secret.yaml.tmpl"].(os.FileInfo),
		fs["/memcache-dep.yaml.tmpl"].(os.FileInfo),
		fs["/memcache-svc.yaml.tmpl"].(os.FileInfo),
	}

	return fs
}()

type vfsgen۰FS map[string]interface{}

func (fs vfsgen۰FS) Open(path string) (http.File, error) {
	path = pathpkg.Clean("/" + path)
	f, ok := fs[path]
	if !ok {
		return nil, &os.PathError{Op: "open", Path: path, Err: os.ErrNotExist}
	}

	switch f := f.(type) {
	case *vfsgen۰CompressedFileInfo:
		gr, err := gzip.NewReader(bytes.NewReader(f.compressedContent))
		if err != nil {
			// This should never happen because we generate the gzip bytes such that they are always valid.
			panic("unexpected error reading own gzip compressed bytes: " + err.Error())
		}
		return &vfsgen۰CompressedFile{
			vfsgen۰CompressedFileInfo: f,
			gr:                        gr,
		}, nil
	case *vfsgen۰DirInfo:
		return &vfsgen۰Dir{
			vfsgen۰DirInfo: f,
		}, nil
	default:
		// This should never happen because we generate only the above types.
		panic(fmt.Sprintf("unexpected type %T", f))
	}
}

// vfsgen۰CompressedFileInfo is a static definition of a gzip compressed file.
type vfsgen۰CompressedFileInfo struct {
	name              string
	modTime           time.Time
	compressedContent []byte
	uncompressedSize  int64
}

func (f *vfsgen۰CompressedFileInfo) Readdir(count int) ([]os.FileInfo, error) {
	return nil, fmt.Errorf("cannot Readdir from file %s", f.name)
}
func (f *vfsgen۰CompressedFileInfo) Stat() (os.FileInfo, error) { return f, nil }

func (f *vfsgen۰CompressedFileInfo) GzipBytes() []byte {
	return f.compressedContent
}

func (f *vfsgen۰CompressedFileInfo) Name() string       { return f.name }
func (f *vfsgen۰CompressedFileInfo) Size() int64        { return f.uncompressedSize }
func (f *vfsgen۰CompressedFileInfo) Mode() os.FileMode  { return 0444 }
func (f *vfsgen۰CompressedFileInfo) ModTime() time.Time { return f.modTime }
func (f *vfsgen۰CompressedFileInfo) IsDir() bool        { return false }
func (f *vfsgen۰CompressedFileInfo) Sys() interface{}   { return nil }

// vfsgen۰CompressedFile is an opened compressedFile instance.
type vfsgen۰CompressedFile struct {
	*vfsgen۰CompressedFileInfo
	gr      *gzip.Reader
	grPos   int64 // Actual gr uncompressed position.
	seekPos int64 // Seek uncompressed position.
}

func (f *vfsgen۰CompressedFile) Read(p []byte) (n int, err error) {
	if f.grPos > f.seekPos {
		// Rewind to beginning.
		err = f.gr.Reset(bytes.NewReader(f.compressedContent))
		if err != nil {
			return 0, err
		}
		f.grPos = 0
	}
	if f.grPos < f.seekPos {
		// Fast-forward.
		_, err = io.CopyN(ioutil.Discard, f.gr, f.seekPos-f.grPos)
		if err != nil {
			return 0, err
		}
		f.grPos = f.seekPos
	}
	n, err = f.gr.Read(p)
	f.grPos += int64(n)
	f.seekPos = f.grPos
	return n, err
}
func (f *vfsgen۰CompressedFile) Seek(offset int64, whence int) (int64, error) {
	switch whence {
	case io.SeekStart:
		f.seekPos = 0 + offset
	case io.SeekCurrent:
		f.seekPos += offset
	case io.SeekEnd:
		f.seekPos = f.uncompressedSize + offset
	default:
		panic(fmt.Errorf("invalid whence value: %v", whence))
	}
	return f.seekPos, nil
}
func (f *vfsgen۰CompressedFile) Close() error {
	return f.gr.Close()
}

// vfsgen۰DirInfo is a static definition of a directory.
type vfsgen۰DirInfo struct {
	name    string
	modTime time.Time
	entries []os.FileInfo
}

func (d *vfsgen۰DirInfo) Read([]byte) (int, error) {
	return 0, fmt.Errorf("cannot Read from directory %s", d.name)
}
func (d *vfsgen۰DirInfo) Close() error               { return nil }
func (d *vfsgen۰DirInfo) Stat() (os.FileInfo, error) { return d, nil }

func (d *vfsgen۰DirInfo) Name() string       { return d.name }
func (d *vfsgen۰DirInfo) Size() int64        { return 0 }
func (d *vfsgen۰DirInfo) Mode() os.FileMode  { return 0755 | os.ModeDir }
func (d *vfsgen۰DirInfo) ModTime() time.Time { return d.modTime }
func (d *vfsgen۰DirInfo) IsDir() bool        { return true }
func (d *vfsgen۰DirInfo) Sys() interface{}   { return nil }

// vfsgen۰Dir is an opened dir instance.
type vfsgen۰Dir struct {
	*vfsgen۰DirInfo
	pos int // Position within entries for Seek and Readdir.
}

func (d *vfsgen۰Dir) Seek(offset int64, whence int) (int64, error) {
	if offset == 0 && whence == io.SeekStart {
		d.pos = 0
		return 0, nil
	}
	return 0, fmt.Errorf("unsupported Seek in directory %s", d.name)
}

func (d *vfsgen۰Dir) Readdir(count int) ([]os.FileInfo, error) {
	if d.pos >= len(d.entries) && count > 0 {
		return nil, io.EOF
	}
	if count <= 0 || count > len(d.entries)-d.pos {
		count = len(d.entries) - d.pos
	}
	e := d.entries[d.pos : d.pos+count]
	d.pos += count
	return e, nil
}
