# CEL function and operator documentation

This file is generated by `make gen_doc` (DO NOT EDIT).


## Custom functions

### `depExists`
Check if a project has a dependency.

This supports a few package management tools: more may be added later.

* `<fs dyn>.depExists(managerType string, pattern string)` -> `bool`
    - `fs`: The filesystem, representing each directory
    - `managerType`: The manager type (one of: `dotnet`, `elixir`, `go`, `java`, `js`, `php`, `python`, `ruby`, `rust`)
    - `pattern`: The dependency name, accepting `*` as a wildcard

### `depVersion`
Find the version of a project dependency.

This returns an empty string if the dependency is not found.

* `<fs dyn>.depVersion(managerType string, name string)` -> `string`
    - `fs`: The filesystem, representing each directory
    - `managerType`: The manager type (one of: `dotnet`, `elixir`, `go`, `java`, `js`, `php`, `python`, `ruby`, `rust`)
    - `name`: The dependency name

### `fileContains`
Check whether a file contains a substring.

* `<fs dyn>.fileContains(filename string, substr string)` -> `bool`

### `fileExists`
Check whether a file exists.

* `<fs dyn>.fileExists(filename string)` -> `bool`

### `glob`
List files matching a glob pattern.

* `<fs dyn>.glob(pattern string)` -> `list(string)`

### `isDir`
Check if a file exists and is a directory.

* `<fs dyn>.isDir(name string)` -> `bool`

### `jq`
Query JSON bytes (e.g. file contents) using JQ.

* `jq(contents bytes, query string)` -> `string`

### `read`
Read a file.

* `<fs dyn>.read(filename string)` -> `bytes`

### `yq`
Query YAML bytes (e.g. file contents) using YQ (same syntax as JQ).

* `yq(contents bytes, query string)` -> `string`

## Built-in functions

### `@in`

* `@in(A, list(A))` -> `bool`
* `@in(A, map(A, B))` -> `bool`

### `@not_strictly_false`

* `@not_strictly_false(bool)` -> `bool`

### `@sortByAssociatedKeys`

* `<list(T)>.@sortByAssociatedKeys(list(int))` -> `list(T)`
* `<list(T)>.@sortByAssociatedKeys(list(uint))` -> `list(T)`
* `<list(T)>.@sortByAssociatedKeys(list(double))` -> `list(T)`
* `<list(T)>.@sortByAssociatedKeys(list(bool))` -> `list(T)`
* `<list(T)>.@sortByAssociatedKeys(list(google.protobuf.Duration))` -> `list(T)`
* `<list(T)>.@sortByAssociatedKeys(list(google.protobuf.Timestamp))` -> `list(T)`
* `<list(T)>.@sortByAssociatedKeys(list(string))` -> `list(T)`
* `<list(T)>.@sortByAssociatedKeys(list(bytes))` -> `list(T)`

### `bool`

* `bool(bool)` -> `bool`
* `bool(string)` -> `bool`

### `bytes`

* `bytes(bytes)` -> `bytes`
* `bytes(string)` -> `bytes`

### `charAt`

* `<string>.charAt(int)` -> `string`

### `contains`

* `<string>.contains(string)` -> `bool`

### `distinct`

* `<list(T)>.distinct()` -> `list(T)`

### `double`

* `double(double)` -> `double`
* `double(int)` -> `double`
* `double(string)` -> `double`
* `double(uint)` -> `double`

### `duration`

* `duration(google.protobuf.Duration)` -> `google.protobuf.Duration`
* `duration(int)` -> `google.protobuf.Duration`
* `duration(string)` -> `google.protobuf.Duration`

### `dyn`

* `dyn(A)` -> `dyn`

### `endsWith`

* `<string>.endsWith(string)` -> `bool`

### `flatten`

* `<list(list(T))>.flatten()` -> `list(T)`
* `<list(dyn)>.flatten(int)` -> `list(dyn)`

### `format`

* `<string>.format(list(dyn))` -> `string`

### `getDate`

* `<google.protobuf.Timestamp>.getDate()` -> `int`
* `<google.protobuf.Timestamp>.getDate(string)` -> `int`

### `getDayOfMonth`

* `<google.protobuf.Timestamp>.getDayOfMonth()` -> `int`
* `<google.protobuf.Timestamp>.getDayOfMonth(string)` -> `int`

### `getDayOfWeek`

* `<google.protobuf.Timestamp>.getDayOfWeek()` -> `int`
* `<google.protobuf.Timestamp>.getDayOfWeek(string)` -> `int`

### `getDayOfYear`

* `<google.protobuf.Timestamp>.getDayOfYear()` -> `int`
* `<google.protobuf.Timestamp>.getDayOfYear(string)` -> `int`

### `getFullYear`

* `<google.protobuf.Timestamp>.getFullYear()` -> `int`
* `<google.protobuf.Timestamp>.getFullYear(string)` -> `int`

### `getHours`

* `<google.protobuf.Timestamp>.getHours()` -> `int`
* `<google.protobuf.Timestamp>.getHours(string)` -> `int`
* `<google.protobuf.Duration>.getHours()` -> `int`

### `getMilliseconds`

* `<google.protobuf.Timestamp>.getMilliseconds()` -> `int`
* `<google.protobuf.Timestamp>.getMilliseconds(string)` -> `int`
* `<google.protobuf.Duration>.getMilliseconds()` -> `int`

### `getMinutes`

* `<google.protobuf.Timestamp>.getMinutes()` -> `int`
* `<google.protobuf.Timestamp>.getMinutes(string)` -> `int`
* `<google.protobuf.Duration>.getMinutes()` -> `int`

### `getMonth`

* `<google.protobuf.Timestamp>.getMonth()` -> `int`
* `<google.protobuf.Timestamp>.getMonth(string)` -> `int`

### `getSeconds`

* `<google.protobuf.Timestamp>.getSeconds()` -> `int`
* `<google.protobuf.Timestamp>.getSeconds(string)` -> `int`
* `<google.protobuf.Duration>.getSeconds()` -> `int`

### `in`

* `in(A, list(A))` -> `bool`
* `in(A, map(A, B))` -> `bool`

### `indexOf`

* `<string>.indexOf(string)` -> `int`
* `<string>.indexOf(string, int)` -> `int`

### `int`

* `int(int)` -> `int`
* `int(double)` -> `int`
* `int(google.protobuf.Duration)` -> `int`
* `int(string)` -> `int`
* `int(google.protobuf.Timestamp)` -> `int`
* `int(uint)` -> `int`

### `join`

* `<list(string)>.join()` -> `string`
* `<list(string)>.join(string)` -> `string`

### `lastIndexOf`

* `<string>.lastIndexOf(string)` -> `int`
* `<string>.lastIndexOf(string, int)` -> `int`

### `lists.range`

* `lists.range(int)` -> `list(int)`

### `lowerAscii`

* `<string>.lowerAscii()` -> `string`

### `matches`

* `matches(string, string)` -> `bool`
* `<string>.matches(string)` -> `bool`

### `replace`

* `<string>.replace(string, string)` -> `string`
* `<string>.replace(string, string, int)` -> `string`

### `reverse`

* `<list(T)>.reverse()` -> `list(T)`
* `<string>.reverse()` -> `string`

### `size`

* `size(bytes)` -> `int`
* `<bytes>.size()` -> `int`
* `size(list(A))` -> `int`
* `<list(A)>.size()` -> `int`
* `size(map(A, B))` -> `int`
* `<map(A, B)>.size()` -> `int`
* `size(string)` -> `int`
* `<string>.size()` -> `int`

### `slice`

* `<list(T)>.slice(int, int)` -> `list(T)`

### `sort`

* `<list(int)>.sort()` -> `list(int)`
* `<list(uint)>.sort()` -> `list(uint)`
* `<list(double)>.sort()` -> `list(double)`
* `<list(bool)>.sort()` -> `list(bool)`
* `<list(google.protobuf.Duration)>.sort()` -> `list(google.protobuf.Duration)`
* `<list(google.protobuf.Timestamp)>.sort()` -> `list(google.protobuf.Timestamp)`
* `<list(string)>.sort()` -> `list(string)`
* `<list(bytes)>.sort()` -> `list(bytes)`

### `split`

* `<string>.split(string)` -> `list(string)`
* `<string>.split(string, int)` -> `list(string)`

### `startsWith`

* `<string>.startsWith(string)` -> `bool`

### `string`

* `string(string)` -> `string`
* `string(bool)` -> `string`
* `string(bytes)` -> `string`
* `string(double)` -> `string`
* `string(google.protobuf.Duration)` -> `string`
* `string(int)` -> `string`
* `string(google.protobuf.Timestamp)` -> `string`
* `string(uint)` -> `string`

### `strings.quote`

* `strings.quote(string)` -> `string`

### `substring`

* `<string>.substring(int)` -> `string`
* `<string>.substring(int, int)` -> `string`

### `timestamp`

* `timestamp(google.protobuf.Timestamp)` -> `google.protobuf.Timestamp`
* `timestamp(int)` -> `google.protobuf.Timestamp`
* `timestamp(string)` -> `google.protobuf.Timestamp`

### `trim`

* `<string>.trim()` -> `string`

### `type`

* `type(A)` -> `type(A)`

### `uint`

* `uint(uint)` -> `uint`
* `uint(double)` -> `uint`
* `uint(int)` -> `uint`
* `uint(string)` -> `uint`

### `upperAscii`

* `<string>.upperAscii()` -> `string`

## Operators

### `!`

* `!` `bool` -> `bool`

### `-`

* `-` `double` -> `double`
* `-` `int` -> `int`

### `!=`

* `A` `!=` `A` -> `bool`

### `%`

* `int` `%` `int` -> `int`
* `uint` `%` `uint` -> `uint`

### `&&`

* `bool` `&&` `bool` -> `bool`

### `*`

* `double` `*` `double` -> `double`
* `int` `*` `int` -> `int`
* `uint` `*` `uint` -> `uint`

### `+`

* `bytes` `+` `bytes` -> `bytes`
* `double` `+` `double` -> `double`
* `google.protobuf.Duration` `+` `google.protobuf.Duration` -> `google.protobuf.Duration`
* `google.protobuf.Duration` `+` `google.protobuf.Timestamp` -> `google.protobuf.Timestamp`
* `google.protobuf.Timestamp` `+` `google.protobuf.Duration` -> `google.protobuf.Timestamp`
* `int` `+` `int` -> `int`
* `list(A)` `+` `list(A)` -> `list(A)`
* `string` `+` `string` -> `string`
* `uint` `+` `uint` -> `uint`

### `-`

* `double` `-` `double` -> `double`
* `google.protobuf.Duration` `-` `google.protobuf.Duration` -> `google.protobuf.Duration`
* `int` `-` `int` -> `int`
* `google.protobuf.Timestamp` `-` `google.protobuf.Duration` -> `google.protobuf.Timestamp`
* `google.protobuf.Timestamp` `-` `google.protobuf.Timestamp` -> `google.protobuf.Duration`
* `uint` `-` `uint` -> `uint`

### `/`

* `double` `/` `double` -> `double`
* `int` `/` `int` -> `int`
* `uint` `/` `uint` -> `uint`

### `<=`

* `bool` `<=` `bool` -> `bool`
* `int` `<=` `int` -> `bool`
* `int` `<=` `double` -> `bool`
* `int` `<=` `uint` -> `bool`
* `uint` `<=` `uint` -> `bool`
* `uint` `<=` `double` -> `bool`
* `uint` `<=` `int` -> `bool`
* `double` `<=` `double` -> `bool`
* `double` `<=` `int` -> `bool`
* `double` `<=` `uint` -> `bool`
* `string` `<=` `string` -> `bool`
* `bytes` `<=` `bytes` -> `bool`
* `google.protobuf.Timestamp` `<=` `google.protobuf.Timestamp` -> `bool`
* `google.protobuf.Duration` `<=` `google.protobuf.Duration` -> `bool`

### `<`

* `bool` `<` `bool` -> `bool`
* `int` `<` `int` -> `bool`
* `int` `<` `double` -> `bool`
* `int` `<` `uint` -> `bool`
* `uint` `<` `uint` -> `bool`
* `uint` `<` `double` -> `bool`
* `uint` `<` `int` -> `bool`
* `double` `<` `double` -> `bool`
* `double` `<` `int` -> `bool`
* `double` `<` `uint` -> `bool`
* `string` `<` `string` -> `bool`
* `bytes` `<` `bytes` -> `bool`
* `google.protobuf.Timestamp` `<` `google.protobuf.Timestamp` -> `bool`
* `google.protobuf.Duration` `<` `google.protobuf.Duration` -> `bool`

### `==`

* `A` `==` `A` -> `bool`

### `>=`

* `bool` `>=` `bool` -> `bool`
* `int` `>=` `int` -> `bool`
* `int` `>=` `double` -> `bool`
* `int` `>=` `uint` -> `bool`
* `uint` `>=` `uint` -> `bool`
* `uint` `>=` `double` -> `bool`
* `uint` `>=` `int` -> `bool`
* `double` `>=` `double` -> `bool`
* `double` `>=` `int` -> `bool`
* `double` `>=` `uint` -> `bool`
* `string` `>=` `string` -> `bool`
* `bytes` `>=` `bytes` -> `bool`
* `google.protobuf.Timestamp` `>=` `google.protobuf.Timestamp` -> `bool`
* `google.protobuf.Duration` `>=` `google.protobuf.Duration` -> `bool`

### `>`

* `bool` `>` `bool` -> `bool`
* `int` `>` `int` -> `bool`
* `int` `>` `double` -> `bool`
* `int` `>` `uint` -> `bool`
* `uint` `>` `uint` -> `bool`
* `uint` `>` `double` -> `bool`
* `uint` `>` `int` -> `bool`
* `double` `>` `double` -> `bool`
* `double` `>` `int` -> `bool`
* `double` `>` `uint` -> `bool`
* `string` `>` `string` -> `bool`
* `bytes` `>` `bytes` -> `bool`
* `google.protobuf.Timestamp` `>` `google.protobuf.Timestamp` -> `bool`
* `google.protobuf.Duration` `>` `google.protobuf.Duration` -> `bool`

### `? :`

* `bool` `?` `A` `:` `A` -> `A`

### `[ ]`

* `list(A)` `[` `int` `]` -> `A`
* `map(A, B)` `[` `A` `]` -> `B`

### `not strictly false`

* `bool` `_not_strictly_false__` -> `bool`

### `in`

* `A` `in` `list(A)` -> `bool`
* `A` `in` `map(A, B)` -> `bool`

### `||`

* `bool` `||` `bool` -> `bool`
