// Code generated by protoc-gen-gogo.
// source: raft_serverpb.proto
// DO NOT EDIT!

/*
	Package raft_serverpb is a generated protocol buffer package.

	It is generated from these files:
		raft_serverpb.proto

	It has these top-level messages:
		RaftMessage
		RaftTruncatedState
		SnapshotCFFile
		SnapshotMeta
		SnapshotChunk
		Done
		KeyValue
		RaftSnapshotData
		StoreIdent
		RaftLocalState
		RaftApplyState
		MergeState
		RegionLocalState
*/
package raft_serverpb

import (
	"fmt"
	"io"
	"math"

	proto "github.com/golang/protobuf/proto"

	eraftpb "github.com/pingcap/kvproto/pkg/eraftpb"

	metapb "github.com/pingcap/kvproto/pkg/metapb"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type PeerState int32

const (
	PeerState_Normal    PeerState = 0
	PeerState_Applying  PeerState = 1
	PeerState_Tombstone PeerState = 2
	PeerState_Merging   PeerState = 3
)

var PeerState_name = map[int32]string{
	0: "Normal",
	1: "Applying",
	2: "Tombstone",
	3: "Merging",
}
var PeerState_value = map[string]int32{
	"Normal":    0,
	"Applying":  1,
	"Tombstone": 2,
	"Merging":   3,
}

func (x PeerState) String() string {
	return proto.EnumName(PeerState_name, int32(x))
}
func (PeerState) EnumDescriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{0} }

type RaftMessage struct {
	RegionId    uint64              `protobuf:"varint,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	FromPeer    *metapb.Peer        `protobuf:"bytes,2,opt,name=from_peer,json=fromPeer" json:"from_peer,omitempty"`
	ToPeer      *metapb.Peer        `protobuf:"bytes,3,opt,name=to_peer,json=toPeer" json:"to_peer,omitempty"`
	Message     *eraftpb.Message    `protobuf:"bytes,4,opt,name=message" json:"message,omitempty"`
	RegionEpoch *metapb.RegionEpoch `protobuf:"bytes,5,opt,name=region_epoch,json=regionEpoch" json:"region_epoch,omitempty"`
	// true means to_peer is a tombstone peer and it should remove itself.
	IsTombstone bool `protobuf:"varint,6,opt,name=is_tombstone,json=isTombstone,proto3" json:"is_tombstone,omitempty"`
	// Region key range [start_key, end_key).
	StartKey []byte `protobuf:"bytes,7,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey   []byte `protobuf:"bytes,8,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	// If it has value, to_peer should be removed if merge is never going to complete.
	MergeTarget *metapb.Region `protobuf:"bytes,9,opt,name=merge_target,json=mergeTarget" json:"merge_target,omitempty"`
}

func (m *RaftMessage) Reset()                    { *m = RaftMessage{} }
func (m *RaftMessage) String() string            { return proto.CompactTextString(m) }
func (*RaftMessage) ProtoMessage()               {}
func (*RaftMessage) Descriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{0} }

func (m *RaftMessage) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

func (m *RaftMessage) GetFromPeer() *metapb.Peer {
	if m != nil {
		return m.FromPeer
	}
	return nil
}

func (m *RaftMessage) GetToPeer() *metapb.Peer {
	if m != nil {
		return m.ToPeer
	}
	return nil
}

func (m *RaftMessage) GetMessage() *eraftpb.Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *RaftMessage) GetRegionEpoch() *metapb.RegionEpoch {
	if m != nil {
		return m.RegionEpoch
	}
	return nil
}

func (m *RaftMessage) GetIsTombstone() bool {
	if m != nil {
		return m.IsTombstone
	}
	return false
}

func (m *RaftMessage) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *RaftMessage) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *RaftMessage) GetMergeTarget() *metapb.Region {
	if m != nil {
		return m.MergeTarget
	}
	return nil
}

type RaftTruncatedState struct {
	Index uint64 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	Term  uint64 `protobuf:"varint,2,opt,name=term,proto3" json:"term,omitempty"`
}

func (m *RaftTruncatedState) Reset()                    { *m = RaftTruncatedState{} }
func (m *RaftTruncatedState) String() string            { return proto.CompactTextString(m) }
func (*RaftTruncatedState) ProtoMessage()               {}
func (*RaftTruncatedState) Descriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{1} }

func (m *RaftTruncatedState) GetIndex() uint64 {
	if m != nil {
		return m.Index
	}
	return 0
}

func (m *RaftTruncatedState) GetTerm() uint64 {
	if m != nil {
		return m.Term
	}
	return 0
}

type SnapshotCFFile struct {
	Cf       string `protobuf:"bytes,1,opt,name=cf,proto3" json:"cf,omitempty"`
	Size_    uint64 `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	Checksum uint32 `protobuf:"varint,3,opt,name=checksum,proto3" json:"checksum,omitempty"`
}

func (m *SnapshotCFFile) Reset()                    { *m = SnapshotCFFile{} }
func (m *SnapshotCFFile) String() string            { return proto.CompactTextString(m) }
func (*SnapshotCFFile) ProtoMessage()               {}
func (*SnapshotCFFile) Descriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{2} }

func (m *SnapshotCFFile) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

func (m *SnapshotCFFile) GetSize_() uint64 {
	if m != nil {
		return m.Size_
	}
	return 0
}

func (m *SnapshotCFFile) GetChecksum() uint32 {
	if m != nil {
		return m.Checksum
	}
	return 0
}

type SnapshotMeta struct {
	CfFiles []*SnapshotCFFile `protobuf:"bytes,1,rep,name=cf_files,json=cfFiles" json:"cf_files,omitempty"`
}

func (m *SnapshotMeta) Reset()                    { *m = SnapshotMeta{} }
func (m *SnapshotMeta) String() string            { return proto.CompactTextString(m) }
func (*SnapshotMeta) ProtoMessage()               {}
func (*SnapshotMeta) Descriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{3} }

func (m *SnapshotMeta) GetCfFiles() []*SnapshotCFFile {
	if m != nil {
		return m.CfFiles
	}
	return nil
}

type SnapshotChunk struct {
	Message *RaftMessage `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
	Data    []byte       `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *SnapshotChunk) Reset()                    { *m = SnapshotChunk{} }
func (m *SnapshotChunk) String() string            { return proto.CompactTextString(m) }
func (*SnapshotChunk) ProtoMessage()               {}
func (*SnapshotChunk) Descriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{4} }

func (m *SnapshotChunk) GetMessage() *RaftMessage {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *SnapshotChunk) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type Done struct {
}

func (m *Done) Reset()                    { *m = Done{} }
func (m *Done) String() string            { return proto.CompactTextString(m) }
func (*Done) ProtoMessage()               {}
func (*Done) Descriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{5} }

type KeyValue struct {
	Key   []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *KeyValue) Reset()                    { *m = KeyValue{} }
func (m *KeyValue) String() string            { return proto.CompactTextString(m) }
func (*KeyValue) ProtoMessage()               {}
func (*KeyValue) Descriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{6} }

func (m *KeyValue) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *KeyValue) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

type RaftSnapshotData struct {
	Region   *metapb.Region `protobuf:"bytes,1,opt,name=region" json:"region,omitempty"`
	FileSize uint64         `protobuf:"varint,2,opt,name=file_size,json=fileSize,proto3" json:"file_size,omitempty"`
	Data     []*KeyValue    `protobuf:"bytes,3,rep,name=data" json:"data,omitempty"`
	Version  uint64         `protobuf:"varint,4,opt,name=version,proto3" json:"version,omitempty"`
	Meta     *SnapshotMeta  `protobuf:"bytes,5,opt,name=meta" json:"meta,omitempty"`
}

func (m *RaftSnapshotData) Reset()                    { *m = RaftSnapshotData{} }
func (m *RaftSnapshotData) String() string            { return proto.CompactTextString(m) }
func (*RaftSnapshotData) ProtoMessage()               {}
func (*RaftSnapshotData) Descriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{7} }

func (m *RaftSnapshotData) GetRegion() *metapb.Region {
	if m != nil {
		return m.Region
	}
	return nil
}

func (m *RaftSnapshotData) GetFileSize() uint64 {
	if m != nil {
		return m.FileSize
	}
	return 0
}

func (m *RaftSnapshotData) GetData() []*KeyValue {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *RaftSnapshotData) GetVersion() uint64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *RaftSnapshotData) GetMeta() *SnapshotMeta {
	if m != nil {
		return m.Meta
	}
	return nil
}

type StoreIdent struct {
	ClusterId uint64 `protobuf:"varint,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	StoreId   uint64 `protobuf:"varint,2,opt,name=store_id,json=storeId,proto3" json:"store_id,omitempty"`
}

func (m *StoreIdent) Reset()                    { *m = StoreIdent{} }
func (m *StoreIdent) String() string            { return proto.CompactTextString(m) }
func (*StoreIdent) ProtoMessage()               {}
func (*StoreIdent) Descriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{8} }

func (m *StoreIdent) GetClusterId() uint64 {
	if m != nil {
		return m.ClusterId
	}
	return 0
}

func (m *StoreIdent) GetStoreId() uint64 {
	if m != nil {
		return m.StoreId
	}
	return 0
}

type RaftLocalState struct {
	HardState *eraftpb.HardState `protobuf:"bytes,1,opt,name=hard_state,json=hardState" json:"hard_state,omitempty"`
	LastIndex uint64             `protobuf:"varint,2,opt,name=last_index,json=lastIndex,proto3" json:"last_index,omitempty"`
}

func (m *RaftLocalState) Reset()                    { *m = RaftLocalState{} }
func (m *RaftLocalState) String() string            { return proto.CompactTextString(m) }
func (*RaftLocalState) ProtoMessage()               {}
func (*RaftLocalState) Descriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{9} }

func (m *RaftLocalState) GetHardState() *eraftpb.HardState {
	if m != nil {
		return m.HardState
	}
	return nil
}

func (m *RaftLocalState) GetLastIndex() uint64 {
	if m != nil {
		return m.LastIndex
	}
	return 0
}

type RaftApplyState struct {
	AppliedIndex   uint64              `protobuf:"varint,1,opt,name=applied_index,json=appliedIndex,proto3" json:"applied_index,omitempty"`
	TruncatedState *RaftTruncatedState `protobuf:"bytes,2,opt,name=truncated_state,json=truncatedState" json:"truncated_state,omitempty"`
}

func (m *RaftApplyState) Reset()                    { *m = RaftApplyState{} }
func (m *RaftApplyState) String() string            { return proto.CompactTextString(m) }
func (*RaftApplyState) ProtoMessage()               {}
func (*RaftApplyState) Descriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{10} }

func (m *RaftApplyState) GetAppliedIndex() uint64 {
	if m != nil {
		return m.AppliedIndex
	}
	return 0
}

func (m *RaftApplyState) GetTruncatedState() *RaftTruncatedState {
	if m != nil {
		return m.TruncatedState
	}
	return nil
}

type MergeState struct {
	MinIndex uint64         `protobuf:"varint,1,opt,name=min_index,json=minIndex,proto3" json:"min_index,omitempty"`
	Target   *metapb.Region `protobuf:"bytes,2,opt,name=target" json:"target,omitempty"`
	Commit   uint64         `protobuf:"varint,3,opt,name=commit,proto3" json:"commit,omitempty"`
}

func (m *MergeState) Reset()                    { *m = MergeState{} }
func (m *MergeState) String() string            { return proto.CompactTextString(m) }
func (*MergeState) ProtoMessage()               {}
func (*MergeState) Descriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{11} }

func (m *MergeState) GetMinIndex() uint64 {
	if m != nil {
		return m.MinIndex
	}
	return 0
}

func (m *MergeState) GetTarget() *metapb.Region {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *MergeState) GetCommit() uint64 {
	if m != nil {
		return m.Commit
	}
	return 0
}

type RegionLocalState struct {
	State      PeerState      `protobuf:"varint,1,opt,name=state,proto3,enum=raft_serverpb.PeerState" json:"state,omitempty"`
	Region     *metapb.Region `protobuf:"bytes,2,opt,name=region" json:"region,omitempty"`
	MergeState *MergeState    `protobuf:"bytes,3,opt,name=merge_state,json=mergeState" json:"merge_state,omitempty"`
}

func (m *RegionLocalState) Reset()                    { *m = RegionLocalState{} }
func (m *RegionLocalState) String() string            { return proto.CompactTextString(m) }
func (*RegionLocalState) ProtoMessage()               {}
func (*RegionLocalState) Descriptor() ([]byte, []int) { return fileDescriptorRaftServerpb, []int{12} }

func (m *RegionLocalState) GetState() PeerState {
	if m != nil {
		return m.State
	}
	return PeerState_Normal
}

func (m *RegionLocalState) GetRegion() *metapb.Region {
	if m != nil {
		return m.Region
	}
	return nil
}

func (m *RegionLocalState) GetMergeState() *MergeState {
	if m != nil {
		return m.MergeState
	}
	return nil
}

func init() {
	proto.RegisterType((*RaftMessage)(nil), "raft_serverpb.RaftMessage")
	proto.RegisterType((*RaftTruncatedState)(nil), "raft_serverpb.RaftTruncatedState")
	proto.RegisterType((*SnapshotCFFile)(nil), "raft_serverpb.SnapshotCFFile")
	proto.RegisterType((*SnapshotMeta)(nil), "raft_serverpb.SnapshotMeta")
	proto.RegisterType((*SnapshotChunk)(nil), "raft_serverpb.SnapshotChunk")
	proto.RegisterType((*Done)(nil), "raft_serverpb.Done")
	proto.RegisterType((*KeyValue)(nil), "raft_serverpb.KeyValue")
	proto.RegisterType((*RaftSnapshotData)(nil), "raft_serverpb.RaftSnapshotData")
	proto.RegisterType((*StoreIdent)(nil), "raft_serverpb.StoreIdent")
	proto.RegisterType((*RaftLocalState)(nil), "raft_serverpb.RaftLocalState")
	proto.RegisterType((*RaftApplyState)(nil), "raft_serverpb.RaftApplyState")
	proto.RegisterType((*MergeState)(nil), "raft_serverpb.MergeState")
	proto.RegisterType((*RegionLocalState)(nil), "raft_serverpb.RegionLocalState")
	proto.RegisterEnum("raft_serverpb.PeerState", PeerState_name, PeerState_value)
}
func (m *RaftMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftMessage) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RegionId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.RegionId))
	}
	if m.FromPeer != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.FromPeer.Size()))
		n1, err := m.FromPeer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.ToPeer != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.ToPeer.Size()))
		n2, err := m.ToPeer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Message != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Message.Size()))
		n3, err := m.Message.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.RegionEpoch != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.RegionEpoch.Size()))
		n4, err := m.RegionEpoch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.IsTombstone {
		dAtA[i] = 0x30
		i++
		if m.IsTombstone {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.StartKey) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if m.MergeTarget != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.MergeTarget.Size()))
		n5, err := m.MergeTarget.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *RaftTruncatedState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftTruncatedState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Index != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Index))
	}
	if m.Term != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Term))
	}
	return i, nil
}

func (m *SnapshotCFFile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SnapshotCFFile) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Cf) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(len(m.Cf)))
		i += copy(dAtA[i:], m.Cf)
	}
	if m.Size_ != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Size_))
	}
	if m.Checksum != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Checksum))
	}
	return i, nil
}

func (m *SnapshotMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SnapshotMeta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.CfFiles) > 0 {
		for _, msg := range m.CfFiles {
			dAtA[i] = 0xa
			i++
			i = encodeVarintRaftServerpb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *SnapshotChunk) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SnapshotChunk) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Message != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Message.Size()))
		n6, err := m.Message.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if len(m.Data) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *Done) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Done) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *KeyValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyValue) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *RaftSnapshotData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftSnapshotData) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Region != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Region.Size()))
		n7, err := m.Region.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.FileSize != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.FileSize))
	}
	if len(m.Data) > 0 {
		for _, msg := range m.Data {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintRaftServerpb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Version != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Version))
	}
	if m.Meta != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Meta.Size()))
		n8, err := m.Meta.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}

func (m *StoreIdent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreIdent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ClusterId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.ClusterId))
	}
	if m.StoreId != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.StoreId))
	}
	return i, nil
}

func (m *RaftLocalState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftLocalState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.HardState != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.HardState.Size()))
		n9, err := m.HardState.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.LastIndex != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.LastIndex))
	}
	return i, nil
}

func (m *RaftApplyState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftApplyState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AppliedIndex != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.AppliedIndex))
	}
	if m.TruncatedState != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.TruncatedState.Size()))
		n10, err := m.TruncatedState.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}

func (m *MergeState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MinIndex != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.MinIndex))
	}
	if m.Target != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Target.Size()))
		n11, err := m.Target.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.Commit != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Commit))
	}
	return i, nil
}

func (m *RegionLocalState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RegionLocalState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.State != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.State))
	}
	if m.Region != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Region.Size()))
		n12, err := m.Region.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.MergeState != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.MergeState.Size()))
		n13, err := m.MergeState.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}

func encodeFixed64RaftServerpb(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32RaftServerpb(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintRaftServerpb(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *RaftMessage) Size() (n int) {
	var l int
	_ = l
	if m.RegionId != 0 {
		n += 1 + sovRaftServerpb(uint64(m.RegionId))
	}
	if m.FromPeer != nil {
		l = m.FromPeer.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.ToPeer != nil {
		l = m.ToPeer.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.Message != nil {
		l = m.Message.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.RegionEpoch != nil {
		l = m.RegionEpoch.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.IsTombstone {
		n += 2
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.MergeTarget != nil {
		l = m.MergeTarget.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	return n
}

func (m *RaftTruncatedState) Size() (n int) {
	var l int
	_ = l
	if m.Index != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Index))
	}
	if m.Term != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Term))
	}
	return n
}

func (m *SnapshotCFFile) Size() (n int) {
	var l int
	_ = l
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.Size_ != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Size_))
	}
	if m.Checksum != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Checksum))
	}
	return n
}

func (m *SnapshotMeta) Size() (n int) {
	var l int
	_ = l
	if len(m.CfFiles) > 0 {
		for _, e := range m.CfFiles {
			l = e.Size()
			n += 1 + l + sovRaftServerpb(uint64(l))
		}
	}
	return n
}

func (m *SnapshotChunk) Size() (n int) {
	var l int
	_ = l
	if m.Message != nil {
		l = m.Message.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	return n
}

func (m *Done) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *KeyValue) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	return n
}

func (m *RaftSnapshotData) Size() (n int) {
	var l int
	_ = l
	if m.Region != nil {
		l = m.Region.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.FileSize != 0 {
		n += 1 + sovRaftServerpb(uint64(m.FileSize))
	}
	if len(m.Data) > 0 {
		for _, e := range m.Data {
			l = e.Size()
			n += 1 + l + sovRaftServerpb(uint64(l))
		}
	}
	if m.Version != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Version))
	}
	if m.Meta != nil {
		l = m.Meta.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	return n
}

func (m *StoreIdent) Size() (n int) {
	var l int
	_ = l
	if m.ClusterId != 0 {
		n += 1 + sovRaftServerpb(uint64(m.ClusterId))
	}
	if m.StoreId != 0 {
		n += 1 + sovRaftServerpb(uint64(m.StoreId))
	}
	return n
}

func (m *RaftLocalState) Size() (n int) {
	var l int
	_ = l
	if m.HardState != nil {
		l = m.HardState.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.LastIndex != 0 {
		n += 1 + sovRaftServerpb(uint64(m.LastIndex))
	}
	return n
}

func (m *RaftApplyState) Size() (n int) {
	var l int
	_ = l
	if m.AppliedIndex != 0 {
		n += 1 + sovRaftServerpb(uint64(m.AppliedIndex))
	}
	if m.TruncatedState != nil {
		l = m.TruncatedState.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	return n
}

func (m *MergeState) Size() (n int) {
	var l int
	_ = l
	if m.MinIndex != 0 {
		n += 1 + sovRaftServerpb(uint64(m.MinIndex))
	}
	if m.Target != nil {
		l = m.Target.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.Commit != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Commit))
	}
	return n
}

func (m *RegionLocalState) Size() (n int) {
	var l int
	_ = l
	if m.State != 0 {
		n += 1 + sovRaftServerpb(uint64(m.State))
	}
	if m.Region != nil {
		l = m.Region.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.MergeState != nil {
		l = m.MergeState.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	return n
}

func sovRaftServerpb(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozRaftServerpb(x uint64) (n int) {
	return sovRaftServerpb(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *RaftMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromPeer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FromPeer == nil {
				m.FromPeer = &metapb.Peer{}
			}
			if err := m.FromPeer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ToPeer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ToPeer == nil {
				m.ToPeer = &metapb.Peer{}
			}
			if err := m.ToPeer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Message == nil {
				m.Message = &eraftpb.Message{}
			}
			if err := m.Message.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionEpoch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionEpoch == nil {
				m.RegionEpoch = &metapb.RegionEpoch{}
			}
			if err := m.RegionEpoch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsTombstone", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsTombstone = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeTarget", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MergeTarget == nil {
				m.MergeTarget = &metapb.Region{}
			}
			if err := m.MergeTarget.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftTruncatedState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftTruncatedState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftTruncatedState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Term", wireType)
			}
			m.Term = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Term |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SnapshotCFFile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SnapshotCFFile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SnapshotCFFile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size_", wireType)
			}
			m.Size_ = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Size_ |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checksum", wireType)
			}
			m.Checksum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Checksum |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SnapshotMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SnapshotMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SnapshotMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CfFiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CfFiles = append(m.CfFiles, &SnapshotCFFile{})
			if err := m.CfFiles[len(m.CfFiles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SnapshotChunk) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SnapshotChunk: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SnapshotChunk: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Message == nil {
				m.Message = &RaftMessage{}
			}
			if err := m.Message.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Done) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Done: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Done: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftSnapshotData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftSnapshotData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftSnapshotData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Region == nil {
				m.Region = &metapb.Region{}
			}
			if err := m.Region.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileSize", wireType)
			}
			m.FileSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FileSize |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data, &KeyValue{})
			if err := m.Data[len(m.Data)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Meta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Meta == nil {
				m.Meta = &SnapshotMeta{}
			}
			if err := m.Meta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreIdent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreIdent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreIdent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			m.ClusterId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ClusterId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreId", wireType)
			}
			m.StoreId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftLocalState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftLocalState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftLocalState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HardState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HardState == nil {
				m.HardState = &eraftpb.HardState{}
			}
			if err := m.HardState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastIndex", wireType)
			}
			m.LastIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftApplyState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftApplyState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftApplyState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppliedIndex", wireType)
			}
			m.AppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AppliedIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TruncatedState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TruncatedState == nil {
				m.TruncatedState = &RaftTruncatedState{}
			}
			if err := m.TruncatedState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinIndex", wireType)
			}
			m.MinIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Target == nil {
				m.Target = &metapb.Region{}
			}
			if err := m.Target.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Commit", wireType)
			}
			m.Commit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Commit |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegionLocalState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegionLocalState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegionLocalState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (PeerState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Region == nil {
				m.Region = &metapb.Region{}
			}
			if err := m.Region.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MergeState == nil {
				m.MergeState = &MergeState{}
			}
			if err := m.MergeState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRaftServerpb(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthRaftServerpb
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowRaftServerpb
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipRaftServerpb(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthRaftServerpb = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRaftServerpb   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("raft_serverpb.proto", fileDescriptorRaftServerpb) }

var fileDescriptorRaftServerpb = []byte{
	// 866 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x55, 0xdd, 0x6e, 0xe3, 0x44,
	0x14, 0x5e, 0x27, 0xae, 0x63, 0x9f, 0x38, 0x21, 0x9a, 0x45, 0xac, 0xb7, 0xd5, 0x56, 0x59, 0x23,
	0x56, 0xa1, 0x48, 0x41, 0x5b, 0x10, 0x42, 0x5c, 0x20, 0x2d, 0x2c, 0xd5, 0x96, 0xa5, 0xa8, 0x9a,
	0x56, 0x48, 0x5c, 0x59, 0x53, 0xfb, 0x38, 0xb1, 0xe2, 0x3f, 0xcd, 0x4c, 0x22, 0xc2, 0x1d, 0x6f,
	0xc1, 0x13, 0xf0, 0x2c, 0xdc, 0xc1, 0x23, 0xa0, 0x72, 0xcb, 0x43, 0xa0, 0x99, 0xb1, 0xf3, 0xa7,
	0xc2, 0x95, 0xe7, 0xfc, 0xcd, 0x39, 0xe7, 0x3b, 0xdf, 0x19, 0xc3, 0x63, 0xce, 0x52, 0x19, 0x09,
	0xe4, 0x2b, 0xe4, 0xf5, 0xdd, 0xb4, 0xe6, 0x95, 0xac, 0xc8, 0x60, 0x4f, 0x79, 0x3c, 0x40, 0x25,
	0xb7, 0xd6, 0x63, 0xbf, 0x40, 0xc9, 0x5a, 0x29, 0xfc, 0xa7, 0x03, 0x7d, 0xca, 0x52, 0x79, 0x85,
	0x42, 0xb0, 0x19, 0x92, 0x13, 0xf0, 0x38, 0xce, 0xb2, 0xaa, 0x8c, 0xb2, 0x24, 0xb0, 0xc6, 0xd6,
	0xc4, 0xa6, 0xae, 0x51, 0x5c, 0x26, 0xe4, 0x43, 0xf0, 0x52, 0x5e, 0x15, 0x51, 0x8d, 0xc8, 0x83,
	0xce, 0xd8, 0x9a, 0xf4, 0xcf, 0xfd, 0x69, 0x73, 0xdd, 0x35, 0x22, 0xa7, 0xae, 0x32, 0xab, 0x13,
	0xf9, 0x00, 0x7a, 0xb2, 0x32, 0x8e, 0xdd, 0x07, 0x1c, 0x1d, 0x59, 0x69, 0xb7, 0x33, 0xe8, 0x15,
	0x26, 0x73, 0x60, 0x6b, 0xb7, 0xd1, 0xb4, 0xad, 0xb6, 0xa9, 0x88, 0xb6, 0x0e, 0xe4, 0x33, 0xf0,
	0x9b, 0xd2, 0xb0, 0xae, 0xe2, 0x79, 0x70, 0xa4, 0x03, 0x1e, 0xb7, 0xf7, 0x52, 0x6d, 0xfb, 0x46,
	0x99, 0x68, 0x9f, 0x6f, 0x05, 0xf2, 0x1c, 0xfc, 0x4c, 0x44, 0xb2, 0x2a, 0xee, 0x84, 0xac, 0x4a,
	0x0c, 0x9c, 0xb1, 0x35, 0x71, 0x69, 0x3f, 0x13, 0xb7, 0xad, 0x4a, 0x75, 0x2d, 0x24, 0xe3, 0x32,
	0x5a, 0xe0, 0x3a, 0xe8, 0x8d, 0xad, 0x89, 0x4f, 0x5d, 0xad, 0x78, 0x8b, 0x6b, 0xf2, 0x04, 0x7a,
	0x58, 0x26, 0xda, 0xe4, 0x6a, 0x93, 0x83, 0x65, 0xa2, 0x0c, 0x2f, 0xc1, 0x2f, 0x90, 0xcf, 0x30,
	0x92, 0x8c, 0xcf, 0x50, 0x06, 0x9e, 0x2e, 0x68, 0xb8, 0x5f, 0x10, 0xed, 0x6b, 0x9f, 0x5b, 0xed,
	0x12, 0x7e, 0x09, 0x44, 0xa1, 0x7d, 0xcb, 0x97, 0x65, 0xcc, 0x24, 0x26, 0x37, 0x92, 0x49, 0x24,
	0xef, 0xc2, 0x51, 0x56, 0x26, 0xf8, 0x53, 0x03, 0xb8, 0x11, 0x08, 0x01, 0x5b, 0x22, 0x2f, 0x34,
	0xd0, 0x36, 0xd5, 0xe7, 0xf0, 0x1a, 0x86, 0x37, 0x25, 0xab, 0xc5, 0xbc, 0x92, 0x5f, 0x5f, 0x5c,
	0x64, 0x39, 0x92, 0x21, 0x74, 0xe2, 0x54, 0x07, 0x7a, 0xb4, 0x13, 0xa7, 0x2a, 0x4a, 0x64, 0x3f,
	0x63, 0x1b, 0xa5, 0xce, 0xe4, 0x18, 0xdc, 0x78, 0x8e, 0xf1, 0x42, 0x2c, 0x0b, 0x3d, 0x8d, 0x01,
	0xdd, 0xc8, 0xe1, 0x1b, 0xf0, 0xdb, 0x1b, 0xaf, 0x50, 0x32, 0xf2, 0x39, 0xb8, 0x71, 0x1a, 0xa5,
	0x59, 0x8e, 0x22, 0xb0, 0xc6, 0xdd, 0x49, 0xff, 0xfc, 0xd9, 0x74, 0x9f, 0x64, 0xfb, 0x05, 0xd0,
	0x5e, 0x9c, 0xaa, 0xaf, 0x08, 0x7f, 0x84, 0xc1, 0xc6, 0x34, 0x5f, 0x96, 0x0b, 0xf2, 0xe9, 0x76,
	0xb8, 0x96, 0x86, 0xe6, 0xf8, 0xe0, 0xa6, 0x1d, 0xe2, 0x6d, 0xc7, 0x4c, 0xc0, 0x4e, 0x98, 0x64,
	0xba, 0x01, 0x9f, 0xea, 0x73, 0xe8, 0x80, 0xfd, 0xba, 0x2a, 0x31, 0x3c, 0x07, 0xf7, 0x2d, 0xae,
	0x7f, 0x60, 0xf9, 0x12, 0xc9, 0x08, 0xba, 0x6a, 0x24, 0x96, 0x76, 0x53, 0x47, 0x05, 0xe3, 0x4a,
	0x99, 0x9a, 0x50, 0x23, 0x84, 0x7f, 0x58, 0x30, 0x52, 0x89, 0xda, 0xda, 0x5e, 0x33, 0xc9, 0xc8,
	0x0b, 0x70, 0x0c, 0x45, 0x9a, 0xca, 0x0e, 0x87, 0xd6, 0x58, 0x15, 0x31, 0x14, 0x14, 0xd1, 0x0e,
	0xa4, 0xae, 0x52, 0xdc, 0x28, 0x58, 0x3f, 0x6a, 0x2a, 0xed, 0x6a, 0x98, 0x9e, 0x1c, 0x34, 0xd7,
	0x16, 0x6a, 0x5a, 0x20, 0x01, 0xf4, 0x56, 0xc8, 0x85, 0x4a, 0x69, 0xeb, 0x7b, 0x5a, 0x91, 0x7c,
	0x0c, 0xb6, 0x4a, 0xde, 0xf0, 0xf9, 0xe4, 0x3f, 0xd0, 0x56, 0xc3, 0xa1, 0xda, 0x31, 0xbc, 0x00,
	0xb8, 0x91, 0x15, 0xc7, 0xcb, 0x04, 0x4b, 0x49, 0x9e, 0x01, 0xc4, 0xf9, 0x52, 0x48, 0xe4, 0xdb,
	0x95, 0xf5, 0x1a, 0xcd, 0x65, 0x42, 0x9e, 0x82, 0x2b, 0x94, 0xb3, 0x32, 0x9a, 0x06, 0x7a, 0xc2,
	0x04, 0x87, 0x77, 0x30, 0x54, 0xc0, 0x7c, 0x57, 0xc5, 0x2c, 0x37, 0x44, 0x7c, 0x09, 0x30, 0x67,
	0x3c, 0x89, 0x84, 0x92, 0x1a, 0x68, 0xc8, 0x66, 0x23, 0xdf, 0x30, 0x6e, 0x08, 0x4b, 0xbd, 0x79,
	0x7b, 0x54, 0xe9, 0x73, 0x26, 0x64, 0x64, 0x08, 0x6c, 0x32, 0x78, 0x4a, 0x73, 0xa9, 0x14, 0xe1,
	0x2f, 0x96, 0x49, 0xf2, 0xaa, 0xae, 0xf3, 0xb5, 0x89, 0x78, 0x1f, 0x06, 0xac, 0xae, 0xf3, 0x0c,
	0x93, 0x68, 0x97, 0xf5, 0x7e, 0xa3, 0xd4, 0x71, 0xe4, 0x5b, 0x78, 0x47, 0xb6, 0x4b, 0xd2, 0x94,
	0x63, 0x1e, 0x9c, 0xe7, 0x0f, 0x70, 0x68, 0x7f, 0x9d, 0xe8, 0x50, 0xee, 0xc9, 0x61, 0x06, 0x70,
	0xa5, 0x76, 0xd0, 0xa4, 0x3f, 0x01, 0xaf, 0xc8, 0xca, 0xbd, 0xd4, 0x6e, 0x91, 0x95, 0x26, 0xed,
	0x0b, 0x70, 0x9a, 0x65, 0xee, 0x3c, 0xcc, 0x0b, 0x63, 0x25, 0xef, 0x81, 0x13, 0x57, 0x45, 0x91,
	0x49, 0xbd, 0x4f, 0x36, 0x6d, 0xa4, 0xf0, 0x37, 0x45, 0x36, 0xed, 0xba, 0x83, 0xea, 0x14, 0x8e,
	0xb6, 0x80, 0x0e, 0xcf, 0x83, 0x83, 0x0e, 0xd4, 0x43, 0x68, 0x0a, 0x37, 0x6e, 0x3b, 0xe4, 0xec,
	0xfc, 0x2f, 0x39, 0xbf, 0x00, 0xf3, 0xb6, 0x34, 0xf8, 0x98, 0x77, 0xf6, 0xe9, 0xc1, 0xed, 0xdb,
	0xce, 0x29, 0x14, 0x9b, 0xf3, 0xd9, 0x2b, 0xf0, 0x36, 0x79, 0x09, 0x80, 0xf3, 0x7d, 0xc5, 0x0b,
	0x96, 0x8f, 0x1e, 0x11, 0x1f, 0x5c, 0x3d, 0xab, 0xac, 0x9c, 0x8d, 0x2c, 0x32, 0x00, 0x6f, 0xf3,
	0x4a, 0x8e, 0x3a, 0xa4, 0x0f, 0x3d, 0x75, 0x9f, 0xb2, 0x75, 0xbf, 0x3a, 0xfb, 0xfd, 0xfe, 0xd4,
	0xfa, 0xf3, 0xfe, 0xd4, 0xfa, 0xeb, 0xfe, 0xd4, 0xfa, 0xf5, 0xef, 0xd3, 0x47, 0x10, 0xc4, 0x55,
	0x31, 0xad, 0xb3, 0x72, 0x16, 0xb3, 0x7a, 0x2a, 0xb3, 0xc5, 0x6a, 0xba, 0x58, 0xe9, 0xdf, 0xcc,
	0x9d, 0xa3, 0x3f, 0x9f, 0xfc, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x6d, 0xac, 0x3c, 0x58, 0xb0, 0x06,
	0x00, 0x00,
}
