// Copyright 2016 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// See the License for the specific language governing permissions and
// limitations under the License.

package perfschema

// Performance Schema Name.
const (
	Name = "PERFORMANCE_SCHEMA"
)

// Definition order same as MySQL's reference manual, so don't bother to
// adjust according to alphabetical order.
const (
	tableGlobalStatus           = "GLOBAL_STATUS"
	tableSessionStatus          = "SESSION_STATUS"
	tableSetupActors            = "SETUP_ACTORS"
	tableSetupObjects           = "SETUP_OBJECTS"
	tableSetupInstruments       = "SETUP_INSTRUMENTS"
	tableSetupConsumers         = "SETUP_CONSUMERS"
	tableSetupTimers            = "SETUP_TIMERS"
	tableStmtsCurrent           = "EVENTS_STATEMENTS_CURRENT"
	tableStmtsHistory           = "EVENTS_STATEMENTS_HISTORY"
	tableStmtsHistoryLong       = "EVENTS_STATEMENTS_HISTORY_LONG"
	tablePreparedStmtsInstances = "PREPARED_STATEMENTS_INSTANCES"
	tableTransCurrent           = "EVENTS_TRANSACTIONS_CURRENT"
	tableTransHistory           = "EVENTS_TRANSACTIONS_HISTORY"
	tableTransHistoryLong       = "EVENTS_TRANSACTIONS_HISTORY_LONG"
	tableStagesCurrent          = "EVENTS_STAGES_CURRENT"
	tableStagesHistory          = "EVENTS_STAGES_HISTORY"
	tableStagesHistoryLong      = "EVENTS_STAGES_HISTORY_LONG"
)

// perfSchemaTables is a shortcut to involve all table names.
var perfSchemaTables = []string{
	tableGlobalStatus,
	tableSessionStatus,
	tableSetupActors,
	tableSetupObjects,
	tableSetupInstruments,
	tableSetupConsumers,
	tableSetupTimers,
	tableStmtsCurrent,
	tableStmtsHistory,
	tableStmtsHistoryLong,
	tablePreparedStmtsInstances,
	tableTransCurrent,
	tableTransHistory,
	tableTransHistoryLong,
	tableStagesCurrent,
	tableStagesHistory,
	tableStagesHistoryLong,
}

// columnGlobalStatus contains the column name definitions for table global_status, same as MySQL.
//
// CREATE TABLE performance_schema.global_status(
//     VARIABLE_NAME VARCHAR(64) not null,
//     VARIABLE_VALUE VARCHAR(1024));
var columnGlobalStatus = []string{"VARIABLE_NAME", "VARIABLE_VALUE"}

// columnSessionStatus contains the column name definitions for table session_status, same as MySQL.
//
// CREATE TABLE performance_schema.session_status(
//     VARIABLE_NAME VARCHAR(64) not null,
//     VARIABLE_VALUE VARCHAR(1024));
var columnSessionStatus = []string{"VARIABLE_NAME", "VARIABLE_VALUE"}

// columnSetupActors contains the column name definitions for table setup_actors, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.setup_actors (
// 		HOST			CHAR(60) NOT NULL  DEFAULT '%',
// 		USER			CHAR(32) NOT NULL  DEFAULT '%',
// 		ROLE			CHAR(16) NOT NULL  DEFAULT '%',
// 		ENABLED			ENUM('YES','NO') NOT NULL  DEFAULT 'YES',
// 		HISTORY			ENUM('YES','NO') NOT NULL  DEFAULT 'YES');
var columnSetupActors = []string{"HOST", "USER", "ROLE", "ENABLED", "HISTORY"}

// columnSetupObjects contains the column name definitions for table setup_objects, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.setup_objects (
// 		OBJECT_TYPE		ENUM('EVENT','FUNCTION','TABLE') NOT NULL  DEFAULT 'TABLE',
// 		OBJECT_SCHEMA	VARCHAR(64)  DEFAULT '%',
// 		OBJECT_NAME		VARCHAR(64) NOT NULL  DEFAULT '%',
// 		ENABLED			ENUM('YES','NO') NOT NULL  DEFAULT 'YES',
// 		TIMED			ENUM('YES','NO') NOT NULL  DEFAULT 'YES');
var columnSetupObjects = []string{"OBJECT_TYPE", "OBJECT_SCHEMA", "OBJECT_NAME", "ENABLED", "TIMED"}

// columnSetupInstruments contains the column name definitions for table setup_instruments, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.setup_instruments (
// 		NAME			VARCHAR(128) NOT NULL,
// 		ENABLED			ENUM('YES','NO') NOT NULL,
// 		TIMED			ENUM('YES','NO') NOT NULL);
var columnSetupInstruments = []string{"NAMED", "ENABLED", "TIMED"}

// columnSetupConsumers contains the column name definitions for table setup_consumers, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.setup_consumers (
// 		NAME			VARCHAR(64) NOT NULL,
// 		ENABLED			ENUM('YES','NO') NOT NULL);
var columnSetupConsumers = []string{"NAMED", "ENABLED"}

// columnSetupTimers contains the column name definitions for table setup_timers, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.setup_timers (
// 		NAME			VARCHAR(64) NOT NULL,
// 		TIMER_NAME		ENUM('NANOSECOND','MICROSECOND','MILLISECOND') NOT NULL);
var columnSetupTimers = []string{"NAME", "TIMER_NAME"}

// columnStmtsCurrent contains the column name definitions for table events_statements_current, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.events_statements_current (
// 		THREAD_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		EVENT_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		END_EVENT_ID	BIGINT(20) UNSIGNED,
// 		EVENT_NAME		VARCHAR(128) NOT NULL,
// 		SOURCE			VARCHAR(64),
// 		TIMER_START		BIGINT(20) UNSIGNED,
// 		TIMER_END		BIGINT(20) UNSIGNED,
// 		TIMER_WAIT		BIGINT(20) UNSIGNED,
// 		LOCK_TIME		BIGINT(20) UNSIGNED NOT NULL,
// 		SQL_TEXT		LONGTEXT,
// 		DIGEST			VARCHAR(32),
// 		DIGEST_TEXT		LONGTEXT,
// 		CURRENT_SCHEMA	VARCHAR(64),
// 		OBJECT_TYPE		VARCHAR(64),
// 		OBJECT_SCHEMA	VARCHAR(64),
// 		OBJECT_NAME		VARCHAR(64),
// 		OBJECT_INSTANCE_BEGIN	BIGINT(20) UNSIGNED,
// 		MYSQL_ERRNO		INT(11),
// 		RETURNED_SQLSTATE		VARCHAR(5),
// 		MESSAGE_TEXT	VARCHAR(128),
// 		ERRORS			BIGINT(20) UNSIGNED NOT NULL,
// 		WARNINGS		BIGINT(20) UNSIGNED NOT NULL,
// 		ROWS_AFFECTED	BIGINT(20) UNSIGNED NOT NULL,
// 		ROWS_SENT		BIGINT(20) UNSIGNED NOT NULL,
// 		ROWS_EXAMINED	BIGINT(20) UNSIGNED NOT NULL,
// 		CREATED_TMP_DISK_TABLES	BIGINT(20) UNSIGNED NOT NULL,
// 		CREATED_TMP_TABLES		BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_FULL_JOIN		BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_FULL_RANGE_JOIN	BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_RANGE	BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_RANGE_CHECK		BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_SCAN		BIGINT(20) UNSIGNED NOT NULL,
// 		SORT_MERGE_PASSES		BIGINT(20) UNSIGNED NOT NULL,
// 		SORT_RANGE		BIGINT(20) UNSIGNED NOT NULL,
// 		SORT_ROWS		BIGINT(20) UNSIGNED NOT NULL,
// 		SORT_SCAN		BIGINT(20) UNSIGNED NOT NULL,
// 		NO_INDEX_USED	BIGINT(20) UNSIGNED NOT NULL,
// 		NO_GOOD_INDEX_USED		BIGINT(20) UNSIGNED NOT NULL,
// 		NESTING_EVENT_ID		BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_TYPE		ENUM('TRANSACTION','STATEMENT','STAGE'),
// 		NESTING_EVENT_LEVEL		INT(11));
var columnStmtsCurrent = []string{
	"THREAD_ID",
	"EVENT_ID",
	"END_EVENT_ID",
	"EVENT_NAME",
	"SOURCE",
	"TIMER_START",
	"TIMER_END",
	"TIMER_WAIT",
	"LOCK_TIME",
	"SQL_TEXT",
	"DIGEST",
	"DIGEST_TEXT",
	"CURRENT_SCHEMA",
	"OBJECT_TYPE",
	"OBJECT_SCHEMA",
	"OBJECT_NAME",
	"OBJECT_INSTANCE_BEGIN",
	"MYSQL_ERRNO",
	"RETURNED_SQLSTATE",
	"MESSAGE_TEXT",
	"ERRORS",
	"WARNINGS",
	"ROWS_AFFECTED",
	"ROWS_SENT",
	"ROWS_EXAMINED",
	"CREATED_TMP_DISK_TABLES",
	"CREATED_TMP_TABLES",
	"SELECT_FULL_JOIN",
	"SELECT_FULL_RANGE_JOIN",
	"SELECT_RANGE",
	"SELECT_RANGE_CHECK",
	"SELECT_SCAN",
	"SORT_MERGE_PASSES",
	"SORT_RANGE",
	"SORT_ROWS",
	"SORT_SCAN",
	"NO_INDEX_USED",
	"NO_GOOD_INDEX_USED",
	"NESTING_EVENT_ID",
	"NESTING_EVENT_TYPE",
	"NESTING_EVENT_LEVEL",
}

// columnStmtsHistory contains the column name definitions for table events_statements_history, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.events_statements_history (
// 		THREAD_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		EVENT_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		END_EVENT_ID	BIGINT(20) UNSIGNED,
// 		EVENT_NAME		VARCHAR(128) NOT NULL,
// 		SOURCE			VARCHAR(64),
// 		TIMER_START		BIGINT(20) UNSIGNED,
// 		TIMER_END		BIGINT(20) UNSIGNED,
// 		TIMER_WAIT		BIGINT(20) UNSIGNED,
// 		LOCK_TIME		BIGINT(20) UNSIGNED NOT NULL,
// 		SQL_TEXT		LONGTEXT,
// 		DIGEST			VARCHAR(32),
// 		DIGEST_TEXT		LONGTEXT,
// 		CURRENT_SCHEMA	VARCHAR(64),
// 		OBJECT_TYPE		VARCHAR(64),
// 		OBJECT_SCHEMA	VARCHAR(64),
// 		OBJECT_NAME		VARCHAR(64),
// 		OBJECT_INSTANCE_BEGIN	BIGINT(20) UNSIGNED,
// 		MYSQL_ERRNO		INT(11),
// 		RETURNED_SQLSTATE		VARCHAR(5),
// 		MESSAGE_TEXT	VARCHAR(128),
// 		ERRORS			BIGINT(20) UNSIGNED NOT NULL,
// 		WARNINGS		BIGINT(20) UNSIGNED NOT NULL,
// 		ROWS_AFFECTED	BIGINT(20) UNSIGNED NOT NULL,
// 		ROWS_SENT		BIGINT(20) UNSIGNED NOT NULL,
// 		ROWS_EXAMINED	BIGINT(20) UNSIGNED NOT NULL,
// 		CREATED_TMP_DISK_TABLES	BIGINT(20) UNSIGNED NOT NULL,
// 		CREATED_TMP_TABLES		BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_FULL_JOIN		BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_FULL_RANGE_JOIN	BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_RANGE	BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_RANGE_CHECK		BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_SCAN		BIGINT(20) UNSIGNED NOT NULL,
// 		SORT_MERGE_PASSES		BIGINT(20) UNSIGNED NOT NULL,
// 		SORT_RANGE		BIGINT(20) UNSIGNED NOT NULL,
// 		SORT_ROWS		BIGINT(20) UNSIGNED NOT NULL,
// 		SORT_SCAN		BIGINT(20) UNSIGNED NOT NULL,
// 		NO_INDEX_USED	BIGINT(20) UNSIGNED NOT NULL,
// 		NO_GOOD_INDEX_USED		BIGINT(20) UNSIGNED NOT NULL,
// 		NESTING_EVENT_ID		BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_TYPE		ENUM('TRANSACTION','STATEMENT','STAGE'),
// 		NESTING_EVENT_LEVEL		INT(11));
var columnStmtsHistory = []string{
	"THREAD_ID",
	"EVENT_ID",
	"END_EVENT_ID",
	"EVENT_NAME",
	"SOURCE",
	"TIMER_START",
	"TIMER_END",
	"TIMER_WAIT",
	"LOCK_TIME",
	"SQL_TEXT",
	"DIGEST",
	"DIGEST_TEXT",
	"CURRENT_SCHEMA",
	"OBJECT_TYPE",
	"OBJECT_SCHEMA",
	"OBJECT_NAME",
	"OBJECT_INSTANCE_BEGIN",
	"MYSQL_ERRNO",
	"RETURNED_SQLSTATE",
	"MESSAGE_TEXT",
	"ERRORS",
	"WARNINGS",
	"ROWS_AFFECTED",
	"ROWS_SENT",
	"ROWS_EXAMINED",
	"CREATED_TMP_DISK_TABLES",
	"CREATED_TMP_TABLES",
	"SELECT_FULL_JOIN",
	"SELECT_FULL_RANGE_JOIN",
	"SELECT_RANGE",
	"SELECT_RANGE_CHECK",
	"SELECT_SCAN",
	"SORT_MERGE_PASSES",
	"SORT_RANGE",
	"SORT_ROWS",
	"SORT_SCAN",
	"NO_INDEX_USED",
	"NO_GOOD_INDEX_USED",
	"NESTING_EVENT_ID",
	"NESTING_EVENT_TYPE",
	"NESTING_EVENT_LEVEL",
}

// columnStmtsHistoryLong contains the column name definitions for table events_statements_history_long, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.events_statements_history_long (
// 		THREAD_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		EVENT_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		END_EVENT_ID	BIGINT(20) UNSIGNED,
// 		EVENT_NAME		VARCHAR(128) NOT NULL,
// 		SOURCE			VARCHAR(64),
// 		TIMER_START		BIGINT(20) UNSIGNED,
// 		TIMER_END		BIGINT(20) UNSIGNED,
// 		TIMER_WAIT		BIGINT(20) UNSIGNED,
// 		LOCK_TIME		BIGINT(20) UNSIGNED NOT NULL,
// 		SQL_TEXT		LONGTEXT,
// 		DIGEST			VARCHAR(32),
// 		DIGEST_TEXT		LONGTEXT,
// 		CURRENT_SCHEMA	VARCHAR(64),
// 		OBJECT_TYPE		VARCHAR(64),
// 		OBJECT_SCHEMA	VARCHAR(64),
// 		OBJECT_NAME		VARCHAR(64),
// 		OBJECT_INSTANCE_BEGIN	BIGINT(20) UNSIGNED,
// 		MYSQL_ERRNO		INT(11),
// 		RETURNED_SQLSTATE		VARCHAR(5),
// 		MESSAGE_TEXT	VARCHAR(128),
// 		ERRORS			BIGINT(20) UNSIGNED NOT NULL,
// 		WARNINGS		BIGINT(20) UNSIGNED NOT NULL,
// 		ROWS_AFFECTED	BIGINT(20) UNSIGNED NOT NULL,
// 		ROWS_SENT		BIGINT(20) UNSIGNED NOT NULL,
// 		ROWS_EXAMINED	BIGINT(20) UNSIGNED NOT NULL,
// 		CREATED_TMP_DISK_TABLES	BIGINT(20) UNSIGNED NOT NULL,
// 		CREATED_TMP_TABLES		BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_FULL_JOIN		BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_FULL_RANGE_JOIN	BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_RANGE	BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_RANGE_CHECK		BIGINT(20) UNSIGNED NOT NULL,
// 		SELECT_SCAN		BIGINT(20) UNSIGNED NOT NULL,
// 		SORT_MERGE_PASSES		BIGINT(20) UNSIGNED NOT NULL,
// 		SORT_RANGE		BIGINT(20) UNSIGNED NOT NULL,
// 		SORT_ROWS		BIGINT(20) UNSIGNED NOT NULL,
// 		SORT_SCAN		BIGINT(20) UNSIGNED NOT NULL,
// 		NO_INDEX_USED	BIGINT(20) UNSIGNED NOT NULL,
// 		NO_GOOD_INDEX_USED		BIGINT(20) UNSIGNED NOT NULL,
// 		NESTING_EVENT_ID		BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_TYPE		ENUM('TRANSACTION','STATEMENT','STAGE'),
// 		NESTING_EVENT_LEVEL		INT(11));
var columnStmtsHistoryLong = []string{
	"THREAD_ID",
	"EVENT_ID",
	"END_EVENT_ID",
	"EVENT_NAME",
	"SOURCE",
	"TIMER_START",
	"TIMER_END",
	"TIMER_WAIT",
	"LOCK_TIME",
	"SQL_TEXT",
	"DIGEST",
	"DIGEST_TEXT",
	"CURRENT_SCHEMA",
	"OBJECT_TYPE",
	"OBJECT_SCHEMA",
	"OBJECT_NAME",
	"OBJECT_INSTANCE_BEGIN",
	"MYSQL_ERRNO",
	"RETURNED_SQLSTATE",
	"MESSAGE_TEXT",
	"ERRORS",
	"WARNINGS",
	"ROWS_AFFECTED",
	"ROWS_SENT",
	"ROWS_EXAMINED",
	"CREATED_TMP_DISK_TABLES",
	"CREATED_TMP_TABLES",
	"SELECT_FULL_JOIN",
	"SELECT_FULL_RANGE_JOIN",
	"SELECT_RANGE",
	"SELECT_RANGE_CHECK",
	"SELECT_SCAN",
	"SORT_MERGE_PASSES",
	"SORT_RANGE",
	"SORT_ROWS",
	"SORT_SCAN",
	"NO_INDEX_USED",
	"NO_GOOD_INDEX_USED",
	"NESTING_EVENT_ID",
	"NESTING_EVENT_TYPE",
	"NESTING_EVENT_LEVEL",
}

// columnPreparedStmtsInstances contains the column name definitions for table prepared_statements_instances, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.prepared_statements_instances (
// 		OBJECT_INSTANCE_BEGIN	BIGINT(20) UNSIGNED NOT NULL,
// 		STATEMENT_ID	BIGINT(20) UNSIGNED NOT NULL,
// 		STATEMENT_NAME	VARCHAR(64),
// 		SQL_TEXT		LONGTEXT NOT NULL,
// 		OWNER_THREAD_ID	BIGINT(20) UNSIGNED NOT NULL,
// 		OWNER_EVENT_ID	BIGINT(20) UNSIGNED NOT NULL,
// 		OWNER_OBJECT_TYPE		ENUM('EVENT','FUNCTION','TABLE'),
// 		OWNER_OBJECT_SCHEMA		VARCHAR(64),
// 		OWNER_OBJECT_NAME		VARCHAR(64),
// 		TIMER_PREPARE	BIGINT(20) UNSIGNED NOT NULL,
// 		COUNT_REPREPARE	BIGINT(20) UNSIGNED NOT NULL,
// 		COUNT_EXECUTE	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_TIMER_EXECUTE		BIGINT(20) UNSIGNED NOT NULL,
// 		MIN_TIMER_EXECUTE		BIGINT(20) UNSIGNED NOT NULL,
// 		AVG_TIMER_EXECUTE		BIGINT(20) UNSIGNED NOT NULL,
// 		MAX_TIMER_EXECUTE		BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_LOCK_TIME	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_ERRORS		BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_WARNINGS	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_ROWS_AFFECTED		BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_ROWS_SENT	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_ROWS_EXAMINED		BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_CREATED_TMP_DISK_TABLES	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_CREATED_TMP_TABLES	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_SELECT_FULL_JOIN	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_SELECT_FULL_RANGE_JOIN	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_SELECT_RANGE		BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_SELECT_RANGE_CHECK	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_SELECT_SCAN	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_SORT_MERGE_PASSES	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_SORT_RANGE	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_SORT_ROWS	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_SORT_SCAN	BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_NO_INDEX_USED		BIGINT(20) UNSIGNED NOT NULL,
// 		SUM_NO_GOOD_INDEX_USED	BIGINT(20) UNSIGNED NOT NULL);
var columnPreparedStmtsInstances = []string{
	"OBJECT_INSTANCE_BEGIN",
	"STATEMENT_ID",
	"STATEMENT_NAME",
	"SQL_TEXT",
	"OWNER_THREAD_ID",
	"OWNER_EVENT_ID",
	"OWNER_OBJECT_TYPE",
	"OWNER_OBJECT_SCHEMA",
	"OWNER_OBJECT_NAME",
	"TIMER_PREPARE",
	"COUNT_REPREPARE",
	"COUNT_EXECUTE",
	"SUM_TIMER_EXECUTE",
	"MIN_TIMER_EXECUTE",
	"AVG_TIMER_EXECUTE",
	"MAX_TIMER_EXECUTE",
	"SUM_LOCK_TIME",
	"SUM_ERRORS",
	"SUM_WARNINGS",
	"SUM_ROWS_AFFECTED",
	"SUM_ROWS_SENT",
	"SUM_ROWS_EXAMINED",
	"SUM_CREATED_TMP_DISK_TABLES",
	"SUM_CREATED_TMP_TABLES",
	"SUM_SELECT_FULL_JOIN",
	"SUM_SELECT_FULL_RANGE_JOIN",
	"SUM_SELECT_RANGE",
	"SUM_SELECT_RANGE_CHECK",
	"SUM_SELECT_SCAN",
	"SUM_SORT_MERGE_PASSES",
	"SUM_SORT_RANGE",
	"SUM_SORT_ROWS",
	"SUM_SORT_SCAN",
	"SUM_NO_INDEX_USED",
	"SUM_NO_GOOD_INDEX_USED",
}

// columnTransCurrent contains the column name definitions for table events_transactions_current, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.events_transactions_current (
// 		THREAD_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		EVENT_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		END_EVENT_ID	BIGINT(20) UNSIGNED,
// 		EVENT_NAME		VARCHAR(128) NOT NULL,
// 		STATE			ENUM('ACTIVE','COMMITTED',"ROLLED BACK"),
// 		TRX_ID			BIGINT(20) UNSIGNED,
// 		GTID			VARCHAR(64),
// 		XID_FORMAT_ID	INT(11),
// 		XID_GTRID		VARCHAR(130),
// 		XID_BQUAL		VARCHAR(130),
// 		XA_STATE		VARCHAR(64),
// 		SOURCE			VARCHAR(64),
// 		TIMER_START		BIGINT(20) UNSIGNED,
// 		TIMER_END		BIGINT(20) UNSIGNED,
// 		TIMER_WAIT		BIGINT(20) UNSIGNED,
// 		ACCESS_MODE		ENUM('READ ONLY','READ WRITE'),
// 		ISOLATION_LEVEL	VARCHAR(64),
// 		AUTOCOMMIT		ENUM('YES','NO') NOT NULL,
// 		NUMBER_OF_SAVEPOINTS	BIGINT(20) UNSIGNED,
// 		NUMBER_OF_ROLLBACK_TO_SAVEPOINT	BIGINT(20) UNSIGNED,
// 		NUMBER_OF_RELEASE_SAVEPOINT		BIGINT(20) UNSIGNED,
// 		OBJECT_INSTANCE_BEGIN	BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_ID		BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_TYPE		ENUM('TRANSACTION','STATEMENT','STAGE'));
var columnTransCurrent = []string{
	"THREAD_ID",
	"EVENT_ID",
	"END_EVENT_ID",
	"EVENT_NAME",
	"STATE",
	"TRX_ID",
	"GTID",
	"XID_FORMAT_ID",
	"XID_GTRID",
	"XID_BQUAL",
	"XA_STATE",
	"SOURCE",
	"TIMER_START",
	"TIMER_END",
	"TIMER_WAIT",
	"ACCESS_MODE",
	"ISOLATION_LEVEL",
	"AUTOCOMMIT",
	"NUMBER_OF_SAVEPOINTS",
	"NUMBER_OF_ROLLBACK_TO_SAVEPOINT",
	"NUMBER_OF_RELEASE_SAVEPOINT",
	"OBJECT_INSTANCE_BEGIN",
	"NESTING_EVENT_ID",
	"NESTING_EVENT_TYPE",
}

// columnTransHistory contains the column name definitions for table events_transactions_history, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.events_transactions_history (
// 		THREAD_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		EVENT_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		END_EVENT_ID	BIGINT(20) UNSIGNED,
// 		EVENT_NAME		VARCHAR(128) NOT NULL,
// 		STATE			ENUM('ACTIVE','COMMITTED',"ROLLED BACK"),
// 		TRX_ID			BIGINT(20) UNSIGNED,
// 		GTID			VARCHAR(64),
// 		XID_FORMAT_ID	INT(11),
// 		XID_GTRID		VARCHAR(130),
// 		XID_BQUAL		VARCHAR(130),
// 		XA_STATE		VARCHAR(64),
// 		SOURCE			VARCHAR(64),
// 		TIMER_START		BIGINT(20) UNSIGNED,
// 		TIMER_END		BIGINT(20) UNSIGNED,
// 		TIMER_WAIT		BIGINT(20) UNSIGNED,
// 		ACCESS_MODE		ENUM('READ ONLY','READ WRITE'),
// 		ISOLATION_LEVEL	VARCHAR(64),
// 		AUTOCOMMIT		ENUM('YES','NO') NOT NULL,
// 		NUMBER_OF_SAVEPOINTS	BIGINT(20) UNSIGNED,
// 		NUMBER_OF_ROLLBACK_TO_SAVEPOINT	BIGINT(20) UNSIGNED,
// 		NUMBER_OF_RELEASE_SAVEPOINT		BIGINT(20) UNSIGNED,
// 		OBJECT_INSTANCE_BEGIN	BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_ID		BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_TYPE		ENUM('TRANSACTION','STATEMENT','STAGE'));
var columnTransHistory = []string{
	"THREAD_ID",
	"EVENT_ID",
	"END_EVENT_ID",
	"EVENT_NAME",
	"STATE",
	"TRX_ID",
	"GTID",
	"XID_FORMAT_ID",
	"XID_GTRID",
	"XID_BQUAL",
	"XA_STATE",
	"SOURCE",
	"TIMER_START",
	"TIMER_END",
	"TIMER_WAIT",
	"ACCESS_MODE",
	"ISOLATION_LEVEL",
	"AUTOCOMMIT",
	"NUMBER_OF_SAVEPOINTS",
	"NUMBER_OF_ROLLBACK_TO_SAVEPOINT",
	"NUMBER_OF_RELEASE_SAVEPOINT",
	"OBJECT_INSTANCE_BEGIN",
	"NESTING_EVENT_ID",
	"NESTING_EVENT_TYPE",
}

// columnTransHistoryLong contains the column name definitions for table events_transactions_history_long, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.events_transactions_history_long (
// 		THREAD_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		EVENT_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		END_EVENT_ID	BIGINT(20) UNSIGNED,
// 		EVENT_NAME		VARCHAR(128) NOT NULL,
// 		STATE			ENUM('ACTIVE','COMMITTED',"ROLLED BACK"),
// 		TRX_ID			BIGINT(20) UNSIGNED,
// 		GTID			VARCHAR(64),
// 		XID_FORMAT_ID	INT(11),
// 		XID_GTRID		VARCHAR(130),
// 		XID_BQUAL		VARCHAR(130),
// 		XA_STATE		VARCHAR(64),
// 		SOURCE			VARCHAR(64),
// 		TIMER_START		BIGINT(20) UNSIGNED,
// 		TIMER_END		BIGINT(20) UNSIGNED,
// 		TIMER_WAIT		BIGINT(20) UNSIGNED,
// 		ACCESS_MODE		ENUM('READ ONLY','READ WRITE'),
// 		ISOLATION_LEVEL	VARCHAR(64),
// 		AUTOCOMMIT		ENUM('YES','NO') NOT NULL,
// 		NUMBER_OF_SAVEPOINTS	BIGINT(20) UNSIGNED,
// 		NUMBER_OF_ROLLBACK_TO_SAVEPOINT	BIGINT(20) UNSIGNED,
// 		NUMBER_OF_RELEASE_SAVEPOINT		BIGINT(20) UNSIGNED,
// 		OBJECT_INSTANCE_BEGIN	BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_ID		BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_TYPE		ENUM('TRANSACTION','STATEMENT','STAGE'));
var columnTransHistoryLong = []string{
	"THREAD_ID",
	"EVENT_ID",
	"END_EVENT_ID",
	"EVENT_NAME",
	"STATE",
	"TRX_ID",
	"GTID",
	"XID_FORMAT_ID",
	"XID_GTRID",
	"XID_BQUAL",
	"XA_STATE",
	"SOURCE",
	"TIMER_START",
	"TIMER_END",
	"TIMER_WAIT",
	"ACCESS_MODE",
	"ISOLATION_LEVEL",
	"AUTOCOMMIT",
	"NUMBER_OF_SAVEPOINTS",
	"NUMBER_OF_ROLLBACK_TO_SAVEPOINT",
	"NUMBER_OF_RELEASE_SAVEPOINT",
	"OBJECT_INSTANCE_BEGIN",
	"NESTING_EVENT_ID",
	"NESTING_EVENT_TYPE",
}

// columnStagesCurrent contains the column name definitions for table events_stages_current, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.events_stages_current (
// 		THREAD_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		EVENT_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		END_EVENT_ID	BIGINT(20) UNSIGNED,
// 		EVENT_NAME		VARCHAR(128) NOT NULL,
// 		SOURCE			VARCHAR(64),
// 		TIMER_START		BIGINT(20) UNSIGNED,
// 		TIMER_END		BIGINT(20) UNSIGNED,
// 		TIMER_WAIT		BIGINT(20) UNSIGNED,
// 		WORK_COMPLETED	BIGINT(20) UNSIGNED,
// 		WORK_ESTIMATED	BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_ID		BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_TYPE		ENUM('TRANSACTION','STATEMENT','STAGE'));
var columnStagesCurrent = []string{
	"THREAD_ID",
	"EVENT_ID",
	"END_EVENT_ID",
	"EVENT_NAME",
	"SOURCE",
	"TIMER_START",
	"TIMER_END",
	"TIMER_WAIT",
	"WORK_COMPLETED",
	"WORK_ESTIMATED",
	"NESTING_EVENT_ID",
	"NESTING_EVENT_TYPE",
}

// columnStagesHistory contains the column name definitions for table events_stages_history, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.events_stages_history (
// 		THREAD_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		EVENT_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		END_EVENT_ID	BIGINT(20) UNSIGNED,
// 		EVENT_NAME		VARCHAR(128) NOT NULL,
// 		SOURCE			VARCHAR(64),
// 		TIMER_START		BIGINT(20) UNSIGNED,
// 		TIMER_END		BIGINT(20) UNSIGNED,
// 		TIMER_WAIT		BIGINT(20) UNSIGNED,
// 		WORK_COMPLETED	BIGINT(20) UNSIGNED,
// 		WORK_ESTIMATED	BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_ID		BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_TYPE		ENUM('TRANSACTION','STATEMENT','STAGE'));
var columnStagesHistory = []string{
	"THREAD_ID",
	"EVENT_ID",
	"END_EVENT_ID",
	"EVENT_NAME",
	"SOURCE",
	"TIMER_START",
	"TIMER_END",
	"TIMER_WAIT",
	"WORK_COMPLETED",
	"WORK_ESTIMATED",
	"NESTING_EVENT_ID",
	"NESTING_EVENT_TYPE",
}

// columnStagesHistoryLong contains the column name definitions for table events_stages_history_long, same as MySQL.
//
// CREATE TABLE if not exists performance_schema.events_stages_history_long (
// 		THREAD_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		EVENT_ID		BIGINT(20) UNSIGNED NOT NULL,
// 		END_EVENT_ID	BIGINT(20) UNSIGNED,
// 		EVENT_NAME		VARCHAR(128) NOT NULL,
// 		SOURCE			VARCHAR(64),
// 		TIMER_START		BIGINT(20) UNSIGNED,
// 		TIMER_END		BIGINT(20) UNSIGNED,
// 		TIMER_WAIT		BIGINT(20) UNSIGNED,
// 		WORK_COMPLETED	BIGINT(20) UNSIGNED,
// 		WORK_ESTIMATED	BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_ID		BIGINT(20) UNSIGNED,
// 		NESTING_EVENT_TYPE		ENUM('TRANSACTION','STATEMENT','STAGE'));
var columnStagesHistoryLong = []string{
	"THREAD_ID",
	"EVENT_ID",
	"END_EVENT_ID",
	"EVENT_NAME",
	"SOURCE",
	"TIMER_START",
	"TIMER_END",
	"TIMER_WAIT",
	"WORK_COMPLETED",
	"WORK_ESTIMATED",
	"NESTING_EVENT_ID",
	"NESTING_EVENT_TYPE",
}
