// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: select.proto

package tipb

import (
	"fmt"

	proto "github.com/golang/protobuf/proto"

	math "math"

	github_com_pingcap_tipb_sharedbytes "github.com/pingcap/tipb/sharedbytes"

	io "io"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type EncodeType int32

const (
	EncodeType_TypeDefault EncodeType = 0
	EncodeType_TypeArrow   EncodeType = 1
)

var EncodeType_name = map[int32]string{
	0: "TypeDefault",
	1: "TypeArrow",
}
var EncodeType_value = map[string]int32{
	"TypeDefault": 0,
	"TypeArrow":   1,
}

func (x EncodeType) Enum() *EncodeType {
	p := new(EncodeType)
	*p = x
	return p
}
func (x EncodeType) String() string {
	return proto.EnumName(EncodeType_name, int32(x))
}
func (x *EncodeType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(EncodeType_value, data, "EncodeType")
	if err != nil {
		return err
	}
	*x = EncodeType(value)
	return nil
}
func (EncodeType) EnumDescriptor() ([]byte, []int) { return fileDescriptorSelect, []int{0} }

// values are all in text format.
type Row struct {
	Handle           []byte `protobuf:"bytes,1,opt,name=handle" json:"handle,omitempty"`
	Data             []byte `protobuf:"bytes,2,opt,name=data" json:"data,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Row) Reset()                    { *m = Row{} }
func (m *Row) String() string            { return proto.CompactTextString(m) }
func (*Row) ProtoMessage()               {}
func (*Row) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{0} }

func (m *Row) GetHandle() []byte {
	if m != nil {
		return m.Handle
	}
	return nil
}

func (m *Row) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type Error struct {
	Code             int32  `protobuf:"varint,1,opt,name=code" json:"code"`
	Msg              string `protobuf:"bytes,2,opt,name=msg" json:"msg"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Error) Reset()                    { *m = Error{} }
func (m *Error) String() string            { return proto.CompactTextString(m) }
func (*Error) ProtoMessage()               {}
func (*Error) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{1} }

func (m *Error) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *Error) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

// Response for SelectRequest.
type SelectResponse struct {
	Error *Error `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// Result rows.
	Rows []*Row `protobuf:"bytes,2,rep,name=rows" json:"rows,omitempty"`
	// Use multiple chunks to reduce memory allocation and
	// avoid allocating large contiguous memory.
	Chunks           []Chunk  `protobuf:"bytes,3,rep,name=chunks" json:"chunks"`
	Warnings         []*Error `protobuf:"bytes,4,rep,name=warnings" json:"warnings,omitempty"`
	OutputCounts     []int64  `protobuf:"varint,5,rep,name=output_counts,json=outputCounts" json:"output_counts,omitempty"`
	WarningCount     *int64   `protobuf:"varint,6,opt,name=warning_count,json=warningCount" json:"warning_count,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *SelectResponse) Reset()                    { *m = SelectResponse{} }
func (m *SelectResponse) String() string            { return proto.CompactTextString(m) }
func (*SelectResponse) ProtoMessage()               {}
func (*SelectResponse) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{2} }

func (m *SelectResponse) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *SelectResponse) GetRows() []*Row {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (m *SelectResponse) GetChunks() []Chunk {
	if m != nil {
		return m.Chunks
	}
	return nil
}

func (m *SelectResponse) GetWarnings() []*Error {
	if m != nil {
		return m.Warnings
	}
	return nil
}

func (m *SelectResponse) GetOutputCounts() []int64 {
	if m != nil {
		return m.OutputCounts
	}
	return nil
}

func (m *SelectResponse) GetWarningCount() int64 {
	if m != nil && m.WarningCount != nil {
		return *m.WarningCount
	}
	return 0
}

// Chunk contains multiple rows data and rows meta.
type Chunk struct {
	// Data for all rows in the chunk.
	RowsData github_com_pingcap_tipb_sharedbytes.SharedBytes `protobuf:"bytes,3,opt,name=rows_data,json=rowsData,customtype=github.com/pingcap/tipb/sharedbytes.SharedBytes" json:"rows_data"`
	// Meta data for every row.
	RowsMeta         []RowMeta `protobuf:"bytes,4,rep,name=rows_meta,json=rowsMeta" json:"rows_meta"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *Chunk) Reset()                    { *m = Chunk{} }
func (m *Chunk) String() string            { return proto.CompactTextString(m) }
func (*Chunk) ProtoMessage()               {}
func (*Chunk) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{3} }

func (m *Chunk) GetRowsMeta() []RowMeta {
	if m != nil {
		return m.RowsMeta
	}
	return nil
}

// RowMeta contains row handle and length of a row.
type RowMeta struct {
	Handle           int64  `protobuf:"varint,1,opt,name=handle" json:"handle"`
	Length           int64  `protobuf:"varint,2,opt,name=length" json:"length"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RowMeta) Reset()                    { *m = RowMeta{} }
func (m *RowMeta) String() string            { return proto.CompactTextString(m) }
func (*RowMeta) ProtoMessage()               {}
func (*RowMeta) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{4} }

func (m *RowMeta) GetHandle() int64 {
	if m != nil {
		return m.Handle
	}
	return 0
}

func (m *RowMeta) GetLength() int64 {
	if m != nil {
		return m.Length
	}
	return 0
}

// DAGRequest represents the request that will be handled with DAG mode.
type DAGRequest struct {
	// Transaction start timestamp.
	StartTs uint64 `protobuf:"varint,1,opt,name=start_ts,json=startTs" json:"start_ts"`
	// It represents push down Executors.
	Executors []*Executor `protobuf:"bytes,2,rep,name=executors" json:"executors,omitempty"`
	// time zone offset in seconds
	TimeZoneOffset int64 `protobuf:"varint,3,opt,name=time_zone_offset,json=timeZoneOffset" json:"time_zone_offset"`
	// flags are used to store flags that change the execution mode, it contains:
	// 	ignore_truncate = 1
	// 		truncate error should be ignore if set.
	// 	truncate_as_warning = 1 << 1
	// 		when ignored_truncate is not set, return warning instead of error if this flag is set.
	// 	...
	// 	add more when needed.
	Flags uint64 `protobuf:"varint,4,opt,name=flags" json:"flags"`
	// It represents which columns we should output.
	OutputOffsets []uint32 `protobuf:"varint,5,rep,name=output_offsets,json=outputOffsets" json:"output_offsets,omitempty"`
	// It represents whether we collect the detailed scan counts in each range.
	CollectRangeCounts *bool `protobuf:"varint,6,opt,name=collect_range_counts,json=collectRangeCounts" json:"collect_range_counts,omitempty"`
	// It indicates the maximum number of warning,
	// which is the number of messages that SHOW WARNINGS displays.
	MaxWarningCount  *uint64 `protobuf:"varint,7,opt,name=max_warning_count,json=maxWarningCount" json:"max_warning_count,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *DAGRequest) Reset()                    { *m = DAGRequest{} }
func (m *DAGRequest) String() string            { return proto.CompactTextString(m) }
func (*DAGRequest) ProtoMessage()               {}
func (*DAGRequest) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{5} }

func (m *DAGRequest) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *DAGRequest) GetExecutors() []*Executor {
	if m != nil {
		return m.Executors
	}
	return nil
}

func (m *DAGRequest) GetTimeZoneOffset() int64 {
	if m != nil {
		return m.TimeZoneOffset
	}
	return 0
}

func (m *DAGRequest) GetFlags() uint64 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *DAGRequest) GetOutputOffsets() []uint32 {
	if m != nil {
		return m.OutputOffsets
	}
	return nil
}

func (m *DAGRequest) GetCollectRangeCounts() bool {
	if m != nil && m.CollectRangeCounts != nil {
		return *m.CollectRangeCounts
	}
	return false
}

func (m *DAGRequest) GetMaxWarningCount() uint64 {
	if m != nil && m.MaxWarningCount != nil {
		return *m.MaxWarningCount
	}
	return 0
}

type StreamResponse struct {
	Error      *Error     `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	EncodeType EncodeType `protobuf:"varint,2,opt,name=encode_type,json=encodeType,enum=tipb.EncodeType" json:"encode_type"`
	// Data for all rows
	Data     github_com_pingcap_tipb_sharedbytes.SharedBytes `protobuf:"bytes,3,opt,name=data,customtype=github.com/pingcap/tipb/sharedbytes.SharedBytes" json:"data"`
	Warnings []*Error                                        `protobuf:"bytes,4,rep,name=warnings" json:"warnings,omitempty"`
	// output row count for each executor
	OutputCounts     []int64 `protobuf:"varint,5,rep,name=output_counts,json=outputCounts" json:"output_counts,omitempty"`
	WarningCount     *int64  `protobuf:"varint,6,opt,name=warning_count,json=warningCount" json:"warning_count,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *StreamResponse) Reset()                    { *m = StreamResponse{} }
func (m *StreamResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamResponse) ProtoMessage()               {}
func (*StreamResponse) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{6} }

func (m *StreamResponse) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *StreamResponse) GetEncodeType() EncodeType {
	if m != nil {
		return m.EncodeType
	}
	return EncodeType_TypeDefault
}

func (m *StreamResponse) GetWarnings() []*Error {
	if m != nil {
		return m.Warnings
	}
	return nil
}

func (m *StreamResponse) GetOutputCounts() []int64 {
	if m != nil {
		return m.OutputCounts
	}
	return nil
}

func (m *StreamResponse) GetWarningCount() int64 {
	if m != nil && m.WarningCount != nil {
		return *m.WarningCount
	}
	return 0
}

func init() {
	proto.RegisterType((*Row)(nil), "tipb.Row")
	proto.RegisterType((*Error)(nil), "tipb.Error")
	proto.RegisterType((*SelectResponse)(nil), "tipb.SelectResponse")
	proto.RegisterType((*Chunk)(nil), "tipb.Chunk")
	proto.RegisterType((*RowMeta)(nil), "tipb.RowMeta")
	proto.RegisterType((*DAGRequest)(nil), "tipb.DAGRequest")
	proto.RegisterType((*StreamResponse)(nil), "tipb.StreamResponse")
	proto.RegisterEnum("tipb.EncodeType", EncodeType_name, EncodeType_value)
}
func (m *Row) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Row) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Handle != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSelect(dAtA, i, uint64(len(m.Handle)))
		i += copy(dAtA[i:], m.Handle)
	}
	if m.Data != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintSelect(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Error) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Error) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.Code))
	dAtA[i] = 0x12
	i++
	i = encodeVarintSelect(dAtA, i, uint64(len(m.Msg)))
	i += copy(dAtA[i:], m.Msg)
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SelectResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SelectResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Error != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSelect(dAtA, i, uint64(m.Error.Size()))
		n1, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.Rows) > 0 {
		for _, msg := range m.Rows {
			dAtA[i] = 0x12
			i++
			i = encodeVarintSelect(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Chunks) > 0 {
		for _, msg := range m.Chunks {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintSelect(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Warnings) > 0 {
		for _, msg := range m.Warnings {
			dAtA[i] = 0x22
			i++
			i = encodeVarintSelect(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.OutputCounts) > 0 {
		for _, num := range m.OutputCounts {
			dAtA[i] = 0x28
			i++
			i = encodeVarintSelect(dAtA, i, uint64(num))
		}
	}
	if m.WarningCount != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintSelect(dAtA, i, uint64(*m.WarningCount))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Chunk) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Chunk) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x1a
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.RowsData.Size()))
	n2, err := m.RowsData.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if len(m.RowsMeta) > 0 {
		for _, msg := range m.RowsMeta {
			dAtA[i] = 0x22
			i++
			i = encodeVarintSelect(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RowMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RowMeta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.Handle))
	dAtA[i] = 0x10
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.Length))
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DAGRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DAGRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.StartTs))
	if len(m.Executors) > 0 {
		for _, msg := range m.Executors {
			dAtA[i] = 0x12
			i++
			i = encodeVarintSelect(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x18
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.TimeZoneOffset))
	dAtA[i] = 0x20
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.Flags))
	if len(m.OutputOffsets) > 0 {
		for _, num := range m.OutputOffsets {
			dAtA[i] = 0x28
			i++
			i = encodeVarintSelect(dAtA, i, uint64(num))
		}
	}
	if m.CollectRangeCounts != nil {
		dAtA[i] = 0x30
		i++
		if *m.CollectRangeCounts {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.MaxWarningCount != nil {
		dAtA[i] = 0x38
		i++
		i = encodeVarintSelect(dAtA, i, uint64(*m.MaxWarningCount))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StreamResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StreamResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Error != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSelect(dAtA, i, uint64(m.Error.Size()))
		n3, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	dAtA[i] = 0x10
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.EncodeType))
	dAtA[i] = 0x1a
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.Data.Size()))
	n4, err := m.Data.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	if len(m.Warnings) > 0 {
		for _, msg := range m.Warnings {
			dAtA[i] = 0x22
			i++
			i = encodeVarintSelect(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.OutputCounts) > 0 {
		for _, num := range m.OutputCounts {
			dAtA[i] = 0x28
			i++
			i = encodeVarintSelect(dAtA, i, uint64(num))
		}
	}
	if m.WarningCount != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintSelect(dAtA, i, uint64(*m.WarningCount))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeFixed64Select(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Select(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintSelect(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Row) Size() (n int) {
	var l int
	_ = l
	if m.Handle != nil {
		l = len(m.Handle)
		n += 1 + l + sovSelect(uint64(l))
	}
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovSelect(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Error) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovSelect(uint64(m.Code))
	l = len(m.Msg)
	n += 1 + l + sovSelect(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SelectResponse) Size() (n int) {
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovSelect(uint64(l))
	}
	if len(m.Rows) > 0 {
		for _, e := range m.Rows {
			l = e.Size()
			n += 1 + l + sovSelect(uint64(l))
		}
	}
	if len(m.Chunks) > 0 {
		for _, e := range m.Chunks {
			l = e.Size()
			n += 1 + l + sovSelect(uint64(l))
		}
	}
	if len(m.Warnings) > 0 {
		for _, e := range m.Warnings {
			l = e.Size()
			n += 1 + l + sovSelect(uint64(l))
		}
	}
	if len(m.OutputCounts) > 0 {
		for _, e := range m.OutputCounts {
			n += 1 + sovSelect(uint64(e))
		}
	}
	if m.WarningCount != nil {
		n += 1 + sovSelect(uint64(*m.WarningCount))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Chunk) Size() (n int) {
	var l int
	_ = l
	l = m.RowsData.Size()
	n += 1 + l + sovSelect(uint64(l))
	if len(m.RowsMeta) > 0 {
		for _, e := range m.RowsMeta {
			l = e.Size()
			n += 1 + l + sovSelect(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RowMeta) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovSelect(uint64(m.Handle))
	n += 1 + sovSelect(uint64(m.Length))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DAGRequest) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovSelect(uint64(m.StartTs))
	if len(m.Executors) > 0 {
		for _, e := range m.Executors {
			l = e.Size()
			n += 1 + l + sovSelect(uint64(l))
		}
	}
	n += 1 + sovSelect(uint64(m.TimeZoneOffset))
	n += 1 + sovSelect(uint64(m.Flags))
	if len(m.OutputOffsets) > 0 {
		for _, e := range m.OutputOffsets {
			n += 1 + sovSelect(uint64(e))
		}
	}
	if m.CollectRangeCounts != nil {
		n += 2
	}
	if m.MaxWarningCount != nil {
		n += 1 + sovSelect(uint64(*m.MaxWarningCount))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StreamResponse) Size() (n int) {
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovSelect(uint64(l))
	}
	n += 1 + sovSelect(uint64(m.EncodeType))
	l = m.Data.Size()
	n += 1 + l + sovSelect(uint64(l))
	if len(m.Warnings) > 0 {
		for _, e := range m.Warnings {
			l = e.Size()
			n += 1 + l + sovSelect(uint64(l))
		}
	}
	if len(m.OutputCounts) > 0 {
		for _, e := range m.OutputCounts {
			n += 1 + sovSelect(uint64(e))
		}
	}
	if m.WarningCount != nil {
		n += 1 + sovSelect(uint64(*m.WarningCount))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSelect(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozSelect(x uint64) (n int) {
	return sovSelect(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Row) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Row: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Row: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Handle", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Handle = append(m.Handle[:0], dAtA[iNdEx:postIndex]...)
			if m.Handle == nil {
				m.Handle = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Error) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Error: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Error: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SelectResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SelectResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SelectResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rows = append(m.Rows, &Row{})
			if err := m.Rows[len(m.Rows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Chunks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Chunks = append(m.Chunks, Chunk{})
			if err := m.Chunks[len(m.Chunks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, &Error{})
			if err := m.Warnings[len(m.Warnings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.OutputCounts = append(m.OutputCounts, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthSelect
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSelect
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.OutputCounts = append(m.OutputCounts, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputCounts", wireType)
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WarningCount", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WarningCount = &v
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Chunk) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Chunk: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Chunk: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RowsData", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RowsData.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RowsMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RowsMeta = append(m.RowsMeta, RowMeta{})
			if err := m.RowsMeta[len(m.RowsMeta)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RowMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RowMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RowMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Handle", wireType)
			}
			m.Handle = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Handle |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Length", wireType)
			}
			m.Length = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Length |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DAGRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DAGRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DAGRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Executors = append(m.Executors, &Executor{})
			if err := m.Executors[len(m.Executors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeZoneOffset", wireType)
			}
			m.TimeZoneOffset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeZoneOffset |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.OutputOffsets = append(m.OutputOffsets, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthSelect
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSelect
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.OutputOffsets = append(m.OutputOffsets, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputOffsets", wireType)
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CollectRangeCounts", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.CollectRangeCounts = &b
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxWarningCount", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MaxWarningCount = &v
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StreamResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StreamResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StreamResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodeType", wireType)
			}
			m.EncodeType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EncodeType |= (EncodeType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, &Error{})
			if err := m.Warnings[len(m.Warnings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.OutputCounts = append(m.OutputCounts, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthSelect
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSelect
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.OutputCounts = append(m.OutputCounts, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputCounts", wireType)
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WarningCount", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WarningCount = &v
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSelect(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthSelect
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipSelect(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthSelect = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSelect   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("select.proto", fileDescriptorSelect) }

var fileDescriptorSelect = []byte{
	// 662 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x53, 0xc1, 0x4e, 0x13, 0x41,
	0x18, 0x66, 0xbb, 0x6d, 0x69, 0xff, 0xd2, 0xa5, 0x4e, 0x90, 0x6c, 0x08, 0x96, 0x5a, 0x63, 0x04,
	0x42, 0xb6, 0xc8, 0x85, 0x78, 0xa4, 0x40, 0x3c, 0x18, 0xa3, 0x19, 0x48, 0x4c, 0xbc, 0x6c, 0xa6,
	0xdb, 0xe9, 0xb6, 0xb1, 0xbb, 0xb3, 0xee, 0xcc, 0xa6, 0xe0, 0x4b, 0x78, 0xf5, 0x21, 0x78, 0x10,
	0x8e, 0x9e, 0x3d, 0x10, 0x83, 0x2f, 0xe0, 0x23, 0x98, 0xf9, 0x67, 0x5a, 0xe0, 0x68, 0x3c, 0x78,
	0xda, 0xd9, 0xef, 0xfb, 0xe6, 0x9f, 0x6f, 0xfe, 0xef, 0x1f, 0x58, 0x91, 0x7c, 0xca, 0x23, 0x15,
	0x64, 0xb9, 0x50, 0x82, 0x94, 0xd5, 0x24, 0x1b, 0x6c, 0x78, 0xfc, 0x82, 0x47, 0x85, 0x12, 0xb9,
	0x41, 0x37, 0xd6, 0x62, 0x11, 0x0b, 0x5c, 0xf6, 0xf4, 0xca, 0xa0, 0xdd, 0x97, 0xe0, 0x52, 0x31,
	0x23, 0xeb, 0x50, 0x1d, 0xb3, 0x74, 0x38, 0xe5, 0xbe, 0xd3, 0x71, 0xb6, 0x57, 0xa8, 0xfd, 0x23,
	0x04, 0xca, 0x43, 0xa6, 0x98, 0x5f, 0x42, 0x14, 0xd7, 0xdd, 0x57, 0x50, 0x39, 0xcd, 0x73, 0x91,
	0x13, 0x1f, 0xca, 0x91, 0x18, 0x9a, 0x2d, 0x95, 0x7e, 0xf9, 0xfa, 0x66, 0x6b, 0x89, 0x22, 0x42,
	0xd6, 0xc1, 0x4d, 0x64, 0x8c, 0xbb, 0xea, 0x96, 0xd0, 0x40, 0xf7, 0xb7, 0x03, 0xde, 0x19, 0x5a,
	0xa5, 0x5c, 0x66, 0x22, 0x95, 0x9c, 0x3c, 0x85, 0x0a, 0xd7, 0xd5, 0xb0, 0x4a, 0xe3, 0xa0, 0x11,
	0x68, 0xf3, 0x01, 0x1e, 0x40, 0x0d, 0x43, 0x9e, 0x40, 0x39, 0x17, 0x33, 0xe9, 0x97, 0x3a, 0xee,
	0x76, 0xe3, 0xa0, 0x6e, 0x14, 0x54, 0xcc, 0x28, 0xc2, 0x64, 0x07, 0xaa, 0xd1, 0xb8, 0x48, 0x3f,
	0x49, 0xdf, 0x45, 0x81, 0x2d, 0x71, 0xac, 0x31, 0x7b, 0xb8, 0x15, 0x90, 0x17, 0x50, 0x9b, 0xb1,
	0x3c, 0x9d, 0xa4, 0xb1, 0xf4, 0xcb, 0xf7, 0xc5, 0xe6, 0xbc, 0x05, 0x49, 0x9e, 0x41, 0x53, 0x14,
	0x2a, 0x2b, 0x54, 0x18, 0x89, 0x22, 0x55, 0xd2, 0xaf, 0x74, 0xdc, 0x6d, 0x97, 0xae, 0x18, 0xf0,
	0x18, 0x31, 0x2d, 0xb2, 0x1b, 0x8c, 0xca, 0xaf, 0x76, 0x1c, 0x2d, 0xb2, 0x20, 0xaa, 0xba, 0x5f,
	0x1d, 0xa8, 0xa0, 0x15, 0x72, 0x0e, 0x75, 0xed, 0x37, 0xc4, 0x86, 0xba, 0xba, 0xa1, 0xfd, 0x43,
	0xed, 0xee, 0xc7, 0xcd, 0x56, 0x2f, 0x9e, 0xa8, 0x71, 0x31, 0x08, 0x22, 0x91, 0xf4, 0xb2, 0x49,
	0x1a, 0x47, 0x2c, 0xeb, 0x69, 0x5f, 0x3d, 0x39, 0x66, 0x39, 0x1f, 0x0e, 0x2e, 0x15, 0x97, 0xc1,
	0x19, 0xae, 0xfb, 0x7a, 0x4d, 0x6b, 0xba, 0xd2, 0x09, 0x53, 0x8c, 0xec, 0xdb, 0xaa, 0x09, 0x57,
	0xcc, 0xde, 0xa9, 0xb9, 0xe8, 0xd0, 0x5b, 0xae, 0x98, 0x6d, 0x01, 0xee, 0xd0, 0xff, 0xdd, 0x53,
	0x58, 0xb6, 0x14, 0xd9, 0x7c, 0x10, 0xbb, 0x3b, 0xef, 0x96, 0x0d, 0x7f, 0x13, 0xaa, 0x53, 0x9e,
	0xc6, 0x6a, 0x8c, 0x41, 0x2e, 0x58, 0x83, 0x75, 0xaf, 0x4a, 0x00, 0x27, 0x47, 0xaf, 0x29, 0xff,
	0x5c, 0x70, 0xa9, 0xc8, 0x16, 0xd4, 0xa4, 0x62, 0xb9, 0x0a, 0x95, 0xc4, 0x62, 0x65, 0x2b, 0x5f,
	0x46, 0xf4, 0x5c, 0x92, 0x3d, 0xa8, 0xcf, 0x27, 0x72, 0x1e, 0xa5, 0x67, 0x9b, 0x6f, 0x61, 0x7a,
	0x27, 0x20, 0x01, 0xb4, 0xd4, 0x24, 0xe1, 0xe1, 0x17, 0x91, 0xf2, 0x50, 0x8c, 0x46, 0x92, 0x2b,
	0xec, 0xd9, 0xdc, 0x85, 0xa7, 0xd9, 0x8f, 0x22, 0xe5, 0xef, 0x90, 0x23, 0x1b, 0x50, 0x19, 0x4d,
	0x19, 0xc6, 0x7a, 0x77, 0xb6, 0x81, 0xc8, 0x73, 0xf0, 0x6c, 0x98, 0xa6, 0x90, 0x49, 0xb3, 0x49,
	0x6d, 0xc4, 0xa6, 0x82, 0x24, 0xfb, 0xb0, 0x16, 0x89, 0xa9, 0x1e, 0xce, 0x30, 0x67, 0x69, 0xcc,
	0xe7, 0xd1, 0xeb, 0x54, 0x6b, 0x94, 0x58, 0x8e, 0x6a, 0xca, 0x0e, 0xc0, 0x2e, 0x3c, 0x4a, 0xd8,
	0x45, 0xf8, 0x70, 0x08, 0x96, 0xb5, 0x01, 0xba, 0x9a, 0xb0, 0x8b, 0x0f, 0xf7, 0xe7, 0xe0, 0xaa,
	0x04, 0xde, 0x99, 0xca, 0x39, 0x4b, 0xfe, 0x66, 0xf4, 0x0f, 0xa1, 0xc1, 0x53, 0xfd, 0xa4, 0x42,
	0x75, 0x99, 0x71, 0xcc, 0xc1, 0x3b, 0x68, 0x59, 0x21, 0x12, 0xe7, 0x97, 0x19, 0xb7, 0xd7, 0x05,
	0xbe, 0x40, 0xc8, 0x1b, 0xfb, 0x70, 0xff, 0x71, 0xce, 0xb0, 0xc8, 0x7f, 0x78, 0x36, 0xbb, 0x7b,
	0x00, 0x77, 0xf7, 0x23, 0xab, 0xd0, 0xd0, 0xdf, 0x13, 0x3e, 0x62, 0xc5, 0x54, 0xb5, 0x96, 0x48,
	0x13, 0xea, 0x1a, 0x38, 0xca, 0x73, 0x31, 0x6b, 0x39, 0xfd, 0x9d, 0xeb, 0xdb, 0xb6, 0xf3, 0xfd,
	0xb6, 0xed, 0xfc, 0xbc, 0x6d, 0x3b, 0xdf, 0x7e, 0xb5, 0x97, 0xe0, 0x71, 0x24, 0x92, 0xc0, 0x5e,
	0x31, 0x50, 0x93, 0xe1, 0x00, 0x0d, 0xbf, 0x77, 0xfe, 0x04, 0x00, 0x00, 0xff, 0xff, 0xc4, 0xab,
	0x16, 0x40, 0x2b, 0x05, 0x00, 0x00,
}
