// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: executor.proto

package tipb

import (
	"fmt"

	proto "github.com/golang/protobuf/proto"

	math "math"

	io "io"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type ExecType int32

const (
	ExecType_TypeTableScan   ExecType = 0
	ExecType_TypeIndexScan   ExecType = 1
	ExecType_TypeSelection   ExecType = 2
	ExecType_TypeAggregation ExecType = 3
	ExecType_TypeTopN        ExecType = 4
	ExecType_TypeLimit       ExecType = 5
	ExecType_TypeStreamAgg   ExecType = 6
)

var ExecType_name = map[int32]string{
	0: "TypeTableScan",
	1: "TypeIndexScan",
	2: "TypeSelection",
	3: "TypeAggregation",
	4: "TypeTopN",
	5: "TypeLimit",
	6: "TypeStreamAgg",
}
var ExecType_value = map[string]int32{
	"TypeTableScan":   0,
	"TypeIndexScan":   1,
	"TypeSelection":   2,
	"TypeAggregation": 3,
	"TypeTopN":        4,
	"TypeLimit":       5,
	"TypeStreamAgg":   6,
}

func (x ExecType) Enum() *ExecType {
	p := new(ExecType)
	*p = x
	return p
}
func (x ExecType) String() string {
	return proto.EnumName(ExecType_name, int32(x))
}
func (x *ExecType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ExecType_value, data, "ExecType")
	if err != nil {
		return err
	}
	*x = ExecType(value)
	return nil
}
func (ExecType) EnumDescriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{0} }

// It represents a Executor.
type Executor struct {
	Tp               ExecType     `protobuf:"varint,1,opt,name=tp,enum=tipb.ExecType" json:"tp"`
	TblScan          *TableScan   `protobuf:"bytes,2,opt,name=tbl_scan,json=tblScan" json:"tbl_scan,omitempty"`
	IdxScan          *IndexScan   `protobuf:"bytes,3,opt,name=idx_scan,json=idxScan" json:"idx_scan,omitempty"`
	Selection        *Selection   `protobuf:"bytes,4,opt,name=selection" json:"selection,omitempty"`
	Aggregation      *Aggregation `protobuf:"bytes,5,opt,name=aggregation" json:"aggregation,omitempty"`
	TopN             *TopN        `protobuf:"bytes,6,opt,name=topN" json:"topN,omitempty"`
	Limit            *Limit       `protobuf:"bytes,7,opt,name=limit" json:"limit,omitempty"`
	StreamAgg        *Aggregation `protobuf:"bytes,8,opt,name=stream_agg,json=streamAgg" json:"stream_agg,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *Executor) Reset()                    { *m = Executor{} }
func (m *Executor) String() string            { return proto.CompactTextString(m) }
func (*Executor) ProtoMessage()               {}
func (*Executor) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{0} }

func (m *Executor) GetTp() ExecType {
	if m != nil {
		return m.Tp
	}
	return ExecType_TypeTableScan
}

func (m *Executor) GetTblScan() *TableScan {
	if m != nil {
		return m.TblScan
	}
	return nil
}

func (m *Executor) GetIdxScan() *IndexScan {
	if m != nil {
		return m.IdxScan
	}
	return nil
}

func (m *Executor) GetSelection() *Selection {
	if m != nil {
		return m.Selection
	}
	return nil
}

func (m *Executor) GetAggregation() *Aggregation {
	if m != nil {
		return m.Aggregation
	}
	return nil
}

func (m *Executor) GetTopN() *TopN {
	if m != nil {
		return m.TopN
	}
	return nil
}

func (m *Executor) GetLimit() *Limit {
	if m != nil {
		return m.Limit
	}
	return nil
}

func (m *Executor) GetStreamAgg() *Aggregation {
	if m != nil {
		return m.StreamAgg
	}
	return nil
}

type TableScan struct {
	TableId          int64         `protobuf:"varint,1,opt,name=table_id,json=tableId" json:"table_id"`
	Columns          []*ColumnInfo `protobuf:"bytes,2,rep,name=columns" json:"columns,omitempty"`
	Desc             bool          `protobuf:"varint,3,opt,name=desc" json:"desc"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *TableScan) Reset()                    { *m = TableScan{} }
func (m *TableScan) String() string            { return proto.CompactTextString(m) }
func (*TableScan) ProtoMessage()               {}
func (*TableScan) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{1} }

func (m *TableScan) GetTableId() int64 {
	if m != nil {
		return m.TableId
	}
	return 0
}

func (m *TableScan) GetColumns() []*ColumnInfo {
	if m != nil {
		return m.Columns
	}
	return nil
}

func (m *TableScan) GetDesc() bool {
	if m != nil {
		return m.Desc
	}
	return false
}

type IndexScan struct {
	TableId          int64         `protobuf:"varint,1,opt,name=table_id,json=tableId" json:"table_id"`
	IndexId          int64         `protobuf:"varint,2,opt,name=index_id,json=indexId" json:"index_id"`
	Columns          []*ColumnInfo `protobuf:"bytes,3,rep,name=columns" json:"columns,omitempty"`
	Desc             bool          `protobuf:"varint,4,opt,name=desc" json:"desc"`
	Unique           *bool         `protobuf:"varint,5,opt,name=unique" json:"unique,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *IndexScan) Reset()                    { *m = IndexScan{} }
func (m *IndexScan) String() string            { return proto.CompactTextString(m) }
func (*IndexScan) ProtoMessage()               {}
func (*IndexScan) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{2} }

func (m *IndexScan) GetTableId() int64 {
	if m != nil {
		return m.TableId
	}
	return 0
}

func (m *IndexScan) GetIndexId() int64 {
	if m != nil {
		return m.IndexId
	}
	return 0
}

func (m *IndexScan) GetColumns() []*ColumnInfo {
	if m != nil {
		return m.Columns
	}
	return nil
}

func (m *IndexScan) GetDesc() bool {
	if m != nil {
		return m.Desc
	}
	return false
}

func (m *IndexScan) GetUnique() bool {
	if m != nil && m.Unique != nil {
		return *m.Unique
	}
	return false
}

type Selection struct {
	// Where conditions.
	Conditions       []*Expr `protobuf:"bytes,1,rep,name=conditions" json:"conditions,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Selection) Reset()                    { *m = Selection{} }
func (m *Selection) String() string            { return proto.CompactTextString(m) }
func (*Selection) ProtoMessage()               {}
func (*Selection) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{3} }

func (m *Selection) GetConditions() []*Expr {
	if m != nil {
		return m.Conditions
	}
	return nil
}

type Projection struct {
	// Projection expressions.
	Exprs            []*Expr `protobuf:"bytes,1,rep,name=exprs" json:"exprs,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Projection) Reset()                    { *m = Projection{} }
func (m *Projection) String() string            { return proto.CompactTextString(m) }
func (*Projection) ProtoMessage()               {}
func (*Projection) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{4} }

func (m *Projection) GetExprs() []*Expr {
	if m != nil {
		return m.Exprs
	}
	return nil
}

type Aggregation struct {
	// Group by clause.
	GroupBy []*Expr `protobuf:"bytes,1,rep,name=group_by,json=groupBy" json:"group_by,omitempty"`
	// Aggregate functions.
	AggFunc []*Expr `protobuf:"bytes,2,rep,name=agg_func,json=aggFunc" json:"agg_func,omitempty"`
	// If it is a stream aggregation.
	Streamed         bool   `protobuf:"varint,3,opt,name=streamed" json:"streamed"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Aggregation) Reset()                    { *m = Aggregation{} }
func (m *Aggregation) String() string            { return proto.CompactTextString(m) }
func (*Aggregation) ProtoMessage()               {}
func (*Aggregation) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{5} }

func (m *Aggregation) GetGroupBy() []*Expr {
	if m != nil {
		return m.GroupBy
	}
	return nil
}

func (m *Aggregation) GetAggFunc() []*Expr {
	if m != nil {
		return m.AggFunc
	}
	return nil
}

func (m *Aggregation) GetStreamed() bool {
	if m != nil {
		return m.Streamed
	}
	return false
}

type TopN struct {
	// Order by clause.
	OrderBy          []*ByItem `protobuf:"bytes,1,rep,name=order_by,json=orderBy" json:"order_by,omitempty"`
	Limit            uint64    `protobuf:"varint,2,opt,name=limit" json:"limit"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *TopN) Reset()                    { *m = TopN{} }
func (m *TopN) String() string            { return proto.CompactTextString(m) }
func (*TopN) ProtoMessage()               {}
func (*TopN) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{6} }

func (m *TopN) GetOrderBy() []*ByItem {
	if m != nil {
		return m.OrderBy
	}
	return nil
}

func (m *TopN) GetLimit() uint64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type Limit struct {
	// Limit the result to be returned.
	Limit            uint64 `protobuf:"varint,1,opt,name=limit" json:"limit"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Limit) Reset()                    { *m = Limit{} }
func (m *Limit) String() string            { return proto.CompactTextString(m) }
func (*Limit) ProtoMessage()               {}
func (*Limit) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{7} }

func (m *Limit) GetLimit() uint64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func init() {
	proto.RegisterType((*Executor)(nil), "tipb.Executor")
	proto.RegisterType((*TableScan)(nil), "tipb.TableScan")
	proto.RegisterType((*IndexScan)(nil), "tipb.IndexScan")
	proto.RegisterType((*Selection)(nil), "tipb.Selection")
	proto.RegisterType((*Projection)(nil), "tipb.Projection")
	proto.RegisterType((*Aggregation)(nil), "tipb.Aggregation")
	proto.RegisterType((*TopN)(nil), "tipb.TopN")
	proto.RegisterType((*Limit)(nil), "tipb.Limit")
	proto.RegisterEnum("tipb.ExecType", ExecType_name, ExecType_value)
}
func (m *Executor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Executor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.Tp))
	if m.TblScan != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.TblScan.Size()))
		n1, err := m.TblScan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.IdxScan != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.IdxScan.Size()))
		n2, err := m.IdxScan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Selection != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.Selection.Size()))
		n3, err := m.Selection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Aggregation != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.Aggregation.Size()))
		n4, err := m.Aggregation.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.TopN != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.TopN.Size()))
		n5, err := m.TopN.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Limit != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.Limit.Size()))
		n6, err := m.Limit.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.StreamAgg != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.StreamAgg.Size()))
		n7, err := m.StreamAgg.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TableScan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableScan) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.TableId))
	if len(m.Columns) > 0 {
		for _, msg := range m.Columns {
			dAtA[i] = 0x12
			i++
			i = encodeVarintExecutor(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x18
	i++
	if m.Desc {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *IndexScan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IndexScan) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.TableId))
	dAtA[i] = 0x10
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.IndexId))
	if len(m.Columns) > 0 {
		for _, msg := range m.Columns {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintExecutor(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x20
	i++
	if m.Desc {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if m.Unique != nil {
		dAtA[i] = 0x28
		i++
		if *m.Unique {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Selection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Selection) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for _, msg := range m.Conditions {
			dAtA[i] = 0xa
			i++
			i = encodeVarintExecutor(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Projection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Projection) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Exprs) > 0 {
		for _, msg := range m.Exprs {
			dAtA[i] = 0xa
			i++
			i = encodeVarintExecutor(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Aggregation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Aggregation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.GroupBy) > 0 {
		for _, msg := range m.GroupBy {
			dAtA[i] = 0xa
			i++
			i = encodeVarintExecutor(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.AggFunc) > 0 {
		for _, msg := range m.AggFunc {
			dAtA[i] = 0x12
			i++
			i = encodeVarintExecutor(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x18
	i++
	if m.Streamed {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TopN) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TopN) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.OrderBy) > 0 {
		for _, msg := range m.OrderBy {
			dAtA[i] = 0xa
			i++
			i = encodeVarintExecutor(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x10
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.Limit))
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Limit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Limit) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.Limit))
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeFixed64Executor(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Executor(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintExecutor(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Executor) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovExecutor(uint64(m.Tp))
	if m.TblScan != nil {
		l = m.TblScan.Size()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.IdxScan != nil {
		l = m.IdxScan.Size()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.Selection != nil {
		l = m.Selection.Size()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.Aggregation != nil {
		l = m.Aggregation.Size()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.TopN != nil {
		l = m.TopN.Size()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.Limit != nil {
		l = m.Limit.Size()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.StreamAgg != nil {
		l = m.StreamAgg.Size()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TableScan) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovExecutor(uint64(m.TableId))
	if len(m.Columns) > 0 {
		for _, e := range m.Columns {
			l = e.Size()
			n += 1 + l + sovExecutor(uint64(l))
		}
	}
	n += 2
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IndexScan) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovExecutor(uint64(m.TableId))
	n += 1 + sovExecutor(uint64(m.IndexId))
	if len(m.Columns) > 0 {
		for _, e := range m.Columns {
			l = e.Size()
			n += 1 + l + sovExecutor(uint64(l))
		}
	}
	n += 2
	if m.Unique != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Selection) Size() (n int) {
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for _, e := range m.Conditions {
			l = e.Size()
			n += 1 + l + sovExecutor(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Projection) Size() (n int) {
	var l int
	_ = l
	if len(m.Exprs) > 0 {
		for _, e := range m.Exprs {
			l = e.Size()
			n += 1 + l + sovExecutor(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Aggregation) Size() (n int) {
	var l int
	_ = l
	if len(m.GroupBy) > 0 {
		for _, e := range m.GroupBy {
			l = e.Size()
			n += 1 + l + sovExecutor(uint64(l))
		}
	}
	if len(m.AggFunc) > 0 {
		for _, e := range m.AggFunc {
			l = e.Size()
			n += 1 + l + sovExecutor(uint64(l))
		}
	}
	n += 2
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TopN) Size() (n int) {
	var l int
	_ = l
	if len(m.OrderBy) > 0 {
		for _, e := range m.OrderBy {
			l = e.Size()
			n += 1 + l + sovExecutor(uint64(l))
		}
	}
	n += 1 + sovExecutor(uint64(m.Limit))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Limit) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovExecutor(uint64(m.Limit))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovExecutor(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozExecutor(x uint64) (n int) {
	return sovExecutor(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Executor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Executor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Executor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tp", wireType)
			}
			m.Tp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Tp |= (ExecType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TblScan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TblScan == nil {
				m.TblScan = &TableScan{}
			}
			if err := m.TblScan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IdxScan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IdxScan == nil {
				m.IdxScan = &IndexScan{}
			}
			if err := m.IdxScan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Selection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Selection == nil {
				m.Selection = &Selection{}
			}
			if err := m.Selection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Aggregation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Aggregation == nil {
				m.Aggregation = &Aggregation{}
			}
			if err := m.Aggregation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TopN", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TopN == nil {
				m.TopN = &TopN{}
			}
			if err := m.TopN.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Limit == nil {
				m.Limit = &Limit{}
			}
			if err := m.Limit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StreamAgg", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StreamAgg == nil {
				m.StreamAgg = &Aggregation{}
			}
			if err := m.StreamAgg.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableScan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableScan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableScan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableId", wireType)
			}
			m.TableId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TableId |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Columns = append(m.Columns, &ColumnInfo{})
			if err := m.Columns[len(m.Columns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Desc = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IndexScan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IndexScan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IndexScan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableId", wireType)
			}
			m.TableId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TableId |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexId", wireType)
			}
			m.IndexId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IndexId |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Columns = append(m.Columns, &ColumnInfo{})
			if err := m.Columns[len(m.Columns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Desc = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unique", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Unique = &b
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Selection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Selection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Selection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conditions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Conditions = append(m.Conditions, &Expr{})
			if err := m.Conditions[len(m.Conditions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Projection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Projection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Projection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exprs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exprs = append(m.Exprs, &Expr{})
			if err := m.Exprs[len(m.Exprs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Aggregation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Aggregation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Aggregation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupBy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupBy = append(m.GroupBy, &Expr{})
			if err := m.GroupBy[len(m.GroupBy)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggFunc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AggFunc = append(m.AggFunc, &Expr{})
			if err := m.AggFunc[len(m.AggFunc)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Streamed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Streamed = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TopN) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TopN: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TopN: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderBy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrderBy = append(m.OrderBy, &ByItem{})
			if err := m.OrderBy[len(m.OrderBy)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Limit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Limit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Limit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipExecutor(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthExecutor
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowExecutor
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipExecutor(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthExecutor = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowExecutor   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("executor.proto", fileDescriptorExecutor) }

var fileDescriptorExecutor = []byte{
	// 630 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x93, 0xcd, 0x6e, 0xd3, 0x40,
	0x10, 0xc7, 0x6b, 0xc7, 0x69, 0x9c, 0x49, 0x3f, 0xdc, 0xe5, 0x43, 0x56, 0x0f, 0x69, 0x30, 0x20,
	0x4a, 0x24, 0x02, 0x2a, 0x07, 0xce, 0x0d, 0x02, 0x29, 0x02, 0x55, 0x95, 0xdb, 0x7b, 0xe4, 0xac,
	0xb7, 0xcb, 0xa2, 0x64, 0x77, 0xb1, 0xd7, 0x52, 0x72, 0xe0, 0xce, 0x23, 0xf0, 0x0e, 0xbc, 0x48,
	0x8f, 0x3c, 0x01, 0x82, 0xf2, 0x22, 0x68, 0x77, 0x6d, 0xc7, 0x85, 0x22, 0x38, 0xed, 0xce, 0x7f,
	0x7e, 0x33, 0x3b, 0x9a, 0x99, 0x85, 0x1d, 0xb2, 0x24, 0xb8, 0x50, 0x22, 0x1b, 0xc9, 0x4c, 0x28,
	0x81, 0x3c, 0xc5, 0xe4, 0x6c, 0x3f, 0x20, 0x4b, 0x99, 0x91, 0x3c, 0x67, 0x82, 0x5b, 0x7d, 0x7f,
	0x2b, 0xc7, 0xef, 0xc8, 0x22, 0x29, 0xad, 0xdb, 0x54, 0x50, 0x61, 0xae, 0x4f, 0xf5, 0xcd, 0xaa,
	0xd1, 0x0f, 0x17, 0xfc, 0x57, 0x65, 0x3a, 0xf4, 0x00, 0x5c, 0x25, 0x43, 0x67, 0xe0, 0x1c, 0xee,
	0x1c, 0xed, 0x8c, 0x74, 0xd6, 0x91, 0xf6, 0x9d, 0xaf, 0x24, 0x19, 0x7b, 0x97, 0xdf, 0x0e, 0x36,
	0x62, 0x57, 0x49, 0x34, 0x04, 0x5f, 0xcd, 0xe6, 0xd3, 0x1c, 0x27, 0x3c, 0x74, 0x07, 0xce, 0x61,
	0xef, 0x68, 0xd7, 0xb2, 0xe7, 0xc9, 0x6c, 0x4e, 0xce, 0x70, 0xc2, 0xe3, 0x8e, 0x9a, 0xcd, 0xf5,
	0x45, 0xb3, 0x2c, 0x5d, 0x5a, 0xb6, 0xd5, 0x64, 0x27, 0x3c, 0x25, 0x4b, 0xcb, 0xb2, 0xd4, 0x5c,
	0xd0, 0x13, 0xe8, 0xe6, 0x64, 0x4e, 0xb0, 0x62, 0x82, 0x87, 0x5e, 0x13, 0x3e, 0xab, 0xe4, 0x78,
	0x4d, 0xa0, 0xe7, 0xd0, 0x4b, 0x28, 0xcd, 0x08, 0x4d, 0x4c, 0x40, 0xdb, 0x04, 0xec, 0xd9, 0x80,
	0xe3, 0xb5, 0x23, 0x6e, 0x52, 0xa8, 0x0f, 0x9e, 0x12, 0xf2, 0x24, 0xdc, 0x34, 0x34, 0x94, 0x75,
	0x0b, 0x79, 0x12, 0x1b, 0x1d, 0xdd, 0x83, 0xf6, 0x9c, 0x2d, 0x98, 0x0a, 0x3b, 0x06, 0xe8, 0x59,
	0xe0, 0xad, 0x96, 0x62, 0xeb, 0x41, 0xcf, 0x00, 0x72, 0x95, 0x91, 0x64, 0x31, 0x4d, 0x28, 0x0d,
	0xfd, 0xbf, 0x3d, 0xdb, 0xb5, 0xd0, 0x31, 0xa5, 0x51, 0x06, 0xdd, 0xba, 0x35, 0xe8, 0x00, 0x7c,
	0xa5, 0x8d, 0x29, 0x4b, 0x4d, 0xa7, 0x5b, 0x65, 0x67, 0x3b, 0x46, 0x9d, 0xa4, 0x68, 0x08, 0x1d,
	0x2c, 0xe6, 0xc5, 0x82, 0xe7, 0xa1, 0x3b, 0x68, 0x1d, 0xf6, 0x8e, 0x02, 0x9b, 0xfc, 0xa5, 0x11,
	0x27, 0xfc, 0x42, 0xc4, 0x15, 0x80, 0x42, 0xf0, 0x52, 0x92, 0x63, 0xd3, 0x5a, 0xbf, 0x4c, 0x64,
	0x94, 0xe8, 0x8b, 0x03, 0xdd, 0xba, 0xc7, 0xff, 0x7e, 0xf4, 0x00, 0x7c, 0xa6, 0x69, 0x0d, 0xb8,
	0x4d, 0xc0, 0xa8, 0xd7, 0xab, 0x6a, 0xfd, 0x6f, 0x55, 0xde, 0xef, 0x55, 0xa1, 0xbb, 0xb0, 0x59,
	0x70, 0xf6, 0xa1, 0x20, 0x66, 0x5c, 0x7e, 0x5c, 0x5a, 0xd1, 0x0b, 0xe8, 0xd6, 0x33, 0x46, 0x43,
	0x00, 0x2c, 0x78, 0xca, 0xb4, 0x91, 0x87, 0x8e, 0x79, 0x0d, 0xaa, 0x6d, 0x94, 0x59, 0xdc, 0xf0,
	0x46, 0x23, 0x80, 0xd3, 0x4c, 0xbc, 0x2f, 0x23, 0x07, 0xd0, 0xd6, 0x9f, 0xe0, 0xa6, 0x20, 0xeb,
	0x88, 0x3e, 0x42, 0xaf, 0x31, 0x24, 0xf4, 0x10, 0x7c, 0x9a, 0x89, 0x42, 0x4e, 0x67, 0xab, 0x1b,
	0x62, 0x3a, 0xc6, 0x37, 0x5e, 0x69, 0x2c, 0xa1, 0x74, 0x7a, 0x51, 0x70, 0x5c, 0xce, 0xe4, 0x1a,
	0x96, 0x50, 0xfa, 0xba, 0xe0, 0x18, 0x0d, 0xc0, 0xb7, 0x43, 0x27, 0xe9, 0xb5, 0x89, 0xd4, 0x6a,
	0xf4, 0x06, 0x3c, 0xbd, 0x6c, 0xe8, 0x11, 0xf8, 0x22, 0x4b, 0x49, 0xb6, 0x7e, 0x77, 0xcb, 0x26,
	0x1c, 0xaf, 0x26, 0x8a, 0x2c, 0xe2, 0x8e, 0xf1, 0x8e, 0x57, 0x68, 0xbf, 0xda, 0x47, 0x3d, 0x14,
	0xaf, 0xcc, 0x67, 0xa5, 0xe8, 0x3e, 0xb4, 0xcd, 0x62, 0xae, 0x21, 0xe7, 0x0f, 0x68, 0xf8, 0xc9,
	0xb1, 0xff, 0x5b, 0xff, 0x61, 0xb4, 0x07, 0xdb, 0xfa, 0xac, 0x97, 0x31, 0xd8, 0xa8, 0xa4, 0x7a,
	0x55, 0x02, 0xa7, 0x92, 0xea, 0x81, 0x04, 0x2e, 0xba, 0x05, 0xbb, 0x5a, 0x6a, 0xb4, 0x2e, 0x68,
	0xa1, 0x2d, 0xf0, 0x4d, 0x36, 0x21, 0x4f, 0x02, 0x0f, 0x6d, 0x43, 0x57, 0x5b, 0xa6, 0xa2, 0xa0,
	0x5d, 0x27, 0xa9, 0x3e, 0x41, 0xb0, 0x39, 0x7e, 0x7c, 0x79, 0xd5, 0x77, 0xbe, 0x5e, 0xf5, 0x9d,
	0xef, 0x57, 0x7d, 0xe7, 0xf3, 0xcf, 0xfe, 0x06, 0xdc, 0xc1, 0x62, 0x31, 0x92, 0x8c, 0x53, 0x9c,
	0xc8, 0x91, 0x62, 0xe9, 0xcc, 0x34, 0xe1, 0xd4, 0xf9, 0x15, 0x00, 0x00, 0xff, 0xff, 0xf8, 0x05,
	0x10, 0x17, 0xe2, 0x04, 0x00, 0x00,
}
