package beacon

type testData struct {
	ts          []int64
	ds          []int64
	minScore    float64
	maxScore    float64
	description string
}

var testDataList = []testData{

	{
		ts:          []int64{0, 1800, 3600, 5400, 7200, 9000, 10800, 12600, 14400, 16200, 18000, 19800, 21600, 23400, 25200, 27000, 28800, 30600, 32400, 34200, 36000, 37800, 39600, 41400, 43200, 45000, 46800, 48600, 50400, 52200, 54000, 55800, 57600, 59400, 61200, 63000, 64800, 66600, 68400, 70200, 72000, 73800, 75600, 77400, 79200, 81000, 82800, 84600, 86400},
		ds:          []int64{4, 4, 4},
		minScore:    0.99,
		maxScore:    1.0,
		description: "Perfect Beacon every 30 minutes... Starts at 0 (midnight) ends at 86400 (+24 hours)",
	},

	{
		ts:          []int64{0, 1800, 3600, 5400, 7200, 9000, 10800, 12600, 14400, 16200, 18000, 19800, 21600, 23400, 25200, 27000, 28800, 30600, 32400, 34200, 36000, 37800, 39600, 41400, 43200, 45000, 46800, 48600, 50400, 52200, 54000, 55800, 57600, 59400, 61200, 63000, 64800, 66600, 68400, 70200, 72000, 73800, 75600, 77400, 79200, 81000, 82800, 84600},
		ds:          []int64{4, 4, 4},
		minScore:    0.95,
		maxScore:    1.0,
		description: "Beacon every 30 minutes... Starts at 0 (midnight) ends 60 minutes before next midnight",
	},

	{
		ts:          []int64{28800, 30600, 32400, 34200, 36000, 37800, 39600, 41400, 43200, 45000, 46800, 48600, 50400, 52200, 54000, 55800, 57600},
		ds:          []int64{4, 4, 4},
		minScore:    0.95,
		maxScore:    1.0,
		description: "Beacon every 30 minutes... Starts at 8:00 ends at 16:00",
	},

	{
		ts:          []int64{32400, 32410, 32420, 32430, 32440, 32450, 32460, 32470, 32480, 32490, 32500, 32510, 32520, 32530, 32540, 32550, 32560, 32570, 32580, 32590, 32600, 32610, 32620, 32630, 32640, 32650, 32660, 32670, 32680, 32690, 32700, 32710, 32720, 32730, 32740, 32750, 32760, 32770, 32780, 32790, 32800, 32810, 32820, 32830, 32840, 32850, 32860, 32870, 32880, 32890, 32900, 32910, 32920, 32930, 32940, 32950, 32960, 32970, 32980, 32990, 33000, 33010, 33020, 33030, 33040, 33050, 33060, 33070, 33080, 33090, 33100, 33110, 33120, 33130, 33140, 33150, 33160, 33170, 33180, 33190, 33200, 33210, 33220, 33230, 33240, 33250, 33260, 33270, 33280, 33290, 33300, 33310, 33320, 33330, 33340, 33350, 33360, 33370, 33380, 33390, 33400, 33410, 33420, 33430, 33440, 33450, 33460, 33470, 33480, 33490, 33500, 33510, 33520, 33530, 33540, 33550, 33560, 33570, 33580, 33590, 33600, 33610, 33620, 33630, 33640, 33650, 33660, 33670, 33680, 33690, 33700, 33710, 33720, 33730, 33740, 33750, 33760, 33770, 33780, 33790, 33800, 33810, 33820, 33830, 33840, 33850, 33860, 33870, 33880, 33890, 33900, 33910, 33920, 33930, 33940, 33950, 33960, 33970, 33980, 33990, 34000, 34010, 34020, 34030, 34040, 34050, 34060, 34070, 34080, 34090, 34100, 34110, 34120, 34130, 34140, 34150, 34160, 34170, 34180, 34190, 34200, 34210, 34220, 34230, 34240, 34250, 34260, 34270, 34280, 34290, 34300, 34310, 34320, 34330, 34340, 34350, 34360, 34370, 34380, 34390, 34400, 34410, 34420, 34430, 34440, 34450, 34460, 34470, 34480, 34490, 34500, 34510, 34520, 34530, 34540, 34550, 34560, 34570, 34580, 34590, 34600, 34610, 34620, 34630, 34640, 34650, 34660, 34670, 34680, 34690, 34700, 34710, 34720, 34730, 34740, 34750, 34760, 34770, 34780, 34790, 34800, 34810, 34820, 34830, 34840, 34850, 34860, 34870, 34880, 34890, 34900, 34910, 34920, 34930, 34940, 34950, 34960, 34970, 34980, 34990, 35000, 35010, 35020, 35030, 35040, 35050, 35060, 35070, 35080, 35090, 35100, 35110, 35120, 35130, 35140, 35150, 35160, 35170, 35180, 35190, 35200, 35210, 35220, 35230, 35240, 35250, 35260, 35270, 35280, 35290, 35300, 35310, 35320, 35330, 35340, 35350, 35360, 35370, 35380, 35390, 35400, 35410, 35420, 35430, 35440, 35450, 35460, 35470, 35480, 35490, 35500, 35510, 35520, 35530, 35540, 35550, 35560, 35570, 35580, 35590, 35600, 35610, 35620, 35630, 35640, 35650, 35660, 35670, 35680, 35690, 35700, 35710, 35720, 35730, 35740, 35750, 35760, 35770, 35780, 35790, 35800, 35810, 35820, 35830, 35840, 35850, 35860, 35870, 35880, 35890, 35900, 35910, 35920, 35930, 35940, 35950, 35960, 35970, 35980, 35990, 36000},
		ds:          []int64{4, 4, 4},
		minScore:    0.95,
		maxScore:    1.0,
		description: "Beacon every 10 seconds... Starts at 9:00 ends at 10:00",
	},

	{
		ts:          []int64{181, 3644, 7104, 10741, 14406, 17867, 21589, 25263, 28954, 32633, 36026, 39460, 43114, 46766, 50476, 54078, 57504, 61127, 64850, 68408, 71829, 75698, 79208, 82702, 84500},
		ds:          []int64{4, 4, 4, 6, 6, 6, 4, 4, 4},
		minScore:    0.7,
		maxScore:    0.8,
		description: "Beacon every 1 hour... Starts at 0 (midnight) ends at 86400 (+24 hours)... Noise added to each timestamp: Gaussian Mu=0 Sigma=100",
	},

	{
		ts:          []int64{0, 2, 3600, 3602, 7200, 7202, 10800, 10802, 14400, 14402, 18000, 18002, 21600, 21602, 25200, 25202, 28800, 28802, 32400, 32402, 36000, 36002, 39600, 39602, 43200, 43202, 46800, 46802, 50400, 50402, 54000, 54002, 57600, 57602, 61200, 61202, 64800, 64802, 68400, 68402, 72000, 72002, 75600, 75602, 79200, 79202, 82800, 82802, 86400, 86402},
		ds:          []int64{4, 4, 4},
		minScore:    0.9,
		maxScore:    1.0,
		description: "Perfect Beacon every 60 minutes... Connects twice every time",
	},

	{
		ts:          []int64{0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 4, 4, 4, 5, 6, 7, 9, 10, 10, 10, 11, 13},
		ds:          []int64{4, 100, 2, 43, 3},
		minScore:    0.8,
		maxScore:    0.9,
		description: "Connection happens a lot... but not a beacon",
	},

	{
		ts:          []int64{10, 15, 23, 70, 50400, 50470, 50472},
		ds:          []int64{10, 15, 23, 70, 50400, 50470, 50472},
		minScore:    0.0,
		maxScore:    0.5,
		description: "Not a beacon.",
	},
}
