// Code generated by protoc-gen-go. DO NOT EDIT.
// source: proto/beacon/rpc/v1/services.proto

package ethereum_beacon_rpc_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import empty "github.com/golang/protobuf/ptypes/empty"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import v1 "github.com/prysmaticlabs/prysm/proto/beacon/p2p/v1"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type ValidatorRole int32

const (
	ValidatorRole_UNKNOWN  ValidatorRole = 0
	ValidatorRole_ATTESTER ValidatorRole = 1
	ValidatorRole_PROPOSER ValidatorRole = 2
)

var ValidatorRole_name = map[int32]string{
	0: "UNKNOWN",
	1: "ATTESTER",
	2: "PROPOSER",
}
var ValidatorRole_value = map[string]int32{
	"UNKNOWN":  0,
	"ATTESTER": 1,
	"PROPOSER": 2,
}

func (x ValidatorRole) String() string {
	return proto.EnumName(ValidatorRole_name, int32(x))
}
func (ValidatorRole) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_services_54e1be11fa7a94d4, []int{0}
}

type ProposeRequest struct {
	ParentHash              []byte               `protobuf:"bytes,1,opt,name=parent_hash,json=parentHash,proto3" json:"parent_hash,omitempty"`
	SlotNumber              uint64               `protobuf:"varint,2,opt,name=slot_number,json=slotNumber,proto3" json:"slot_number,omitempty"`
	RandaoReveal            []byte               `protobuf:"bytes,3,opt,name=randao_reveal,json=randaoReveal,proto3" json:"randao_reveal,omitempty"`
	AttestationBitmask      []byte               `protobuf:"bytes,4,opt,name=attestation_bitmask,json=attestationBitmask,proto3" json:"attestation_bitmask,omitempty"`
	AttestationAggregateSig []uint32             `protobuf:"varint,5,rep,packed,name=attestation_aggregate_sig,json=attestationAggregateSig,proto3" json:"attestation_aggregate_sig,omitempty"`
	Timestamp               *timestamp.Timestamp `protobuf:"bytes,6,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}             `json:"-"`
	XXX_unrecognized        []byte               `json:"-"`
	XXX_sizecache           int32                `json:"-"`
}

func (m *ProposeRequest) Reset()         { *m = ProposeRequest{} }
func (m *ProposeRequest) String() string { return proto.CompactTextString(m) }
func (*ProposeRequest) ProtoMessage()    {}
func (*ProposeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_services_54e1be11fa7a94d4, []int{0}
}
func (m *ProposeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProposeRequest.Unmarshal(m, b)
}
func (m *ProposeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProposeRequest.Marshal(b, m, deterministic)
}
func (dst *ProposeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProposeRequest.Merge(dst, src)
}
func (m *ProposeRequest) XXX_Size() int {
	return xxx_messageInfo_ProposeRequest.Size(m)
}
func (m *ProposeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProposeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProposeRequest proto.InternalMessageInfo

func (m *ProposeRequest) GetParentHash() []byte {
	if m != nil {
		return m.ParentHash
	}
	return nil
}

func (m *ProposeRequest) GetSlotNumber() uint64 {
	if m != nil {
		return m.SlotNumber
	}
	return 0
}

func (m *ProposeRequest) GetRandaoReveal() []byte {
	if m != nil {
		return m.RandaoReveal
	}
	return nil
}

func (m *ProposeRequest) GetAttestationBitmask() []byte {
	if m != nil {
		return m.AttestationBitmask
	}
	return nil
}

func (m *ProposeRequest) GetAttestationAggregateSig() []uint32 {
	if m != nil {
		return m.AttestationAggregateSig
	}
	return nil
}

func (m *ProposeRequest) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type ProposeResponse struct {
	BlockHash            []byte   `protobuf:"bytes,1,opt,name=block_hash,json=blockHash,proto3" json:"block_hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProposeResponse) Reset()         { *m = ProposeResponse{} }
func (m *ProposeResponse) String() string { return proto.CompactTextString(m) }
func (*ProposeResponse) ProtoMessage()    {}
func (*ProposeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_services_54e1be11fa7a94d4, []int{1}
}
func (m *ProposeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProposeResponse.Unmarshal(m, b)
}
func (m *ProposeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProposeResponse.Marshal(b, m, deterministic)
}
func (dst *ProposeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProposeResponse.Merge(dst, src)
}
func (m *ProposeResponse) XXX_Size() int {
	return xxx_messageInfo_ProposeResponse.Size(m)
}
func (m *ProposeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProposeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProposeResponse proto.InternalMessageInfo

func (m *ProposeResponse) GetBlockHash() []byte {
	if m != nil {
		return m.BlockHash
	}
	return nil
}

type AttestRequest struct {
	Attestation          *v1.AggregatedAttestation `protobuf:"bytes,1,opt,name=attestation,proto3" json:"attestation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AttestRequest) Reset()         { *m = AttestRequest{} }
func (m *AttestRequest) String() string { return proto.CompactTextString(m) }
func (*AttestRequest) ProtoMessage()    {}
func (*AttestRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_services_54e1be11fa7a94d4, []int{2}
}
func (m *AttestRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttestRequest.Unmarshal(m, b)
}
func (m *AttestRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttestRequest.Marshal(b, m, deterministic)
}
func (dst *AttestRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttestRequest.Merge(dst, src)
}
func (m *AttestRequest) XXX_Size() int {
	return xxx_messageInfo_AttestRequest.Size(m)
}
func (m *AttestRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AttestRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AttestRequest proto.InternalMessageInfo

func (m *AttestRequest) GetAttestation() *v1.AggregatedAttestation {
	if m != nil {
		return m.Attestation
	}
	return nil
}

type AttestResponse struct {
	AttestationHash      []byte   `protobuf:"bytes,1,opt,name=attestation_hash,json=attestationHash,proto3" json:"attestation_hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttestResponse) Reset()         { *m = AttestResponse{} }
func (m *AttestResponse) String() string { return proto.CompactTextString(m) }
func (*AttestResponse) ProtoMessage()    {}
func (*AttestResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_services_54e1be11fa7a94d4, []int{3}
}
func (m *AttestResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttestResponse.Unmarshal(m, b)
}
func (m *AttestResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttestResponse.Marshal(b, m, deterministic)
}
func (dst *AttestResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttestResponse.Merge(dst, src)
}
func (m *AttestResponse) XXX_Size() int {
	return xxx_messageInfo_AttestResponse.Size(m)
}
func (m *AttestResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AttestResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AttestResponse proto.InternalMessageInfo

func (m *AttestResponse) GetAttestationHash() []byte {
	if m != nil {
		return m.AttestationHash
	}
	return nil
}

// Request assignment updates for either all validators or a subset of validators
// defined by their public keys.
type ValidatorAssignmentRequest struct {
	AllValidators        bool         `protobuf:"varint,1,opt,name=all_validators,json=allValidators,proto3" json:"all_validators,omitempty"`
	PublicKeys           []*PublicKey `protobuf:"bytes,2,rep,name=public_keys,json=publicKeys,proto3" json:"public_keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ValidatorAssignmentRequest) Reset()         { *m = ValidatorAssignmentRequest{} }
func (m *ValidatorAssignmentRequest) String() string { return proto.CompactTextString(m) }
func (*ValidatorAssignmentRequest) ProtoMessage()    {}
func (*ValidatorAssignmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_services_54e1be11fa7a94d4, []int{4}
}
func (m *ValidatorAssignmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValidatorAssignmentRequest.Unmarshal(m, b)
}
func (m *ValidatorAssignmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValidatorAssignmentRequest.Marshal(b, m, deterministic)
}
func (dst *ValidatorAssignmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidatorAssignmentRequest.Merge(dst, src)
}
func (m *ValidatorAssignmentRequest) XXX_Size() int {
	return xxx_messageInfo_ValidatorAssignmentRequest.Size(m)
}
func (m *ValidatorAssignmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidatorAssignmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ValidatorAssignmentRequest proto.InternalMessageInfo

func (m *ValidatorAssignmentRequest) GetAllValidators() bool {
	if m != nil {
		return m.AllValidators
	}
	return false
}

func (m *ValidatorAssignmentRequest) GetPublicKeys() []*PublicKey {
	if m != nil {
		return m.PublicKeys
	}
	return nil
}

type ValidatorAssignmentResponse struct {
	Assignments          []*Assignment `protobuf:"bytes,1,rep,name=assignments,proto3" json:"assignments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ValidatorAssignmentResponse) Reset()         { *m = ValidatorAssignmentResponse{} }
func (m *ValidatorAssignmentResponse) String() string { return proto.CompactTextString(m) }
func (*ValidatorAssignmentResponse) ProtoMessage()    {}
func (*ValidatorAssignmentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_services_54e1be11fa7a94d4, []int{5}
}
func (m *ValidatorAssignmentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValidatorAssignmentResponse.Unmarshal(m, b)
}
func (m *ValidatorAssignmentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValidatorAssignmentResponse.Marshal(b, m, deterministic)
}
func (dst *ValidatorAssignmentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidatorAssignmentResponse.Merge(dst, src)
}
func (m *ValidatorAssignmentResponse) XXX_Size() int {
	return xxx_messageInfo_ValidatorAssignmentResponse.Size(m)
}
func (m *ValidatorAssignmentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidatorAssignmentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ValidatorAssignmentResponse proto.InternalMessageInfo

func (m *ValidatorAssignmentResponse) GetAssignments() []*Assignment {
	if m != nil {
		return m.Assignments
	}
	return nil
}

// Assignment defines a validator's assignment responsibilities.
type Assignment struct {
	PublicKey            *PublicKey    `protobuf:"bytes,1,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	ShardId              uint64        `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	Role                 ValidatorRole `protobuf:"varint,3,opt,name=role,proto3,enum=ethereum.beacon.rpc.v1.ValidatorRole" json:"role,omitempty"`
	AssignedSlot         uint64        `protobuf:"varint,4,opt,name=assigned_slot,json=assignedSlot,proto3" json:"assigned_slot,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Assignment) Reset()         { *m = Assignment{} }
func (m *Assignment) String() string { return proto.CompactTextString(m) }
func (*Assignment) ProtoMessage()    {}
func (*Assignment) Descriptor() ([]byte, []int) {
	return fileDescriptor_services_54e1be11fa7a94d4, []int{6}
}
func (m *Assignment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Assignment.Unmarshal(m, b)
}
func (m *Assignment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Assignment.Marshal(b, m, deterministic)
}
func (dst *Assignment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Assignment.Merge(dst, src)
}
func (m *Assignment) XXX_Size() int {
	return xxx_messageInfo_Assignment.Size(m)
}
func (m *Assignment) XXX_DiscardUnknown() {
	xxx_messageInfo_Assignment.DiscardUnknown(m)
}

var xxx_messageInfo_Assignment proto.InternalMessageInfo

func (m *Assignment) GetPublicKey() *PublicKey {
	if m != nil {
		return m.PublicKey
	}
	return nil
}

func (m *Assignment) GetShardId() uint64 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *Assignment) GetRole() ValidatorRole {
	if m != nil {
		return m.Role
	}
	return ValidatorRole_UNKNOWN
}

func (m *Assignment) GetAssignedSlot() uint64 {
	if m != nil {
		return m.AssignedSlot
	}
	return 0
}

type PublicKey struct {
	PublicKey            []byte   `protobuf:"bytes,1,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PublicKey) Reset()         { *m = PublicKey{} }
func (m *PublicKey) String() string { return proto.CompactTextString(m) }
func (*PublicKey) ProtoMessage()    {}
func (*PublicKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_services_54e1be11fa7a94d4, []int{7}
}
func (m *PublicKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PublicKey.Unmarshal(m, b)
}
func (m *PublicKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PublicKey.Marshal(b, m, deterministic)
}
func (dst *PublicKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublicKey.Merge(dst, src)
}
func (m *PublicKey) XXX_Size() int {
	return xxx_messageInfo_PublicKey.Size(m)
}
func (m *PublicKey) XXX_DiscardUnknown() {
	xxx_messageInfo_PublicKey.DiscardUnknown(m)
}

var xxx_messageInfo_PublicKey proto.InternalMessageInfo

func (m *PublicKey) GetPublicKey() []byte {
	if m != nil {
		return m.PublicKey
	}
	return nil
}

type SlotResponsibilityResponse struct {
	Slot                 uint64        `protobuf:"varint,1,opt,name=slot,proto3" json:"slot,omitempty"`
	Role                 ValidatorRole `protobuf:"varint,2,opt,name=role,proto3,enum=ethereum.beacon.rpc.v1.ValidatorRole" json:"role,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *SlotResponsibilityResponse) Reset()         { *m = SlotResponsibilityResponse{} }
func (m *SlotResponsibilityResponse) String() string { return proto.CompactTextString(m) }
func (*SlotResponsibilityResponse) ProtoMessage()    {}
func (*SlotResponsibilityResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_services_54e1be11fa7a94d4, []int{8}
}
func (m *SlotResponsibilityResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SlotResponsibilityResponse.Unmarshal(m, b)
}
func (m *SlotResponsibilityResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SlotResponsibilityResponse.Marshal(b, m, deterministic)
}
func (dst *SlotResponsibilityResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SlotResponsibilityResponse.Merge(dst, src)
}
func (m *SlotResponsibilityResponse) XXX_Size() int {
	return xxx_messageInfo_SlotResponsibilityResponse.Size(m)
}
func (m *SlotResponsibilityResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SlotResponsibilityResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SlotResponsibilityResponse proto.InternalMessageInfo

func (m *SlotResponsibilityResponse) GetSlot() uint64 {
	if m != nil {
		return m.Slot
	}
	return 0
}

func (m *SlotResponsibilityResponse) GetRole() ValidatorRole {
	if m != nil {
		return m.Role
	}
	return ValidatorRole_UNKNOWN
}

type IndexResponse struct {
	Index                uint32   `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IndexResponse) Reset()         { *m = IndexResponse{} }
func (m *IndexResponse) String() string { return proto.CompactTextString(m) }
func (*IndexResponse) ProtoMessage()    {}
func (*IndexResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_services_54e1be11fa7a94d4, []int{9}
}
func (m *IndexResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IndexResponse.Unmarshal(m, b)
}
func (m *IndexResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IndexResponse.Marshal(b, m, deterministic)
}
func (dst *IndexResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IndexResponse.Merge(dst, src)
}
func (m *IndexResponse) XXX_Size() int {
	return xxx_messageInfo_IndexResponse.Size(m)
}
func (m *IndexResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_IndexResponse.DiscardUnknown(m)
}

var xxx_messageInfo_IndexResponse proto.InternalMessageInfo

func (m *IndexResponse) GetIndex() uint32 {
	if m != nil {
		return m.Index
	}
	return 0
}

type ShardIDResponse struct {
	ShardId              uint64   `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShardIDResponse) Reset()         { *m = ShardIDResponse{} }
func (m *ShardIDResponse) String() string { return proto.CompactTextString(m) }
func (*ShardIDResponse) ProtoMessage()    {}
func (*ShardIDResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_services_54e1be11fa7a94d4, []int{10}
}
func (m *ShardIDResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardIDResponse.Unmarshal(m, b)
}
func (m *ShardIDResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardIDResponse.Marshal(b, m, deterministic)
}
func (dst *ShardIDResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardIDResponse.Merge(dst, src)
}
func (m *ShardIDResponse) XXX_Size() int {
	return xxx_messageInfo_ShardIDResponse.Size(m)
}
func (m *ShardIDResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardIDResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ShardIDResponse proto.InternalMessageInfo

func (m *ShardIDResponse) GetShardId() uint64 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

type CurrentAssignmentsResponse struct {
	Assignments          []*Assignment        `protobuf:"bytes,1,rep,name=assignments,proto3" json:"assignments,omitempty"`
	GenesisTimestamp     *timestamp.Timestamp `protobuf:"bytes,2,opt,name=genesis_timestamp,json=genesisTimestamp,proto3" json:"genesis_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CurrentAssignmentsResponse) Reset()         { *m = CurrentAssignmentsResponse{} }
func (m *CurrentAssignmentsResponse) String() string { return proto.CompactTextString(m) }
func (*CurrentAssignmentsResponse) ProtoMessage()    {}
func (*CurrentAssignmentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_services_54e1be11fa7a94d4, []int{11}
}
func (m *CurrentAssignmentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CurrentAssignmentsResponse.Unmarshal(m, b)
}
func (m *CurrentAssignmentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CurrentAssignmentsResponse.Marshal(b, m, deterministic)
}
func (dst *CurrentAssignmentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CurrentAssignmentsResponse.Merge(dst, src)
}
func (m *CurrentAssignmentsResponse) XXX_Size() int {
	return xxx_messageInfo_CurrentAssignmentsResponse.Size(m)
}
func (m *CurrentAssignmentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CurrentAssignmentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CurrentAssignmentsResponse proto.InternalMessageInfo

func (m *CurrentAssignmentsResponse) GetAssignments() []*Assignment {
	if m != nil {
		return m.Assignments
	}
	return nil
}

func (m *CurrentAssignmentsResponse) GetGenesisTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.GenesisTimestamp
	}
	return nil
}

func init() {
	proto.RegisterType((*ProposeRequest)(nil), "ethereum.beacon.rpc.v1.ProposeRequest")
	proto.RegisterType((*ProposeResponse)(nil), "ethereum.beacon.rpc.v1.ProposeResponse")
	proto.RegisterType((*AttestRequest)(nil), "ethereum.beacon.rpc.v1.AttestRequest")
	proto.RegisterType((*AttestResponse)(nil), "ethereum.beacon.rpc.v1.AttestResponse")
	proto.RegisterType((*ValidatorAssignmentRequest)(nil), "ethereum.beacon.rpc.v1.ValidatorAssignmentRequest")
	proto.RegisterType((*ValidatorAssignmentResponse)(nil), "ethereum.beacon.rpc.v1.ValidatorAssignmentResponse")
	proto.RegisterType((*Assignment)(nil), "ethereum.beacon.rpc.v1.Assignment")
	proto.RegisterType((*PublicKey)(nil), "ethereum.beacon.rpc.v1.PublicKey")
	proto.RegisterType((*SlotResponsibilityResponse)(nil), "ethereum.beacon.rpc.v1.SlotResponsibilityResponse")
	proto.RegisterType((*IndexResponse)(nil), "ethereum.beacon.rpc.v1.IndexResponse")
	proto.RegisterType((*ShardIDResponse)(nil), "ethereum.beacon.rpc.v1.ShardIDResponse")
	proto.RegisterType((*CurrentAssignmentsResponse)(nil), "ethereum.beacon.rpc.v1.CurrentAssignmentsResponse")
	proto.RegisterEnum("ethereum.beacon.rpc.v1.ValidatorRole", ValidatorRole_name, ValidatorRole_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BeaconServiceClient is the client API for BeaconService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeaconServiceClient interface {
	// CanonicalHead can be called on demand to fetch the current, head block of a
	// beacon node.
	CanonicalHead(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*v1.BeaconBlock, error)
	// LatestAttestation streams the latest aggregated attestation to connected
	// validator clients.
	LatestAttestation(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (BeaconService_LatestAttestationClient, error)
	// CurrentAssignmentsAndGenesisTime is called by a validator client upon first connecting
	// to a beacon node in order to determine the current validator assignments
	// and genesis timestamp of the protocol.
	CurrentAssignmentsAndGenesisTime(ctx context.Context, in *ValidatorAssignmentRequest, opts ...grpc.CallOption) (*CurrentAssignmentsResponse, error)
	// ValidatorAssignments streams validator assignments to clients
	// for a subset of public keys in the active validator set.
	ValidatorAssignments(ctx context.Context, in *ValidatorAssignmentRequest, opts ...grpc.CallOption) (BeaconService_ValidatorAssignmentsClient, error)
}

type beaconServiceClient struct {
	cc *grpc.ClientConn
}

func NewBeaconServiceClient(cc *grpc.ClientConn) BeaconServiceClient {
	return &beaconServiceClient{cc}
}

func (c *beaconServiceClient) CanonicalHead(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*v1.BeaconBlock, error) {
	out := new(v1.BeaconBlock)
	err := c.cc.Invoke(ctx, "/ethereum.beacon.rpc.v1.BeaconService/CanonicalHead", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beaconServiceClient) LatestAttestation(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (BeaconService_LatestAttestationClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeaconService_serviceDesc.Streams[0], "/ethereum.beacon.rpc.v1.BeaconService/LatestAttestation", opts...)
	if err != nil {
		return nil, err
	}
	x := &beaconServiceLatestAttestationClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BeaconService_LatestAttestationClient interface {
	Recv() (*v1.AggregatedAttestation, error)
	grpc.ClientStream
}

type beaconServiceLatestAttestationClient struct {
	grpc.ClientStream
}

func (x *beaconServiceLatestAttestationClient) Recv() (*v1.AggregatedAttestation, error) {
	m := new(v1.AggregatedAttestation)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *beaconServiceClient) CurrentAssignmentsAndGenesisTime(ctx context.Context, in *ValidatorAssignmentRequest, opts ...grpc.CallOption) (*CurrentAssignmentsResponse, error) {
	out := new(CurrentAssignmentsResponse)
	err := c.cc.Invoke(ctx, "/ethereum.beacon.rpc.v1.BeaconService/CurrentAssignmentsAndGenesisTime", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beaconServiceClient) ValidatorAssignments(ctx context.Context, in *ValidatorAssignmentRequest, opts ...grpc.CallOption) (BeaconService_ValidatorAssignmentsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeaconService_serviceDesc.Streams[1], "/ethereum.beacon.rpc.v1.BeaconService/ValidatorAssignments", opts...)
	if err != nil {
		return nil, err
	}
	x := &beaconServiceValidatorAssignmentsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BeaconService_ValidatorAssignmentsClient interface {
	Recv() (*ValidatorAssignmentResponse, error)
	grpc.ClientStream
}

type beaconServiceValidatorAssignmentsClient struct {
	grpc.ClientStream
}

func (x *beaconServiceValidatorAssignmentsClient) Recv() (*ValidatorAssignmentResponse, error) {
	m := new(ValidatorAssignmentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeaconServiceServer is the server API for BeaconService service.
type BeaconServiceServer interface {
	// CanonicalHead can be called on demand to fetch the current, head block of a
	// beacon node.
	CanonicalHead(context.Context, *empty.Empty) (*v1.BeaconBlock, error)
	// LatestAttestation streams the latest aggregated attestation to connected
	// validator clients.
	LatestAttestation(*empty.Empty, BeaconService_LatestAttestationServer) error
	// CurrentAssignmentsAndGenesisTime is called by a validator client upon first connecting
	// to a beacon node in order to determine the current validator assignments
	// and genesis timestamp of the protocol.
	CurrentAssignmentsAndGenesisTime(context.Context, *ValidatorAssignmentRequest) (*CurrentAssignmentsResponse, error)
	// ValidatorAssignments streams validator assignments to clients
	// for a subset of public keys in the active validator set.
	ValidatorAssignments(*ValidatorAssignmentRequest, BeaconService_ValidatorAssignmentsServer) error
}

func RegisterBeaconServiceServer(s *grpc.Server, srv BeaconServiceServer) {
	s.RegisterService(&_BeaconService_serviceDesc, srv)
}

func _BeaconService_CanonicalHead_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BeaconServiceServer).CanonicalHead(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/ethereum.beacon.rpc.v1.BeaconService/CanonicalHead",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BeaconServiceServer).CanonicalHead(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _BeaconService_LatestAttestation_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(empty.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BeaconServiceServer).LatestAttestation(m, &beaconServiceLatestAttestationServer{stream})
}

type BeaconService_LatestAttestationServer interface {
	Send(*v1.AggregatedAttestation) error
	grpc.ServerStream
}

type beaconServiceLatestAttestationServer struct {
	grpc.ServerStream
}

func (x *beaconServiceLatestAttestationServer) Send(m *v1.AggregatedAttestation) error {
	return x.ServerStream.SendMsg(m)
}

func _BeaconService_CurrentAssignmentsAndGenesisTime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidatorAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BeaconServiceServer).CurrentAssignmentsAndGenesisTime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/ethereum.beacon.rpc.v1.BeaconService/CurrentAssignmentsAndGenesisTime",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BeaconServiceServer).CurrentAssignmentsAndGenesisTime(ctx, req.(*ValidatorAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BeaconService_ValidatorAssignments_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ValidatorAssignmentRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BeaconServiceServer).ValidatorAssignments(m, &beaconServiceValidatorAssignmentsServer{stream})
}

type BeaconService_ValidatorAssignmentsServer interface {
	Send(*ValidatorAssignmentResponse) error
	grpc.ServerStream
}

type beaconServiceValidatorAssignmentsServer struct {
	grpc.ServerStream
}

func (x *beaconServiceValidatorAssignmentsServer) Send(m *ValidatorAssignmentResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _BeaconService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "ethereum.beacon.rpc.v1.BeaconService",
	HandlerType: (*BeaconServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CanonicalHead",
			Handler:    _BeaconService_CanonicalHead_Handler,
		},
		{
			MethodName: "CurrentAssignmentsAndGenesisTime",
			Handler:    _BeaconService_CurrentAssignmentsAndGenesisTime_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "LatestAttestation",
			Handler:       _BeaconService_LatestAttestation_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ValidatorAssignments",
			Handler:       _BeaconService_ValidatorAssignments_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "proto/beacon/rpc/v1/services.proto",
}

// AttesterServiceClient is the client API for AttesterService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AttesterServiceClient interface {
	AttestHead(ctx context.Context, in *AttestRequest, opts ...grpc.CallOption) (*AttestResponse, error)
}

type attesterServiceClient struct {
	cc *grpc.ClientConn
}

func NewAttesterServiceClient(cc *grpc.ClientConn) AttesterServiceClient {
	return &attesterServiceClient{cc}
}

func (c *attesterServiceClient) AttestHead(ctx context.Context, in *AttestRequest, opts ...grpc.CallOption) (*AttestResponse, error) {
	out := new(AttestResponse)
	err := c.cc.Invoke(ctx, "/ethereum.beacon.rpc.v1.AttesterService/AttestHead", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AttesterServiceServer is the server API for AttesterService service.
type AttesterServiceServer interface {
	AttestHead(context.Context, *AttestRequest) (*AttestResponse, error)
}

func RegisterAttesterServiceServer(s *grpc.Server, srv AttesterServiceServer) {
	s.RegisterService(&_AttesterService_serviceDesc, srv)
}

func _AttesterService_AttestHead_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttesterServiceServer).AttestHead(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/ethereum.beacon.rpc.v1.AttesterService/AttestHead",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttesterServiceServer).AttestHead(ctx, req.(*AttestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AttesterService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "ethereum.beacon.rpc.v1.AttesterService",
	HandlerType: (*AttesterServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AttestHead",
			Handler:    _AttesterService_AttestHead_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "proto/beacon/rpc/v1/services.proto",
}

// ProposerServiceClient is the client API for ProposerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProposerServiceClient interface {
	ProposeBlock(ctx context.Context, in *ProposeRequest, opts ...grpc.CallOption) (*ProposeResponse, error)
}

type proposerServiceClient struct {
	cc *grpc.ClientConn
}

func NewProposerServiceClient(cc *grpc.ClientConn) ProposerServiceClient {
	return &proposerServiceClient{cc}
}

func (c *proposerServiceClient) ProposeBlock(ctx context.Context, in *ProposeRequest, opts ...grpc.CallOption) (*ProposeResponse, error) {
	out := new(ProposeResponse)
	err := c.cc.Invoke(ctx, "/ethereum.beacon.rpc.v1.ProposerService/ProposeBlock", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProposerServiceServer is the server API for ProposerService service.
type ProposerServiceServer interface {
	ProposeBlock(context.Context, *ProposeRequest) (*ProposeResponse, error)
}

func RegisterProposerServiceServer(s *grpc.Server, srv ProposerServiceServer) {
	s.RegisterService(&_ProposerService_serviceDesc, srv)
}

func _ProposerService_ProposeBlock_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProposeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProposerServiceServer).ProposeBlock(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/ethereum.beacon.rpc.v1.ProposerService/ProposeBlock",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProposerServiceServer).ProposeBlock(ctx, req.(*ProposeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProposerService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "ethereum.beacon.rpc.v1.ProposerService",
	HandlerType: (*ProposerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ProposeBlock",
			Handler:    _ProposerService_ProposeBlock_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "proto/beacon/rpc/v1/services.proto",
}

// ValidatorServiceClient is the client API for ValidatorService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ValidatorServiceClient interface {
	// These endpoints can be called on demand in the future
	// by some web3 API for users to conveniently know their assignment.
	ValidatorShardID(ctx context.Context, in *PublicKey, opts ...grpc.CallOption) (*ShardIDResponse, error)
	ValidatorIndex(ctx context.Context, in *PublicKey, opts ...grpc.CallOption) (*IndexResponse, error)
	ValidatorSlotAndResponsibility(ctx context.Context, in *PublicKey, opts ...grpc.CallOption) (*SlotResponsibilityResponse, error)
}

type validatorServiceClient struct {
	cc *grpc.ClientConn
}

func NewValidatorServiceClient(cc *grpc.ClientConn) ValidatorServiceClient {
	return &validatorServiceClient{cc}
}

func (c *validatorServiceClient) ValidatorShardID(ctx context.Context, in *PublicKey, opts ...grpc.CallOption) (*ShardIDResponse, error) {
	out := new(ShardIDResponse)
	err := c.cc.Invoke(ctx, "/ethereum.beacon.rpc.v1.ValidatorService/ValidatorShardID", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *validatorServiceClient) ValidatorIndex(ctx context.Context, in *PublicKey, opts ...grpc.CallOption) (*IndexResponse, error) {
	out := new(IndexResponse)
	err := c.cc.Invoke(ctx, "/ethereum.beacon.rpc.v1.ValidatorService/ValidatorIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *validatorServiceClient) ValidatorSlotAndResponsibility(ctx context.Context, in *PublicKey, opts ...grpc.CallOption) (*SlotResponsibilityResponse, error) {
	out := new(SlotResponsibilityResponse)
	err := c.cc.Invoke(ctx, "/ethereum.beacon.rpc.v1.ValidatorService/ValidatorSlotAndResponsibility", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ValidatorServiceServer is the server API for ValidatorService service.
type ValidatorServiceServer interface {
	// These endpoints can be called on demand in the future
	// by some web3 API for users to conveniently know their assignment.
	ValidatorShardID(context.Context, *PublicKey) (*ShardIDResponse, error)
	ValidatorIndex(context.Context, *PublicKey) (*IndexResponse, error)
	ValidatorSlotAndResponsibility(context.Context, *PublicKey) (*SlotResponsibilityResponse, error)
}

func RegisterValidatorServiceServer(s *grpc.Server, srv ValidatorServiceServer) {
	s.RegisterService(&_ValidatorService_serviceDesc, srv)
}

func _ValidatorService_ValidatorShardID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublicKey)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ValidatorServiceServer).ValidatorShardID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/ethereum.beacon.rpc.v1.ValidatorService/ValidatorShardID",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ValidatorServiceServer).ValidatorShardID(ctx, req.(*PublicKey))
	}
	return interceptor(ctx, in, info, handler)
}

func _ValidatorService_ValidatorIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublicKey)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ValidatorServiceServer).ValidatorIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/ethereum.beacon.rpc.v1.ValidatorService/ValidatorIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ValidatorServiceServer).ValidatorIndex(ctx, req.(*PublicKey))
	}
	return interceptor(ctx, in, info, handler)
}

func _ValidatorService_ValidatorSlotAndResponsibility_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublicKey)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ValidatorServiceServer).ValidatorSlotAndResponsibility(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/ethereum.beacon.rpc.v1.ValidatorService/ValidatorSlotAndResponsibility",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ValidatorServiceServer).ValidatorSlotAndResponsibility(ctx, req.(*PublicKey))
	}
	return interceptor(ctx, in, info, handler)
}

var _ValidatorService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "ethereum.beacon.rpc.v1.ValidatorService",
	HandlerType: (*ValidatorServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ValidatorShardID",
			Handler:    _ValidatorService_ValidatorShardID_Handler,
		},
		{
			MethodName: "ValidatorIndex",
			Handler:    _ValidatorService_ValidatorIndex_Handler,
		},
		{
			MethodName: "ValidatorSlotAndResponsibility",
			Handler:    _ValidatorService_ValidatorSlotAndResponsibility_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "proto/beacon/rpc/v1/services.proto",
}

func init() {
	proto.RegisterFile("proto/beacon/rpc/v1/services.proto", fileDescriptor_services_54e1be11fa7a94d4)
}

var fileDescriptor_services_54e1be11fa7a94d4 = []byte{
	// 929 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0x6f, 0x6f, 0xdb, 0x44,
	0x1c, 0xc6, 0x69, 0xb6, 0xb5, 0xbf, 0xc4, 0x69, 0x76, 0x4c, 0x23, 0xf3, 0x04, 0x0b, 0x9e, 0x0a,
	0x61, 0x02, 0xa7, 0xf5, 0xde, 0x0c, 0x78, 0x43, 0xba, 0x55, 0xdb, 0xb4, 0xa9, 0xad, 0x9c, 0x02,
	0x12, 0x20, 0xcc, 0x25, 0x3e, 0x1c, 0xab, 0x8e, 0xcf, 0xdc, 0x5d, 0x02, 0x7d, 0xc9, 0x2b, 0x24,
	0x3e, 0x04, 0x5f, 0x80, 0x0f, 0x82, 0x90, 0xf8, 0x50, 0xe8, 0xce, 0xf6, 0xd9, 0x69, 0x6b, 0xd2,
	0xa2, 0xbd, 0xb3, 0x9f, 0xfb, 0xfd, 0x79, 0xee, 0xb9, 0xdf, 0x3d, 0x07, 0x76, 0xca, 0xa8, 0xa0,
	0xc3, 0x09, 0xc1, 0x53, 0x9a, 0x0c, 0x59, 0x3a, 0x1d, 0x2e, 0xf7, 0x86, 0x9c, 0xb0, 0x65, 0x34,
	0x25, 0xdc, 0x51, 0x8b, 0xe8, 0x2e, 0x11, 0x33, 0xc2, 0xc8, 0x62, 0xee, 0x64, 0x61, 0x0e, 0x4b,
	0xa7, 0xce, 0x72, 0xcf, 0x5a, 0xcd, 0x4d, 0xdd, 0x54, 0xe6, 0xce, 0x09, 0xe7, 0x38, 0x2c, 0x72,
	0xad, 0xfb, 0x21, 0xa5, 0x61, 0x4c, 0x86, 0xea, 0x6f, 0xb2, 0xf8, 0x71, 0x48, 0xe6, 0xa9, 0x38,
	0xcb, 0x17, 0x1f, 0x9c, 0x5f, 0x14, 0xd1, 0x9c, 0x70, 0x81, 0xe7, 0x69, 0x16, 0x60, 0xff, 0xd1,
	0x80, 0xce, 0x31, 0xa3, 0x29, 0xe5, 0xc4, 0x23, 0x3f, 0x2d, 0x08, 0x17, 0xe8, 0x01, 0xb4, 0x52,
	0xcc, 0x48, 0x22, 0xfc, 0x19, 0xe6, 0xb3, 0x9e, 0xd1, 0x37, 0x06, 0x6d, 0x0f, 0x32, 0xe8, 0x05,
	0xe6, 0x33, 0x19, 0xc0, 0x63, 0x2a, 0xfc, 0x64, 0x31, 0x9f, 0x10, 0xd6, 0x6b, 0xf4, 0x8d, 0x41,
	0xd3, 0x03, 0x09, 0x1d, 0x2a, 0x04, 0x3d, 0x04, 0x93, 0xe1, 0x24, 0xc0, 0xd4, 0x67, 0x64, 0x49,
	0x70, 0xdc, 0xdb, 0x50, 0x35, 0xda, 0x19, 0xe8, 0x29, 0x0c, 0x0d, 0xe1, 0x6d, 0x2c, 0x84, 0x24,
	0x23, 0x22, 0x9a, 0xf8, 0x93, 0x48, 0xcc, 0x31, 0x3f, 0xed, 0x35, 0x55, 0x28, 0xaa, 0x2c, 0xed,
	0x67, 0x2b, 0xe8, 0x33, 0xb8, 0x57, 0x4d, 0xc0, 0x61, 0xc8, 0x48, 0x88, 0x05, 0xf1, 0x79, 0x14,
	0xf6, 0x6e, 0xf4, 0x37, 0x06, 0xa6, 0xf7, 0x4e, 0x25, 0x60, 0x54, 0xac, 0x8f, 0xa3, 0x10, 0x3d,
	0x81, 0x2d, 0xbd, 0xf3, 0xde, 0xcd, 0xbe, 0x31, 0x68, 0xb9, 0x96, 0x93, 0x69, 0xe3, 0x14, 0xda,
	0x38, 0x27, 0x45, 0x84, 0x57, 0x06, 0xdb, 0xbb, 0xb0, 0xad, 0xf5, 0xe1, 0x29, 0x4d, 0x38, 0x41,
	0xef, 0x02, 0x4c, 0x62, 0x3a, 0x3d, 0xad, 0xea, 0xb3, 0xa5, 0x10, 0x29, 0x8f, 0xfd, 0x03, 0x98,
	0x23, 0x45, 0xa3, 0x10, 0xf4, 0x08, 0x5a, 0x15, 0x5e, 0x2a, 0xa1, 0xe5, 0x7e, 0xe2, 0x9c, 0x3f,
	0xf3, 0xd4, 0x4d, 0x9d, 0xe5, 0x9e, 0xa3, 0x79, 0x07, 0xa3, 0x32, 0xc9, 0xab, 0x56, 0xb0, 0x3f,
	0x87, 0x4e, 0xd1, 0x21, 0xa7, 0xf4, 0x11, 0x74, 0xab, 0xda, 0x54, 0x88, 0x6d, 0x57, 0x70, 0x45,
	0xef, 0x37, 0x03, 0xac, 0xaf, 0x70, 0x1c, 0x05, 0x58, 0x50, 0x36, 0xe2, 0x3c, 0x0a, 0x93, 0x39,
	0x49, 0x34, 0xd9, 0x1d, 0xe8, 0xe0, 0x38, 0xf6, 0x97, 0x45, 0x04, 0x57, 0x75, 0x36, 0x3d, 0x13,
	0xc7, 0xb1, 0x4e, 0xe3, 0x68, 0x1f, 0x5a, 0xe9, 0x62, 0x12, 0x47, 0x53, 0xff, 0x94, 0x9c, 0xf1,
	0x5e, 0xa3, 0xbf, 0x31, 0x68, 0xb9, 0xef, 0x3b, 0x97, 0xcf, 0xb1, 0x73, 0xac, 0x42, 0x5f, 0x91,
	0x33, 0x0f, 0xd2, 0xe2, 0x93, 0xdb, 0x53, 0xb8, 0x7f, 0x29, 0x91, 0x7c, 0x4f, 0xcf, 0xa0, 0x85,
	0x35, 0x2a, 0x69, 0xc8, 0x16, 0x76, 0x5d, 0x8b, 0x4a, 0x81, 0x6a, 0x9a, 0xfd, 0xb7, 0x01, 0x50,
	0xae, 0xa1, 0x2f, 0x00, 0x4a, 0xde, 0xf9, 0x51, 0x5c, 0x81, 0xf6, 0x96, 0xa6, 0x8d, 0xee, 0xc1,
	0x26, 0x9f, 0x61, 0x16, 0xf8, 0x51, 0x90, 0x8f, 0xfe, 0x2d, 0xf5, 0xff, 0x32, 0x40, 0x9f, 0x42,
	0x93, 0xd1, 0x98, 0xa8, 0x71, 0xef, 0xb8, 0x3b, 0x75, 0x65, 0xf5, 0xa6, 0x3d, 0x1a, 0x13, 0x4f,
	0xa5, 0xc8, 0x2b, 0x93, 0xb1, 0x26, 0x81, 0x2f, 0x6f, 0x92, 0xba, 0x07, 0x4d, 0xaf, 0x5d, 0x80,
	0xe3, 0x98, 0x0a, 0xfb, 0x11, 0x6c, 0x69, 0x4a, 0x72, 0x0a, 0xcf, 0xed, 0xa4, 0x5d, 0xa1, 0x69,
	0x9f, 0x82, 0x25, 0x73, 0x72, 0x35, 0xa3, 0x49, 0x14, 0x47, 0xe2, 0x4c, 0x6b, 0x8b, 0xa0, 0xa9,
	0xba, 0x18, 0xaa, 0x8b, 0xfa, 0xd6, 0xec, 0x1b, 0xd7, 0x66, 0x6f, 0xef, 0x80, 0xf9, 0x32, 0x09,
	0xc8, 0x2f, 0xba, 0xfe, 0x1d, 0xb8, 0x11, 0x49, 0x40, 0x35, 0x30, 0xbd, 0xec, 0xc7, 0xfe, 0x18,
	0xb6, 0xc7, 0x4a, 0xaa, 0x67, 0x3a, 0xb0, 0xaa, 0xa6, 0xb1, 0xa2, 0xa6, 0xfd, 0xa7, 0x01, 0xd6,
	0xd3, 0x05, 0x93, 0xb6, 0x53, 0x1e, 0x20, 0x7f, 0xb3, 0xe3, 0x81, 0x9e, 0xc3, 0xed, 0x90, 0x24,
	0x84, 0x47, 0xdc, 0x2f, 0x0d, 0xa2, 0xb1, 0xd6, 0x20, 0xba, 0x79, 0x92, 0x46, 0x1e, 0x3d, 0x01,
	0x73, 0x45, 0x19, 0xd4, 0x82, 0x5b, 0x5f, 0x1e, 0xbe, 0x3a, 0x3c, 0xfa, 0xfa, 0xb0, 0xfb, 0x16,
	0x6a, 0xc3, 0xe6, 0xe8, 0xe4, 0xe4, 0x60, 0x7c, 0x72, 0xe0, 0x75, 0x0d, 0xf9, 0x77, 0xec, 0x1d,
	0x1d, 0x1f, 0x8d, 0x0f, 0xbc, 0x6e, 0xc3, 0xfd, 0x67, 0x03, 0xcc, 0x7d, 0x45, 0x76, 0x9c, 0xbd,
	0x0a, 0xe8, 0x35, 0x98, 0x4f, 0x71, 0x42, 0x93, 0x68, 0x8a, 0xe3, 0x17, 0x04, 0x07, 0xe8, 0xee,
	0x05, 0x2a, 0x07, 0xd2, 0xe4, 0xad, 0x87, 0x75, 0x26, 0x92, 0xd5, 0xdb, 0x97, 0x9e, 0x84, 0xbe,
	0x83, 0xdb, 0xaf, 0xb1, 0xf4, 0x80, 0x8a, 0x9f, 0xd4, 0x56, 0xbc, 0x9e, 0x2d, 0xed, 0x1a, 0xe8,
	0x77, 0x03, 0xfa, 0x17, 0x4f, 0x69, 0x94, 0x04, 0xcf, 0x4b, 0x85, 0x90, 0xbb, 0x76, 0x98, 0x2e,
	0x18, 0x91, 0x55, 0x9b, 0xf3, 0x1f, 0x33, 0xf1, 0xab, 0x01, 0x77, 0x2e, 0x29, 0xc9, 0xff, 0x17,
	0x81, 0xc7, 0xd7, 0xca, 0xc9, 0x18, 0xec, 0x1a, 0x6e, 0x02, 0xdb, 0x99, 0x42, 0x84, 0x15, 0xe7,
	0xf9, 0x2d, 0x40, 0x06, 0xa9, 0xc3, 0xac, 0xbd, 0x59, 0x2b, 0xaf, 0x86, 0xf5, 0xc1, 0xba, 0xb0,
	0xac, 0xa3, 0xcb, 0xf4, 0x03, 0xa5, 0xfb, 0xf9, 0xd0, 0xce, 0xa1, 0x6c, 0x02, 0x6a, 0x4b, 0xad,
	0xbe, 0xfc, 0xd6, 0x87, 0x6b, 0xe3, 0xf2, 0x9e, 0x7f, 0x35, 0xa0, 0xab, 0x55, 0x28, 0xba, 0x7e,
	0x5f, 0xc5, 0xb2, 0x6b, 0x8e, 0xd6, 0x5b, 0x6b, 0x7d, 0xd3, 0xf3, 0x56, 0xf1, 0x0d, 0x74, 0x74,
	0x7d, 0xe5, 0x36, 0x57, 0xa9, 0x5e, 0x2b, 0xf6, 0xaa, 0x5f, 0xfd, 0x0c, 0xef, 0x95, 0xdc, 0x63,
	0x2a, 0x46, 0x49, 0xb0, 0xea, 0x9c, 0x57, 0xe9, 0x55, 0x3b, 0x64, 0xf5, 0x46, 0x3c, 0xb9, 0xa9,
	0xee, 0xdf, 0xe3, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0xd7, 0xae, 0x60, 0x87, 0x26, 0x0a, 0x00,
	0x00,
}
