# OPS Charter

## Mission

To recreate the next generation of cloud infrastructure with the
following core tenents.

## Tenets (unless you know better ones)

These tenets guide OPS' development. They are guidelines and goals.

1. **Security**:

OPS is a builder/orchestrator for the Nanos unikernel. The underlying
kernel does not have the notion of users. It only runs one process per
virtual machine and does it's best to minimize the amount of code
incorporated into each vm. OPS as an interface to this unikernel should
reflect these concerns.

2. **Minimalist**: 

KISS - Keep it Simple Stupid. Current cloud infrastructure projects suffer from too much complexity which leads to performance, security and agility problems. The unikernel design philosophy is a rejection of this complexity.

3. **Performant**: 

There is much to be gained from incorporating a unikernel
infrastructure. One of them is performance. While there is much work to
be done here we should take care to keep this in mind in the surrounding
ecosystem.

## Contributions & Project Roles

All contributions must align with this charter.
