// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: opentelemetry/proto/logs/v1/logs.proto

package v1

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"

	go_opentelemetry_io_collector_pdata_internal_data "go.opentelemetry.io/collector/pdata/internal/data"
	v11 "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	v1 "go.opentelemetry.io/collector/pdata/internal/data/protogen/resource/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Possible values for LogRecord.SeverityNumber.
type SeverityNumber int32

const (
	// UNSPECIFIED is the default SeverityNumber, it MUST NOT be used.
	SeverityNumber_SEVERITY_NUMBER_UNSPECIFIED SeverityNumber = 0
	SeverityNumber_SEVERITY_NUMBER_TRACE       SeverityNumber = 1
	SeverityNumber_SEVERITY_NUMBER_TRACE2      SeverityNumber = 2
	SeverityNumber_SEVERITY_NUMBER_TRACE3      SeverityNumber = 3
	SeverityNumber_SEVERITY_NUMBER_TRACE4      SeverityNumber = 4
	SeverityNumber_SEVERITY_NUMBER_DEBUG       SeverityNumber = 5
	SeverityNumber_SEVERITY_NUMBER_DEBUG2      SeverityNumber = 6
	SeverityNumber_SEVERITY_NUMBER_DEBUG3      SeverityNumber = 7
	SeverityNumber_SEVERITY_NUMBER_DEBUG4      SeverityNumber = 8
	SeverityNumber_SEVERITY_NUMBER_INFO        SeverityNumber = 9
	SeverityNumber_SEVERITY_NUMBER_INFO2       SeverityNumber = 10
	SeverityNumber_SEVERITY_NUMBER_INFO3       SeverityNumber = 11
	SeverityNumber_SEVERITY_NUMBER_INFO4       SeverityNumber = 12
	SeverityNumber_SEVERITY_NUMBER_WARN        SeverityNumber = 13
	SeverityNumber_SEVERITY_NUMBER_WARN2       SeverityNumber = 14
	SeverityNumber_SEVERITY_NUMBER_WARN3       SeverityNumber = 15
	SeverityNumber_SEVERITY_NUMBER_WARN4       SeverityNumber = 16
	SeverityNumber_SEVERITY_NUMBER_ERROR       SeverityNumber = 17
	SeverityNumber_SEVERITY_NUMBER_ERROR2      SeverityNumber = 18
	SeverityNumber_SEVERITY_NUMBER_ERROR3      SeverityNumber = 19
	SeverityNumber_SEVERITY_NUMBER_ERROR4      SeverityNumber = 20
	SeverityNumber_SEVERITY_NUMBER_FATAL       SeverityNumber = 21
	SeverityNumber_SEVERITY_NUMBER_FATAL2      SeverityNumber = 22
	SeverityNumber_SEVERITY_NUMBER_FATAL3      SeverityNumber = 23
	SeverityNumber_SEVERITY_NUMBER_FATAL4      SeverityNumber = 24
)

var SeverityNumber_name = map[int32]string{
	0:  "SEVERITY_NUMBER_UNSPECIFIED",
	1:  "SEVERITY_NUMBER_TRACE",
	2:  "SEVERITY_NUMBER_TRACE2",
	3:  "SEVERITY_NUMBER_TRACE3",
	4:  "SEVERITY_NUMBER_TRACE4",
	5:  "SEVERITY_NUMBER_DEBUG",
	6:  "SEVERITY_NUMBER_DEBUG2",
	7:  "SEVERITY_NUMBER_DEBUG3",
	8:  "SEVERITY_NUMBER_DEBUG4",
	9:  "SEVERITY_NUMBER_INFO",
	10: "SEVERITY_NUMBER_INFO2",
	11: "SEVERITY_NUMBER_INFO3",
	12: "SEVERITY_NUMBER_INFO4",
	13: "SEVERITY_NUMBER_WARN",
	14: "SEVERITY_NUMBER_WARN2",
	15: "SEVERITY_NUMBER_WARN3",
	16: "SEVERITY_NUMBER_WARN4",
	17: "SEVERITY_NUMBER_ERROR",
	18: "SEVERITY_NUMBER_ERROR2",
	19: "SEVERITY_NUMBER_ERROR3",
	20: "SEVERITY_NUMBER_ERROR4",
	21: "SEVERITY_NUMBER_FATAL",
	22: "SEVERITY_NUMBER_FATAL2",
	23: "SEVERITY_NUMBER_FATAL3",
	24: "SEVERITY_NUMBER_FATAL4",
}

var SeverityNumber_value = map[string]int32{
	"SEVERITY_NUMBER_UNSPECIFIED": 0,
	"SEVERITY_NUMBER_TRACE":       1,
	"SEVERITY_NUMBER_TRACE2":      2,
	"SEVERITY_NUMBER_TRACE3":      3,
	"SEVERITY_NUMBER_TRACE4":      4,
	"SEVERITY_NUMBER_DEBUG":       5,
	"SEVERITY_NUMBER_DEBUG2":      6,
	"SEVERITY_NUMBER_DEBUG3":      7,
	"SEVERITY_NUMBER_DEBUG4":      8,
	"SEVERITY_NUMBER_INFO":        9,
	"SEVERITY_NUMBER_INFO2":       10,
	"SEVERITY_NUMBER_INFO3":       11,
	"SEVERITY_NUMBER_INFO4":       12,
	"SEVERITY_NUMBER_WARN":        13,
	"SEVERITY_NUMBER_WARN2":       14,
	"SEVERITY_NUMBER_WARN3":       15,
	"SEVERITY_NUMBER_WARN4":       16,
	"SEVERITY_NUMBER_ERROR":       17,
	"SEVERITY_NUMBER_ERROR2":      18,
	"SEVERITY_NUMBER_ERROR3":      19,
	"SEVERITY_NUMBER_ERROR4":      20,
	"SEVERITY_NUMBER_FATAL":       21,
	"SEVERITY_NUMBER_FATAL2":      22,
	"SEVERITY_NUMBER_FATAL3":      23,
	"SEVERITY_NUMBER_FATAL4":      24,
}

func (x SeverityNumber) String() string {
	return proto.EnumName(SeverityNumber_name, int32(x))
}

func (SeverityNumber) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d1c030a3ec7e961e, []int{0}
}

// Masks for LogRecord.flags field.
type LogRecordFlags int32

const (
	LogRecordFlags_LOG_RECORD_FLAG_UNSPECIFIED      LogRecordFlags = 0
	LogRecordFlags_LOG_RECORD_FLAG_TRACE_FLAGS_MASK LogRecordFlags = 255
)

var LogRecordFlags_name = map[int32]string{
	0:   "LOG_RECORD_FLAG_UNSPECIFIED",
	255: "LOG_RECORD_FLAG_TRACE_FLAGS_MASK",
}

var LogRecordFlags_value = map[string]int32{
	"LOG_RECORD_FLAG_UNSPECIFIED":      0,
	"LOG_RECORD_FLAG_TRACE_FLAGS_MASK": 255,
}

func (x LogRecordFlags) String() string {
	return proto.EnumName(LogRecordFlags_name, int32(x))
}

func (LogRecordFlags) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d1c030a3ec7e961e, []int{1}
}

// LogsData represents the logs data that can be stored in a persistent storage,
// OR can be embedded by other protocols that transfer OTLP logs data but do not
// implement the OTLP protocol.
//
// The main difference between this message and collector protocol is that
// in this message there will not be any "control" or "metadata" specific to
// OTLP protocol.
//
// When new fields are added into this message, the OTLP request MUST be updated
// as well.
type LogsData struct {
	// An array of ResourceLogs.
	// For data coming from a single resource this array will typically contain
	// one element. Intermediary nodes that receive data from multiple origins
	// typically batch the data before forwarding further and in that case this
	// array will contain multiple elements.
	ResourceLogs []*ResourceLogs `protobuf:"bytes,1,rep,name=resource_logs,json=resourceLogs,proto3" json:"resource_logs,omitempty"`
}

func (m *LogsData) Reset()         { *m = LogsData{} }
func (m *LogsData) String() string { return proto.CompactTextString(m) }
func (*LogsData) ProtoMessage()    {}
func (*LogsData) Descriptor() ([]byte, []int) {
	return fileDescriptor_d1c030a3ec7e961e, []int{0}
}
func (m *LogsData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LogsData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LogsData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LogsData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogsData.Merge(m, src)
}
func (m *LogsData) XXX_Size() int {
	return m.Size()
}
func (m *LogsData) XXX_DiscardUnknown() {
	xxx_messageInfo_LogsData.DiscardUnknown(m)
}

var xxx_messageInfo_LogsData proto.InternalMessageInfo

func (m *LogsData) GetResourceLogs() []*ResourceLogs {
	if m != nil {
		return m.ResourceLogs
	}
	return nil
}

// A collection of ScopeLogs from a Resource.
type ResourceLogs struct {
	// The resource for the logs in this message.
	// If this field is not set then resource info is unknown.
	Resource v1.Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource"`
	// A list of ScopeLogs that originate from a resource.
	ScopeLogs []*ScopeLogs `protobuf:"bytes,2,rep,name=scope_logs,json=scopeLogs,proto3" json:"scope_logs,omitempty"`
	// A list of InstrumentationLibraryLogs that originate from a resource.
	// This field is deprecated and will be removed after grace period expires on June 15, 2022.
	//
	// During the grace period the following rules SHOULD be followed:
	//
	// For Binary Protobufs
	// ====================
	// Binary Protobuf senders SHOULD NOT set instrumentation_library_logs. Instead
	// scope_logs SHOULD be set.
	//
	// Binary Protobuf receivers SHOULD check if instrumentation_library_logs is set
	// and scope_logs is not set then the value in instrumentation_library_logs
	// SHOULD be used instead by converting InstrumentationLibraryLogs into ScopeLogs.
	// If scope_logs is set then instrumentation_library_logs SHOULD be ignored.
	//
	// For JSON
	// ========
	// JSON senders that set instrumentation_library_logs field MAY also set
	// scope_logs to carry the same logs, essentially double-publishing the same data.
	// Such double-publishing MAY be controlled by a user-settable option.
	// If double-publishing is not used then the senders SHOULD set scope_logs and
	// SHOULD NOT set instrumentation_library_logs.
	//
	// JSON receivers SHOULD check if instrumentation_library_logs is set and
	// scope_logs is not set then the value in instrumentation_library_logs
	// SHOULD be used instead by converting InstrumentationLibraryLogs into ScopeLogs.
	// If scope_logs is set then instrumentation_library_logs field SHOULD be ignored.
	InstrumentationLibraryLogs []*InstrumentationLibraryLogs `protobuf:"bytes,1000,rep,name=instrumentation_library_logs,json=instrumentationLibraryLogs,proto3" json:"instrumentation_library_logs,omitempty"` // Deprecated: Do not use.
	// This schema_url applies to the data in the "resource" field. It does not apply
	// to the data in the "scope_logs" field which have their own schema_url field.
	SchemaUrl string `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
}

func (m *ResourceLogs) Reset()         { *m = ResourceLogs{} }
func (m *ResourceLogs) String() string { return proto.CompactTextString(m) }
func (*ResourceLogs) ProtoMessage()    {}
func (*ResourceLogs) Descriptor() ([]byte, []int) {
	return fileDescriptor_d1c030a3ec7e961e, []int{1}
}
func (m *ResourceLogs) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceLogs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceLogs.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceLogs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceLogs.Merge(m, src)
}
func (m *ResourceLogs) XXX_Size() int {
	return m.Size()
}
func (m *ResourceLogs) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceLogs.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceLogs proto.InternalMessageInfo

func (m *ResourceLogs) GetResource() v1.Resource {
	if m != nil {
		return m.Resource
	}
	return v1.Resource{}
}

func (m *ResourceLogs) GetScopeLogs() []*ScopeLogs {
	if m != nil {
		return m.ScopeLogs
	}
	return nil
}

// Deprecated: Do not use.
func (m *ResourceLogs) GetInstrumentationLibraryLogs() []*InstrumentationLibraryLogs {
	if m != nil {
		return m.InstrumentationLibraryLogs
	}
	return nil
}

func (m *ResourceLogs) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// A collection of Logs produced by a Scope.
type ScopeLogs struct {
	// The instrumentation scope information for the logs in this message.
	// Semantically when InstrumentationScope isn't set, it is equivalent with
	// an empty instrumentation scope name (unknown).
	Scope v11.InstrumentationScope `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope"`
	// A list of log records.
	LogRecords []*LogRecord `protobuf:"bytes,2,rep,name=log_records,json=logRecords,proto3" json:"log_records,omitempty"`
	// This schema_url applies to all logs in the "logs" field.
	SchemaUrl string `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
}

func (m *ScopeLogs) Reset()         { *m = ScopeLogs{} }
func (m *ScopeLogs) String() string { return proto.CompactTextString(m) }
func (*ScopeLogs) ProtoMessage()    {}
func (*ScopeLogs) Descriptor() ([]byte, []int) {
	return fileDescriptor_d1c030a3ec7e961e, []int{2}
}
func (m *ScopeLogs) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScopeLogs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScopeLogs.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScopeLogs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScopeLogs.Merge(m, src)
}
func (m *ScopeLogs) XXX_Size() int {
	return m.Size()
}
func (m *ScopeLogs) XXX_DiscardUnknown() {
	xxx_messageInfo_ScopeLogs.DiscardUnknown(m)
}

var xxx_messageInfo_ScopeLogs proto.InternalMessageInfo

func (m *ScopeLogs) GetScope() v11.InstrumentationScope {
	if m != nil {
		return m.Scope
	}
	return v11.InstrumentationScope{}
}

func (m *ScopeLogs) GetLogRecords() []*LogRecord {
	if m != nil {
		return m.LogRecords
	}
	return nil
}

func (m *ScopeLogs) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// A collection of Logs produced by an InstrumentationLibrary.
// InstrumentationLibraryLogs is wire-compatible with ScopeLogs for binary
// Protobuf format.
// This message is deprecated and will be removed on June 15, 2022.
//
// Deprecated: Do not use.
type InstrumentationLibraryLogs struct {
	// The instrumentation library information for the logs in this message.
	// Semantically when InstrumentationLibrary isn't set, it is equivalent with
	// an empty instrumentation library name (unknown).
	InstrumentationLibrary v11.InstrumentationLibrary `protobuf:"bytes,1,opt,name=instrumentation_library,json=instrumentationLibrary,proto3" json:"instrumentation_library"`
	// A list of logs that originate from an instrumentation library.
	LogRecords []*LogRecord `protobuf:"bytes,2,rep,name=log_records,json=logRecords,proto3" json:"log_records,omitempty"`
	// This schema_url applies to all logs in the "logs" field.
	SchemaUrl string `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
}

func (m *InstrumentationLibraryLogs) Reset()         { *m = InstrumentationLibraryLogs{} }
func (m *InstrumentationLibraryLogs) String() string { return proto.CompactTextString(m) }
func (*InstrumentationLibraryLogs) ProtoMessage()    {}
func (*InstrumentationLibraryLogs) Descriptor() ([]byte, []int) {
	return fileDescriptor_d1c030a3ec7e961e, []int{3}
}
func (m *InstrumentationLibraryLogs) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstrumentationLibraryLogs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstrumentationLibraryLogs.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InstrumentationLibraryLogs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstrumentationLibraryLogs.Merge(m, src)
}
func (m *InstrumentationLibraryLogs) XXX_Size() int {
	return m.Size()
}
func (m *InstrumentationLibraryLogs) XXX_DiscardUnknown() {
	xxx_messageInfo_InstrumentationLibraryLogs.DiscardUnknown(m)
}

var xxx_messageInfo_InstrumentationLibraryLogs proto.InternalMessageInfo

func (m *InstrumentationLibraryLogs) GetInstrumentationLibrary() v11.InstrumentationLibrary {
	if m != nil {
		return m.InstrumentationLibrary
	}
	return v11.InstrumentationLibrary{}
}

func (m *InstrumentationLibraryLogs) GetLogRecords() []*LogRecord {
	if m != nil {
		return m.LogRecords
	}
	return nil
}

func (m *InstrumentationLibraryLogs) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// A log record according to OpenTelemetry Log Data Model:
// https://github.com/open-telemetry/oteps/blob/main/text/logs/0097-log-data-model.md
type LogRecord struct {
	// time_unix_nano is the time when the event occurred.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	// Value of 0 indicates unknown or missing timestamp.
	TimeUnixNano uint64 `protobuf:"fixed64,1,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// Time when the event was observed by the collection system.
	// For events that originate in OpenTelemetry (e.g. using OpenTelemetry Logging SDK)
	// this timestamp is typically set at the generation time and is equal to Timestamp.
	// For events originating externally and collected by OpenTelemetry (e.g. using
	// Collector) this is the time when OpenTelemetry's code observed the event measured
	// by the clock of the OpenTelemetry code. This field MUST be set once the event is
	// observed by OpenTelemetry.
	//
	// For converting OpenTelemetry log data to formats that support only one timestamp or
	// when receiving OpenTelemetry log data by recipients that support only one timestamp
	// internally the following logic is recommended:
	//   - Use time_unix_nano if it is present, otherwise use observed_time_unix_nano.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	// Value of 0 indicates unknown or missing timestamp.
	ObservedTimeUnixNano uint64 `protobuf:"fixed64,11,opt,name=observed_time_unix_nano,json=observedTimeUnixNano,proto3" json:"observed_time_unix_nano,omitempty"`
	// Numerical value of the severity, normalized to values described in Log Data Model.
	// [Optional].
	SeverityNumber SeverityNumber `protobuf:"varint,2,opt,name=severity_number,json=severityNumber,proto3,enum=opentelemetry.proto.logs.v1.SeverityNumber" json:"severity_number,omitempty"`
	// The severity text (also known as log level). The original string representation as
	// it is known at the source. [Optional].
	SeverityText string `protobuf:"bytes,3,opt,name=severity_text,json=severityText,proto3" json:"severity_text,omitempty"`
	// A value containing the body of the log record. Can be for example a human-readable
	// string message (including multi-line) describing the event in a free form or it can
	// be a structured data composed of arrays and maps of other values. [Optional].
	Body v11.AnyValue `protobuf:"bytes,5,opt,name=body,proto3" json:"body"`
	// Additional attributes that describe the specific event occurrence. [Optional].
	// Attribute keys MUST be unique (it is not allowed to have more than one
	// attribute with the same key).
	Attributes             []v11.KeyValue `protobuf:"bytes,6,rep,name=attributes,proto3" json:"attributes"`
	DroppedAttributesCount uint32         `protobuf:"varint,7,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
	// Flags, a bit field. 8 least significant bits are the trace flags as
	// defined in W3C Trace Context specification. 24 most significant bits are reserved
	// and must be set to 0. Readers must not assume that 24 most significant bits
	// will be zero and must correctly mask the bits when reading 8-bit trace flag (use
	// flags & TRACE_FLAGS_MASK). [Optional].
	Flags uint32 `protobuf:"fixed32,8,opt,name=flags,proto3" json:"flags,omitempty"`
	// A unique identifier for a trace. All logs from the same trace share
	// the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes
	// is considered invalid. Can be set for logs that are part of request processing
	// and have an assigned trace id. [Optional].
	TraceId go_opentelemetry_io_collector_pdata_internal_data.TraceID `protobuf:"bytes,9,opt,name=trace_id,json=traceId,proto3,customtype=go.opentelemetry.io/collector/pdata/internal/data.TraceID" json:"trace_id"`
	// A unique identifier for a span within a trace, assigned when the span
	// is created. The ID is an 8-byte array. An ID with all zeroes is considered
	// invalid. Can be set for logs that are part of a particular processing span.
	// If span_id is present trace_id SHOULD be also present. [Optional].
	SpanId go_opentelemetry_io_collector_pdata_internal_data.SpanID `protobuf:"bytes,10,opt,name=span_id,json=spanId,proto3,customtype=go.opentelemetry.io/collector/pdata/internal/data.SpanID" json:"span_id"`
}

func (m *LogRecord) Reset()         { *m = LogRecord{} }
func (m *LogRecord) String() string { return proto.CompactTextString(m) }
func (*LogRecord) ProtoMessage()    {}
func (*LogRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_d1c030a3ec7e961e, []int{4}
}
func (m *LogRecord) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LogRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LogRecord.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LogRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogRecord.Merge(m, src)
}
func (m *LogRecord) XXX_Size() int {
	return m.Size()
}
func (m *LogRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_LogRecord.DiscardUnknown(m)
}

var xxx_messageInfo_LogRecord proto.InternalMessageInfo

func (m *LogRecord) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *LogRecord) GetObservedTimeUnixNano() uint64 {
	if m != nil {
		return m.ObservedTimeUnixNano
	}
	return 0
}

func (m *LogRecord) GetSeverityNumber() SeverityNumber {
	if m != nil {
		return m.SeverityNumber
	}
	return SeverityNumber_SEVERITY_NUMBER_UNSPECIFIED
}

func (m *LogRecord) GetSeverityText() string {
	if m != nil {
		return m.SeverityText
	}
	return ""
}

func (m *LogRecord) GetBody() v11.AnyValue {
	if m != nil {
		return m.Body
	}
	return v11.AnyValue{}
}

func (m *LogRecord) GetAttributes() []v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *LogRecord) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

func (m *LogRecord) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func init() {
	proto.RegisterEnum("opentelemetry.proto.logs.v1.SeverityNumber", SeverityNumber_name, SeverityNumber_value)
	proto.RegisterEnum("opentelemetry.proto.logs.v1.LogRecordFlags", LogRecordFlags_name, LogRecordFlags_value)
	proto.RegisterType((*LogsData)(nil), "opentelemetry.proto.logs.v1.LogsData")
	proto.RegisterType((*ResourceLogs)(nil), "opentelemetry.proto.logs.v1.ResourceLogs")
	proto.RegisterType((*ScopeLogs)(nil), "opentelemetry.proto.logs.v1.ScopeLogs")
	proto.RegisterType((*InstrumentationLibraryLogs)(nil), "opentelemetry.proto.logs.v1.InstrumentationLibraryLogs")
	proto.RegisterType((*LogRecord)(nil), "opentelemetry.proto.logs.v1.LogRecord")
}

func init() {
	proto.RegisterFile("opentelemetry/proto/logs/v1/logs.proto", fileDescriptor_d1c030a3ec7e961e)
}

var fileDescriptor_d1c030a3ec7e961e = []byte{
	// 971 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x96, 0x41, 0x73, 0x22, 0x45,
	0x14, 0xc7, 0x33, 0x24, 0x04, 0xe8, 0x10, 0xb6, 0x6d, 0xb3, 0xc9, 0x48, 0x94, 0x50, 0x51, 0x57,
	0x8c, 0x55, 0x50, 0x0b, 0x6c, 0xb9, 0x7a, 0x72, 0x08, 0x43, 0x0a, 0x43, 0x20, 0xd5, 0xc0, 0xea,
	0x6e, 0x59, 0x35, 0x35, 0x40, 0x8b, 0x53, 0x35, 0x4c, 0x53, 0x3d, 0x4d, 0x2a, 0x5c, 0x3c, 0x79,
	0xf1, 0xe6, 0x57, 0xb2, 0xf4, 0xb0, 0xc7, 0x3d, 0x5a, 0x1e, 0xb6, 0xac, 0xe4, 0xe2, 0xa7, 0x50,
	0xab, 0x7b, 0x06, 0x04, 0x9c, 0x21, 0xe6, 0xb2, 0x27, 0xba, 0xdf, 0xef, 0xbd, 0x7f, 0xff, 0x5f,
	0x77, 0x4f, 0x17, 0xe0, 0x11, 0x1d, 0x13, 0x87, 0x13, 0x9b, 0x8c, 0x08, 0x67, 0xd3, 0xc2, 0x98,
	0x51, 0x4e, 0x0b, 0x36, 0x1d, 0xba, 0x85, 0xab, 0xc7, 0xf2, 0x37, 0x2f, 0x43, 0xe8, 0x70, 0x29,
	0xcf, 0x0b, 0xe6, 0x25, 0xbf, 0x7a, 0x9c, 0xde, 0x1b, 0xd2, 0x21, 0xf5, 0x4a, 0xc5, 0xc8, 0xa3,
	0xe9, 0x93, 0x20, 0xe9, 0x3e, 0x1d, 0x8d, 0xa8, 0x23, 0xc4, 0xbd, 0x91, 0x9f, 0x9b, 0x0f, 0xca,
	0x65, 0xc4, 0xa5, 0x13, 0xd6, 0x27, 0x22, 0x7b, 0x36, 0xf6, 0xf2, 0x8f, 0x5f, 0x80, 0x78, 0x83,
	0x0e, 0xdd, 0xaa, 0xc9, 0x4d, 0xd4, 0x04, 0xbb, 0x33, 0x6a, 0x08, 0x47, 0xaa, 0x92, 0xdd, 0xcc,
	0xed, 0x14, 0x3f, 0xce, 0xaf, 0xb1, 0x9c, 0xc7, 0x7e, 0x85, 0x50, 0xc1, 0x49, 0xb6, 0x30, 0x3b,
	0xfe, 0x39, 0x02, 0x92, 0x8b, 0x18, 0x9d, 0x83, 0xf8, 0x2c, 0x41, 0x55, 0xb2, 0x4a, 0xa8, 0xf6,
	0xdc, 0xe3, 0x82, 0x7e, 0x65, 0xeb, 0xe5, 0xeb, 0xa3, 0x0d, 0x3c, 0x17, 0x40, 0x3a, 0x00, 0x6e,
	0x9f, 0x8e, 0x7d, 0xab, 0x11, 0x69, 0xf5, 0xd1, 0x5a, 0xab, 0x6d, 0x91, 0x2e, 0x7d, 0x26, 0xdc,
	0xd9, 0x10, 0x7d, 0x0f, 0xde, 0xb5, 0x1c, 0x97, 0xb3, 0xc9, 0x88, 0x38, 0xdc, 0xe4, 0x16, 0x75,
	0x0c, 0xdb, 0xea, 0x31, 0x93, 0x4d, 0x3d, 0xe1, 0x3f, 0x63, 0x52, 0xf9, 0xd3, 0xb5, 0xca, 0xf5,
	0x65, 0x85, 0x86, 0x27, 0x20, 0xf4, 0x2b, 0x11, 0x55, 0xc1, 0x69, 0x2b, 0x94, 0xa3, 0xf7, 0x44,
	0x1b, 0xdf, 0x91, 0x91, 0x69, 0x4c, 0x98, 0xad, 0x6e, 0x66, 0x95, 0x5c, 0x42, 0xd8, 0x13, 0x91,
	0x2e, 0xb3, 0x8f, 0x7f, 0x55, 0x40, 0x62, 0xee, 0x1b, 0xb5, 0x40, 0x54, 0x3a, 0xf7, 0x77, 0xaf,
	0x14, 0x68, 0xca, 0xbf, 0x0f, 0xff, 0xb5, 0x25, 0x75, 0xfc, 0x7d, 0xf4, 0x74, 0xd0, 0x19, 0xd8,
	0xb1, 0xe9, 0xd0, 0x60, 0xa4, 0x4f, 0xd9, 0xe0, 0xff, 0xed, 0x62, 0x83, 0x0e, 0xb1, 0x4c, 0xc7,
	0xc0, 0x9e, 0x0d, 0xef, 0x6c, 0xe3, 0x2f, 0x05, 0xa4, 0xc3, 0x37, 0x09, 0x71, 0x70, 0x10, 0x72,
	0x08, 0x7e, 0xa7, 0x4f, 0xee, 0xd7, 0xa9, 0xaf, 0xed, 0xf7, 0xba, 0x1f, 0xbc, 0xfd, 0x6f, 0xaa,
	0xf9, 0xcf, 0x23, 0xaa, 0x72, 0xfc, 0x43, 0x14, 0x24, 0xe6, 0xc5, 0xe8, 0x03, 0x90, 0xe2, 0xd6,
	0x88, 0x18, 0x13, 0xc7, 0xba, 0x36, 0x1c, 0xd3, 0xa1, 0xb2, 0xcd, 0x6d, 0x9c, 0x14, 0xd1, 0xae,
	0x63, 0x5d, 0x37, 0x4d, 0x87, 0xa2, 0x27, 0xe0, 0x80, 0xf6, 0x5c, 0xc2, 0xae, 0xc8, 0xc0, 0x58,
	0x49, 0xdf, 0x91, 0xe9, 0x7b, 0x33, 0xdc, 0x59, 0x2c, 0xeb, 0x80, 0x07, 0x2e, 0xb9, 0x22, 0xcc,
	0xe2, 0x53, 0xc3, 0x99, 0x8c, 0x7a, 0x84, 0xa9, 0x91, 0xac, 0x92, 0x4b, 0x15, 0x3f, 0x59, 0xff,
	0x75, 0xf8, 0x35, 0x4d, 0x59, 0x82, 0x53, 0xee, 0xd2, 0x1c, 0xbd, 0x0f, 0x76, 0xe7, 0xaa, 0x9c,
	0x5c, 0x73, 0xbf, 0xcd, 0xe4, 0x2c, 0xd8, 0x21, 0xd7, 0x1c, 0x69, 0x60, 0xab, 0x47, 0x07, 0x53,
	0x35, 0x2a, 0x0f, 0xed, 0xa3, 0x3b, 0x0e, 0x4d, 0x73, 0xa6, 0xcf, 0x4c, 0x7b, 0x32, 0xbb, 0x92,
	0xb2, 0x14, 0x5d, 0x00, 0x60, 0x72, 0xce, 0xac, 0xde, 0x84, 0x13, 0x57, 0xdd, 0x96, 0x67, 0x72,
	0x97, 0xd0, 0x39, 0x59, 0x12, 0x5a, 0x10, 0x40, 0x4f, 0x81, 0x3a, 0x60, 0x74, 0x3c, 0x26, 0x03,
	0xe3, 0xdf, 0xa8, 0xd1, 0xa7, 0x13, 0x87, 0xab, 0xb1, 0xac, 0x92, 0xdb, 0xc5, 0xfb, 0x3e, 0xd7,
	0xe6, 0xf8, 0x54, 0x50, 0xb4, 0x07, 0xa2, 0xdf, 0xda, 0xe6, 0xd0, 0x55, 0xe3, 0x59, 0x25, 0x17,
	0xc3, 0xde, 0x04, 0x7d, 0x03, 0xe2, 0x9c, 0x99, 0x7d, 0x62, 0x58, 0x03, 0x35, 0x91, 0x55, 0x72,
	0xc9, 0x8a, 0x26, 0xd6, 0xfc, 0xfd, 0xf5, 0xd1, 0x67, 0x43, 0xba, 0x62, 0xd3, 0x12, 0xaf, 0xb4,
	0x6d, 0x93, 0x3e, 0xa7, 0xac, 0x30, 0x1e, 0x98, 0xdc, 0x2c, 0x58, 0x0e, 0x27, 0xcc, 0x31, 0xed,
	0x82, 0x98, 0xe5, 0x3b, 0x42, 0xa9, 0x5e, 0xc5, 0x31, 0x29, 0x59, 0x1f, 0xa0, 0xe7, 0x20, 0xe6,
	0x8e, 0x4d, 0x47, 0x88, 0x03, 0x29, 0xfe, 0x85, 0x2f, 0xfe, 0xf4, 0xfe, 0xe2, 0xed, 0xb1, 0xe9,
	0xd4, 0xab, 0x78, 0x5b, 0x08, 0xd6, 0x07, 0x5f, 0x6e, 0xc5, 0xb7, 0x60, 0xf4, 0xe4, 0x97, 0x28,
	0x48, 0x2d, 0x1f, 0x34, 0x3a, 0x02, 0x87, 0x6d, 0xfd, 0x99, 0x8e, 0xeb, 0x9d, 0xe7, 0x46, 0xb3,
	0x7b, 0x51, 0xd1, 0xb1, 0xd1, 0x6d, 0xb6, 0x2f, 0xf5, 0xd3, 0x7a, 0xad, 0xae, 0x57, 0xe1, 0x06,
	0x7a, 0x07, 0x3c, 0x5c, 0x4d, 0xe8, 0x60, 0xed, 0x54, 0x87, 0x0a, 0x4a, 0x83, 0xfd, 0x40, 0x54,
	0x84, 0x91, 0x50, 0x56, 0x82, 0x9b, 0xa1, 0xac, 0x0c, 0xb7, 0x82, 0x96, 0xab, 0xea, 0x95, 0xee,
	0x19, 0x8c, 0x06, 0x95, 0x49, 0x54, 0x84, 0xdb, 0xa1, 0xac, 0x04, 0x63, 0xa1, 0xac, 0x0c, 0xe3,
	0x48, 0x05, 0x7b, 0xab, 0xac, 0xde, 0xac, 0xb5, 0x60, 0x22, 0xc8, 0x88, 0x20, 0x45, 0x08, 0xc2,
	0x50, 0x09, 0xee, 0x84, 0xa1, 0x32, 0x4c, 0x06, 0x2d, 0xf5, 0x95, 0x86, 0x9b, 0x70, 0x37, 0xa8,
	0x48, 0x90, 0x22, 0x4c, 0x85, 0xa1, 0x12, 0x7c, 0x10, 0x86, 0xca, 0x10, 0x06, 0x21, 0x1d, 0xe3,
	0x16, 0x86, 0x6f, 0x05, 0x6d, 0x86, 0x44, 0x45, 0x88, 0x42, 0x59, 0x09, 0xbe, 0x1d, 0xca, 0xca,
	0x70, 0x2f, 0x68, 0xb9, 0x9a, 0xd6, 0xd1, 0x1a, 0xf0, 0x61, 0x50, 0x99, 0x44, 0x45, 0xb8, 0x1f,
	0xca, 0x4a, 0xf0, 0x20, 0x94, 0x95, 0xa1, 0x7a, 0xf2, 0x35, 0x48, 0xcd, 0xdf, 0xd2, 0x9a, 0xfc,
	0x2c, 0x8f, 0xc0, 0x61, 0xa3, 0x75, 0x66, 0x60, 0xfd, 0xb4, 0x85, 0xab, 0x46, 0xad, 0xa1, 0x9d,
	0xad, 0x5c, 0xe2, 0x0f, 0x41, 0x76, 0x35, 0x41, 0xde, 0x38, 0x39, 0x6c, 0x1b, 0x17, 0x5a, 0xfb,
	0x1c, 0xfe, 0xad, 0x54, 0x7e, 0x54, 0x5e, 0xde, 0x64, 0x94, 0x57, 0x37, 0x19, 0xe5, 0x8f, 0x9b,
	0x8c, 0xf2, 0xd3, 0x6d, 0x66, 0xe3, 0xd5, 0x6d, 0x66, 0xe3, 0xb7, 0xdb, 0xcc, 0x06, 0xc8, 0x58,
	0x74, 0xdd, 0xfb, 0x59, 0x11, 0xcf, 0xbb, 0x7b, 0x29, 0x42, 0x97, 0xca, 0x8b, 0xca, 0xbd, 0xbf,
	0x57, 0xef, 0xaf, 0xda, 0x90, 0x38, 0xb3, 0x3f, 0x8d, 0xbd, 0x6d, 0x19, 0x29, 0xfd, 0x13, 0x00,
	0x00, 0xff, 0xff, 0x43, 0x73, 0x1b, 0xe8, 0x5a, 0x0a, 0x00, 0x00,
}

func (m *LogsData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogsData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LogsData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ResourceLogs) > 0 {
		for iNdEx := len(m.ResourceLogs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourceLogs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintLogs(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ResourceLogs) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceLogs) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceLogs) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.InstrumentationLibraryLogs) > 0 {
		for iNdEx := len(m.InstrumentationLibraryLogs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.InstrumentationLibraryLogs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintLogs(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3e
			i--
			dAtA[i] = 0xc2
		}
	}
	if len(m.SchemaUrl) > 0 {
		i -= len(m.SchemaUrl)
		copy(dAtA[i:], m.SchemaUrl)
		i = encodeVarintLogs(dAtA, i, uint64(len(m.SchemaUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ScopeLogs) > 0 {
		for iNdEx := len(m.ScopeLogs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ScopeLogs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintLogs(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintLogs(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ScopeLogs) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScopeLogs) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScopeLogs) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SchemaUrl) > 0 {
		i -= len(m.SchemaUrl)
		copy(dAtA[i:], m.SchemaUrl)
		i = encodeVarintLogs(dAtA, i, uint64(len(m.SchemaUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.LogRecords) > 0 {
		for iNdEx := len(m.LogRecords) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.LogRecords[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintLogs(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.Scope.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintLogs(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *InstrumentationLibraryLogs) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstrumentationLibraryLogs) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstrumentationLibraryLogs) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SchemaUrl) > 0 {
		i -= len(m.SchemaUrl)
		copy(dAtA[i:], m.SchemaUrl)
		i = encodeVarintLogs(dAtA, i, uint64(len(m.SchemaUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.LogRecords) > 0 {
		for iNdEx := len(m.LogRecords) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.LogRecords[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintLogs(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.InstrumentationLibrary.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintLogs(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *LogRecord) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogRecord) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LogRecord) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ObservedTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.ObservedTimeUnixNano))
		i--
		dAtA[i] = 0x59
	}
	{
		size := m.SpanId.Size()
		i -= size
		if _, err := m.SpanId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintLogs(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x52
	{
		size := m.TraceId.Size()
		i -= size
		if _, err := m.TraceId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintLogs(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x4a
	if m.Flags != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(m.Flags))
		i--
		dAtA[i] = 0x45
	}
	if m.DroppedAttributesCount != 0 {
		i = encodeVarintLogs(dAtA, i, uint64(m.DroppedAttributesCount))
		i--
		dAtA[i] = 0x38
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintLogs(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	{
		size, err := m.Body.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintLogs(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x2a
	if len(m.SeverityText) > 0 {
		i -= len(m.SeverityText)
		copy(dAtA[i:], m.SeverityText)
		i = encodeVarintLogs(dAtA, i, uint64(len(m.SeverityText)))
		i--
		dAtA[i] = 0x1a
	}
	if m.SeverityNumber != 0 {
		i = encodeVarintLogs(dAtA, i, uint64(m.SeverityNumber))
		i--
		dAtA[i] = 0x10
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x9
	}
	return len(dAtA) - i, nil
}

func encodeVarintLogs(dAtA []byte, offset int, v uint64) int {
	offset -= sovLogs(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *LogsData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ResourceLogs) > 0 {
		for _, e := range m.ResourceLogs {
			l = e.Size()
			n += 1 + l + sovLogs(uint64(l))
		}
	}
	return n
}

func (m *ResourceLogs) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Resource.Size()
	n += 1 + l + sovLogs(uint64(l))
	if len(m.ScopeLogs) > 0 {
		for _, e := range m.ScopeLogs {
			l = e.Size()
			n += 1 + l + sovLogs(uint64(l))
		}
	}
	l = len(m.SchemaUrl)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	if len(m.InstrumentationLibraryLogs) > 0 {
		for _, e := range m.InstrumentationLibraryLogs {
			l = e.Size()
			n += 2 + l + sovLogs(uint64(l))
		}
	}
	return n
}

func (m *ScopeLogs) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Scope.Size()
	n += 1 + l + sovLogs(uint64(l))
	if len(m.LogRecords) > 0 {
		for _, e := range m.LogRecords {
			l = e.Size()
			n += 1 + l + sovLogs(uint64(l))
		}
	}
	l = len(m.SchemaUrl)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	return n
}

func (m *InstrumentationLibraryLogs) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.InstrumentationLibrary.Size()
	n += 1 + l + sovLogs(uint64(l))
	if len(m.LogRecords) > 0 {
		for _, e := range m.LogRecords {
			l = e.Size()
			n += 1 + l + sovLogs(uint64(l))
		}
	}
	l = len(m.SchemaUrl)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	return n
}

func (m *LogRecord) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.SeverityNumber != 0 {
		n += 1 + sovLogs(uint64(m.SeverityNumber))
	}
	l = len(m.SeverityText)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	l = m.Body.Size()
	n += 1 + l + sovLogs(uint64(l))
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovLogs(uint64(l))
		}
	}
	if m.DroppedAttributesCount != 0 {
		n += 1 + sovLogs(uint64(m.DroppedAttributesCount))
	}
	if m.Flags != 0 {
		n += 5
	}
	l = m.TraceId.Size()
	n += 1 + l + sovLogs(uint64(l))
	l = m.SpanId.Size()
	n += 1 + l + sovLogs(uint64(l))
	if m.ObservedTimeUnixNano != 0 {
		n += 9
	}
	return n
}

func sovLogs(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozLogs(x uint64) (n int) {
	return sovLogs(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *LogsData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogsData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogsData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceLogs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceLogs = append(m.ResourceLogs, &ResourceLogs{})
			if err := m.ResourceLogs[len(m.ResourceLogs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLogs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceLogs) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceLogs: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceLogs: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScopeLogs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScopeLogs = append(m.ScopeLogs, &ScopeLogs{})
			if err := m.ScopeLogs[len(m.ScopeLogs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 1000:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstrumentationLibraryLogs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InstrumentationLibraryLogs = append(m.InstrumentationLibraryLogs, &InstrumentationLibraryLogs{})
			if err := m.InstrumentationLibraryLogs[len(m.InstrumentationLibraryLogs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLogs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScopeLogs) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScopeLogs: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScopeLogs: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Scope.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogRecords", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LogRecords = append(m.LogRecords, &LogRecord{})
			if err := m.LogRecords[len(m.LogRecords)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLogs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstrumentationLibraryLogs) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstrumentationLibraryLogs: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstrumentationLibraryLogs: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstrumentationLibrary", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.InstrumentationLibrary.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogRecords", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LogRecords = append(m.LogRecords, &LogRecord{})
			if err := m.LogRecords[len(m.LogRecords)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLogs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogRecord) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogRecord: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogRecord: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeverityNumber", wireType)
			}
			m.SeverityNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SeverityNumber |= SeverityNumber(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeverityText", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SeverityText = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Body.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			m.DroppedAttributesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedAttributesCount |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			m.Flags = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TraceId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SpanId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObservedTimeUnixNano", wireType)
			}
			m.ObservedTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.ObservedTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		default:
			iNdEx = preIndex
			skippy, err := skipLogs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipLogs(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthLogs
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupLogs
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthLogs
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthLogs        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowLogs          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupLogs = fmt.Errorf("proto: unexpected end of group")
)
