// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: model.proto

// Uses queryrange package to offer backwards compatibility with cached extents.

package querymiddleware

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"
	_ "github.com/golang/protobuf/ptypes/duration"
	github_com_grafana_mimir_pkg_mimirpb "github.com/grafana/mimir/pkg/mimirpb"
	mimirpb "github.com/grafana/mimir/pkg/mimirpb"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type PrometheusRangeQueryRequest struct {
	Path    string        `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Start   int64         `protobuf:"varint,2,opt,name=start,proto3" json:"start,omitempty"`
	End     int64         `protobuf:"varint,3,opt,name=end,proto3" json:"end,omitempty"`
	Step    int64         `protobuf:"varint,4,opt,name=step,proto3" json:"step,omitempty"`
	Timeout time.Duration `protobuf:"bytes,5,opt,name=timeout,proto3,stdduration" json:"timeout"`
	Query   string        `protobuf:"bytes,6,opt,name=query,proto3" json:"query,omitempty"`
	Options Options       `protobuf:"bytes,7,opt,name=options,proto3" json:"options"`
	// ID of the request used by splitAndCacheMiddleware to correlate downstream requests and responses.
	Id int64 `protobuf:"varint,8,opt,name=id,proto3" json:"id,omitempty"`
	// Hints that could be optionally attached to the request to pass down the stack.
	// These hints can be used to optimize the query execution.
	Hints *Hints `protobuf:"bytes,9,opt,name=hints,proto3" json:"hints,omitempty"`
}

func (m *PrometheusRangeQueryRequest) Reset()      { *m = PrometheusRangeQueryRequest{} }
func (*PrometheusRangeQueryRequest) ProtoMessage() {}
func (*PrometheusRangeQueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{0}
}
func (m *PrometheusRangeQueryRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrometheusRangeQueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrometheusRangeQueryRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrometheusRangeQueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrometheusRangeQueryRequest.Merge(m, src)
}
func (m *PrometheusRangeQueryRequest) XXX_Size() int {
	return m.Size()
}
func (m *PrometheusRangeQueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PrometheusRangeQueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PrometheusRangeQueryRequest proto.InternalMessageInfo

func (m *PrometheusRangeQueryRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *PrometheusRangeQueryRequest) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *PrometheusRangeQueryRequest) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *PrometheusRangeQueryRequest) GetStep() int64 {
	if m != nil {
		return m.Step
	}
	return 0
}

func (m *PrometheusRangeQueryRequest) GetTimeout() time.Duration {
	if m != nil {
		return m.Timeout
	}
	return 0
}

func (m *PrometheusRangeQueryRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *PrometheusRangeQueryRequest) GetOptions() Options {
	if m != nil {
		return m.Options
	}
	return Options{}
}

func (m *PrometheusRangeQueryRequest) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *PrometheusRangeQueryRequest) GetHints() *Hints {
	if m != nil {
		return m.Hints
	}
	return nil
}

type PrometheusInstantQueryRequest struct {
	Path    string  `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Time    int64   `protobuf:"varint,2,opt,name=time,proto3" json:"time,omitempty"`
	Query   string  `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	Options Options `protobuf:"bytes,4,opt,name=options,proto3" json:"options"`
	// ID of the request used by splitAndCacheMiddleware to correlate downstream requests and responses.
	Id int64 `protobuf:"varint,5,opt,name=id,proto3" json:"id,omitempty"`
	// Hints that could be optionally attached to the request to pass down the stack.
	// These hints can be used to optimize the query execution.
	Hints *Hints `protobuf:"bytes,6,opt,name=hints,proto3" json:"hints,omitempty"`
}

func (m *PrometheusInstantQueryRequest) Reset()      { *m = PrometheusInstantQueryRequest{} }
func (*PrometheusInstantQueryRequest) ProtoMessage() {}
func (*PrometheusInstantQueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{1}
}
func (m *PrometheusInstantQueryRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrometheusInstantQueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrometheusInstantQueryRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrometheusInstantQueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrometheusInstantQueryRequest.Merge(m, src)
}
func (m *PrometheusInstantQueryRequest) XXX_Size() int {
	return m.Size()
}
func (m *PrometheusInstantQueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PrometheusInstantQueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PrometheusInstantQueryRequest proto.InternalMessageInfo

func (m *PrometheusInstantQueryRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *PrometheusInstantQueryRequest) GetTime() int64 {
	if m != nil {
		return m.Time
	}
	return 0
}

func (m *PrometheusInstantQueryRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *PrometheusInstantQueryRequest) GetOptions() Options {
	if m != nil {
		return m.Options
	}
	return Options{}
}

func (m *PrometheusInstantQueryRequest) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *PrometheusInstantQueryRequest) GetHints() *Hints {
	if m != nil {
		return m.Hints
	}
	return nil
}

type PrometheusResponseHeader struct {
	Name   string   `protobuf:"bytes,1,opt,name=Name,proto3" json:"-"`
	Values []string `protobuf:"bytes,2,rep,name=Values,proto3" json:"-"`
}

func (m *PrometheusResponseHeader) Reset()      { *m = PrometheusResponseHeader{} }
func (*PrometheusResponseHeader) ProtoMessage() {}
func (*PrometheusResponseHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{2}
}
func (m *PrometheusResponseHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrometheusResponseHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrometheusResponseHeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrometheusResponseHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrometheusResponseHeader.Merge(m, src)
}
func (m *PrometheusResponseHeader) XXX_Size() int {
	return m.Size()
}
func (m *PrometheusResponseHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_PrometheusResponseHeader.DiscardUnknown(m)
}

var xxx_messageInfo_PrometheusResponseHeader proto.InternalMessageInfo

func (m *PrometheusResponseHeader) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PrometheusResponseHeader) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

type PrometheusResponse struct {
	Status    string                      `protobuf:"bytes,1,opt,name=Status,proto3" json:"status"`
	Data      *PrometheusData             `protobuf:"bytes,2,opt,name=Data,proto3" json:"data,omitempty"`
	ErrorType string                      `protobuf:"bytes,3,opt,name=ErrorType,proto3" json:"errorType,omitempty"`
	Error     string                      `protobuf:"bytes,4,opt,name=Error,proto3" json:"error,omitempty"`
	Headers   []*PrometheusResponseHeader `protobuf:"bytes,5,rep,name=Headers,proto3" json:"-"`
}

func (m *PrometheusResponse) Reset()      { *m = PrometheusResponse{} }
func (*PrometheusResponse) ProtoMessage() {}
func (*PrometheusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{3}
}
func (m *PrometheusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrometheusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrometheusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrometheusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrometheusResponse.Merge(m, src)
}
func (m *PrometheusResponse) XXX_Size() int {
	return m.Size()
}
func (m *PrometheusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PrometheusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PrometheusResponse proto.InternalMessageInfo

func (m *PrometheusResponse) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *PrometheusResponse) GetData() *PrometheusData {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *PrometheusResponse) GetErrorType() string {
	if m != nil {
		return m.ErrorType
	}
	return ""
}

func (m *PrometheusResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *PrometheusResponse) GetHeaders() []*PrometheusResponseHeader {
	if m != nil {
		return m.Headers
	}
	return nil
}

type PrometheusData struct {
	ResultType string         `protobuf:"bytes,1,opt,name=ResultType,proto3" json:"resultType"`
	Result     []SampleStream `protobuf:"bytes,2,rep,name=Result,proto3" json:"result"`
}

func (m *PrometheusData) Reset()      { *m = PrometheusData{} }
func (*PrometheusData) ProtoMessage() {}
func (*PrometheusData) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{4}
}
func (m *PrometheusData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrometheusData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrometheusData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrometheusData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrometheusData.Merge(m, src)
}
func (m *PrometheusData) XXX_Size() int {
	return m.Size()
}
func (m *PrometheusData) XXX_DiscardUnknown() {
	xxx_messageInfo_PrometheusData.DiscardUnknown(m)
}

var xxx_messageInfo_PrometheusData proto.InternalMessageInfo

func (m *PrometheusData) GetResultType() string {
	if m != nil {
		return m.ResultType
	}
	return ""
}

func (m *PrometheusData) GetResult() []SampleStream {
	if m != nil {
		return m.Result
	}
	return nil
}

type SampleStream struct {
	Labels  []github_com_grafana_mimir_pkg_mimirpb.LabelAdapter `protobuf:"bytes,1,rep,name=labels,proto3,customtype=github.com/grafana/mimir/pkg/mimirpb.LabelAdapter" json:"metric"`
	Samples []mimirpb.Sample                                    `protobuf:"bytes,2,rep,name=samples,proto3" json:"values"`
}

func (m *SampleStream) Reset()      { *m = SampleStream{} }
func (*SampleStream) ProtoMessage() {}
func (*SampleStream) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{5}
}
func (m *SampleStream) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SampleStream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SampleStream.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SampleStream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SampleStream.Merge(m, src)
}
func (m *SampleStream) XXX_Size() int {
	return m.Size()
}
func (m *SampleStream) XXX_DiscardUnknown() {
	xxx_messageInfo_SampleStream.DiscardUnknown(m)
}

var xxx_messageInfo_SampleStream proto.InternalMessageInfo

func (m *SampleStream) GetSamples() []mimirpb.Sample {
	if m != nil {
		return m.Samples
	}
	return nil
}

type CachedResponse struct {
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key"`
	// List of cached responses; non-overlapping and in order.
	Extents []Extent `protobuf:"bytes,2,rep,name=extents,proto3" json:"extents"`
}

func (m *CachedResponse) Reset()      { *m = CachedResponse{} }
func (*CachedResponse) ProtoMessage() {}
func (*CachedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{6}
}
func (m *CachedResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CachedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CachedResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CachedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CachedResponse.Merge(m, src)
}
func (m *CachedResponse) XXX_Size() int {
	return m.Size()
}
func (m *CachedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CachedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CachedResponse proto.InternalMessageInfo

func (m *CachedResponse) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *CachedResponse) GetExtents() []Extent {
	if m != nil {
		return m.Extents
	}
	return nil
}

type Extent struct {
	Start    int64      `protobuf:"varint,1,opt,name=start,proto3" json:"start"`
	End      int64      `protobuf:"varint,2,opt,name=end,proto3" json:"end"`
	TraceId  string     `protobuf:"bytes,4,opt,name=trace_id,json=traceId,proto3" json:"-"`
	Response *types.Any `protobuf:"bytes,5,opt,name=response,proto3" json:"response"`
}

func (m *Extent) Reset()      { *m = Extent{} }
func (*Extent) ProtoMessage() {}
func (*Extent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{7}
}
func (m *Extent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Extent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Extent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Extent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Extent.Merge(m, src)
}
func (m *Extent) XXX_Size() int {
	return m.Size()
}
func (m *Extent) XXX_DiscardUnknown() {
	xxx_messageInfo_Extent.DiscardUnknown(m)
}

var xxx_messageInfo_Extent proto.InternalMessageInfo

func (m *Extent) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *Extent) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *Extent) GetTraceId() string {
	if m != nil {
		return m.TraceId
	}
	return ""
}

func (m *Extent) GetResponse() *types.Any {
	if m != nil {
		return m.Response
	}
	return nil
}

type Options struct {
	CacheDisabled        bool  `protobuf:"varint,1,opt,name=CacheDisabled,proto3" json:"CacheDisabled,omitempty"`
	ShardingDisabled     bool  `protobuf:"varint,2,opt,name=ShardingDisabled,proto3" json:"ShardingDisabled,omitempty"`
	TotalShards          int32 `protobuf:"varint,3,opt,name=TotalShards,proto3" json:"TotalShards,omitempty"`
	InstantSplitDisabled bool  `protobuf:"varint,4,opt,name=InstantSplitDisabled,proto3" json:"InstantSplitDisabled,omitempty"`
	// Instant split by time interval unit stored in nanoseconds (time.Duration unit in int64)
	InstantSplitInterval int64 `protobuf:"varint,5,opt,name=InstantSplitInterval,proto3" json:"InstantSplitInterval,omitempty"`
}

func (m *Options) Reset()      { *m = Options{} }
func (*Options) ProtoMessage() {}
func (*Options) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{8}
}
func (m *Options) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Options) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Options.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Options) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Options.Merge(m, src)
}
func (m *Options) XXX_Size() int {
	return m.Size()
}
func (m *Options) XXX_DiscardUnknown() {
	xxx_messageInfo_Options.DiscardUnknown(m)
}

var xxx_messageInfo_Options proto.InternalMessageInfo

func (m *Options) GetCacheDisabled() bool {
	if m != nil {
		return m.CacheDisabled
	}
	return false
}

func (m *Options) GetShardingDisabled() bool {
	if m != nil {
		return m.ShardingDisabled
	}
	return false
}

func (m *Options) GetTotalShards() int32 {
	if m != nil {
		return m.TotalShards
	}
	return 0
}

func (m *Options) GetInstantSplitDisabled() bool {
	if m != nil {
		return m.InstantSplitDisabled
	}
	return false
}

func (m *Options) GetInstantSplitInterval() int64 {
	if m != nil {
		return m.InstantSplitInterval
	}
	return 0
}

type Hints struct {
	// Total number of queries that are expected to to be executed to serve the original request.
	TotalQueries int32 `protobuf:"varint,1,opt,name=TotalQueries,proto3" json:"TotalQueries,omitempty"`
}

func (m *Hints) Reset()      { *m = Hints{} }
func (*Hints) ProtoMessage() {}
func (*Hints) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{9}
}
func (m *Hints) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Hints) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Hints.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Hints) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Hints.Merge(m, src)
}
func (m *Hints) XXX_Size() int {
	return m.Size()
}
func (m *Hints) XXX_DiscardUnknown() {
	xxx_messageInfo_Hints.DiscardUnknown(m)
}

var xxx_messageInfo_Hints proto.InternalMessageInfo

func (m *Hints) GetTotalQueries() int32 {
	if m != nil {
		return m.TotalQueries
	}
	return 0
}

func init() {
	proto.RegisterType((*PrometheusRangeQueryRequest)(nil), "queryrange.PrometheusRangeQueryRequest")
	proto.RegisterType((*PrometheusInstantQueryRequest)(nil), "queryrange.PrometheusInstantQueryRequest")
	proto.RegisterType((*PrometheusResponseHeader)(nil), "queryrange.PrometheusResponseHeader")
	proto.RegisterType((*PrometheusResponse)(nil), "queryrange.PrometheusResponse")
	proto.RegisterType((*PrometheusData)(nil), "queryrange.PrometheusData")
	proto.RegisterType((*SampleStream)(nil), "queryrange.SampleStream")
	proto.RegisterType((*CachedResponse)(nil), "queryrange.CachedResponse")
	proto.RegisterType((*Extent)(nil), "queryrange.Extent")
	proto.RegisterType((*Options)(nil), "queryrange.Options")
	proto.RegisterType((*Hints)(nil), "queryrange.Hints")
}

func init() { proto.RegisterFile("model.proto", fileDescriptor_4c16552f9fdb66d8) }

var fileDescriptor_4c16552f9fdb66d8 = []byte{
	// 993 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xcd, 0x6e, 0x1c, 0x45,
	0x10, 0xde, 0xd9, 0x7f, 0xd7, 0x86, 0xb5, 0x69, 0x5b, 0x62, 0x6c, 0x94, 0x99, 0xd5, 0x28, 0x07,
	0xf3, 0xe3, 0x35, 0x38, 0xe2, 0x82, 0x04, 0x22, 0x13, 0x5b, 0x8a, 0x11, 0x82, 0xd0, 0xb6, 0x38,
	0x70, 0x41, 0xbd, 0x3b, 0x9d, 0xdd, 0x21, 0xf3, 0x97, 0x9e, 0x9e, 0x90, 0xbd, 0x21, 0x9e, 0x80,
	0x23, 0x2f, 0x80, 0xc4, 0x81, 0x33, 0x27, 0x1e, 0x20, 0x47, 0x73, 0x8b, 0x38, 0x0c, 0x78, 0x2d,
	0x24, 0xb4, 0xa7, 0x3c, 0x02, 0xea, 0xea, 0x99, 0xdd, 0x71, 0x6c, 0x44, 0xb8, 0xec, 0x56, 0x57,
	0x7d, 0x55, 0xfd, 0xd5, 0x37, 0xd5, 0x05, 0xbd, 0x30, 0xf6, 0x78, 0x30, 0x4c, 0x44, 0x2c, 0x63,
	0x02, 0x8f, 0x32, 0x2e, 0x66, 0x82, 0x45, 0x13, 0xbe, 0xb3, 0x37, 0xf1, 0xe5, 0x34, 0x1b, 0x0d,
	0xc7, 0x71, 0xb8, 0x3f, 0x89, 0x27, 0xf1, 0x3e, 0x42, 0x46, 0xd9, 0x03, 0x3c, 0xe1, 0x01, 0x2d,
	0x9d, 0xba, 0x63, 0x4d, 0xe2, 0x78, 0x12, 0xf0, 0x15, 0xca, 0xcb, 0x04, 0x93, 0x7e, 0x1c, 0x15,
	0xf1, 0x77, 0xaa, 0xe5, 0x04, 0x7b, 0xc0, 0x22, 0xb6, 0x1f, 0xfa, 0xa1, 0x2f, 0xf6, 0x93, 0x87,
	0x13, 0x6d, 0x25, 0x23, 0xfd, 0x5f, 0x64, 0x6c, 0xbf, 0x58, 0x91, 0x45, 0x33, 0x1d, 0x72, 0x7e,
	0xa9, 0xc3, 0xeb, 0xf7, 0x45, 0x1c, 0x72, 0x39, 0xe5, 0x59, 0x4a, 0x15, 0xdf, 0xcf, 0x15, 0x73,
	0xca, 0x1f, 0x65, 0x3c, 0x95, 0x84, 0x40, 0x33, 0x61, 0x72, 0x6a, 0x1a, 0x03, 0x63, 0x77, 0x8d,
	0xa2, 0x4d, 0xb6, 0xa0, 0x95, 0x4a, 0x26, 0xa4, 0x59, 0x1f, 0x18, 0xbb, 0x0d, 0xaa, 0x0f, 0x64,
	0x03, 0x1a, 0x3c, 0xf2, 0xcc, 0x06, 0xfa, 0x94, 0xa9, 0x72, 0x53, 0xc9, 0x13, 0xb3, 0x89, 0x2e,
	0xb4, 0xc9, 0x07, 0xd0, 0x91, 0x7e, 0xc8, 0xe3, 0x4c, 0x9a, 0xad, 0x81, 0xb1, 0xdb, 0x3b, 0xd8,
	0x1e, 0x6a, 0x72, 0xc3, 0x92, 0xdc, 0xf0, 0xb0, 0x68, 0xd7, 0xed, 0x3e, 0xcd, 0xed, 0xda, 0x0f,
	0x7f, 0xd8, 0x06, 0x2d, 0x73, 0xd4, 0xd5, 0x28, 0xac, 0xd9, 0x46, 0x3e, 0xfa, 0x40, 0x6e, 0x43,
	0x27, 0x4e, 0x54, 0x4a, 0x6a, 0x76, 0xb0, 0xe8, 0xe6, 0x70, 0x25, 0xff, 0xf0, 0x33, 0x1d, 0x72,
	0x9b, 0xaa, 0x1c, 0x2d, 0x91, 0xa4, 0x0f, 0x75, 0xdf, 0x33, 0xbb, 0xc8, 0xad, 0xee, 0x7b, 0x64,
	0x0f, 0x5a, 0x53, 0x3f, 0x92, 0xa9, 0xb9, 0x86, 0x25, 0x5e, 0xad, 0x96, 0xb8, 0xa7, 0x02, 0x58,
	0xc0, 0xa0, 0x1a, 0xe5, 0xfc, 0x66, 0xc0, 0xcd, 0x95, 0x70, 0xc7, 0x51, 0x2a, 0x59, 0x24, 0xff,
	0x53, 0x3a, 0x02, 0x4d, 0xd5, 0x4a, 0xa1, 0x1c, 0xda, 0xab, 0x9e, 0x1a, 0xff, 0xd2, 0x53, 0xf3,
	0x7f, 0xf6, 0xd4, 0xba, 0xda, 0x53, 0xfb, 0xa5, 0x7a, 0x3a, 0x05, 0xb3, 0x32, 0x0b, 0x3c, 0x4d,
	0xe2, 0x28, 0xe5, 0xf7, 0x38, 0xf3, 0xb8, 0x20, 0xdb, 0xd0, 0xfc, 0x94, 0x85, 0x5c, 0x77, 0xe3,
	0xb6, 0x16, 0xb9, 0x6d, 0xec, 0x51, 0x74, 0x91, 0x9b, 0xd0, 0xfe, 0x82, 0x05, 0x19, 0x4f, 0xcd,
	0xfa, 0xa0, 0xb1, 0x0a, 0x16, 0x4e, 0xe7, 0xc7, 0x3a, 0x90, 0xab, 0x65, 0x89, 0x03, 0xed, 0x13,
	0xc9, 0x64, 0x96, 0x16, 0x25, 0x61, 0x91, 0xdb, 0xed, 0x14, 0x3d, 0xb4, 0x88, 0x10, 0x17, 0x9a,
	0x87, 0x4c, 0x32, 0x94, 0xab, 0x77, 0xb0, 0x53, 0xa5, 0xbf, 0xaa, 0xa8, 0x10, 0x2e, 0x59, 0xe4,
	0x76, 0xdf, 0x63, 0x92, 0xbd, 0x1d, 0x87, 0xbe, 0xe4, 0x61, 0x22, 0x67, 0x14, 0x73, 0xc9, 0x7b,
	0xb0, 0x76, 0x24, 0x44, 0x2c, 0x4e, 0x67, 0x09, 0xd7, 0x12, 0xbb, 0xaf, 0x2d, 0x72, 0x7b, 0x93,
	0x97, 0xce, 0x4a, 0xc6, 0x0a, 0x49, 0xde, 0x80, 0x16, 0x1e, 0x50, 0xfd, 0x35, 0x77, 0x73, 0x91,
	0xdb, 0xeb, 0x98, 0x52, 0x81, 0x6b, 0x04, 0x39, 0x82, 0x8e, 0x16, 0x29, 0x35, 0x5b, 0x83, 0xc6,
	0x6e, 0xef, 0xe0, 0xd6, 0xf5, 0x44, 0x2f, 0x2b, 0x5a, 0xca, 0x54, 0xe6, 0x3a, 0xdf, 0x19, 0xd0,
	0xbf, 0xdc, 0x15, 0x19, 0x02, 0x50, 0x9e, 0x66, 0x81, 0x44, 0xf2, 0x5a, 0xa7, 0xfe, 0x22, 0xb7,
	0x41, 0x2c, 0xbd, 0xb4, 0x82, 0x20, 0x1f, 0x41, 0x5b, 0x9f, 0xf0, 0x4b, 0xf4, 0x0e, 0xcc, 0x2a,
	0x91, 0x13, 0x16, 0x26, 0x01, 0x3f, 0x91, 0x82, 0xb3, 0xd0, 0xed, 0xab, 0xc1, 0x51, 0x8a, 0xeb,
	0x4a, 0xb4, 0xc8, 0x73, 0x7e, 0x35, 0xe0, 0x46, 0x15, 0x48, 0x12, 0x68, 0x07, 0x6c, 0xc4, 0x03,
	0xf5, 0x99, 0x1a, 0x38, 0x86, 0xe3, 0x58, 0x48, 0xfe, 0x24, 0x19, 0x0d, 0x3f, 0x51, 0xfe, 0xfb,
	0xcc, 0x17, 0xee, 0x5d, 0x55, 0xed, 0xf7, 0xdc, 0x7e, 0xf7, 0x65, 0x56, 0x93, 0xce, 0xbb, 0xe3,
	0xb1, 0x44, 0x72, 0xa1, 0x28, 0x84, 0x5c, 0x0a, 0x7f, 0x4c, 0x8b, 0x7b, 0xc8, 0xfb, 0xd0, 0x49,
	0x91, 0x41, 0x5a, 0x74, 0xb1, 0xb1, 0xba, 0x52, 0x53, 0x5b, 0xb1, 0x7f, 0x8c, 0x23, 0x46, 0xcb,
	0x04, 0xe7, 0x6b, 0xe8, 0xdf, 0x65, 0xe3, 0x29, 0xf7, 0x96, 0x63, 0xb6, 0x0d, 0x8d, 0x87, 0x7c,
	0x56, 0x68, 0xd7, 0x59, 0xe4, 0xb6, 0x3a, 0x52, 0xf5, 0xa3, 0x76, 0x11, 0x7f, 0x22, 0xb9, 0x7a,
	0x1f, 0xfa, 0x22, 0x52, 0x95, 0xeb, 0x08, 0x43, 0xee, 0x7a, 0x71, 0x55, 0x09, 0xa5, 0xa5, 0xe1,
	0xfc, 0x6c, 0x40, 0x5b, 0x83, 0x88, 0x5d, 0x6e, 0x44, 0x75, 0x4d, 0xc3, 0x5d, 0x5b, 0xe4, 0xb6,
	0x76, 0x94, 0xcb, 0x71, 0x5b, 0x2f, 0x47, 0x7c, 0xf6, 0x9a, 0x05, 0x8f, 0x3c, 0xbd, 0x25, 0x07,
	0xd0, 0x95, 0x82, 0x8d, 0xf9, 0x57, 0xbe, 0x57, 0xcc, 0x5a, 0x39, 0x18, 0xe8, 0x3e, 0xf6, 0xc8,
	0x87, 0xd0, 0x15, 0x45, 0x3b, 0xc5, 0xd2, 0xdc, 0xba, 0xb2, 0x34, 0xef, 0x44, 0x33, 0xf7, 0xc6,
	0x22, 0xb7, 0x97, 0x48, 0xba, 0xb4, 0x3e, 0x6e, 0x76, 0x1b, 0x1b, 0x4d, 0xe7, 0x2f, 0x03, 0x3a,
	0xc5, 0xda, 0x20, 0xb7, 0xe0, 0x15, 0x94, 0xe9, 0xd0, 0x4f, 0xd9, 0x28, 0xe0, 0x1e, 0xf2, 0xee,
	0xd2, 0xcb, 0x4e, 0xf2, 0x26, 0x6c, 0x9c, 0x4c, 0x99, 0xf0, 0xfc, 0x68, 0xb2, 0x04, 0xd6, 0x11,
	0x78, 0xc5, 0x4f, 0x06, 0xd0, 0x3b, 0x8d, 0x25, 0x0b, 0x30, 0x90, 0xe2, 0x3b, 0x6b, 0xd1, 0xaa,
	0x8b, 0x1c, 0xc0, 0x56, 0xb1, 0x25, 0x4f, 0x92, 0xc0, 0x97, 0xcb, 0x8a, 0x4d, 0xac, 0x78, 0x6d,
	0xec, 0xc5, 0x9c, 0xe3, 0x48, 0x72, 0xf1, 0x98, 0x05, 0xc5, 0x86, 0xbb, 0x36, 0xe6, 0xbc, 0x05,
	0x2d, 0x5c, 0x6d, 0xc4, 0x81, 0x1b, 0x78, 0xbf, 0x5a, 0xca, 0x3e, 0xd7, 0x6b, 0xa6, 0x45, 0x2f,
	0xf9, 0xdc, 0xa3, 0xb3, 0x73, 0xab, 0xf6, 0xec, 0xdc, 0xaa, 0x3d, 0x3f, 0xb7, 0x8c, 0x6f, 0xe7,
	0x96, 0xf1, 0xd3, 0xdc, 0x32, 0x9e, 0xce, 0x2d, 0xe3, 0x6c, 0x6e, 0x19, 0x7f, 0xce, 0x2d, 0xe3,
	0xef, 0xb9, 0x55, 0x7b, 0x3e, 0xb7, 0x8c, 0xef, 0x2f, 0xac, 0xda, 0xd9, 0x85, 0x55, 0x7b, 0x76,
	0x61, 0xd5, 0xbe, 0x5c, 0xc7, 0x31, 0x09, 0x7d, 0xcf, 0x0b, 0xf8, 0x37, 0x4c, 0xf0, 0x51, 0x1b,
	0xbf, 0xc3, 0xed, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x35, 0xce, 0x26, 0x85, 0x03, 0x08, 0x00,
	0x00,
}

func (this *PrometheusRangeQueryRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PrometheusRangeQueryRequest)
	if !ok {
		that2, ok := that.(PrometheusRangeQueryRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.Start != that1.Start {
		return false
	}
	if this.End != that1.End {
		return false
	}
	if this.Step != that1.Step {
		return false
	}
	if this.Timeout != that1.Timeout {
		return false
	}
	if this.Query != that1.Query {
		return false
	}
	if !this.Options.Equal(&that1.Options) {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if !this.Hints.Equal(that1.Hints) {
		return false
	}
	return true
}
func (this *PrometheusInstantQueryRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PrometheusInstantQueryRequest)
	if !ok {
		that2, ok := that.(PrometheusInstantQueryRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.Time != that1.Time {
		return false
	}
	if this.Query != that1.Query {
		return false
	}
	if !this.Options.Equal(&that1.Options) {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if !this.Hints.Equal(that1.Hints) {
		return false
	}
	return true
}
func (this *PrometheusResponseHeader) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PrometheusResponseHeader)
	if !ok {
		that2, ok := that.(PrometheusResponseHeader)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.Values) != len(that1.Values) {
		return false
	}
	for i := range this.Values {
		if this.Values[i] != that1.Values[i] {
			return false
		}
	}
	return true
}
func (this *PrometheusResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PrometheusResponse)
	if !ok {
		that2, ok := that.(PrometheusResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if !this.Data.Equal(that1.Data) {
		return false
	}
	if this.ErrorType != that1.ErrorType {
		return false
	}
	if this.Error != that1.Error {
		return false
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if !this.Headers[i].Equal(that1.Headers[i]) {
			return false
		}
	}
	return true
}
func (this *PrometheusData) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PrometheusData)
	if !ok {
		that2, ok := that.(PrometheusData)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ResultType != that1.ResultType {
		return false
	}
	if len(this.Result) != len(that1.Result) {
		return false
	}
	for i := range this.Result {
		if !this.Result[i].Equal(&that1.Result[i]) {
			return false
		}
	}
	return true
}
func (this *SampleStream) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SampleStream)
	if !ok {
		that2, ok := that.(SampleStream)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Labels) != len(that1.Labels) {
		return false
	}
	for i := range this.Labels {
		if !this.Labels[i].Equal(that1.Labels[i]) {
			return false
		}
	}
	if len(this.Samples) != len(that1.Samples) {
		return false
	}
	for i := range this.Samples {
		if !this.Samples[i].Equal(&that1.Samples[i]) {
			return false
		}
	}
	return true
}
func (this *CachedResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CachedResponse)
	if !ok {
		that2, ok := that.(CachedResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if len(this.Extents) != len(that1.Extents) {
		return false
	}
	for i := range this.Extents {
		if !this.Extents[i].Equal(&that1.Extents[i]) {
			return false
		}
	}
	return true
}
func (this *Extent) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Extent)
	if !ok {
		that2, ok := that.(Extent)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Start != that1.Start {
		return false
	}
	if this.End != that1.End {
		return false
	}
	if this.TraceId != that1.TraceId {
		return false
	}
	if !this.Response.Equal(that1.Response) {
		return false
	}
	return true
}
func (this *Options) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Options)
	if !ok {
		that2, ok := that.(Options)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.CacheDisabled != that1.CacheDisabled {
		return false
	}
	if this.ShardingDisabled != that1.ShardingDisabled {
		return false
	}
	if this.TotalShards != that1.TotalShards {
		return false
	}
	if this.InstantSplitDisabled != that1.InstantSplitDisabled {
		return false
	}
	if this.InstantSplitInterval != that1.InstantSplitInterval {
		return false
	}
	return true
}
func (this *Hints) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Hints)
	if !ok {
		that2, ok := that.(Hints)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TotalQueries != that1.TotalQueries {
		return false
	}
	return true
}
func (this *PrometheusRangeQueryRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&querymiddleware.PrometheusRangeQueryRequest{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "Start: "+fmt.Sprintf("%#v", this.Start)+",\n")
	s = append(s, "End: "+fmt.Sprintf("%#v", this.End)+",\n")
	s = append(s, "Step: "+fmt.Sprintf("%#v", this.Step)+",\n")
	s = append(s, "Timeout: "+fmt.Sprintf("%#v", this.Timeout)+",\n")
	s = append(s, "Query: "+fmt.Sprintf("%#v", this.Query)+",\n")
	s = append(s, "Options: "+strings.Replace(this.Options.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	if this.Hints != nil {
		s = append(s, "Hints: "+fmt.Sprintf("%#v", this.Hints)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PrometheusInstantQueryRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&querymiddleware.PrometheusInstantQueryRequest{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "Time: "+fmt.Sprintf("%#v", this.Time)+",\n")
	s = append(s, "Query: "+fmt.Sprintf("%#v", this.Query)+",\n")
	s = append(s, "Options: "+strings.Replace(this.Options.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	if this.Hints != nil {
		s = append(s, "Hints: "+fmt.Sprintf("%#v", this.Hints)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PrometheusResponseHeader) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&querymiddleware.PrometheusResponseHeader{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Values: "+fmt.Sprintf("%#v", this.Values)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PrometheusResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&querymiddleware.PrometheusResponse{")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	if this.Data != nil {
		s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	}
	s = append(s, "ErrorType: "+fmt.Sprintf("%#v", this.ErrorType)+",\n")
	s = append(s, "Error: "+fmt.Sprintf("%#v", this.Error)+",\n")
	if this.Headers != nil {
		s = append(s, "Headers: "+fmt.Sprintf("%#v", this.Headers)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PrometheusData) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&querymiddleware.PrometheusData{")
	s = append(s, "ResultType: "+fmt.Sprintf("%#v", this.ResultType)+",\n")
	if this.Result != nil {
		vs := make([]*SampleStream, len(this.Result))
		for i := range vs {
			vs[i] = &this.Result[i]
		}
		s = append(s, "Result: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SampleStream) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&querymiddleware.SampleStream{")
	s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	if this.Samples != nil {
		vs := make([]*mimirpb.Sample, len(this.Samples))
		for i := range vs {
			vs[i] = &this.Samples[i]
		}
		s = append(s, "Samples: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CachedResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&querymiddleware.CachedResponse{")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	if this.Extents != nil {
		vs := make([]*Extent, len(this.Extents))
		for i := range vs {
			vs[i] = &this.Extents[i]
		}
		s = append(s, "Extents: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Extent) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&querymiddleware.Extent{")
	s = append(s, "Start: "+fmt.Sprintf("%#v", this.Start)+",\n")
	s = append(s, "End: "+fmt.Sprintf("%#v", this.End)+",\n")
	s = append(s, "TraceId: "+fmt.Sprintf("%#v", this.TraceId)+",\n")
	if this.Response != nil {
		s = append(s, "Response: "+fmt.Sprintf("%#v", this.Response)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Options) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&querymiddleware.Options{")
	s = append(s, "CacheDisabled: "+fmt.Sprintf("%#v", this.CacheDisabled)+",\n")
	s = append(s, "ShardingDisabled: "+fmt.Sprintf("%#v", this.ShardingDisabled)+",\n")
	s = append(s, "TotalShards: "+fmt.Sprintf("%#v", this.TotalShards)+",\n")
	s = append(s, "InstantSplitDisabled: "+fmt.Sprintf("%#v", this.InstantSplitDisabled)+",\n")
	s = append(s, "InstantSplitInterval: "+fmt.Sprintf("%#v", this.InstantSplitInterval)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Hints) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&querymiddleware.Hints{")
	s = append(s, "TotalQueries: "+fmt.Sprintf("%#v", this.TotalQueries)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringModel(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *PrometheusRangeQueryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrometheusRangeQueryRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrometheusRangeQueryRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintModel(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.Id != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x40
	}
	{
		size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintModel(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x3a
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0x32
	}
	n3, err3 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.Timeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.Timeout):])
	if err3 != nil {
		return 0, err3
	}
	i -= n3
	i = encodeVarintModel(dAtA, i, uint64(n3))
	i--
	dAtA[i] = 0x2a
	if m.Step != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.Step))
		i--
		dAtA[i] = 0x20
	}
	if m.End != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.End))
		i--
		dAtA[i] = 0x18
	}
	if m.Start != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.Start))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PrometheusInstantQueryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrometheusInstantQueryRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrometheusInstantQueryRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintModel(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.Id != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x28
	}
	{
		size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintModel(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Time != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.Time))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PrometheusResponseHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrometheusResponseHeader) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrometheusResponseHeader) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintModel(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PrometheusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrometheusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrometheusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Headers) > 0 {
		for iNdEx := len(m.Headers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Headers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintModel(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ErrorType) > 0 {
		i -= len(m.ErrorType)
		copy(dAtA[i:], m.ErrorType)
		i = encodeVarintModel(dAtA, i, uint64(len(m.ErrorType)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Data != nil {
		{
			size, err := m.Data.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintModel(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PrometheusData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrometheusData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrometheusData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Result) > 0 {
		for iNdEx := len(m.Result) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Result[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintModel(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ResultType) > 0 {
		i -= len(m.ResultType)
		copy(dAtA[i:], m.ResultType)
		i = encodeVarintModel(dAtA, i, uint64(len(m.ResultType)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SampleStream) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SampleStream) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SampleStream) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Samples) > 0 {
		for iNdEx := len(m.Samples) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Samples[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintModel(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size := m.Labels[iNdEx].Size()
				i -= size
				if _, err := m.Labels[iNdEx].MarshalTo(dAtA[i:]); err != nil {
					return 0, err
				}
				i = encodeVarintModel(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CachedResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CachedResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CachedResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Extents) > 0 {
		for iNdEx := len(m.Extents) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Extents[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintModel(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Extent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Extent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Extent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Response != nil {
		{
			size, err := m.Response.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintModel(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.TraceId) > 0 {
		i -= len(m.TraceId)
		copy(dAtA[i:], m.TraceId)
		i = encodeVarintModel(dAtA, i, uint64(len(m.TraceId)))
		i--
		dAtA[i] = 0x22
	}
	if m.End != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.End))
		i--
		dAtA[i] = 0x10
	}
	if m.Start != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.Start))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Options) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Options) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Options) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InstantSplitInterval != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.InstantSplitInterval))
		i--
		dAtA[i] = 0x28
	}
	if m.InstantSplitDisabled {
		i--
		if m.InstantSplitDisabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.TotalShards != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.TotalShards))
		i--
		dAtA[i] = 0x18
	}
	if m.ShardingDisabled {
		i--
		if m.ShardingDisabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.CacheDisabled {
		i--
		if m.CacheDisabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Hints) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Hints) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Hints) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TotalQueries != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.TotalQueries))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintModel(dAtA []byte, offset int, v uint64) int {
	offset -= sovModel(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *PrometheusRangeQueryRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if m.Start != 0 {
		n += 1 + sovModel(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovModel(uint64(m.End))
	}
	if m.Step != 0 {
		n += 1 + sovModel(uint64(m.Step))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.Timeout)
	n += 1 + l + sovModel(uint64(l))
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	l = m.Options.Size()
	n += 1 + l + sovModel(uint64(l))
	if m.Id != 0 {
		n += 1 + sovModel(uint64(m.Id))
	}
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovModel(uint64(l))
	}
	return n
}

func (m *PrometheusInstantQueryRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if m.Time != 0 {
		n += 1 + sovModel(uint64(m.Time))
	}
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	l = m.Options.Size()
	n += 1 + l + sovModel(uint64(l))
	if m.Id != 0 {
		n += 1 + sovModel(uint64(m.Id))
	}
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovModel(uint64(l))
	}
	return n
}

func (m *PrometheusResponseHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovModel(uint64(l))
		}
	}
	return n
}

func (m *PrometheusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Status)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if m.Data != nil {
		l = m.Data.Size()
		n += 1 + l + sovModel(uint64(l))
	}
	l = len(m.ErrorType)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovModel(uint64(l))
		}
	}
	return n
}

func (m *PrometheusData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ResultType)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if len(m.Result) > 0 {
		for _, e := range m.Result {
			l = e.Size()
			n += 1 + l + sovModel(uint64(l))
		}
	}
	return n
}

func (m *SampleStream) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovModel(uint64(l))
		}
	}
	if len(m.Samples) > 0 {
		for _, e := range m.Samples {
			l = e.Size()
			n += 1 + l + sovModel(uint64(l))
		}
	}
	return n
}

func (m *CachedResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if len(m.Extents) > 0 {
		for _, e := range m.Extents {
			l = e.Size()
			n += 1 + l + sovModel(uint64(l))
		}
	}
	return n
}

func (m *Extent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Start != 0 {
		n += 1 + sovModel(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovModel(uint64(m.End))
	}
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if m.Response != nil {
		l = m.Response.Size()
		n += 1 + l + sovModel(uint64(l))
	}
	return n
}

func (m *Options) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CacheDisabled {
		n += 2
	}
	if m.ShardingDisabled {
		n += 2
	}
	if m.TotalShards != 0 {
		n += 1 + sovModel(uint64(m.TotalShards))
	}
	if m.InstantSplitDisabled {
		n += 2
	}
	if m.InstantSplitInterval != 0 {
		n += 1 + sovModel(uint64(m.InstantSplitInterval))
	}
	return n
}

func (m *Hints) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TotalQueries != 0 {
		n += 1 + sovModel(uint64(m.TotalQueries))
	}
	return n
}

func sovModel(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozModel(x uint64) (n int) {
	return sovModel(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *PrometheusRangeQueryRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PrometheusRangeQueryRequest{`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`Start:` + fmt.Sprintf("%v", this.Start) + `,`,
		`End:` + fmt.Sprintf("%v", this.End) + `,`,
		`Step:` + fmt.Sprintf("%v", this.Step) + `,`,
		`Timeout:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Timeout), "Duration", "duration.Duration", 1), `&`, ``, 1) + `,`,
		`Query:` + fmt.Sprintf("%v", this.Query) + `,`,
		`Options:` + strings.Replace(strings.Replace(this.Options.String(), "Options", "Options", 1), `&`, ``, 1) + `,`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`Hints:` + strings.Replace(this.Hints.String(), "Hints", "Hints", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PrometheusInstantQueryRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PrometheusInstantQueryRequest{`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`Time:` + fmt.Sprintf("%v", this.Time) + `,`,
		`Query:` + fmt.Sprintf("%v", this.Query) + `,`,
		`Options:` + strings.Replace(strings.Replace(this.Options.String(), "Options", "Options", 1), `&`, ``, 1) + `,`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`Hints:` + strings.Replace(this.Hints.String(), "Hints", "Hints", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PrometheusResponseHeader) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PrometheusResponseHeader{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Values:` + fmt.Sprintf("%v", this.Values) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PrometheusResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForHeaders := "[]*PrometheusResponseHeader{"
	for _, f := range this.Headers {
		repeatedStringForHeaders += strings.Replace(f.String(), "PrometheusResponseHeader", "PrometheusResponseHeader", 1) + ","
	}
	repeatedStringForHeaders += "}"
	s := strings.Join([]string{`&PrometheusResponse{`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`Data:` + strings.Replace(this.Data.String(), "PrometheusData", "PrometheusData", 1) + `,`,
		`ErrorType:` + fmt.Sprintf("%v", this.ErrorType) + `,`,
		`Error:` + fmt.Sprintf("%v", this.Error) + `,`,
		`Headers:` + repeatedStringForHeaders + `,`,
		`}`,
	}, "")
	return s
}
func (this *PrometheusData) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForResult := "[]SampleStream{"
	for _, f := range this.Result {
		repeatedStringForResult += strings.Replace(strings.Replace(f.String(), "SampleStream", "SampleStream", 1), `&`, ``, 1) + ","
	}
	repeatedStringForResult += "}"
	s := strings.Join([]string{`&PrometheusData{`,
		`ResultType:` + fmt.Sprintf("%v", this.ResultType) + `,`,
		`Result:` + repeatedStringForResult + `,`,
		`}`,
	}, "")
	return s
}
func (this *SampleStream) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForSamples := "[]Sample{"
	for _, f := range this.Samples {
		repeatedStringForSamples += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForSamples += "}"
	s := strings.Join([]string{`&SampleStream{`,
		`Labels:` + fmt.Sprintf("%v", this.Labels) + `,`,
		`Samples:` + repeatedStringForSamples + `,`,
		`}`,
	}, "")
	return s
}
func (this *CachedResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForExtents := "[]Extent{"
	for _, f := range this.Extents {
		repeatedStringForExtents += strings.Replace(strings.Replace(f.String(), "Extent", "Extent", 1), `&`, ``, 1) + ","
	}
	repeatedStringForExtents += "}"
	s := strings.Join([]string{`&CachedResponse{`,
		`Key:` + fmt.Sprintf("%v", this.Key) + `,`,
		`Extents:` + repeatedStringForExtents + `,`,
		`}`,
	}, "")
	return s
}
func (this *Extent) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Extent{`,
		`Start:` + fmt.Sprintf("%v", this.Start) + `,`,
		`End:` + fmt.Sprintf("%v", this.End) + `,`,
		`TraceId:` + fmt.Sprintf("%v", this.TraceId) + `,`,
		`Response:` + strings.Replace(fmt.Sprintf("%v", this.Response), "Any", "types.Any", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Options) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Options{`,
		`CacheDisabled:` + fmt.Sprintf("%v", this.CacheDisabled) + `,`,
		`ShardingDisabled:` + fmt.Sprintf("%v", this.ShardingDisabled) + `,`,
		`TotalShards:` + fmt.Sprintf("%v", this.TotalShards) + `,`,
		`InstantSplitDisabled:` + fmt.Sprintf("%v", this.InstantSplitDisabled) + `,`,
		`InstantSplitInterval:` + fmt.Sprintf("%v", this.InstantSplitInterval) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Hints) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Hints{`,
		`TotalQueries:` + fmt.Sprintf("%v", this.TotalQueries) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringModel(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *PrometheusRangeQueryRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrometheusRangeQueryRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrometheusRangeQueryRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Step", wireType)
			}
			m.Step = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Step |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.Timeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hints == nil {
				m.Hints = &Hints{}
			}
			if err := m.Hints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrometheusInstantQueryRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrometheusInstantQueryRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrometheusInstantQueryRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			m.Time = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Time |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hints == nil {
				m.Hints = &Hints{}
			}
			if err := m.Hints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrometheusResponseHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrometheusResponseHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrometheusResponseHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrometheusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrometheusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrometheusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Data == nil {
				m.Data = &PrometheusData{}
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &PrometheusResponseHeader{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrometheusData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrometheusData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrometheusData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResultType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResultType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = append(m.Result, SampleStream{})
			if err := m.Result[len(m.Result)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SampleStream) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SampleStream: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SampleStream: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, github_com_grafana_mimir_pkg_mimirpb.LabelAdapter{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Samples", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Samples = append(m.Samples, mimirpb.Sample{})
			if err := m.Samples[len(m.Samples)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CachedResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CachedResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CachedResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Extents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Extents = append(m.Extents, Extent{})
			if err := m.Extents[len(m.Extents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Extent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Extent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Extent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Response", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Response == nil {
				m.Response = &types.Any{}
			}
			if err := m.Response.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Options) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Options: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Options: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheDisabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CacheDisabled = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardingDisabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ShardingDisabled = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalShards", wireType)
			}
			m.TotalShards = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalShards |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstantSplitDisabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.InstantSplitDisabled = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstantSplitInterval", wireType)
			}
			m.InstantSplitInterval = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InstantSplitInterval |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Hints) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Hints: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Hints: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalQueries", wireType)
			}
			m.TotalQueries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalQueries |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipModel(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowModel
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowModel
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowModel
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthModel
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthModel
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowModel
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipModel(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthModel
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthModel = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowModel   = fmt.Errorf("proto: integer overflow")
)
