// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: stats.proto

package stats

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	_ "github.com/golang/protobuf/ptypes/duration"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type Stats struct {
	// The sum of all wall time spent in the querier to execute the query.
	WallTime time.Duration `protobuf:"bytes,1,opt,name=wall_time,json=wallTime,proto3,stdduration" json:"wall_time"`
	// The number of series fetched for the query
	FetchedSeriesCount uint64 `protobuf:"varint,2,opt,name=fetched_series_count,json=fetchedSeriesCount,proto3" json:"fetched_series_count,omitempty"`
	// The number of bytes of the chunks fetched for the query
	FetchedChunkBytes uint64 `protobuf:"varint,3,opt,name=fetched_chunk_bytes,json=fetchedChunkBytes,proto3" json:"fetched_chunk_bytes,omitempty"`
	// The number of chunks fetched for the query
	FetchedChunksCount uint64 `protobuf:"varint,4,opt,name=fetched_chunks_count,json=fetchedChunksCount,proto3" json:"fetched_chunks_count,omitempty"`
	// The number of sharded queries executed. 0 if sharding is disabled or the query can't be sharded.
	ShardedQueries uint32 `protobuf:"varint,5,opt,name=sharded_queries,json=shardedQueries,proto3" json:"sharded_queries,omitempty"`
	// The number of split partial queries executed. 0 if splitting is disabled or the query can't be split.
	SplitQueries uint32 `protobuf:"varint,6,opt,name=split_queries,json=splitQueries,proto3" json:"split_queries,omitempty"`
}

func (m *Stats) Reset()      { *m = Stats{} }
func (*Stats) ProtoMessage() {}
func (*Stats) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4756a0aec8b9d44, []int{0}
}
func (m *Stats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Stats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Stats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Stats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Stats.Merge(m, src)
}
func (m *Stats) XXX_Size() int {
	return m.Size()
}
func (m *Stats) XXX_DiscardUnknown() {
	xxx_messageInfo_Stats.DiscardUnknown(m)
}

var xxx_messageInfo_Stats proto.InternalMessageInfo

func (m *Stats) GetWallTime() time.Duration {
	if m != nil {
		return m.WallTime
	}
	return 0
}

func (m *Stats) GetFetchedSeriesCount() uint64 {
	if m != nil {
		return m.FetchedSeriesCount
	}
	return 0
}

func (m *Stats) GetFetchedChunkBytes() uint64 {
	if m != nil {
		return m.FetchedChunkBytes
	}
	return 0
}

func (m *Stats) GetFetchedChunksCount() uint64 {
	if m != nil {
		return m.FetchedChunksCount
	}
	return 0
}

func (m *Stats) GetShardedQueries() uint32 {
	if m != nil {
		return m.ShardedQueries
	}
	return 0
}

func (m *Stats) GetSplitQueries() uint32 {
	if m != nil {
		return m.SplitQueries
	}
	return 0
}

func init() {
	proto.RegisterType((*Stats)(nil), "stats.Stats")
}

func init() { proto.RegisterFile("stats.proto", fileDescriptor_b4756a0aec8b9d44) }

var fileDescriptor_b4756a0aec8b9d44 = []byte{
	// 340 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x54, 0x91, 0xbd, 0x52, 0xea, 0x40,
	0x14, 0xc7, 0x77, 0xb9, 0xc0, 0x70, 0x97, 0xcb, 0x75, 0x8c, 0x16, 0x91, 0xe2, 0xc0, 0x68, 0x21,
	0x8d, 0xc1, 0xd1, 0xd2, 0xc6, 0x01, 0x5f, 0x40, 0xb0, 0xb2, 0xc9, 0xe4, 0x63, 0x49, 0x32, 0x06,
	0x16, 0xb3, 0x9b, 0x71, 0xec, 0x7c, 0x04, 0x4b, 0x1f, 0xc1, 0x19, 0x5f, 0x84, 0x92, 0x92, 0x4a,
	0x65, 0x69, 0x2c, 0x79, 0x04, 0x27, 0x27, 0xc1, 0x8f, 0x6e, 0xcf, 0xf9, 0xfd, 0x7f, 0xfb, 0x9f,
	0xd9, 0x65, 0x75, 0xa9, 0x1c, 0x25, 0xad, 0x69, 0x22, 0x94, 0x30, 0x2a, 0x38, 0x34, 0x8f, 0x82,
	0x48, 0x85, 0xa9, 0x6b, 0x79, 0x62, 0xdc, 0x0d, 0x44, 0x20, 0xba, 0x48, 0xdd, 0x74, 0x84, 0x13,
	0x0e, 0x78, 0xca, 0xad, 0x26, 0x04, 0x42, 0x04, 0x31, 0xff, 0x4e, 0xf9, 0x69, 0xe2, 0xa8, 0x48,
	0x4c, 0x72, 0xbe, 0xff, 0x52, 0x62, 0x95, 0x61, 0x76, 0xb1, 0x71, 0xce, 0xfe, 0xde, 0x39, 0x71,
	0x6c, 0xab, 0x68, 0xcc, 0x4d, 0xda, 0xa6, 0x9d, 0xfa, 0xc9, 0x9e, 0x95, 0xdb, 0xd6, 0xc6, 0xb6,
	0x2e, 0x0a, 0xbb, 0x57, 0x9b, 0xbd, 0xb6, 0xc8, 0xd3, 0x5b, 0x8b, 0x0e, 0x6a, 0x99, 0x75, 0x15,
	0x8d, 0xb9, 0x71, 0xcc, 0x76, 0x47, 0x5c, 0x79, 0x21, 0xf7, 0x6d, 0xc9, 0x93, 0x88, 0x4b, 0xdb,
	0x13, 0xe9, 0x44, 0x99, 0xa5, 0x36, 0xed, 0x94, 0x07, 0x46, 0xc1, 0x86, 0x88, 0xfa, 0x19, 0x31,
	0x2c, 0xb6, 0xb3, 0x31, 0xbc, 0x30, 0x9d, 0xdc, 0xd8, 0xee, 0xbd, 0xe2, 0xd2, 0xfc, 0x83, 0xc2,
	0x76, 0x81, 0xfa, 0x19, 0xe9, 0x65, 0xe0, 0x67, 0x03, 0xe6, 0x37, 0x0d, 0xe5, 0x5f, 0x0d, 0x28,
	0x14, 0x0d, 0x87, 0x6c, 0x4b, 0x86, 0x4e, 0xe2, 0x73, 0xdf, 0xbe, 0x4d, 0xb1, 0xd9, 0xac, 0xb4,
	0x69, 0xa7, 0x31, 0xf8, 0x5f, 0xac, 0x2f, 0xf3, 0xad, 0x71, 0xc0, 0x1a, 0x72, 0x1a, 0x47, 0xea,
	0x2b, 0x56, 0xc5, 0xd8, 0x3f, 0x5c, 0x16, 0xa1, 0xde, 0xd9, 0x7c, 0x09, 0x64, 0xb1, 0x04, 0xb2,
	0x5e, 0x02, 0x7d, 0xd0, 0x40, 0x9f, 0x35, 0xd0, 0x99, 0x06, 0x3a, 0xd7, 0x40, 0xdf, 0x35, 0xd0,
	0x0f, 0x0d, 0x64, 0xad, 0x81, 0x3e, 0xae, 0x80, 0xcc, 0x57, 0x40, 0x16, 0x2b, 0x20, 0xd7, 0xf9,
	0xcf, 0xb9, 0x55, 0x7c, 0xc5, 0xd3, 0xcf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x9d, 0x30, 0xbc, 0x87,
	0xd6, 0x01, 0x00, 0x00,
}

func (this *Stats) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Stats)
	if !ok {
		that2, ok := that.(Stats)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.WallTime != that1.WallTime {
		return false
	}
	if this.FetchedSeriesCount != that1.FetchedSeriesCount {
		return false
	}
	if this.FetchedChunkBytes != that1.FetchedChunkBytes {
		return false
	}
	if this.FetchedChunksCount != that1.FetchedChunksCount {
		return false
	}
	if this.ShardedQueries != that1.ShardedQueries {
		return false
	}
	if this.SplitQueries != that1.SplitQueries {
		return false
	}
	return true
}
func (this *Stats) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&stats.Stats{")
	s = append(s, "WallTime: "+fmt.Sprintf("%#v", this.WallTime)+",\n")
	s = append(s, "FetchedSeriesCount: "+fmt.Sprintf("%#v", this.FetchedSeriesCount)+",\n")
	s = append(s, "FetchedChunkBytes: "+fmt.Sprintf("%#v", this.FetchedChunkBytes)+",\n")
	s = append(s, "FetchedChunksCount: "+fmt.Sprintf("%#v", this.FetchedChunksCount)+",\n")
	s = append(s, "ShardedQueries: "+fmt.Sprintf("%#v", this.ShardedQueries)+",\n")
	s = append(s, "SplitQueries: "+fmt.Sprintf("%#v", this.SplitQueries)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringStats(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Stats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Stats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Stats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SplitQueries != 0 {
		i = encodeVarintStats(dAtA, i, uint64(m.SplitQueries))
		i--
		dAtA[i] = 0x30
	}
	if m.ShardedQueries != 0 {
		i = encodeVarintStats(dAtA, i, uint64(m.ShardedQueries))
		i--
		dAtA[i] = 0x28
	}
	if m.FetchedChunksCount != 0 {
		i = encodeVarintStats(dAtA, i, uint64(m.FetchedChunksCount))
		i--
		dAtA[i] = 0x20
	}
	if m.FetchedChunkBytes != 0 {
		i = encodeVarintStats(dAtA, i, uint64(m.FetchedChunkBytes))
		i--
		dAtA[i] = 0x18
	}
	if m.FetchedSeriesCount != 0 {
		i = encodeVarintStats(dAtA, i, uint64(m.FetchedSeriesCount))
		i--
		dAtA[i] = 0x10
	}
	n1, err1 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.WallTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.WallTime):])
	if err1 != nil {
		return 0, err1
	}
	i -= n1
	i = encodeVarintStats(dAtA, i, uint64(n1))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func encodeVarintStats(dAtA []byte, offset int, v uint64) int {
	offset -= sovStats(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Stats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.WallTime)
	n += 1 + l + sovStats(uint64(l))
	if m.FetchedSeriesCount != 0 {
		n += 1 + sovStats(uint64(m.FetchedSeriesCount))
	}
	if m.FetchedChunkBytes != 0 {
		n += 1 + sovStats(uint64(m.FetchedChunkBytes))
	}
	if m.FetchedChunksCount != 0 {
		n += 1 + sovStats(uint64(m.FetchedChunksCount))
	}
	if m.ShardedQueries != 0 {
		n += 1 + sovStats(uint64(m.ShardedQueries))
	}
	if m.SplitQueries != 0 {
		n += 1 + sovStats(uint64(m.SplitQueries))
	}
	return n
}

func sovStats(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozStats(x uint64) (n int) {
	return sovStats(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Stats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Stats{`,
		`WallTime:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.WallTime), "Duration", "duration.Duration", 1), `&`, ``, 1) + `,`,
		`FetchedSeriesCount:` + fmt.Sprintf("%v", this.FetchedSeriesCount) + `,`,
		`FetchedChunkBytes:` + fmt.Sprintf("%v", this.FetchedChunkBytes) + `,`,
		`FetchedChunksCount:` + fmt.Sprintf("%v", this.FetchedChunksCount) + `,`,
		`ShardedQueries:` + fmt.Sprintf("%v", this.ShardedQueries) + `,`,
		`SplitQueries:` + fmt.Sprintf("%v", this.SplitQueries) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringStats(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Stats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Stats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Stats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WallTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.WallTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FetchedSeriesCount", wireType)
			}
			m.FetchedSeriesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FetchedSeriesCount |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FetchedChunkBytes", wireType)
			}
			m.FetchedChunkBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FetchedChunkBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FetchedChunksCount", wireType)
			}
			m.FetchedChunksCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FetchedChunksCount |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardedQueries", wireType)
			}
			m.ShardedQueries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardedQueries |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SplitQueries", wireType)
			}
			m.SplitQueries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SplitQueries |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipStats(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowStats
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthStats
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthStats
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowStats
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipStats(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthStats
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthStats = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowStats   = fmt.Errorf("proto: integer overflow")
)
