// Code generated by go-swagger; DO NOT EDIT.

package restapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

var (
	// SwaggerJSON embedded version of the swagger document used at generation time
	SwaggerJSON json.RawMessage
	// FlatSwaggerJSON embedded flattened version of the swagger document used at generation time
	FlatSwaggerJSON json.RawMessage
)

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/cloudevents+json",
    "application/json"
  ],
  "produces": [
    "application/cloudevents+json",
    "application/json"
  ],
  "schemes": [
    "http"
  ],
  "swagger": "2.0",
  "info": {
    "title": "mongodb-datastore",
    "version": "0.1.0"
  },
  "basePath": "/",
  "paths": {
    "/event": {
      "get": {
        "tags": [
          "event"
        ],
        "summary": "Gets events from the data store",
        "operationId": "getEvents",
        "parameters": [
          {
            "type": "string",
            "description": "keptnContext of the events to get",
            "name": "keptnContext",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Type of the keptn cloud event",
            "name": "type",
            "in": "query"
          },
          {
            "$ref": "#/parameters/pagesizeParam"
          },
          {
            "$ref": "#/parameters/pageParam"
          }
        ],
        "responses": {
          "200": {
            "description": "ok",
            "schema": {
              "type": "object",
              "properties": {
                "events": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/KeptnContextExtendedCE"
                  }
                },
                "nextPageKey": {
                  "description": "Pointer to the next page",
                  "type": "string"
                },
                "pageSize": {
                  "description": "Size of the returned page",
                  "type": "integer"
                },
                "totalCount": {
                  "description": "Total number of events",
                  "type": "integer"
                }
              }
            }
          },
          "default": {
            "description": "error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "event"
        ],
        "summary": "Saves an event to the datastore",
        "operationId": "saveEvent",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/KeptnContextExtendedCE"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "created"
          },
          "default": {
            "description": "error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/log": {
      "get": {
        "tags": [
          "logs"
        ],
        "summary": "gets the logs from the datastore",
        "operationId": "getLogs",
        "parameters": [
          {
            "type": "string",
            "description": "EventId of the event the logs belog to",
            "name": "eventId",
            "in": "query"
          },
          {
            "$ref": "#/parameters/pagesizeParam"
          },
          {
            "$ref": "#/parameters/pageParam"
          }
        ],
        "responses": {
          "200": {
            "description": "ok",
            "schema": {
              "type": "object",
              "properties": {
                "logs": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/LogEntry"
                  }
                },
                "nextPageKey": {
                  "description": "Pointer to the next page",
                  "type": "string"
                },
                "pageSize": {
                  "description": "Size of the returned page",
                  "type": "integer"
                },
                "totalCount": {
                  "description": "Total number of logs",
                  "type": "integer"
                }
              }
            }
          },
          "default": {
            "description": "error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "logs"
        ],
        "summary": "Saves a log to the datastore",
        "operationId": "saveLog",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/LogEntry"
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "created"
          },
          "default": {
            "description": "error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "KeptnContextExtendedCE": {
      "allOf": [
        {
          "$ref": "https://raw.githubusercontent.com/cloudevents/spec/v0.2/spec.json#/definitions/event"
        },
        {
          "type": "object",
          "properties": {
            "shkeptncontext": {
              "type": "string"
            }
          }
        }
      ]
    },
    "LogEntry": {
      "type": "object",
      "properties": {
        "eventId": {
          "type": "string"
        },
        "keptnContext": {
          "type": "string"
        },
        "keptnService": {
          "type": "string"
        },
        "logLevel": {
          "type": "string"
        },
        "message": {
          "type": "string"
        },
        "timestamp": {
          "type": "string",
          "format": "date-time"
        }
      }
    },
    "error": {
      "type": "object",
      "required": [
        "message"
      ],
      "properties": {
        "code": {
          "type": "integer",
          "format": "int64"
        },
        "fields": {
          "type": "string"
        },
        "message": {
          "type": "string"
        }
      }
    },
    "principal": {
      "type": "string"
    }
  },
  "parameters": {
    "pageParam": {
      "type": "string",
      "description": "Key of the page to be returned",
      "name": "nextPageKey",
      "in": "query"
    },
    "pagesizeParam": {
      "maximum": 100,
      "minimum": 1,
      "type": "integer",
      "default": 20,
      "description": "Page size to be returned",
      "name": "pageSize",
      "in": "query"
    }
  }
}`))
	FlatSwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/cloudevents+json",
    "application/json"
  ],
  "produces": [
    "application/cloudevents+json",
    "application/json"
  ],
  "schemes": [
    "http"
  ],
  "swagger": "2.0",
  "info": {
    "title": "mongodb-datastore",
    "version": "0.1.0"
  },
  "basePath": "/",
  "paths": {
    "/event": {
      "get": {
        "tags": [
          "event"
        ],
        "summary": "Gets events from the data store",
        "operationId": "getEvents",
        "parameters": [
          {
            "type": "string",
            "description": "keptnContext of the events to get",
            "name": "keptnContext",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Type of the keptn cloud event",
            "name": "type",
            "in": "query"
          },
          {
            "maximum": 100,
            "minimum": 1,
            "type": "integer",
            "default": 20,
            "description": "Page size to be returned",
            "name": "pageSize",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Key of the page to be returned",
            "name": "nextPageKey",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "ok",
            "schema": {
              "type": "object",
              "properties": {
                "events": {
                  "type": "array",
                  "items": {
                    "allOf": [
                      {
                        "type": "object",
                        "required": [
                          "specversion",
                          "id",
                          "type",
                          "source"
                        ],
                        "properties": {
                          "contenttype": {
                            "type": "string"
                          },
                          "data": {
                            "type": [
                              "object",
                              "string"
                            ]
                          },
                          "extensions": {
                            "type": "object"
                          },
                          "id": {
                            "type": "string"
                          },
                          "source": {
                            "type": "string",
                            "format": "uri-reference"
                          },
                          "specversion": {
                            "type": "string"
                          },
                          "time": {
                            "type": "string",
                            "format": "date-time"
                          },
                          "type": {
                            "type": "string"
                          }
                        }
                      },
                      {
                        "type": "object",
                        "properties": {
                          "shkeptncontext": {
                            "type": "string"
                          }
                        }
                      }
                    ]
                  }
                },
                "nextPageKey": {
                  "description": "Pointer to the next page",
                  "type": "string"
                },
                "pageSize": {
                  "description": "Size of the returned page",
                  "type": "integer"
                },
                "totalCount": {
                  "description": "Total number of events",
                  "type": "integer"
                }
              }
            }
          },
          "default": {
            "description": "error",
            "schema": {
              "type": "object",
              "required": [
                "message"
              ],
              "properties": {
                "code": {
                  "type": "integer",
                  "format": "int64"
                },
                "fields": {
                  "type": "string"
                },
                "message": {
                  "type": "string"
                }
              }
            }
          }
        }
      },
      "post": {
        "tags": [
          "event"
        ],
        "summary": "Saves an event to the datastore",
        "operationId": "saveEvent",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "allOf": [
                {
                  "type": "object",
                  "required": [
                    "specversion",
                    "id",
                    "type",
                    "source"
                  ],
                  "properties": {
                    "contenttype": {
                      "type": "string"
                    },
                    "data": {
                      "type": [
                        "object",
                        "string"
                      ]
                    },
                    "extensions": {
                      "type": "object"
                    },
                    "id": {
                      "type": "string"
                    },
                    "source": {
                      "type": "string",
                      "format": "uri-reference"
                    },
                    "specversion": {
                      "type": "string"
                    },
                    "time": {
                      "type": "string",
                      "format": "date-time"
                    },
                    "type": {
                      "type": "string"
                    }
                  }
                },
                {
                  "type": "object",
                  "properties": {
                    "shkeptncontext": {
                      "type": "string"
                    }
                  }
                }
              ]
            }
          }
        ],
        "responses": {
          "201": {
            "description": "created"
          },
          "default": {
            "description": "error",
            "schema": {
              "type": "object",
              "required": [
                "message"
              ],
              "properties": {
                "code": {
                  "type": "integer",
                  "format": "int64"
                },
                "fields": {
                  "type": "string"
                },
                "message": {
                  "type": "string"
                }
              }
            }
          }
        }
      }
    },
    "/log": {
      "get": {
        "tags": [
          "logs"
        ],
        "summary": "gets the logs from the datastore",
        "operationId": "getLogs",
        "parameters": [
          {
            "type": "string",
            "description": "EventId of the event the logs belog to",
            "name": "eventId",
            "in": "query"
          },
          {
            "maximum": 100,
            "minimum": 1,
            "type": "integer",
            "default": 20,
            "description": "Page size to be returned",
            "name": "pageSize",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Key of the page to be returned",
            "name": "nextPageKey",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "ok",
            "schema": {
              "type": "object",
              "properties": {
                "logs": {
                  "type": "array",
                  "items": {
                    "type": "object",
                    "properties": {
                      "eventId": {
                        "type": "string"
                      },
                      "keptnContext": {
                        "type": "string"
                      },
                      "keptnService": {
                        "type": "string"
                      },
                      "logLevel": {
                        "type": "string"
                      },
                      "message": {
                        "type": "string"
                      },
                      "timestamp": {
                        "type": "string",
                        "format": "date-time"
                      }
                    }
                  }
                },
                "nextPageKey": {
                  "description": "Pointer to the next page",
                  "type": "string"
                },
                "pageSize": {
                  "description": "Size of the returned page",
                  "type": "integer"
                },
                "totalCount": {
                  "description": "Total number of logs",
                  "type": "integer"
                }
              }
            }
          },
          "default": {
            "description": "error",
            "schema": {
              "type": "object",
              "required": [
                "message"
              ],
              "properties": {
                "code": {
                  "type": "integer",
                  "format": "int64"
                },
                "fields": {
                  "type": "string"
                },
                "message": {
                  "type": "string"
                }
              }
            }
          }
        }
      },
      "post": {
        "tags": [
          "logs"
        ],
        "summary": "Saves a log to the datastore",
        "operationId": "saveLog",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "type": "array",
              "items": {
                "type": "object",
                "properties": {
                  "eventId": {
                    "type": "string"
                  },
                  "keptnContext": {
                    "type": "string"
                  },
                  "keptnService": {
                    "type": "string"
                  },
                  "logLevel": {
                    "type": "string"
                  },
                  "message": {
                    "type": "string"
                  },
                  "timestamp": {
                    "type": "string",
                    "format": "date-time"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "created"
          },
          "default": {
            "description": "error",
            "schema": {
              "type": "object",
              "required": [
                "message"
              ],
              "properties": {
                "code": {
                  "type": "integer",
                  "format": "int64"
                },
                "fields": {
                  "type": "string"
                },
                "message": {
                  "type": "string"
                }
              }
            }
          }
        }
      }
    }
  },
  "definitions": {
    "KeptnContextExtendedCE": {
      "allOf": [
        {
          "type": "object",
          "required": [
            "specversion",
            "id",
            "type",
            "source"
          ],
          "properties": {
            "contenttype": {
              "type": "string"
            },
            "data": {
              "type": [
                "object",
                "string"
              ]
            },
            "extensions": {
              "type": "object"
            },
            "id": {
              "type": "string"
            },
            "source": {
              "type": "string",
              "format": "uri-reference"
            },
            "specversion": {
              "type": "string"
            },
            "time": {
              "type": "string",
              "format": "date-time"
            },
            "type": {
              "type": "string"
            }
          }
        },
        {
          "type": "object",
          "properties": {
            "shkeptncontext": {
              "type": "string"
            }
          }
        }
      ]
    },
    "LogEntry": {
      "type": "object",
      "properties": {
        "eventId": {
          "type": "string"
        },
        "keptnContext": {
          "type": "string"
        },
        "keptnService": {
          "type": "string"
        },
        "logLevel": {
          "type": "string"
        },
        "message": {
          "type": "string"
        },
        "timestamp": {
          "type": "string",
          "format": "date-time"
        }
      }
    },
    "error": {
      "type": "object",
      "required": [
        "message"
      ],
      "properties": {
        "code": {
          "type": "integer",
          "format": "int64"
        },
        "fields": {
          "type": "string"
        },
        "message": {
          "type": "string"
        }
      }
    },
    "principal": {
      "type": "string"
    }
  },
  "parameters": {
    "pageParam": {
      "type": "string",
      "description": "Key of the page to be returned",
      "name": "nextPageKey",
      "in": "query"
    },
    "pagesizeParam": {
      "maximum": 100,
      "minimum": 1,
      "type": "integer",
      "default": 20,
      "description": "Page size to be returned",
      "name": "pageSize",
      "in": "query"
    }
  }
}`))
}
