// Code generated by go-swagger; DO NOT EDIT.

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"net/http"
	"strings"

	errors "github.com/go-openapi/errors"
	loads "github.com/go-openapi/loads"
	runtime "github.com/go-openapi/runtime"
	middleware "github.com/go-openapi/runtime/middleware"
	security "github.com/go-openapi/runtime/security"
	spec "github.com/go-openapi/spec"
	strfmt "github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/keptn/keptn/configuration-service/restapi/operations/project"
	"github.com/keptn/keptn/configuration-service/restapi/operations/project_resource"
	"github.com/keptn/keptn/configuration-service/restapi/operations/service"
	"github.com/keptn/keptn/configuration-service/restapi/operations/service_default_resource"
	"github.com/keptn/keptn/configuration-service/restapi/operations/service_resource"
	"github.com/keptn/keptn/configuration-service/restapi/operations/stage"
	"github.com/keptn/keptn/configuration-service/restapi/operations/stage_resource"
)

// NewConfigurationServiceAPI creates a new ConfigurationService instance
func NewConfigurationServiceAPI(spec *loads.Document) *ConfigurationServiceAPI {
	return &ConfigurationServiceAPI{
		handlers:            make(map[string]map[string]http.Handler),
		formats:             strfmt.Default,
		defaultConsumes:     "application/json",
		defaultProduces:     "application/json",
		customConsumers:     make(map[string]runtime.Consumer),
		customProducers:     make(map[string]runtime.Producer),
		ServerShutdown:      func() {},
		spec:                spec,
		ServeError:          errors.ServeError,
		BasicAuthenticator:  security.BasicAuth,
		APIKeyAuthenticator: security.APIKeyAuth,
		BearerAuthenticator: security.BearerAuth,
		JSONConsumer:        runtime.JSONConsumer(),
		JSONProducer:        runtime.JSONProducer(),
		ProjectDeleteProjectProjectNameHandler: project.DeleteProjectProjectNameHandlerFunc(func(params project.DeleteProjectProjectNameParams) middleware.Responder {
			return middleware.NotImplemented("operation ProjectDeleteProjectProjectName has not yet been implemented")
		}),
		ProjectResourceDeleteProjectProjectNameResourceResourceURIHandler: project_resource.DeleteProjectProjectNameResourceResourceURIHandlerFunc(func(params project_resource.DeleteProjectProjectNameResourceResourceURIParams) middleware.Responder {
			return middleware.NotImplemented("operation ProjectResourceDeleteProjectProjectNameResourceResourceURI has not yet been implemented")
		}),
		ServiceDefaultResourceDeleteProjectProjectNameServiceServiceNameResourceResourceURIHandler: service_default_resource.DeleteProjectProjectNameServiceServiceNameResourceResourceURIHandlerFunc(func(params service_default_resource.DeleteProjectProjectNameServiceServiceNameResourceResourceURIParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceDefaultResourceDeleteProjectProjectNameServiceServiceNameResourceResourceURI has not yet been implemented")
		}),
		StageDeleteProjectProjectNameStageStageNameHandler: stage.DeleteProjectProjectNameStageStageNameHandlerFunc(func(params stage.DeleteProjectProjectNameStageStageNameParams) middleware.Responder {
			return middleware.NotImplemented("operation StageDeleteProjectProjectNameStageStageName has not yet been implemented")
		}),
		StageResourceDeleteProjectProjectNameStageStageNameResourceResourceURIHandler: stage_resource.DeleteProjectProjectNameStageStageNameResourceResourceURIHandlerFunc(func(params stage_resource.DeleteProjectProjectNameStageStageNameResourceResourceURIParams) middleware.Responder {
			return middleware.NotImplemented("operation StageResourceDeleteProjectProjectNameStageStageNameResourceResourceURI has not yet been implemented")
		}),
		ServiceDeleteProjectProjectNameStageStageNameServiceServiceNameHandler: service.DeleteProjectProjectNameStageStageNameServiceServiceNameHandlerFunc(func(params service.DeleteProjectProjectNameStageStageNameServiceServiceNameParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceDeleteProjectProjectNameStageStageNameServiceServiceName has not yet been implemented")
		}),
		ServiceResourceDeleteProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler: service_resource.DeleteProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandlerFunc(func(params service_resource.DeleteProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceResourceDeleteProjectProjectNameStageStageNameServiceServiceNameResourceResourceURI has not yet been implemented")
		}),
		ProjectGetProjectHandler: project.GetProjectHandlerFunc(func(params project.GetProjectParams) middleware.Responder {
			return middleware.NotImplemented("operation ProjectGetProject has not yet been implemented")
		}),
		ProjectGetProjectProjectNameHandler: project.GetProjectProjectNameHandlerFunc(func(params project.GetProjectProjectNameParams) middleware.Responder {
			return middleware.NotImplemented("operation ProjectGetProjectProjectName has not yet been implemented")
		}),
		ProjectResourceGetProjectProjectNameResourceHandler: project_resource.GetProjectProjectNameResourceHandlerFunc(func(params project_resource.GetProjectProjectNameResourceParams) middleware.Responder {
			return middleware.NotImplemented("operation ProjectResourceGetProjectProjectNameResource has not yet been implemented")
		}),
		ProjectResourceGetProjectProjectNameResourceResourceURIHandler: project_resource.GetProjectProjectNameResourceResourceURIHandlerFunc(func(params project_resource.GetProjectProjectNameResourceResourceURIParams) middleware.Responder {
			return middleware.NotImplemented("operation ProjectResourceGetProjectProjectNameResourceResourceURI has not yet been implemented")
		}),
		ServiceDefaultResourceGetProjectProjectNameServiceServiceNameResourceHandler: service_default_resource.GetProjectProjectNameServiceServiceNameResourceHandlerFunc(func(params service_default_resource.GetProjectProjectNameServiceServiceNameResourceParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceDefaultResourceGetProjectProjectNameServiceServiceNameResource has not yet been implemented")
		}),
		ServiceDefaultResourceGetProjectProjectNameServiceServiceNameResourceResourceURIHandler: service_default_resource.GetProjectProjectNameServiceServiceNameResourceResourceURIHandlerFunc(func(params service_default_resource.GetProjectProjectNameServiceServiceNameResourceResourceURIParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceDefaultResourceGetProjectProjectNameServiceServiceNameResourceResourceURI has not yet been implemented")
		}),
		StageGetProjectProjectNameStageHandler: stage.GetProjectProjectNameStageHandlerFunc(func(params stage.GetProjectProjectNameStageParams) middleware.Responder {
			return middleware.NotImplemented("operation StageGetProjectProjectNameStage has not yet been implemented")
		}),
		StageGetProjectProjectNameStageStageNameHandler: stage.GetProjectProjectNameStageStageNameHandlerFunc(func(params stage.GetProjectProjectNameStageStageNameParams) middleware.Responder {
			return middleware.NotImplemented("operation StageGetProjectProjectNameStageStageName has not yet been implemented")
		}),
		StageResourceGetProjectProjectNameStageStageNameResourceHandler: stage_resource.GetProjectProjectNameStageStageNameResourceHandlerFunc(func(params stage_resource.GetProjectProjectNameStageStageNameResourceParams) middleware.Responder {
			return middleware.NotImplemented("operation StageResourceGetProjectProjectNameStageStageNameResource has not yet been implemented")
		}),
		StageResourceGetProjectProjectNameStageStageNameResourceResourceURIHandler: stage_resource.GetProjectProjectNameStageStageNameResourceResourceURIHandlerFunc(func(params stage_resource.GetProjectProjectNameStageStageNameResourceResourceURIParams) middleware.Responder {
			return middleware.NotImplemented("operation StageResourceGetProjectProjectNameStageStageNameResourceResourceURI has not yet been implemented")
		}),
		ServiceGetProjectProjectNameStageStageNameServiceHandler: service.GetProjectProjectNameStageStageNameServiceHandlerFunc(func(params service.GetProjectProjectNameStageStageNameServiceParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceGetProjectProjectNameStageStageNameService has not yet been implemented")
		}),
		ServiceGetProjectProjectNameStageStageNameServiceServiceNameHandler: service.GetProjectProjectNameStageStageNameServiceServiceNameHandlerFunc(func(params service.GetProjectProjectNameStageStageNameServiceServiceNameParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceGetProjectProjectNameStageStageNameServiceServiceName has not yet been implemented")
		}),
		ServiceResourceGetProjectProjectNameStageStageNameServiceServiceNameResourceHandler: service_resource.GetProjectProjectNameStageStageNameServiceServiceNameResourceHandlerFunc(func(params service_resource.GetProjectProjectNameStageStageNameServiceServiceNameResourceParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceResourceGetProjectProjectNameStageStageNameServiceServiceNameResource has not yet been implemented")
		}),
		ServiceResourceGetProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler: service_resource.GetProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandlerFunc(func(params service_resource.GetProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceResourceGetProjectProjectNameStageStageNameServiceServiceNameResourceResourceURI has not yet been implemented")
		}),
		ProjectPostProjectHandler: project.PostProjectHandlerFunc(func(params project.PostProjectParams) middleware.Responder {
			return middleware.NotImplemented("operation ProjectPostProject has not yet been implemented")
		}),
		ProjectResourcePostProjectProjectNameResourceHandler: project_resource.PostProjectProjectNameResourceHandlerFunc(func(params project_resource.PostProjectProjectNameResourceParams) middleware.Responder {
			return middleware.NotImplemented("operation ProjectResourcePostProjectProjectNameResource has not yet been implemented")
		}),
		ServiceDefaultResourcePostProjectProjectNameServiceServiceNameResourceHandler: service_default_resource.PostProjectProjectNameServiceServiceNameResourceHandlerFunc(func(params service_default_resource.PostProjectProjectNameServiceServiceNameResourceParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceDefaultResourcePostProjectProjectNameServiceServiceNameResource has not yet been implemented")
		}),
		StagePostProjectProjectNameStageHandler: stage.PostProjectProjectNameStageHandlerFunc(func(params stage.PostProjectProjectNameStageParams) middleware.Responder {
			return middleware.NotImplemented("operation StagePostProjectProjectNameStage has not yet been implemented")
		}),
		StageResourcePostProjectProjectNameStageStageNameResourceHandler: stage_resource.PostProjectProjectNameStageStageNameResourceHandlerFunc(func(params stage_resource.PostProjectProjectNameStageStageNameResourceParams) middleware.Responder {
			return middleware.NotImplemented("operation StageResourcePostProjectProjectNameStageStageNameResource has not yet been implemented")
		}),
		ServicePostProjectProjectNameStageStageNameServiceHandler: service.PostProjectProjectNameStageStageNameServiceHandlerFunc(func(params service.PostProjectProjectNameStageStageNameServiceParams) middleware.Responder {
			return middleware.NotImplemented("operation ServicePostProjectProjectNameStageStageNameService has not yet been implemented")
		}),
		ServiceResourcePostProjectProjectNameStageStageNameServiceServiceNameResourceHandler: service_resource.PostProjectProjectNameStageStageNameServiceServiceNameResourceHandlerFunc(func(params service_resource.PostProjectProjectNameStageStageNameServiceServiceNameResourceParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceResourcePostProjectProjectNameStageStageNameServiceServiceNameResource has not yet been implemented")
		}),
		ProjectPutProjectProjectNameHandler: project.PutProjectProjectNameHandlerFunc(func(params project.PutProjectProjectNameParams) middleware.Responder {
			return middleware.NotImplemented("operation ProjectPutProjectProjectName has not yet been implemented")
		}),
		ProjectResourcePutProjectProjectNameResourceHandler: project_resource.PutProjectProjectNameResourceHandlerFunc(func(params project_resource.PutProjectProjectNameResourceParams) middleware.Responder {
			return middleware.NotImplemented("operation ProjectResourcePutProjectProjectNameResource has not yet been implemented")
		}),
		ProjectResourcePutProjectProjectNameResourceResourceURIHandler: project_resource.PutProjectProjectNameResourceResourceURIHandlerFunc(func(params project_resource.PutProjectProjectNameResourceResourceURIParams) middleware.Responder {
			return middleware.NotImplemented("operation ProjectResourcePutProjectProjectNameResourceResourceURI has not yet been implemented")
		}),
		ServiceDefaultResourcePutProjectProjectNameServiceServiceNameResourceHandler: service_default_resource.PutProjectProjectNameServiceServiceNameResourceHandlerFunc(func(params service_default_resource.PutProjectProjectNameServiceServiceNameResourceParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceDefaultResourcePutProjectProjectNameServiceServiceNameResource has not yet been implemented")
		}),
		ServiceDefaultResourcePutProjectProjectNameServiceServiceNameResourceResourceURIHandler: service_default_resource.PutProjectProjectNameServiceServiceNameResourceResourceURIHandlerFunc(func(params service_default_resource.PutProjectProjectNameServiceServiceNameResourceResourceURIParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceDefaultResourcePutProjectProjectNameServiceServiceNameResourceResourceURI has not yet been implemented")
		}),
		StagePutProjectProjectNameStageStageNameHandler: stage.PutProjectProjectNameStageStageNameHandlerFunc(func(params stage.PutProjectProjectNameStageStageNameParams) middleware.Responder {
			return middleware.NotImplemented("operation StagePutProjectProjectNameStageStageName has not yet been implemented")
		}),
		StageResourcePutProjectProjectNameStageStageNameResourceHandler: stage_resource.PutProjectProjectNameStageStageNameResourceHandlerFunc(func(params stage_resource.PutProjectProjectNameStageStageNameResourceParams) middleware.Responder {
			return middleware.NotImplemented("operation StageResourcePutProjectProjectNameStageStageNameResource has not yet been implemented")
		}),
		StageResourcePutProjectProjectNameStageStageNameResourceResourceURIHandler: stage_resource.PutProjectProjectNameStageStageNameResourceResourceURIHandlerFunc(func(params stage_resource.PutProjectProjectNameStageStageNameResourceResourceURIParams) middleware.Responder {
			return middleware.NotImplemented("operation StageResourcePutProjectProjectNameStageStageNameResourceResourceURI has not yet been implemented")
		}),
		ServicePutProjectProjectNameStageStageNameServiceServiceNameHandler: service.PutProjectProjectNameStageStageNameServiceServiceNameHandlerFunc(func(params service.PutProjectProjectNameStageStageNameServiceServiceNameParams) middleware.Responder {
			return middleware.NotImplemented("operation ServicePutProjectProjectNameStageStageNameServiceServiceName has not yet been implemented")
		}),
		ServiceResourcePutProjectProjectNameStageStageNameServiceServiceNameResourceHandler: service_resource.PutProjectProjectNameStageStageNameServiceServiceNameResourceHandlerFunc(func(params service_resource.PutProjectProjectNameStageStageNameServiceServiceNameResourceParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceResourcePutProjectProjectNameStageStageNameServiceServiceNameResource has not yet been implemented")
		}),
		ServiceResourcePutProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler: service_resource.PutProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandlerFunc(func(params service_resource.PutProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIParams) middleware.Responder {
			return middleware.NotImplemented("operation ServiceResourcePutProjectProjectNameStageStageNameServiceServiceNameResourceResourceURI has not yet been implemented")
		}),
	}
}

/*ConfigurationServiceAPI the configuration service API */
type ConfigurationServiceAPI struct {
	spec            *loads.Document
	context         *middleware.Context
	handlers        map[string]map[string]http.Handler
	formats         strfmt.Registry
	customConsumers map[string]runtime.Consumer
	customProducers map[string]runtime.Producer
	defaultConsumes string
	defaultProduces string
	Middleware      func(middleware.Builder) http.Handler

	// BasicAuthenticator generates a runtime.Authenticator from the supplied basic auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	BasicAuthenticator func(security.UserPassAuthentication) runtime.Authenticator
	// APIKeyAuthenticator generates a runtime.Authenticator from the supplied token auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	APIKeyAuthenticator func(string, string, security.TokenAuthentication) runtime.Authenticator
	// BearerAuthenticator generates a runtime.Authenticator from the supplied bearer token auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	BearerAuthenticator func(string, security.ScopedTokenAuthentication) runtime.Authenticator

	// JSONConsumer registers a consumer for a "application/json" mime type
	JSONConsumer runtime.Consumer

	// JSONProducer registers a producer for a "application/json" mime type
	JSONProducer runtime.Producer

	// ProjectDeleteProjectProjectNameHandler sets the operation handler for the delete project project name operation
	ProjectDeleteProjectProjectNameHandler project.DeleteProjectProjectNameHandler
	// ProjectResourceDeleteProjectProjectNameResourceResourceURIHandler sets the operation handler for the delete project project name resource resource URI operation
	ProjectResourceDeleteProjectProjectNameResourceResourceURIHandler project_resource.DeleteProjectProjectNameResourceResourceURIHandler
	// ServiceDefaultResourceDeleteProjectProjectNameServiceServiceNameResourceResourceURIHandler sets the operation handler for the delete project project name service service name resource resource URI operation
	ServiceDefaultResourceDeleteProjectProjectNameServiceServiceNameResourceResourceURIHandler service_default_resource.DeleteProjectProjectNameServiceServiceNameResourceResourceURIHandler
	// StageDeleteProjectProjectNameStageStageNameHandler sets the operation handler for the delete project project name stage stage name operation
	StageDeleteProjectProjectNameStageStageNameHandler stage.DeleteProjectProjectNameStageStageNameHandler
	// StageResourceDeleteProjectProjectNameStageStageNameResourceResourceURIHandler sets the operation handler for the delete project project name stage stage name resource resource URI operation
	StageResourceDeleteProjectProjectNameStageStageNameResourceResourceURIHandler stage_resource.DeleteProjectProjectNameStageStageNameResourceResourceURIHandler
	// ServiceDeleteProjectProjectNameStageStageNameServiceServiceNameHandler sets the operation handler for the delete project project name stage stage name service service name operation
	ServiceDeleteProjectProjectNameStageStageNameServiceServiceNameHandler service.DeleteProjectProjectNameStageStageNameServiceServiceNameHandler
	// ServiceResourceDeleteProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler sets the operation handler for the delete project project name stage stage name service service name resource resource URI operation
	ServiceResourceDeleteProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler service_resource.DeleteProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler
	// ProjectGetProjectHandler sets the operation handler for the get project operation
	ProjectGetProjectHandler project.GetProjectHandler
	// ProjectGetProjectProjectNameHandler sets the operation handler for the get project project name operation
	ProjectGetProjectProjectNameHandler project.GetProjectProjectNameHandler
	// ProjectResourceGetProjectProjectNameResourceHandler sets the operation handler for the get project project name resource operation
	ProjectResourceGetProjectProjectNameResourceHandler project_resource.GetProjectProjectNameResourceHandler
	// ProjectResourceGetProjectProjectNameResourceResourceURIHandler sets the operation handler for the get project project name resource resource URI operation
	ProjectResourceGetProjectProjectNameResourceResourceURIHandler project_resource.GetProjectProjectNameResourceResourceURIHandler
	// ServiceDefaultResourceGetProjectProjectNameServiceServiceNameResourceHandler sets the operation handler for the get project project name service service name resource operation
	ServiceDefaultResourceGetProjectProjectNameServiceServiceNameResourceHandler service_default_resource.GetProjectProjectNameServiceServiceNameResourceHandler
	// ServiceDefaultResourceGetProjectProjectNameServiceServiceNameResourceResourceURIHandler sets the operation handler for the get project project name service service name resource resource URI operation
	ServiceDefaultResourceGetProjectProjectNameServiceServiceNameResourceResourceURIHandler service_default_resource.GetProjectProjectNameServiceServiceNameResourceResourceURIHandler
	// StageGetProjectProjectNameStageHandler sets the operation handler for the get project project name stage operation
	StageGetProjectProjectNameStageHandler stage.GetProjectProjectNameStageHandler
	// StageGetProjectProjectNameStageStageNameHandler sets the operation handler for the get project project name stage stage name operation
	StageGetProjectProjectNameStageStageNameHandler stage.GetProjectProjectNameStageStageNameHandler
	// StageResourceGetProjectProjectNameStageStageNameResourceHandler sets the operation handler for the get project project name stage stage name resource operation
	StageResourceGetProjectProjectNameStageStageNameResourceHandler stage_resource.GetProjectProjectNameStageStageNameResourceHandler
	// StageResourceGetProjectProjectNameStageStageNameResourceResourceURIHandler sets the operation handler for the get project project name stage stage name resource resource URI operation
	StageResourceGetProjectProjectNameStageStageNameResourceResourceURIHandler stage_resource.GetProjectProjectNameStageStageNameResourceResourceURIHandler
	// ServiceGetProjectProjectNameStageStageNameServiceHandler sets the operation handler for the get project project name stage stage name service operation
	ServiceGetProjectProjectNameStageStageNameServiceHandler service.GetProjectProjectNameStageStageNameServiceHandler
	// ServiceGetProjectProjectNameStageStageNameServiceServiceNameHandler sets the operation handler for the get project project name stage stage name service service name operation
	ServiceGetProjectProjectNameStageStageNameServiceServiceNameHandler service.GetProjectProjectNameStageStageNameServiceServiceNameHandler
	// ServiceResourceGetProjectProjectNameStageStageNameServiceServiceNameResourceHandler sets the operation handler for the get project project name stage stage name service service name resource operation
	ServiceResourceGetProjectProjectNameStageStageNameServiceServiceNameResourceHandler service_resource.GetProjectProjectNameStageStageNameServiceServiceNameResourceHandler
	// ServiceResourceGetProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler sets the operation handler for the get project project name stage stage name service service name resource resource URI operation
	ServiceResourceGetProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler service_resource.GetProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler
	// ProjectPostProjectHandler sets the operation handler for the post project operation
	ProjectPostProjectHandler project.PostProjectHandler
	// ProjectResourcePostProjectProjectNameResourceHandler sets the operation handler for the post project project name resource operation
	ProjectResourcePostProjectProjectNameResourceHandler project_resource.PostProjectProjectNameResourceHandler
	// ServiceDefaultResourcePostProjectProjectNameServiceServiceNameResourceHandler sets the operation handler for the post project project name service service name resource operation
	ServiceDefaultResourcePostProjectProjectNameServiceServiceNameResourceHandler service_default_resource.PostProjectProjectNameServiceServiceNameResourceHandler
	// StagePostProjectProjectNameStageHandler sets the operation handler for the post project project name stage operation
	StagePostProjectProjectNameStageHandler stage.PostProjectProjectNameStageHandler
	// StageResourcePostProjectProjectNameStageStageNameResourceHandler sets the operation handler for the post project project name stage stage name resource operation
	StageResourcePostProjectProjectNameStageStageNameResourceHandler stage_resource.PostProjectProjectNameStageStageNameResourceHandler
	// ServicePostProjectProjectNameStageStageNameServiceHandler sets the operation handler for the post project project name stage stage name service operation
	ServicePostProjectProjectNameStageStageNameServiceHandler service.PostProjectProjectNameStageStageNameServiceHandler
	// ServiceResourcePostProjectProjectNameStageStageNameServiceServiceNameResourceHandler sets the operation handler for the post project project name stage stage name service service name resource operation
	ServiceResourcePostProjectProjectNameStageStageNameServiceServiceNameResourceHandler service_resource.PostProjectProjectNameStageStageNameServiceServiceNameResourceHandler
	// ProjectPutProjectProjectNameHandler sets the operation handler for the put project project name operation
	ProjectPutProjectProjectNameHandler project.PutProjectProjectNameHandler
	// ProjectResourcePutProjectProjectNameResourceHandler sets the operation handler for the put project project name resource operation
	ProjectResourcePutProjectProjectNameResourceHandler project_resource.PutProjectProjectNameResourceHandler
	// ProjectResourcePutProjectProjectNameResourceResourceURIHandler sets the operation handler for the put project project name resource resource URI operation
	ProjectResourcePutProjectProjectNameResourceResourceURIHandler project_resource.PutProjectProjectNameResourceResourceURIHandler
	// ServiceDefaultResourcePutProjectProjectNameServiceServiceNameResourceHandler sets the operation handler for the put project project name service service name resource operation
	ServiceDefaultResourcePutProjectProjectNameServiceServiceNameResourceHandler service_default_resource.PutProjectProjectNameServiceServiceNameResourceHandler
	// ServiceDefaultResourcePutProjectProjectNameServiceServiceNameResourceResourceURIHandler sets the operation handler for the put project project name service service name resource resource URI operation
	ServiceDefaultResourcePutProjectProjectNameServiceServiceNameResourceResourceURIHandler service_default_resource.PutProjectProjectNameServiceServiceNameResourceResourceURIHandler
	// StagePutProjectProjectNameStageStageNameHandler sets the operation handler for the put project project name stage stage name operation
	StagePutProjectProjectNameStageStageNameHandler stage.PutProjectProjectNameStageStageNameHandler
	// StageResourcePutProjectProjectNameStageStageNameResourceHandler sets the operation handler for the put project project name stage stage name resource operation
	StageResourcePutProjectProjectNameStageStageNameResourceHandler stage_resource.PutProjectProjectNameStageStageNameResourceHandler
	// StageResourcePutProjectProjectNameStageStageNameResourceResourceURIHandler sets the operation handler for the put project project name stage stage name resource resource URI operation
	StageResourcePutProjectProjectNameStageStageNameResourceResourceURIHandler stage_resource.PutProjectProjectNameStageStageNameResourceResourceURIHandler
	// ServicePutProjectProjectNameStageStageNameServiceServiceNameHandler sets the operation handler for the put project project name stage stage name service service name operation
	ServicePutProjectProjectNameStageStageNameServiceServiceNameHandler service.PutProjectProjectNameStageStageNameServiceServiceNameHandler
	// ServiceResourcePutProjectProjectNameStageStageNameServiceServiceNameResourceHandler sets the operation handler for the put project project name stage stage name service service name resource operation
	ServiceResourcePutProjectProjectNameStageStageNameServiceServiceNameResourceHandler service_resource.PutProjectProjectNameStageStageNameServiceServiceNameResourceHandler
	// ServiceResourcePutProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler sets the operation handler for the put project project name stage stage name service service name resource resource URI operation
	ServiceResourcePutProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler service_resource.PutProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler

	// ServeError is called when an error is received, there is a default handler
	// but you can set your own with this
	ServeError func(http.ResponseWriter, *http.Request, error)

	// ServerShutdown is called when the HTTP(S) server is shut down and done
	// handling all active connections and does not accept connections any more
	ServerShutdown func()

	// Custom command line argument groups with their descriptions
	CommandLineOptionsGroups []swag.CommandLineOptionsGroup

	// User defined logger function.
	Logger func(string, ...interface{})
}

// SetDefaultProduces sets the default produces media type
func (o *ConfigurationServiceAPI) SetDefaultProduces(mediaType string) {
	o.defaultProduces = mediaType
}

// SetDefaultConsumes returns the default consumes media type
func (o *ConfigurationServiceAPI) SetDefaultConsumes(mediaType string) {
	o.defaultConsumes = mediaType
}

// SetSpec sets a spec that will be served for the clients.
func (o *ConfigurationServiceAPI) SetSpec(spec *loads.Document) {
	o.spec = spec
}

// DefaultProduces returns the default produces media type
func (o *ConfigurationServiceAPI) DefaultProduces() string {
	return o.defaultProduces
}

// DefaultConsumes returns the default consumes media type
func (o *ConfigurationServiceAPI) DefaultConsumes() string {
	return o.defaultConsumes
}

// Formats returns the registered string formats
func (o *ConfigurationServiceAPI) Formats() strfmt.Registry {
	return o.formats
}

// RegisterFormat registers a custom format validator
func (o *ConfigurationServiceAPI) RegisterFormat(name string, format strfmt.Format, validator strfmt.Validator) {
	o.formats.Add(name, format, validator)
}

// Validate validates the registrations in the ConfigurationServiceAPI
func (o *ConfigurationServiceAPI) Validate() error {
	var unregistered []string

	if o.JSONConsumer == nil {
		unregistered = append(unregistered, "JSONConsumer")
	}

	if o.JSONProducer == nil {
		unregistered = append(unregistered, "JSONProducer")
	}

	if o.ProjectDeleteProjectProjectNameHandler == nil {
		unregistered = append(unregistered, "project.DeleteProjectProjectNameHandler")
	}

	if o.ProjectResourceDeleteProjectProjectNameResourceResourceURIHandler == nil {
		unregistered = append(unregistered, "project_resource.DeleteProjectProjectNameResourceResourceURIHandler")
	}

	if o.ServiceDefaultResourceDeleteProjectProjectNameServiceServiceNameResourceResourceURIHandler == nil {
		unregistered = append(unregistered, "service_default_resource.DeleteProjectProjectNameServiceServiceNameResourceResourceURIHandler")
	}

	if o.StageDeleteProjectProjectNameStageStageNameHandler == nil {
		unregistered = append(unregistered, "stage.DeleteProjectProjectNameStageStageNameHandler")
	}

	if o.StageResourceDeleteProjectProjectNameStageStageNameResourceResourceURIHandler == nil {
		unregistered = append(unregistered, "stage_resource.DeleteProjectProjectNameStageStageNameResourceResourceURIHandler")
	}

	if o.ServiceDeleteProjectProjectNameStageStageNameServiceServiceNameHandler == nil {
		unregistered = append(unregistered, "service.DeleteProjectProjectNameStageStageNameServiceServiceNameHandler")
	}

	if o.ServiceResourceDeleteProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler == nil {
		unregistered = append(unregistered, "service_resource.DeleteProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler")
	}

	if o.ProjectGetProjectHandler == nil {
		unregistered = append(unregistered, "project.GetProjectHandler")
	}

	if o.ProjectGetProjectProjectNameHandler == nil {
		unregistered = append(unregistered, "project.GetProjectProjectNameHandler")
	}

	if o.ProjectResourceGetProjectProjectNameResourceHandler == nil {
		unregistered = append(unregistered, "project_resource.GetProjectProjectNameResourceHandler")
	}

	if o.ProjectResourceGetProjectProjectNameResourceResourceURIHandler == nil {
		unregistered = append(unregistered, "project_resource.GetProjectProjectNameResourceResourceURIHandler")
	}

	if o.ServiceDefaultResourceGetProjectProjectNameServiceServiceNameResourceHandler == nil {
		unregistered = append(unregistered, "service_default_resource.GetProjectProjectNameServiceServiceNameResourceHandler")
	}

	if o.ServiceDefaultResourceGetProjectProjectNameServiceServiceNameResourceResourceURIHandler == nil {
		unregistered = append(unregistered, "service_default_resource.GetProjectProjectNameServiceServiceNameResourceResourceURIHandler")
	}

	if o.StageGetProjectProjectNameStageHandler == nil {
		unregistered = append(unregistered, "stage.GetProjectProjectNameStageHandler")
	}

	if o.StageGetProjectProjectNameStageStageNameHandler == nil {
		unregistered = append(unregistered, "stage.GetProjectProjectNameStageStageNameHandler")
	}

	if o.StageResourceGetProjectProjectNameStageStageNameResourceHandler == nil {
		unregistered = append(unregistered, "stage_resource.GetProjectProjectNameStageStageNameResourceHandler")
	}

	if o.StageResourceGetProjectProjectNameStageStageNameResourceResourceURIHandler == nil {
		unregistered = append(unregistered, "stage_resource.GetProjectProjectNameStageStageNameResourceResourceURIHandler")
	}

	if o.ServiceGetProjectProjectNameStageStageNameServiceHandler == nil {
		unregistered = append(unregistered, "service.GetProjectProjectNameStageStageNameServiceHandler")
	}

	if o.ServiceGetProjectProjectNameStageStageNameServiceServiceNameHandler == nil {
		unregistered = append(unregistered, "service.GetProjectProjectNameStageStageNameServiceServiceNameHandler")
	}

	if o.ServiceResourceGetProjectProjectNameStageStageNameServiceServiceNameResourceHandler == nil {
		unregistered = append(unregistered, "service_resource.GetProjectProjectNameStageStageNameServiceServiceNameResourceHandler")
	}

	if o.ServiceResourceGetProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler == nil {
		unregistered = append(unregistered, "service_resource.GetProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler")
	}

	if o.ProjectPostProjectHandler == nil {
		unregistered = append(unregistered, "project.PostProjectHandler")
	}

	if o.ProjectResourcePostProjectProjectNameResourceHandler == nil {
		unregistered = append(unregistered, "project_resource.PostProjectProjectNameResourceHandler")
	}

	if o.ServiceDefaultResourcePostProjectProjectNameServiceServiceNameResourceHandler == nil {
		unregistered = append(unregistered, "service_default_resource.PostProjectProjectNameServiceServiceNameResourceHandler")
	}

	if o.StagePostProjectProjectNameStageHandler == nil {
		unregistered = append(unregistered, "stage.PostProjectProjectNameStageHandler")
	}

	if o.StageResourcePostProjectProjectNameStageStageNameResourceHandler == nil {
		unregistered = append(unregistered, "stage_resource.PostProjectProjectNameStageStageNameResourceHandler")
	}

	if o.ServicePostProjectProjectNameStageStageNameServiceHandler == nil {
		unregistered = append(unregistered, "service.PostProjectProjectNameStageStageNameServiceHandler")
	}

	if o.ServiceResourcePostProjectProjectNameStageStageNameServiceServiceNameResourceHandler == nil {
		unregistered = append(unregistered, "service_resource.PostProjectProjectNameStageStageNameServiceServiceNameResourceHandler")
	}

	if o.ProjectPutProjectProjectNameHandler == nil {
		unregistered = append(unregistered, "project.PutProjectProjectNameHandler")
	}

	if o.ProjectResourcePutProjectProjectNameResourceHandler == nil {
		unregistered = append(unregistered, "project_resource.PutProjectProjectNameResourceHandler")
	}

	if o.ProjectResourcePutProjectProjectNameResourceResourceURIHandler == nil {
		unregistered = append(unregistered, "project_resource.PutProjectProjectNameResourceResourceURIHandler")
	}

	if o.ServiceDefaultResourcePutProjectProjectNameServiceServiceNameResourceHandler == nil {
		unregistered = append(unregistered, "service_default_resource.PutProjectProjectNameServiceServiceNameResourceHandler")
	}

	if o.ServiceDefaultResourcePutProjectProjectNameServiceServiceNameResourceResourceURIHandler == nil {
		unregistered = append(unregistered, "service_default_resource.PutProjectProjectNameServiceServiceNameResourceResourceURIHandler")
	}

	if o.StagePutProjectProjectNameStageStageNameHandler == nil {
		unregistered = append(unregistered, "stage.PutProjectProjectNameStageStageNameHandler")
	}

	if o.StageResourcePutProjectProjectNameStageStageNameResourceHandler == nil {
		unregistered = append(unregistered, "stage_resource.PutProjectProjectNameStageStageNameResourceHandler")
	}

	if o.StageResourcePutProjectProjectNameStageStageNameResourceResourceURIHandler == nil {
		unregistered = append(unregistered, "stage_resource.PutProjectProjectNameStageStageNameResourceResourceURIHandler")
	}

	if o.ServicePutProjectProjectNameStageStageNameServiceServiceNameHandler == nil {
		unregistered = append(unregistered, "service.PutProjectProjectNameStageStageNameServiceServiceNameHandler")
	}

	if o.ServiceResourcePutProjectProjectNameStageStageNameServiceServiceNameResourceHandler == nil {
		unregistered = append(unregistered, "service_resource.PutProjectProjectNameStageStageNameServiceServiceNameResourceHandler")
	}

	if o.ServiceResourcePutProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler == nil {
		unregistered = append(unregistered, "service_resource.PutProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler")
	}

	if len(unregistered) > 0 {
		return fmt.Errorf("missing registration: %s", strings.Join(unregistered, ", "))
	}

	return nil
}

// ServeErrorFor gets a error handler for a given operation id
func (o *ConfigurationServiceAPI) ServeErrorFor(operationID string) func(http.ResponseWriter, *http.Request, error) {
	return o.ServeError
}

// AuthenticatorsFor gets the authenticators for the specified security schemes
func (o *ConfigurationServiceAPI) AuthenticatorsFor(schemes map[string]spec.SecurityScheme) map[string]runtime.Authenticator {

	return nil

}

// Authorizer returns the registered authorizer
func (o *ConfigurationServiceAPI) Authorizer() runtime.Authorizer {

	return nil

}

// ConsumersFor gets the consumers for the specified media types
func (o *ConfigurationServiceAPI) ConsumersFor(mediaTypes []string) map[string]runtime.Consumer {

	result := make(map[string]runtime.Consumer)
	for _, mt := range mediaTypes {
		switch mt {

		case "application/json":
			result["application/json"] = o.JSONConsumer

		}

		if c, ok := o.customConsumers[mt]; ok {
			result[mt] = c
		}
	}
	return result

}

// ProducersFor gets the producers for the specified media types
func (o *ConfigurationServiceAPI) ProducersFor(mediaTypes []string) map[string]runtime.Producer {

	result := make(map[string]runtime.Producer)
	for _, mt := range mediaTypes {
		switch mt {

		case "application/json":
			result["application/json"] = o.JSONProducer

		}

		if p, ok := o.customProducers[mt]; ok {
			result[mt] = p
		}
	}
	return result

}

// HandlerFor gets a http.Handler for the provided operation method and path
func (o *ConfigurationServiceAPI) HandlerFor(method, path string) (http.Handler, bool) {
	if o.handlers == nil {
		return nil, false
	}
	um := strings.ToUpper(method)
	if _, ok := o.handlers[um]; !ok {
		return nil, false
	}
	if path == "/" {
		path = ""
	}
	h, ok := o.handlers[um][path]
	return h, ok
}

// Context returns the middleware context for the configuration service API
func (o *ConfigurationServiceAPI) Context() *middleware.Context {
	if o.context == nil {
		o.context = middleware.NewRoutableContext(o.spec, o, nil)
	}

	return o.context
}

func (o *ConfigurationServiceAPI) initHandlerCache() {
	o.Context() // don't care about the result, just that the initialization happened

	if o.handlers == nil {
		o.handlers = make(map[string]map[string]http.Handler)
	}

	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/project/{projectName}"] = project.NewDeleteProjectProjectName(o.context, o.ProjectDeleteProjectProjectNameHandler)

	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/project/{projectName}/resource/{resourceURI}"] = project_resource.NewDeleteProjectProjectNameResourceResourceURI(o.context, o.ProjectResourceDeleteProjectProjectNameResourceResourceURIHandler)

	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/project/{projectName}/service/{serviceName}/resource/{resourceURI}"] = service_default_resource.NewDeleteProjectProjectNameServiceServiceNameResourceResourceURI(o.context, o.ServiceDefaultResourceDeleteProjectProjectNameServiceServiceNameResourceResourceURIHandler)

	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/project/{projectName}/stage/{stageName}"] = stage.NewDeleteProjectProjectNameStageStageName(o.context, o.StageDeleteProjectProjectNameStageStageNameHandler)

	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/project/{projectName}/stage/{stageName}/resource/{resourceURI}"] = stage_resource.NewDeleteProjectProjectNameStageStageNameResourceResourceURI(o.context, o.StageResourceDeleteProjectProjectNameStageStageNameResourceResourceURIHandler)

	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/project/{projectName}/stage/{stageName}/service/{serviceName}"] = service.NewDeleteProjectProjectNameStageStageNameServiceServiceName(o.context, o.ServiceDeleteProjectProjectNameStageStageNameServiceServiceNameHandler)

	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/project/{projectName}/stage/{stageName}/service/{serviceName}/resource/{resourceURI}"] = service_resource.NewDeleteProjectProjectNameStageStageNameServiceServiceNameResourceResourceURI(o.context, o.ServiceResourceDeleteProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project"] = project.NewGetProject(o.context, o.ProjectGetProjectHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project/{projectName}"] = project.NewGetProjectProjectName(o.context, o.ProjectGetProjectProjectNameHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project/{projectName}/resource"] = project_resource.NewGetProjectProjectNameResource(o.context, o.ProjectResourceGetProjectProjectNameResourceHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project/{projectName}/resource/{resourceURI}"] = project_resource.NewGetProjectProjectNameResourceResourceURI(o.context, o.ProjectResourceGetProjectProjectNameResourceResourceURIHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project/{projectName}/service/{serviceName}/resource"] = service_default_resource.NewGetProjectProjectNameServiceServiceNameResource(o.context, o.ServiceDefaultResourceGetProjectProjectNameServiceServiceNameResourceHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project/{projectName}/service/{serviceName}/resource/{resourceURI}"] = service_default_resource.NewGetProjectProjectNameServiceServiceNameResourceResourceURI(o.context, o.ServiceDefaultResourceGetProjectProjectNameServiceServiceNameResourceResourceURIHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project/{projectName}/stage"] = stage.NewGetProjectProjectNameStage(o.context, o.StageGetProjectProjectNameStageHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project/{projectName}/stage/{stageName}"] = stage.NewGetProjectProjectNameStageStageName(o.context, o.StageGetProjectProjectNameStageStageNameHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project/{projectName}/stage/{stageName}/resource"] = stage_resource.NewGetProjectProjectNameStageStageNameResource(o.context, o.StageResourceGetProjectProjectNameStageStageNameResourceHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project/{projectName}/stage/{stageName}/resource/{resourceURI}"] = stage_resource.NewGetProjectProjectNameStageStageNameResourceResourceURI(o.context, o.StageResourceGetProjectProjectNameStageStageNameResourceResourceURIHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project/{projectName}/stage/{stageName}/service"] = service.NewGetProjectProjectNameStageStageNameService(o.context, o.ServiceGetProjectProjectNameStageStageNameServiceHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project/{projectName}/stage/{stageName}/service/{serviceName}"] = service.NewGetProjectProjectNameStageStageNameServiceServiceName(o.context, o.ServiceGetProjectProjectNameStageStageNameServiceServiceNameHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project/{projectName}/stage/{stageName}/service/{serviceName}/resource"] = service_resource.NewGetProjectProjectNameStageStageNameServiceServiceNameResource(o.context, o.ServiceResourceGetProjectProjectNameStageStageNameServiceServiceNameResourceHandler)

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/project/{projectName}/stage/{stageName}/service/{serviceName}/resource/{resourceURI}"] = service_resource.NewGetProjectProjectNameStageStageNameServiceServiceNameResourceResourceURI(o.context, o.ServiceResourceGetProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler)

	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/project"] = project.NewPostProject(o.context, o.ProjectPostProjectHandler)

	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/project/{projectName}/resource"] = project_resource.NewPostProjectProjectNameResource(o.context, o.ProjectResourcePostProjectProjectNameResourceHandler)

	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/project/{projectName}/service/{serviceName}/resource"] = service_default_resource.NewPostProjectProjectNameServiceServiceNameResource(o.context, o.ServiceDefaultResourcePostProjectProjectNameServiceServiceNameResourceHandler)

	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/project/{projectName}/stage"] = stage.NewPostProjectProjectNameStage(o.context, o.StagePostProjectProjectNameStageHandler)

	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/project/{projectName}/stage/{stageName}/resource"] = stage_resource.NewPostProjectProjectNameStageStageNameResource(o.context, o.StageResourcePostProjectProjectNameStageStageNameResourceHandler)

	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/project/{projectName}/stage/{stageName}/service"] = service.NewPostProjectProjectNameStageStageNameService(o.context, o.ServicePostProjectProjectNameStageStageNameServiceHandler)

	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/project/{projectName}/stage/{stageName}/service/{serviceName}/resource"] = service_resource.NewPostProjectProjectNameStageStageNameServiceServiceNameResource(o.context, o.ServiceResourcePostProjectProjectNameStageStageNameServiceServiceNameResourceHandler)

	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/project/{projectName}"] = project.NewPutProjectProjectName(o.context, o.ProjectPutProjectProjectNameHandler)

	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/project/{projectName}/resource"] = project_resource.NewPutProjectProjectNameResource(o.context, o.ProjectResourcePutProjectProjectNameResourceHandler)

	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/project/{projectName}/resource/{resourceURI}"] = project_resource.NewPutProjectProjectNameResourceResourceURI(o.context, o.ProjectResourcePutProjectProjectNameResourceResourceURIHandler)

	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/project/{projectName}/service/{serviceName}/resource"] = service_default_resource.NewPutProjectProjectNameServiceServiceNameResource(o.context, o.ServiceDefaultResourcePutProjectProjectNameServiceServiceNameResourceHandler)

	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/project/{projectName}/service/{serviceName}/resource/{resourceURI}"] = service_default_resource.NewPutProjectProjectNameServiceServiceNameResourceResourceURI(o.context, o.ServiceDefaultResourcePutProjectProjectNameServiceServiceNameResourceResourceURIHandler)

	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/project/{projectName}/stage/{stageName}"] = stage.NewPutProjectProjectNameStageStageName(o.context, o.StagePutProjectProjectNameStageStageNameHandler)

	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/project/{projectName}/stage/{stageName}/resource"] = stage_resource.NewPutProjectProjectNameStageStageNameResource(o.context, o.StageResourcePutProjectProjectNameStageStageNameResourceHandler)

	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/project/{projectName}/stage/{stageName}/resource/{resourceURI}"] = stage_resource.NewPutProjectProjectNameStageStageNameResourceResourceURI(o.context, o.StageResourcePutProjectProjectNameStageStageNameResourceResourceURIHandler)

	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/project/{projectName}/stage/{stageName}/service/{serviceName}"] = service.NewPutProjectProjectNameStageStageNameServiceServiceName(o.context, o.ServicePutProjectProjectNameStageStageNameServiceServiceNameHandler)

	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/project/{projectName}/stage/{stageName}/service/{serviceName}/resource"] = service_resource.NewPutProjectProjectNameStageStageNameServiceServiceNameResource(o.context, o.ServiceResourcePutProjectProjectNameStageStageNameServiceServiceNameResourceHandler)

	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/project/{projectName}/stage/{stageName}/service/{serviceName}/resource/{resourceURI}"] = service_resource.NewPutProjectProjectNameStageStageNameServiceServiceNameResourceResourceURI(o.context, o.ServiceResourcePutProjectProjectNameStageStageNameServiceServiceNameResourceResourceURIHandler)

}

// Serve creates a http handler to serve the API over HTTP
// can be used directly in http.ListenAndServe(":8000", api.Serve(nil))
func (o *ConfigurationServiceAPI) Serve(builder middleware.Builder) http.Handler {
	o.Init()

	if o.Middleware != nil {
		return o.Middleware(builder)
	}
	return o.context.APIHandler(builder)
}

// Init allows you to just initialize the handler cache, you can then recompose the middleware as you see fit
func (o *ConfigurationServiceAPI) Init() {
	if len(o.handlers) == 0 {
		o.initHandlerCache()
	}
}

// RegisterConsumer allows you to add (or override) a consumer for a media type.
func (o *ConfigurationServiceAPI) RegisterConsumer(mediaType string, consumer runtime.Consumer) {
	o.customConsumers[mediaType] = consumer
}

// RegisterProducer allows you to add (or override) a producer for a media type.
func (o *ConfigurationServiceAPI) RegisterProducer(mediaType string, producer runtime.Producer) {
	o.customProducers[mediaType] = producer
}
