// Code generated by go-swagger; DO NOT EDIT.

package restapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

var (
	// SwaggerJSON embedded version of the swagger document used at generation time
	SwaggerJSON json.RawMessage
	// FlatSwaggerJSON embedded flattened version of the swagger document used at generation time
	FlatSwaggerJSON json.RawMessage
)

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http"
  ],
  "swagger": "2.0",
  "info": {
    "title": "Configuration Service API",
    "version": "0.1.0"
  },
  "basePath": "/v1",
  "paths": {
    "/project": {
      "get": {
        "tags": [
          "Project"
        ],
        "summary": "Get list of projects",
        "parameters": [
          {
            "$ref": "#/parameters/pageSize"
          },
          {
            "$ref": "#/parameters/nextPageKey"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Projects"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Project"
        ],
        "summary": "Create a new project by project name",
        "parameters": [
          {
            "$ref": "#/parameters/project"
          }
        ],
        "responses": {
          "204": {
            "description": "Success. Project has been created. Response does not have a body."
          },
          "400": {
            "description": "Failed. Project could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/project/{projectName}": {
      "get": {
        "tags": [
          "Project"
        ],
        "summary": "Get the specified project",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Project"
            }
          },
          "404": {
            "description": "Failed. Project could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Project"
        ],
        "summary": "Update the specified project",
        "parameters": [
          {
            "$ref": "#/parameters/project"
          }
        ],
        "responses": {
          "204": {
            "description": "Success. Project has been updated. Response does not have a body."
          },
          "400": {
            "description": "Failed. Project could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Project"
        ],
        "summary": "Delete the specified project",
        "responses": {
          "204": {
            "description": "Success. Project has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Project could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        }
      ]
    },
    "/project/{projectName}/resource": {
      "get": {
        "tags": [
          "Project Resource"
        ],
        "summary": "Get list of project resources",
        "parameters": [
          {
            "$ref": "#/parameters/pageSize"
          },
          {
            "$ref": "#/parameters/nextPageKey"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resources"
            }
          },
          "404": {
            "description": "Failed. Containing project could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Project Resource"
        ],
        "summary": "Update list of project resources",
        "parameters": [
          {
            "$ref": "#/parameters/resources"
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Project resources have been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Project resources could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Project Resource"
        ],
        "summary": "Create list of new resources for the project",
        "parameters": [
          {
            "$ref": "#/parameters/resources"
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Project resource has been created. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Project resource could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        }
      ]
    },
    "/project/{projectName}/resource/{resourceURI}": {
      "get": {
        "tags": [
          "Project Resource"
        ],
        "summary": "Get the specified resource",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resource"
            }
          },
          "404": {
            "description": "Failed. Project resource could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Project Resource"
        ],
        "summary": "Update the specified resource",
        "parameters": [
          {
            "$ref": "#/parameters/resource"
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Project resource has been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Project resource could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Project Resource"
        ],
        "summary": "Delete the specified resource",
        "responses": {
          "204": {
            "description": "Success. Project resource has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Project resource could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        },
        {
          "$ref": "#/parameters/resourceURI"
        }
      ]
    },
    "/project/{projectName}/service/{serviceName}/resource": {
      "get": {
        "tags": [
          "Service Default Resource"
        ],
        "summary": "Get list of default resources for the service used in all stages",
        "parameters": [
          {
            "$ref": "#/parameters/pageSize"
          },
          {
            "$ref": "#/parameters/nextPageKey"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resources"
            }
          },
          "404": {
            "description": "Failed. Containing service could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Service Default Resource"
        ],
        "summary": "Update list of service default resources",
        "parameters": [
          {
            "$ref": "#/parameters/resources"
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service default resources have been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service default resources could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Service Default Resource"
        ],
        "summary": "Create list of default resources for the service used in all stages",
        "parameters": [
          {
            "$ref": "#/parameters/resources"
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service default resource has been created. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service default resource could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        },
        {
          "$ref": "#/parameters/serviceName"
        }
      ]
    },
    "/project/{projectName}/service/{serviceName}/resource/{resourceURI}": {
      "get": {
        "tags": [
          "Service Default Resource"
        ],
        "summary": "Get the specified default resource for the service",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resource"
            }
          },
          "404": {
            "description": "Failed. Default resource could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Service Default Resource"
        ],
        "summary": "Update the specified default resource for the service",
        "responses": {
          "201": {
            "description": "Success. Service default resource has been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service default resource could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Service Default Resource"
        ],
        "summary": "Delete the specified default resource for the service",
        "responses": {
          "204": {
            "description": "Success. Service default resource has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Service default resource could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        },
        {
          "$ref": "#/parameters/serviceName"
        },
        {
          "$ref": "#/parameters/resourceURI"
        }
      ]
    },
    "/project/{projectName}/stage": {
      "get": {
        "tags": [
          "Stage"
        ],
        "summary": "Get list of stages",
        "parameters": [
          {
            "$ref": "#/parameters/pageSize"
          },
          {
            "$ref": "#/parameters/nextPageKey"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Stages"
            }
          },
          "404": {
            "description": "Failed. Containing project could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Stage"
        ],
        "summary": "Create a new stage by stage name",
        "parameters": [
          {
            "$ref": "#/parameters/stage"
          }
        ],
        "responses": {
          "204": {
            "description": "Success. Stage has been created. Response does not have a body."
          },
          "400": {
            "description": "Failed. Stage could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}": {
      "get": {
        "tags": [
          "Stage"
        ],
        "summary": "Get the specified stage",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Stage"
            }
          },
          "404": {
            "description": "Failed. Project resource could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Stage"
        ],
        "summary": "Update the specified stage",
        "parameters": [
          {
            "$ref": "#/parameters/stage"
          }
        ],
        "responses": {
          "204": {
            "description": "Success. Stage has been updated. Response does not have a body."
          },
          "400": {
            "description": "Failed. Stage could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Stage"
        ],
        "summary": "Delete the specified stage",
        "responses": {
          "204": {
            "description": "Success. Stage has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Stage could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        },
        {
          "$ref": "#/parameters/stageName"
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}/resource": {
      "get": {
        "tags": [
          "Stage Resource"
        ],
        "summary": "Get list of stage resources",
        "parameters": [
          {
            "$ref": "#/parameters/pageSize"
          },
          {
            "$ref": "#/parameters/nextPageKey"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resources"
            }
          },
          "404": {
            "description": "Failed. Stage could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Stage Resource"
        ],
        "summary": "Update list of stage resources",
        "parameters": [
          {
            "$ref": "#/parameters/resources"
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Stage resources have been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Stage resources could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Stage Resource"
        ],
        "summary": "Create list of new resources for the stage",
        "parameters": [
          {
            "$ref": "#/parameters/resources"
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Stage resource has been created. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Stage resource could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        },
        {
          "$ref": "#/parameters/stageName"
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}/resource/{resourceURI}": {
      "get": {
        "tags": [
          "Stage Resource"
        ],
        "summary": "Get the specified resource",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resource"
            }
          },
          "404": {
            "description": "Failed. Stage resource could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Stage Resource"
        ],
        "summary": "Update the specified resource",
        "parameters": [
          {
            "$ref": "#/parameters/resource"
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Stage resource has been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Stage resource could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Stage Resource"
        ],
        "summary": "Delete the specified resource",
        "responses": {
          "204": {
            "description": "Success. Stage resource has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Stage resource could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        },
        {
          "$ref": "#/parameters/stageName"
        },
        {
          "$ref": "#/parameters/resourceURI"
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}/service": {
      "get": {
        "tags": [
          "Service"
        ],
        "summary": "Get list of services",
        "parameters": [
          {
            "$ref": "#/parameters/pageSize"
          },
          {
            "$ref": "#/parameters/nextPageKey"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Services"
            }
          },
          "404": {
            "description": "Failed. Containing project could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Service"
        ],
        "summary": "Create a new service by service name",
        "parameters": [
          {
            "$ref": "#/parameters/service"
          }
        ],
        "responses": {
          "204": {
            "description": "Success. Stage has been created. Response does not have a body."
          },
          "400": {
            "description": "Failed. Service could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        },
        {
          "$ref": "#/parameters/stageName"
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}/service/{serviceName}": {
      "get": {
        "tags": [
          "Service"
        ],
        "summary": "Get the specified service",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Service"
            }
          },
          "404": {
            "description": "Failed. Service could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Service"
        ],
        "summary": "Update the specified service",
        "parameters": [
          {
            "$ref": "#/parameters/service"
          }
        ],
        "responses": {
          "204": {
            "description": "Success. Service has been updated. Response does not have a body."
          },
          "400": {
            "description": "Failed. Service could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Service"
        ],
        "summary": "Delete the specified service",
        "responses": {
          "204": {
            "description": "Success. Service has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Service could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        },
        {
          "$ref": "#/parameters/stageName"
        },
        {
          "$ref": "#/parameters/serviceName"
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}/service/{serviceName}/resource": {
      "get": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Get list of service resources",
        "parameters": [
          {
            "$ref": "#/parameters/pageSize"
          },
          {
            "$ref": "#/parameters/nextPageKey"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resources"
            }
          },
          "404": {
            "description": "Failed. Containing Service could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Update list of service resources",
        "parameters": [
          {
            "$ref": "#/parameters/resources"
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service resources have been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service resources could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Create list of new resources for the service",
        "parameters": [
          {
            "$ref": "#/parameters/resources"
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service resource has been created. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service resource could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        },
        {
          "$ref": "#/parameters/stageName"
        },
        {
          "$ref": "#/parameters/serviceName"
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}/service/{serviceName}/resource/{resourceURI}": {
      "get": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Get the specified resource",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resource"
            }
          },
          "404": {
            "description": "Failed. Service resource could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Update the specified resource",
        "parameters": [
          {
            "$ref": "#/parameters/resource"
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service resource has been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service resource could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Delete the specified resource",
        "responses": {
          "204": {
            "description": "Success. Service resource has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Service resource could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        },
        {
          "$ref": "#/parameters/stageName"
        },
        {
          "$ref": "#/parameters/serviceName"
        },
        {
          "$ref": "#/parameters/resourceURI"
        }
      ]
    }
  },
  "definitions": {
    "Error": {
      "type": "object",
      "required": [
        "message"
      ],
      "properties": {
        "code": {
          "description": "Error code",
          "type": "integer",
          "format": "int64"
        },
        "message": {
          "description": "Error message",
          "type": "string"
        }
      }
    },
    "Project": {
      "type": "object",
      "properties": {
        "gitRemoteURI": {
          "description": "Git remote URI",
          "type": "string"
        },
        "gitToken": {
          "description": "Git token",
          "type": "string"
        },
        "gitUser": {
          "description": "Git User",
          "type": "string"
        },
        "projectName": {
          "description": "Project name",
          "type": "string"
        }
      }
    },
    "Projects": {
      "type": "object",
      "properties": {
        "nextPageKey": {
          "description": "Pointer to next page, base64 encoded",
          "type": "string"
        },
        "pageSize": {
          "description": "Size of returned page",
          "type": "number"
        },
        "projects": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Project"
          }
        },
        "totalCount": {
          "description": "Total number of projects",
          "type": "number"
        }
      }
    },
    "Resource": {
      "type": "object",
      "required": [
        "resourceURI"
      ],
      "properties": {
        "resourceContent": {
          "description": "Resource content",
          "type": "string"
        },
        "resourceURI": {
          "description": "Resource URI",
          "type": "string"
        }
      }
    },
    "Resources": {
      "type": "object",
      "properties": {
        "nextPageKey": {
          "description": "Pointer to next page, base64 encoded",
          "type": "string"
        },
        "pageSize": {
          "description": "Size of returned page",
          "type": "number"
        },
        "resources": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Resource"
          }
        },
        "totalCount": {
          "description": "Total number of resources",
          "type": "number"
        }
      }
    },
    "Service": {
      "type": "object",
      "properties": {
        "serviceName": {
          "description": "Service name",
          "type": "string"
        }
      }
    },
    "Services": {
      "type": "object",
      "properties": {
        "nextPageKey": {
          "description": "Pointer to next page, base64 encoded",
          "type": "string"
        },
        "pageSize": {
          "description": "Size of returned page",
          "type": "number"
        },
        "services": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Service"
          }
        },
        "totalCount": {
          "description": "Total number of services",
          "type": "number"
        }
      }
    },
    "Stage": {
      "type": "object",
      "properties": {
        "stageName": {
          "description": "Stage name",
          "type": "string"
        }
      }
    },
    "Stages": {
      "type": "object",
      "properties": {
        "nextPageKey": {
          "description": "Pointer to next page, base64 encoded",
          "type": "string"
        },
        "pageSize": {
          "description": "Size of returned page",
          "type": "number"
        },
        "stages": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Stage"
          }
        },
        "totalCount": {
          "description": "Total number of stages",
          "type": "number"
        }
      }
    },
    "Version": {
      "type": "object",
      "properties": {
        "version": {
          "description": "Version identifier",
          "type": "string"
        }
      }
    }
  },
  "parameters": {
    "nextPageKey": {
      "type": "string",
      "description": "Pointer to the next set of items",
      "name": "nextPageKey",
      "in": "query"
    },
    "pageSize": {
      "maximum": 50,
      "minimum": 1,
      "type": "integer",
      "default": 20,
      "description": "The number of items to return",
      "name": "pageSize",
      "in": "query"
    },
    "project": {
      "description": "Project entity",
      "name": "project",
      "in": "body",
      "schema": {
        "$ref": "#/definitions/Project"
      }
    },
    "projectName": {
      "type": "string",
      "description": "Name of the project",
      "name": "projectName",
      "in": "path",
      "required": true
    },
    "resource": {
      "description": "Resource",
      "name": "resource",
      "in": "body",
      "schema": {
        "$ref": "#/definitions/Resource"
      }
    },
    "resourceURI": {
      "type": "string",
      "description": "Resource URI",
      "name": "resourceURI",
      "in": "path",
      "required": true
    },
    "resources": {
      "description": "List of resources",
      "name": "resources",
      "in": "body",
      "schema": {
        "properties": {
          "resources": {
            "type": "array",
            "items": {
              "$ref": "#/definitions/Resource"
            }
          }
        }
      }
    },
    "service": {
      "description": "Service entity",
      "name": "service",
      "in": "body",
      "schema": {
        "$ref": "#/definitions/Service"
      }
    },
    "serviceName": {
      "type": "string",
      "description": "Name of the service",
      "name": "serviceName",
      "in": "path",
      "required": true
    },
    "stage": {
      "description": "Stage entity",
      "name": "stage",
      "in": "body",
      "schema": {
        "$ref": "#/definitions/Stage"
      }
    },
    "stageName": {
      "type": "string",
      "description": "Name of the stage",
      "name": "stageName",
      "in": "path",
      "required": true
    }
  }
}`))
	FlatSwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http"
  ],
  "swagger": "2.0",
  "info": {
    "title": "Configuration Service API",
    "version": "0.1.0"
  },
  "basePath": "/v1",
  "paths": {
    "/project": {
      "get": {
        "tags": [
          "Project"
        ],
        "summary": "Get list of projects",
        "parameters": [
          {
            "maximum": 50,
            "minimum": 1,
            "type": "integer",
            "default": 20,
            "description": "The number of items to return",
            "name": "pageSize",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Pointer to the next set of items",
            "name": "nextPageKey",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Projects"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Project"
        ],
        "summary": "Create a new project by project name",
        "parameters": [
          {
            "description": "Project entity",
            "name": "project",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Project"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Success. Project has been created. Response does not have a body."
          },
          "400": {
            "description": "Failed. Project could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/project/{projectName}": {
      "get": {
        "tags": [
          "Project"
        ],
        "summary": "Get the specified project",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Project"
            }
          },
          "404": {
            "description": "Failed. Project could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Project"
        ],
        "summary": "Update the specified project",
        "parameters": [
          {
            "description": "Project entity",
            "name": "project",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Project"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Success. Project has been updated. Response does not have a body."
          },
          "400": {
            "description": "Failed. Project could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Project"
        ],
        "summary": "Delete the specified project",
        "responses": {
          "204": {
            "description": "Success. Project has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Project could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        }
      ]
    },
    "/project/{projectName}/resource": {
      "get": {
        "tags": [
          "Project Resource"
        ],
        "summary": "Get list of project resources",
        "parameters": [
          {
            "maximum": 50,
            "minimum": 1,
            "type": "integer",
            "default": 20,
            "description": "The number of items to return",
            "name": "pageSize",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Pointer to the next set of items",
            "name": "nextPageKey",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resources"
            }
          },
          "404": {
            "description": "Failed. Containing project could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Project Resource"
        ],
        "summary": "Update list of project resources",
        "parameters": [
          {
            "description": "List of resources",
            "name": "resources",
            "in": "body",
            "schema": {
              "properties": {
                "resources": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Resource"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Project resources have been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Project resources could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Project Resource"
        ],
        "summary": "Create list of new resources for the project",
        "parameters": [
          {
            "description": "List of resources",
            "name": "resources",
            "in": "body",
            "schema": {
              "properties": {
                "resources": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Resource"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Project resource has been created. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Project resource could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        }
      ]
    },
    "/project/{projectName}/resource/{resourceURI}": {
      "get": {
        "tags": [
          "Project Resource"
        ],
        "summary": "Get the specified resource",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resource"
            }
          },
          "404": {
            "description": "Failed. Project resource could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Project Resource"
        ],
        "summary": "Update the specified resource",
        "parameters": [
          {
            "description": "Resource",
            "name": "resource",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Resource"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Project resource has been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Project resource could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Project Resource"
        ],
        "summary": "Delete the specified resource",
        "responses": {
          "204": {
            "description": "Success. Project resource has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Project resource could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Resource URI",
          "name": "resourceURI",
          "in": "path",
          "required": true
        }
      ]
    },
    "/project/{projectName}/service/{serviceName}/resource": {
      "get": {
        "tags": [
          "Service Default Resource"
        ],
        "summary": "Get list of default resources for the service used in all stages",
        "parameters": [
          {
            "maximum": 50,
            "minimum": 1,
            "type": "integer",
            "default": 20,
            "description": "The number of items to return",
            "name": "pageSize",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Pointer to the next set of items",
            "name": "nextPageKey",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resources"
            }
          },
          "404": {
            "description": "Failed. Containing service could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Service Default Resource"
        ],
        "summary": "Update list of service default resources",
        "parameters": [
          {
            "description": "List of resources",
            "name": "resources",
            "in": "body",
            "schema": {
              "properties": {
                "resources": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Resource"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service default resources have been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service default resources could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Service Default Resource"
        ],
        "summary": "Create list of default resources for the service used in all stages",
        "parameters": [
          {
            "description": "List of resources",
            "name": "resources",
            "in": "body",
            "schema": {
              "properties": {
                "resources": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Resource"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service default resource has been created. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service default resource could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the service",
          "name": "serviceName",
          "in": "path",
          "required": true
        }
      ]
    },
    "/project/{projectName}/service/{serviceName}/resource/{resourceURI}": {
      "get": {
        "tags": [
          "Service Default Resource"
        ],
        "summary": "Get the specified default resource for the service",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resource"
            }
          },
          "404": {
            "description": "Failed. Default resource could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Service Default Resource"
        ],
        "summary": "Update the specified default resource for the service",
        "responses": {
          "201": {
            "description": "Success. Service default resource has been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service default resource could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Service Default Resource"
        ],
        "summary": "Delete the specified default resource for the service",
        "responses": {
          "204": {
            "description": "Success. Service default resource has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Service default resource could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the service",
          "name": "serviceName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Resource URI",
          "name": "resourceURI",
          "in": "path",
          "required": true
        }
      ]
    },
    "/project/{projectName}/stage": {
      "get": {
        "tags": [
          "Stage"
        ],
        "summary": "Get list of stages",
        "parameters": [
          {
            "maximum": 50,
            "minimum": 1,
            "type": "integer",
            "default": 20,
            "description": "The number of items to return",
            "name": "pageSize",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Pointer to the next set of items",
            "name": "nextPageKey",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Stages"
            }
          },
          "404": {
            "description": "Failed. Containing project could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Stage"
        ],
        "summary": "Create a new stage by stage name",
        "parameters": [
          {
            "description": "Stage entity",
            "name": "stage",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Stage"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Success. Stage has been created. Response does not have a body."
          },
          "400": {
            "description": "Failed. Stage could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}": {
      "get": {
        "tags": [
          "Stage"
        ],
        "summary": "Get the specified stage",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Stage"
            }
          },
          "404": {
            "description": "Failed. Project resource could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Stage"
        ],
        "summary": "Update the specified stage",
        "parameters": [
          {
            "description": "Stage entity",
            "name": "stage",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Stage"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Success. Stage has been updated. Response does not have a body."
          },
          "400": {
            "description": "Failed. Stage could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Stage"
        ],
        "summary": "Delete the specified stage",
        "responses": {
          "204": {
            "description": "Success. Stage has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Stage could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the stage",
          "name": "stageName",
          "in": "path",
          "required": true
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}/resource": {
      "get": {
        "tags": [
          "Stage Resource"
        ],
        "summary": "Get list of stage resources",
        "parameters": [
          {
            "maximum": 50,
            "minimum": 1,
            "type": "integer",
            "default": 20,
            "description": "The number of items to return",
            "name": "pageSize",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Pointer to the next set of items",
            "name": "nextPageKey",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resources"
            }
          },
          "404": {
            "description": "Failed. Stage could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Stage Resource"
        ],
        "summary": "Update list of stage resources",
        "parameters": [
          {
            "description": "List of resources",
            "name": "resources",
            "in": "body",
            "schema": {
              "properties": {
                "resources": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Resource"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Stage resources have been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Stage resources could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Stage Resource"
        ],
        "summary": "Create list of new resources for the stage",
        "parameters": [
          {
            "description": "List of resources",
            "name": "resources",
            "in": "body",
            "schema": {
              "properties": {
                "resources": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Resource"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Stage resource has been created. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Stage resource could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the stage",
          "name": "stageName",
          "in": "path",
          "required": true
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}/resource/{resourceURI}": {
      "get": {
        "tags": [
          "Stage Resource"
        ],
        "summary": "Get the specified resource",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resource"
            }
          },
          "404": {
            "description": "Failed. Stage resource could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Stage Resource"
        ],
        "summary": "Update the specified resource",
        "parameters": [
          {
            "description": "Resource",
            "name": "resource",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Resource"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Stage resource has been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Stage resource could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Stage Resource"
        ],
        "summary": "Delete the specified resource",
        "responses": {
          "204": {
            "description": "Success. Stage resource has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Stage resource could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the stage",
          "name": "stageName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Resource URI",
          "name": "resourceURI",
          "in": "path",
          "required": true
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}/service": {
      "get": {
        "tags": [
          "Service"
        ],
        "summary": "Get list of services",
        "parameters": [
          {
            "maximum": 50,
            "minimum": 1,
            "type": "integer",
            "default": 20,
            "description": "The number of items to return",
            "name": "pageSize",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Pointer to the next set of items",
            "name": "nextPageKey",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Services"
            }
          },
          "404": {
            "description": "Failed. Containing project could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Service"
        ],
        "summary": "Create a new service by service name",
        "parameters": [
          {
            "description": "Service entity",
            "name": "service",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Service"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Success. Stage has been created. Response does not have a body."
          },
          "400": {
            "description": "Failed. Service could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the stage",
          "name": "stageName",
          "in": "path",
          "required": true
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}/service/{serviceName}": {
      "get": {
        "tags": [
          "Service"
        ],
        "summary": "Get the specified service",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Service"
            }
          },
          "404": {
            "description": "Failed. Service could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Service"
        ],
        "summary": "Update the specified service",
        "parameters": [
          {
            "description": "Service entity",
            "name": "service",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Service"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Success. Service has been updated. Response does not have a body."
          },
          "400": {
            "description": "Failed. Service could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Service"
        ],
        "summary": "Delete the specified service",
        "responses": {
          "204": {
            "description": "Success. Service has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Service could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the stage",
          "name": "stageName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the service",
          "name": "serviceName",
          "in": "path",
          "required": true
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}/service/{serviceName}/resource": {
      "get": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Get list of service resources",
        "parameters": [
          {
            "maximum": 50,
            "minimum": 1,
            "type": "integer",
            "default": 20,
            "description": "The number of items to return",
            "name": "pageSize",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Pointer to the next set of items",
            "name": "nextPageKey",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resources"
            }
          },
          "404": {
            "description": "Failed. Containing Service could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Update list of service resources",
        "parameters": [
          {
            "description": "List of resources",
            "name": "resources",
            "in": "body",
            "schema": {
              "properties": {
                "resources": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Resource"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service resources have been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service resources could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Create list of new resources for the service",
        "parameters": [
          {
            "description": "List of resources",
            "name": "resources",
            "in": "body",
            "schema": {
              "properties": {
                "resources": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Resource"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service resource has been created. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service resource could not be created.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the stage",
          "name": "stageName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the service",
          "name": "serviceName",
          "in": "path",
          "required": true
        }
      ]
    },
    "/project/{projectName}/stage/{stageName}/service/{serviceName}/resource/{resourceURI}": {
      "get": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Get the specified resource",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/Resource"
            }
          },
          "404": {
            "description": "Failed. Service resource could not be found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Update the specified resource",
        "parameters": [
          {
            "description": "Resource",
            "name": "resource",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Resource"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service resource has been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service resource could not be updated.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Delete the specified resource",
        "responses": {
          "204": {
            "description": "Success. Service resource has been deleted. Response does not have a body."
          },
          "400": {
            "description": "Failed. Service resource could not be deleted.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the stage",
          "name": "stageName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the service",
          "name": "serviceName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Resource URI",
          "name": "resourceURI",
          "in": "path",
          "required": true
        }
      ]
    }
  },
  "definitions": {
    "Error": {
      "type": "object",
      "required": [
        "message"
      ],
      "properties": {
        "code": {
          "description": "Error code",
          "type": "integer",
          "format": "int64"
        },
        "message": {
          "description": "Error message",
          "type": "string"
        }
      }
    },
    "Project": {
      "type": "object",
      "properties": {
        "gitRemoteURI": {
          "description": "Git remote URI",
          "type": "string"
        },
        "gitToken": {
          "description": "Git token",
          "type": "string"
        },
        "gitUser": {
          "description": "Git User",
          "type": "string"
        },
        "projectName": {
          "description": "Project name",
          "type": "string"
        }
      }
    },
    "Projects": {
      "type": "object",
      "properties": {
        "nextPageKey": {
          "description": "Pointer to next page, base64 encoded",
          "type": "string"
        },
        "pageSize": {
          "description": "Size of returned page",
          "type": "number"
        },
        "projects": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Project"
          }
        },
        "totalCount": {
          "description": "Total number of projects",
          "type": "number"
        }
      }
    },
    "Resource": {
      "type": "object",
      "required": [
        "resourceURI"
      ],
      "properties": {
        "resourceContent": {
          "description": "Resource content",
          "type": "string"
        },
        "resourceURI": {
          "description": "Resource URI",
          "type": "string"
        }
      }
    },
    "Resources": {
      "type": "object",
      "properties": {
        "nextPageKey": {
          "description": "Pointer to next page, base64 encoded",
          "type": "string"
        },
        "pageSize": {
          "description": "Size of returned page",
          "type": "number"
        },
        "resources": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Resource"
          }
        },
        "totalCount": {
          "description": "Total number of resources",
          "type": "number"
        }
      }
    },
    "Service": {
      "type": "object",
      "properties": {
        "serviceName": {
          "description": "Service name",
          "type": "string"
        }
      }
    },
    "Services": {
      "type": "object",
      "properties": {
        "nextPageKey": {
          "description": "Pointer to next page, base64 encoded",
          "type": "string"
        },
        "pageSize": {
          "description": "Size of returned page",
          "type": "number"
        },
        "services": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Service"
          }
        },
        "totalCount": {
          "description": "Total number of services",
          "type": "number"
        }
      }
    },
    "Stage": {
      "type": "object",
      "properties": {
        "stageName": {
          "description": "Stage name",
          "type": "string"
        }
      }
    },
    "Stages": {
      "type": "object",
      "properties": {
        "nextPageKey": {
          "description": "Pointer to next page, base64 encoded",
          "type": "string"
        },
        "pageSize": {
          "description": "Size of returned page",
          "type": "number"
        },
        "stages": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Stage"
          }
        },
        "totalCount": {
          "description": "Total number of stages",
          "type": "number"
        }
      }
    },
    "Version": {
      "type": "object",
      "properties": {
        "version": {
          "description": "Version identifier",
          "type": "string"
        }
      }
    }
  },
  "parameters": {
    "nextPageKey": {
      "type": "string",
      "description": "Pointer to the next set of items",
      "name": "nextPageKey",
      "in": "query"
    },
    "pageSize": {
      "maximum": 50,
      "minimum": 1,
      "type": "integer",
      "default": 20,
      "description": "The number of items to return",
      "name": "pageSize",
      "in": "query"
    },
    "project": {
      "description": "Project entity",
      "name": "project",
      "in": "body",
      "schema": {
        "$ref": "#/definitions/Project"
      }
    },
    "projectName": {
      "type": "string",
      "description": "Name of the project",
      "name": "projectName",
      "in": "path",
      "required": true
    },
    "resource": {
      "description": "Resource",
      "name": "resource",
      "in": "body",
      "schema": {
        "$ref": "#/definitions/Resource"
      }
    },
    "resourceURI": {
      "type": "string",
      "description": "Resource URI",
      "name": "resourceURI",
      "in": "path",
      "required": true
    },
    "resources": {
      "description": "List of resources",
      "name": "resources",
      "in": "body",
      "schema": {
        "properties": {
          "resources": {
            "type": "array",
            "items": {
              "$ref": "#/definitions/Resource"
            }
          }
        }
      }
    },
    "service": {
      "description": "Service entity",
      "name": "service",
      "in": "body",
      "schema": {
        "$ref": "#/definitions/Service"
      }
    },
    "serviceName": {
      "type": "string",
      "description": "Name of the service",
      "name": "serviceName",
      "in": "path",
      "required": true
    },
    "stage": {
      "description": "Stage entity",
      "name": "stage",
      "in": "body",
      "schema": {
        "$ref": "#/definitions/Stage"
      }
    },
    "stageName": {
      "type": "string",
      "description": "Name of the stage",
      "name": "stageName",
      "in": "path",
      "required": true
    }
  }
}`))
}
