// Code generated by go-swagger; DO NOT EDIT.

package auth

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	middleware "github.com/go-openapi/runtime/middleware"

	models "github.com/keptn/keptn/api/models"
)

// AuthHandlerFunc turns a function with the right signature into a auth handler
type AuthHandlerFunc func(AuthParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn AuthHandlerFunc) Handle(params AuthParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// AuthHandler interface for that can handle valid auth params
type AuthHandler interface {
	Handle(AuthParams, *models.Principal) middleware.Responder
}

// NewAuth creates a new http.Handler for the auth operation
func NewAuth(ctx *middleware.Context, handler AuthHandler) *Auth {
	return &Auth{Context: ctx, Handler: handler}
}

/*Auth swagger:route POST /auth auth auth

Checks the provided token

*/
type Auth struct {
	Context *middleware.Context
	Handler AuthHandler
}

func (o *Auth) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		r = rCtx
	}
	var Params = NewAuthParams()

	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		r = aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request

	o.Context.Respond(rw, r, route.Produces, route, res)

}
