// Code generated by go-swagger; DO NOT EDIT.

package restapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

var (
	// SwaggerJSON embedded version of the swagger document used at generation time
	SwaggerJSON json.RawMessage
	// FlatSwaggerJSON embedded flattened version of the swagger document used at generation time
	FlatSwaggerJSON json.RawMessage
)

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json",
    "application/cloudevents+json"
  ],
  "produces": [
    "application/json",
    "application/cloudevents+json"
  ],
  "schemes": [
    "http"
  ],
  "swagger": "2.0",
  "info": {
    "title": "keptn api",
    "version": "0.1.0"
  },
  "basePath": "/v1",
  "paths": {
    "/auth": {
      "post": {
        "tags": [
          "auth"
        ],
        "summary": "Checks the provided token",
        "operationId": "auth",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/CE"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "authenticated"
          }
        }
      }
    },
    "/event": {
      "post": {
        "tags": [
          "event"
        ],
        "summary": "Forwards the received event to the eventbroker",
        "operationId": "sendEvent",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/CE"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "forwarded",
            "schema": {
              "$ref": "#/definitions/ChannelInfo"
            }
          },
          "default": {
            "description": "error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/project": {
      "post": {
        "tags": [
          "project"
        ],
        "summary": "Forwards the received project event to the eventbroker",
        "operationId": "project",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/CreateProjectCE"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Project created",
            "schema": {
              "$ref": "#/definitions/ChannelInfo"
            }
          },
          "204": {
            "description": "Project deleted",
            "schema": {
              "$ref": "#/definitions/ChannelInfo"
            }
          },
          "default": {
            "description": "error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/project/{projectName}/stage/{stageName}/service/{serviceName}/resource": {
      "put": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Update list of service resources",
        "parameters": [
          {
            "$ref": "#/parameters/resources"
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service resources have been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service resources could not be updated.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Create list of new resources for the service",
        "parameters": [
          {
            "$ref": "#/parameters/resources"
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service resource has been created. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service resource could not be created.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "parameters": [
        {
          "$ref": "#/parameters/projectName"
        },
        {
          "$ref": "#/parameters/stageName"
        },
        {
          "$ref": "#/parameters/serviceName"
        }
      ]
    },
    "/service": {
      "post": {
        "tags": [
          "service"
        ],
        "summary": "Forwards the received service event to the eventbroker",
        "operationId": "service",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/CE"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "service onboarded",
            "schema": {
              "$ref": "#/definitions/ChannelInfo"
            }
          },
          "default": {
            "description": "error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "CE": {
      "allOf": [
        {
          "$ref": "#/definitions/CE_without_data"
        },
        {
          "type": "object",
          "properties": {
            "data": {
              "type": [
                "object",
                "string"
              ]
            }
          }
        }
      ]
    },
    "CE_without_data": {
      "type": "object",
      "required": [
        "specversion",
        "id",
        "type",
        "source"
      ],
      "properties": {
        "contenttype": {
          "type": "string"
        },
        "extensions": {
          "type": "object"
        },
        "id": {
          "type": "string"
        },
        "source": {
          "type": "string",
          "format": "uri-reference"
        },
        "specversion": {
          "type": "string"
        },
        "time": {
          "type": "string",
          "format": "date-time"
        },
        "type": {
          "type": "string"
        }
      }
    },
    "CE_without_data_with_keptncontext": {
      "allOf": [
        {
          "$ref": "#/definitions/CE_without_data"
        },
        {
          "type": "object",
          "properties": {
            "shkeptncontext": {
              "type": "string"
            }
          }
        }
      ]
    },
    "ChannelInfo": {
      "allOf": [
        {
          "$ref": "#/definitions/CE_without_data_with_keptncontext"
        },
        {
          "type": "object",
          "properties": {
            "data": {
              "properties": {
                "channelInfo": {
                  "required": [
                    "token",
                    "channelID"
                  ],
                  "properties": {
                    "channelID": {
                      "type": "string"
                    },
                    "token": {
                      "type": "string"
                    }
                  }
                }
              }
            }
          }
        }
      ]
    },
    "CreateProjectCE": {
      "allOf": [
        {
          "$ref": "#/definitions/CE_without_data"
        },
        {
          "type": "object",
          "properties": {
            "data": {
              "required": [
                "project"
              ],
              "properties": {
                "gitRemoteURL": {
                  "type": "string"
                },
                "gitToken": {
                  "type": "string"
                },
                "gitUser": {
                  "type": "string"
                },
                "project": {
                  "type": "string"
                },
                "shipyard": {
                  "type": "string"
                }
              }
            }
          }
        }
      ]
    },
    "Resource": {
      "type": "object",
      "required": [
        "resourceURI",
        "resourceContent"
      ],
      "properties": {
        "resourceContent": {
          "description": "Resource content",
          "type": "string"
        },
        "resourceURI": {
          "description": "Resource URI",
          "type": "string"
        }
      }
    },
    "Resources": {
      "type": "object",
      "properties": {
        "nextPageKey": {
          "description": "Pointer to next page, base64 encoded",
          "type": "string"
        },
        "pageSize": {
          "description": "Size of returned page",
          "type": "number"
        },
        "resources": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Resource"
          }
        },
        "totalCount": {
          "description": "Total number of resources",
          "type": "number"
        }
      }
    },
    "Version": {
      "type": "object",
      "properties": {
        "version": {
          "description": "Version identifier",
          "type": "string"
        }
      }
    },
    "error": {
      "type": "object",
      "required": [
        "message"
      ],
      "properties": {
        "code": {
          "type": "integer",
          "format": "int64"
        },
        "fields": {
          "type": "string"
        },
        "message": {
          "type": "string"
        }
      }
    }
  },
  "parameters": {
    "projectName": {
      "type": "string",
      "description": "Name of the project",
      "name": "projectName",
      "in": "path",
      "required": true
    },
    "resource": {
      "description": "Resource",
      "name": "resource",
      "in": "body",
      "schema": {
        "$ref": "#/definitions/Resource"
      }
    },
    "resourceURI": {
      "type": "string",
      "description": "Resource URI",
      "name": "resourceURI",
      "in": "path",
      "required": true
    },
    "resources": {
      "description": "List of resources",
      "name": "resources",
      "in": "body",
      "schema": {
        "properties": {
          "resources": {
            "type": "array",
            "items": {
              "$ref": "#/definitions/Resource"
            }
          }
        }
      }
    },
    "serviceName": {
      "type": "string",
      "description": "Name of the service",
      "name": "serviceName",
      "in": "path",
      "required": true
    },
    "stageName": {
      "type": "string",
      "description": "Name of the stage",
      "name": "stageName",
      "in": "path",
      "required": true
    }
  },
  "securityDefinitions": {
    "key": {
      "type": "apiKey",
      "name": "x-token",
      "in": "header"
    }
  },
  "security": [
    {
      "key": []
    }
  ]
}`))
	FlatSwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json",
    "application/cloudevents+json"
  ],
  "produces": [
    "application/json",
    "application/cloudevents+json"
  ],
  "schemes": [
    "http"
  ],
  "swagger": "2.0",
  "info": {
    "title": "keptn api",
    "version": "0.1.0"
  },
  "basePath": "/v1",
  "paths": {
    "/auth": {
      "post": {
        "tags": [
          "auth"
        ],
        "summary": "Checks the provided token",
        "operationId": "auth",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/CE"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "authenticated"
          }
        }
      }
    },
    "/event": {
      "post": {
        "tags": [
          "event"
        ],
        "summary": "Forwards the received event to the eventbroker",
        "operationId": "sendEvent",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/CE"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "forwarded",
            "schema": {
              "$ref": "#/definitions/ChannelInfo"
            }
          },
          "default": {
            "description": "error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/project": {
      "post": {
        "tags": [
          "project"
        ],
        "summary": "Forwards the received project event to the eventbroker",
        "operationId": "project",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/CreateProjectCE"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Project created",
            "schema": {
              "$ref": "#/definitions/ChannelInfo"
            }
          },
          "204": {
            "description": "Project deleted",
            "schema": {
              "$ref": "#/definitions/ChannelInfo"
            }
          },
          "default": {
            "description": "error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/project/{projectName}/stage/{stageName}/service/{serviceName}/resource": {
      "put": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Update list of service resources",
        "parameters": [
          {
            "description": "List of resources",
            "name": "resources",
            "in": "body",
            "schema": {
              "properties": {
                "resources": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Resource"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service resources have been updated. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service resources could not be updated.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Service Resource"
        ],
        "summary": "Create list of new resources for the service",
        "parameters": [
          {
            "description": "List of resources",
            "name": "resources",
            "in": "body",
            "schema": {
              "properties": {
                "resources": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Resource"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success. Service resource has been created. The version of the new configuration is returned.",
            "schema": {
              "$ref": "#/definitions/Version"
            }
          },
          "400": {
            "description": "Failed. Service resource could not be created.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "default": {
            "description": "Error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "parameters": [
        {
          "type": "string",
          "description": "Name of the project",
          "name": "projectName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the stage",
          "name": "stageName",
          "in": "path",
          "required": true
        },
        {
          "type": "string",
          "description": "Name of the service",
          "name": "serviceName",
          "in": "path",
          "required": true
        }
      ]
    },
    "/service": {
      "post": {
        "tags": [
          "service"
        ],
        "summary": "Forwards the received service event to the eventbroker",
        "operationId": "service",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/CE"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "service onboarded",
            "schema": {
              "$ref": "#/definitions/ChannelInfo"
            }
          },
          "default": {
            "description": "error",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "CE": {
      "allOf": [
        {
          "$ref": "#/definitions/CE_without_data"
        },
        {
          "type": "object",
          "properties": {
            "data": {
              "type": [
                "object",
                "string"
              ]
            }
          }
        }
      ]
    },
    "CE_without_data": {
      "type": "object",
      "required": [
        "specversion",
        "id",
        "type",
        "source"
      ],
      "properties": {
        "contenttype": {
          "type": "string"
        },
        "extensions": {
          "type": "object"
        },
        "id": {
          "type": "string"
        },
        "source": {
          "type": "string",
          "format": "uri-reference"
        },
        "specversion": {
          "type": "string"
        },
        "time": {
          "type": "string",
          "format": "date-time"
        },
        "type": {
          "type": "string"
        }
      }
    },
    "CE_without_data_with_keptncontext": {
      "allOf": [
        {
          "$ref": "#/definitions/CE_without_data"
        },
        {
          "type": "object",
          "properties": {
            "shkeptncontext": {
              "type": "string"
            }
          }
        }
      ]
    },
    "ChannelInfo": {
      "allOf": [
        {
          "$ref": "#/definitions/CE_without_data_with_keptncontext"
        },
        {
          "type": "object",
          "properties": {
            "data": {
              "properties": {
                "channelInfo": {
                  "required": [
                    "token",
                    "channelID"
                  ],
                  "properties": {
                    "channelID": {
                      "type": "string"
                    },
                    "token": {
                      "type": "string"
                    }
                  }
                }
              }
            }
          }
        }
      ]
    },
    "CreateProjectCE": {
      "allOf": [
        {
          "$ref": "#/definitions/CE_without_data"
        },
        {
          "type": "object",
          "properties": {
            "data": {
              "required": [
                "project"
              ],
              "properties": {
                "gitRemoteURL": {
                  "type": "string"
                },
                "gitToken": {
                  "type": "string"
                },
                "gitUser": {
                  "type": "string"
                },
                "project": {
                  "type": "string"
                },
                "shipyard": {
                  "type": "string"
                }
              }
            }
          }
        }
      ]
    },
    "Resource": {
      "type": "object",
      "required": [
        "resourceURI",
        "resourceContent"
      ],
      "properties": {
        "resourceContent": {
          "description": "Resource content",
          "type": "string"
        },
        "resourceURI": {
          "description": "Resource URI",
          "type": "string"
        }
      }
    },
    "Resources": {
      "type": "object",
      "properties": {
        "nextPageKey": {
          "description": "Pointer to next page, base64 encoded",
          "type": "string"
        },
        "pageSize": {
          "description": "Size of returned page",
          "type": "number"
        },
        "resources": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Resource"
          }
        },
        "totalCount": {
          "description": "Total number of resources",
          "type": "number"
        }
      }
    },
    "Version": {
      "type": "object",
      "properties": {
        "version": {
          "description": "Version identifier",
          "type": "string"
        }
      }
    },
    "error": {
      "type": "object",
      "required": [
        "message"
      ],
      "properties": {
        "code": {
          "type": "integer",
          "format": "int64"
        },
        "fields": {
          "type": "string"
        },
        "message": {
          "type": "string"
        }
      }
    }
  },
  "parameters": {
    "projectName": {
      "type": "string",
      "description": "Name of the project",
      "name": "projectName",
      "in": "path",
      "required": true
    },
    "resource": {
      "description": "Resource",
      "name": "resource",
      "in": "body",
      "schema": {
        "$ref": "#/definitions/Resource"
      }
    },
    "resourceURI": {
      "type": "string",
      "description": "Resource URI",
      "name": "resourceURI",
      "in": "path",
      "required": true
    },
    "resources": {
      "description": "List of resources",
      "name": "resources",
      "in": "body",
      "schema": {
        "properties": {
          "resources": {
            "type": "array",
            "items": {
              "$ref": "#/definitions/Resource"
            }
          }
        }
      }
    },
    "serviceName": {
      "type": "string",
      "description": "Name of the service",
      "name": "serviceName",
      "in": "path",
      "required": true
    },
    "stageName": {
      "type": "string",
      "description": "Name of the stage",
      "name": "stageName",
      "in": "path",
      "required": true
    }
  },
  "securityDefinitions": {
    "key": {
      "type": "apiKey",
      "name": "x-token",
      "in": "header"
    }
  },
  "security": [
    {
      "key": []
    }
  ]
}`))
}
