// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CreateProjectCE create project c e
// swagger:model CreateProjectCE
type CreateProjectCE struct {
	CEWithoutData

	// data
	Data *CreateProjectCEAO1Data `json:"data,omitempty"`
}

// UnmarshalJSON unmarshals this object from a JSON structure
func (m *CreateProjectCE) UnmarshalJSON(raw []byte) error {
	// AO0
	var aO0 CEWithoutData
	if err := swag.ReadJSON(raw, &aO0); err != nil {
		return err
	}
	m.CEWithoutData = aO0

	// AO1
	var dataAO1 struct {
		Data *CreateProjectCEAO1Data `json:"data,omitempty"`
	}
	if err := swag.ReadJSON(raw, &dataAO1); err != nil {
		return err
	}

	m.Data = dataAO1.Data

	return nil
}

// MarshalJSON marshals this object to a JSON structure
func (m CreateProjectCE) MarshalJSON() ([]byte, error) {
	_parts := make([][]byte, 0, 2)

	aO0, err := swag.WriteJSON(m.CEWithoutData)
	if err != nil {
		return nil, err
	}
	_parts = append(_parts, aO0)

	var dataAO1 struct {
		Data *CreateProjectCEAO1Data `json:"data,omitempty"`
	}

	dataAO1.Data = m.Data

	jsonDataAO1, errAO1 := swag.WriteJSON(dataAO1)
	if errAO1 != nil {
		return nil, errAO1
	}
	_parts = append(_parts, jsonDataAO1)

	return swag.ConcatJSON(_parts...), nil
}

// Validate validates this create project c e
func (m *CreateProjectCE) Validate(formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with CEWithoutData
	if err := m.CEWithoutData.Validate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateData(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CreateProjectCE) validateData(formats strfmt.Registry) error {

	if swag.IsZero(m.Data) { // not required
		return nil
	}

	if m.Data != nil {
		if err := m.Data.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CreateProjectCE) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CreateProjectCE) UnmarshalBinary(b []byte) error {
	var res CreateProjectCE
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CreateProjectCEAO1Data create project c e a o1 data
// swagger:model CreateProjectCEAO1Data
type CreateProjectCEAO1Data struct {

	// git remote URL
	GitRemoteURL string `json:"gitRemoteURL,omitempty"`

	// git token
	GitToken string `json:"gitToken,omitempty"`

	// git user
	GitUser string `json:"gitUser,omitempty"`

	// project
	// Required: true
	Project *string `json:"project"`

	// shipyard
	Shipyard string `json:"shipyard,omitempty"`
}

// Validate validates this create project c e a o1 data
func (m *CreateProjectCEAO1Data) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateProject(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CreateProjectCEAO1Data) validateProject(formats strfmt.Registry) error {

	if err := validate.Required("data"+"."+"project", "body", m.Project); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CreateProjectCEAO1Data) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CreateProjectCEAO1Data) UnmarshalBinary(b []byte) error {
	var res CreateProjectCEAO1Data
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
