// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/jenkins-x/jx/pkg/apis/jenkins.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// UserLister helps list Users.
type UserLister interface {
	// List lists all Users in the indexer.
	List(selector labels.Selector) (ret []*v1.User, err error)
	// Users returns an object that can list and get Users.
	Users(namespace string) UserNamespaceLister
	UserListerExpansion
}

// userLister implements the UserLister interface.
type userLister struct {
	indexer cache.Indexer
}

// NewUserLister returns a new UserLister.
func NewUserLister(indexer cache.Indexer) UserLister {
	return &userLister{indexer: indexer}
}

// List lists all Users in the indexer.
func (s *userLister) List(selector labels.Selector) (ret []*v1.User, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.User))
	})
	return ret, err
}

// Users returns an object that can list and get Users.
func (s *userLister) Users(namespace string) UserNamespaceLister {
	return userNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// UserNamespaceLister helps list and get Users.
type UserNamespaceLister interface {
	// List lists all Users in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.User, err error)
	// Get retrieves the User from the indexer for a given namespace and name.
	Get(name string) (*v1.User, error)
	UserNamespaceListerExpansion
}

// userNamespaceLister implements the UserNamespaceLister
// interface.
type userNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Users in the indexer for a given namespace.
func (s userNamespaceLister) List(selector labels.Selector) (ret []*v1.User, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.User))
	})
	return ret, err
}

// Get retrieves the User from the indexer for a given namespace and name.
func (s userNamespaceLister) Get(name string) (*v1.User, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("user"), name)
	}
	return obj.(*v1.User), nil
}
