// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/jenkins-x/jx/pkg/apis/jenkins.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// TeamLister helps list Teams.
type TeamLister interface {
	// List lists all Teams in the indexer.
	List(selector labels.Selector) (ret []*v1.Team, err error)
	// Teams returns an object that can list and get Teams.
	Teams(namespace string) TeamNamespaceLister
	TeamListerExpansion
}

// teamLister implements the TeamLister interface.
type teamLister struct {
	indexer cache.Indexer
}

// NewTeamLister returns a new TeamLister.
func NewTeamLister(indexer cache.Indexer) TeamLister {
	return &teamLister{indexer: indexer}
}

// List lists all Teams in the indexer.
func (s *teamLister) List(selector labels.Selector) (ret []*v1.Team, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Team))
	})
	return ret, err
}

// Teams returns an object that can list and get Teams.
func (s *teamLister) Teams(namespace string) TeamNamespaceLister {
	return teamNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// TeamNamespaceLister helps list and get Teams.
type TeamNamespaceLister interface {
	// List lists all Teams in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.Team, err error)
	// Get retrieves the Team from the indexer for a given namespace and name.
	Get(name string) (*v1.Team, error)
	TeamNamespaceListerExpansion
}

// teamNamespaceLister implements the TeamNamespaceLister
// interface.
type teamNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Teams in the indexer for a given namespace.
func (s teamNamespaceLister) List(selector labels.Selector) (ret []*v1.Team, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Team))
	})
	return ret, err
}

// Get retrieves the Team from the indexer for a given namespace and name.
func (s teamNamespaceLister) Get(name string) (*v1.Team, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("team"), name)
	}
	return obj.(*v1.Team), nil
}
