// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/jenkins-x/jx/pkg/apis/jenkins.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SourceRepositoryGroupLister helps list SourceRepositoryGroups.
type SourceRepositoryGroupLister interface {
	// List lists all SourceRepositoryGroups in the indexer.
	List(selector labels.Selector) (ret []*v1.SourceRepositoryGroup, err error)
	// SourceRepositoryGroups returns an object that can list and get SourceRepositoryGroups.
	SourceRepositoryGroups(namespace string) SourceRepositoryGroupNamespaceLister
	SourceRepositoryGroupListerExpansion
}

// sourceRepositoryGroupLister implements the SourceRepositoryGroupLister interface.
type sourceRepositoryGroupLister struct {
	indexer cache.Indexer
}

// NewSourceRepositoryGroupLister returns a new SourceRepositoryGroupLister.
func NewSourceRepositoryGroupLister(indexer cache.Indexer) SourceRepositoryGroupLister {
	return &sourceRepositoryGroupLister{indexer: indexer}
}

// List lists all SourceRepositoryGroups in the indexer.
func (s *sourceRepositoryGroupLister) List(selector labels.Selector) (ret []*v1.SourceRepositoryGroup, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SourceRepositoryGroup))
	})
	return ret, err
}

// SourceRepositoryGroups returns an object that can list and get SourceRepositoryGroups.
func (s *sourceRepositoryGroupLister) SourceRepositoryGroups(namespace string) SourceRepositoryGroupNamespaceLister {
	return sourceRepositoryGroupNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// SourceRepositoryGroupNamespaceLister helps list and get SourceRepositoryGroups.
type SourceRepositoryGroupNamespaceLister interface {
	// List lists all SourceRepositoryGroups in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.SourceRepositoryGroup, err error)
	// Get retrieves the SourceRepositoryGroup from the indexer for a given namespace and name.
	Get(name string) (*v1.SourceRepositoryGroup, error)
	SourceRepositoryGroupNamespaceListerExpansion
}

// sourceRepositoryGroupNamespaceLister implements the SourceRepositoryGroupNamespaceLister
// interface.
type sourceRepositoryGroupNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all SourceRepositoryGroups in the indexer for a given namespace.
func (s sourceRepositoryGroupNamespaceLister) List(selector labels.Selector) (ret []*v1.SourceRepositoryGroup, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SourceRepositoryGroup))
	})
	return ret, err
}

// Get retrieves the SourceRepositoryGroup from the indexer for a given namespace and name.
func (s sourceRepositoryGroupNamespaceLister) Get(name string) (*v1.SourceRepositoryGroup, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("sourcerepositorygroup"), name)
	}
	return obj.(*v1.SourceRepositoryGroup), nil
}
