// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/jenkins-x/jx/pkg/apis/jenkins.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SchedulerLister helps list Schedulers.
type SchedulerLister interface {
	// List lists all Schedulers in the indexer.
	List(selector labels.Selector) (ret []*v1.Scheduler, err error)
	// Schedulers returns an object that can list and get Schedulers.
	Schedulers(namespace string) SchedulerNamespaceLister
	SchedulerListerExpansion
}

// schedulerLister implements the SchedulerLister interface.
type schedulerLister struct {
	indexer cache.Indexer
}

// NewSchedulerLister returns a new SchedulerLister.
func NewSchedulerLister(indexer cache.Indexer) SchedulerLister {
	return &schedulerLister{indexer: indexer}
}

// List lists all Schedulers in the indexer.
func (s *schedulerLister) List(selector labels.Selector) (ret []*v1.Scheduler, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Scheduler))
	})
	return ret, err
}

// Schedulers returns an object that can list and get Schedulers.
func (s *schedulerLister) Schedulers(namespace string) SchedulerNamespaceLister {
	return schedulerNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// SchedulerNamespaceLister helps list and get Schedulers.
type SchedulerNamespaceLister interface {
	// List lists all Schedulers in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.Scheduler, err error)
	// Get retrieves the Scheduler from the indexer for a given namespace and name.
	Get(name string) (*v1.Scheduler, error)
	SchedulerNamespaceListerExpansion
}

// schedulerNamespaceLister implements the SchedulerNamespaceLister
// interface.
type schedulerNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Schedulers in the indexer for a given namespace.
func (s schedulerNamespaceLister) List(selector labels.Selector) (ret []*v1.Scheduler, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Scheduler))
	})
	return ret, err
}

// Get retrieves the Scheduler from the indexer for a given namespace and name.
func (s schedulerNamespaceLister) Get(name string) (*v1.Scheduler, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("scheduler"), name)
	}
	return obj.(*v1.Scheduler), nil
}
