// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/jenkins-x/jx/pkg/apis/jenkins.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// PipelineStructureLister helps list PipelineStructures.
type PipelineStructureLister interface {
	// List lists all PipelineStructures in the indexer.
	List(selector labels.Selector) (ret []*v1.PipelineStructure, err error)
	// PipelineStructures returns an object that can list and get PipelineStructures.
	PipelineStructures(namespace string) PipelineStructureNamespaceLister
	PipelineStructureListerExpansion
}

// pipelineStructureLister implements the PipelineStructureLister interface.
type pipelineStructureLister struct {
	indexer cache.Indexer
}

// NewPipelineStructureLister returns a new PipelineStructureLister.
func NewPipelineStructureLister(indexer cache.Indexer) PipelineStructureLister {
	return &pipelineStructureLister{indexer: indexer}
}

// List lists all PipelineStructures in the indexer.
func (s *pipelineStructureLister) List(selector labels.Selector) (ret []*v1.PipelineStructure, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.PipelineStructure))
	})
	return ret, err
}

// PipelineStructures returns an object that can list and get PipelineStructures.
func (s *pipelineStructureLister) PipelineStructures(namespace string) PipelineStructureNamespaceLister {
	return pipelineStructureNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// PipelineStructureNamespaceLister helps list and get PipelineStructures.
type PipelineStructureNamespaceLister interface {
	// List lists all PipelineStructures in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.PipelineStructure, err error)
	// Get retrieves the PipelineStructure from the indexer for a given namespace and name.
	Get(name string) (*v1.PipelineStructure, error)
	PipelineStructureNamespaceListerExpansion
}

// pipelineStructureNamespaceLister implements the PipelineStructureNamespaceLister
// interface.
type pipelineStructureNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all PipelineStructures in the indexer for a given namespace.
func (s pipelineStructureNamespaceLister) List(selector labels.Selector) (ret []*v1.PipelineStructure, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.PipelineStructure))
	})
	return ret, err
}

// Get retrieves the PipelineStructure from the indexer for a given namespace and name.
func (s pipelineStructureNamespaceLister) Get(name string) (*v1.PipelineStructure, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("pipelinestructure"), name)
	}
	return obj.(*v1.PipelineStructure), nil
}
