// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/jenkins-x/jx/pkg/apis/jenkins.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// GitServiceLister helps list GitServices.
type GitServiceLister interface {
	// List lists all GitServices in the indexer.
	List(selector labels.Selector) (ret []*v1.GitService, err error)
	// GitServices returns an object that can list and get GitServices.
	GitServices(namespace string) GitServiceNamespaceLister
	GitServiceListerExpansion
}

// gitServiceLister implements the GitServiceLister interface.
type gitServiceLister struct {
	indexer cache.Indexer
}

// NewGitServiceLister returns a new GitServiceLister.
func NewGitServiceLister(indexer cache.Indexer) GitServiceLister {
	return &gitServiceLister{indexer: indexer}
}

// List lists all GitServices in the indexer.
func (s *gitServiceLister) List(selector labels.Selector) (ret []*v1.GitService, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.GitService))
	})
	return ret, err
}

// GitServices returns an object that can list and get GitServices.
func (s *gitServiceLister) GitServices(namespace string) GitServiceNamespaceLister {
	return gitServiceNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// GitServiceNamespaceLister helps list and get GitServices.
type GitServiceNamespaceLister interface {
	// List lists all GitServices in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.GitService, err error)
	// Get retrieves the GitService from the indexer for a given namespace and name.
	Get(name string) (*v1.GitService, error)
	GitServiceNamespaceListerExpansion
}

// gitServiceNamespaceLister implements the GitServiceNamespaceLister
// interface.
type gitServiceNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all GitServices in the indexer for a given namespace.
func (s gitServiceNamespaceLister) List(selector labels.Selector) (ret []*v1.GitService, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.GitService))
	})
	return ret, err
}

// Get retrieves the GitService from the indexer for a given namespace and name.
func (s gitServiceNamespaceLister) Get(name string) (*v1.GitService, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("gitservice"), name)
	}
	return obj.(*v1.GitService), nil
}
