// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/jenkins-x/jx/pkg/apis/jenkins.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// FactLister helps list Facts.
type FactLister interface {
	// List lists all Facts in the indexer.
	List(selector labels.Selector) (ret []*v1.Fact, err error)
	// Facts returns an object that can list and get Facts.
	Facts(namespace string) FactNamespaceLister
	FactListerExpansion
}

// factLister implements the FactLister interface.
type factLister struct {
	indexer cache.Indexer
}

// NewFactLister returns a new FactLister.
func NewFactLister(indexer cache.Indexer) FactLister {
	return &factLister{indexer: indexer}
}

// List lists all Facts in the indexer.
func (s *factLister) List(selector labels.Selector) (ret []*v1.Fact, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Fact))
	})
	return ret, err
}

// Facts returns an object that can list and get Facts.
func (s *factLister) Facts(namespace string) FactNamespaceLister {
	return factNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// FactNamespaceLister helps list and get Facts.
type FactNamespaceLister interface {
	// List lists all Facts in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.Fact, err error)
	// Get retrieves the Fact from the indexer for a given namespace and name.
	Get(name string) (*v1.Fact, error)
	FactNamespaceListerExpansion
}

// factNamespaceLister implements the FactNamespaceLister
// interface.
type factNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Facts in the indexer for a given namespace.
func (s factNamespaceLister) List(selector labels.Selector) (ret []*v1.Fact, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Fact))
	})
	return ret, err
}

// Get retrieves the Fact from the indexer for a given namespace and name.
func (s factNamespaceLister) Get(name string) (*v1.Fact, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("fact"), name)
	}
	return obj.(*v1.Fact), nil
}
