// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/jenkins-x/jx/pkg/apis/jenkins.io/v1"
	scheme "github.com/jenkins-x/jx/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// TeamsGetter has a method to return a TeamInterface.
// A group's client should implement this interface.
type TeamsGetter interface {
	Teams(namespace string) TeamInterface
}

// TeamInterface has methods to work with Team resources.
type TeamInterface interface {
	Create(*v1.Team) (*v1.Team, error)
	Update(*v1.Team) (*v1.Team, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.Team, error)
	List(opts metav1.ListOptions) (*v1.TeamList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.Team, err error)
	TeamExpansion
}

// teams implements TeamInterface
type teams struct {
	client rest.Interface
	ns     string
}

// newTeams returns a Teams
func newTeams(c *JenkinsV1Client, namespace string) *teams {
	return &teams{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the team, and returns the corresponding team object, and an error if there is any.
func (c *teams) Get(name string, options metav1.GetOptions) (result *v1.Team, err error) {
	result = &v1.Team{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("teams").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Teams that match those selectors.
func (c *teams) List(opts metav1.ListOptions) (result *v1.TeamList, err error) {
	result = &v1.TeamList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("teams").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested teams.
func (c *teams) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("teams").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a team and creates it.  Returns the server's representation of the team, and an error, if there is any.
func (c *teams) Create(team *v1.Team) (result *v1.Team, err error) {
	result = &v1.Team{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("teams").
		Body(team).
		Do().
		Into(result)
	return
}

// Update takes the representation of a team and updates it. Returns the server's representation of the team, and an error, if there is any.
func (c *teams) Update(team *v1.Team) (result *v1.Team, err error) {
	result = &v1.Team{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("teams").
		Name(team.Name).
		Body(team).
		Do().
		Into(result)
	return
}

// Delete takes name of the team and deletes it. Returns an error if one occurs.
func (c *teams) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("teams").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *teams) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("teams").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched team.
func (c *teams) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.Team, err error) {
	result = &v1.Team{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("teams").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
