// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/jenkins-x/jx/pkg/apis/jenkins.io/v1"
	scheme "github.com/jenkins-x/jx/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// PipelineStructuresGetter has a method to return a PipelineStructureInterface.
// A group's client should implement this interface.
type PipelineStructuresGetter interface {
	PipelineStructures(namespace string) PipelineStructureInterface
}

// PipelineStructureInterface has methods to work with PipelineStructure resources.
type PipelineStructureInterface interface {
	Create(*v1.PipelineStructure) (*v1.PipelineStructure, error)
	Update(*v1.PipelineStructure) (*v1.PipelineStructure, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.PipelineStructure, error)
	List(opts metav1.ListOptions) (*v1.PipelineStructureList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.PipelineStructure, err error)
	PipelineStructureExpansion
}

// pipelineStructures implements PipelineStructureInterface
type pipelineStructures struct {
	client rest.Interface
	ns     string
}

// newPipelineStructures returns a PipelineStructures
func newPipelineStructures(c *JenkinsV1Client, namespace string) *pipelineStructures {
	return &pipelineStructures{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the pipelineStructure, and returns the corresponding pipelineStructure object, and an error if there is any.
func (c *pipelineStructures) Get(name string, options metav1.GetOptions) (result *v1.PipelineStructure, err error) {
	result = &v1.PipelineStructure{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("pipelinestructures").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of PipelineStructures that match those selectors.
func (c *pipelineStructures) List(opts metav1.ListOptions) (result *v1.PipelineStructureList, err error) {
	result = &v1.PipelineStructureList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("pipelinestructures").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested pipelineStructures.
func (c *pipelineStructures) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("pipelinestructures").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a pipelineStructure and creates it.  Returns the server's representation of the pipelineStructure, and an error, if there is any.
func (c *pipelineStructures) Create(pipelineStructure *v1.PipelineStructure) (result *v1.PipelineStructure, err error) {
	result = &v1.PipelineStructure{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("pipelinestructures").
		Body(pipelineStructure).
		Do().
		Into(result)
	return
}

// Update takes the representation of a pipelineStructure and updates it. Returns the server's representation of the pipelineStructure, and an error, if there is any.
func (c *pipelineStructures) Update(pipelineStructure *v1.PipelineStructure) (result *v1.PipelineStructure, err error) {
	result = &v1.PipelineStructure{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("pipelinestructures").
		Name(pipelineStructure.Name).
		Body(pipelineStructure).
		Do().
		Into(result)
	return
}

// Delete takes name of the pipelineStructure and deletes it. Returns an error if one occurs.
func (c *pipelineStructures) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("pipelinestructures").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *pipelineStructures) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("pipelinestructures").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched pipelineStructure.
func (c *pipelineStructures) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.PipelineStructure, err error) {
	result = &v1.PipelineStructure{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("pipelinestructures").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
