# frozen_string_literal: true

# create_locale_types.rb
# Create locale_types.go from public locale list from API
#
# (C) nukosuke <nukosuke@lavabit.com>

require 'json'
require 'uri'
require 'net/http'
require 'erb'

uri = URI.parse('https://terraform-provider-zendesk.zendesk.com/api/v2/locales/public.json')
req = Net::HTTP::Get.new(uri)
res = Net::HTTP.start(uri.host, uri.port, use_ssl: true) do |http|
  http.request(req)
end

if res.is_a? Net::HTTPSuccess
  data = JSON.parse(res.body)
  puts ERB.new(DATA.read).result(binding)
else
  abort "failed to fetch from locale API: #{res.body.inspect}"
end

__END__
package zendesk

// DO NOT EDIT
// This file is generated by script/create_locale_types.rb
// 
// <%= data['count'] %> locales are supported

const (<% data['locales'].each_with_index do |locale, idx| %>
	// Locale<%= locale_key = locale['locale'].gsub('-', '').upcase %> <%= locale['presentation_name'] %>
	Locale<%= locale_key %> = <%= locale['id'] %><% end %>
)

var localeTypeText = map[int]string {<% data['locales'].each do |locale| %>
	// Locale<%= locale_key = locale['locale'].gsub('-', '').upcase %> <%= locale['presentation_name'] %>
	Locale<%= locale_key %>: "<%= locale['locale'] %>",<% end %>
}

// LocaleTypeText returns locale type text
func LocaleTypeText(loc int) string {
	return localeTypeText[loc]
}
