package testdata

// Basic is the simplest struct that can be used with Genji: No tags, no methods, no comments.
// This must not be generated by the generator.
type Basic struct {
	A    string
	B    int
	C, D int32
}

// basic is like Basic except that it is unexported.
type basic struct {
	A    []byte
	B    uint16
	C, D float32
}

// Pk is a struct that selects its own primary key.
// This must not be generated by the generator.
type Pk struct {
	A string
	B int64 `genji:"pk"`
}

// Indexed is a struct that declares an indexed fields.
// This must not be generated by the generator.
type Indexed struct {
	A string `genji:"index"`
	B int64  `genji:"index(unique)"`
	C int64
}

// MultipleTags is a struct that declares multiple indexed fields.
// This must not be generated by the generator.
type MultipleTags struct {
	A string `json:"a" genji:"pk"`
	B int64
	C float32
	D bool `json:"d" genji:"index"`
}
