/*
Copyright 2020 VMware

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"time"

	v1beta1 "github.com/projectcontour/contour/apis/contour/v1beta1"
	scheme "github.com/projectcontour/contour/apis/generated/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// IngressRoutesGetter has a method to return a IngressRouteInterface.
// A group's client should implement this interface.
type IngressRoutesGetter interface {
	IngressRoutes(namespace string) IngressRouteInterface
}

// IngressRouteInterface has methods to work with IngressRoute resources.
type IngressRouteInterface interface {
	Create(*v1beta1.IngressRoute) (*v1beta1.IngressRoute, error)
	Update(*v1beta1.IngressRoute) (*v1beta1.IngressRoute, error)
	UpdateStatus(*v1beta1.IngressRoute) (*v1beta1.IngressRoute, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1beta1.IngressRoute, error)
	List(opts v1.ListOptions) (*v1beta1.IngressRouteList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta1.IngressRoute, err error)
	IngressRouteExpansion
}

// ingressRoutes implements IngressRouteInterface
type ingressRoutes struct {
	client rest.Interface
	ns     string
}

// newIngressRoutes returns a IngressRoutes
func newIngressRoutes(c *ContourV1beta1Client, namespace string) *ingressRoutes {
	return &ingressRoutes{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the ingressRoute, and returns the corresponding ingressRoute object, and an error if there is any.
func (c *ingressRoutes) Get(name string, options v1.GetOptions) (result *v1beta1.IngressRoute, err error) {
	result = &v1beta1.IngressRoute{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("ingressroutes").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of IngressRoutes that match those selectors.
func (c *ingressRoutes) List(opts v1.ListOptions) (result *v1beta1.IngressRouteList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.IngressRouteList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("ingressroutes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ingressRoutes.
func (c *ingressRoutes) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("ingressroutes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a ingressRoute and creates it.  Returns the server's representation of the ingressRoute, and an error, if there is any.
func (c *ingressRoutes) Create(ingressRoute *v1beta1.IngressRoute) (result *v1beta1.IngressRoute, err error) {
	result = &v1beta1.IngressRoute{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("ingressroutes").
		Body(ingressRoute).
		Do().
		Into(result)
	return
}

// Update takes the representation of a ingressRoute and updates it. Returns the server's representation of the ingressRoute, and an error, if there is any.
func (c *ingressRoutes) Update(ingressRoute *v1beta1.IngressRoute) (result *v1beta1.IngressRoute, err error) {
	result = &v1beta1.IngressRoute{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("ingressroutes").
		Name(ingressRoute.Name).
		Body(ingressRoute).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *ingressRoutes) UpdateStatus(ingressRoute *v1beta1.IngressRoute) (result *v1beta1.IngressRoute, err error) {
	result = &v1beta1.IngressRoute{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("ingressroutes").
		Name(ingressRoute.Name).
		SubResource("status").
		Body(ingressRoute).
		Do().
		Into(result)
	return
}

// Delete takes name of the ingressRoute and deletes it. Returns an error if one occurs.
func (c *ingressRoutes) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("ingressroutes").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ingressRoutes) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("ingressroutes").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched ingressRoute.
func (c *ingressRoutes) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta1.IngressRoute, err error) {
	result = &v1beta1.IngressRoute{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("ingressroutes").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
