// Code generated by protoc-gen-go. DO NOT EDIT.
// source: commands.proto

package rpc // import "github.com/arduino/arduino-cli/rpc"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Configuration contains information to instantiate an Arduino Platform Service
type Configuration struct {
	// dataDir represents the current root of the arduino tree (defaulted to
	// `$HOME/.arduino15` on linux).
	DataDir string `protobuf:"bytes,1,opt,name=dataDir,proto3" json:"dataDir,omitempty"`
	// sketchbookDir represents the current root of the sketchbooks tree
	// (defaulted to `$HOME/Arduino`).
	SketchbookDir string `protobuf:"bytes,2,opt,name=sketchbookDir,proto3" json:"sketchbookDir,omitempty"`
	// ArduinoIDEDirectory is the directory of the Arduino IDE if the CLI runs
	// together with it.
	DownloadsDir string `protobuf:"bytes,3,opt,name=downloadsDir,proto3" json:"downloadsDir,omitempty"`
	// BoardManagerAdditionalUrls contains the additional URL for 3rd party
	// packages
	BoardManagerAdditionalUrls []string `protobuf:"bytes,4,rep,name=boardManagerAdditionalUrls,proto3" json:"boardManagerAdditionalUrls,omitempty"`
	XXX_NoUnkeyedLiteral       struct{} `json:"-"`
	XXX_unrecognized           []byte   `json:"-"`
	XXX_sizecache              int32    `json:"-"`
}

func (m *Configuration) Reset()         { *m = Configuration{} }
func (m *Configuration) String() string { return proto.CompactTextString(m) }
func (*Configuration) ProtoMessage()    {}
func (*Configuration) Descriptor() ([]byte, []int) {
	return fileDescriptor_commands_92dd81084d7f582d, []int{0}
}
func (m *Configuration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Configuration.Unmarshal(m, b)
}
func (m *Configuration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Configuration.Marshal(b, m, deterministic)
}
func (dst *Configuration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Configuration.Merge(dst, src)
}
func (m *Configuration) XXX_Size() int {
	return xxx_messageInfo_Configuration.Size(m)
}
func (m *Configuration) XXX_DiscardUnknown() {
	xxx_messageInfo_Configuration.DiscardUnknown(m)
}

var xxx_messageInfo_Configuration proto.InternalMessageInfo

func (m *Configuration) GetDataDir() string {
	if m != nil {
		return m.DataDir
	}
	return ""
}

func (m *Configuration) GetSketchbookDir() string {
	if m != nil {
		return m.SketchbookDir
	}
	return ""
}

func (m *Configuration) GetDownloadsDir() string {
	if m != nil {
		return m.DownloadsDir
	}
	return ""
}

func (m *Configuration) GetBoardManagerAdditionalUrls() []string {
	if m != nil {
		return m.BoardManagerAdditionalUrls
	}
	return nil
}

type InitReq struct {
	Configuration        *Configuration `protobuf:"bytes,1,opt,name=configuration,proto3" json:"configuration,omitempty"`
	LibraryManagerOnly   bool           `protobuf:"varint,2,opt,name=library_manager_only,json=libraryManagerOnly,proto3" json:"library_manager_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *InitReq) Reset()         { *m = InitReq{} }
func (m *InitReq) String() string { return proto.CompactTextString(m) }
func (*InitReq) ProtoMessage()    {}
func (*InitReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_commands_92dd81084d7f582d, []int{1}
}
func (m *InitReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InitReq.Unmarshal(m, b)
}
func (m *InitReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InitReq.Marshal(b, m, deterministic)
}
func (dst *InitReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InitReq.Merge(dst, src)
}
func (m *InitReq) XXX_Size() int {
	return xxx_messageInfo_InitReq.Size(m)
}
func (m *InitReq) XXX_DiscardUnknown() {
	xxx_messageInfo_InitReq.DiscardUnknown(m)
}

var xxx_messageInfo_InitReq proto.InternalMessageInfo

func (m *InitReq) GetConfiguration() *Configuration {
	if m != nil {
		return m.Configuration
	}
	return nil
}

func (m *InitReq) GetLibraryManagerOnly() bool {
	if m != nil {
		return m.LibraryManagerOnly
	}
	return false
}

type InitResp struct {
	Instance             *Instance         `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	PlatformsIndexErrors []string          `protobuf:"bytes,2,rep,name=platforms_index_errors,json=platformsIndexErrors,proto3" json:"platforms_index_errors,omitempty"`
	LibrariesIndexError  string            `protobuf:"bytes,3,opt,name=libraries_index_error,json=librariesIndexError,proto3" json:"libraries_index_error,omitempty"`
	DownloadProgress     *DownloadProgress `protobuf:"bytes,4,opt,name=download_progress,json=downloadProgress,proto3" json:"download_progress,omitempty"`
	TaskProgress         *TaskProgress     `protobuf:"bytes,5,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *InitResp) Reset()         { *m = InitResp{} }
func (m *InitResp) String() string { return proto.CompactTextString(m) }
func (*InitResp) ProtoMessage()    {}
func (*InitResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_commands_92dd81084d7f582d, []int{2}
}
func (m *InitResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InitResp.Unmarshal(m, b)
}
func (m *InitResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InitResp.Marshal(b, m, deterministic)
}
func (dst *InitResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InitResp.Merge(dst, src)
}
func (m *InitResp) XXX_Size() int {
	return xxx_messageInfo_InitResp.Size(m)
}
func (m *InitResp) XXX_DiscardUnknown() {
	xxx_messageInfo_InitResp.DiscardUnknown(m)
}

var xxx_messageInfo_InitResp proto.InternalMessageInfo

func (m *InitResp) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *InitResp) GetPlatformsIndexErrors() []string {
	if m != nil {
		return m.PlatformsIndexErrors
	}
	return nil
}

func (m *InitResp) GetLibrariesIndexError() string {
	if m != nil {
		return m.LibrariesIndexError
	}
	return ""
}

func (m *InitResp) GetDownloadProgress() *DownloadProgress {
	if m != nil {
		return m.DownloadProgress
	}
	return nil
}

func (m *InitResp) GetTaskProgress() *TaskProgress {
	if m != nil {
		return m.TaskProgress
	}
	return nil
}

type DestroyReq struct {
	Instance             *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *DestroyReq) Reset()         { *m = DestroyReq{} }
func (m *DestroyReq) String() string { return proto.CompactTextString(m) }
func (*DestroyReq) ProtoMessage()    {}
func (*DestroyReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_commands_92dd81084d7f582d, []int{3}
}
func (m *DestroyReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DestroyReq.Unmarshal(m, b)
}
func (m *DestroyReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DestroyReq.Marshal(b, m, deterministic)
}
func (dst *DestroyReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DestroyReq.Merge(dst, src)
}
func (m *DestroyReq) XXX_Size() int {
	return xxx_messageInfo_DestroyReq.Size(m)
}
func (m *DestroyReq) XXX_DiscardUnknown() {
	xxx_messageInfo_DestroyReq.DiscardUnknown(m)
}

var xxx_messageInfo_DestroyReq proto.InternalMessageInfo

func (m *DestroyReq) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

type DestroyResp struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DestroyResp) Reset()         { *m = DestroyResp{} }
func (m *DestroyResp) String() string { return proto.CompactTextString(m) }
func (*DestroyResp) ProtoMessage()    {}
func (*DestroyResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_commands_92dd81084d7f582d, []int{4}
}
func (m *DestroyResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DestroyResp.Unmarshal(m, b)
}
func (m *DestroyResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DestroyResp.Marshal(b, m, deterministic)
}
func (dst *DestroyResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DestroyResp.Merge(dst, src)
}
func (m *DestroyResp) XXX_Size() int {
	return xxx_messageInfo_DestroyResp.Size(m)
}
func (m *DestroyResp) XXX_DiscardUnknown() {
	xxx_messageInfo_DestroyResp.DiscardUnknown(m)
}

var xxx_messageInfo_DestroyResp proto.InternalMessageInfo

type RescanReq struct {
	Instance             *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *RescanReq) Reset()         { *m = RescanReq{} }
func (m *RescanReq) String() string { return proto.CompactTextString(m) }
func (*RescanReq) ProtoMessage()    {}
func (*RescanReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_commands_92dd81084d7f582d, []int{5}
}
func (m *RescanReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RescanReq.Unmarshal(m, b)
}
func (m *RescanReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RescanReq.Marshal(b, m, deterministic)
}
func (dst *RescanReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RescanReq.Merge(dst, src)
}
func (m *RescanReq) XXX_Size() int {
	return xxx_messageInfo_RescanReq.Size(m)
}
func (m *RescanReq) XXX_DiscardUnknown() {
	xxx_messageInfo_RescanReq.DiscardUnknown(m)
}

var xxx_messageInfo_RescanReq proto.InternalMessageInfo

func (m *RescanReq) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

type RescanResp struct {
	PlatformsIndexErrors []string `protobuf:"bytes,1,rep,name=platforms_index_errors,json=platformsIndexErrors,proto3" json:"platforms_index_errors,omitempty"`
	LibrariesIndexError  string   `protobuf:"bytes,2,opt,name=libraries_index_error,json=librariesIndexError,proto3" json:"libraries_index_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RescanResp) Reset()         { *m = RescanResp{} }
func (m *RescanResp) String() string { return proto.CompactTextString(m) }
func (*RescanResp) ProtoMessage()    {}
func (*RescanResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_commands_92dd81084d7f582d, []int{6}
}
func (m *RescanResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RescanResp.Unmarshal(m, b)
}
func (m *RescanResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RescanResp.Marshal(b, m, deterministic)
}
func (dst *RescanResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RescanResp.Merge(dst, src)
}
func (m *RescanResp) XXX_Size() int {
	return xxx_messageInfo_RescanResp.Size(m)
}
func (m *RescanResp) XXX_DiscardUnknown() {
	xxx_messageInfo_RescanResp.DiscardUnknown(m)
}

var xxx_messageInfo_RescanResp proto.InternalMessageInfo

func (m *RescanResp) GetPlatformsIndexErrors() []string {
	if m != nil {
		return m.PlatformsIndexErrors
	}
	return nil
}

func (m *RescanResp) GetLibrariesIndexError() string {
	if m != nil {
		return m.LibrariesIndexError
	}
	return ""
}

type UpdateIndexReq struct {
	Instance             *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UpdateIndexReq) Reset()         { *m = UpdateIndexReq{} }
func (m *UpdateIndexReq) String() string { return proto.CompactTextString(m) }
func (*UpdateIndexReq) ProtoMessage()    {}
func (*UpdateIndexReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_commands_92dd81084d7f582d, []int{7}
}
func (m *UpdateIndexReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateIndexReq.Unmarshal(m, b)
}
func (m *UpdateIndexReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateIndexReq.Marshal(b, m, deterministic)
}
func (dst *UpdateIndexReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateIndexReq.Merge(dst, src)
}
func (m *UpdateIndexReq) XXX_Size() int {
	return xxx_messageInfo_UpdateIndexReq.Size(m)
}
func (m *UpdateIndexReq) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateIndexReq.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateIndexReq proto.InternalMessageInfo

func (m *UpdateIndexReq) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

type UpdateIndexResp struct {
	DownloadProgress     *DownloadProgress `protobuf:"bytes,1,opt,name=download_progress,json=downloadProgress,proto3" json:"download_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateIndexResp) Reset()         { *m = UpdateIndexResp{} }
func (m *UpdateIndexResp) String() string { return proto.CompactTextString(m) }
func (*UpdateIndexResp) ProtoMessage()    {}
func (*UpdateIndexResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_commands_92dd81084d7f582d, []int{8}
}
func (m *UpdateIndexResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateIndexResp.Unmarshal(m, b)
}
func (m *UpdateIndexResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateIndexResp.Marshal(b, m, deterministic)
}
func (dst *UpdateIndexResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateIndexResp.Merge(dst, src)
}
func (m *UpdateIndexResp) XXX_Size() int {
	return xxx_messageInfo_UpdateIndexResp.Size(m)
}
func (m *UpdateIndexResp) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateIndexResp.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateIndexResp proto.InternalMessageInfo

func (m *UpdateIndexResp) GetDownloadProgress() *DownloadProgress {
	if m != nil {
		return m.DownloadProgress
	}
	return nil
}

type UpdateLibrariesIndexReq struct {
	Instance             *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UpdateLibrariesIndexReq) Reset()         { *m = UpdateLibrariesIndexReq{} }
func (m *UpdateLibrariesIndexReq) String() string { return proto.CompactTextString(m) }
func (*UpdateLibrariesIndexReq) ProtoMessage()    {}
func (*UpdateLibrariesIndexReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_commands_92dd81084d7f582d, []int{9}
}
func (m *UpdateLibrariesIndexReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateLibrariesIndexReq.Unmarshal(m, b)
}
func (m *UpdateLibrariesIndexReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateLibrariesIndexReq.Marshal(b, m, deterministic)
}
func (dst *UpdateLibrariesIndexReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateLibrariesIndexReq.Merge(dst, src)
}
func (m *UpdateLibrariesIndexReq) XXX_Size() int {
	return xxx_messageInfo_UpdateLibrariesIndexReq.Size(m)
}
func (m *UpdateLibrariesIndexReq) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateLibrariesIndexReq.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateLibrariesIndexReq proto.InternalMessageInfo

func (m *UpdateLibrariesIndexReq) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

type UpdateLibrariesIndexResp struct {
	DownloadProgress     *DownloadProgress `protobuf:"bytes,1,opt,name=download_progress,json=downloadProgress,proto3" json:"download_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateLibrariesIndexResp) Reset()         { *m = UpdateLibrariesIndexResp{} }
func (m *UpdateLibrariesIndexResp) String() string { return proto.CompactTextString(m) }
func (*UpdateLibrariesIndexResp) ProtoMessage()    {}
func (*UpdateLibrariesIndexResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_commands_92dd81084d7f582d, []int{10}
}
func (m *UpdateLibrariesIndexResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateLibrariesIndexResp.Unmarshal(m, b)
}
func (m *UpdateLibrariesIndexResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateLibrariesIndexResp.Marshal(b, m, deterministic)
}
func (dst *UpdateLibrariesIndexResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateLibrariesIndexResp.Merge(dst, src)
}
func (m *UpdateLibrariesIndexResp) XXX_Size() int {
	return xxx_messageInfo_UpdateLibrariesIndexResp.Size(m)
}
func (m *UpdateLibrariesIndexResp) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateLibrariesIndexResp.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateLibrariesIndexResp proto.InternalMessageInfo

func (m *UpdateLibrariesIndexResp) GetDownloadProgress() *DownloadProgress {
	if m != nil {
		return m.DownloadProgress
	}
	return nil
}

type VersionReq struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VersionReq) Reset()         { *m = VersionReq{} }
func (m *VersionReq) String() string { return proto.CompactTextString(m) }
func (*VersionReq) ProtoMessage()    {}
func (*VersionReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_commands_92dd81084d7f582d, []int{11}
}
func (m *VersionReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VersionReq.Unmarshal(m, b)
}
func (m *VersionReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VersionReq.Marshal(b, m, deterministic)
}
func (dst *VersionReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VersionReq.Merge(dst, src)
}
func (m *VersionReq) XXX_Size() int {
	return xxx_messageInfo_VersionReq.Size(m)
}
func (m *VersionReq) XXX_DiscardUnknown() {
	xxx_messageInfo_VersionReq.DiscardUnknown(m)
}

var xxx_messageInfo_VersionReq proto.InternalMessageInfo

type VersionResp struct {
	Version              string   `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VersionResp) Reset()         { *m = VersionResp{} }
func (m *VersionResp) String() string { return proto.CompactTextString(m) }
func (*VersionResp) ProtoMessage()    {}
func (*VersionResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_commands_92dd81084d7f582d, []int{12}
}
func (m *VersionResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VersionResp.Unmarshal(m, b)
}
func (m *VersionResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VersionResp.Marshal(b, m, deterministic)
}
func (dst *VersionResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VersionResp.Merge(dst, src)
}
func (m *VersionResp) XXX_Size() int {
	return xxx_messageInfo_VersionResp.Size(m)
}
func (m *VersionResp) XXX_DiscardUnknown() {
	xxx_messageInfo_VersionResp.DiscardUnknown(m)
}

var xxx_messageInfo_VersionResp proto.InternalMessageInfo

func (m *VersionResp) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func init() {
	proto.RegisterType((*Configuration)(nil), "cc.arduino.core.rpc.Configuration")
	proto.RegisterType((*InitReq)(nil), "cc.arduino.core.rpc.InitReq")
	proto.RegisterType((*InitResp)(nil), "cc.arduino.core.rpc.InitResp")
	proto.RegisterType((*DestroyReq)(nil), "cc.arduino.core.rpc.DestroyReq")
	proto.RegisterType((*DestroyResp)(nil), "cc.arduino.core.rpc.DestroyResp")
	proto.RegisterType((*RescanReq)(nil), "cc.arduino.core.rpc.RescanReq")
	proto.RegisterType((*RescanResp)(nil), "cc.arduino.core.rpc.RescanResp")
	proto.RegisterType((*UpdateIndexReq)(nil), "cc.arduino.core.rpc.UpdateIndexReq")
	proto.RegisterType((*UpdateIndexResp)(nil), "cc.arduino.core.rpc.UpdateIndexResp")
	proto.RegisterType((*UpdateLibrariesIndexReq)(nil), "cc.arduino.core.rpc.UpdateLibrariesIndexReq")
	proto.RegisterType((*UpdateLibrariesIndexResp)(nil), "cc.arduino.core.rpc.UpdateLibrariesIndexResp")
	proto.RegisterType((*VersionReq)(nil), "cc.arduino.core.rpc.VersionReq")
	proto.RegisterType((*VersionResp)(nil), "cc.arduino.core.rpc.VersionResp")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ArduinoCoreClient is the client API for ArduinoCore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ArduinoCoreClient interface {
	// Start a new instance of the Arduino Core Service
	Init(ctx context.Context, in *InitReq, opts ...grpc.CallOption) (ArduinoCore_InitClient, error)
	// Destroy an instance of the Arduino Core Service
	Destroy(ctx context.Context, in *DestroyReq, opts ...grpc.CallOption) (*DestroyResp, error)
	// Rescan instance of the Arduino Core Service
	Rescan(ctx context.Context, in *RescanReq, opts ...grpc.CallOption) (*RescanResp, error)
	// Update package index of the Arduino Core Service
	UpdateIndex(ctx context.Context, in *UpdateIndexReq, opts ...grpc.CallOption) (ArduinoCore_UpdateIndexClient, error)
	// Update libraries index
	UpdateLibrariesIndex(ctx context.Context, in *UpdateLibrariesIndexReq, opts ...grpc.CallOption) (ArduinoCore_UpdateLibrariesIndexClient, error)
	Version(ctx context.Context, in *VersionReq, opts ...grpc.CallOption) (*VersionResp, error)
	// Requests details about a board
	BoardDetails(ctx context.Context, in *BoardDetailsReq, opts ...grpc.CallOption) (*BoardDetailsResp, error)
	BoardAttach(ctx context.Context, in *BoardAttachReq, opts ...grpc.CallOption) (ArduinoCore_BoardAttachClient, error)
	BoardList(ctx context.Context, in *BoardListReq, opts ...grpc.CallOption) (*BoardListResp, error)
	BoardListAll(ctx context.Context, in *BoardListAllReq, opts ...grpc.CallOption) (*BoardListAllResp, error)
	Compile(ctx context.Context, in *CompileReq, opts ...grpc.CallOption) (ArduinoCore_CompileClient, error)
	PlatformInstall(ctx context.Context, in *PlatformInstallReq, opts ...grpc.CallOption) (ArduinoCore_PlatformInstallClient, error)
	PlatformDownload(ctx context.Context, in *PlatformDownloadReq, opts ...grpc.CallOption) (ArduinoCore_PlatformDownloadClient, error)
	PlatformUninstall(ctx context.Context, in *PlatformUninstallReq, opts ...grpc.CallOption) (ArduinoCore_PlatformUninstallClient, error)
	PlatformUpgrade(ctx context.Context, in *PlatformUpgradeReq, opts ...grpc.CallOption) (ArduinoCore_PlatformUpgradeClient, error)
	Upload(ctx context.Context, in *UploadReq, opts ...grpc.CallOption) (ArduinoCore_UploadClient, error)
	PlatformSearch(ctx context.Context, in *PlatformSearchReq, opts ...grpc.CallOption) (*PlatformSearchResp, error)
	PlatformList(ctx context.Context, in *PlatformListReq, opts ...grpc.CallOption) (*PlatformListResp, error)
	LibraryDownload(ctx context.Context, in *LibraryDownloadReq, opts ...grpc.CallOption) (ArduinoCore_LibraryDownloadClient, error)
	LibraryInstall(ctx context.Context, in *LibraryInstallReq, opts ...grpc.CallOption) (ArduinoCore_LibraryInstallClient, error)
	LibraryUninstall(ctx context.Context, in *LibraryUninstallReq, opts ...grpc.CallOption) (ArduinoCore_LibraryUninstallClient, error)
	LibraryUpgradeAll(ctx context.Context, in *LibraryUpgradeAllReq, opts ...grpc.CallOption) (ArduinoCore_LibraryUpgradeAllClient, error)
	LibrarySearch(ctx context.Context, in *LibrarySearchReq, opts ...grpc.CallOption) (*LibrarySearchResp, error)
	LibraryList(ctx context.Context, in *LibraryListReq, opts ...grpc.CallOption) (*LibraryListResp, error)
}

type arduinoCoreClient struct {
	cc *grpc.ClientConn
}

func NewArduinoCoreClient(cc *grpc.ClientConn) ArduinoCoreClient {
	return &arduinoCoreClient{cc}
}

func (c *arduinoCoreClient) Init(ctx context.Context, in *InitReq, opts ...grpc.CallOption) (ArduinoCore_InitClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[0], "/cc.arduino.core.rpc.ArduinoCore/Init", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreInitClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_InitClient interface {
	Recv() (*InitResp, error)
	grpc.ClientStream
}

type arduinoCoreInitClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreInitClient) Recv() (*InitResp, error) {
	m := new(InitResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) Destroy(ctx context.Context, in *DestroyReq, opts ...grpc.CallOption) (*DestroyResp, error) {
	out := new(DestroyResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.core.rpc.ArduinoCore/Destroy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) Rescan(ctx context.Context, in *RescanReq, opts ...grpc.CallOption) (*RescanResp, error) {
	out := new(RescanResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.core.rpc.ArduinoCore/Rescan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) UpdateIndex(ctx context.Context, in *UpdateIndexReq, opts ...grpc.CallOption) (ArduinoCore_UpdateIndexClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[1], "/cc.arduino.core.rpc.ArduinoCore/UpdateIndex", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreUpdateIndexClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_UpdateIndexClient interface {
	Recv() (*UpdateIndexResp, error)
	grpc.ClientStream
}

type arduinoCoreUpdateIndexClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreUpdateIndexClient) Recv() (*UpdateIndexResp, error) {
	m := new(UpdateIndexResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) UpdateLibrariesIndex(ctx context.Context, in *UpdateLibrariesIndexReq, opts ...grpc.CallOption) (ArduinoCore_UpdateLibrariesIndexClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[2], "/cc.arduino.core.rpc.ArduinoCore/UpdateLibrariesIndex", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreUpdateLibrariesIndexClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_UpdateLibrariesIndexClient interface {
	Recv() (*UpdateLibrariesIndexResp, error)
	grpc.ClientStream
}

type arduinoCoreUpdateLibrariesIndexClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreUpdateLibrariesIndexClient) Recv() (*UpdateLibrariesIndexResp, error) {
	m := new(UpdateLibrariesIndexResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) Version(ctx context.Context, in *VersionReq, opts ...grpc.CallOption) (*VersionResp, error) {
	out := new(VersionResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.core.rpc.ArduinoCore/Version", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) BoardDetails(ctx context.Context, in *BoardDetailsReq, opts ...grpc.CallOption) (*BoardDetailsResp, error) {
	out := new(BoardDetailsResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.core.rpc.ArduinoCore/BoardDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) BoardAttach(ctx context.Context, in *BoardAttachReq, opts ...grpc.CallOption) (ArduinoCore_BoardAttachClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[3], "/cc.arduino.core.rpc.ArduinoCore/BoardAttach", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreBoardAttachClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_BoardAttachClient interface {
	Recv() (*BoardAttachResp, error)
	grpc.ClientStream
}

type arduinoCoreBoardAttachClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreBoardAttachClient) Recv() (*BoardAttachResp, error) {
	m := new(BoardAttachResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) BoardList(ctx context.Context, in *BoardListReq, opts ...grpc.CallOption) (*BoardListResp, error) {
	out := new(BoardListResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.core.rpc.ArduinoCore/BoardList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) BoardListAll(ctx context.Context, in *BoardListAllReq, opts ...grpc.CallOption) (*BoardListAllResp, error) {
	out := new(BoardListAllResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.core.rpc.ArduinoCore/BoardListAll", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) Compile(ctx context.Context, in *CompileReq, opts ...grpc.CallOption) (ArduinoCore_CompileClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[4], "/cc.arduino.core.rpc.ArduinoCore/Compile", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreCompileClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_CompileClient interface {
	Recv() (*CompileResp, error)
	grpc.ClientStream
}

type arduinoCoreCompileClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreCompileClient) Recv() (*CompileResp, error) {
	m := new(CompileResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) PlatformInstall(ctx context.Context, in *PlatformInstallReq, opts ...grpc.CallOption) (ArduinoCore_PlatformInstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[5], "/cc.arduino.core.rpc.ArduinoCore/PlatformInstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCorePlatformInstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_PlatformInstallClient interface {
	Recv() (*PlatformInstallResp, error)
	grpc.ClientStream
}

type arduinoCorePlatformInstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCorePlatformInstallClient) Recv() (*PlatformInstallResp, error) {
	m := new(PlatformInstallResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) PlatformDownload(ctx context.Context, in *PlatformDownloadReq, opts ...grpc.CallOption) (ArduinoCore_PlatformDownloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[6], "/cc.arduino.core.rpc.ArduinoCore/PlatformDownload", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCorePlatformDownloadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_PlatformDownloadClient interface {
	Recv() (*PlatformDownloadResp, error)
	grpc.ClientStream
}

type arduinoCorePlatformDownloadClient struct {
	grpc.ClientStream
}

func (x *arduinoCorePlatformDownloadClient) Recv() (*PlatformDownloadResp, error) {
	m := new(PlatformDownloadResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) PlatformUninstall(ctx context.Context, in *PlatformUninstallReq, opts ...grpc.CallOption) (ArduinoCore_PlatformUninstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[7], "/cc.arduino.core.rpc.ArduinoCore/PlatformUninstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCorePlatformUninstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_PlatformUninstallClient interface {
	Recv() (*PlatformUninstallResp, error)
	grpc.ClientStream
}

type arduinoCorePlatformUninstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCorePlatformUninstallClient) Recv() (*PlatformUninstallResp, error) {
	m := new(PlatformUninstallResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) PlatformUpgrade(ctx context.Context, in *PlatformUpgradeReq, opts ...grpc.CallOption) (ArduinoCore_PlatformUpgradeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[8], "/cc.arduino.core.rpc.ArduinoCore/PlatformUpgrade", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCorePlatformUpgradeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_PlatformUpgradeClient interface {
	Recv() (*PlatformUpgradeResp, error)
	grpc.ClientStream
}

type arduinoCorePlatformUpgradeClient struct {
	grpc.ClientStream
}

func (x *arduinoCorePlatformUpgradeClient) Recv() (*PlatformUpgradeResp, error) {
	m := new(PlatformUpgradeResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) Upload(ctx context.Context, in *UploadReq, opts ...grpc.CallOption) (ArduinoCore_UploadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[9], "/cc.arduino.core.rpc.ArduinoCore/Upload", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreUploadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_UploadClient interface {
	Recv() (*UploadResp, error)
	grpc.ClientStream
}

type arduinoCoreUploadClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreUploadClient) Recv() (*UploadResp, error) {
	m := new(UploadResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) PlatformSearch(ctx context.Context, in *PlatformSearchReq, opts ...grpc.CallOption) (*PlatformSearchResp, error) {
	out := new(PlatformSearchResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.core.rpc.ArduinoCore/PlatformSearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) PlatformList(ctx context.Context, in *PlatformListReq, opts ...grpc.CallOption) (*PlatformListResp, error) {
	out := new(PlatformListResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.core.rpc.ArduinoCore/PlatformList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) LibraryDownload(ctx context.Context, in *LibraryDownloadReq, opts ...grpc.CallOption) (ArduinoCore_LibraryDownloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[10], "/cc.arduino.core.rpc.ArduinoCore/LibraryDownload", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreLibraryDownloadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_LibraryDownloadClient interface {
	Recv() (*LibraryDownloadResp, error)
	grpc.ClientStream
}

type arduinoCoreLibraryDownloadClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreLibraryDownloadClient) Recv() (*LibraryDownloadResp, error) {
	m := new(LibraryDownloadResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) LibraryInstall(ctx context.Context, in *LibraryInstallReq, opts ...grpc.CallOption) (ArduinoCore_LibraryInstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[11], "/cc.arduino.core.rpc.ArduinoCore/LibraryInstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreLibraryInstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_LibraryInstallClient interface {
	Recv() (*LibraryInstallResp, error)
	grpc.ClientStream
}

type arduinoCoreLibraryInstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreLibraryInstallClient) Recv() (*LibraryInstallResp, error) {
	m := new(LibraryInstallResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) LibraryUninstall(ctx context.Context, in *LibraryUninstallReq, opts ...grpc.CallOption) (ArduinoCore_LibraryUninstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[12], "/cc.arduino.core.rpc.ArduinoCore/LibraryUninstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreLibraryUninstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_LibraryUninstallClient interface {
	Recv() (*LibraryUninstallResp, error)
	grpc.ClientStream
}

type arduinoCoreLibraryUninstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreLibraryUninstallClient) Recv() (*LibraryUninstallResp, error) {
	m := new(LibraryUninstallResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) LibraryUpgradeAll(ctx context.Context, in *LibraryUpgradeAllReq, opts ...grpc.CallOption) (ArduinoCore_LibraryUpgradeAllClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[13], "/cc.arduino.core.rpc.ArduinoCore/LibraryUpgradeAll", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreLibraryUpgradeAllClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_LibraryUpgradeAllClient interface {
	Recv() (*LibraryUpgradeAllResp, error)
	grpc.ClientStream
}

type arduinoCoreLibraryUpgradeAllClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreLibraryUpgradeAllClient) Recv() (*LibraryUpgradeAllResp, error) {
	m := new(LibraryUpgradeAllResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) LibrarySearch(ctx context.Context, in *LibrarySearchReq, opts ...grpc.CallOption) (*LibrarySearchResp, error) {
	out := new(LibrarySearchResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.core.rpc.ArduinoCore/LibrarySearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) LibraryList(ctx context.Context, in *LibraryListReq, opts ...grpc.CallOption) (*LibraryListResp, error) {
	out := new(LibraryListResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.core.rpc.ArduinoCore/LibraryList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ArduinoCoreServer is the server API for ArduinoCore service.
type ArduinoCoreServer interface {
	// Start a new instance of the Arduino Core Service
	Init(*InitReq, ArduinoCore_InitServer) error
	// Destroy an instance of the Arduino Core Service
	Destroy(context.Context, *DestroyReq) (*DestroyResp, error)
	// Rescan instance of the Arduino Core Service
	Rescan(context.Context, *RescanReq) (*RescanResp, error)
	// Update package index of the Arduino Core Service
	UpdateIndex(*UpdateIndexReq, ArduinoCore_UpdateIndexServer) error
	// Update libraries index
	UpdateLibrariesIndex(*UpdateLibrariesIndexReq, ArduinoCore_UpdateLibrariesIndexServer) error
	Version(context.Context, *VersionReq) (*VersionResp, error)
	// Requests details about a board
	BoardDetails(context.Context, *BoardDetailsReq) (*BoardDetailsResp, error)
	BoardAttach(*BoardAttachReq, ArduinoCore_BoardAttachServer) error
	BoardList(context.Context, *BoardListReq) (*BoardListResp, error)
	BoardListAll(context.Context, *BoardListAllReq) (*BoardListAllResp, error)
	Compile(*CompileReq, ArduinoCore_CompileServer) error
	PlatformInstall(*PlatformInstallReq, ArduinoCore_PlatformInstallServer) error
	PlatformDownload(*PlatformDownloadReq, ArduinoCore_PlatformDownloadServer) error
	PlatformUninstall(*PlatformUninstallReq, ArduinoCore_PlatformUninstallServer) error
	PlatformUpgrade(*PlatformUpgradeReq, ArduinoCore_PlatformUpgradeServer) error
	Upload(*UploadReq, ArduinoCore_UploadServer) error
	PlatformSearch(context.Context, *PlatformSearchReq) (*PlatformSearchResp, error)
	PlatformList(context.Context, *PlatformListReq) (*PlatformListResp, error)
	LibraryDownload(*LibraryDownloadReq, ArduinoCore_LibraryDownloadServer) error
	LibraryInstall(*LibraryInstallReq, ArduinoCore_LibraryInstallServer) error
	LibraryUninstall(*LibraryUninstallReq, ArduinoCore_LibraryUninstallServer) error
	LibraryUpgradeAll(*LibraryUpgradeAllReq, ArduinoCore_LibraryUpgradeAllServer) error
	LibrarySearch(context.Context, *LibrarySearchReq) (*LibrarySearchResp, error)
	LibraryList(context.Context, *LibraryListReq) (*LibraryListResp, error)
}

func RegisterArduinoCoreServer(s *grpc.Server, srv ArduinoCoreServer) {
	s.RegisterService(&_ArduinoCore_serviceDesc, srv)
}

func _ArduinoCore_Init_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(InitReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).Init(m, &arduinoCoreInitServer{stream})
}

type ArduinoCore_InitServer interface {
	Send(*InitResp) error
	grpc.ServerStream
}

type arduinoCoreInitServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreInitServer) Send(m *InitResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_Destroy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestroyReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).Destroy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.core.rpc.ArduinoCore/Destroy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).Destroy(ctx, req.(*DestroyReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_Rescan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RescanReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).Rescan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.core.rpc.ArduinoCore/Rescan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).Rescan(ctx, req.(*RescanReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_UpdateIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpdateIndexReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).UpdateIndex(m, &arduinoCoreUpdateIndexServer{stream})
}

type ArduinoCore_UpdateIndexServer interface {
	Send(*UpdateIndexResp) error
	grpc.ServerStream
}

type arduinoCoreUpdateIndexServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreUpdateIndexServer) Send(m *UpdateIndexResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_UpdateLibrariesIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpdateLibrariesIndexReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).UpdateLibrariesIndex(m, &arduinoCoreUpdateLibrariesIndexServer{stream})
}

type ArduinoCore_UpdateLibrariesIndexServer interface {
	Send(*UpdateLibrariesIndexResp) error
	grpc.ServerStream
}

type arduinoCoreUpdateLibrariesIndexServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreUpdateLibrariesIndexServer) Send(m *UpdateLibrariesIndexResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_Version_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VersionReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).Version(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.core.rpc.ArduinoCore/Version",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).Version(ctx, req.(*VersionReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_BoardDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardDetailsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).BoardDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.core.rpc.ArduinoCore/BoardDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).BoardDetails(ctx, req.(*BoardDetailsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_BoardAttach_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BoardAttachReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).BoardAttach(m, &arduinoCoreBoardAttachServer{stream})
}

type ArduinoCore_BoardAttachServer interface {
	Send(*BoardAttachResp) error
	grpc.ServerStream
}

type arduinoCoreBoardAttachServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreBoardAttachServer) Send(m *BoardAttachResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_BoardList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardListReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).BoardList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.core.rpc.ArduinoCore/BoardList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).BoardList(ctx, req.(*BoardListReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_BoardListAll_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardListAllReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).BoardListAll(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.core.rpc.ArduinoCore/BoardListAll",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).BoardListAll(ctx, req.(*BoardListAllReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_Compile_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CompileReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).Compile(m, &arduinoCoreCompileServer{stream})
}

type ArduinoCore_CompileServer interface {
	Send(*CompileResp) error
	grpc.ServerStream
}

type arduinoCoreCompileServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreCompileServer) Send(m *CompileResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_PlatformInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformInstallReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).PlatformInstall(m, &arduinoCorePlatformInstallServer{stream})
}

type ArduinoCore_PlatformInstallServer interface {
	Send(*PlatformInstallResp) error
	grpc.ServerStream
}

type arduinoCorePlatformInstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCorePlatformInstallServer) Send(m *PlatformInstallResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_PlatformDownload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformDownloadReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).PlatformDownload(m, &arduinoCorePlatformDownloadServer{stream})
}

type ArduinoCore_PlatformDownloadServer interface {
	Send(*PlatformDownloadResp) error
	grpc.ServerStream
}

type arduinoCorePlatformDownloadServer struct {
	grpc.ServerStream
}

func (x *arduinoCorePlatformDownloadServer) Send(m *PlatformDownloadResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_PlatformUninstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformUninstallReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).PlatformUninstall(m, &arduinoCorePlatformUninstallServer{stream})
}

type ArduinoCore_PlatformUninstallServer interface {
	Send(*PlatformUninstallResp) error
	grpc.ServerStream
}

type arduinoCorePlatformUninstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCorePlatformUninstallServer) Send(m *PlatformUninstallResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_PlatformUpgrade_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformUpgradeReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).PlatformUpgrade(m, &arduinoCorePlatformUpgradeServer{stream})
}

type ArduinoCore_PlatformUpgradeServer interface {
	Send(*PlatformUpgradeResp) error
	grpc.ServerStream
}

type arduinoCorePlatformUpgradeServer struct {
	grpc.ServerStream
}

func (x *arduinoCorePlatformUpgradeServer) Send(m *PlatformUpgradeResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_Upload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UploadReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).Upload(m, &arduinoCoreUploadServer{stream})
}

type ArduinoCore_UploadServer interface {
	Send(*UploadResp) error
	grpc.ServerStream
}

type arduinoCoreUploadServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreUploadServer) Send(m *UploadResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_PlatformSearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlatformSearchReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).PlatformSearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.core.rpc.ArduinoCore/PlatformSearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).PlatformSearch(ctx, req.(*PlatformSearchReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_PlatformList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlatformListReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).PlatformList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.core.rpc.ArduinoCore/PlatformList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).PlatformList(ctx, req.(*PlatformListReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_LibraryDownload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryDownloadReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).LibraryDownload(m, &arduinoCoreLibraryDownloadServer{stream})
}

type ArduinoCore_LibraryDownloadServer interface {
	Send(*LibraryDownloadResp) error
	grpc.ServerStream
}

type arduinoCoreLibraryDownloadServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreLibraryDownloadServer) Send(m *LibraryDownloadResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_LibraryInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryInstallReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).LibraryInstall(m, &arduinoCoreLibraryInstallServer{stream})
}

type ArduinoCore_LibraryInstallServer interface {
	Send(*LibraryInstallResp) error
	grpc.ServerStream
}

type arduinoCoreLibraryInstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreLibraryInstallServer) Send(m *LibraryInstallResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_LibraryUninstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryUninstallReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).LibraryUninstall(m, &arduinoCoreLibraryUninstallServer{stream})
}

type ArduinoCore_LibraryUninstallServer interface {
	Send(*LibraryUninstallResp) error
	grpc.ServerStream
}

type arduinoCoreLibraryUninstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreLibraryUninstallServer) Send(m *LibraryUninstallResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_LibraryUpgradeAll_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryUpgradeAllReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).LibraryUpgradeAll(m, &arduinoCoreLibraryUpgradeAllServer{stream})
}

type ArduinoCore_LibraryUpgradeAllServer interface {
	Send(*LibraryUpgradeAllResp) error
	grpc.ServerStream
}

type arduinoCoreLibraryUpgradeAllServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreLibraryUpgradeAllServer) Send(m *LibraryUpgradeAllResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_LibrarySearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibrarySearchReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).LibrarySearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.core.rpc.ArduinoCore/LibrarySearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).LibrarySearch(ctx, req.(*LibrarySearchReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_LibraryList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibraryListReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).LibraryList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.core.rpc.ArduinoCore/LibraryList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).LibraryList(ctx, req.(*LibraryListReq))
	}
	return interceptor(ctx, in, info, handler)
}

var _ArduinoCore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cc.arduino.core.rpc.ArduinoCore",
	HandlerType: (*ArduinoCoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Destroy",
			Handler:    _ArduinoCore_Destroy_Handler,
		},
		{
			MethodName: "Rescan",
			Handler:    _ArduinoCore_Rescan_Handler,
		},
		{
			MethodName: "Version",
			Handler:    _ArduinoCore_Version_Handler,
		},
		{
			MethodName: "BoardDetails",
			Handler:    _ArduinoCore_BoardDetails_Handler,
		},
		{
			MethodName: "BoardList",
			Handler:    _ArduinoCore_BoardList_Handler,
		},
		{
			MethodName: "BoardListAll",
			Handler:    _ArduinoCore_BoardListAll_Handler,
		},
		{
			MethodName: "PlatformSearch",
			Handler:    _ArduinoCore_PlatformSearch_Handler,
		},
		{
			MethodName: "PlatformList",
			Handler:    _ArduinoCore_PlatformList_Handler,
		},
		{
			MethodName: "LibrarySearch",
			Handler:    _ArduinoCore_LibrarySearch_Handler,
		},
		{
			MethodName: "LibraryList",
			Handler:    _ArduinoCore_LibraryList_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Init",
			Handler:       _ArduinoCore_Init_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateIndex",
			Handler:       _ArduinoCore_UpdateIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateLibrariesIndex",
			Handler:       _ArduinoCore_UpdateLibrariesIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BoardAttach",
			Handler:       _ArduinoCore_BoardAttach_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Compile",
			Handler:       _ArduinoCore_Compile_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformInstall",
			Handler:       _ArduinoCore_PlatformInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformDownload",
			Handler:       _ArduinoCore_PlatformDownload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformUninstall",
			Handler:       _ArduinoCore_PlatformUninstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformUpgrade",
			Handler:       _ArduinoCore_PlatformUpgrade_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Upload",
			Handler:       _ArduinoCore_Upload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryDownload",
			Handler:       _ArduinoCore_LibraryDownload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryInstall",
			Handler:       _ArduinoCore_LibraryInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryUninstall",
			Handler:       _ArduinoCore_LibraryUninstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryUpgradeAll",
			Handler:       _ArduinoCore_LibraryUpgradeAll_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "commands.proto",
}

func init() { proto.RegisterFile("commands.proto", fileDescriptor_commands_92dd81084d7f582d) }

var fileDescriptor_commands_92dd81084d7f582d = []byte{
	// 992 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xb4, 0x97, 0xdd, 0x72, 0xdb, 0x44,
	0x14, 0x80, 0x71, 0x5a, 0x9a, 0xe4, 0xd8, 0x4e, 0x9b, 0x6d, 0x80, 0x8c, 0x86, 0xd2, 0x54, 0x75,
	0x92, 0x96, 0xa1, 0x6e, 0x27, 0x70, 0xc3, 0x0d, 0x33, 0x6e, 0x42, 0x4b, 0xa6, 0x05, 0x3a, 0xa2,
	0x66, 0x98, 0xc2, 0xe0, 0x59, 0x4b, 0x1b, 0x67, 0x27, 0xb2, 0x56, 0xdd, 0x55, 0x5a, 0xf2, 0x00,
	0x3c, 0x11, 0x8f, 0xc1, 0x9b, 0xf0, 0x14, 0xec, 0xaf, 0x6c, 0x25, 0x92, 0x2c, 0x92, 0xe1, 0xca,
	0xde, 0x3d, 0xdf, 0xf9, 0xd9, 0xf3, 0x17, 0x07, 0xd6, 0x42, 0x36, 0x9d, 0xe2, 0x24, 0x12, 0xfd,
	0x94, 0xb3, 0x8c, 0xa1, 0xdb, 0x61, 0xd8, 0xc7, 0x3c, 0x3a, 0xa5, 0x09, 0xeb, 0x87, 0x8c, 0x93,
	0x3e, 0x4f, 0x43, 0xaf, 0xa3, 0x20, 0x96, 0x18, 0xc4, 0x6b, 0x8f, 0x99, 0x24, 0xec, 0xa1, 0x2b,
	0x45, 0x29, 0x8d, 0x89, 0x3d, 0x82, 0xd6, 0x31, 0xdf, 0x3b, 0xa7, 0x69, 0xcc, 0xb0, 0x03, 0x57,
	0x63, 0x3a, 0x36, 0x5f, 0xfd, 0xbf, 0x5a, 0xd0, 0xdd, 0x67, 0xc9, 0x11, 0x9d, 0x9c, 0x72, 0x9c,
	0x51, 0x96, 0xa0, 0x4d, 0x58, 0x8e, 0x70, 0x86, 0x0f, 0x28, 0xdf, 0x6c, 0x6d, 0xb5, 0x1e, 0xac,
	0x06, 0xee, 0x88, 0x7a, 0xd0, 0x15, 0x27, 0x24, 0x0b, 0x8f, 0xc7, 0x8c, 0x9d, 0x28, 0xf9, 0x92,
	0x96, 0x17, 0x2f, 0x91, 0x0f, 0x9d, 0x88, 0xbd, 0x4f, 0x94, 0x3b, 0xa1, 0xa0, 0x6b, 0x1a, 0x2a,
	0xdc, 0xa1, 0x6f, 0xc0, 0xd3, 0x81, 0x7f, 0x8f, 0x13, 0x3c, 0x21, 0x7c, 0x10, 0x45, 0x54, 0xf9,
	0xc6, 0xf1, 0x90, 0xc7, 0x62, 0xf3, 0xfa, 0xd6, 0x35, 0xa9, 0x51, 0x43, 0xf8, 0x7f, 0xb6, 0x60,
	0xf9, 0x30, 0xa1, 0x59, 0x40, 0xde, 0xa2, 0xef, 0x40, 0xbe, 0x7b, 0xee, 0x01, 0x3a, 0xea, 0xf6,
	0x9e, 0xdf, 0x2f, 0xc9, 0x5e, 0xbf, 0xf0, 0xd4, 0xa0, 0xa8, 0x88, 0x9e, 0xc0, 0x86, 0x4c, 0x0c,
	0xc7, 0xfc, 0x6c, 0x34, 0x35, 0x6e, 0x47, 0x2c, 0x89, 0xcf, 0xf4, 0x33, 0x57, 0x02, 0x64, 0x65,
	0x36, 0xa2, 0x1f, 0xa5, 0xc4, 0xff, 0x7b, 0x09, 0x56, 0x4c, 0x1c, 0x22, 0x45, 0x5f, 0xc3, 0x0a,
	0x4d, 0x44, 0x86, 0x93, 0x90, 0xd8, 0x18, 0xee, 0x94, 0xc6, 0x70, 0x68, 0xa1, 0x20, 0xc7, 0xd1,
	0x57, 0xf0, 0x71, 0x1a, 0xe3, 0xec, 0x88, 0xf1, 0xa9, 0x18, 0xd1, 0x24, 0x22, 0x7f, 0x8c, 0x08,
	0xe7, 0x8c, 0x0b, 0xe9, 0x5b, 0xe5, 0x62, 0x23, 0x97, 0x1e, 0x2a, 0xe1, 0xb7, 0x5a, 0x86, 0xf6,
	0xe0, 0x23, 0x13, 0x13, 0x25, 0x05, 0x2d, 0x9b, 0xf2, 0xdb, 0xb9, 0x70, 0xa6, 0x84, 0x02, 0x58,
	0x77, 0x95, 0x18, 0xc9, 0x0e, 0x98, 0x70, 0x22, 0x54, 0xc2, 0x55, 0xb4, 0xdb, 0xa5, 0xd1, 0x1e,
	0x58, 0xfa, 0x95, 0x85, 0x83, 0x5b, 0xd1, 0xb9, 0x1b, 0xf4, 0x0c, 0xba, 0x19, 0x16, 0x27, 0x33,
	0x7b, 0x1f, 0x6a, 0x7b, 0xf7, 0x4a, 0xed, 0xbd, 0x96, 0x64, 0x6e, 0xab, 0x93, 0xcd, 0x9d, 0xfc,
	0xe7, 0x00, 0x07, 0x44, 0x64, 0x9c, 0x9d, 0xa9, 0xba, 0x5e, 0x3e, 0x9d, 0x7e, 0x17, 0xda, 0xb9,
	0x21, 0x91, 0xfa, 0xcf, 0x60, 0x55, 0x7e, 0x86, 0x38, 0xb9, 0xa2, 0xd9, 0x77, 0x00, 0xce, 0x8e,
	0x2c, 0x77, 0x75, 0xcd, 0x5a, 0x97, 0xa9, 0xd9, 0x52, 0x65, 0xcd, 0xfc, 0x17, 0xb0, 0x36, 0x4c,
	0xe5, 0x10, 0x12, 0x7d, 0x77, 0xc5, 0x47, 0x10, 0xb8, 0x59, 0x30, 0x26, 0x5f, 0x52, 0xda, 0x13,
	0xad, 0x2b, 0xf5, 0x84, 0xff, 0x1a, 0x3e, 0x31, 0x6e, 0x5e, 0x16, 0x1e, 0x74, 0xc5, 0xe0, 0x13,
	0xd8, 0x2c, 0xb7, 0xfa, 0x3f, 0xbd, 0xa2, 0x03, 0xf0, 0x33, 0xe1, 0x42, 0xed, 0x0a, 0xf2, 0xd6,
	0xdf, 0x85, 0x76, 0x7e, 0x92, 0x0e, 0xe5, 0xa2, 0x7c, 0x67, 0x8e, 0x6e, 0x51, 0xda, 0xe3, 0xde,
	0x3f, 0xeb, 0xd0, 0x1e, 0x18, 0x77, 0xfb, 0xd2, 0x1b, 0x7a, 0x0e, 0xd7, 0xd5, 0x96, 0x40, 0x9f,
	0x56, 0xbc, 0x53, 0x2f, 0x32, 0xef, 0x4e, 0x8d, 0x54, 0x76, 0xf1, 0x07, 0x4f, 0x5a, 0xe8, 0x07,
	0x58, 0xb6, 0x8d, 0x8d, 0xee, 0x96, 0xbf, 0x29, 0x9f, 0x1f, 0x6f, 0xab, 0x1e, 0x50, 0x16, 0xd1,
	0x0b, 0xb8, 0x61, 0x3a, 0x1a, 0x7d, 0x56, 0x4a, 0xe7, 0x63, 0xe3, 0xdd, 0xad, 0x95, 0x6b, 0x63,
	0xbf, 0x41, 0x7b, 0xae, 0xb3, 0xd0, 0xfd, 0x52, 0x8d, 0x62, 0x23, 0x7b, 0xbd, 0xc5, 0x90, 0x7d,
	0xfa, 0x7b, 0xd8, 0x28, 0x2b, 0x3d, 0xfa, 0xa2, 0xc6, 0xc2, 0x85, 0xde, 0xf3, 0x1e, 0xfd, 0x07,
	0x7a, 0x96, 0x73, 0x5b, 0xf5, 0x8a, 0x9c, 0xcf, 0x3a, 0xa4, 0x22, 0xe7, 0x73, 0x4d, 0x23, 0xd3,
	0xf4, 0x2b, 0x74, 0x9e, 0xaa, 0xbf, 0x6c, 0x07, 0x24, 0xc3, 0x34, 0x16, 0xa8, 0x3c, 0x05, 0xf3,
	0x88, 0xb2, 0xbc, 0xdd, 0x80, 0x92, 0x3d, 0xf9, 0x06, 0xda, 0xfa, 0x6e, 0x90, 0x65, 0x38, 0x3c,
	0xae, 0xa8, 0xc1, 0x1c, 0x51, 0x5d, 0x83, 0x02, 0x24, 0x52, 0x99, 0x88, 0x00, 0x56, 0xf5, 0xe5,
	0x4b, 0x2a, 0x32, 0x74, 0xaf, 0x5a, 0x49, 0xc9, 0x95, 0x5d, 0x7f, 0x11, 0x22, 0xe3, 0x75, 0xc9,
	0x50, 0x17, 0x83, 0x38, 0xae, 0x4b, 0x86, 0x45, 0x16, 0x24, 0x23, 0xa7, 0xa4, 0x71, 0x59, 0xb9,
	0x7d, 0xf3, 0x8b, 0xa8, 0xa2, 0x72, 0x56, 0x5a, 0x5d, 0xb9, 0x1c, 0xd0, 0x09, 0x38, 0x82, 0x9b,
	0xaf, 0xec, 0x4e, 0xd7, 0xbb, 0x49, 0xc6, 0xbb, 0x5b, 0xaa, 0x76, 0x8e, 0x52, 0xf6, 0x1f, 0x34,
	0x03, 0xb5, 0x1f, 0x0a, 0xb7, 0x9c, 0xc0, 0xed, 0x28, 0x54, 0xaf, 0xef, 0x30, 0xe5, 0xe9, 0x61,
	0x43, 0x52, 0xbb, 0x8a, 0x61, 0xdd, 0x49, 0x86, 0x09, 0xb5, 0x8f, 0xaa, 0xb7, 0x90, 0x73, 0xca,
	0xd9, 0xe7, 0x4d, 0xd1, 0xf3, 0x09, 0x1c, 0xa6, 0x13, 0x8e, 0x23, 0xb2, 0x20, 0x81, 0x96, 0x5a,
	0x9c, 0xc0, 0x1c, 0xd4, 0x7e, 0xe4, 0x5a, 0x1b, 0xea, 0xdf, 0xbb, 0x15, 0x6b, 0xcd, 0x08, 0xab,
	0xd7, 0x9a, 0x93, 0x6b, 0x63, 0x18, 0xd6, 0x9c, 0x97, 0x9f, 0x08, 0xe6, 0x72, 0xaa, 0x76, 0x6a,
	0x43, 0x31, 0x90, 0x32, 0xbe, 0xdb, 0x88, 0x33, 0x53, 0xe0, 0x6e, 0xf5, 0x70, 0xf5, 0x6a, 0x15,
	0xdd, 0x7c, 0x6d, 0x37, 0xa0, 0xa4, 0x71, 0x99, 0x74, 0xb3, 0xd9, 0xce, 0xf2, 0x66, 0x2a, 0x0f,
	0xec, 0x1c, 0x55, 0x9d, 0xf4, 0x0b, 0xa0, 0xce, 0x53, 0x08, 0x6b, 0x56, 0xe0, 0x86, 0x63, 0xa7,
	0x4e, 0x7b, 0x6e, 0x36, 0x76, 0x1b, 0x71, 0x6e, 0x34, 0xec, 0xfd, 0xac, 0x5d, 0x6b, 0x83, 0x2c,
	0x74, 0xeb, 0xc3, 0x86, 0xa4, 0x1b, 0x0d, 0x27, 0x31, 0xcd, 0x35, 0xa8, 0x1c, 0x8d, 0x0b, 0x5c,
	0xf5, 0x68, 0x94, 0xa0, 0xda, 0xdb, 0xef, 0xd0, 0xb5, 0x22, 0xdb, 0x64, 0xdb, 0x75, 0xea, 0xb3,
	0x1e, 0xdb, 0x69, 0x82, 0xc9, 0x2e, 0xf8, 0x05, 0xda, 0xf6, 0x52, 0x77, 0xd8, 0xfd, 0x3a, 0x35,
	0xd7, 0x60, 0xbd, 0xc5, 0x90, 0x48, 0x9f, 0xf6, 0xde, 0xf8, 0x13, 0x9a, 0x1d, 0x9f, 0x8e, 0x25,
	0x32, 0x7d, 0x6c, 0x71, 0xf7, 0xf9, 0x28, 0x8c, 0xe9, 0x63, 0xa9, 0x35, 0xbe, 0xa1, 0xff, 0xdd,
	0xfc, 0xf2, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa3, 0xcb, 0xac, 0x65, 0xe4, 0x0e, 0x00, 0x00,
}
